/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.isafe;

import com.equitysoft.isafe.ColorPanel;
import com.equitysoft.isafe.DatePanel;
import com.equitysoft.isafe.DirFinder;
import com.equitysoft.isafe.Dummy;
import com.equitysoft.isafe.ESChooser;
import com.equitysoft.isafe.ESUtils;
import com.equitysoft.isafe.ESZap;
import com.equitysoft.isafe.FileFinder;
import com.equitysoft.isafe.FileManager;
import com.equitysoft.isafe.ISLib;
import com.equitysoft.isafe.ImageLook;
import com.equitysoft.isafe.LayoutFile;
import com.equitysoft.isafe.LibButton;
import com.equitysoft.isafe.MultiOption;
import com.equitysoft.isafe.PositionBox;
import com.equitysoft.isafe.Prefs;
import com.equitysoft.isafe.SysProps;
import com.equitysoft.isafe.TextOption;
import com.equitysoft.isafe.URLBox;
import com.equitysoft.isafe.VerticalLayout;
import com.equitysoft.isafe.YesNo;
import com.equitysoft.isafe.YesNoListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class EditPrefs
extends JPanel {
    static final int NO_FILE = 0;
    static final int MANY_FILES = 1;
    static final int ONE_FILE = 2;
    static JRadioButton checkid;
    static JRadioButton usepass;
    static JRadioButton overlay;
    static JTextField id;
    static JTextField denied;
    static JTextField expired;
    static JTextField reldir;
    static JTextField skelpath;
    static JTextField author;
    static JTextField version;
    static JTextField pw;
    static JTextField olpath;
    static YesNo center;
    static YesNo clipboard;
    static YesNo relative;
    static YesNo skeleton;
    static YesNo suffix;
    static DatePanel dp;
    static DatePanel pdp;
    static URLBox url;
    static ColorPanel pagecol;
    static PositionBox pb;
    static File PWORDS;
    static ImageLook il;
    static Overlay ohandle;
    static PW phandle;
    static File ODIR;
    static Overlay olay;
    static Origin origin;
    static MultiOption html;
    static TextOption to;

    EditPrefs() {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Applet settings"));
        this.setLayout(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setFont(ISLib.MSG_FONT);
        this.add((Component)jTabbedPane, "Center");
        olay = new Overlay();
        jTabbedPane.addTab("Image overlay", olay);
        to = new TextOption();
        jTabbedPane.add("Text overlay", to);
        origin = new Origin();
        jTabbedPane.addTab("Origin", origin);
        jTabbedPane.addTab("HTML", new LastBox());
        url = new URLBox();
        jTabbedPane.add("Link", url);
        phandle = new PW();
        jTabbedPane.addTab("Password", phandle);
        dp = new DatePanel("View-by");
        jTabbedPane.addTab("View-by", dp);
        jTabbedPane.add("Messages", new TextMsg());
        jTabbedPane.setPreferredSize(new Dimension(jTabbedPane.getPreferredSize().width, 400));
        if (TextOption.usetext.isYes()) {
            jTabbedPane.setSelectedIndex(1);
        } else if (usepass.isSelected()) {
            jTabbedPane.setSelectedIndex(5);
        }
    }

    static String getHTMLSuffix() {
        if (suffix.isYes()) {
            return ".htm";
        }
        return ".html";
    }

    static void skeletonOff() {
        skelpath.setText(SysProps.EMPTY);
        skelpath.setBackground(Color.lightGray);
        skeleton.setYes(false);
    }

    static void writeValues() {
        if (skeleton.isYes()) {
            Prefs.setBoolean("skeleton", true);
            Prefs.set("skelpath", skelpath.getText());
        } else {
            Prefs.setBoolean("skeleton", false);
        }
        Prefs.setBoolean("suffix", suffix.isYes());
        Prefs.setInt("spaces", TextOption.spaces.getCurr());
        Prefs.setInt("fname", TextOption.getFname());
        Prefs.setInt("fstyle", TextOption.getFstyle());
        Prefs.setInt("fsize", TextOption.fsize.getCurr());
        Prefs.setBoolean("animate", TextOption.animate.isYes());
        Prefs.setInt("textcol", TextOption.textcol.getRGB());
        Prefs.setInt("tpos", TextOption.getValue());
        Prefs.setInt("toffset", TextOption.custom.getCurr());
        Prefs.setBoolean("usetext", TextOption.usetext.isYes());
        Prefs.set("text", TextOption.text.getText());
        Prefs.setBoolean("relative", relative.isYes());
        Prefs.set("reldir", reldir.getText());
        Prefs.setInt("html", html.getOption());
        Prefs.setBoolean("clipboard", clipboard.isYes());
        Prefs.setInt("movement", pb.getMovement());
        Prefs.setInt("opos", EditPrefs.pb.opos);
        Prefs.setInt("xpos", EditPrefs.pb.xpos);
        Prefs.setInt("ypos", EditPrefs.pb.ypos);
        Prefs.setBoolean("duplicate", EditPrefs.pb.dup.isSelected());
        Prefs.setBoolean("center", center.isYes());
        Prefs.setInt("page", pagecol.getRGB());
        Prefs.set("acess_denied", denied.getText());
        Prefs.set("expired", expired.getText());
        Prefs.setBoolean("overlay", overlay.isSelected());
        Prefs.set("overlay_name", olpath.getText());
        if (version.getText().equals("")) {
            version.setText("Java 1.1 needed");
        }
        Prefs.set("version", version.getText());
        Prefs.setBoolean("use_password", usepass.isSelected());
        Prefs.set("password", pw.getText());
        Prefs.set("View-by", String.valueOf(dp.getDate()));
        Prefs.set("Valid-until", String.valueOf(pdp.getDate()));
        Prefs.setBoolean("check_serverid", checkid.isSelected());
        if (checkid.isSelected()) {
            if (id.getText().equals("")) {
                Prefs.setBoolean("check_serverid", false);
            } else {
                Prefs.set("server_id", id.getText());
            }
        }
        if (author.getText().equals("")) {
            Prefs.set("author", "Unspecified");
        } else {
            Prefs.set("author", author.getText());
        }
    }

    class LastBox
    extends JPanel
    implements YesNoListener {
        LastBox() {
            this.setLayout(new VerticalLayout(0, 3));
            this.add(new Dummy(10));
            JPanel jPanel = new JPanel(false);
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Use skeleton file with '<imagesafe>' tag for HTML"));
            jPanel.setLayout(new FlowLayout(1, 0, 0));
            skeleton = new YesNo(null, "No", "Yes", this, false);
            jPanel.add(skeleton);
            skelpath = new JTextField(20);
            jPanel.add(skelpath);
            skelpath.setEditable(false);
            skelpath.setFont(ESUtils.MSG_FONT);
            if (Prefs.getBoolean("skeleton")) {
                skeleton.setYes(true);
                skelpath.setText(Prefs.get("skelpath"));
                skelpath.setBackground(Color.white);
            } else {
                skeleton.setYes(false);
                skelpath.setBackground(Color.lightGray);
            }
            this.add(jPanel);
            suffix = new YesNo("HTML file suffix to use", "  .html    ", "  .htm  ");
            this.add(suffix);
            suffix.setGaps(5, 0);
            suffix.setYes(Prefs.getBoolean("suffix"));
            String[] stringArray = new String[]{"No files", "One file/image", "One file for batch"};
            html = new MultiOption("HTML files to create", stringArray);
            this.add(html);
            html.setOption(Prefs.getInt("html"));
            clipboard = new YesNo("Paste HTML into system clipboard", "Don't paste", "Paste into clipboard");
            this.add(clipboard);
            clipboard.setYes(Prefs.getBoolean("clipboard"));
            clipboard.setGaps(5, 0);
            center = new YesNo("Position of applet on HTML page", "Default", "Center");
            this.add(center);
            center.setYes(Prefs.getBoolean("center"));
            center.setGaps(5, 0);
            pagecol = new ColorPanel("HTML page background color", Prefs.getInt("page"));
            this.add(pagecol);
        }

        public void changedYesNo(YesNo yesNo) {
            if (!skeleton.isYes()) {
                skelpath.setText(SysProps.EMPTY);
                skelpath.setBackground(Color.lightGray);
            } else {
                File file = ESChooser.ask(SysProps.CURR_DIR, "Select HTML skeleton", 0, "HTML file (with suffix " + EditPrefs.getHTMLSuffix() + ")", 1);
                if (file == null) {
                    skeleton.setYes(false);
                    return;
                }
                String string = ESUtils.getFileAsString(file);
                if (string == null) {
                    skeleton.setYes(false);
                    return;
                }
                if (string.indexOf("<imagesafe>") < 0 && string.indexOf("<IMAGESAFE>") < 0) {
                    skeleton.setYes(false);
                    new ESZap("Unable to find the '<imagesafe>' tag in the specified file");
                    return;
                }
                skelpath.setBackground(Color.white);
                skelpath.setText(file.getAbsolutePath());
            }
        }
    }

    class TextMsg
    extends JPanel {
        TextMsg() {
            this.setLayout(new GridLayout(4, 1));
            JPanel jPanel = new JPanel(false);
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Expired message"));
            expired = new JTextField(30);
            jPanel.add(expired);
            expired.setText(Prefs.get("expired"));
            expired.setFont(ESUtils.MSG_FONT);
            this.add(jPanel);
            jPanel = new JPanel(false);
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Access denied message"));
            denied = new JTextField(30);
            jPanel.add(denied);
            denied.setText(Prefs.get("access_denied"));
            denied.setFont(ESUtils.MSG_FONT);
            this.add(jPanel);
            jPanel = new JPanel(false);
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Wrong Java version message"));
            version = new JTextField(30);
            jPanel.add(version);
            version.setText(Prefs.get("version"));
            version.setFont(ESUtils.MSG_FONT);
            this.add(jPanel);
        }
    }

    class Origin
    extends JPanel
    implements ActionListener,
    YesNoListener {
        JRadioButton nocheck;

        Origin() {
            this.setLayout(new VerticalLayout(10, 3, 0));
            JPanel jPanel = new JPanel(false);
            jPanel.setLayout(new VerticalLayout(5, 3));
            this.add(jPanel);
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Check originating server (recommended)"));
            id = new JTextField(25);
            id.setFont(ESUtils.MSG_FONT);
            ButtonGroup buttonGroup = new ButtonGroup();
            JPanel jPanel2 = new JPanel(false);
            this.nocheck = new JRadioButton("Don't check");
            jPanel2.add(this.nocheck);
            buttonGroup.add(this.nocheck);
            this.nocheck.addActionListener(this);
            checkid = new JRadioButton("Check URL prefix");
            jPanel2.add(checkid);
            buttonGroup.add(checkid);
            checkid.addActionListener(this);
            jPanel.add(jPanel2);
            jPanel2 = new JPanel(false);
            jPanel2.add(id);
            jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Server URL prefix (without http:// prefix)"));
            jPanel.add(jPanel2);
            this.add(jPanel);
            if (Prefs.getBoolean("check_serverid")) {
                this.on();
                checkid.setSelected(true);
                id.setText(Prefs.get("server_id"));
            } else {
                this.nocheck.setSelected(true);
                this.off();
            }
            jPanel = new JPanel(false);
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Author id (optional)"));
            author = new JTextField(25);
            jPanel.add(author);
            author.setFont(ESUtils.MSG_FONT);
            author.setText(Prefs.get("author"));
            this.add(jPanel);
            JPanel jPanel3 = new JPanel(false);
            jPanel3.setLayout(new VerticalLayout(5, 3));
            jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Directory for JAR files relative to HTML"));
            relative = new YesNo(null, "HTML & JARs in same directory", "Relative JARs", this, false);
            jPanel3.add(relative);
            JPanel jPanel4 = new JPanel(false);
            jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Name of directory for JAR files"));
            reldir = new JTextField(25);
            jPanel4.add(reldir);
            reldir.setFont(ESUtils.MSG_FONT);
            if (!Prefs.getBoolean("relative")) {
                this.relOff();
            } else {
                relative.setYes(true);
                reldir.setText(Prefs.get("reldir"));
            }
            jPanel3.add(jPanel4);
            this.add(jPanel3);
        }

        void relOff() {
            relative.setYes(false);
            reldir.setBackground(Color.lightGray);
            reldir.setEnabled(false);
        }

        public void changedYesNo(YesNo yesNo) {
            if (relative.isYes()) {
                reldir.setEnabled(true);
                reldir.setBackground(Color.white);
                reldir.requestFocus();
            } else {
                reldir.setText("");
                reldir.setBackground(Color.lightGray);
                reldir.setEnabled(false);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (checkid.isSelected()) {
                this.on();
            } else {
                this.off();
            }
        }

        void off() {
            id.setText("");
            id.setEnabled(false);
            id.setBackground(Color.lightGray);
        }

        void on() {
            id.setBackground(Color.white);
            id.setEnabled(true);
            id.requestFocus();
        }
    }

    class PW
    extends JPanel
    implements ActionListener {
        JRadioButton nopass;
        LibButton lb;

        PW() {
            this.setLayout(new BorderLayout());
            phandle = this;
            JPanel jPanel = new JPanel(false);
            ButtonGroup buttonGroup = new ButtonGroup();
            this.nopass = new JRadioButton("No password");
            jPanel.add(this.nopass);
            buttonGroup.add(this.nopass);
            this.nopass.addActionListener(this);
            usepass = new JRadioButton("Use password");
            jPanel.add(usepass);
            buttonGroup.add(usepass);
            usepass.addActionListener(this);
            pw = new JTextField(12);
            jPanel.add(pw);
            pw.setFont(ESUtils.MSG_FONT);
            this.add((Component)jPanel, "North");
            pdp = new DatePanel("Valid-until");
            this.add((Component)pdp, "Center");
            jPanel = new JPanel(false);
            this.lb = new LibButton("Create password file");
            jPanel.add(this.lb);
            this.lb.addActionListener(this);
            this.add((Component)jPanel, "South");
            if (Prefs.getBoolean("use_password") && !Prefs.get("password").equals("")) {
                pw.setText(Prefs.get("password"));
                usepass.setSelected(true);
            } else {
                pw.setEnabled(false);
                pw.setBackground(Color.lightGray);
                this.nopass.setSelected(true);
                this.lb.setEnabled(false);
                pdp.allOff();
            }
        }

        void pwOff() {
            pw.setText("");
            pw.setEnabled(false);
            pw.setBackground(Color.lightGray);
            this.lb.setEnabled(false);
            pdp.allOff();
            this.nopass.setSelected(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof LibButton) {
                if (!PWORDS.exists()) {
                    PWORDS.mkdir();
                }
                if (pw.getText().equals("")) {
                    new ESZap("Specify a password first");
                    return;
                }
                File file = DirFinder.ask(PWORDS, "Select the name of the password file", 2);
                if (file == null) {
                    return;
                }
                PWORDS = file.getParentFile();
                LayoutFile.createPWF(ESUtils.checkExtension(file, "jar"), pw.getText());
            } else if (usepass.isSelected()) {
                if (!FileManager.canUse(2)) {
                    this.nopass.setSelected(true);
                    return;
                }
                pw.setEnabled(true);
                pw.setBackground(Color.white);
                this.lb.setEnabled(true);
                pdp.allOn();
                pw.requestFocus();
            } else {
                this.pwOff();
            }
        }
    }

    class Overlay
    extends JPanel
    implements ActionListener {
        JRadioButton nolay;

        Overlay() {
            super(false);
            ohandle = this;
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(false);
            ButtonGroup buttonGroup = new ButtonGroup();
            this.nolay = new JRadioButton("No overlay");
            jPanel.add(this.nolay);
            buttonGroup.add(this.nolay);
            this.nolay.addActionListener(this);
            overlay = new JRadioButton("Use image");
            jPanel.add(overlay);
            buttonGroup.add(overlay);
            overlay.addActionListener(this);
            olpath = new JTextField(15);
            jPanel.add((Component)olpath, "South");
            this.add((Component)jPanel, "North");
            olpath.setEditable(false);
            olpath.setBackground(Color.white);
            olpath.setFont(ESUtils.MSG_FONT);
            JPanel jPanel2 = new JPanel(false);
            jPanel2.setLayout(new BorderLayout());
            jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Thumbnail of overlay image"));
            il = new ImageLook(90, 60);
            jPanel2.add((Component)il, "Center");
            this.add((Component)jPanel2, "Center");
            pb = new PositionBox();
            this.add((Component)pb, "South");
            pb.allOff();
        }

        void setOverlay() {
            if (Prefs.getBoolean("overlay")) {
                overlay.setSelected(true);
                olpath.setText(Prefs.get("overlay_name"));
                File file = new File(SysProps.IMAGES, olpath.getText());
                pb.allOn();
                il.view(file);
                if (Prefs.getInt("opos") == 4) {
                    pb.on();
                }
                if (Prefs.getInt("movement") != 0) {
                    EditPrefs.pb.nodup.setEnabled(true);
                    EditPrefs.pb.dup.setEnabled(true);
                    EditPrefs.pb.time.setEnabled(true);
                }
            } else {
                this.off();
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.nolay.isSelected()) {
                this.off();
            } else {
                File file;
                if (!FileManager.canUse(0)) {
                    this.nolay.setSelected(true);
                    return;
                }
                if (ODIR == null) {
                    ODIR = FileFinder.HOME_DIR;
                }
                if ((file = DirFinder.ask(ODIR, "Select the image to overlay", 1)) == null) {
                    this.off();
                    return;
                }
                ODIR = file.getParentFile();
                ESUtils.deleteAll(SysProps.IMAGES);
                olpath.setBackground(Color.white);
                olpath.setEnabled(true);
                String string = file.getName();
                if (string.endsWith(".GIF")) {
                    string = string.substring(0, string.lastIndexOf(".GIF")) + ".gif";
                } else if (string.endsWith(".JPG")) {
                    string = string.substring(0, string.lastIndexOf(".JPG")) + ".jpg";
                }
                olpath.setText(string);
                File file2 = new File(SysProps.IMAGES, string);
                ESUtils.copyFile(file, file2);
                il.view(file2);
                pb.allOn();
            }
        }

        void off() {
            this.nolay.setSelected(true);
            olpath.setBackground(Color.lightGray);
            olpath.setText("");
            olpath.setEnabled(false);
            il.view(null);
            EditPrefs.pb.opos = 3;
            EditPrefs.pb.ce.setSelected(true);
            EditPrefs.pb.st.setSelected(true);
            EditPrefs.pb.nodup.setSelected(true);
            pb.allOff();
            Prefs.setInt("delay", 35);
            Prefs.setInt("step", 1);
        }
    }
}

