/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.isafe;

import com.equitysoft.isafe.Bar;
import com.equitysoft.isafe.ESZap;
import com.equitysoft.isafe.LayoutFile;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.JLabel;

class ESUtils {
    static Font MSG_FONT = new Font("dialog", 1, 12);
    static String PRODUCT = " ImageSafe 2.6";
    static MediaTracker tracker;
    static Class cls;

    ESUtils() {
    }

    static boolean checkVersion() {
        String string = System.getProperty("java.version");
        if (string.compareTo("1.2") < 0) {
            Frame frame = new Frame("Your Java version is too old.");
            JLabel jLabel = new JLabel();
            jLabel.setFont(MSG_FONT);
            jLabel.setText("  This product must be run with a 1.2 or higher Java VM.  ");
            frame.setLayout(new FlowLayout());
            frame.add(jLabel);
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            frame.pack();
            ((Component)frame).setVisible(true);
            return false;
        }
        return true;
    }

    static void deleteAll(File file) {
        if (!file.exists()) {
            return;
        }
        File[] fileArray = file.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            fileArray[n2].delete();
            ++n2;
        }
    }

    static boolean saveStringAsFile(String string, File file) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        if (file.exists()) {
            file.delete();
        }
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                bufferedWriter.write(string2, 0, string2.length());
                bufferedWriter.write("\r\n", 0, 2);
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            new ESZap("Error writing file " + file.getAbsolutePath());
            return false;
        }
        return true;
    }

    static File checkExtension(File file, String string) {
        int n;
        String string2 = file.getName();
        int n2 = string2.indexOf(46);
        if (n2 == (n = string2.length() - 1)) {
            return new File(file.getParent(), string2 + string);
        }
        if (n2 > -1) {
            return file;
        }
        return new File(file.getParent(), string2 + '.' + string);
    }

    static String checkTextExtension(String string, String string2) {
        int n;
        int n2 = string.indexOf(46);
        if (n2 == (n = string.length() - 1)) {
            return string + string2;
        }
        if (n2 > -1) {
            return string;
        }
        return string + '.' + string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getSystemFileAsString(String string) {
        int n = 256;
        byte[] byArray = new byte[1];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        byte by = 13;
        try {
            InputStream inputStream = cls.getResourceAsStream(string);
            if (inputStream == null) {
                return null;
            }
            while (true) {
                if (inputStream.read(byArray, 0, 1) <= -1) {
                    inputStream.close();
                    return byteArrayOutputStream.toString();
                }
                if (byArray[0] == by) continue;
                byteArrayOutputStream.write(byArray, 0, 1);
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static String getFileAsString(File file) {
        if (!file.exists()) {
            return null;
        }
        int n = (int)file.length();
        byte[] byArray = new byte[n];
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            bufferedInputStream.read(byArray, 0, n);
            bufferedInputStream.close();
        }
        catch (IOException iOException) {
            return null;
        }
        return new String(byArray, 0, n);
    }

    static URL getESURL(String string) {
        URL uRL;
        if (cls == null) {
            cls = Bar.handle.getClass();
        }
        if ((uRL = cls.getResource("images/" + string)) == null) {
            return null;
        }
        return uRL;
    }

    static Image getSystemImage(String string) {
        return ESUtils.loadImage(Toolkit.getDefaultToolkit().getImage(ESUtils.getESURL(string)));
    }

    static Image getImage(File file) {
        return ESUtils.loadImage(Toolkit.getDefaultToolkit().getImage(file.getAbsolutePath()));
    }

    static Image loadImage(Image image) {
        try {
            if (tracker == null) {
                tracker = new MediaTracker(Bar.handle);
            }
            tracker.addImage(image, 0);
            tracker.waitForID(0);
        }
        catch (Exception exception) {
            return null;
        }
        if (image.getWidth(null) <= 0) {
            return null;
        }
        return image;
    }

    static void copyFile(File file, File file2) {
        byte[] byArray = LayoutFile.buf;
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            while ((n = fileInputStream.read(byArray)) > 0) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileInputStream.close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            new ESZap("Error " + iOException.getMessage() + " copying files");
        }
    }

    static void textBubbleSort(String[] stringArray, int n) {
        int n2 = n - 1;
        boolean bl = false;
        while (true) {
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n3 + 1;
                if (stringArray[n3].compareToIgnoreCase(stringArray[n4]) > 0) {
                    String string = stringArray[n4];
                    stringArray[n4] = stringArray[n3];
                    stringArray[n3] = string;
                    bl = true;
                }
                ++n3;
            }
            if (!bl) break;
            bl = false;
            --n2;
        }
    }
}

