/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.isafe;

import com.equitysoft.isafe.ESDialog;
import com.equitysoft.isafe.ESUtils;
import com.equitysoft.isafe.ESZap;
import com.equitysoft.isafe.EditPrefs;
import com.equitysoft.isafe.LibButton;
import com.equitysoft.isafe.SysProps;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class ESChooser
extends ESDialog
implements ActionListener,
ListSelectionListener {
    static final int ALL = 0;
    static final int HTML = 1;
    static final int JAR = 2;
    static final int CHOOSE = 0;
    static final int SAVE = 1;
    static Color ALTCOL = new Color(153, 153, 255);
    Dimension SQ = new Dimension(26, 26);
    Dimension DIM = new Dimension(250, 20);
    JList list;
    DefaultListModel vals;
    JScrollPane sp;
    JComboBox lookin;
    static File currdir;
    static File currfile;
    File homedir;
    static Image dirimg;
    static Image diskimg;
    static ImageIcon diricon;
    static ImageIcon diskicon;
    static ImageIcon docicon;
    LibButton goup;
    LibButton gohome;
    LibButton select;
    LibButton cancel;
    boolean ignore;
    int type;
    static JTextField fn;
    String[] suffix;
    int[] lens;
    int curridx;
    int itype;

    ESChooser(File file, String string, int n, String string2, int n2) {
        super(string);
        this.type = n;
        this.itype = n2;
        int n3 = 0;
        switch (n2) {
            case 1: {
                this.suffix = new String[1];
                this.suffix[0] = EditPrefs.getHTMLSuffix();
                break;
            }
            case 2: {
                this.suffix = new String[1];
                this.suffix[0] = ".jar";
                break;
            }
            default: {
                this.suffix = null;
            }
        }
        if (this.suffix != null) {
            n3 = this.suffix.length;
            this.lens = new int[n3];
        }
        int n4 = 0;
        while (n4 < n3) {
            this.lens[n4] = this.suffix[n4].length();
            ++n4;
        }
        this.homedir = currdir = file;
        if (dirimg == null) {
            dirimg = ESUtils.getSystemImage("dir.gif");
            diricon = new ImageIcon(dirimg);
            docicon = new ImageIcon(ESUtils.getSystemImage("doc.gif"));
            diskimg = ESUtils.getSystemImage("disk.gif");
            diskicon = new ImageIcon(diskimg);
        }
        this.jp.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 6, 5));
        jPanel.add(new JLabel("Look in:"));
        this.lookin = new JComboBox();
        jPanel.add(this.lookin);
        this.lookin.setRenderer(new LCRenderer());
        this.addRoots();
        this.goup = new LibButton(null, "updir.gif");
        jPanel.add(this.goup);
        this.goup.addActionListener(this);
        this.goup.setPreferredSize(this.SQ);
        this.goup.setToolTipText("Go up a directory level");
        this.gohome = new LibButton(null, "home.gif");
        jPanel.add(this.gohome);
        this.gohome.addActionListener(this);
        this.gohome.setPreferredSize(this.SQ);
        this.gohome.setToolTipText("Go to the home directory");
        this.jp.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel2.setLayout(new BorderLayout());
        this.sp = new JScrollPane();
        this.vals = new DefaultListModel();
        this.list = new JList();
        this.list.setSelectionMode(0);
        this.list.setCellRenderer(new FFRenderer(this.list));
        this.list.setModel(this.vals);
        this.sp.getViewport().setView(this.list);
        jPanel2.add((Component)this.sp, "Center");
        this.jp.add((Component)jPanel2, "Center");
        this.lookin.addActionListener(this);
        this.list.addListSelectionListener(this);
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), string2));
        fn = new JTextField(25);
        jPanel4.add(fn);
        fn.setFont(ESUtils.MSG_FONT);
        jPanel3.add(jPanel4);
        if (n < 1) {
            fn.setEditable(false);
        }
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        String string3 = n < 1 ? "Open  " : "Save   ";
        this.select = new LibButton(string3);
        jPanel5.add((Component)this.select, "North");
        this.select.addActionListener(this);
        if (n < 1) {
            this.select.setEnabled(false);
        }
        this.cancel = new LibButton("Cancel");
        jPanel5.add((Component)this.cancel, "South");
        this.cancel.addActionListener(this);
        jPanel3.add(jPanel5);
        this.jp.add((Component)jPanel3, "South");
        this.setDir(currdir);
        this.setUpDir();
        this.finishOff();
        if (n == 1) {
            this.requestFocus();
            fn.requestFocus();
        }
    }

    void setUpDir() {
        File file;
        this.ignore = true;
        int n = this.lookin.getItemCount();
        String string = currdir.getAbsolutePath();
        int n2 = 0;
        n2 = 0;
        while (n2 < n) {
            file = (File)this.lookin.getItemAt(n2);
            if (string.startsWith(file.getAbsolutePath())) break;
            ++n2;
        }
        int n3 = this.getDepth(currdir);
        if (n3 == 0) {
            this.lookin.setSelectedIndex(n2);
            this.ignore = false;
            return;
        }
        if (n2 == n) {
            new ESZap("An expected device is missing - the program may not function properly.");
            return;
        }
        ++n2;
        file = currdir;
        while (true) {
            if (n2 == n) {
                this.lookin.addItem(file);
            } else {
                this.lookin.insertItemAt(file, n2);
            }
            file = file.getParentFile();
            if (file.getParentFile() == null) break;
            n = -1;
        }
        this.lookin.setSelectedItem(currdir);
        this.ignore = false;
    }

    void setDir(File file) {
        File file2;
        if (this.getDepth(file) == 0) {
            this.goup.setEnabled(false);
        } else {
            this.goup.setEnabled(true);
        }
        this.vals.removeAllElements();
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        int n = fileArray.length;
        File[] fileArray2 = new File[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            file2 = fileArray[n3];
            if (file2.isDirectory()) {
                fileArray2[n2] = file2;
                ++n2;
            }
            ++n3;
        }
        ESChooser.fileBubbleSort(fileArray2, n2);
        int n4 = 0;
        while (n4 < n2) {
            this.vals.addElement(fileArray2[n4]);
            ++n4;
        }
        n2 = 0;
        int n5 = 0;
        int n6 = 0;
        if (this.suffix != null) {
            n6 = this.suffix.length;
        }
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (n9 < n) {
            file2 = fileArray[n9];
            if (!file2.isDirectory()) {
                if (this.suffix != null) {
                    String string = file2.getName();
                    n5 = string.length();
                    n7 = 0;
                    while (n7 < n6) {
                        n8 = this.lens[n7];
                        if (string.regionMatches(true, n5 - n8, this.suffix[n7], 0, n8)) break;
                        ++n7;
                    }
                    if (n7 < n6) {
                        fileArray2[n2] = file2;
                        ++n2;
                    }
                } else {
                    fileArray2[n2] = file2;
                    ++n2;
                }
            }
            ++n9;
        }
        if (n2 > 0) {
            ESChooser.fileBubbleSort(fileArray2, n2);
            int n10 = 0;
            while (n10 < n2) {
                this.vals.addElement(fileArray2[n10]);
                ++n10;
            }
        }
        currfile = null;
        if (this.type < 1) {
            this.select.setEnabled(false);
        }
        fn.setText(SysProps.EMPTY);
        currdir = file;
        this.curridx = -2;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.list.getSelectedIndex();
        if (n < 0) {
            return;
        }
        if (n == this.curridx) {
            return;
        }
        this.curridx = n;
        File file = (File)this.vals.getElementAt(n);
        if (file.isDirectory()) {
            File file2;
            this.setDir(file);
            int n2 = this.lookin.getItemCount();
            String string = file.getAbsolutePath();
            int n3 = 0;
            n3 = 0;
            while (n3 < n2) {
                file2 = (File)this.lookin.getItemAt(n3);
                if (string.startsWith(file2.getAbsolutePath())) break;
                ++n3;
            }
            if (n3 == n2 - 1) {
                this.lookin.addItem(file);
                this.lookin.setSelectedIndex(n2);
            } else {
                int n4 = 0;
                n4 = n3;
                while (n4 < n2) {
                    file2 = (File)this.lookin.getItemAt(n4);
                    if (!string.startsWith(file2.getAbsolutePath())) break;
                    ++n4;
                }
                this.lookin.insertItemAt(file, n4);
                this.ignore = true;
                this.lookin.setSelectedItem(file);
                this.ignore = false;
            }
        } else if (this.type < 1) {
            currfile = file;
            this.select.setEnabled(true);
            fn.setText(file.getName());
        } else if (this.type == 1) {
            currfile = file;
            fn.setText(file.getName());
        }
    }

    int getDepth(File file) {
        int n = 0;
        while ((file = file.getParentFile()) != null) {
            ++n;
        }
        return n;
    }

    void addRoots() {
        File[] fileArray = File.listRoots();
        int n = fileArray.length;
        this.ignore = true;
        int n2 = 0;
        while (n2 < n) {
            this.lookin.addItem(fileArray[n2]);
            ++n2;
        }
        this.ignore = false;
    }

    void removeLookin(File file) {
        Vector<File> vector = new Vector<File>();
        int n = this.lookin.getItemCount();
        String string = file.getAbsolutePath();
        int n2 = 0;
        while (n2 < n) {
            File file2 = (File)this.lookin.getItemAt(n2);
            String string2 = file2.getAbsolutePath();
            if (string2.startsWith(string) && !string2.equals(string)) {
                vector.addElement(file2);
            }
            ++n2;
        }
        n = vector.size();
        this.ignore = true;
        int n3 = 0;
        while (n3 < n) {
            this.lookin.removeItem(vector.elementAt(n3));
            ++n3;
        }
        this.ignore = false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JComboBox) {
            if (!this.ignore) {
                File file = (File)this.lookin.getSelectedItem();
                File[] fileArray = file.listFiles();
                if (fileArray == null) {
                    new ESZap("The device '" + file.getAbsolutePath() + "' is not accessible.");
                    this.ignore = true;
                    this.lookin.setSelectedItem(currdir);
                    this.ignore = false;
                    return;
                }
                this.removeLookin(file);
                this.setDir(file);
            }
        } else if (object instanceof LibButton) {
            LibButton libButton = (LibButton)object;
            if (libButton == this.goup) {
                if (this.getDepth(currdir) == 0) {
                    return;
                }
                File file = currdir.getParentFile();
                this.setDir(file);
                this.removeLookin(file);
            } else if (libButton == this.gohome) {
                this.setDir(this.homedir);
                Vector<File> vector = new Vector<File>();
                int n = this.lookin.getItemCount();
                int n2 = 0;
                while (n2 < n) {
                    File file = (File)this.lookin.getItemAt(n2);
                    if (this.getDepth(file) > 0) {
                        vector.addElement(file);
                    }
                    ++n2;
                }
                n = vector.size();
                this.ignore = true;
                int n3 = 0;
                while (n3 < n) {
                    this.lookin.removeItem(vector.elementAt(n3));
                    ++n3;
                }
                this.ignore = false;
                this.setUpDir();
            } else if (libButton == this.cancel) {
                fn.setText(SysProps.EMPTY);
                currfile = null;
                this.closeDialog();
            } else if (libButton == this.select) {
                this.closeDialog();
            }
        }
    }

    void lastCall() {
        currfile = null;
        currdir = null;
    }

    static File ask(File file, String string, int n, String string2, int n2) {
        new ESChooser(file, string, n, string2, n2);
        if (n == 1) {
            if (fn.getText().equals(SysProps.EMPTY)) {
                return null;
            }
            return new File(currdir, fn.getText());
        }
        return currfile;
    }

    static void fileBubbleSort(File[] fileArray, int n) {
        int n2 = n - 1;
        boolean bl = false;
        while (true) {
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n3 + 1;
                if (fileArray[n3].getName().compareToIgnoreCase(fileArray[n4].getName()) > 0) {
                    File file = fileArray[n4];
                    fileArray[n4] = fileArray[n3];
                    fileArray[n3] = file;
                    bl = true;
                }
                ++n3;
            }
            if (!bl) break;
            bl = false;
            --n2;
        }
    }

    class FFRenderer
    extends DefaultListCellRenderer {
        FFRenderer(JList jList) {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            File file = (File)object;
            Component component = super.getListCellRendererComponent((JList<?>)jList, file.getName(), n, bl, bl2);
            if (file.isDirectory()) {
                this.setIcon(diricon);
            } else {
                this.setIcon(docicon);
            }
            return component;
        }
    }

    class LCRenderer
    extends Component
    implements ListCellRenderer {
        boolean isdisk;
        Color back;
        String txt;
        int indent;
        boolean selected;

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            File file = (File)object;
            if (ESChooser.this.getDepth(file) > 0) {
                this.isdisk = false;
                this.txt = file.getName();
            } else {
                this.isdisk = true;
                this.txt = file.getAbsolutePath();
            }
            this.indent = n < 0 ? 0 : 1 + ESChooser.this.getDepth(file) * 8;
            this.selected = bl;
            return this;
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void paint(Graphics graphics) {
            if (this.back == null) {
                this.back = this.getParent().getBackground();
            }
            graphics.setColor(this.selected ? ALTCOL : this.back);
            graphics.fillRect(0, 0, ESChooser.this.DIM.width + 30, ESChooser.this.DIM.height);
            if (this.isdisk) {
                graphics.drawImage(diskimg, this.indent, 2, null);
            } else {
                graphics.drawImage(dirimg, this.indent, 2, null);
            }
            graphics.setFont(ESUtils.MSG_FONT);
            graphics.setColor(Color.black);
            graphics.drawString(this.txt, this.indent + 21, 15);
        }

        public Dimension getPreferredSize() {
            return ESChooser.this.DIM;
        }
    }
}

