/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.isafe;

import com.equitysoft.isafe.OBRenderer;
import com.equitysoft.isafe.PMBox;
import com.equitysoft.isafe.PMBoxAdjuster;
import com.equitysoft.isafe.Prefs;
import com.equitysoft.isafe.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class DatePanel
extends JPanel
implements PMBoxAdjuster,
ActionListener {
    JComboBox months;
    PMBox day;
    PMBox year;
    JRadioButton no;
    JRadioButton yes;
    GregorianCalendar cal = new GregorianCalendar();

    DatePanel(String string) {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.no = new JRadioButton("No time limit");
        jPanel.add(this.no);
        this.no.addActionListener(this);
        buttonGroup.add(this.no);
        this.no.setSelected(true);
        this.yes = new JRadioButton(string);
        jPanel.add(this.yes);
        this.yes.addActionListener(this);
        buttonGroup.add(this.yes);
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), String.valueOf(string) + " date"));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new VerticalLayout(10, 3));
        this.day = new PMBox("Day", this, 1, 1, 31);
        jPanel3.add(this.day);
        this.months = new JComboBox();
        jPanel3.add(this.months);
        this.setMonths();
        this.months.addActionListener(this);
        this.cal.setTime(new Date());
        this.months.setRenderer(new OBRenderer());
        this.year = new PMBox("Year", this, 1, this.cal.get(1), 2100);
        jPanel3.add(this.year);
        jPanel2.add((Component)jPanel3, "Center");
        this.add((Component)jPanel2, "Center");
        long l = Long.parseLong(Prefs.get(string));
        if (l == 0L) {
            this.off();
        } else {
            this.yes.setSelected(true);
            this.on(new Date(l));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JComboBox) {
            this.cal.set(this.year.curr, this.months.getSelectedIndex(), 1);
            if (this.day.curr > this.cal.getActualMaximum(5)) {
                this.day.set(this.cal.getActualMaximum(5));
            }
        } else if (this.yes.isSelected()) {
            this.on(new Date());
        } else {
            this.off();
        }
    }

    public boolean adjust(PMBox pMBox, int n) {
        if (pMBox == this.day) {
            this.cal.set(this.year.curr, this.months.getSelectedIndex(), 1);
            if (n > this.cal.getActualMaximum(5)) {
                return false;
            }
        }
        return true;
    }

    void allOff() {
        this.off();
        this.no.setSelected(true);
        this.no.setEnabled(false);
        this.yes.setEnabled(false);
    }

    void allOn() {
        this.no.setEnabled(true);
        this.yes.setEnabled(true);
    }

    long getDate() {
        if (this.no.isSelected()) {
            return 0L;
        }
        this.cal.set(this.year.curr, this.months.getSelectedIndex(), this.day.curr, 23, 59, 59);
        return this.cal.getTime().getTime();
    }

    void off() {
        this.months.setSelectedIndex(1);
        this.months.setEnabled(false);
        this.day.off();
        this.year.off();
    }

    void on(Date date) {
        this.cal.setTime(date);
        this.day.on(this.cal.get(5));
        this.year.on(this.cal.get(1));
        this.months.setEnabled(true);
        this.months.setSelectedIndex(this.cal.get(2));
    }

    void setMonths() {
        this.months.addItem("January");
        this.months.addItem("February");
        this.months.addItem("March");
        this.months.addItem("April");
        this.months.addItem("May");
        this.months.addItem("June");
        this.months.addItem("July");
        this.months.addItem("August");
        this.months.addItem("September");
        this.months.addItem("October");
        this.months.addItem("November");
        this.months.addItem("December");
    }
}

