//An example of extending IEButton to create a button with a triangular border

import java.awt.*;

public class Triangle extends Frame{

   Triangle(){setLayout(new FlowLayout());
	MediaTracker tracker=new MediaTracker(this);
	Image img=Toolkit.getDefaultToolkit().getImage("tools.gif");
	tracker.addImage(img,0); setBackground(Color.lightGray);
	try{tracker.waitForAll();}catch (InterruptedException ie){System.err.println("Error");}
	setSize(300,300); Extension i; add(i=new Extension(img));
	i.setPreferredSize(new Dimension(200,100)); i.setBorderWidth(5); i.setBorderInset(0);
	setVisible(true);
   }
   public static void main(String args[]){new Triangle();}
//---------------------------------------------------------------------------------------------
  public class Extension extends com.equitysoft.components.IEButton{

	boolean loaded; int[] wx,wy,ex,ey,sx,sy,olx,oly; Color bright,dark;

   public Extension(Image i){super(i,"Triangle",com.equitysoft.components.IEButton.LABEL_SOUTH);}

   public void paintBorder(Graphics G,int width,int height,boolean up,Color background,
	int width_of_border,boolean draw_outline,Color outline_color){
	if(!loaded){
		bright=background.brighter(); dark=background.darker();
		int topx=Math.round(width/2);
		int yoff=(int)Math.round(width_of_border*(Math.sqrt(height*height+topx*topx))/topx);
		int xoff=(int)Math.round(width_of_border*(Math.sqrt(
			(15*topx*topx-height*height)/(topx*topx+height*height))));
		wx=new int[4]; wx[0]=0; wx[1]=topx; wx[2]=topx; wx[3]=xoff;
		wy=new int[4]; wy[0]=height; wy[1]=0; wy[2]=yoff; wy[3]=height-width_of_border;
		sx=new int[4]; sx[0]=0; sx[1]=xoff; sx[2]=width-xoff; sx[3]=width;
		sy=new int[4]; sy[0]=height; sy[1]=wy[3]; sy[2]=sy[1]; sy[3]=height;
		ex=new int[4]; ex[0]=topx; ex[1]=topx; ex[2]=sx[2]; ex[3]=width;
		ey=new int[4]; ey[0]=0; ey[1]=yoff; ey[2]=wy[3]; ey[3]=height;
		olx=new int[3]; olx[0]=topx; olx[1]=width; olx[2]=0;
		oly=new int[3]; oly[0]=0; oly[1]=height; oly[2]=height;
		loaded=true;
	}
	if(up)G.setColor(bright); else G.setColor(dark); G.fillPolygon(wx,wy,4);
	if(up)G.setColor(dark); else G.setColor(bright);
	G.fillPolygon(sx,sy,4); G.fillPolygon(ex,ey,4);
   }
  }
}

