import java.awt.*; import java.awt.event.*; import java.io.*;
import com.equitysoft.components.*;

/**
* A piece of code to demonstrate just about all the possible variations of IEButton. The
* gif images come from www.thecorporation.com
*
* @author Colin Mummery  e-mail: equitysoft@kagi.com
*/

public class Demo extends Frame implements ActionListener,EnterExitListener{

	final static String DEPRESS="Depress button";
	final static String RELEASE="Release button";
	final static String REPEAT="Repeat firing";
	final static String REPEAT_AGAIN="Repeat again";
	final static String AGAIN="Fire event again";
	final static String FIRED="Solo event fired";
	Label label;
	IEButton sticky,depresser,repeater,solo;
	Image tools,ball,pic,gif,genx;

   Demo(){

//setup the frame and images
	getImageFiles();
	setLayout(new BorderLayout()); BufferedPanel bp=new BufferedPanel();
	bp.setBackground(Color.lightGray); setSize(600,600);
	bp.setLayout(new FlowLayout(FlowLayout.LEFT,5,5));
//add buttons
	IEButton ie;
//Various examples first
	bp.add(ie=new IEButton(tools,"Label east",IEButton.LABEL_EAST));
	bp.add(ie=new IEButton(tools,"Label west",IEButton.LABEL_WEST));
	bp.add(ie=new IEButton(tools,"Label north",IEButton.LABEL_NORTH));
	bp.add(ie=new IEButton(tools,"Label south",IEButton.LABEL_SOUTH));
	ie.setFont(new Font("TimesRoman",Font.ITALIC,14)); ie.setTextColor(Color.blue);
	bp.add(ie=new IEButton(tools,"Image darkened on mousedown",IEButton.TOOLTIP));
	ie.setDownDarkened(true); ie.setFont(new Font("TimesRoman",Font.BOLD,20));
	ie.setTextColor(Color.blue);
	bp.add(ie=new IEButton(tools,"Border inset = 10",IEButton.TOOLTIP));
	ie.setBorderInset(14); ie.setTooltipBackground(Color.pink); ie.setTextColor(Color.white);
	bp.add(ie=new IEButton("Text only button"));
	ie.setFont(new Font("Helvetica",Font.BOLD,18));
	bp.add(ie=new IEButton(ball,"Thick border style",IEButton.LABEL_EAST));
	ie.setBorderWidth(2);
//With border emphasis
	bp.add(ie=new IEButton(ball,"Button outline drawn",IEButton.LABEL_EAST));
	ie.setOutlineDrawn(true); ie.setBorderWidth(3);
//Now Sticky buttons
	bp.add(sticky=new IEButton(tools,"Group sticky No.1",IEButton.LABEL_EAST));
	sticky.setSticky(true); sticky.setBorderWidth(3); sticky.setInGroup(true);
	sticky.addActionListener(this);
	bp.add(ie=new IEButton(tools,"Group sticky No.2",IEButton.LABEL_EAST));
	ie.setSticky(true); ie.setBorderWidth(3); ie.setInGroup(true);
	bp.add(ie=new IEButton(tools,"Disabled button",IEButton.LABEL_EAST));
	ie.setEnabled(false);
//Focus enabled buttons
	bp.add(ie=new IEButton(tools,"Focus No.1",IEButton.LABEL_SOUTH));
	ie.setFocusTraversable(true); ie.setBorderWidth(2); ie.setOutlineDrawn(true);
	bp.add(ie=new IEButton(tools,"Focus No.2",IEButton.LABEL_SOUTH));
	ie.setFocusTraversable(true); ie.setBorderWidth(2); ie.setOutlineDrawn(true);
	bp.add(ie=new IEButton(tools,"Focus No.3",IEButton.LABEL_SOUTH));
	ie.setFocusTraversable(true); ie.setBorderWidth(2); ie.setOutlineDrawn(true);
	bp.add(ie=new IEButton(tools,"Preferred size 250 X 60",IEButton.LABEL_EAST));
	ie.setPreferredSize(new Dimension(250,60));
//zero args constructor
	bp.add(ie=new IEButton()); ie.setBorderWidth(4);
	bp.add(ie=new IEButton(ball,"Fire action event",IEButton.LABEL_EAST));
	ie.addActionListener(this);
//Always litup
	bp.add(ie=new IEButton(ball,"Always litup",IEButton.LABEL_EAST)); ie.setLitup(true);
//Always litup and sticky
	bp.add(solo=new IEButton(ball,"Solo sticky 1",IEButton.LABEL_EAST));
	solo.setLitup(true); solo.setSticky(true); solo.addActionListener(this);
	bp.add(ie=new IEButton(ball,"Solo sticky 2",IEButton.LABEL_EAST));
	ie.setLitup(true); ie.setSticky(true);
	bp.add(ie=new IEButton(gif,"Inset = 0 and Border Width = 4",IEButton.TOOLTIP));
	ie.setBorderInset(0); ie.setBorderWidth(4);
	bp.add(ie=new IEButton(genx,"Image darkened when pushed",IEButton.TOOLTIP));
	ie.setBorderInset(3); ie.setBorderWidth(4); ie.setDownDarkened(true); ie.setLitup(true);

//This panel demonstrates transparent buttons
	Panel p=new Panel(){
		public void update(Graphics G){paint(G);}
		public void paint(Graphics G){G.drawImage(pic,0,0,null); super.paint(G);}
		public Dimension getPreferredSize(){return new Dimension(400,100);}
	};
//add buttons to panel
	p.setLayout(new FlowLayout(FlowLayout.CENTER,20,30));
	p.add(ie=new IEButton(tools,"A transparent button",IEButton.LABEL_EAST));
	ie.setTextColor(Color.white); ie.setBorderWidth(3);
	p.add(ie=new IEButton(tools,"Tooltip time delay = 50",IEButton.TOOLTIP));
	ie.setTextColor(Color.red); ie.setTooltipBackground(Color.darkGray);
	ie.setBorderWidth(3); ie.setBorderInset(8); ie.setTooltipTimeDelay(50);
	bp.add(p);
//Inverted grayout
	bp.add(ie=new IEButton(tools,"Inverted grayout",IEButton.LABEL_EAST));
	ie.setGrayOutInverted(true);
	bp.add(ie=new IEButton(ball,"EnterExitEvent listener",IEButton.LABEL_EAST));
	IEButton ie2; 
	bp.add(ie2=new IEButton(ball,"EnterExitEvent source",IEButton.LABEL_EAST));
	ie2.addEnterExitListener(ie); ie2.addEnterExitListener(this);

	bp.add(ie=new IEButton(tools,"Opaque button",IEButton.LABEL_SOUTH)); ie.setOpaque(true);
	ie.setButtonBackground(Color.yellow.darker()); ie.setLitup(true);
	ie.setBorderWidth(2);
	bp.add(label=new Label("No button pushed",Label.CENTER));
	label.setFont(new Font("Helvetica",Font.BOLD,16));
	bp.add(depresser=new IEButton(DEPRESS)); depresser.addActionListener(this);
//Repeater button
	bp.add(repeater=new IEButton("Repeat event firing")); repeater.setRepeat(true);
	repeater.setRepeatInterval(400); repeater.addActionListener(this);
	/*repeater.setSticky(true);*/       //uncomment this line to see repeating and sticky
//Add panel
	add(bp,BorderLayout.CENTER);
	setVisible(true);
	addWindowListener(new WindowAdapter(){public void windowClosing(WindowEvent we){
												System.exit(0);}});
   }
//---------------------------------------------------------------------------------------------
   public void buttonStateChanged(EnterExitEvent eee){
	label.setForeground(Color.red);
	if(eee.getState())label.setText("Entered"); else label.setText("Exited");
   }
//---------------------------------------------------------------------------------------------
   public void actionPerformed(ActionEvent ae){
	if(ae.getSource()==repeater){
		if(label.getText().equals(REPEAT_AGAIN)){
			label.setForeground(Color.red); label.setText(REPEAT);
		}
		else {label.setForeground(Color.green); label.setText(REPEAT_AGAIN);}
	}
	else if(ae.getSource()==solo){
		if(label.getText().equals(FIRED)){
			label.setForeground(Color.green); label.setText("Solo fired again");
		}
		else {label.setForeground(Color.blue); label.setText(FIRED);}
	}
	else if(ae.getSource()==depresser){
		if(sticky.isDepressed()){
			sticky.setDepressed(false); depresser.setText(DEPRESS);
		}
		else {sticky.setDepressed(true); depresser.setText(RELEASE);}
	}
	else {
		if(label.getText().equals(AGAIN)){
			label.setForeground(Color.cyan); label.setText("ActionEvent fired");
		}
		else {label.setForeground(Color.pink); label.setText(AGAIN);}
	}
   }
//---------------------------------------------------------------------------------------------
   public static void main(String args[]){new Demo();}
//---------------------------------------------------------------------------------------------
// Load the images.
   void getImageFiles(){
	MediaTracker tracker=new MediaTracker(this);
	tools=Toolkit.getDefaultToolkit().getImage("tools.gif");
	tracker.addImage(tools,0);
	ball=Toolkit.getDefaultToolkit().getImage("ball.gif");
	tracker.addImage(ball,0);
	pic=Toolkit.getDefaultToolkit().getImage("klee.jpg");
	tracker.addImage(pic,0);
	gif=Toolkit.getDefaultToolkit().getImage("gifpic.gif");
	tracker.addImage(gif,0);
	genx=Toolkit.getDefaultToolkit().getImage("genx.gif");
	tracker.addImage(genx,0);
	try{tracker.waitForAll();}catch (InterruptedException ie){System.err.println("Error");}	
   }
//---------------------------------------------------------------------------------------------
// A buffered panel gets rid of flashing that occurs when you have a lot of buttons like this
// If you use the Swing JPanel as the container it will double buffer automatically for you
  class BufferedPanel extends Panel{
	Image os;
   public void update(Graphics G){paint(G);}
   public void paint(Graphics G){
	if(os==null)os=createImage(getSize().width,getSize().height);
	Graphics g=os.getGraphics(); g.clearRect(0,0,getSize().width,getSize().height);
	super.paint(g); G.drawImage(os,0,0,null); g.dispose();
   }
  }
}//end of Demo
