package com.equitysoft.components;

import java.awt.*; import java.awt.event.*;

public class PreferredSizeEditor extends java.beans.PropertyEditorSupport{

   public boolean isPaintable(){return true;}

   public void paintValue(Graphics G, Rectangle r){
	Dimension dim=(Dimension)getValue();
	G.setColor(Color.white); G.fillRect(0,0,r.width,r.height);
	G.setColor(Color.gray); G.draw3DRect(0,0,r.width-1,r.height-1,false);
	FontMetrics fm=G.getFontMetrics(G.getFont());
	G.setClip(1,1,r.width-2,r.height-2); G.setColor(Color.black);
	int yoff=(int)((r.height-fm.getHeight())/2+fm.getHeight()-fm.getDescent());
	G.drawString(IEButton.getString("width")+": "+dim.width+" "+IEButton.getString("hgt")+
											": "+dim.height,2,yoff);
   }

   public boolean supportsCustomEditor(){return true;}

   public Component getCustomEditor(){return new EditDialog();}
//----------------------------------------------------------------------------------------------
   public String getJavaInitializationString() {
	Object o=getValue(); if(o==null)return "null";
	Dimension d=(Dimension)o;
	return "new Dimension("+d.width+","+d.height+")";
   }
//----------------------------------------------------------------------------------------------
  class EditDialog extends Panel implements TextListener{
	TextField tfw,tfh; Dimension dim;
   EditDialog(){

	dim=(Dimension)getValue();
	tfw=new TextField(String.valueOf(dim.width),6);
	tfh=new TextField(String.valueOf(dim.height),6);
	setLayout(new FlowLayout()); tfw.addTextListener(this); tfh.addTextListener(this);
	add(new Label(IEButton.getString("width"),Label.CENTER)); add(tfw);
	add(new Label(IEButton.getString("hgt"),Label.CENTER)); add(tfh);
   }

   public void textValueChanged(TextEvent evt){
	TextField tf=(TextField)evt.getSource();
	String txt=tf.getText(); int val;
	if(txt.equals(""))tf.setText("0");
	else {
		try{val=Integer.parseInt(txt);}catch(NumberFormatException nfe){
			tfw.setText(String.valueOf(dim.width));
			tfh.setText(String.valueOf(dim.height)); return;}
	}
	setValue(new Dimension(Integer.parseInt(tfw.getText()),Integer.parseInt(tfh.getText())));
   }
  }//end of class EditDialog
}
