package com.equitysoft.components;

import java.awt.*; import java.awt.event.*; import java.io.*;

public class ImageFileEditor extends java.beans.PropertyEditorSupport{

   public boolean isPaintable(){return true;}

   public void paintValue(Graphics G, Rectangle r){
	int w=r.width-2; int h=r.height-2; G.setClip(r.x+1,r.y+1,w,h);
	FontMetrics fm=G.getFontMetrics(G.getFont()); G.setColor(Color.black);
	int yoff=(int)((r.height-fm.getHeight())/2+fm.getHeight()-fm.getDescent());
	String name=(String)getValue();
	if(name.equals(""))G.drawString(IEButton.getString("no_image_msg"),r.x+2,r.y+yoff);
	else G.drawString(((String)name),r.x+2,r.y+yoff);
   }

   public boolean supportsCustomEditor(){return true;}

   public Component getCustomEditor(){return new GetImageDialog();}

   public String getJavaInitializationString() {
	String name=(String)getValue();
	if(name.equals(""))return "null";
	String str = name.replace('\\','/');
	return "\""+str+"\"";
   }
//............................................................................................
  class GetImageDialog extends Panel implements ActionListener{
	Label lab; FileDialog fd; Button but;
   GetImageDialog(){
	setLayout(new BorderLayout());
	add(lab=new Label(IEButton.getString("select_image")),BorderLayout.NORTH);
	lab.setFont(IEButton.MSG_FONT);
	Panel p=new Panel(); p.setLayout(new GridLayout(1,2,5,0));
	Button b=new Button(IEButton.getString("browse")); b.setFont(IEButton.MSG_FONT); p.add(b);
	b.addActionListener(this);
	p.add(b=new Button(IEButton.getString("no_image"))); b.setFont(IEButton.MSG_FONT);
	b.addActionListener(this); add(p,BorderLayout.SOUTH);
	Object o=getValue();
	if(o!=null)b.setEnabled(false); but=b;
   }
   public void getImage(){
	Container parent=getParent();
	while(parent!=null && !(parent instanceof Frame))parent=parent.getParent();
	fd=new FileDialog((Frame)parent,IEButton.getString("select_image"),FileDialog.LOAD);
	fd.setVisible(true); String name=fd.getFile(); if(name==null)return;
	File f=new File(fd.getDirectory(),name);
	setValue(f.getAbsolutePath()); but.setEnabled(true);
	lab.setText("'"+f.getName()+"' "+IEButton.getString("selected"));
   }
   public void actionPerformed(ActionEvent ae){
	String com=ae.getActionCommand();
	if(com==IEButton.getString("browse"))getImage();
	else {
		lab.setText(IEButton.getString("no_image_selected"));
		setValue(null); but.setEnabled(false);
	}
   }
  }//end of class GetImageDialog
}
