package com.equitysoft.components;

import java.awt.*; import java.awt.event.*; import java.beans.*; import java.util.*;

public class IEButtonBeanInfo extends SimpleBeanInfo{

   public Image getIcon(int kind){
	switch(kind){
		case ICON_COLOR_16x16: return loadImage("house_sm.gif");
		case ICON_COLOR_32x32: return loadImage("house_lg.gif");
		default: return null;
	}
   }
   public PropertyDescriptor[] getPropertyDescriptors(){
	PropertyDescriptor[] pds=new PropertyDescriptor[26]; ResourceBundle rb=null;
	try{
		rb=ResourceBundle.getBundle("com.equitysoft.components.IEButtonResources");
	}catch(MissingResourceException mre){return null;}
	try{
		pds[0]=new PropertyDescriptor("ImageFile",IEButton.class);
		pds[0].setDisplayName(rb.getString("current_image"));
		pds[0].setPropertyEditorClass(ImageFileEditor.class);
		pds[1]=new PropertyDescriptor("TextPosition",IEButton.class);
		pds[1].setDisplayName(rb.getString("text_position"));
		pds[1].setPropertyEditorClass(TextPositionEditor.class);
		pds[2]=new PropertyDescriptor("PreferredSize",IEButton.class);
		pds[2].setPropertyEditorClass(PreferredSizeEditor.class);
		pds[2].setDisplayName(rb.getString("preferred_size"));
		pds[3]=new PropertyDescriptor("Font",IEButton.class);
		pds[3].setDisplayName(rb.getString("font"));
		pds[4]=new PropertyDescriptor("TooltipTimeDelay",IEButton.class);
		pds[4].setDisplayName(rb.getString("delay"));
		pds[5]=new PropertyDescriptor("Text",IEButton.class);
		pds[5].setDisplayName(rb.getString("text"));
		pds[6]=new PropertyDescriptor("TextColor",IEButton.class);
		pds[6].setDisplayName(rb.getString("text_color"));
		pds[7]=new PropertyDescriptor("Opaque",IEButton.class,"isOpaque","setOpaque");
		pds[7].setDisplayName(rb.getString("opaque"));
		pds[8]=new PropertyDescriptor("ButtonBackground",IEButton.class);
		pds[8].setDisplayName(rb.getString("button_background"));
		pds[9]=new PropertyDescriptor("TooltipBackground",IEButton.class);
		pds[9].setDisplayName(rb.getString("tooltip_background"));
		pds[10]=new PropertyDescriptor("BorderInset",IEButton.class);
		pds[10].setDisplayName(rb.getString("inset"));
		pds[11]=new PropertyDescriptor("BorderWidth",IEButton.class);
		pds[11].setDisplayName(rb.getString("border_width"));
		pds[12]=new PropertyDescriptor("Sticky",IEButton.class,"isSticky","setSticky");
		pds[12].setDisplayName(rb.getString("sticky"));
		pds[13]=new PropertyDescriptor("Litup",IEButton.class,"isLitup","setLitup");
		pds[13].setDisplayName(rb.getString("always_litup"));
		pds[14]=new PropertyDescriptor("ImageGrayOutEnabled",IEButton.class,
							"isImageGrayOutEnabled","setImageGrayOutEnabled");
		pds[14].setDisplayName(rb.getString("can_grayout"));
		pds[15]=new PropertyDescriptor("FocusTraversable",IEButton.class,
			"isFocusTraversable","setFocusTraversable");
		pds[15].setDisplayName(rb.getString("focus_traversable"));
		pds[16]=new PropertyDescriptor("Enabled",IEButton.class,"isEnabled","setEnabled");
		pds[16].setDisplayName(rb.getString("enabled"));
		pds[17]=new PropertyDescriptor("GrayoutInverted",IEButton.class,
			"isGrayOutInverted","setGrayOutInverted");
		pds[17].setDisplayName(rb.getString("inverted"));
		pds[18]=new PropertyDescriptor("OutlineDrawn",IEButton.class,"isOutlineDrawn",
			"setOutlineDrawn");
		pds[18].setDisplayName(rb.getString("outline"));
		pds[19]=new PropertyDescriptor("Outline",IEButton.class,"isDownDarkened",
												"setDownDarkened");
		pds[19].setDisplayName(rb.getString("darkened"));
		pds[20]=new PropertyDescriptor("Depressed",IEButton.class,
										"isDepressed","setDepressed");
		pds[20].setDisplayName(rb.getString("depressed"));
		pds[21]=new PropertyDescriptor("Repeat",IEButton.class,"willRepeat","setRepeat");
		pds[21].setDisplayName(rb.getString("repeat"));
		pds[22]=new PropertyDescriptor("RepeatInterval",IEButton.class,"getRepeatInterval",
								"setRepeatInterval");
		pds[22].setDisplayName(rb.getString("interval"));
		pds[23]=new PropertyDescriptor("InGroup",IEButton.class,"isInGroup","setInGroup");
		pds[23].setDisplayName(rb.getString("ingroup"));
		pds[24]=new PropertyDescriptor("Sliding tooltip",IEButton.class,"isSlidingTooltip","setSlidingTooltip");
		pds[24].setDisplayName(rb.getString("sliding"));
		pds[25]=new PropertyDescriptor("Tooltip position",IEButton.class,"getTooltipPosition","setTooltipPosition");
		pds[25].setDisplayName(rb.getString("ttposition"));
		pds[25].setPropertyEditorClass(TooltipPositionEditor.class);
	}catch(IntrospectionException io){}
	return pds;
   }
//---------------------------------------------------------------------------------------------
   public int getDefaultPropertyIndex() {
	// the index for the "text" property
        return 5; 
   }
//---------------------------------------------------------------------------------------------
   public MethodDescriptor[] getMethodDescriptors() {

	MethodDescriptor[] md=new MethodDescriptor[1];
	Class[] cls=new Class[1]; cls[0]=EnterExitEvent.class;
	try{
		md[0]=new MethodDescriptor(IEButton.class.getMethod("buttonStateChanged",cls));
		md[0].setDisplayName("Button State Changed");
	}catch(NoSuchMethodException msme){}
	return md;
   }
//---------------------------------------------------------------------------------------------
   public EventSetDescriptor[] getEventSetDescriptors() {
	EventSetDescriptor[] rv=new EventSetDescriptor[2];
	try{
		rv[0]=new EventSetDescriptor(IEButton.class,"Action Event",
						java.awt.event.ActionListener.class,"actionPerformed");
            rv[0].setDisplayName("Pushing the button");
		rv[1]=new EventSetDescriptor(IEButton.class,"Cursor EnterExit Event",
								EnterExitListener.class,"buttonStateChanged");
            rv[1].setDisplayName("Cursor enter or exit");
	}catch (IntrospectionException e) {}
	return rv;
    }
}//end of BeanInfo
