package com.equitysoft.components;

import java.util.*;
/**
* This interface allows a class to listen for <code>EnterExitEvent</code> occurences when the
* cursor enters or exits an IEButton instance. One of the uses is to allow one IEButton to lightup
* at the same time as another button. IEButton already implements this interface so that if it is
* registered as a <code>EnterExitListener</code> on another button, the listening button
* will lightup at the same time as the cursor passes over the event generating button.
*/
public interface EnterExitListener extends EventListener{
   public void buttonStateChanged(EnterExitEvent eee);
}