package com.equitysoft.components;

import java.util.*;
/**
* This event is used to indicate to a <code>EnterExitListener</code> if the cursor has entered
* or exited an IEButton instance.
*/
public class EnterExitEvent extends EventObject{
	private boolean entered;
/**
* Creates an instance of EnterExitEvent with the boolean value that indicates the condition that
* caused the event.
* @ param source The IEButton instance that gave rise to the event
* @ param entered A boolean value to indicate what occured.
*/
   public EnterExitEvent(Object source,boolean entered){super(source); this.entered=entered;}
/**
* @return A boolean value that indicates if the event was enter or exit.
* A value of <code>true</code> indicates the cursor entered the button. A value
* of <code>false</code> indicates that the cursor exited the button.
*/
   public boolean getState(){return entered;}
}
