/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.components;

import com.equitysoft.components.IEButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.beans.PropertyEditorSupport;

public class PreferredSizeEditor
extends PropertyEditorSupport {
    public Component getCustomEditor() {
        return new EditDialog();
    }

    public String getJavaInitializationString() {
        Object object = this.getValue();
        if (object == null) {
            return "null";
        }
        Dimension dimension = (Dimension)object;
        return "new Dimension(" + dimension.width + "," + dimension.height + ")";
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        Dimension dimension = (Dimension)this.getValue();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        graphics.setColor(Color.gray);
        graphics.draw3DRect(0, 0, rectangle.width - 1, rectangle.height - 1, false);
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        graphics.setClip(1, 1, rectangle.width - 2, rectangle.height - 2);
        graphics.setColor(Color.black);
        int n = (rectangle.height - fontMetrics.getHeight()) / 2 + fontMetrics.getHeight() - fontMetrics.getDescent();
        graphics.drawString(String.valueOf(IEButton.getString("width")) + ": " + dimension.width + " " + IEButton.getString("hgt") + ": " + dimension.height, 2, n);
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    class EditDialog
    extends Panel
    implements TextListener {
        TextField tfw;
        TextField tfh;
        Dimension dim;

        EditDialog() {
            this.dim = (Dimension)PreferredSizeEditor.this.getValue();
            this.tfw = new TextField(String.valueOf(this.dim.width), 6);
            this.tfh = new TextField(String.valueOf(this.dim.height), 6);
            this.setLayout(new FlowLayout());
            this.tfw.addTextListener(this);
            this.tfh.addTextListener(this);
            this.add(new Label(IEButton.getString("width"), 1));
            this.add(this.tfw);
            this.add(new Label(IEButton.getString("hgt"), 1));
            this.add(this.tfh);
        }

        public void textValueChanged(TextEvent textEvent) {
            TextField textField = (TextField)textEvent.getSource();
            String string = textField.getText();
            if (string.equals("")) {
                textField.setText("0");
            } else {
                try {
                    int n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    this.tfw.setText(String.valueOf(this.dim.width));
                    this.tfh.setText(String.valueOf(this.dim.height));
                    return;
                }
            }
            PreferredSizeEditor.this.setValue(new Dimension(Integer.parseInt(this.tfw.getText()), Integer.parseInt(this.tfh.getText())));
        }
    }
}

