/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.components;

import com.equitysoft.components.IEButton;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditorSupport;
import java.io.File;

public class ImageFileEditor
extends PropertyEditorSupport {
    public Component getCustomEditor() {
        return new GetImageDialog();
    }

    public String getJavaInitializationString() {
        String string = (String)this.getValue();
        if (string.equals("")) {
            return "null";
        }
        String string2 = string.replace('\\', '/');
        return "\"" + string2 + "\"";
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        int n = rectangle.width - 2;
        int n2 = rectangle.height - 2;
        graphics.setClip(rectangle.x + 1, rectangle.y + 1, n, n2);
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        graphics.setColor(Color.black);
        int n3 = (rectangle.height - fontMetrics.getHeight()) / 2 + fontMetrics.getHeight() - fontMetrics.getDescent();
        String string = (String)this.getValue();
        if (string.equals("")) {
            graphics.drawString(IEButton.getString("no_image_msg"), rectangle.x + 2, rectangle.y + n3);
        } else {
            graphics.drawString(string, rectangle.x + 2, rectangle.y + n3);
        }
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    class GetImageDialog
    extends Panel
    implements ActionListener {
        Label lab;
        FileDialog fd;
        Button but;

        GetImageDialog() {
            this.setLayout(new BorderLayout());
            this.lab = new Label(IEButton.getString("select_image"));
            this.add((Component)this.lab, "North");
            this.lab.setFont(IEButton.MSG_FONT);
            Panel panel = new Panel();
            panel.setLayout(new GridLayout(1, 2, 5, 0));
            Button button = new Button(IEButton.getString("browse"));
            button.setFont(IEButton.MSG_FONT);
            panel.add(button);
            button.addActionListener(this);
            button = new Button(IEButton.getString("no_image"));
            panel.add(button);
            button.setFont(IEButton.MSG_FONT);
            button.addActionListener(this);
            this.add((Component)panel, "South");
            Object object = ImageFileEditor.this.getValue();
            if (object != null) {
                button.setEnabled(false);
            }
            this.but = button;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string == IEButton.getString("browse")) {
                this.getImage();
            } else {
                this.lab.setText(IEButton.getString("no_image_selected"));
                ImageFileEditor.this.setValue(null);
                this.but.setEnabled(false);
            }
        }

        public void getImage() {
            Container container = this.getParent();
            while (container != null && !(container instanceof Frame)) {
                container = container.getParent();
            }
            this.fd = new FileDialog((Frame)container, IEButton.getString("select_image"), 0);
            ((Component)this.fd).setVisible(true);
            String string = this.fd.getFile();
            if (string == null) {
                return;
            }
            File file = new File(this.fd.getDirectory(), string);
            ImageFileEditor.this.setValue(file.getAbsolutePath());
            this.but.setEnabled(true);
            this.lab.setText("'" + file.getName() + "' " + IEButton.getString("selected"));
        }
    }
}

