package com.equitysoft.hashstore;
import java.io.*; import java.text.*;

/**
 * This a convenience class that is an extension of DuplicateDiskHashTable providing all methods as synchronized
 * This source code is subject to the terms and conditions of the General Public License
 *
 *
 * @author  Colin Mummery - colin_mummery@my-deja.com - http://www.kagi.com/equitysoft
 */

public class SyncDuplicateDiskHashtable extends DuplicateDiskHashtable{

   public SyncDuplicateDiskHashtable(File root) {
	super(root);
   }
//-------------------------------------------------------------------------
/**
 * Gets the value associated with first occurence of the key or null if the key is not found.
 */
   public synchronized Object get(Object key) throws IOException {
	return super.get(key);
   }
//-------------------------------------------------------------------------
/**
 * Puts the key and value pair into the table.
 */
   public synchronized Object put(Object key,Object value) throws IOException {
	return super.put(key,value);
   }
//--------------------------------------------------------------------------
/**
 * Gets the next value ssociated with the current key.
 */
   public synchronized Object getNext() throws IOException {
	return super.getNext();
   }
//--------------------------------------------------------------------------
/**
 * Removes all entries with the specified key value.
 */
   public synchronized Object remove(Object key) throws IOException {
	return super.remove(key);
   }
//--------------------------------------------------------------------------
/**
 * Removes the current entry.
 */
   public synchronized Object removeCurrent() throws IOException {
	return super.removeCurrent();
   }
//--------------------------------------------------------------------------
}

