package com.equitysoft.hashstore;
import java.io.*;

/**
 * This class is a convenience class that is a synchronized version of <code>DiskHashtable</code>.<p>
 * This source code is subject to the terms and conditions of the General Public License
 *
 * @author  Colin Mummery - colin_mummery@my-deja.com - http://www.kagi.com/equitysoft
 */

public class SyncDiskHashtable extends DiskHashtable{


   public SyncDiskHashtable(File root) {
	super(root);
    }
//-------------------------------------------------------------------------
/**
 * Stores the <code>key</code> and <code>value</code> pair in the hashtable. If the key value already
 * exists then the value if replaced and the old value is returned otherwise the method returns <code>null</code>.
 */
   public synchronized Object put(Object key,Object value) throws IOException {
	return super.put(key,value);
   }
//--------------------------------------------------------------------------
/**
 * Retrieves the object associated with the <code>key</code> in the hashtable. If the key doesn't
 * exist then the method returns <code>null</code>.
 */
   public synchronized Object get(Object key) throws IOException {
	return super.get(key);
   }
//--------------------------------------------------------------------------
/**
 * Removes the key and value pair in the hashtable associated with the given <code>key</code>. If the key value
 * exists then the associated value is returned otherwise the method returns <code>null</code>.
 */
   public synchronized Object remove(Object key) throws IOException {
	return super.remove(key);
   }
//--------------------------------------------------------------------------
/**
 * Returns <code>true</code> if the <code>key</code> exists in the hashtable otherwise <code>false</code>.
 */
   public synchronized boolean containsKey(Object key) throws IOException {
	return super.containsKey(key);
   }
}

