import com.equitysoft.hashstore.*;
import java.awt.*; import java.text.*;
import java.io.*; import javax.swing.*;
import java.awt.event.*; import java.util.*;
/*
	A demonstration program for DiskHashtable
*/

public class TestUnique extends JFrame implements ActionListener{

	JTextField key,value; JButton add,find,delete,clear,deleteall,size,list,isempty; JLabel msg;
	SyncDiskHashtable dht=new SyncDiskHashtable(new File("Unique_table"));
	String EMPTY="";

   TestUnique(){
	Container c=getContentPane();
	c.setLayout(new BorderLayout());
	JPanel top=new JPanel();
	clear=new JButton("Clear"); clear.addActionListener(this); top.add(clear);
	deleteall=new JButton("Delete table"); deleteall.addActionListener(this); top.add(deleteall);
	size=new JButton("Size"); size.addActionListener(this); top.add(size);
	list=new JButton("List"); list.addActionListener(this); top.add(list);
	c.add(top,BorderLayout.NORTH);
	JPanel p=new JPanel();
	p.setLayout(new GridLayout(3,2)); JLabel jl;
	p.add(jl=new JLabel("Key   ")); jl.setHorizontalAlignment(SwingConstants.RIGHT); p.add(key=new JTextField(20));
	p.add(jl=new JLabel("Value  ")); jl.setHorizontalAlignment(SwingConstants.RIGHT); p.add(value=new JTextField(20));
	p.add(msg=new JLabel()); msg.setHorizontalAlignment(SwingConstants.RIGHT);
	c.add(p,BorderLayout.CENTER);
	p=new JPanel();
	add=new JButton("Add"); add.addActionListener(this); p.add(add);
	find=new JButton("Find"); find.addActionListener(this); p.add(find);
	delete=new JButton("Delete"); delete.addActionListener(this); p.add(delete);
	isempty=new JButton("Is empty"); isempty.addActionListener(this); p.add(isempty);
	c.add(p,BorderLayout.SOUTH);
	pack(); setLocation(100,100); setVisible(true);
	addWindowListener(
		new WindowAdapter(){public void windowClosing(WindowEvent we){System.exit(0);}}
	);
   }
//---------------------------------------------------------------------------------------------------
   public void actionPerformed(ActionEvent ae){
     try{
	JButton jb=(JButton)ae.getSource();
	if(jb==add){
		if(key.getText().equals(EMPTY) || value.getText().equals(EMPTY)){
			msg.setText("  Ignored - key or value was empty"); return;
		}
		if(dht.containsKey(key.getText()))msg.setText("  Ignored - key already exists");
		else {dht.put(key.getText(),value.getText()); msg.setText("  Value added");}
	}
	else if(jb==find){
		if(key.getText().equals(EMPTY)){
			msg.setText("  Ignored - key was empty"); return;
		}
		value.setText(EMPTY);
		Object obj=dht.get(key.getText());
		if(obj==null)msg.setText("  Not found"); else msg.setText("  Found : "+(String)obj);
	}
	else if(jb==delete){
		if(key.getText().equals(EMPTY)){
			msg.setText("  Ignored - key was empty"); return;
		}
		Object obj=dht.remove(key.getText());
		if(obj==null)msg.setText("Failed - key not found");
		else msg.setText("Removed : "+(String)obj);
	}
	else if(jb==size){
		msg.setText(" Size : "+dht.size());
	}
	else if(jb==clear){
		dht.clear(); msg.setText(" Files deleted");
	}
	else if(jb==deleteall){
		dht.deleteTable(); msg.setText(" Files and directories deleted");
	}
	else if(jb==list){
		Enumeration e=dht.keys(); String s;
		while(e.hasMoreElements())System.out.println((String)e.nextElement());
		/*while((s=(String)e.nextElement())!=null)System.out.println(s);*/
		System.out.println("End of listing");
	}
	else if(jb==isempty){
		if(dht.isEmpty())msg.setText(" Is Empty"); else msg.setText(" Is not empty");
	}
     }catch(IOException e){System.out.println("******* IO Exception ********");}
   }
//---------------------------------------------------------------------------------------------------
   public static void main (String args[]){new TestUnique();
   }
}
//===================================================================================================
