import com.equitysoft.hashstore.*;
import java.awt.*; import java.text.*;
import java.io.*; import javax.swing.*;
import java.awt.event.*; import java.util.*;
/*
	A demonstration program for DuplicateDiskHashtable
*/

public class TestDuplicate extends JFrame implements ActionListener{

	JTextField key,value; JButton add,find,next,delete,clear,deleteall,size,list,isempty,dcurrent,current;
	JLabel msg;
	DuplicateDiskHashtable dht=new DuplicateDiskHashtable(new File("Duplicate_table"));
	String EMPTY="";

   TestDuplicate(){
	Container c=getContentPane();
	c.setLayout(new BorderLayout());
	JPanel top=new JPanel();
	clear=new JButton("Clear"); clear.addActionListener(this); top.add(clear);
	deleteall=new JButton("Delete table"); deleteall.addActionListener(this); top.add(deleteall);
	size=new JButton("Size"); size.addActionListener(this); top.add(size);
	list=new JButton("List"); list.addActionListener(this); top.add(list);
	isempty=new JButton("Is empty"); isempty.addActionListener(this); top.add(isempty);
	c.add(top,BorderLayout.NORTH);
	JPanel p=new JPanel();
	p.setLayout(new GridLayout(3,2)); JLabel jl;
	p.add(jl=new JLabel("Key   ")); jl.setHorizontalAlignment(SwingConstants.RIGHT); p.add(key=new JTextField(20));
	p.add(jl=new JLabel("Value  ")); jl.setHorizontalAlignment(SwingConstants.RIGHT); p.add(value=new JTextField(20));
	p.add(msg=new JLabel()); msg.setHorizontalAlignment(SwingConstants.RIGHT);
	c.add(p,BorderLayout.CENTER);
	p=new JPanel();
	add=new JButton("Add"); add.addActionListener(this); p.add(add);
	find=new JButton("Find"); find.addActionListener(this); p.add(find);
	next=new JButton("Next"); next.addActionListener(this); p.add(next);
	delete=new JButton("Delete key"); delete.addActionListener(this); p.add(delete);
	dcurrent=new JButton("Delete current"); dcurrent.addActionListener(this); p.add(dcurrent);
	current=new JButton("Current"); current.addActionListener(this); p.add(current);
	c.add(p,BorderLayout.SOUTH);
	pack(); setLocation(100,100); setVisible(true);
	addWindowListener(
		new WindowAdapter(){public void windowClosing(WindowEvent we){System.exit(0);}}
	);
   }
//---------------------------------------------------------------------------------------------------
   public void actionPerformed(ActionEvent ae){
     try{
	JButton jb=(JButton)ae.getSource();
	if(jb==add){
		if(key.getText().equals(EMPTY) || value.getText().equals(EMPTY)){
			msg.setText("  Ignored - key or value was empty"); return;
		}
		dht.put(key.getText(),value.getText()); msg.setText("  Value added");
		System.out.println("Current key: "+(String)dht.getCurrentKey()+
				"  Current value: "+(String)dht.getCurrentValue());
	}
	else if(jb==find){
		if(key.getText().equals(EMPTY)){
			msg.setText("  Ignored - key was empty"); return;
		}
		value.setText(EMPTY);
		Object obj=dht.get(key.getText());
		if(obj==null)msg.setText("  Not found");
		else {
			msg.setText("  Value found : "+(String)obj);
			System.out.println("Current key: "+(String)dht.getCurrentKey()+
				"  Current value: "+(String)dht.getCurrentValue());
		}
	}
	else if(jb==current){
		System.out.println("Current key: "+(String)dht.getCurrentKey()+
				"  Current value: "+(String)dht.getCurrentValue());
	}
	else if(jb==next){
		value.setText(EMPTY);
		Object obj=dht.getNext();
		if(obj==null)msg.setText("  Not found");
		else {
			msg.setText("  Next found : "+(String)obj);
			System.out.println("Current key: "+(String)dht.getCurrentKey()+
				"  Current value: "+(String)dht.getCurrentValue());
		}
	}
	else if(jb==delete){ //delete all of one key
		if(key.getText().equals(EMPTY)){
			msg.setText("  Ignored - key was empty"); return;
		}
		Object obj=dht.remove(key.getText());
		if(obj==null)msg.setText("Failed - key not found");
		else msg.setText("Removed : "+(String)obj);
	}
	else if(jb==dcurrent){ //delete the current
		Object obj=dht.removeCurrent();
		if(obj==null)msg.setText("Failed - current not removed");
		else {
			msg.setText("Removed : "+(String)obj);
			System.out.println("Current key: "+(String)dht.getCurrentKey()+
				"  Current value: "+(String)dht.getCurrentValue());
		}
	}
	else if(jb==size){
		msg.setText(" Size : "+dht.size());
	}
	else if(jb==clear){
		dht.clear(); msg.setText(" Files deleted");
	}
	else if(jb==deleteall){
		dht.deleteTable(); msg.setText(" Files and directories deleted");
	}
	else if(jb==list){
		Enumeration e=dht.keys(); Enumeration v=dht.elements(); String s1,s2;
		while(e.hasMoreElements()){
			s1=(String)e.nextElement(); s2=(String)v.nextElement();
			System.out.println("Key: "+s1+"  Value: "+s2);
		}
/*
		while((s=(String)e.nextElement())!=null)System.out.println(s); //Alternative way to list
*/
		System.out.println("End of listing");
	}
	else if(jb==isempty){
		if(dht.isEmpty())msg.setText(" Is Empty"); else msg.setText(" Is not empty");
	}
     }catch(IOException e){System.out.println("******* IO Exception ********");}
   }
//---------------------------------------------------------------------------------------------------
   public static void main (String args[]){new TestDuplicate();
   }
}
//===================================================================================================
