/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.hashstore;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.util.Enumeration;

public class DiskHashtable {
    static final int DEPTH = 4;
    static final int NOTSET = -1;
    private static final int DELETE_FILES = 0;
    private static final int DELETE_ALL = 1;
    private static final int COUNT = 2;
    static final int KEYS = 0;
    static final int ELEMENTS = 1;
    private static final String KEY = "Key";
    private static final String DATA = "Data";
    private static final int MOD = 1000000001;
    private static final DecimalFormat df = new DecimalFormat("000000000");
    protected File root;
    protected File keyroot;
    protected File dataroot;
    protected String current;
    protected Object currkey;
    private boolean ready;

    public DiskHashtable(File file) {
        this.root = file;
        this.ready = false;
        this.checkDirs();
    }

    protected void checkDirs() {
        if (this.ready) {
            return;
        }
        DiskHashtable.checkExists(this.root);
        this.keyroot = new File(this.root, KEY);
        DiskHashtable.checkExists(this.keyroot);
        this.dataroot = new File(this.root, DATA);
        DiskHashtable.checkExists(this.dataroot);
        this.ready = true;
    }

    private static boolean checkExists(File file) {
        if (!file.exists()) {
            file.mkdir();
            return false;
        }
        return true;
    }

    public Object put(Object object, Object object2) throws IOException {
        return this.put(object, object2, true);
    }

    protected Object put(Object object, Object object2, boolean bl) throws IOException {
        this.checkDirs();
        if (object2 == null) {
            throw new NullPointerException();
        }
        String string = this.getLocation(object);
        this.noDirectories(string, true);
        File file = null;
        while ((file = new File(this.keyroot, string)).exists()) {
            Object object3;
            if (bl && object.equals(object3 = this.loadObject(file))) {
                File file2 = new File(this.dataroot, string);
                Object object4 = this.loadObject(file2);
                this.saveObject(file2, object2);
                this.current = string;
                this.currkey = object;
                return object4;
            }
            string = this.incName(string, 1);
        }
        this.saveObject(file, object);
        this.saveObject(new File(this.dataroot, string), object2);
        this.current = string;
        this.currkey = object;
        return null;
    }

    public Object get(Object object) throws IOException {
        return this.get(object, false);
    }

    protected Object get(Object object, boolean bl) throws IOException {
        this.checkDirs();
        String string = null;
        if (!bl) {
            string = this.getLocation(object);
            if (this.noDirectories(string, false)) {
                return null;
            }
        } else {
            if (this.current == null) {
                return null;
            }
            string = this.incName(this.current, 1);
            object = this.currkey;
        }
        File file = null;
        while (true) {
            if (!(file = new File(this.keyroot, string)).exists()) {
                this.current = null;
                this.currkey = null;
                return null;
            }
            Object object2 = this.loadObject(file);
            if (object.equals(object2)) {
                this.current = string;
                this.currkey = object;
                return this.loadObject(new File(this.dataroot, string));
            }
            string = this.incName(string, 1);
        }
    }

    protected Object remove(Object object, boolean bl) throws IOException {
        this.checkDirs();
        String string = this.getLocation(object);
        if (this.noDirectories(string, false)) {
            return null;
        }
        File file = null;
        block0: while ((file = new File(this.keyroot, string)).exists()) {
            Object object2 = this.loadObject(file);
            if (object.equals(object2)) {
                File file2 = new File(this.dataroot, string);
                Object object3 = this.loadObject(file2);
                file.delete();
                file2.delete();
                String string2 = string;
                while (true) {
                    if (!(file = new File(this.keyroot, string2 = this.incName(string2, 1))).exists()) {
                        if (!bl) continue block0;
                        return object3;
                    }
                    file.renameTo(new File(this.keyroot, this.incName(string2, -1)));
                    file2 = new File(this.dataroot, string2);
                    file2.renameTo(new File(this.dataroot, this.incName(string2, -1)));
                }
            }
            string = this.incName(string, 1);
        }
        return null;
    }

    public Object remove(Object object) throws IOException {
        return this.remove(object, true);
    }

    private boolean noDirectories(String string, boolean bl) {
        int n = 2;
        while (n < 9) {
            String string2 = string.substring(0, n);
            File file = new File(this.keyroot, string2);
            if (!file.exists()) {
                if (bl) {
                    file.mkdir();
                    File file2 = new File(this.dataroot, string2);
                    file2.mkdir();
                } else {
                    return true;
                }
            }
            n += 3;
        }
        return false;
    }

    public boolean containsKey(Object object) throws IOException {
        return this.get(object) != null;
    }

    public boolean isEmpty() {
        if (!this.ready) {
            return true;
        }
        Enumeration enumeration = this.keys();
        return !enumeration.hasMoreElements();
    }

    public int size() {
        if (!this.ready) {
            return 0;
        }
        return this.goThroughFiles(this.keyroot, 2);
    }

    public Enumeration keys() {
        return new Enumerator(0);
    }

    public Enumeration elements() {
        return new Enumerator(1);
    }

    public synchronized void clear() {
        if (!this.ready) {
            return;
        }
        this.goThroughFiles(this.keyroot, 0);
        this.goThroughFiles(this.dataroot, 0);
    }

    public synchronized void deleteTable() {
        if (!this.ready) {
            return;
        }
        this.goThroughFiles(this.keyroot, 1);
        this.goThroughFiles(this.dataroot, 1);
        this.root.delete();
        this.ready = false;
    }

    private int goThroughFiles(File file, int n) {
        File[] fileArray = file.listFiles();
        int n2 = fileArray.length;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            File file2 = fileArray[n4];
            if (file2.isDirectory()) {
                n3 += this.goThroughFiles(file2, n);
            } else if (n == 2) {
                ++n3;
            } else {
                file2.delete();
            }
            ++n4;
        }
        if (n == 1) {
            file.delete();
        }
        return n3;
    }

    protected String incName(String string, int n) {
        int n2 = string.lastIndexOf(File.separatorChar) + 1;
        int n3 = string.length();
        int n4 = Integer.parseInt(string.substring(n2, n3 - 3)) + n;
        return string.substring(0, n2) + n4 + string.substring(n3 - 3);
    }

    protected String getLocation(Object object) {
        int n = (object.hashCode() & Integer.MAX_VALUE) % 1000000001;
        String string = df.format(n);
        StringBuffer stringBuffer = new StringBuffer(13);
        stringBuffer.append(string.substring(7)).append(File.separator);
        stringBuffer.append(string.substring(5, 7)).append(File.separator);
        stringBuffer.append(string.substring(3, 5)).append(File.separator);
        stringBuffer.append(0);
        stringBuffer.append(string.substring(0, 3));
        return stringBuffer.toString();
    }

    protected void saveObject(File file, Object object) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
        objectOutputStream.writeObject(object);
        objectOutputStream.close();
    }

    protected Object loadObject(File file) throws IOException {
        ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
        Object object = null;
        try {
            object = objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("Class not found");
        }
        objectInputStream.close();
        return object;
    }

    private class Enumerator
    implements Enumeration {
        int type;
        File[][] lists = new File[4][];
        int[] levelcnt = new int[4];

        Enumerator(int n) {
            this.type = n;
            int n2 = 0;
            while (n2 < 4) {
                this.levelcnt[n2] = -1;
                ++n2;
            }
            DiskHashtable.this.checkDirs();
        }

        private File sequenceThroughFiles(File file, int n, boolean bl) throws IOException {
            if (this.levelcnt[n] == -1) {
                this.lists[n] = file.listFiles();
                this.levelcnt[n] = 0;
            }
            if (this.levelcnt[n] == this.lists[n].length) {
                this.levelcnt[n] = -1;
                return null;
            }
            File file2 = this.lists[n][this.levelcnt[n]];
            if (file2.isDirectory()) {
                File file3 = null;
                while ((file3 = this.sequenceThroughFiles(file2, n + 1, bl)) == null) {
                    int n2 = n;
                    this.levelcnt[n2] = this.levelcnt[n2] + 1;
                    if (this.levelcnt[n] == this.lists[n].length) {
                        this.levelcnt[n] = -1;
                        return null;
                    }
                    file2 = this.lists[n][this.levelcnt[n]];
                }
                return file3;
            }
            if (!bl) {
                int n3 = n;
                this.levelcnt[n3] = this.levelcnt[n3] + 1;
            }
            return file2;
        }

        public boolean hasMoreElements() {
            try {
                File file = this.sequenceThroughFiles(this.type == 0 ? DiskHashtable.this.keyroot : DiskHashtable.this.dataroot, 0, true);
                if (file == null) {
                    return false;
                }
            }
            catch (IOException iOException) {
                return false;
            }
            return true;
        }

        public Object nextElement() {
            try {
                File file = this.sequenceThroughFiles(this.type == 0 ? DiskHashtable.this.keyroot : DiskHashtable.this.dataroot, 0, false);
                if (file == null) {
                    return null;
                }
                return DiskHashtable.this.loadObject(file);
            }
            catch (IOException iOException) {
                return null;
            }
        }
    }
}

