/*
   Sorted List ADT Header File
   Anthony Smith
   CS 3100 - Cunnigham
   Spring 2002
*/

#include "sorteddata.h"

// List Node (item with pointers)
struct ListNode;
  
// pointer to a List Node
typedef ListNode* ptr;


class SortedListClass{
public:
   // constructors and destructor
   SortedListClass();
   ~SortedListClass();

   // List Operations:

   /*
      empty()
      Function to determine wether or not list is empty
      Input:  none.
      Output:  true if list is empty, false if list is not empty.
   */
   bool empty();

   /*
      full()
      Function to determine wether the list has run out of
      allocatable memory.
      Input:  none.
      Output:  true if list is full, false if list has space for more items.
   */
   bool full();
   
   /*
      Insert()
      Function to Insert a data item into the list.  Sort is executed on insert.
      Input:  item to insert.
      Output:  true is item has been inserted into the list.
      Misc:  "Current" pointer points to the item just inserted at the end of
             the function run.
   */
   bool Insert(valuetype value);
   
   /*
      Retrieve()
      Function to retrieve a data item from the list.
      Input:  none.
      Output:  item retrieved from pointer position "Current".
   */
   valuetype Retrieve();
   
   /*
      DeleteNode()
      Function to delete a data item from the list.
      Input:  none.
      Output:  true if the node at "Current" has been deleted, false if it has
               not been deleted or there is nothing to delete.
   */
   bool DeleteNode();
   
   /*
      FindKey()
      Function to Find an item by key value in the list.
      Input:  key value that is being searched for.
      Output:  true if item is found, false if item is not found.
      Misc:  "Current" pointer points to item that is found, if it is found.
   */
   bool FindKey(valuetype key);
   

   /*
      FindFirst()
      Function to set "Current" pointer to front of list.
      Input:  none.
      Output:  "Current" pointer has been set to the front of the list
               (smallest key value).
   */
   bool FindFirst();

   /*
      FindLast()
      Function to set "Current" pointer to end of list.
      Input:  none.
      Output:  "Current" pointer has been set to the end of the list
               (largest key value).
   */
   bool FindLast();
   
   /*
      Size()
      Function to return size of list.
      Input:  none.
      Output:  size of list (integer).
   */
   int Size();

private:
   // Pointers to First item, Last item, and Current Item
   ptr Last, First, Current;

   // Size of List
   int ListSize;

};  // end class
// End of header file.



