/*
   Sorted List ADT Implementation File
   Anthony Smith
   CS 3100 - Cunningham
   Spring 2002
*/

#include <stddef.h>
#include "sortedlist.h"

struct ListNode{
   ptr Prev, Next;
   valuetype data;
};


SortedListClass::SortedListClass()
{
   ListSize = 0;
   Last = NULL;
   First = NULL;
   Current = NULL;
}

SortedListClass::~SortedListClass()
{
   while(ListSize != 0)
   {
   FindLast();
   DeleteNode();
   }
   delete Last;
   delete First;
   delete Current;
}


bool SortedListClass::empty()
{
   if(ListSize == 0)
   return true;
   else
   return false;
}

bool SortedListClass::DeleteNode()
{
   if(Current == NULL)
   return false;
   
   else if(Current == Last && Current != First)
   {
      ptr Temp = Current;  
      Temp->Prev->Next = NULL;
      Last = Temp->Prev;
      Current = Temp->Prev;
      Temp->Prev = NULL;
      delete Temp;
   }
   
   else if(Current == First && Current != Last)
   {
      ptr Temp = Current;
      
      Temp->Next->Prev = NULL;
      First = Temp->Next;
      Current = Temp->Next;
      Temp->Next=NULL;
      delete Temp;
   }
   
   else if(Current == First && Current == Last)
   {
      ptr Temp = Current;
      First = NULL;
      Last = NULL;
      Current = NULL;
      delete Temp;
   }

   else
   {
      ptr Temp = Current;
      
      Temp->Prev->Next = Temp->Next;
      Temp->Next->Prev = Temp->Prev;
      Current = Temp->Next;
      Temp->Next = NULL;
      Temp->Prev = NULL;
      delete Temp;
   }
   
   ListSize--;
   return true;
}

bool SortedListClass::full()
{
   ptr Temp = new ListNode;
   
   if(Temp == NULL)
   {
   delete Temp;
   return true;
   }
   
   else
   {
   delete Temp;
   return false;   
   }
}

bool SortedListClass::FindFirst()
{
   if(First != NULL)
   {
   Current = First;
   return true;
   }
   else
   return false;
}

bool SortedListClass::FindLast()
{
   if(Last != NULL)
   {
   Current = Last;
   return true;
   }
   else
   return false;
}

int SortedListClass::Size()
{
   return ListSize;
}

bool SortedListClass::FindKey(valuetype key)
{
   FindFirst();

   while(Current != Last)
   {
   if(key.key() == Current->data.key())
   return true;
   else
   Current = Current->Next;
   }
   
   if(Current == Last)
   {
   if(key.key() == Current->data.key())
   return true;
   else
   return false;
   }

   return false;
}

valuetype SortedListClass::Retrieve()
{
   return Current->data;
}

bool SortedListClass::Insert(valuetype value)
{

   // Place Item in empty list
   if(First == NULL)
   {
      ptr NewNode = new ListNode;
      //cout << "Inserting into EMPTY list..." << endl;    debug line
      First = NewNode;
      Last = NewNode;
      Current = NewNode;
      Current->data = value;
      ListSize++;
   }

   // Place Item at new front of list
   else if(value.key() <= (First->data.key()))
   {
      ptr NewNode = new ListNode;
      //cout << "Inserting at new FRONT of list..." << endl;    debug line
      NewNode->Prev = NULL;
      NewNode->Next = First;
      First->Prev = NewNode;
      Current = NewNode;
      First = NewNode;
      Current->data = value;
      ListSize++;
   }

   // Place Item at new end of List
   else if(value.key() > (Last->data.key()))
   {
      ptr NewNode = new ListNode;
      //cout << "Inserting at new END of list..." << endl;  debug line
      NewNode->Next = NULL;
      NewNode->Prev = Last;
      Last->Next = NewNode;
      Last = NewNode;
      Current = NewNode;
      Current->data = value;
      ListSize++;
   }

   //Place Item in middle of List
   else
   {
      Current = First->Next;
      bool inserted = false;
      while(!inserted)
      {
         //Insert Before Current Item
         if(Current->data.key() >= value.key())
         {
         ptr NewNode = new ListNode;
         //cout << "Inserting in MIDDLE of list..." << endl;  debug line
         NewNode->Next = Current;
         NewNode->Prev = Current->Prev;
         Current->Prev->Next = NewNode;
         Current->Prev = NewNode;
         Current = NewNode;
         Current->data = value;
         ListSize++;

         inserted = true;
         }

         //Move to Next Item
         else
         {
         Current=Current->Next;
         }
      }
   }

   return true;
}

