/*
  Test Program for Sorted List Class
  Anthony Smith
  CS 3100 - Cunningham
  Spring 2002
*/

/*
  This program uses the Sorted List Class to keep track of a Doctor's office.
  The program allows you to insert people as they come into the office and then
  remove them from the list of waiting patients when they are served.
*/




#include <iostream.h>
#include "sortedlist.h"
#include <string>

/*
  Function to Print Exiting Message
  Input:  none.
  Output:  message written to the screen.
*/
void Exit(void)
{
   cout << endl <<"Thank you for using Doctor's Scheduling Assistant!" << endl;
   cout << "Have a nice day!"  << endl << endl;
}

/*
  Function to Print Introduction Message
  Input:  none.
  Output:  Instructions and hello message written to the screen.
*/
void Intro(void)
{
   cout << "Welcome to Doctor's Scheduling Assistant!"  << endl;
   cout << "Please format commands in the form:  command first last time";
   cout << endl << "All times will be entered in Military Time" << endl << endl;
   cout << "Begin..." << endl << endl;
}


/*
  Main Program
*/
int main(void)
{
   SortedListClass Schedule;                      //Instantiation of List Class
   valuetype record;                              //data item
   string command;                                //string for commands
   Intro();


   //When command "quit" is given, loop ends
   while(command != "quit")
   {
      cin >> command;

      /*
        Arrive
        Inserts patient into the list and echoes the information to the
        screen.
      */
      if(command == "arrive")
      {
      cin >> record.FirstName >> record.LastName >> record.AppointmentTime;
      Schedule.Insert(record);
      cout << "Inserting " << record.FirstName << " " << record.LastName
              << " at " << record.key() << endl;
      }

      /*
        Serve
        Retrieves then deletes a patient from list, simulating the patient
        being seen by the doctor.  Patient's name is written to the screen
        as well as his/her appointment time.
      */
      else if(command == "serve")
      {
      Schedule.FindFirst();
      record = Schedule.Retrieve();
         if(!Schedule.empty())
         {
         cout << "Serving " << record.FirstName << " " << record.LastName
              << " at " << record.key() << endl;
         Schedule.DeleteNode();
         }
         else
         cout << "No one to serve!"  << endl;
      }
   }

   Exit();

   return 0;
}

/*
  End of Program
*/
