VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "NetBios"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
    Option Explicit

    'NETBIOS Class
    '
    'orginal code was a simple module file
    'with no enumeration. Author is unknown.
    '
    'Updated and turned into a DOM by Jon
    'Lennart Nerg, Zap software
    '
    'For more great stuff, visit:
    '
    'http://www.angelfire.com/geek/ZapSoft/
    '
    '
    '

    Private Const MAX_HOSTNAME_LEN = 132
    Private Const MAX_DOMAIN_NAME_LEN = 132
    Private Const MAX_SCOPE_ID_LEN = 260
    Private Const MAX_ADAPTER_NAME_LENGTH = 260
    Private Const MAX_ADAPTER_ADDRESS_LENGTH = 8
    Private Const MAX_ADAPTER_DESCRIPTION_LENGTH = 132
    Private Const ERROR_BUFFER_OVERFLOW = 111
    Private Const MIB_IF_TYPE_ETHERNET = 1
    Private Const MIB_IF_TYPE_TOKENRING = 2
    Private Const MIB_IF_TYPE_FDDI = 3
    Private Const MIB_IF_TYPE_PPP = 4
    Private Const MIB_IF_TYPE_LOOPBACK = 5
    Private Const MIB_IF_TYPE_SLIP = 6

    Private Type IP_ADDR_STRING
        Next As Long
        IpAddress As String * 16
        IpMask As String * 16
        Context As Long
    End Type

    Private Type IP_ADAPTER_INFO
        Next As Long
        ComboIndex As Long
        AdapterName As String * MAX_ADAPTER_NAME_LENGTH
        Description As String * MAX_ADAPTER_DESCRIPTION_LENGTH
        AddressLength As Long
        Address(MAX_ADAPTER_ADDRESS_LENGTH - 1) As Byte
        Index As Long
        Type As Long
        DhcpEnabled As Long
        CurrentIpAddress As Long
        IpAddressList As IP_ADDR_STRING
        GatewayList As IP_ADDR_STRING
        DhcpServer As IP_ADDR_STRING
        HaveWins As Boolean
        PrimaryWinsServer As IP_ADDR_STRING
        SecondaryWinsServer As IP_ADDR_STRING
        LeaseObtained As Long
        LeaseExpires As Long
    End Type

    Private Type FIXED_INFO
        HostName As String * MAX_HOSTNAME_LEN
        DomainName As String * MAX_DOMAIN_NAME_LEN
        CurrentDnsServer As Long
        DnsServerList As IP_ADDR_STRING
        NodeType As Long
        ScopeId  As String * MAX_SCOPE_ID_LEN
        EnableRouting As Long
        EnableProxy As Long
        EnableDns As Long
    End Type

    Private Declare Function GetNetworkParams Lib "IPHlpApi" (FixedInfo As Any, pOutBufLen As Long) As Long
    Private Declare Function GetAdaptersInfo Lib "IPHlpApi" (IpAdapterInfo As Any, pOutBufLen As Long) As Long
    Private Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (Destination As Any, Source As Any, ByVal Length As Long)

    Private Objects As New Collection
    Public Properties As New NetGlobals

    Private Sub Class_Initialize()
        On Local Error Resume Next
        Call Clear
        Call Refresh
    End Sub

    Private Sub Class_Terminate()
        On Local Error Resume Next
        Call Clear
        Set Objects = Nothing
    End Sub

    Public Sub Clear()
        On Local Error Resume Next
        While Objects.Count <> 0
            Objects.Remove Objects.Count
            DoEvents
        Wend
    End Sub

    Public Property Get Count() As Long
        On Local Error Resume Next
        Let Count = Objects.Count
    End Property

    Public Property Get Adapter(ByVal Index As Long) As NetAdapter
        On Local Error Resume Next
        Set Adapter = Objects(Index)
    End Property

    Public Sub Refresh()
        On Local Error Resume Next
        Call Clear
        Call QueryBios
    End Sub

    Private Function CreateAdapter() As NetAdapter
        On Local Error Resume Next
        Dim Obj As NetAdapter
        Set Obj = New NetAdapter
        Objects.Add Obj
        Set CreateAdapter = Obj
    End Function


    Private Sub QueryBios()
        On Local Error Resume Next
        Dim error As Long
        Dim FixedInfoSize As Long
        Dim AdapterInfoSize As Long
        Dim i As Integer
        Dim PhysicalAddress  As String
        Dim NewTime As Date
        Dim AdapterInfo As IP_ADAPTER_INFO
        Dim Adapt As IP_ADAPTER_INFO
        Dim AddrStr As IP_ADDR_STRING
        Dim FixedInfo As FIXED_INFO
        Dim Buffer As IP_ADDR_STRING
        Dim pAddrStr As Long
        Dim pAdapt As Long
        Dim Buffer2 As IP_ADAPTER_INFO
        Dim FixedInfoBuffer() As Byte
        Dim AdapterInfoBuffer() As Byte
        
        'Get the main IP configuration information for this machine using a FIXED_INFO structure
        Let FixedInfoSize = 0
        Let error = GetNetworkParams(ByVal 0&, FixedInfoSize)
        If error <> 0 Then
            If error <> ERROR_BUFFER_OVERFLOW Then Exit Sub
        End If
        Err.Clear
        
        ReDim FixedInfoBuffer(FixedInfoSize - 1)
        Let error = GetNetworkParams(FixedInfoBuffer(0), FixedInfoSize)
        If error <> 0 Then Exit Sub
        
        CopyMemory FixedInfo, FixedInfoBuffer(0), Len(FixedInfo)
        Call Properties.Create("HOST NAME", FixedInfo.HostName)
        Call Properties.Create("DNS SERVERS", FixedInfo.DnsServerList.IpAddress)
        
        Let pAddrStr = FixedInfo.DnsServerList.Next
        Do While pAddrStr <> 0
            CopyMemory Buffer, ByVal pAddrStr, Len(Buffer)
            Call Properties.Create("DNS SERVER", Buffer.IpAddress)
            pAddrStr = Buffer.Next
            DoEvents
        Loop
        
        Select Case FixedInfo.NodeType
            Case 1: Call Properties.Create("NODE TYPE", "BROADCAST")
            Case 2: Call Properties.Create("NODE TYPE", "PEER TO PEER")
            Case 4: Call Properties.Create("NODE TYPE", "MIXED")
            Case 8: Call Properties.Create("NODE TYPE", "HYBRID")
            Case Else: Call Properties.Create("NODE TYPE", "")
        End Select
        
        Call Properties.Create("NETBIOS SCOPE ID", FixedInfo.ScopeId)
        If FixedInfo.EnableRouting Then
            Call Properties.Create("IP ROUTING", "ENABLED")
        Else
            Call Properties.Create("IP ROUTING", "DISABLED")
        End If
        
        If FixedInfo.EnableProxy Then
            Call Properties.Create("WINS PROXY", "ENABLED")
        Else
            Call Properties.Create("WIND PROXY", "DISABLED")
        End If
        
        If FixedInfo.EnableDns Then
            Call Properties.Create("NETBIOS RESOLUTION", "DNS")
        Else
            Call Properties.Create("NETBIOS RESOLUTION", "NO DNS")
        End If

        'Enumerate all of the adapter specific information using the IP_ADAPTER_INFO structure.
        'Note:  IP_ADAPTER_INFO contains a linked list of adapter entries.
        
        AdapterInfoSize = 0
        Let error = GetAdaptersInfo(ByVal 0&, AdapterInfoSize)
        If error <> 0 Then
            If error <> ERROR_BUFFER_OVERFLOW Then
               MsgBox "GetAdaptersInfo sizing failed with error " & error
               Exit Sub
            End If
        End If
        ReDim AdapterInfoBuffer(AdapterInfoSize - 1)
     
        'Get actual adapter information
        Let error = GetAdaptersInfo(AdapterInfoBuffer(0), AdapterInfoSize)
        If error <> 0 Then
            MsgBox "GetAdaptersInfo failed with error " & error
            Exit Sub
        End If
        CopyMemory AdapterInfo, AdapterInfoBuffer(0), Len(AdapterInfo)
        pAdapt = AdapterInfo.Next

    
        Do While pAdapt <> 0
            Dim Obj As NetAdapter
            Set Obj = CreateAdapter
            If Obj Is Nothing Then Exit Do
            
            CopyMemory Buffer2, AdapterInfo, Len(Buffer2)
            
            Select Case Buffer2.Type
                Case MIB_IF_TYPE_ETHERNET: Call Obj.Create("ADAPTER", "ETHERNET")
                Case MIB_IF_TYPE_TOKENRING: Call Obj.Create("ADAPTER", "TOKEN-RING")
                Case MIB_IF_TYPE_FDDI: Call Obj.Create("ADAPTER", "FDDI")
                Case MIB_IF_TYPE_PPP: Call Obj.Create("ADAPTER", "PPP")
                Case MIB_IF_TYPE_LOOPBACK: Call Obj.Create("ADAPTER", "LOOPBACK")
                Case MIB_IF_TYPE_SLIP: Call Obj.Create("ADAPTER", "SLIP")
                Case Else: Call Obj.Create("ADAPTER", "")
            End Select
            
            Call Obj.Create("ADAPTER NAME", Buffer2.AdapterName)
            Call Obj.Create("ADAPTER DESCRIPTION", Buffer2.Description)
    
            For i = 0 To Buffer2.AddressLength - 1
                PhysicalAddress = PhysicalAddress & Hex(Buffer2.Address(i))
                If i < Buffer2.AddressLength - 1 Then PhysicalAddress = PhysicalAddress & "-"
                DoEvents
            Next
            
            Call Obj.Create("PHYSICAL ADDR", PhysicalAddress)
            If Buffer2.DhcpEnabled Then
                Call Obj.Create("DHCP", "ENABLED")
            Else
                Call Obj.Create("DHCP", "DISABLED")
            End If
        
            pAddrStr = Buffer2.IpAddressList.Next
            Do While pAddrStr <> 0
                CopyMemory Buffer, Buffer2.IpAddressList, LenB(Buffer)
                Call Obj.Create("IP", Buffer.IpAddress)
                Call Obj.Create("SUBNET MASK", Buffer.IpMask)
                Let pAddrStr = Buffer.Next
                If pAddrStr <> 0 Then CopyMemory Buffer2.IpAddressList, ByVal pAddrStr, Len(Buffer2.IpAddressList)
                DoEvents
            Loop
            
            Call Obj.Create("DEFAULT GATEWAY", Buffer2.GatewayList.IpAddress)
    
            Let pAddrStr = Buffer2.GatewayList.Next
            Do While pAddrStr <> 0
                CopyMemory Buffer, Buffer2.GatewayList, Len(Buffer)
                Call Obj.Create("IP ADDRESS", Buffer.IpAddress)
    
                pAddrStr = Buffer.Next
                If pAddrStr <> 0 Then CopyMemory Buffer2.GatewayList, ByVal pAddrStr, Len(Buffer2.GatewayList)
                DoEvents
            Loop
    
            Call Obj.Create("DHCP SERVER", Buffer2.DhcpServer.IpAddress)
            Call Obj.Create("PRIMARY WINS SERVER", Buffer2.PrimaryWinsServer.IpAddress)
            Call Obj.Create("SECONDARY WINS SERVER", Buffer2.SecondaryWinsServer.IpAddress)
    
            Let NewTime = CDate(Adapt.LeaseObtained)
            Call Obj.Create("LEASE OBTAINED", CStr(NewTime))
        
            Let NewTime = CDate(Adapt.LeaseExpires)
            Call Obj.Create("LEASE EXPIRES", CStr(NewTime))
            
            pAdapt = Buffer2.Next
            If pAdapt <> 0 Then
                CopyMemory AdapterInfo, ByVal pAdapt, Len(AdapterInfo)
            End If
            DoEvents
        Loop
    End Sub
