--Package Nmodem
--     by Scott Stinson
--     7/24/04
--
--     This package is modified from Andre LaMothe's
--     nlink program on page 556 of Trick's of the Game
--     Programming Gurus.  The purpose of this program
--     is to allow 2 computers running DOS to communicate
--     via the null modem cable.

with Interfaces; use Interfaces;  --This is for Hex numbers
with System;
with DJGPP_Library;

package Nmodem is
   subtype Interrupt_Handler is System.Address;
   --The one in Ada.Interrupts won't do because of
   --compilation errors.

   SER_RBF : constant Unsigned_16 := 16#0#;  --RecieveBuffer
   SER_THR : constant Unsigned_16 := 16#0#;  --TransmitHold
   SER_IER : constant Unsigned_16 := 16#1#;  --InterruptEnable
   SER_IIR : constant Unsigned_16 := 16#2#;  --InterruptIdentify
   SER_LCR : constant Unsigned_16 := 16#3#;  --LineControl
   SER_MCR : constant Unsigned_16 := 16#4#;  --ModemControl
   SER_LSR : constant Unsigned_16 := 16#5#;  --LineStatus
   SER_MSR : constant Unsigned_16 := 16#6#;  --ModemStatus
   SER_DLL : constant Unsigned_16 := 16#0#;  --DivisorLatchLeastsig
   SER_DLM : constant Unsigned_16 := 16#1#;  --DivisorLatchMostsig

   SER_BAUD_1200 : constant Unsigned_8 := 16#60#;
   SER_BAUD_2400 : constant Unsigned_8 := 16#30#;
   SER_BAUD_9600 : constant Unsigned_8 := 16#C#;
   SER_BAUD_19200 : constant Unsigned_8 := 16#6#;

   SER_GP02 : constant Unsigned_8 := 16#8#;

   COM_1 : constant Unsigned_16 := 16#3F8#;
   COM_2 : constant Unsigned_16 := 16#2F8#;

   SER_STOP_1 : constant Unsigned_8 := 16#0#;
   SER_STOP_2 : constant Unsigned_8 := 16#4#;

   SER_BITS_5 : constant Unsigned_8 := 16#0#;
   SER_BITS_6 : constant Unsigned_8 := 16#1#;
   SER_BITS_7 : constant Unsigned_8 := 16#2#;
   SER_BITS_8 : constant Unsigned_8 := 16#3#;

   SER_PARITY_NONE : constant Unsigned_8 := 16#0#;
   SER_PARITY_ODD : constant Unsigned_8 := 16#8#;
   SER_PARITY_EVEN : constant Unsigned_8 := 16#18#;

   SER_DIV_LATCH_ON : constant Unsigned_8 := 16#80#;

   PIC_IMR : constant Unsigned_16 := 16#21#;  --Interrupt Mask
   PIC_ICR : constant Unsigned_16 := 16#20#;  --Interrupt Control

   INT_SER_PORT_0 : constant Unsigned_8 := 16#0C#;  --For com1
   INT_SER_PORT_1 : constant Unsigned_8 := 16#0B#;

   SERIAL_BUFFER_SIZE : constant Integer := 128;

   Old_ISR : Interrupt_Handler;

   Ser_Buffer : array(0..SERIAL_BUFFER_SIZE) of Unsigned_8;

   Ser_End : Integer := -1;
   Ser_Start : Integer := -1;

   Ser_Ch : Unsigned_8;
   Char_Ready : Integer := 0;

   Old_Int_Mask : Unsigned_8;

   Open_Port : Unsigned_16;
   Serial_Lock : Integer := 0;


----------------------------------------------------------
-- Procedures and Functions for the nmodem package below -
----------------------------------------------------------
   Procedure Serial_ISR;
   Function Ready_Serial return Integer;
   Function Serial_Read return Unsigned_8;
   Procedure Serial_Write(ch : Unsigned_8);
   Procedure Open_Serial(port_base:Unsigned_16; baud:Unsigned_8; configuration:Unsigned_8);
   Procedure Close_Serial(port_base:Unsigned_16);

end Nmodem;
