with Nmodem; use Nmodem;
with Interfaces; use Interfaces;
with System.Bit_Ops; use System.Bit_Ops;
with Ada.Text_IO; use Ada.Text_IO;
with Ada.Unchecked_Conversion;
with Multi_keys; use Multi_keys;

procedure Main is
  Or_Result : Unsigned_8;
  Or_Result1 : Unsigned_8;
  Function Byte_To_Char is new Ada.Unchecked_Conversion(Source=>Unsigned_8,
           Target=>Character);
  Function Char_To_Byte is new Ada.Unchecked_Conversion(Source=>Character,
           Target=>Unsigned_8);

  Ch:Character;
  Done:Integer := 0;
  
begin
  Put("Welcome to the null modem communication program.");
  New_Line;

  Bit_Or(SER_PARITY_NONE'address, 8, SER_BITS_8'address, 8, Or_Result'address);
  Bit_Or(Or_Result'address, 8, SER_STOP_1'address,8, Or_Result1'address);
  Open_Serial(COM_1, SER_BAUD_9600, Or_Result1);

  Multi_Keys.Install;

  while (done = 0) loop
    --Check to see if a key is pressed
    for index in 0..127 loop
       if (Strike_1(index)) then
          Ch := Key_ASCII(index,False);
          Put(Ch);
          Serial_Write(Char_To_Byte(Ch));

          if (Char_To_Byte(Ch) = 16#1b#) then
             done := 1;
          end if;
       end if;
    end loop;
--     end if;  --End of is a key pressed?

     if (Ready_Serial>0) then
        ch := Byte_To_Char(Serial_Read);
        Put(ch);
     end if;

     if (Char_To_Byte(ch) = 16#1b#) then
        Put("Remote machine is closing.");
        New_Line;
        done := 1;
     end if;

  end loop;

  Multi_Keys.Uninstall;

end Main;
