with SDL.Types; use SDL.Types;
with SDL.Video;

Package SDL_GfxPrimitives
is

   --December 27,2005
   --by Scott Stinson
   --Let's get this converted to Ada95, a better language than Pascal
   SDL_GFXPRIMITIVES_MAJOR : constant := 2;
   SDL_GFXPRIMITIVES_MINOR : constant := 0;
   SDL_GFXPRIMITIVES_MICRO : constant := 13;


   --Pixel}
   Function pixelColor(dst: SDL.Video.Surface_ptr; x, y : Sint16; color : Uint32) return Integer;
   pragma Import (C, PixelColor, "pixelColor");

   Function pixelRGBA(dst: SDL.Video.Surface_ptr; x, y : Sint16; r,g,b,a : Uint8) return Integer;
   pragma Import (C, PixelRGBA, "pixelRGBA");

   --Horizontal Line}
   Function hlineColor(dst:SDL.Video.Surface_ptr; x1,x2,y: Sint16; color: Uint32) return Integer;
   pragma Import (C, HlineColor, "hlineColor");

   Function hlineRGBA(dst : SDL.Video.Surface_ptr; x1,x2,y: Sint16; r,g,b,a:Uint8) return Integer;
   pragma Import (C, HlineRGBA, "hlineRGBA");

   --Vertical Line}
   Function vlineColor(dst : SDL.Video.Surface_ptr;x,y1,y2:SInt16; color:UInt32) return Integer;
   pragma Import (C, VlineColor, "vlineColor");

   Function vlineRGBA(dst : SDL.Video.Surface_ptr;x,y1,y2:SInt16;r,g,b,a:UInt8) return Integer;
   pragma Import (C, VlineRGBA, "vlineRGBA");

   --Rectangle}
   Function rectangleColor(dst : SDL.Video.Surface_ptr;x1,y1,x2,y2:Sint16;color:Uint32) return Integer;
   pragma Import (C, RectangleColor, "rectangleColor");

   Function rectangleRGBA(dst : SDL.Video.Surface_ptr;x1,y1,x2,y2: Sint16;color:Uint32) return Integer;
   pragma Import (C, RectangleRGBA, "rectangleRGBA");

   --Filled rectangle 'Box'}
   Function boxColor(dst : SDL.Video.Surface_ptr;x1,y1,x2,y2:Sint16;color:Uint32) return Integer;
   pragma Import (C, BoxColor, "boxColor");

   Function boxRGBA(dst: SDL.Video.Surface_ptr;x1,y1,x2,y2:Sint16;r,g,b,a:Uint8) return Integer;
   pragma Import (C, BoxRGBA, "boxRGBA");

   --Line}
   Function lineColor(dst : SDL.Video.Surface_ptr;x1,y1,x2,y2:Sint16;color:Uint32) return Integer;
   pragma Import (C, LineColor, "lineColor");

   Function lineRGBA(dst : SDL.Video.Surface_ptr;x1,y1,x2,y2:Sint16;r,g,b,a:Uint8) return Integer;
   pragma Import (C, LineRGBA, "lineRGBA");

   --AALine}
   Function aalineColor(dst : SDL.Video.Surface_ptr;x1,y1,x2,y2:Sint16;color:Uint32) return Integer;
   pragma Import (C, AalineColor, "aalineColor");

   Function aalineRGBA(dst : SDL.Video.Surface_ptr;x1,y1,x2,y2:Sint16;r,g,b,a:Uint8) return Integer;
   pragma Import (C, AalineRGBA, "aalineRGBA");

   --Circle}
   Function circleColor(dst : SDL.Video.Surface_ptr;x,y,r:Sint16;color:Uint32) return Integer;
   pragma Import (C, CircleColor, "circleColor");

   Function circleRGBA(dst : SDL.Video.Surface_ptr;x,y,rad:Sint16;r,g,b,a:Uint8) return Integer;
   pragma Import (C, CircleRGBA, "circleRGBA");

   Function aacircleColor(dst : SDL.Video.Surface_ptr;x,y,r:Sint16;color:Uint32) return Integer;
   pragma Import (C, AacircleColor, "aacircleColor");

   Function aacircleRGBA(dst : SDL.Video.Surface_ptr;x,y,rad:Sint16;r,g,b,a:Uint8) return Integer;
   pragma Import (C, AacircleRGBA, "aacircleRGBA");

   --Filled Circle}
   Function filledcircleColor(dst : SDL.Video.Surface_ptr;x,y,r:Sint16;color:Uint32) return Integer;
   pragma Import (C, FilledCircleColor, "filledCircleColor");

   Function filledcircleRGBA(dst : SDL.Video.Surface_ptr;x,y,rad:Sint16;r,g,b,a:Uint8) return Integer;
   pragma Import (C, FilledCircleRGBA, "filledCircleRGBA");

   --Ellipse}
   Function ellipseColor(dst : SDL.Video.Surface_ptr;x,y,rx,ry:Sint16;color:Uint32) return Integer;
   pragma Import (C, EllipseColor, "ellipseColor");

   Function ellipseRGBA(dst : SDL.Video.Surface_ptr;x,y,rx,ry:Sint16;r,g,b,a:Uint8) return Integer;
   pragma Import (C, EllipseRGBA, "ellipseRGBA");

   --AA Ellipse}
   Function aaellipseColor(dst : SDL.Video.Surface_ptr;x,y,rx,ry:Sint16;color:Uint32) return Integer;
   pragma Import (C, AaellipseColor, "aaellipseColor");

   Function aaellipseRGBA(dst : SDL.Video.Surface_ptr;x,y,rx,ry:Sint16;r,g,b,a:Uint8) return Integer;
   pragma Import (C, AaellipseRGBA, "aaellipseRGBA");

   --Filled Ellipse}
   Function filledellipseColor(dst : SDL.Video.Surface_ptr;x,y,rx,ry:Sint16;color:Uint32) return Integer;
   pragma Import (C, FilledEllipseColor, "filledEllipseColor");

   Function filledellipseRGBA(dst : SDL.Video.Surface_ptr;x,y,rx,ry:Sint16;r,g,b,a:Uint8) return Integer;
   pragma Import (C, FilledEllipseRGBA, "filledEllipseRGBA");

   --define CLOCKWISE; from C code}
   --Pie}
   Function pieColor(dst : SDL.Video.Surface_ptr;x,y,rad,start,eend:Sint16;color:Uint32) return Integer;
   pragma Import (C, PieColor, "pieColor");

   Function pieRGBA(dst : SDL.Video.Surface_ptr;x,y,rad,start,eend:Sint16;r,g,b,a:Uint8) return Integer;
   pragma Import (C, PieRGBA, "pieRGBA");

   --Filled Pie}
   Function filledpieColor(dst : SDL.Video.Surface_ptr;x,y,rad,start,eend:Sint16;color:Uint32) return Integer;
   pragma Import (C, FilledPieColor, "filledPieColor");

   Function filledpieRGBA(dst : SDL.Video.Surface_ptr;x,y,rad,start,eend:Sint16;r,g,b,a:Uint8) return Integer;
   pragma Import (C, FilledPieRGBA, "filledPieRGBA");

   --Trigon}
   Function trigonColor(dst : SDL.Video.Surface_ptr;x1,y1,x2,y2,x3,y3:Sint16;color:Uint32) return Integer;
   pragma Import (C, TrigonColor, "trigonColor");

   Function trigonRGBA(dst : SDL.Video.Surface_ptr;x1,y1,x2,y2,x3,y3:Sint16;r,g,b,a:Uint8) return Integer;
   pragma Import (C, TrigonRGBA, "trigonRGBA");

   --AA-Trigon}
   Function aatrigonColor(dst : SDL.Video.Surface_ptr;x1,y1,x2,y2,x3,y3:Sint16;color:Uint32) return Integer;
   pragma Import (C, AatrigonColor, "aatrigonColor");

   Function aatrigonRGBA(dst : SDL.Video.Surface_ptr;x1,y1,x2,y2,x3,y3:Sint16;r,g,b,a:Uint8) return Integer;
   pragma Import (C, AatrigonRGBA, "aatrigonRGBA");

   --Filled Trigon}
   Function filledtrigonColor(dst : SDL.Video.Surface_ptr;x1,y1,x2,y2,x3,y3:Sint16;color:Uint32) return Integer;
   pragma Import (C, FilledTrigonColor, "filledTrigonColor");

   Function filledtrigonRGBA(dst : SDL.Video.Surface_ptr;x1,y1,x2,y2,x3,y3:Sint16;r,g,b,a:Uint8) return Integer;
   pragma Import (C, FilledTrigonRGBA, "filledTrigonRGBA");

   --Polygon}
   Function polygonColor(dst : SDL.Video.Surface_ptr;vx,xy:Sint16;n:Integer;color:Uint32) return Integer;
   pragma Import (C, PolygonColor, "polygonColor");

   Function polygonRGBA(dst : SDL.Video.Surface_ptr;vx,vy:Sint16;n:Integer;r,g,b,a:Uint8) return Integer;
   pragma Import (C, PolygonRGBA, "polygonRGBA");

   --AA Polygon}
   Function aapolygonColor(dst : SDL.Video.Surface_ptr;vx,xy:Sint16;n:Integer;color:Uint32) return Integer;
   pragma Import (C, AapolygonColor, "aapolygonColor");

   Function aapolygonRGBA(dst : SDL.Video.Surface_ptr;vx,vy:Sint16;n:Integer;r,g,b,a:Uint8) return Integer;
   pragma Import (C, AapolygonRGBA, "aapolygonRGBA");

   --Filled Polygon}
   Function filledpolygonColor(dst : SDL.Video.Surface_ptr;vx,xy:Sint16;n:Integer;color:Uint32) return Integer;
   pragma Import (C, FilledPolygonColor, "filledPolygonColor");

   Function filledpolygonRGBA(dst : SDL.Video.Surface_ptr;vx,vy:Sint16;n:Integer;r,g,b,a:Uint8) return Integer;
   pragma Import (C, FilledpolygonRGBA, "filledPolygonRGBA");

   --Bezier}
   --s=number of steps}
   Function bezierColor(dst : SDL.Video.Surface_ptr;vx,vy:Sint16;n,s:Integer;color:Uint32) return Integer;
   pragma Import (C, BezierColor, "bezierColor");

   Function bezierRGBA(dst : SDL.Video.Surface_ptr;vx,vy:Sint16;n,s:Integer;r,g,b,a:Uint8) return Integer;
   pragma Import (C, BezierRGBA, "bezierRGBA");

   --Characters and Strings}
   Function characterColor(dst : SDL.Video.Surface_ptr;x,y:Sint16;c:Character;color:Uint32) return Integer;
   pragma Import (C, CharacterColor, "characterColor");

   Function characterRGBA(dst : SDL.Video.Surface_ptr;x,y:Sint16;c:Character;r,g,b,a:Uint8) return Integer;
   pragma Import (C, CharacterRGBA, "characterRGBA");

   Function stringColor(dst : SDL.Video.Surface_ptr;x,y:Sint16;c:access Character;color:Uint32) return Integer;
   pragma Import (C, StringColor, "stringColor");

   Function stringRGBA(dst : SDL.Video.Surface_ptr;x,y:Sint16;c:access Character;r,g,b,a:Uint8) return Integer;
   pragma Import (C, StringRGBA, "stringRGBA");

   Procedure gfxPrimitivesSetFont(cw, ch : Integer);
   pragma Import (C, GfxPrimitivesSetFont, "gfxPrimitivesSetFont");

end SDL_GFXPrimitives;
