package maze;

// Pacman by X5K MaStEr X5K and John
// started September 10, 2001

// we used some code from:
// Warp
// By Karl Hornell, June 10, 1996
// to get us started! Thanks Karl!

import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public final class Pacman extends java.applet.Applet implements Runnable
{

    private static final int P_BUTTON = 112;

    private static final int SPACE_BAR = 32;

    private static final int DOWN_ARROW_BUTTON = 1005;

    private static final int UP_ARROW_BUTTON = 1004;

    private static final int RIGHT_ARROW_BUTTON = 1007;

    private static final int LEFT_ARROW_BUTTON = 1006;

    Graphics gBuf; // used for double-buffered graphics

    Image imgBuf; // also used for double-buffered graphics

    Graphics gBufMaze;

    Image mazeBuf;

    public int PACMAN_SIZE = 36;

    Thread updateThread; // thread in which the game will run

    long startTime;

    // used to keep track of timing and to prevent applet from running too fast

    int x = 0; // x position of pacman

    int dx[] = { 0, 0}; // amount x position will change

    int y = 0; // y position of pacman

    int dy[] = { 0, 0}; // amount y will change

    int curCol; //the column pacman is

    int curRow; //the row pacman is in

    int nextX; // the next position of pacman in pixels= 9 * PACMAN_SIZE;

    int nextY; // = 9 * PACMAN_SIZE;

    int mouthStartAngle = 180; // direction that pacman is pointing

    // This array describes each "cell" of the screen
    // Cells labeled 0 are open and those with a 1 are
    // walls.
    int[][] mazeArray;

    private int SPEED = 12;

    private int MAX_X = 800;

    // PACMAN_SIZE * MAZE_SIZE; // widest the playing screen can be
    private int MAX_Y = 600;

    // PACMAN_SIZE * MAZE_SIZE; // tallest the playing screen can be

    private int xOffset = 0; // used to center screen

    private int yOffset = 0; // used to center screen

    private Maze maze = null;

    private Ghost ghost = new Ghost();

    private int clearGraphics = 2;

    private GameInfo[] gameInfoArray;

    private int gameInfoCount = 0;

    private int pellets = 0;

    private int numPacAnims = 4;

    private int numGhostAnims = 4;

    private Image[] ghostImage = new Image[numGhostAnims];

    private Image[][] pacImage = new Image[numPacAnims][4];

    private int animDirection = 1;

    int deaths = 0;

    int maxDeaths = 6;

    private boolean paused = false;

    class EventHandler implements KeyListener
    {

        /*
         * (non-Javadoc)
         * 
         * @see java.awt.event.KeyListener#keyTyped(java.awt.event.KeyEvent)
         */
        public void keyTyped(KeyEvent e)
        {
            // TODO Auto-generated method stub

        }

        /*
         * (non-Javadoc)
         * 
         * @see java.awt.event.KeyListener#keyPressed(java.awt.event.KeyEvent)
         */
        public void keyPressed(KeyEvent e)
        {
            // TODO Auto-generated method stub
            myKeyDown(e.getKeyCode());

        }

        /*
         * (non-Javadoc)
         * 
         * @see java.awt.event.KeyListener#keyReleased(java.awt.event.KeyEvent)
         */
        public void keyReleased(KeyEvent e)
        {
            // TODO Auto-generated method stub
            //myKeyUp(e.getKeyCode());

        }

    }

    public boolean processMouseEvent(Event e)
    {
        requestFocus();
        return false;
    }

    public void init()
    {
        // Make the applet window the size we want it to be
        resize(MAX_X, MAX_Y);

        // Load the images we will use from the web
        getMainGraphics();

        // Garbage collection call. Not really needed.
        System.gc();

        addKeyListener(new EventHandler());
        // Make a black background
        setBackground(Color.black);

        // Set up double-buffered graphics.
        // This allows us to draw without flickering.
        imgBuf = createImage(MAX_X, MAX_Y);
        gBuf = imgBuf.getGraphics();

        mazeBuf = createImage(MAX_X, MAX_Y);
        gBufMaze = mazeBuf.getGraphics();

        gameInfoArray = new GameInfo[5];
        
        //gameInfoArray[0] = new GameInfo(60, 4, 4, 4, 4, 8, 3);
        //gameInfoArray[1] = new GameInfo(60, 5, 5, 5, 5, 8, 3);
        //gameInfoArray[2] = new GameInfo(60, 6, 6, 6, 6, 8, 3);
        //gameInfoArray[0] = new GameInfo(18, 17, 17, 23, 23, 9, 6);

        gameInfoArray[0] = new GameInfo(60, 6, 6, 8, 8, 8, 3);
        gameInfoArray[1] = new GameInfo(48, 7, 7, 9, 9, 16, 8);
        gameInfoArray[2] = new GameInfo(36, 9, 9, 12, 12, 12, 6);
        gameInfoArray[3] = new GameInfo(24, 13, 13, 17, 17, 8, 6);
        gameInfoArray[4] = new GameInfo(18, 17, 17, 23, 23, 9, 6);

        doResetMaze();

    }

    public boolean myKeyDown(int key)
    {

        // This method handles key presses.
        // For now all the statements are placeholders.

        // it is nice to have a print statement here.
        // it can be quickly uncommented and the output
        // used to get keycodes since I am too lazy to
        // look them up.

        if (key == KeyEvent.VK_LEFT) // T_ARROW_BUTTON) // left arrow
        {
            if (dx[0] == 0 && dy[0] == 0)
            {
                dx[0] = -SPEED;
                dx[1] = -SPEED;
                dy[0] = 0;
                dy[1] = 0;
            } else
            {
                dx[1] = -SPEED;
                dy[1] = 0;
            }
            return false;
        }
        if (key == KeyEvent.VK_RIGHT) // RIGHT_ARROW_BUTTON) // right arrow
        {
            if (dx[0] == 0 && dy[0] == 0)
            {
                dx[0] = SPEED;
                dx[1] = SPEED;
                dy[0] = 0;
                dy[1] = 0;
            } else
            {
                dx[1] = SPEED;
                dy[1] = 0;
            }
            return false;
        }

        if (key == KeyEvent.VK_UP) //UP_ARROW_BUTTON) // up arrow
        {
            if (dx[0] == 0 && dy[0] == 0)
            {
                dx[0] = 0;
                dx[1] = 0;
                dy[0] = -SPEED;
                dy[1] = -SPEED;
            } else
            {
                dx[1] = 0;
                dy[1] = -SPEED;
            }

            return false;
        }
        if (key == KeyEvent.VK_DOWN) //DOWN_ARROW_BUTTON) // down arrow
        {
            if (dx[0] == 0 && dy[0] == 0)
            {
                dx[0] = 0;
                dx[1] = 0;
                dy[0] = SPEED;
                dy[1] = SPEED;
            } else
            {
                dx[1] = 0;
                dy[1] = SPEED;
            }
            return false;
        }

        /*
         * if (key == SPACE_BAR) // space bar { return false; }
         * 
         * if (key == P_BUTTON) // 'P' key { return false; }
         */

        if (key == KeyEvent.VK_P)
        {
            paused = !paused;
        }
        return false;
    }

    public boolean myKeyUp(int key)
    {

        return false;
    }

    public void paint(Graphics g) // Draw the control panel and stuff
    {
        // Since there are no borders or anything
        // static to draw yet we only need to call
        // the update method.
        update(g);
    }

    public void run()
    {
        // This is the most important method. It loops over and
        // over again as the game is running. It makes the calls
        // that move things and then draw them.

        int mouthOpenAngle = 20;
        int dMouthOpenAngle = 5;
        int maxMouthOpenAngle = 100;
        int minMouthOpenAngle = 1;

        boolean hitWall = false;

        int i;
        int imageIndex = 0;
        int ghostImageIndex = 0;
        Rectangle ghostRect;
        boolean ghostRectAdded = false;

        //		try to grab the keyboard focus.
        requestFocus();

        while (updateThread != null)
        {

            // DRAW STUFF HERE:
            Rectangle rect = null;

            curCol = (x + PACMAN_SIZE / 2) / PACMAN_SIZE;
            curRow = (y + PACMAN_SIZE / 2) / PACMAN_SIZE;

            if (!paused)
            {

                if (mazeArray[curRow][curCol] == Maze.PELLET)
                {
                    pellets--;
                    mazeArray[curRow][curCol] = Maze.EMPTY_SQUARE;
                    gBufMaze.setColor(Color.black);
                    gBufMaze.fillRect(curCol * PACMAN_SIZE, curRow
                            * PACMAN_SIZE, PACMAN_SIZE, PACMAN_SIZE);
                    rect = new Rectangle(curCol * PACMAN_SIZE, curRow
                            * PACMAN_SIZE, PACMAN_SIZE, PACMAN_SIZE);
                }

                // do ghost stuff
                //ghost.move(curRow, curCol);

                for (i = 1; i >= 0; i--)
                {
                    nextX = x + dx[i];
                    nextY = y + dy[i];
                    hitWall = false;

                    int col;
                    int row;
                    hitWall = doDidWeHitAWall(hitWall);
                    if (!hitWall)
                    {
                        if (i == 1)
                        {
                            dx[0] = dx[1];
                            dy[0] = dy[1];
                        }
                        break;
                    }

                }

                doDrawMouth();
                //Move PacMan
                doMovePacman(nextX, nextY, hitWall, i);
                // Make the mouth chomp
                {
                    mouthOpenAngle = mouthOpenAngle + dMouthOpenAngle;

                    if (mouthOpenAngle > maxMouthOpenAngle)
                    {
                        mouthOpenAngle = maxMouthOpenAngle;
                        dMouthOpenAngle = -10;
                    }
                    if (mouthOpenAngle < minMouthOpenAngle)
                    {
                        mouthOpenAngle = minMouthOpenAngle;
                        dMouthOpenAngle = 5;
                    }
                }
                ghost.move(curRow, curCol, maze.myGraph);
                ghost.findPaths(1, maze.myGraph);
                ghostRect = new Rectangle(ghost.getY() - ghost.getSpeed(),
                        ghost.getX() - ghost.getSpeed(), PACMAN_SIZE
                                + ghost.getSpeed() + ghost.getSpeed(),
                        PACMAN_SIZE + ghost.getSpeed() + ghost.getSpeed());

                doComputeSleepTime();
                startTime = System.currentTimeMillis() + 40;

                if (clearGraphics > 0)
                {
                    gBuf.setClip(null);
                    gBuf.drawImage(mazeBuf, 0, 0, MAX_X, MAX_Y, this);
                    clearGraphics--;
                } else
                {
                    if (rect == null)
                    {
                        rect = new Rectangle(x - SPEED, y - SPEED, PACMAN_SIZE
                                + SPEED + SPEED, PACMAN_SIZE + SPEED + SPEED);
                    } else
                    {
                        rect.add(new Rectangle(x - SPEED, y - SPEED,
                                PACMAN_SIZE + SPEED + SPEED, PACMAN_SIZE
                                        + SPEED + SPEED));
                    }
                    ghostRectAdded = false;
                    if (rect.intersects(ghostRect))
                    {
                        rect.add(ghostRect);
                        ghostRectAdded = true;
                    }
                    gBuf.setClip(rect);
                }
                // clear what we drew last time.
                //gBuf.clearRect(0, 0, MAX_X, MAX_Y);

                //pellets = doDrawMaze();
                gBuf.drawImage(mazeBuf, 0, 0, MAX_X, MAX_Y, this);
                //set the drawing color
                gBuf.setColor(Color.yellow);

                // draw a PacMan
                if (PACMAN_SIZE == 60)
                {
                    gBuf.drawImage(
                            pacImage[imageIndex / 2][mouthStartAngle / 90], x,
                            y, this);
                    imageIndex += animDirection;
                    if (imageIndex >= numPacAnims * 2 || imageIndex < 0)
                    {
                        animDirection = -animDirection;
                        imageIndex += 2 * animDirection;
                    }
                } else
                {
                    gBuf.fillArc(x, y, PACMAN_SIZE, PACMAN_SIZE,
                            mouthStartAngle + mouthOpenAngle / 2,
                            360 - mouthOpenAngle);
                }
                if (!ghostRectAdded)
                {

                    repaint();
                    gBuf.setClip(new Rectangle(ghost.getY() - ghost.getSpeed(),
                            ghost.getX() - ghost.getSpeed(), PACMAN_SIZE
                                    + ghost.getSpeed() + ghost.getSpeed(),
                            PACMAN_SIZE + ghost.getSpeed() + ghost.getSpeed()));

                    gBuf.drawImage(mazeBuf, 0, 0, MAX_X, MAX_Y, this);
                }

                if (PACMAN_SIZE == 60)
                {
                    gBuf.drawImage(ghostImage[ghostImageIndex / 7], ghost
                            .getY(), ghost.getX(), this);
                    ghostImageIndex++;
                    ghostImageIndex = ghostImageIndex % (7 * numGhostAnims);
                } else
                {
                    gBuf.setColor(Color.red);
                    gBuf.fillRect(ghost.getY(), ghost.getX(), PACMAN_SIZE,
                            PACMAN_SIZE);
                }
                /*
                 * if (mazeArray[ghost.getX() / PACMAN_SIZE][ghost.getY() /
                 * PACMAN_SIZE] == Maze.WALL) { System.out.println( "ghost
                 * running into wall" + ghost.getX() + "," + ghost.getY()); }
                 */

                /*
                 * int ghostCol = (ghost.getY() + PACMAN_SIZE / 2) /
                 * PACMAN_SIZE; int ghostRow = (ghost.getX() + PACMAN_SIZE / 2) /
                 * PACMAN_SIZE;
                 */
                /*
                 * System.out.println( "ghost: " + ghostCol + "," + ghostRow + "
                 * pac:" + curCol + "," + curRow);
                 */

                if (Math.abs(x - ghost.getY()) < PACMAN_SIZE / 2
                        && Math.abs(y - ghost.getX()) < PACMAN_SIZE / 2)
                {
                    // kill the player
                    deaths++;
                    if (deaths >= maxDeaths)
                    {
                        deaths = 0;
                        gameInfoCount = 0;
                        doResetMaze();
                    }
                    resetLocations();
                }
            }
            // repaint() will call paint(Graphics) which will call
            // update(Graphics)

            if (pellets < 1)
            {
                doResetMaze();
            }
            repaint();
        }
    }

    private boolean doDidWeHitAWall(boolean hitWall)
    {
        // Process each "cell" of the maze and paint it correctly
        for (int xCorner = 0; xCorner < PACMAN_SIZE; xCorner += PACMAN_SIZE - 1)
        {
            for (int yCorner = 0; yCorner < PACMAN_SIZE; yCorner += PACMAN_SIZE - 1)
            {
                int col = (nextX + xCorner) / PACMAN_SIZE;
                int row = (nextY + yCorner) / PACMAN_SIZE;
                if (row < mazeArray.length && col < mazeArray[0].length)
                {
                    if (mazeArray[row][col] == Maze.WALL)
                    {
                        hitWall = true;
                        break;
                    }
                }
            }
        }
        return hitWall;
    }

    private void doComputeSleepTime()
    {
        {

            try
            {
                // this code slows the applet down if it is on a really fast
                // machine
                long sleepTime = Math.max(startTime
                        - System.currentTimeMillis(), 10);
                Thread.sleep(sleepTime);
            } catch (InterruptedException e)
            {
            }
        }
    }

    private void doMovePacman(int nextX, int nextY, boolean hitWall, int i)
    {
        {
            if (!hitWall)
            {
                x = nextX;
                y = nextY;
            } else
            {
                dx[0] = 0;
                dx[1] = 0;
                dy[0] = 0;
                dy[1] = 0;
            }

            // Don't let him go off the sides of the screen
            if (x > MAX_X - PACMAN_SIZE)
            {
                x = MAX_X - PACMAN_SIZE;
                dx[0] = 0;
                dx[1] = 0;
            }
            if (x < 0)
            {
                x = 0;
                dx[0] = 0;
                dx[1] = 0;
            }

            // Don't let him go off the top or bottom of the screen
            if (y > MAX_Y - PACMAN_SIZE)
            {
                y = MAX_Y - PACMAN_SIZE;
                dy[i] = 0;
                dy[1] = 0;
            }
            if (y < 0)
            {
                y = 0;
                dy[i] = 0;
                dy[1] = 0;
            }
        }
    }

    private void doDrawMouth()
    {
        {
            if (dx[0] > 0)
            {
                mouthStartAngle = 0;
            } else if (dx[0] < 0)
            {
                mouthStartAngle = 180;
            } else if (dy[0] > 0)
            {
                mouthStartAngle = 270;
            } else if (dy[0] < 0)
            {
                mouthStartAngle = 90;
            }
        }
    }

    private int doDrawMaze()
    {
        int row;
        int col;
        int pellets;

        // draw maze

        gBufMaze.setColor(Color.black);
        gBufMaze.fillRect(0, 0, MAX_X, MAX_Y);
        gBufMaze.setColor(Color.blue);

        pellets = 0;

        for (row = 0; row < mazeArray.length; row++)
        {
            for (col = 0; col < mazeArray[row].length; col++)
            {
                if (mazeArray[row][col] == Maze.WALL)
                {
                    gBufMaze.setColor(Color.blue);
                    gBufMaze.fillRect(col * PACMAN_SIZE, row * PACMAN_SIZE,
                            PACMAN_SIZE, PACMAN_SIZE);
                } else if (mazeArray[row][col] == Maze.PELLET)
                {
                    pellets++;
                    gBufMaze.setColor(Color.white);
                    //gBuf.fillArc(col * PACMAN_SIZE+PACMAN_SIZE/2 - 5, row *
                    // PACMAN_SIZE+PACMAN_SIZE/2 -5, 10,10,0,360);
                    gBufMaze.fillRect(col * PACMAN_SIZE + PACMAN_SIZE / 4, row
                            * PACMAN_SIZE + PACMAN_SIZE / 4, PACMAN_SIZE / 2,
                            PACMAN_SIZE / 2);
                }
            }
        }

        return pellets;
    }

    private void doResetMaze()
    {

        PACMAN_SIZE = gameInfoArray[gameInfoCount].getPacmanSize();
        SPEED = gameInfoArray[gameInfoCount].getPacmanSpeed();

        maze = new Maze(gameInfoArray[gameInfoCount].getMaxMaxWidth(),
                gameInfoArray[gameInfoCount].getMaxMazeHeight());
        mazeArray = maze.generateMazeArray();
        xOffset = (MAX_X - (mazeArray[0].length * PACMAN_SIZE)) / 2;
        yOffset = (MAX_Y - (mazeArray.length * PACMAN_SIZE)) / 2;
        ghost.setSpeed(gameInfoArray[gameInfoCount].getGhostSpeed());
        ghost.setSize(PACMAN_SIZE);
        ghost.setMaze(mazeArray);
        resetLocations();

        pellets = doDrawMaze();
        imgBuf.getGraphics().setColor(Color.black);
        imgBuf.getGraphics().fillRect(0, 0, MAX_X, MAX_Y);
        imgBuf.getGraphics().drawImage(mazeBuf, 0, 0, MAX_X, MAX_Y, this);

        clearGraphics = 2;
        gameInfoCount++;
        gameInfoCount = gameInfoCount % gameInfoArray.length;

    }

    private void resetLocations()
    {
        int ghostCol = mazeArray[0].length / 2;
        if (ghostCol % 2 == 0)
        {
            ghostCol++;
        }
        ghost.setXY(1, ghostCol);
        int pacRow = mazeArray.length * 2 / 3;
        if (pacRow % 2 == 0)
        {
            pacRow++;
        }
        nextX = ghostCol * PACMAN_SIZE;
        nextY = pacRow * PACMAN_SIZE;
        x = nextX;
        y = nextY;

        dx[0] = 0; // amount x position will change
        dy[0] = 0; // amount y will change
        dx[1] = 0; // amount x position will change
        dy[1] = 0; // amount y will change

        mouthStartAngle = 180; // direction that pacman is pointing

        clearGraphics = 2;

    }

    // This method is called when the applet is run.
    // It initiallizes the thread and gets things going.
    public void start()
    {
        if (updateThread == null)
        {
            updateThread = new Thread(this, "Game");
            updateThread.start();
            startTime = System.currentTimeMillis();
        }
    }

    // This method is called when the applet is stopped.
    public void stop()
    {
        updateThread = null;
    }

    public void update(Graphics g)
    {
        // draw the offscreen buffer to the screen!
        // This buffer was drawn on by the run() method
        // and by any methods run() might have called.
        if (clearGraphics > 0)
        {
            g.setColor(Color.black);
            g.fillRect(0, 0, MAX_X, MAX_Y);

            g.drawImage(imgBuf, xOffset, yOffset, this);
            clearGraphics--;
        }
        g.drawImage(imgBuf, xOffset, yOffset, this);
        /*
         * g.drawImage(imgBuf,x-PACMAN_SIZE,y-PACMAN_SIZE,x+2*PACMAN_SIZE,
         * y+2*PACMAN_SIZE,
         * x-PACMAN_SIZE,y-PACMAN_SIZE,x+2*PACMAN_SIZE,y+2*PACMAN_SIZE,this);
         * g.drawImage(imgBuf, ghost.getY()-PACMAN_SIZE,
         * ghost.getX()-PACMAN_SIZE, ghost.getY()+2*PACMAN_SIZE,
         * ghost.getX()+2*PACMAN_SIZE, ghost.getY()-PACMAN_SIZE,
         * ghost.getX()-PACMAN_SIZE, ghost.getY()+2*PACMAN_SIZE,
         * ghost.getX()+2*PACMAN_SIZE,this);
         */
    }

    public void getMainGraphics() // Load and process the most common graphics
    {
        MediaTracker tracker;
        int i = 0;

        tracker = new MediaTracker(this);

        for (int anim = 0; anim < numGhostAnims; anim++)
        {

            ghostImage[anim] = getImage(getCodeBase(), "Ghost" + anim
                    + ".gif");
            tracker.addImage(ghostImage[anim], i);
            i++;
        }

        for (int anim = 0; anim < numPacAnims; anim++)
        {
            for (int dir = 0; dir < 4; dir++)
            {
                pacImage[anim][dir] = getImage(getCodeBase(), "Pac" + anim
                        + dir + ".gif");
                tracker.addImage(pacImage[anim][dir], i);
                i++;
            }
        }

        try
        {
            tracker.waitForAll();
        } catch (InterruptedException e)
        {
        }

    }

}