/*
 * Created on Dec 31, 2003
 * 
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package maze;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;

/**
 * @author Harrison
 * 
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class Node
{

    Vector outEdgesVector = new Vector();

    int outEdgesCount = 0;

    public int myX;

    public int myY;

    public Edge bestEdge; // temp holder to be used to find a path

    private Hashtable myHT = new Hashtable();

    private int path = 17;

    public Node(int x, int y)
    {
        myX = x;
        myY = y;
        myHT.put(this, new HTContainer(this,0,null));
    }

    public void addEdge(Edge anEdge)
    {
        if (outEdgesVector.contains(anEdge))
        {
            System.out.println("redundant edge");
            return;
        }
        outEdgesVector.add(anEdge);
        outEdgesCount++;
        if (outEdgesCount >= 5)
        {
            System.out.println("*********************To many edges!");
        }
    }

    // returns square of shortest straight line distance between input location
    // and
    // any node within searchDepth range.
    // Recursive, base case is searchDepth == 0
    public int findPathTo(int x, int y, int searchDepth)
    {
        if (searchDepth == 0) { return (x - myX) * (x - myX) + (y - myY)
                * (y - myY); }

        int bestDepth = -1;
        int tempDepth = 0;
        Enumeration enum = outEdgesVector.elements();

        while (enum.hasMoreElements())
        {
            Edge edge = (Edge) (enum.nextElement());
            if (edge.contains(x, y))
            {
                bestEdge = edge;
                return 0;
            }

            tempDepth = edge.endNode.findPathTo(x, y, searchDepth - 1);

            if (bestDepth < 0 || tempDepth < bestDepth)
            {
                bestDepth = tempDepth;
                bestEdge = edge;
            }
        }
        return bestDepth;
    }

    public int findPathTo(int x, int y, int searchDepth, Vector recentNodes,
            Vector visitedNodes)
    {
        //visitedNodes.add(this);
        System.out.println("Visited :" + visitedNodes.size());
        int penalty = 0;

        if (recentNodes.indexOf(this) == 0)
        //if (recentNodes.contains(this))
        {
            penalty = 300;
            //System.out.println("recent node");
        }

        if (searchDepth == 0)
        {
            System.out
                    .println("depth ="
                            + (penalty + (x - myX) * (x - myX) + (y - myY)
                                    * (y - myY)));

            return penalty + (x - myX) * (x - myX) + (y - myY) * (y - myY);
        }

        int bestDepth = -1;
        int tempDepth = 0;
        Enumeration enum = outEdgesVector.elements();

        while (enum.hasMoreElements())
        {
            Edge edge = (Edge) (enum.nextElement());
            if (edge.contains(x, y))
            {
                bestEdge = edge;
                System.out.println("depth =" + penalty);

                return 0 + penalty;
            }

            if (!visitedNodes.contains(edge.endNode))
            {
                System.out.println("test");
                tempDepth = edge.endNode.findPathTo(x, y, searchDepth - 1,
                        recentNodes, visitedNodes);

                if (bestDepth < 0 || tempDepth < bestDepth)
                {
                    bestDepth = tempDepth;
                    bestEdge = edge;
                }
            }

        }
        if (bestDepth == -1)
        {
            bestDepth = 2000;
        }
        System.out.println("depth =" + (bestDepth + penalty));
        return (int) bestDepth + penalty;
    }

    public boolean equals(Object o)
    {
        if (o instanceof Node)
        {
            Node n = (Node) o;
            return n.myX == myX && n.myY == myY;
        }
        return false;
    }

    public int hashCode()
    {
        return myX * 1024 + myY;
    }

    public void traverse()
    {
        //System.out.println("************");
        Node currentNode = this;
        int dist = 0;
        Edge initialEdge = null;
        
        while (path > 0)
        {
            Enumeration enum = currentNode.outEdgesVector.elements();

            int fewestVisits = -1;
            
            HTContainer bestHTC = null;
            Edge bestEdge = null;
            // find least visited node
            while (enum.hasMoreElements())
            {
                Edge edge = (Edge) (enum.nextElement());
                Node n = edge.endNode;

                if (n != this)
                {

                    HTContainer htcChoice = (HTContainer) myHT.get(n);
                    
                    if (htcChoice == null)
                    {
                        //System.out.println("** creating HTC");
                        if (initialEdge == null)
                        {
                            htcChoice = new HTContainer(n, dist + edge.getLength(),edge);
                        }
                        else 
                        {
                            htcChoice = new HTContainer(n, dist + edge.getLength(),initialEdge);    
                        }
                        bestHTC = htcChoice;
                        myHT.put(n, htcChoice);
                        fewestVisits = htcChoice.getVisits();
                        bestEdge = edge;
                    }
                    else if(this == htcChoice.node)
                    {
                        // do nothing
                    }
                    else if (htcChoice.getDist() > dist+edge.getLength())
                    {
                        // if this is a shorter path then keep it
                        //System.out.println("Shorter Path Found");
                        bestHTC = htcChoice;
                        bestEdge = edge;
                        fewestVisits = 0;
                	} else if (bestEdge == null
                            || htcChoice.getVisits() < fewestVisits)
                    {
                        fewestVisits = htcChoice.getVisits();
                        bestHTC = htcChoice;
                        bestEdge = edge;
                    }
                }
                //System.out.println(htcChoice.getVisits());
            }
            if (initialEdge == null)
            {
                initialEdge = bestEdge;
            }
            
            if (initialEdge== null || initialEdge.startNode != this)
            {
                //System.out.println("Bad Initial Edge!!!!");
            }
            //System.out.println("fewest visits:"+fewestVisits);
            if (bestEdge == null)
            {
                // this only occurs in rare cases
                //System.out.println("best edge is null?!?");
                return;
            }
            
            
            /*
             * if (edgeIndex == lastEdge) { edgeIndex ++; edgeIndex = edgeIndex %
             * outEdgesCount; }
             */
            //System.out.println("Node:"+myX+","+myY+" path:"+path+"
            // edge:"+edgeIndex+" dist:"+dist);
            
            path--;
            dist += bestEdge.getLength();

            if (bestHTC == null)
            {
                System.out.println("** creating HTC2 - should almost never happen");
                bestHTC = new HTContainer(this, dist, initialEdge);
                myHT.put(this, bestHTC);
            } else
            {
                if (dist >= bestHTC.getDist())
                {
                    

                    dist = bestHTC.getDist();
                    initialEdge = bestHTC.getInitialEdge();
                } else
                {
                    bestHTC.setDist(dist, initialEdge);
                }
            }
            bestHTC.visit();

            Node nextNode = bestEdge.endNode;
            if (nextNode == this)
            {
                bestHTC.visit(100);
                //return;
                //System.out.println("Next node is this node ");
                /*
                 * nextNode = outEdge.startNode; if (nextNode == this) {
                 * System.out.println("Next node is STILL this node");
                 * edgeIndex++; edgeIndex = edgeIndex % outEdgesCount; outEdge =
                 * (Edge) (currentNode.outEdgesVector.get(edgeIndex)); nextNode =
                 * outEdge.endNode; }
                 */
            }
            // dist += outEdge.getLength();
            currentNode = bestEdge.endNode;
        }
    }

    // startTraverse
    // picks a now that has already been explored at random
    public void startTraverse()
    {
        path  = 20;
        traverse();
        /*
        // choose a default edge in case the ht is empty
        int initialEdge = path % outEdgesCount;
        Edge outEdge = (Edge) (outEdgesVector.get(initialEdge));
        Node nextNode = outEdge.endNode;

        Enumeration enum = myHT.elements();
        int minVisits = -1;
        int dist = outEdge.getLength();

        while (enum.hasMoreElements())
        {
            HTContainer htc = (HTContainer) enum.nextElement();
            if (minVisits == -1
                    || (htc.getVisits() > 0 && htc.getVisits() < minVisits))
            {
                minVisits = htc.getVisits();
                initialEdge = htc.initialEdge;
                dist = htc.getDist();
                nextNode = htc.node;
            }
        }
        nextNode.traverse(path, dist, myHT, 6, initialEdge);
        path++;
        if (path > 20)
        {
            path = 5;
        }
        */
    }

    public Edge getEdgeFor(int x, int y)
    {
        Enumeration enum = myHT.elements();
        int bestScore = -1;
        Edge bestEdge = null;

        System.out.println(myX + "," + myY + " **************decision" + myHT);
        while (enum.hasMoreElements())
        {
            HTContainer htc = (HTContainer) (enum.nextElement());
            int score = htc.calculateScore(x, y);
            if (bestScore == -1 || score < bestScore)
            {
                bestScore = score;
                bestEdge = htc.getInitialEdge();
            }
           // System.out.println(htc.node + " " + score);

        }
        System.out.println("best score:" + bestScore);
        
        if (bestEdge == null)
        {
            int index = (new Random()).nextInt(outEdgesCount);
            bestEdge = (Edge)outEdgesVector.get(index);
            System.out.println("Random direction!");
        }
        return bestEdge;
    }

    public boolean contains(int x, int y)
    {
        Enumeration enum = outEdgesVector.elements();
        while (enum.hasMoreElements())
        {
            Edge e = (Edge) (enum.nextElement());
            if (e.contains(x, y)) { return true; }
        }
        return false;
    }

    public Edge getEdgeTo(int x, int y)
    {
        Enumeration enum = outEdgesVector.elements();
        //int bestDist = -1;

        //Edge bestEdge = null;
        while (enum.hasMoreElements())
        {
            Edge e = (Edge) (enum.nextElement());
            if (e.contains(x, y)) { return e; }
        }
        return null;
    }

    public String toString()
    {
        return ("(" + myX + "," + myY + ")");
    }
}