/*
 * Created on Dec 31, 2003
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package maze;

import java.util.Enumeration;
import java.util.Vector;

/**
 * @author Harrison
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class Node
{

	Vector outEdgesVector = new Vector();
	
	public int myX;
	public int myY;
	
	public Edge bestEdge;  // temp holder to be used to find a path
	
	public Node(int x, int y)
	{
		myX = x;
		myY = y;
	}
	
	public void addEdge(Edge anEdge)
	{
		outEdgesVector.add(anEdge);
	}
	
	// returns square of shortest straight line distance between input location and
	// any node within searchDepth range.  
	// Recursive, base case is searchDepth == 0
	public int findPathTo(int x, int y, int searchDepth)
	{
		if (searchDepth == 0)
		{
			return (x-myX)*(x-myX)+(y-myY)*(y-myY);
		}
		
		int bestDepth = -1;
		int tempDepth = 0;
		Enumeration enum = outEdgesVector.elements();
		
		while (enum.hasMoreElements())
		{
			Edge edge = (Edge)(enum.nextElement());
			if (edge.contains(x,y))
			{
				bestEdge = edge;
				return 0;
			}
			
			tempDepth = edge.endNode.findPathTo(x,y,searchDepth-1);
			
			if (bestDepth < 0 || tempDepth < bestDepth)
			{
				bestDepth = tempDepth;
				bestEdge = edge;
			}	
		}
		return bestDepth;
	}
	public static void main(String[] args)
	{
	}
}
