package maze;

/**
 * Insert the type's description here.
 * Creation date: (11/2/2003 2:53:15 PM)
 * @author: Administrator
 */
public class Ghost
{
	private int[][] myMaze;

	private int x, y;
	private int dirX = 1;
	private int dirY = 0;
	private boolean lastChoiceX = false;

	private int speed = 6;
	private int size = 1;
	
	private Edge myEdge = null;
	/**
	 * Ghost constructor comment.
	 */
	public Ghost()
	{
		super();
	}
	private void generatePath(int x, int y, int pX, int pY)
	{
		int oldDirX = dirX;
		int oldDirY = dirY;

		if (x > pX)
		{
			dirX = -1;
		}
		if (x < pX)
		{
			dirX = 1;
		}

		if (y > pY)
		{
			dirY = -1;
		}
		if (y < pY)
		{
			dirY = 1;
		}

		if (dirX == 0 && dirY == 0)
		{
			dirX = -oldDirX;
			dirY = -oldDirY;

		}

		if (dirX != 0 && myMaze[x + dirX][y] == Maze.WALL)
		{
			dirX = 0;
		}

		if (dirY != 0 && myMaze[x][y + dirY] == Maze.WALL)
		{
			dirY = 0;
		}

		if (dirX == 0 && dirY == 0)
		{
			dirX = -oldDirX;
			dirY = -oldDirY;

		}

		if (dirX != 0 && dirY != 0)
		{
			if (lastChoiceX)
			{
				dirX = 0;

			}
			else
			{
				dirY = 0;
			}
			lastChoiceX = !lastChoiceX;
		}

		if (dirX != 0 && dirY != 0)
		{
			System.out.println("Huh!0?");
		}

	}
	public int getX()
	{
		return x;
	}
	public int getY()
	{
		return y;
	}
	private boolean hasChoice()
	{
		if (x % size == 0 && y % size == 0)
		{
			int mazeX = x / size;
			int mazeY = y / size;

			int score =
				myMaze[mazeX][mazeY
					- 1]
					+ myMaze[mazeX
					+ 1][mazeY] * 2
					+ myMaze[mazeX][mazeY
					+ 1] * 4
					+ myMaze[mazeX
					- 1][mazeY] * 8;

			if (score == 14 || score == 13 || score == 11 || score == 7)
			{
				dirX = -dirX;
				dirY = -dirY;
				return false;
			}

			if (score == 5 || score == 10)
			{
				return false;
			}

			return true;

		}
		return false;
	}
	public void move(int pacX, int pacY)
	{

		if (hasChoice())
		{
			int mazeX = x / size;
			int mazeY = y / size;

			generatePath(mazeX, mazeY, pacX, pacY);

		}

		x += dirX * speed;
		y += dirY * speed;

	}

	public void move(int pacX, int pacY, Graph graph)
	{
		int mazeX = x / size;
		int mazeY = y / size;

		if (myEdge == null)
		{
			System.out.println("edge is null!");
			myEdge = graph.getEdge(mazeX, mazeY);
			if (myEdge.contains(mazeX - 1, mazeY))
			{
				dirX = -1;
				dirY = 0;
			}
			else if (myEdge.contains(mazeX + 1, mazeY))
			{
				dirX = 1;
				dirY = 0;
			}
			else if (myEdge.contains(mazeX, mazeY - 1))
			{
				dirX = 0;
				dirY = -1;
			}
			else if (myEdge.contains(mazeX, mazeY + 1))
			{
				dirX = 0;
				dirY = 1;
			}
			else
			{
				System.out.println("error in Ghost.move");
			}
		}

		if (x % size == 0 && y % size == 0)
		{
			//System.out.println("DecisionPoint");
			Node node = graph.getNode(mazeX, mazeY);

			if (node != null)
			{
				//System.out.println("Node Decision");
				node.findPathTo(pacX, pacY, 2);
				myEdge = node.bestEdge;
				if (myEdge.contains(mazeX - 1, mazeY))
				{
					dirX = -1;
					dirY = 0;
				}
				else if (myEdge.contains(mazeX + 1, mazeY))
				{
					dirX = 1;
					dirY = 0;
				}
				else if (myEdge.contains(mazeX, mazeY - 1))
				{
					dirX = 0;
					dirY = -1;
				}
				else if (myEdge.contains(mazeX, mazeY + 1))
				{
					dirX = 0;
					dirY = 1;
				}
				else
				{
					System.out.println("error in Ghost.move");
				}

			}
			else if (
				myEdge != null && !myEdge.contains(mazeX + dirX, mazeY + dirY))
			{
				//System.out.println("Edge Decision " + dirX + "," + dirY);
				if (dirX != 0)
				{
					if (myEdge.contains(mazeX, mazeY - 1))
					{
						dirX = 0;
						dirY = -1;
					}
					else if (myEdge.contains(mazeX, mazeY + 1))
					{
						dirX = 0;
						dirY = 1;
					}
					else
					{
						myEdge.contains(mazeX + dirX, mazeY + dirY);
						System.out.println("Error in dirX!=0");
						dirX = -dirX;
						dirY = 0;
					}
				}
				else if (dirY != 0)
				{
					if (myEdge.contains(mazeX - 1, mazeY))
					{
						dirX = -1;
						dirY = 0;
					}
					else if (myEdge.contains(mazeX + 1, mazeY))
					{
						dirX = 1;
						dirY = 0;
					}
					else
					{
						myEdge.contains(mazeX + dirX, mazeY + dirY);
						System.out.println("Error in dirY!=0");
						dirX = 0;
						dirY = -dirY;
					}
				}
				else
				{

					System.out.println(
						"Error navigating segment transition in edgein Ghost.mvoe");
				}
				//System.out.println("Edge Decision done " + dirX + "," + dirY);

			}
		}

		x += dirX * speed;
		y += dirY * speed;

	}

	public void setMaze(int[][] maze)
	{
		myMaze = new int[maze.length][maze[0].length];
		for (int i = 0; i < myMaze.length; i++)
		{
			for (int j = 0; j < myMaze[i].length; j++)
			{
				if (maze[i][j] == Maze.WALL)
				{
					myMaze[i][j] = Maze.WALL;
				}
				else
				{
					myMaze[i][j] = Maze.EMPTY_SQUARE;
				}
			}
		}
	}
	public void setXY(int anX, int aY)
	{
		x = anX * size;
		y = aY * size;
		dirX = 1;
		dirY = 1;

		myEdge = null;
		//generatePath(anX, aY, anX, aY);

	}
	/**
	 * @return
	 */
	public int getSpeed()
	{
		return speed;
	}

	/**
	 * @param i
	 */
	public void setSpeed(int i)
	{
		speed = i;
	}

	/**
	 * @return
	 */
	public int getSize()
	{
		return size;
	}

	/**
	 * @param i
	 */
	public void setSize(int i)
	{
		size = i;
	}

}
