//-----------------------------------------------------------------------------------
// Packet Structures
//-----------------------------------------------------------------------------------
#define PACKET_TYPE_GENERIC				0
#define PACKET_TYPE_TURN				1
#define PACKET_TYPE_STROKE				2
#define PACKET_TYPE_BALLPOS				3
#define PACKET_TYPE_SCORE				4
#define PACKET_TYPE_OK					5
#define PACKET_TYPE_GAMEOVER			6

class	PacketGeneric
{
	public:
		DWORD			dwType;
		DWORD			dwSize;
		unsigned int	iPlayerID;
};

class	PacketTurn : public PacketGeneric
{
	public:
		short			sBallOn;
		BOOL			bBallInHand;
		BOOL			bChooseBallOn;
};

class	PacketStroke : public PacketGeneric
{
	public:
		float			fCuePosX;
		float			fCuePosZ;
		float			fCueRotX;
		float			fCueRotY;
		short			sPower;
		short			sBallOn;	
};

class	PacketBallPos : public PacketGeneric
{
	public:
		int				iBallNo;
		float			fX;
		float			fZ;
		bool			bPotted;
};

class	PacketScore : public PacketGeneric
{
	public:
		short			sScore;
};

class	PacketOK : public PacketGeneric
{
	public:
};

class	PacketGameOver : public PacketGeneric
{
	public:
};