#define WIN32_LEAN_AND_MEAN	// No MFC
#ifndef _WIN32_WINNT		// Windows 95 or later
#define _WIN32_WINNT 0x0400
#endif

#include <dplay8.h>
#include <mmsystem.h>
#include <SHELLAPI.H>
#include "resource.h"
#include "SoundSystem.h"
#include "BallClass.h"
#include "CueClass.h"
#include "TableClass.h"
#include "CameraClass.h"

//-----------------------------------------------------------------------------------
// #DEFINES & Constants
//-----------------------------------------------------------------------------------
#define MAX_TEXTURES		20
#define SCREEN_WIDTH		800
#define SCREEN_HEIGHT		600
// GUID to identify application
GUID	DP_ADSNOOKER = { 0x72cc354c, 0x3311, 0x4da3, { 0x86, 0x4b, 0xef, 0x84, 0xb1, 0xca, 0x85, 0xb3 } };
// D3D
#define VIDEODEVICEERROR_NOCOMPATIBLE	0x82000001
#define VIDEODEVICEERROR_NOWINDOWED		0x82000002

//-----------------------------------------------------------------------------------
// Structures & Classes
//-----------------------------------------------------------------------------------
struct GAME_SOUNDS
{
	GameSound	*gsBallHit;
	GameSound	*gsBallInPocket;
};

struct D3DModeInfo
{
    DWORD      Width; 
    DWORD      Height;
    D3DFORMAT  Format;
    DWORD      dwBehavior; 
    D3DFORMAT  DepthStencilFormat;
};

struct D3DDeviceInfo
{
    D3DDEVTYPE			DeviceType;
    D3DCAPS8			d3dCaps; 
    char				szDesc[32];
    BOOL				bCanDoWindowed;
    DWORD				dwNumModes;
    D3DModeInfo			modes[150];
    DWORD				dwCurrentMode;
    BOOL				bWindowed;
    D3DMULTISAMPLE_TYPE MultiSampleType;
};

struct D3DAdapterInfo
{
    D3DADAPTER_IDENTIFIER8	d3dAdapterIdentifier;
    D3DDISPLAYMODE			d3ddmDesktop; 
    DWORD					dwNumDevices;
    D3DDeviceInfo			devices[5];
    DWORD					dwCurrentDevice;
};

//-----------------------------------------------------------------------------------
// Function Prototypes
//-----------------------------------------------------------------------------------
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow);
LRESULT WINAPI MsgProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam );
HRESULT hrInit3D( HWND hWnd );
void vPrepareGame(HWND hWnd);
bool bIsPlayAllowed(void);
void vCleanup(void);
void vRenderScene(void);
void vSetupView(void);
void vInitGeometry(void);
void vSetOriginalBallPositions(void);
void vCreateLights(void);
void vGetVelocity( float fAngle, float &vx, float &vz );
int iAddPlayer(DPNID dpid, char *szName);
void vInitializeObjects(void);
void vInitSoundEngine(HWND hWnd);
void vUpdateObjects(HWND hWnd);
void vCueCollisionDetection(void);
void vCheckGameOver(void);
void vComputePointsOnTable(void);
void vInitializeStrokeResult(void);
void vPrepareCollisionDetectionData(void);
bool bAnyBallMoving(void);
void vSendBallPosMsg(const int i, D3DXVECTOR3 *pVec, const bool bPotted);
void vSendScoreMsg(const int i);
void vSendOKMsg(void);
void vSendGameOverMsg(void);
void vUpdateCamera(void);
void vUpdateNetwork( HWND hWnd );
int iGetPlayerID(unsigned int id);
HRESULT hrInitializeDirectPlay( HWND hWindow );
HRESULT WINAPI DirectPlayMessageHandler( PVOID pvUserContext, DWORD dwMessageId, PVOID pMsgBuffer );
HRESULT	hrSendPeerMessage( int player, DWORD dwMessageType, PVOID pMsgBuffer);
HRESULT	hrHostGame( HWND hwnd );
HRESULT	hrJoinGame( HWND hWnd );
HRESULT	hrCreatePlayer( PVOID pvUserContext, PVOID pMsgBuffer );
HRESULT	hrDestroyPlayer( PVOID pvUserContext, PVOID pMsgBuffer );
BOOL bFindDepthStencilFormat( DWORD dwMinDepth, DWORD dwMinStencil, UINT iAdapter, D3DDEVTYPE DeviceType, D3DFORMAT TargetFormat, D3DFORMAT* pDepthStencilFormat );
BOOL bValidateFormat(D3DFORMAT d3dfFormatToTest, UINT iAdapter, D3DDEVTYPE DeviceType, D3DFORMAT TargetFormat);
HRESULT hrBuildDeviceList(HWND hWnd);
HRESULT hrConfirmDevice( D3DCAPS8* pCaps, DWORD dwBehavior, D3DFORMAT Format );

//-----------------------------------------------------------------------------------
// Windows Globals
//-----------------------------------------------------------------------------------
const char				*szWndClass		= "ADSnooker";
const char				*szProgramName	= "AD Snooker";
HINSTANCE				g_hInstance;

//-----------------------------------------------------------------------------------
// Direct 3D Objects
//-----------------------------------------------------------------------------------
LPDIRECT3D8				pD3D = NULL;
LPDIRECT3DDEVICE8		pd3dDevice = NULL;
D3DXMATRIX				matProj;		// Projection Data
LPDIRECT3DTEXTURE8      g_pTexture[MAX_TEXTURES];
D3DXVECTOR3				arrBallPositions[TOTAL_BALLS];
bool					arrBallPotted[TOTAL_BALLS];
int						iBallPosCount;
BallClass				black;
BallClass				pink;
BallClass				blue;
BallClass				brown;
BallClass				green;
BallClass				yellow;
BallClass				white;
BallClass				reds[REDS_NUM];
CueClass				cue;
TableClass				table;
CameraClass				camera;

//-----------------------------------------------------------------------------------
// Direct Sound Objects
//-----------------------------------------------------------------------------------
SoundSystem				SoundEngine;
GAME_SOUNDS				g_GameSounds;
//-----------------------------------------------------------------------------------
// Direct Play Objects
//-----------------------------------------------------------------------------------
IDirectPlay8Peer*			g_pDP = NULL;
IDirectPlay8Address*		g_pDeviceAddress = NULL;
IDirectPlay8Address*		g_pHostAddress = NULL;
DPNHANDLE					g_hConnectAsyncOp = NULL;
DPNID						g_dpnidLocalPlayer = 0;
CLIENT_PLAYER_INFORMATION	PlayerInfo[MAX_PLAYERS];
int							g_iCurrentPlayer = 0;
int							g_iMyPlayerId = 0;
LONG						g_lNumberOfActivePlayers = 0;

//-----------------------------------------------------------------------------------
// Multi-Threading Variables
//-----------------------------------------------------------------------------------
CRITICAL_SECTION	g_csModifyPlayer;

//-----------------------------------------------------------------------------------
// Miscellaneous Variables
//-----------------------------------------------------------------------------------
// Font
LPD3DXFONT		pD3DXFont = NULL;
HFONT			hFont = NULL;
// Video
D3DAdapterInfo  g_Adapters[10];
DWORD           g_dwNumAdapters = 0;
DWORD           g_dwAdapter = 0;
BOOL            g_bUseDepthBuffer = TRUE;
BOOL			g_bWindowed = TRUE;
// Mouse
POINT			pointCursorStart;
BOOL			bCueBallMove = FALSE;
BOOL			bCueMove = FALSE;
BOOL			bPerformShot = FALSE;
short			sShotPower = MIN_POWER;
// Keyboard
BOOL			bBirdView = FALSE;
// Flags
BOOL			bShotDone;
BOOL			bGameStart;
BOOL			bGameOver;
BOOL			bBallInHand;
BOOL			bChooseBallOn;
BOOL			bNextPlayer;
BOOL			bChooseGameType;
BOOL			bNetworkGame;
BOOL			bHostGame;
BOOL			bConnecting;
BOOL			bPacketsProcessed;
BOOL			bScoreComputed;
BOOL			bSendTurn;
BOOL			bOtherPlayerLeft;
// Game
STROKE_RESULT	StrokeResult;
short			sPointsOnTable;
char			szSystemMessage[256];
char			szTemporary[256];
