#ifndef CUECLASS_H
#define CUECLASS_H

#include <d3dx8.h>
#include <stdio.h>
#include "globals.h"
#include "Object3DClass.h"
#include "BallClass.h"
// Constants
#define CUE_DISTANCE 5.0f
#define CUE_LENGTH 150.0f
#define CUE_RADIUS 0.875f
#define MAX_X_ROTATION_UP 330.0f
#define MIN_POWER 1
#define MAX_POWER 10

class CueClass : public Object3DClass
{
	private:
		D3DXVECTOR3 vecCuePosition;
		D3DXVECTOR3 vecCueRotation;
		bool		bCueVisibility;
		// Private methods
		void vAbsoluteDegrees(void);
	public:
		CueClass();
		void vSetPosition(D3DXVECTOR3 *pVec);
		D3DXVECTOR3 vecGetPosition(void);
		void vSetRotation(D3DXVECTOR3 *pVec);
		void vRotatePosition(int idx, int idy);
		D3DXVECTOR3 vecGetRotation(void);
		void vDisplayXYZ(void);
		void vPerformShot(BallClass *pCueBall , const short sShotPower );
		void vCheckRotationUp(void);
		void vBallCollisionDetection(BallClass *pBall);
};

#endif