//###################################################################################
//#																					#
//#			Camera object class														#
//#				- Ales Daneu, 06/11/2002											#
//#																					#
//###################################################################################
#include "CameraClass.h"

//-----------------------------------------------------------------------------
// Name: CameraClass()
// Desc: Constructor
//-----------------------------------------------------------------------------
CameraClass::CameraClass()
{
	vecCameraRotation = ORIGINAL_ROT;
}

//-----------------------------------------------------------------------------
// Name: matGetCameraView(bTop,*pVec)
// Desc: Calculate VIEW matrix
//-----------------------------------------------------------------------------
D3DXMATRIX CameraClass::matGetCameraView(bool bTop, D3DXVECTOR3 *pVec)
{
	D3DXMATRIX		matCameraView;
	D3DXMATRIX		matPosition,matRotation,matTranslation;
	D3DXQUATERNION	quatRotation;
	D3DXVECTOR4		vecTransformedCameraSource;

	// Bird view
	if ( bTop ) 
	{
		vecCameraSource = D3DXVECTOR3( 0.0f, 210.0f, 0.0f);
		vecCameraTarget = D3DXVECTOR3( 0.0f, 0.0f, 0.0f);
		// Setup Camera View
		D3DXMatrixLookAtLH( &matCameraView, 
			&vecCameraSource, 
			&vecCameraTarget, 
			&D3DXVECTOR3( 0.0f, 0.0f, -1.0f ) );
		// Rotate the view by 90 degrees		
		D3DXMatrixRotationY( &matRotation, 90.0f / RADIAN_TO_DEGREES );
		D3DXMatrixMultiply( &matCameraView, &matRotation, &matCameraView );
	}
	// Normal view (from top of the cue)
	else
	{
		vecCameraTarget = *pVec + D3DXVECTOR3(0.0f, 2.62f, 0.0f);
		vecCameraSource = D3DXVECTOR3(0.0f, 29.38f, 79.05f);
		// Quaternions stuff... (rotate the view around cue ball)
		D3DXMatrixIdentity(&matPosition);
		// Step 1 (initial position of camera)
		D3DXMatrixTranslation(&matTranslation,
							vecCameraTarget.x,
							vecCameraTarget.y,
							vecCameraTarget.z);
		D3DXMatrixMultiply(&matPosition,&matTranslation,&matPosition);
		// Step 2 (create quaternion that rotates us on X and Y axis)
		D3DXQuaternionRotationYawPitchRoll(&quatRotation,
											vecCameraRotation.x / RADIAN_TO_DEGREES,
											vecCameraRotation.y / RADIAN_TO_DEGREES,
											0.0f);
		// Step 3 (transform quaternion to correspondig matrix)
		D3DXMatrixRotationQuaternion(&matRotation,&quatRotation);
		// Step 4 (rotate initial camera position)
		D3DXMatrixMultiply(&matPosition,&matRotation,&matPosition);
		// Get rotated camera source vector
		D3DXVec3Transform(&vecTransformedCameraSource, 
							&vecCameraSource,
							&matPosition);
		vecCameraSource = D3DXVECTOR3(vecTransformedCameraSource.x, 
										vecTransformedCameraSource.y,
										vecTransformedCameraSource.z); 
		// Setup Camera View
		D3DXMatrixLookAtLH( &matCameraView, 
			&vecCameraSource, 
			&vecCameraTarget, 
			&D3DXVECTOR3( 0.0f, 1.0f, 0.0f ) );
	}
	return matCameraView;
}

//-----------------------------------------------------------------------------
// Name: vRotateCamera(*pVec)
// Desc: Set camera rotation
//-----------------------------------------------------------------------------
void CameraClass::vRotateCamera(D3DXVECTOR3 *pVec)
{
	vecCameraRotation = *pVec;
}