#ifndef BALLCLASS_H
#define BALLCLASS_H

#include <d3dx8.h>
#include <stdio.h>
#include "Object3DClass.h"
// Constants
#define BALL_RADIUS		2.62f
#define REDS_NUM		15
#define TOTAL_BALLS		22
#define WHITE_VALUE		0
#define WHITE_POS		D3DXVECTOR3( 0.0f, 0.0f, 133.95f )
#define RED_VALUE		1
#define YELLOW_VALUE	2
#define YELLOW_POS		D3DXVECTOR3( -29.21f, 0.0f, 104.75f )
#define GREEN_VALUE		3
#define	GREEN_POS		D3DXVECTOR3( 0.0f, 0.0f, 104.75f )
#define BROWN_VALUE		4
#define BROWN_POS		D3DXVECTOR3( 29.21f, 0.0f, 104.75f )
#define BLUE_VALUE		5
#define	BLUE_POS		D3DXVECTOR3( 0.0f, 0.0f, 0.0f )
#define PINK_VALUE		6
#define	PINK_POS		D3DXVECTOR3( 0.0f, 0.0f, -89.22f )
#define BLACK_VALUE		7
#define BLACK_POS		D3DXVECTOR3( 0.0f, 0.0f, -146.05f )
#define MINIMUM_PENALTY 4
#define MAXIMUM_PENALTY 7

class BallClass : public Object3DClass
{
	private:
		bool		bIsBallMoving;
		bool		bCollisionDetectionDone;
		bool		bPotted;
		bool		bReposition;
		short		sBallValue;
		float		fCurrentBallSpeed;
		BallClass*	arrCloseNeighbours[TOTAL_BALLS - 1];
		D3DXVECTOR3 vecBallPosition;
		D3DXVECTOR3 vecBallMovement;
		// Private methods
		D3DXVECTOR3 vFixOverlaps(D3DXVECTOR3 *vecPos1, D3DXVECTOR3 *vecPos2, D3DXVECTOR3 *vecMovement);
		bool vBallCollisionDetection(BallClass *pBall);
		void vPruneBallMovement(void);
	public:
		void vSetPosition(D3DXVECTOR3 *pVec);
		D3DXVECTOR3 vecGetPosition(void);
		void vUpdatePosition(D3DXVECTOR3 *pVec);
		void vSetBallMovement(D3DXVECTOR3 *pVec);
		D3DXVECTOR3 vecGetBallMovement(void);
		void vSetBallSpeed(float fBallSpeed);
		void vSetValue(const short sValue);
		short sGetValue(void);
		float fGetBallSpeed(void);
		bool bGetIsBallMoving(void);
		bool bGetCollisionDetectionDone(void);
		void vSetPotted(const bool bValue);
		bool bGetPotted(void);
		void vSetReposition(const bool bValue);
		void vReposition(void);
		void vAddToList(BallClass *pBall);
		void vResetList(void);
		void vDisplayXYZ(void);
		short vAdvance(void);
		void vBallsCollisionDetection(void);
};

#endif