/*
	CmdSix by Sapient6
	
	Copyright 2002, Jonathan D. Campbell

	contact: sleacon@hotmail.com
	
	This source code is available for distribution and modification
	as long as the following conditions are met:
	
		1. Credit for the original work must be included.
		2. Unless substantial changes are made to the functionality
		and purpose of the program copyright for the altered work
		still belongs to me and the credit must remain.
		3. Redistribution of this code or it's resultant binary 
		must always be free of charge.
		4. All changes made to the source code must be documented 
		and their functionality commented.
		5. Changes to functionality or use must be reflected in 
		the output of the program's HELP command.
*/

#include <stdafx.h>
#include <stdio.h>
#include <stdlib.h>
#include <windows.h>
#include <string.h>
#include <process.h>


#define MAX_PATH		260

int stop(char* szProcess);
BOOL CALLBACK CloseWindowByTitle(HWND hWnd, LPARAM lParam);
int help();

char* gszWindowName;


int main(int argc, char* argv[])
{
	/*
		Runs a series of system commands.

		Can sleep for a specified number of seconds.

		Can search for a specific window title and send the window a WM_CLOSE msg.
	*/
	int i, x, iArgs; unsigned long ulWait;char* args[12];
	
	if( argc > 1)
	{
		if ((_stricmp(argv[1], "help") == 0) || (strcmp(argv[1], "?") == 0))
		{
			//check for HELP is non-case sensitive in the interest of being 
			// somewhat friendly to a new user.
			//display help
			help();
			return 0;
		}
		
		for(i=1; i < argc; i++)
		{
			//Special case commands are case sensitive so they will not
			// interfere with names of programs a user might want to run
			// through CmdSix. This way, if a user wants to run a program 
			// named "Wait" and doesn't want to SPAWN it, he can do so 
			// simply by avoiding an all-caps specification.
			if (strcmp(argv[i], "WAIT") == 0)
			{
				//Wait. Determine proper number of arguments.
				x = i + 3;
				if (argc < x)
				{
					//Not enough arguments. Format should be:
					//		cmdsix wait 30 "because I said so"
					printf("When using \"wait\" command always include seconds to wait and wait reason.\n");
					i = argc; //don't execute further commands (if any)
				} else
				{
					//advance i to number of seconds to wait (next cmdline argument)
					i++;
					ulWait = atol(argv[i]);
					//advance i to wait reason (next cmdline argument)
					i++;
					//alert user this command window is still busy
					printf("Waiting %s seconds for %s...\n", argv[i-1], argv[i]);
					ulWait = ulWait * 1000; //convert seconds to milliseconds
					//take a nap
					Sleep(ulWait);
				}
			} else if(strcmp(argv[i], "STOP") == 0)
			{
				x = i + 1;
				if (argc < x)
				{
					//Not enough arguments. Format should be:
					//		cmdsix stop "Untitled - Notepad"
					printf("When using \"stop\" command always include the window title you wish to stop as the next argument.\n");
					i = argc; //no further arguments. Allow for statement to complete
				} else
				{
					i++; //advance to the window name we want to stop
					gszWindowName = (argv[i]);
					printf("Looking for windows titled \"%s\".\n", gszWindowName);
					EnumWindows(&CloseWindowByTitle, 0); //looks for the window title and terminates it.
				}
			} else if (strcmp(argv[i], "SPAWN") == 0)
			{
				x = i + 2;
				if (argc < x)
				{
					//Not enough arguments. Format should be:
					//		cmdsix spawn notepad.exe 1 example.bat
					printf("When using \"SPAWN\" command always include:\nthe program name you wish to spawn,\nthe number of arguments you want to pass,\nthen the arguments.\n");
					i = argc;
				} else
				{
					//advance to spawn name
					i++;
					args[0] = argv[i];

					//advance to arg count
					i++;
					iArgs = atoi(argv[i]);

					if (iArgs > 10)
					{
						printf("CmdSix does not currently support more than 10 arguments to \"SPAWN\".\n");
						i = argc;
					} else
					{
						if (iArgs > 0)
						{
							x = i + iArgs;
							if (argc < x)
							{
								//Not enough arguments.
								printf("You have specified more arguments to SPAWN than you have provided.\n");
								i = argc;
							} else
							{
								//advance iArgs to make args 1-based
								iArgs++;
								//all nondefined args should be NULL
								//last item in array must be NULL
								for (x = 1; x < 12; x++)
								{
									args[x] = NULL;
								}
								//transfer arguments to args
								for (x = 1; x < iArgs; x++)
								{
									i++;
									args[x] = argv[i];
								}
								//execute locally or by fully qualified path
								x = spawnv(_P_NOWAIT, args[0], args);
								if (x < 0)
								{
									//failed locally, may need to search path
									x = spawnvp(_P_NOWAIT, args[0], args);
									if (x < 0)
									{
										//Failed in path as well
										printf("%s could not be found in the path.\n", args[0]);
									}
								}
							}
						} else
						{
							//execut with 0 arguments
							x = spawnl(_P_NOWAIT, args[0], NULL);
							if (x < 0)
							{
								//failed locally. may need to search path
								x = spawnlp(_P_NOWAIT, args[0], NULL);
								if (x < 0)
								{
									//Failed in path as well
									printf("%s could not be found in the path.\n", args[0]);
								}
							}
						}
					}
				}
			} else
			{
				//System command. Usually should be a batch file I guess.
				system(argv[i]);
			}
		}
	} else
	{
		//User gave no params. Display help.
		help();
	}
	return 0;
}

BOOL CALLBACK CloseWindowByTitle(HWND hWnd, LPARAM lParam)
{
	//This callback function is called by EnumWindows.
	//	It looks for a window title matching gszWindowName and
	//	requests the window to close.
	//It will attempt to close ALL windows with matching titles.

	static char Title[MAX_PATH];
	int iTitleLen;
	unsigned int uExitCode = 0, uPMParam = 0;
	long lPMParam = 0;
	
	iTitleLen = GetWindowText(hWnd, Title, sizeof(Title));
	if (iTitleLen > 0)
	{
		if (_stricmp(Title, gszWindowName) == 0)
		{
			//Found a matching title.
			printf("Attemting to stop \"%s\".\n", Title);
			//first, bring the window to the top in case it prompts when it's asked to close.
			if (IsIconic(hWnd))
			{
				//The window is minimized. Restore it before call to front.
				OpenIcon(hWnd);
			}
			BringWindowToTop(hWnd);
			//Now ask it to close
			PostMessage(hWnd, WM_CLOSE, uPMParam, lPMParam);
			//If we wanted this function to only close the
			//	the first matching window title, we could
			//	uncomment the following line.
			//return false;
		}
	}
	
	//returning true tells EnumWindows to continue enumerating
	//	windows until it runs out of windows to enumerate.
	return true;
}

int help()
{
	char msg[1024];
	strcpy(msg, "\n\nEach parameter in the commandline will be executed except for the\n");
	strcat(msg, "the following case sensitive special exceptions:\n");
	strcat(msg, "   STOP\n");
	strcat(msg, "     CmdSix STOP arg1\n");
	strcat(msg, "       arg1: Windows titles matching this string will be stopped\n");
	strcat(msg, "   WAIT\n");
	strcat(msg, "     CmdSix WAIT arg1 arg2\n");
	strcat(msg, "       arg1: Pause for this number of seconds\n");
	strcat(msg, "       arg2: Display this string as the wait reason\n");
	strcat(msg, "   SPAWN\n");
	strcat(msg, "     CmdSix SPAWN arg1 arg2 [arg3[, ... arg12]]\n");
	strcat(msg, "       arg1: Execute this program without waiting for completion\n");
	strcat(msg, "       arg2: Number of commandline arguments to send to arg1(0 if none)\n");
	strcat(msg, "       arg3-12: Matching number of arguments from arg2\n");
	printf("%s", msg);
	return 0;
}