#include "asm86.h"
#include "ti86asm.inc"
#include "ti86ops.inc"
#include "ti86math.inc"

;Triangle Tester - by Elroy (elroy@usa.net)
;-----
;Input Legs and Hypotenuse, and it returns what type of
;triangle it is.  This is my first asm program, so sorry
;about any bad techniques!

;----------  Equates  ----------
_asap_ind	.equ	0D623h
_clrWindow	.equ	4A86h
_CPOP1OP2	.equ	41FBh
_exec_pg3	.equ	5714h
_homeUp		.equ	4A95h
_ioprompt	.equ	0C324h
_mov10b		.equ	$427b

;----------  Program  ----------
.org _asm_exec_ram
	nop
	jp Top
	.dw $0000
	.dw Str_Shell_Title
Clear:
	call _clrLCD
	call _clrWindow
	call _homeUp
	ret
Prompt:
	call _mov10b			;move to prompt buffer, 10 bytes
	ld a,0Dh
	ld (_asap_ind),a
	call _exec_pg3
	ret
Top:
	call Clear
	ld hl,Str_Title
	call _puts
	ld bc,$0003			;row 3 column 0
	ld (_curRow),bc
	ld de,_ioprompt
	ld hl,Str_Prompt1		;load prompt string
	call Prompt			;prompt and move to op1
	call _OP1TOOP4			;move op1 to op4
	ld de,_ioprompt
	ld hl,Str_Prompt2
	call Prompt
	call _OP1TOOP5
	ld de,_ioprompt
	ld hl,Str_Prompt3
	call Prompt
	call _OP1TOOP6			;op4 = A, op5 = B, op6 = C
	call _OP4TOOP1			;op1 = A
	call _OP5TOOP2			;op2 = B
	call _FPADD			;op1 = A+B
	call _OP1TOOP2			;op2 = A+B
	call _OP6TOOP1			;op1 = C
	call _CPOP1OP2			;test (A+B)-C
	jp m,Test			;if negative jump to Test
	ld hl,Str_Fail			;else load failure string
	jp Exit				;and jump to Exit
Test:
	call _OP4TOOP1			;op1 = A
	call _FPSQUARE			;op1 = A^2
	call _OP1TOOP4			;op4 = A^2
	call _OP5TOOP1			;op1 = B
	call _FPSQUARE			;op1 = B^2
	call _OP1TOOP5			;op5 = B^2
	call _OP6TOOP1			;op1 = C
	call _FPSQUARE			;op1 = C^2
	call _OP1TOOP6			;op6 = C^2
	call _OP4TOOP1			;op1 = A^2
	call _OP5TOOP2			;op2 = B^2
	call _FPADD			;op1 = A^2+B^2
	call _OP6TOOP2			;op2 = C^2
	call _CPOP1OP2			;test (A^2+B^2)-C^2
	jp z,Right			;if answer is zero jump to Right
	jp m,Obtuse			;if answer is negative jump to Obtuse
	ld hl,Str_Acute			;else it's acute
	jp Exit
Right:
	ld hl,Str_Right
	jp Exit
Obtuse:
	ld hl,Str_Obtuse
Exit:
	ld bc,$0107			;column 1 row 7
	ld (_curRow),bc
	set 3,(iy+05)			;inverse text
	call _puts			;display string
	res 3,(iy+05)			;normal text
	call _getkey
	call Clear
	ret

;---------- Variables ----------
Str_Title:
	.db "Triangle Tester      "
	.db "elroy@usa.net",0
Str_Prompt1:
	.db "Leg 1:",0
Str_Prompt2:
	.db "Leg 2:",0
Str_Prompt3:
	.db "Hyp. :",0
Str_Fail:
	.db "Impossible triangle",0
Str_Acute:
	.db "  Acute triangle   ",0
Str_Right:
	.db "  Right triangle   ",0
Str_Obtuse:
	.db "  Obtuse triangle  ",0
Str_Shell_Title:
	.db "Triangle Tester",0
.end
