#define need_DIV_A_HL
#define need_D_HL_DECI
         ; *****************************************************************
         ; *
         ; *                 O R Z U N O I D
         ; *
         ; *            Programmed by Patrick Davidson
         ; *
         ; *           last updated : 14-September-1997
         ; *
         ; *****************************************************************
         .include "ti-86.h"
scrlpos  =TEXT_MEM+165
temp     =TEXT_MEM+161
temp3    =TEXT_MEM+164
aball    =TEXT_MEM+167
stop     =TEXT_MEM
p        =TEXT_MEM+1
x        =TEXT_MEM+2
x2       =TEXT_MEM+6
x3       =TEXT_MEM+10
incr     =TEXT_MEM+14
level    =TEXT_MEM+15
lives    =TEXT_MEM+16
won      =TEXT_MEM+17
speed    =TEXT_MEM+18
score    =TEXT_MEM+19
uchoice  =TEXT_MEM+21
inc      =TEXT_MEM+22
bonust   =TEXT_MEM+23
bonusx   =TEXT_MEM+24
bonusy   =TEXT_MEM+25
expand   =TEXT_MEM+26
timer    =TEXT_MEM+27
guard    =TEXT_MEM+29
catch    =TEXT_MEM+30
bthru    =TEXT_MEM+31
data     =TEXT_MEM+33
prog_name:
         .db      "Orzunoid 1.3 by Patrick D"
         .db      0
prog_code:
  ; ----------------------- INITIALIZATION --------------------------------
         ld       (exit_game+1),sp
main:    ld       hl,TEXT_MEM
         ld       (hl),0
         ld       de,TEXT_MEM+1
         ld       bc,167
         ldir
         ROM_CALL(CLEARLCD)
         ld       b,96
         ld       a,32
         ld       ix,GRAPH_MEM
pcl:     ld       hl,0
         ld       (CURSOR_ROW),hl
         push     af
         push     bc
         ROM_CALL(TX_CHARPUT)
         ld       hl,$fc00
         ld       b,8
         ld       de,16
il2:     ld       a,(hl)
         add      a,a
         or       (hl)
         ld       (ix),a
         add      hl,de
         inc      ix
         djnz     il2
         pop      bc
         pop      af
         inc      a
         djnz     pcl
         ld       a,(CONTRAST)
         inc      a
         cp       $20
         jr       nz,ok2
         dec      a
ok2:     out      (2),a
         ld       (iy+13),0
         call     stuff            ;do the game
         ROM_CALL(CLEARLCD)
         ld       (CURSOR_ROW),de
         ld       hl,hstitle
         ROM_CALL(D_ZT_STR)
         LOCATE(16,1)
         ld       ix,hsdata
         ld       b,7
high_display_loop:
         ld       l,(ix+0)
         ld       h,(ix+1)
         ROM_CALL(D_HL_DECI)
         ld       hl,CURSOR_ROW
         dec      (hl)
         inc      ix
         inc      ix
         push     ix
         pop      hl
         ROM_CALL(D_ZT_STR)
         ld       de,17
         add      ix,de
         ld       hl,CURSOR_ROW
         inc      (hl)
         djnz     high_display_loop
         call     wait_key
         cp       K_EXIT
         jp       nz,main
exit_game:
         ld       sp,0
         ld       a,(CONTRAST)
         out      (2),a
         ld       hl,DELC_LEN
         ld       (HL),0
         ret           

stuff:
         ld       hl,saved_flag     ;Check for saved game
         ld       a,(hl)
         or       a
         jp       nz,restore_game

         ld       hl,0
         ld       (CURSOR_ROW),hl
         ld       hl,initial_msg
         ROM_CALL(D_ZT_STR)
         ld       ix,CURSOR_ROW
         inc      (ix)
         ROM_CALL(D_ZT_STR)
         ld       hl,0
         ld       (scrlpos),hl
         ld       hl,$0806
         ld       (GRAPH_MEM+$300),hl

intro_loop:
         ld       hl,GRAPH_MEM+$380
         ld       b,128
lclearscrl:
         ld       (hl),0
         inc      hl
         djnz     lclearscrl
         ld       hl,(scrlpos)
         inc      hl
         ld       de,(scrl_end-scrltext)*8
         call     CP_HL_DE
         jr       nz,okscrl
         ld       hl,0
okscrl:  ld       (scrlpos),hl
         ld       a,8
         call     DIV_A_HL+2
         cpl
         and      7
         ld       de,scrltext
         add      hl,de
         ld       b,15
scroll_loop:
         push     bc
         push     hl
         push     af
         ld       a,(hl)
         sub      32
         ld       l,a
         ld       h,0
         add      hl,hl
         add      hl,hl
         add      hl,hl
         ld       de,GRAPH_MEM
         add      hl,de
         ld       de,GRAPH_MEM+$302
         ld       bc,8
         ldir
         pop      af
         push     af
         ld       d,a
         ld       e,56
         ld       ix,GRAPH_MEM+$300
         call     drw_spr
         pop      af
         pop      hl
         pop      bc
         add      a,8
         inc      hl
         djnz     scroll_loop
         ld       de,15
         ld       hl,GRAPH_MEM+$380
         ld       b,8
         ld       a,255
loop_blox:
         ld       (hl),a
         add      hl,de
         ld       (hl),a
         inc      hl
         djnz     loop_blox
         dec      hl
         ld       de,$ffff
         ld       bc,128
         lddr

         call     GET_KEY
         or       a
         jp       z,intro_loop

         cp       K_EXIT
         jp       z,exit_game

         cp       K_ALPHA
         ret      z

         sub      $31
         jp       m,intro_loop
         cp       5
         jp       p,intro_loop

         ld       hl,speed
         ld       (hl),a
         ld       a,5
         sub      (hl)
         rlca
         ld       (score+1),a
         ld       (score),a
         ld       hl,lives
         ld       (hl),3
         dec      hl
         dec      hl
         ld       (hl),5

         call     un_expand

         ld       hl,(DELC_LEN)
         ld       de,$4Fd0
         call     CP_HL_DE
         jr       nz,normal_levels
         ld       hl,DELC_LEN+2
         jr       load_levels
normal_levels:
         ld       hl,universe
load_levels:
         ld       de,this_universe
         ld       bc,96
         ldir

  ; ------------------- OUTER GAME LOOP ----------------------
         call     init_display
play_da_game:
         ld       b,20
lgain:   ld       hl,(score)
         ld       de,100
         add      hl,de
         ld       (score),hl
         call     update_score
         djnz     lgain

         ld       hl,lives
         inc      (hl)
         call     level_addr
         ld       b,32                  ;Copy the map + count blocks
         ld       de,data
set_up_1:ld       c,(hl)
         rlc      c
         rlc      c
         ld       a,c
         and      3
         ld       (de),a
         inc      de
         rlc      c
         rlc      c
         ld       a,c
         and      3
         ld       (de),a
         inc      de
         rlc      c
         rlc      c
         ld       a,c
         and      3
         ld       (de),a
         inc      de
         rlc      c
         rlc      c
         ld       a,c
         and      3
         ld       (de),a
         inc      de
         inc      hl
         djnz     set_up_1
         ld       hl,level
         inc      (hl)
level_loop:
         ld       hl,p
         ld       (hl),112
         inc      hl
         ld       (hl),128
         inc      hl
         ld       (hl),-1
         inc      hl
         ld       (hl),50
         inc      hl
         ld       (hl),-1
         inc      hl
         xor      a
         ld       (hl),a
         ld       de,x2+1
         ld       bc,7
         ldir
         ld       (guard),a
         ld       (bthru),a
         call     un_expand

restore_position:
         call     play_level
         xor      a
         out      (1),a
         ld       a,(won)
         or       a
         jr       z,finished_level
         ld       hl,lives
         dec      (hl)
         jr       z,game_over
         jr       level_loop
finished_level:
         ld       b,0
         ld       a,(x+3)
         or       a
         jr       z,n1
         inc      b
n1:      ld       a,(x2+3)
         or       a
         jr       z,n2
         inc      b
n2:      ld       a,(x3+3)
         or       a
         jr       z,n3
         inc      b
n3:      ld       a,b
         add      a,a
         add      a,a
         add      a,a
         add      a,a
gp:      ld       hl,(score)
         ld       de,10
         add      hl,de
         ld       (score),hl
         push     af
         call     update_score
         pop      af
         dec      a
         jr       nz,gp
         ld       a,(level)
         cp       3
         jp       nz,play_da_game
         ld       a,(lives)
         add      a,a
         add      a,a
         add      a,a
         ld       b,a
lgain2:  ld       hl,(score)
         ld       de,100
         add      hl,de
         ld       (score),hl
         call     update_score
         djnz     lgain2

  ; ---------------------- END OF GAME -------------------------
game_over:                          ;Set up score page
         ld       hl,(lowest)      ;See if ya got a hi-score
         ld       de,(score)
         call     CP_HL_DE
         ret      nc
         ROM_CALL(CLEARLCD)
         ld       (CURSOR_ROW),de
         ld       hl,hi_score_str
         ROM_CALL(D_ZT_STR)
         ld       hl,lowest+2
         ld       (temp),hl
         ld       b,16
space_loop:
         ld       (hl),32
         inc      hl
         djnz     space_loop
         ld       ix,(temp)
         ld       b,0
enter_name_loop:
         call     GET_KEY
         or       a
         jr       z,enter_name_loop
         cp       K_DEL
         jr       z,backup
         cp       K_ENTER
         jr       z,nomore
         ld       c,a
         ld       a,15
         cp       b
         jr       z,enter_name_loop
         ld       hl,chartable-10
         ld       e,c
         ld       d,0
         add      hl,de
         ld       a,(hl)
         ld       (ix),a
         ROM_CALL(TX_CHARPUT) 
         inc      b
         inc      ix
         jr       enter_name_loop
backup:  dec      b
         ld       a,255
         cp       b
         jr       z,too_far
         dec      ix
         ld       (ix),32
         ld       hl,CURSOR_COL
         dec      (hl)
         ld       a,32
         ROM_CALL(TX_CHARPUT)
         dec      (hl)
         jr       enter_name_loop
too_far: inc      b
         jr       enter_name_loop
nomore:
         ld       hl,lowest
         ld       de,(score)
         ld       (hl),e
         push     hl
         inc      hl
         ld       (hl),d
         pop      ix              ;sort hiscore table
         ld       b,6
sort_scores
         ld       e,(ix)
         ld       d,(ix+1)
         ld       l,(ix-19)
         ld       h,(ix-18)
         call     CP_HL_DE
         ret      nc
         push     bc
         ld       b,19
         ld       d,0
exg_loop:ld       e,(ix)
         ld       c,(ix-19)
         ld       (ix),c
         ld       (ix-19),e
         inc      ix
         inc      hl
         djnz     exg_loop
         ld       de,-38
         add      ix,de
         pop      bc
         djnz     sort_scores
         ret
 ;---------------------- THE MAIN GAME -----------------------
play_level:
         ld       a,1
         ld       (stop),a
game_main_loop:
         ld       hl,GRAPH_MEM
         ld       b,110
         xor      a
clgloop: ld       (hl),a
         inc      hl
         ld       (hl),a
         inc      hl
         ld       (hl),a
         inc      hl
         ld       (hl),a
         inc      hl
         ld       (hl),a
         inc      hl
         ld       (hl),a
         inc      hl
         ld       (hl),a
         inc      hl
         ld       (hl),a
         inc      hl
         djnz     clgloop
         ld       a,(guard)
         ld       b,16
dbloop:  ld       (hl),a
         inc      hl
         djnz     dbloop
         ld       a,(speed)             ;Slow down a bit
         or       a
         call     nz,waste_time
         ld       hl,(timer)
         inc      hl
         ld       (timer),hl
         call     redraw_solid          ;Redraw all blocks

         xor      a
         ld       (aball),a
         ld       hl,x
         ld       b,3
ldb:     push     hl
         push     bc
         call     ballstuff
         pop      bc
         pop      hl
         ld       de,4
         add      hl,de
         djnz     ldb

         ld       a,(aball)
         or       a
         ret      z
not_hit_right_edge:
         ld       a,%00111111           ;Exit key = get out!
         out      (1),a
         in       a,(1)
         bit      6,a
         jp       z,r3
         ld       a,%01111110           ;Left arrow = go left!
         out      (1),a
         in       a,(1)
         rrca
         jr       c,no_save
         ld       hl,saved_flag
         ld       (hl),1
         ld       de,saved_flag+1
         ld       hl,TEXT_MEM+1
         ld       bc,160
         ldir
         jp       exit_game
no_save:
         rrca
         push     af
         call     nc,go_left
         pop      af
         rrca
         call     nc,go_right

         ld       a,(p)                 ; Draw paddle
         srl      a
         ld       d,a
         ld       e,52
         ld       ix,paddlen
         ld       a,(expand)
         or       a
         jr       z,nw111
         ld       ix,paddlew
nw111:
         call     drw_sprw

         call     bonus_blocks

         ld       de,$fc80
         ld       hl,GRAPH_MEM
         ld       bc,896
         ldir
         call     update_score
         ld       a,(stop)
         or       a
         jr       nz,stopped
         ld       a,%01111101
         out      (1),a
         in       a,(1)
         bit      6,a
         ret      z
         ld       a,(won)
         or       a
         jp       nz,game_main_loop
         ret

stopped: SUB      A
         ld       (stop),a

         ld       hl,$2921
         ld       (CURSOR_X),hl
         ld       hl,press_enter
         ROM_CALL(D_ZM_STR)
we1:   
         call     wait_key
         cp       K_ENTER
         jr       nz,we1
         jp       game_main_loop

 ; -------------- BONUS BRICKS ----------------------------------------------
killbb:  dec      hl
         dec      hl
         ld       (hl),0
         ret
bonus_blocks:
         ld       hl,bonust
         ld       a,(hl)
         dec      a
         RET      M
         jr       z,b1
         dec      a
         jr       z,b2
         dec      a
         jr       z,b3
         dec      a
         jr       z,b4
         dec      a
         jr       z,b5
         dec      a
         jr       z,b6
         ld       ix,bonus_7
         jr       done
b1:
         ld       ix,bonus_4
         JR       done
b2:
         ld       ix,bonus_2
         jr       done
b3:
         ld       ix,bonus_3
         jr       done
b4:
         ld       ix,bonus_1
         jr       done
b5:
         ld       ix,bonus_5
         jr       done
b6:
         ld       ix,bonus_6
         jr       done
      
done:    inc      hl
         LD       D,(hl)
         srl      d
         inc      hl
         ld       e,(HL)
         call     drw_sprw
         ld       hl,bonusy
         ld       a,(timer)
         and      1
         add      a,(hl)
         ld       (hl),a
         ld       a,(hl)
         cp       56
         jr       z,killbb
         cp       50
         ret      m
         dec      hl
         ld       a,(p)
         neg
         add      a,(hl)
         add      a,20
         ret      m
exp1:    sub      52
         ret      p
         dec      hl
         ld       a,(hl)
         ld       (hl),0
         dec      a
         JR       Z,got1
         dec      a
         jr       z,got2
         dec      a
         JR       Z,got3
         dec      a
         jr       z,got4
         dec      a
         jr       z,got5
         dec      a
         jr       z,got6
got7:    ld       hl,bthru
         inc      (hl)
         inc      (hl)
         ret

got1:    ld       hl,lives
         inc      (hl)
         reT

got2:    ld       hl,(score)
         ld       de,25
         add      hl,de
         ld       (score),hl
         ld       a,(x2+3)
         or       a
         jr       nz,b1_no
         ld       hl,x
         ld       de,x2
         ld       bc,4
         ldir
         ld       hl,x2+1
         inc      (hl)
b1_no:   ld       a,(x3+3)
         or       a
         ret      nz
         ld       hl,x
         ld       de,x3
         ld       bc,4
         ldir
         ld       hl,x3+1
         dec      (hl)

         ret

got3:    ld       hl,(score)
         ld       de,25
         add      hl,de
         ld       (score),hl
         ld       a,32
         ld       (expand),a
         ld       a,84
         ld       (exp1+1),a
         ld       hl,$3fcb
         ld       (exp2),hl
         ret

got4:    ld       hl,(score)
         ld       de,100
         add      hl,de
         ld       (score),hl
         ret

got5:    LD       A,255
         LD       (guard),a
         ret
got6:    ld       hl,catch
         inc      (hl)
         inc      (hl)
         ret

  ; ------------------- UTILITY ROUTINES ----------------------
un_expand:
         ld       a,52
         ld       (exp1+1),a
         xor      a
         ld       hl,exp2
         ld       (hl),a
         inc      hl
         ld       (hl),a
         ld       (expand),a
         ret

nothing: ld       a,32
         jr       dispit2
update_score:
         ld       hl,$700
         ld       (CURSOR_ROW),hl
         ld       a,(lives)
         ld       l,a
         ld       h,0
         call     DIV_A_HL
         add      a,48
         push     hl
         ROM_CALL(TX_CHARPUT)
         ld       hl,$600
         ld       (CURSOR_ROW),hl
         pop      hl
         call     DIV_A_HL
         or       a
         jr       z,nothing
         add      a,48
dispit2: ROM_CALL(TX_CHARPUT)

         ld       hl,$fc74
         ld       a,255
         ld       (hl),a
         inc      hl
         ld       (hl),a
         inc      hl
         ld       (hl),a
         ld       hl,$1000
         ld       (CURSOR_ROW),hl
         ld       hl,(score)
         ROM_CALL(D_HL_DECI)
         ld       hl,$fc7c
         ld       a,255
         ld       (hl),a
         inc      hl
         ld       (hl),a
         inc      hl
         ld       (hl),a
         inc      hl
         ld       (hl),a
         ret

init_display:
         ROM_CALL(CLEARLCD)
         ld       (CURSOR_ROW),de
         ld       hl,ingame
         ROM_CALL(D_ZT_STR)
         ld       hl,$fc70
         ld       (hl),255
         ld       de,$fc71
         ld       bc,15
         ldir
         ret
restore_game:                             ;Restore the game
         ld       (hl),0
         inc      hl
         ld       de,TEXT_MEM+1
         ld       bc,160
         ldir
         call     init_display
         jp       restore_position
wait_key:ld       a,40                   ;Wait for a keypress
         call     waste_time
wait_inner:
         call     GET_KEY
         or       a
         ret      nz
         jr       wait_inner

r3:      pop      af
         ret
go_right:
         ld       a,(expand)
         neg
         add      a,224
         ld       d,a
         ld       a,(p)
         cp       d
         jr       z,right_edge
         inc      a
         ld       c,1
         in       e,(c)
         bit      3,e
         jr       z,quit_moving
         cp       d
         jr       z,right_edge
         inc      a
         cp       d
         jr       z,right_edge
         inc      a
         cp       d
         jr       z,right_edge
         inc      a
         cp       d
         jr       z,right_edge
         inc      a
quit_moving:
         ld       (p),a
         ret
right_edge:                   ;If paddle is at right edge
         ld       a,d
         ld       (p),a
         ret
go_left:
         ld       a,(p)
         cp       0
         jr       z,left_edge
         dec      a
         jr       z,left_edge
         ld       c,1
         in       e,(c)
         bit      3,e
         jr       z,quit_moving
         dec      a
         jr       z,left_edge
         dec      a
         jr       z,left_edge
         dec      a
         jr       z,left_edge
         dec      a
         ld       (p),a
         xor      a
         ret
left_edge:                     ;If paddle is at left edge
         xor      a
         ld       (p),a
         ret
waste_time:
l:       halt
         dec      a
         jr       nz,l
         ret

redraw_solid:                 ;Redraw all bricks
         ld       hl,won
         ld       (hl),0
         ld       ix,GRAPH_MEM
         ld       hl,data
         ld       b,8
rs_outer:push     bc
         ld       b,16
         ld       de,
rs_inner:ld       a,(hl)
         dec      a
         jr       z,draw_block
         dec      a
         JR       Z,draw_block_tough
         dec      a
         jr       z,draw_block_solid
ok:      inc      hl
         inc      ix
         djnz     rs_inner
         ld       de,48
         add      ix,de
         pop      bc
         djnz     rs_outer
         ret
draw_block:                   ;Draw a standard block
         cpl
         ld       (won),a
         ld       (ix+0),255
         ld       (ix+16),129
         ld       (ix+32),129
         ld       (ix+48),255
         jp       ok
draw_block_solid:             ;Draw a solid block
         ld       (ix+0),255
         ld       (ix+16),255
         ld       (ix+32),255
         ld       (ix+48),255
         jp       ok
draw_block_tough:             ;Draw a tough block
         cpl
         ld       (won),a
         ld       (ix+0),255
         ld       (ix+16),195
         ld       (ix+32),195
         ld       (ix+48),255
         jp       ok
 ; -------------- SRPITE DRAWING ROUTINE ------------------------------------
offsets_table:
         .db      128,64,32,16,8,4,2,1
drw_spr: ld       a,d
         and      7
         ld       hl,offsets_table
         ld       c,a
         ld       b,0
         add      hl,bc
         ld       a,(hl)
         ld       (smc1+1),a

         ld       hl,GRAPH_MEM          ;Calculate byte number
         ld       B,0
         ld       a,e
         add      a,a
         add      a,a
         add      a,a
         rl       b
         add      a,a
         rl       b
         ld       c,d
         srl      c
         srl      c
         srl      c
         or       c
         ld       c,a
         add      hl,bc                                    
          
         ld       d,(ix)       
         ld       b,(ix+1)        
oloop:   push     bc                ;Save # of rows
         push     hl                ;Save screen address
         ld       b,d               ;Load width
         ld       c,(ix+2)          ;Load one line of image
         inc      ix
smc1     ld       a,1               ;Load pixel mask
iloop:   sla      c                 ;Test leftmost pixel
         jr       nc,noplot         ;See if a plot is needed
         ld       e,a               ;OR pixel with screen
         or       (hl)
         ld       (hl),a
         ld       a,e
noplot:  rrca
         jr       nc,notedge        ;Test if edge of byte reached
         inc      hl                ;Go to next byte
notedge: djnz     iloop
         pop      hl                ;Restore address
         ld       bc,16             ;Go to next line
         add      hl,bc
         pop      bc                ;Restore data
         djnz     oloop
         ret

drw_sprw:ld       a,d
         and      7
         ld       hl,offsets_table
         ld       c,a
         ld       b,0
         add      hl,bc
         ld       a,(hl)
         ld       (wsmc1+1),a
         ld       (wsmc2+1),a

         ld       hl,GRAPH_MEM       ;Calculate byte number
         ld       B,0
         ld       a,e
         add      a,a
         add      a,a
         add      a,a
         rl       b
         add      a,a
         rl       b
         ld       c,d
         srl      c
         srl      c
         srl      c
         or       c
         ld       c,a
         add      hl,bc                                    
          
         ld       d,(ix)       
         ld       b,(ix+1)        
woloop:  push     bc                ;Save # of rows
         push     hl                ;Save screen address
         ld       b,d               ;Load width
         ld       c,(ix+2)          ;Load one line of image
         inc      ix
wsmc1    ld       a,1               ;Load pixel mask
wiloop:  sla      c                 ;Test leftmost pixel
         jr       nc,wnoplot         ;See if a plot is needed
         ld       e,a               ;OR pixel with screen
         or       (hl)
         ld       (hl),a
         ld       a,e
wnoplot: rrca
         jr       nc,wnotedge        ;Test if edge of byte reached
         inc      hl                ;Go to next byte
wnotedge
wsmc2:   cp       1
         jr       z,wover_1

         djnz     wiloop
         pop      hl                ;Restore address
         ld       bc,16             ;Go to next line
         add      hl,bc
         pop      bc                ;Restore data
         djnz     woloop
         ret
wover_1: ld       c,(ix+2)
         inc      ix
         djnz     wiloop
         dec      ix
         pop      hl
         ld       bc,16
         add      hl,bc
         pop      bc
         djnz     woloop
         ret

 ; -------------- SPRITE FOR PADDLE -----------------------------------------
paddlen: .db      16,4
         .db      %01111111,%11111110
         .db      %10000000,%00000001
         .db      %10000000,%00000001
         .db      %01111111,%11111110
paddlew: .db      32,4
         .db      %01111111,%11111111,%11111111,%11111110
         .db      %10000000,%00000000,%00000000,%00000001
         .db      %10000000,%00000000,%00000000,%00000001
         .db      %01111111,%11111111,%11111111,%11111110

spr_ball:.db      3,3
         .db      %01000000
         .db      %11100000
         .db      %01000000
 ; -------------- FIND A LEVEL ----------------------------------------------
level_addr:
         ld       hl,this_universe-32
         ld       a,(level)
         ld       b,a
         inc      b
         ld       de,32
find_level_loop:
         add      hl,de
         djnz     find_level_loop
         RET

 ; -------------- PROCESS A BALL -------------------------------------------
release: ld       (hl),50
         inc      hl
         ld       (hl),-1
         dec      hl
         dec      hl
         dec      hl
         ld       a,(p)
         add      a,(hl)
         ld       (hl),a
         jp       ballstuff

coughtit:
         dec      (hl)
         pop      hl                         ;HL -> Y
         inc      hl
         ld       (hl),55
         dec      hl
         dec      hl
         dec      hl                         ;HL -> X
         ld       a,(p)
         sub      (hl)
         neg
         ld       (hl),a
         inc      hl
         inc      hl

caught_ball:                                 ;HL -> Y
         ld       a,%00111111
         out      (1),a
         ld       e,51
         in       a,(1)
         bit      5,a
         jr       z,release
         ld       a,(p)
         dec      hl
         dec      hl
         add      a,(hl)
         srl      a
         Dec      a
         ld       d,a
         dec      a
         ld       ix,spr_ball
         jp       drw_spr

paddle:
         push     hl
         dec      hl
         dec      hl
         ld       a,(hl)                     ;HL -> X
         ld       hl,p
         sub      (hl)
         pop      hl                         ;HL -> Y
         jp       m,doneyb
exp2:    nop
         nop
         ld       e,a
         and      224
         jp       nz,doneyb
         push     hl
         inc      hl                         ;HL -> YV
         ld       (hl),-1

         ld       d,0
         ld       hl,bounces
         add      hl,de
         ld       a,(hl)
         pop      hl
         push     hl                
         dec      hl                         ;HL -> XV
         ld       (hl),a
         ld       a,5
         ld       (incr),a
         ld       hl,bthru
         ld       a,(hl)
         or       a
         jr       z,ndbt
         dec      a
         ld       (hl),a
ndbt:

         ld       hl,catch
         ld       a,(hl)
         or       a
         jr       nz,coughtit
         pop      hl

         jr       doneyb

top:     inc      hl
         ld       (hl),1
         dec      hl
         jr       doneyb

bottom:  ld       a,(guard)
         or       a
         jr       nz,guarded
         inc      hl
         ld       (hl),0
         ret
guarded: inc      hl
         ld       (hl),-1
         dec      hl
         rrca
         ld       a,%10101010
         ld       (guard),a
         jr       c,doneyb
         xor      a
         ld       (guard),a
         jr       doneyb

ballstuff:
         inc      hl
         inc      hl
         inc      hl                         ;HL -> YV
         ld       a,(hl)

         or       a
         ret      z
         ld       (aball),a
         cp       55
         dec      hl                         ;HL -> Y

         jp       z,caught_ball
         add      a,(hl)
         ld       (hl),a
         dec      a
         jr       z,top
         cp       50
         jr       z,paddle
         cp       51

         jr       z,paddle
         cp       52
         jr       z,paddle
         cp       53
         jr       z,bottom
doneyb:                                      ;HL -> Y
         push     hl
         call     test_hit
         pop      hl
         jr       nc,nohit1
         ld       a,(bthru)
         or       a
         jr       nz,nohit1
         inc      hl
         ld       a,(hl)
         neg
         ld       (hl),a
         dec      hl
         add      a,(hl)
         ld       (hl),a
nohit1:
         dec      hl
         ld       a,(hl)
         dec      hl
         add      a,(hl)
         ld       (hl),a                     ;HL -> X
         inc      hl                         ;HL -> XV
         rrca
         rrca
         and      63
         jr       z,forceright
         cp       63
         jr       z,forceleft
dodraw:
         push     hl
         inc      hl                         ;HL -> Y
         call     test_hit
         pop      hl
         jr       nc,nohit2
         ld       a,(bthru)
         or       a
         jr       nz,nohit2
         ld       a,(hl)
         neg
         ld       (hl),a
         dec      hl
         add      a,(hl)
         ld       (hl),a
         inc      hl
nohit2:
         dec      hl
         ld       d,(hl)
         inc      hl
         inc      hl                         ;HL -> Y
         srl      d
         dec      d
         ld       e,(hl)
         dec      e

         ld       ix,spr_ball
         call     drw_spr
         ret
forceright:
         ld       a,(hl)
         neg
         jp       m,dodraw
         ld       (hl),a
         jr       dodraw
forceleft:
         ld       a,(hl)
         neg
         jp       p,dodraw
         ld       (hl),a
         jr       dodraw
 ; -------------- TEST IF THE BALL HITS A BRICK ------------------------
test_hit:
         ld       a,(hl)
         ld       e,a
         bit      5,a
         jr       nz,bottom_half
         and      28
         add      a,a
         add      a,a
         ld       b,a
         dec      hl
         dec      hl
         ld       a,(hl)
         and      240
         ld       d,a
         rrca
         rrca
         rrca
         rrca
         and      15
         or       b
         ld       c,a
         ld       b,0
         ld       hl,data
         add      hl,bc
         ld       a,(hl)
         dec      a
         jr       z,hit_1
         dec      a
         jr       z,hit_2
         dec      a
         jr       z,hit_3
bottom_half:
         scf
         ccf
         ret
hit_1:   ld       (hl),0
         ld       hl,(score)
         ld       a,(incr)
         inc      a
         ld       (incr),a
         ld       c,a
         ld       b,0
         add      hl,bc
         ld       (score),hl
         ld       a,r
         rrca
         ret      c
         and      3
         inc      a

         ld       b,a
         ld       a,d
         rla
         jr       c,abcdef
         ld       hl,bonust
         ld       a,(hl)
         or       a
         scf
         ret      nz
         ld       (hl),b
         inc      hl
         ld       (hl),d
         inc      hl
         ld       (hl),e
         scf
         ret

abcdef:  inc      b
         inc      b
         inc      b
         ld       hl,bonust
         ld       a,(hl)
         or       a
         scf
         ret      nz
         ld       (hl),b
         inc      hl
         ld       a,d
         sub      8
         ld       (hl),a
         inc      hl
         ld       (hl),e
         scf
         ret

hit_2:   ld       (hl),1
         ld       hl,(score)
         inc      hl
         ld       (score),hl
hit_3:   scf
         ret
         
 ; -------------- DATA -------------------------------------------------
bounces: .db      -3,-3
         .db      -2,-2,-2,-2,-2,-2
         .db      -1,-1,-1,-1,-1,-1
         .db      0,0,0,0
         .db      1,1,1,1,1,1
         .db      2,2,2,2,2,2
         .db      3,3
initial_msg: 
         .db      "--- Orzunoid v1.3 ---",0
         .db      "by Patrick A Davidson"
         .db      "  (ariwsi@juno.com)  "
         .DB      "   Copyright 1997    "
         .db      "Choose Speed : F1-F5"
         .db      0
scrltext:.db      "                "
         .db      "WELCOME TO ORZUNOID!  "
         .db      "PRESS [F1] TO PLAY AT THE "
         .DB      "SLOWEST SPEED AND [F5] FOR "
         .db      "THE FASTEST SPEED.  PRESS "
         .db      "[ALPHA] TO VIEW THE HIGH "
         .DB      "SCORES.  IN THE GAME, USE "
         .DB      "LEFT AND RIGHT ARROWS TO "
         .DB      "MOVE YOUR PADDLE.  PRESS "
         .DB      "THE DOWN ARROW TO SAVE "
         .DB      "THE GAME AND EXIT.  HOLD "
         .DB      "DOWN THE UP ARROW WHILE "
         .DB      "MOVING TO MOVE MORE SLOWLY.  "
         .DB      "PRESS [2nd] TO RELEASE A "
         .db      "BALL THAT YOU HAVE CAUGHT "
         .DB      "AND [CLEAR] TO GIVE UP "
         .DB      "THE CURRENT LIFE.  "
         .DB      "TEXT RESTARTS... "
scrl_end:.db      "                "
ingame:  .db      "Lives:    Score:"
 ; -------------------- GAME DATA -------------------------------------------
saved_flag:
         .db      0
         .dw      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
         .dw      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
         .dw      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
         .dw      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
         .dw      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

this_universe:
         .dw      0,0,0,0,0,0,0,0,0,0,0,0
         .dw      0,0,0,0,0,0,0,0,0,0,0,0
         .dw      0,0,0,0,0,0,0,0,0,0,0,0
         .dw      0,0,0,0,0,0,0,0,0,0,0,0
 ; -------------------- UNIVERSE DATA ---------------------------------------
universe:
         .db      %11111100,%00000000,%00000000,%00111111
         .db      %11110000,%00000000,%00000000,%00001111
         .db      %11000000,%00000000,%00000000,%00000011
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%10101010,%10101010,%00000000
         .db      %00000000,%01010101,%01010101,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000

         .db      %11000000,%00000000,%00000000,%00000011
         .db      %11010101,%01010101,%01010101,%01010111
         .db      %11000000,%00000000,%00000000,%00000011
         .db      %11010101,%01010101,%01010101,%01010111
         .db      %11000000,%00000000,%00000000,%00000011
         .db      %11010101,%01010101,%01010101,%01010111
         .db      %11000000,%00000000,%00000000,%00000011
         .db      %11000000,%00000000,%00000000,%00000011

         .db      %01000100,%01000100,%01000100,%01000100
         .db      %00010001,%00010001,%00010001,%00010001
         .db      %01000100,%01000100,%01000100,%01000100
         .db      %00010001,%00010001,%00010001,%00010001
         .db      %01000100,%01000100,%01000100,%01000100
         .db      %00010001,%00010001,%00010001,%00010001
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %11111100,%00000000,%00000000,%00111111
 ; ---------------------- BONUS BLOCKS --------------------------------------
bonus_1: .db      11,5
         .db      %10011000,%11000000
         .db      %10100101,%00100000
         .db      %10100101,%00100000
         .db      %10100101,%00100000
         .db      %10011000,%11000000
bonus_2: .db      11,3
         .db      %01000100,%01000000
         .db      %11101110,%11100000
         .db      %01000100,%01000000
bonus_3: .db      12,5
         .db      %00100000,%01000000
         .db      %01000000,%00100000
         .db      %11111111,%11110000
         .db      %01000000,%00100000
         .db      %00100000,%01000000
bonus_4: .db      11,3
         .db      %01111111,%11000000
         .DB      %10000000,%00100000
         .db      %01111111,%11000000
bonus_5: .db      12,2
         .db      %11111111,%11110000
         .db      %11111111,%11110000
bonus_6: .db      12,4
         .db      %10000000,%00010000
         .db      %10000000,%00010000
         .db      %11111111,%11110000
         .db      %10000000,%00010000
bonus_7: .db      12,5
         .db      %00100000,%00000000
         .db      %01000000,%10000000
         .db      %11111111,%11110000
         .db      %01000000,%10000000
         .db      %00100000,%00000000
 ; -------------------- HIGH SCORES -----------------------------------------
hi_score_str:
         .db      "---> ORZUNOID 86 <---"
         .db      "  You have a hiscore!"
         .db      "Enter your name:     ",0
hstitle: .db      "=ORZUNOID HIGHSCORES=",0
hsdata:  .dw      20000
         .db      "ORZUNOID 1.3    ",0
         .dw      15000
         .db      "ORZUNOID 1.3    ",0
         .dw      10000
         .db      "ORZUNOID 1.3    ",0
         .dw      7500
         .db      "ORZUNOID 1.3    ",0
         .dw      5000
         .db      "ORZUNOID 1.3    ",0
         .dw      4000
         .db      "ORZUNOID 1.3    ",0
lowest   .dw      3000
         .db      "ORZUNOID 1.3    ",0
chartable:
         .db      "XTOJE."
         .db      ". WSNID!.ZVRMHC?"
         .db      ".YUQLGB#x~+PKFA|"
         .db      "@54321.~+"
press_enter:
         .db      "Press [ENTER] to play",0
         .end
