;Monopoly 92 Beta
;For the 92 and 92+
;by Daniel Plaisted
;dsplaisted@bigfoot.com    <- use this one preferrably
;dsplaisted@geocities.com
;Please do not distribute a modified version without getting my permission
;first.  You may port it to a newer version of Fargo or something if I don't
;answer an email in about a week or so.


        include "flib.h"
        include "tios.h"
        include "linelib.h"
	xdef	_main
	xdef	_comment
_main:
        bsr     newgame
        jsr     flib::zap_screen
        bsr     drawlines               ;draw dividing line
        bsr     drawboard
        move.w  #0,-(A7)                ;set the font
        jsr     tios::FontSetSys
        lea     2(A7),A7
        lea     fmenu2,A6
        bsr     show1
        lea     fmenu1,A6
        bsr     show2
;------test routine----------

;------end test routine------

;start menu
menu:

        move.w  curplay,transplr
        lea     nullstring,A6
        bsr     show5
        move.w  curplay,d0
        bsr     plraddress
        move.w  2(A6),-(A7)             ;money
        bsr     pname
        move.l  A6,-(A7)                ;name
        pea     srolldice1
        pea     buffer
        jsr     tios::sprintf
        lea     14(A7),A7

        lea     buffer,A6
        bsr     show4

        move.w  curplay,d0
        bsr     plraddress
        move.w  (A6),d2
        bsr     showprop
        lea     srolldice,A6
        bsr     show3

        pea     stappsint
        move.w  curplay,d0
        bsr     pname
        move.l  A6,-(A7)
        pea     stmenu
        pea     buffer
        jsr     tios::sprintf
        lea     16(A7),A7

        pea     buffer
        bsr     showhelp
        lea     4(a7),A7

        bsr     gkey                    ;get keypress
        cmp.w   #264,d0                 ;If key=ESC then
        beq     endprgm                 ;goto endprgm
        cmp.w   #268,d0                 ;If key=F1 then
        beq     mthrowdie               ;goto mthrowdie
        cmp.w   #265,d0                 ;If key=APPS
        beq     mint                    ;goto mint
        cmp.w   #13,d0                  ;If key=Enter
        beq     mthrowdie

        bra     menu                    ;goto menu

mthrowdie:
        bsr     throwdie                ;call rolldie
        bra     menu                    ;goto menu

mint:
        bsr     interrupt
        bra     menu

endprgm:        ;the Absolute end of the program.
        rts


throwdie:
        move.w  curplay,d0
        bsr     plraddress
        move.b  4(A6),d1        ;if in jail or not
        cmp.b   #0,d1
        beq     notinjail
        bra     jailroll

notinjail:
        bsr     rolldie
rolleddie:
        move.w  curplay,d0
        cmp.w   #3,doubles      ;check if rolled 3 doubles in a row
        bne     not3doubles
        bsr     gojail
        bra     nextplayer

not3doubles:
        bsr     plraddress      ;A6 now points to current player
        move.w  roll,d0         
        add.w   d0,(A6)         ;add roll to position
        move.w  (A6),d0
        cmp.w   #40,d0          ;check if went past go
        blt     notwrap
        sub.w   #40,d0
        move.w  d0,(A6)
        move.w  curplay,d0      ;add $200
        move.w  #200,d1
        bsr     addmoney
notwrap:
        move.w  curplay,d0      ;print name of property
        bsr     plraddress
        move.w  (A6),d2
        bsr     getname
        bsr     print

;This section of code takes action depending on where player landed
        move.w  curplay,d0
        bsr     plraddress
        move.w  (A6),d2
        bsr     showprop
        move.w  curplay,d0
        bsr     plraddress
        move.w  (A6),d1         ;current position
        bsr     posaddress      ;A6 now contains pointer to info about
                                ;space which player is on
        move.w  (A6),d2         ;property type
        cmp.w   #0,d2           ;do nothing (Jail,free parking,GO)
        beq     chkdoubles
        cmp.w   #1,d2           ;Go to jail
        beq     actgojail
        cmp.w   #2,d2           ;luxury tax
        beq     actluxtax
        cmp.w   #6,d2           ;normal property
        bge     buyorpay



        bra     chkdoubles

actgojail:
        bsr     gojail
        bra     nextplayer
actluxtax:                      ;pay $75
        ;curplay already in d0
        move.w  curplay,d0
        move.w  #75,d1
        move.w  #0,d2           ;Has to pay
        bsr     pay
        bra     chkdoubles

buyorpay:                       ;check if property landed on is owned
        move.w  curplay,d0
        bsr     plraddress
        move.w  (A6),d2
        bsr     propaddress
        move.w  (A6),d3

        ;no reason for player to pay himself
        cmp.w   d0,d3
        beq     chkdoubles
        move.w  2(A6),d6        ;number of houses,6 if mortgaged
        cmp.w   #6,d6
        beq     chkdoubles      ;don't pay for a mortgaged property

        cmp.w   #6,d3
        beq     buyprop

        move.w  d2,d1           ;decide which rent routine to use
        bsr     posaddress
        cmp.w   #6,(A6)
        beq     payprop         ;normal property
        cmp.w   #7,(A6)
        beq     payrr           ;railroad
        cmp.w   #8,(A6)
        beq     payutil
        bra     chkdoubles

payprop:                        ;routine to pay rent
;        bsr     propaddress
        move.w  d3,D7           ;plr to pay to
        move.w  curplay,d0
        bsr     plraddress
        move.w  (A6),d1
        bsr     posaddress
        asl.w   #1,d6           ;multiply # of houses by 2
        move.w  4(A6,d6.w),d5   ;amount to pay
        bra     payrent

payrr:  ;pay rent on a railroad
        move.w  d3,d7           ;plr to pay to
        move.w  #5,d4           ;counter
        move.w  #25,d5          ;amount to pay
payrrchkloop:
        move.w  d4,d2
        bsr     propaddress
        cmp.w   (A6),d7         ;check if owned by player to whom is being paid
        bne     payrrinc
        asl     #1,d5           ;multiply by 2
payrrinc:
        add.w   #10,d4
        cmp.w   #40,d4
        blt     payrrchkloop

        asr     #1,d5           ;divide rent by 2
        bra     payrent

payutil:
        clr.l   d2
        clr.l   d4
        move.w  d3,d7           ;player to pay to
        cmp.w   #1,util10
        bne     payutilcount
        move.w  #10,d4
        move.w  die1,-(A7)              ;save old roll so can check doubles
        move.w  die2,-(A7)
        move.w  roll,-(A7)
        bsr     rolld                   ;roll dice

        mulu    d2,d4
        move.w  d4,d5
        move.w  (A7)+,roll
        move.w  (A7)+,die2              ;restore old roll
        move.w  (A7)+,die1
        move.w  #0,util10
        move.w  curplay,d0
        bra     payrent


payutilcount:
        move.w  #12,d2
        bsr     propaddress
        cmp.w   (A6),d7
        bne     checkww
        move.w  #4,d4
checkww:
        move.w  #28,d2
        bsr     propaddress
        cmp.w   (A6),d7
        bne     endpayutilcount
        cmp.w   #4,d4
        beq     payutilhasboth
        move.w  #4,d4
        bra     endpayutilcount
payutilhasboth:
        move.w  #10,d4
endpayutilcount:
        move.w  roll,d2
        mulu    d2,d4
        move.w  d4,d5

        move.w  #0,util10
        move.w  curplay,d0
        bra     payrent

;d5=amnt to pay,d0=player who pays,d7=plr to pay to
payrent:
        move.w  d5,d1
        move.w  d5,amount       ;save amount to pay
        move.w  #0,d2           ;has to pay
        bsr     pay

        ;give money to other player
        move.w  d7,d0
        move.w  amount,d1
        bsr     addmoney

        move.w  d7,d0           ;print info
        bsr     pname
        move.l  A6,-(A7)
        move.w  curplay,d0
        bsr     pname
        move.l  A6,-(A7)
        pea     paidrent1
        pea     buffer
        jsr     tios::sprintf
        lea     16(A7),A7

        lea     buffer,A6
        bsr     print

        move.w  curplay,d0
        bsr     plraddress
        move.w  (A6),d2
        bsr     getname
        move.l  A6,-(A7)        ;name of prop

        move.w  amount,d1
        move.w  d1,-(A7)        ;anount to pay
        pea     paidrent2
        pea     buffer
        jsr     tios::sprintf
        lea     14(A7),A7

        lea     buffer,A6
        bsr     print


        bra     chkdoubles
buyprop:                        ;buy a property
                                ;ask player if he wants to buy it
        move.w  curplay,d0
        bsr     plraddress
        move.w  2(A6),-(A7)
        bsr     pname
        move.l  A6,-(A7)
        pea     srolldice1
        pea     buffer
        jsr     tios::sprintf
        lea     14(A7),A7
        lea     buffer,A6
        bsr     show5

        move.w  curplay,d0
        bsr     plraddress
        move.w  (A6),d2
        bsr     getname         ;name of property
        move.l  A6,-(A7)
        pea     buyornot1
        pea     buffer
        jsr     tios::sprintf
        lea     12(A7),A7

        lea     buffer,A6
        bsr     show4
        lea     buyornot2,A6
        bsr     show3


buyornotgkey:
;        jsr     flib::idle_loop
        bsr     gkey
        cmp.w   #268,d0                 ;F1-Buy property
        beq     dobuyprop
        cmp.w   #13,d0                  ;Enter also works
        beq     dobuyprop
        cmp.w   #272,d0                 ;F5-Auction it off
        beq     auction

        bra     buyprop
dobuyprop:
        move.w  curplay,d0
        bsr     plraddress
        move.w  (A6),d1
        bsr     posaddress
        move.w  2(A6),d1
        move.w  #1,d2                   ;doesn't have to buy it... can cancel
        move.w  curplay,d0
        bsr     pay                     ;pay for property
        cmp.w   #0,d0                   ;didn't pay
        beq     buyornotgkey

        move.w  curplay,d0
        bsr     plraddress
        move.w  (A6),d2
        bsr     propaddress
        move.w  d0,(A6)

        bsr     plraddress              ;print msg that plr bought property
        move.w  (A6),d2
        bsr     getname
        move.l  A6,-(A7)                ;name of prop
        bsr     pname
        move.l  A6,-(A7)
        pea     boughtprop
        pea     buffer
        jsr     tios::sprintf
        lea     16(A7),A7

        lea     buffer,A6
        jsr     print



        bra     chkdoubles
auction:                ;auctioning is not implemented yet :)
        bra chkdoubles
;end section of code that takes action according to where player landed

chkdoubles:                     ;check for doubles
        cmp.w   #0,doubles
        bne     skipcurplayw

nextplayer:
        add.w   #1,curplay      ;next player
        move.w  numplayers,d1
        cmp.w   curplay,d1
        bge     skipcurplayw    ;skip player wrapping
        move.w  #0,curplay
        move.w  #0,doubles
skipcurplayw:
        rts


posaddress:     ;returns in A6 pointer to property # passed in d1
        move.l  d1,-(A7)        ;save d1
        lea     go,A6           ;get address of first property
        mulu    #20,d1
        add.l   d1,A6
        move.l  (A7)+,d1        ;restore d1
        rts
propaddress:    ;returns in A6 pointer to changing prop # passed in d2
        move.l  d2,-(A7)
        lea     properties,A6
        mulu    #4,d2
        add.l   d2,A6
        move.l  (A7)+,d2
        rts

plraddress:     ;returns pointer to player # passed in d0 in A6
        move.l  d0,-(A7)
        lea     player0,A6
        mulu    #24,d0
        add.l   d0,A6
        move.l  (A7)+,d0
        rts
pname:          ;returns in A6 pointer to name of player # passed in d0
        bsr     plraddress
        add.l   #7,A6
        rts

getmoney:       ;returns in d0 amount of money that player in d0 has
        bsr     plraddress
        move.w  2(A6),d0
        rts

addmoney:       ;adds amount of money in d1 to player number of d0
        bsr     plraddress      ;get address
        add.l   #2,A6           ;point to money, not space on board
        add.w   d1,(A6)         ;add amount of money
        rts

;takemoney:      ;takes amount of money in d1 from player number of d0
;                ;returns 0 in d0.w if money was taken, 1 if not
;        bsr     plraddress      ;get address
;        add.l   #2,A6           ;point to money, not space on board
;        sub.w   d1,(A6)         ;subtract amount of money
;        move.w  #0,d0           ;did pay money
;        rts

pay:            ;player number in d0.w pays amount of money passed in d1.w
                ;if player has enough money, simply subtracts money
                ;d2.w specifies whether player HAS to raise money or not
                ; if d2.w <> 0 then the player can cancel paying
                ; otherwise he MUST raise the money or go bankrupt
                ;Returns:
                ; d0.w is 1 if money was subtracted
                ; d0.w is 0 if money wasn't subtracted
                ;   (This either means the player canceled or went bankrupt)
        ;already has plr # in d0
        bsr     plraddress      ;get address
        move.w  2(A6),d3         ;put amount of money in d3
        sub     d1,d3           ;subtract amount of money
        blt     nomoney         ;if result was less than zero, go to menu for
                                ;raising money
        move.w  d3,2(A6)         ;store new amount of money
;        lea     hadmoney,A6
;        bsr     print
        move.w  #1,d0           ;money was subtracted
        rts                     ;return from subroutine
nomoney:
;        lea     hadnomoney,A6   ;get address of nomoney msg
;        bsr     print           ;print msg
        ;need to add moneyraising code here... sell houses, mortgage, etc.
        move.w  #0,d0           ;didn't pay
        rts



gojail:         ;GO TO JAIL, player to put in jail passed in d0
        bsr     plraddress
        move.b  #3,4(A6)
        move.w  #10,(A6)
        bsr     pname
        move.l  A6,-(A7)
        pea     gotojailstr
        pea     buffer
        jsr     tios::sprintf
        lea     12(A7),A7
        lea     buffer,A6
        bsr     print           ;Print player landing in jail
        rts

jailroll:       ;Routine for when you are in jail
        move.w  curplay,d0              ;generate message of whether to
        bsr     pname                   ;pay $50 or roll die
        move.l  A6,-(A7)
        pea     jailstring1
        pea     buffer
        jsr     tios::sprintf
        lea     12(A7),A7
        lea     buffer,A6
        bsr     show4
        lea     jailstring2,A6
        bsr     show3
jailrollgkey:
;        jsr     flib::idle_loop         ;get keypress
        bsr     gkey
        cmp.w   #268,d0                 ;F1
        beq     jailrollpaid
        cmp.w   #272,d0                 ;F5
        beq     jailrolltry
        bra     jailroll
jailrollpaid:
        move.w  curplay,d0
        move.w  #50,d1                  ;subtract $50
        move.w  #1,d2
        bsr     pay
        cmp.w   #1,d0                   ;check if money was taken
        bne     jailroll
        move.w  curplay,d0
        bsr     plraddress
        move.b  #0,4(A6)
        bra     notinjail               ;roll the die normally
jailrolltry:
        move.w  curplay,d0
        bsr     plraddress
        sub.b   #1,4(A6)                ;1 less try
        bsr     rolld                   ;roll the die
        cmp.w   d0,d1                   ;check if got doubles
        beq     doubledout              ;if so, let out of jail

        move.w  curplay,d0
        bsr     plraddress
        cmp.b   #0,4(A6)                ;check if this was the last chance
        bne     nextplayer

        move.w  curplay,d0
        move.w  #50,d1
        move.w  #0,d2
        bsr     pay                     ;pay money
        bra     rolleddie

doubledout:
        move.w  curplay,d0
        bsr     plraddress
        move.b  #0,4(A6)                ;not in jail anymore
        bra     rolleddie               ;rolled the die, now move
;        bra     nextplayer


newgame:                                ;reset player data
        move.w  #0,d1
newgameloop:
        move.w  d1,d0
        bsr     plraddress              ;get address of player
        move.w  #0,(A6)                 ;board position
        move.w  #1500,2(A6)             ;money
        move.w  #0,4(A6)                ;use word to overwrite 2 bytes...
                                        ;in jail and commchest
        move.b  #0,6(A6)                ;doesn't have chance card

        add.w   #1,d1
        cmp.w   numplayers,d1
        ble     newgameloop
        bsr     clrbuf                  ;don't keep messages from last run.
        move.w  #0,curplay
        lea     properties,A6           ;reset property info
        move.l  A6,A5
        add.l   #166,A5
rproploop:                              ;rproploop = "reset property loop"
        move.w  #6,(A6)                 ;noone owns it
        move.w  #0,2(A6)                ;no houses
        add.l   #4,A6
        cmp.l   A5,A6
        ble     rproploop
        rts


;getname(D2.w)    number of property to get name of passed in d2
                ; returns pointer to name in A6
getname:
        move.w  d2,-(A7)
        mulu    #2,d2
        lea     strings(PC),A6
        add.l   d2,A6
        move.w  (A6),d2
        lea     stringstart(PC),A6
        add.l   d2,A6
        move.w  (A7)+,d2
        rts

rolldie:        ;rolls the die, updates doubles, dice1, dice2, prints doubles
        bsr     rolld                   ;roll die

;        move.w  d2,-(A7)                ;total
;        move.w  d1,-(A7)                ;die2
;        move.w  d0,-(A7)                ;die1
;        move.w  curplay,d0
;        bsr     pname
;        move.l  A6,-(A7)                ;Player name
;        pea     rolltext(PC)            ;text
;        pea     buffer(PC)              ;store it in buffer
;        jsr     tios::sprintf
;        lea     18(A7),A7
;        lea     buffer(PC),A6           ;print die roll
;        bsr     print

        move.w  die1,d1
        cmp.w   die2,d1                 ;if die1=die2
        bne     notdoubles              ;don't skip doubles routine
        add.w   #1,doubles              ;doubles=doubles+1
        lea     doubletext(PC),A6       ;Print "Doubles"
        bsr     print
        bra     enddoubles
notdoubles:
        move.w  #0,doubles
enddoubles:
        rts

rolld:  ;ONLY Rolls two dice, stores values in die1 and die2, stores roll
        ;prints results
        ;d0 and d1 equal rolls when it's done, d2=total
        move.w  #6,d0                   ;0-5
        jsr     flib::random
        add.w   #1,d0                   ;change to 1-6
        move.w  d0,die1                 ;store value in die 1
        move.w  d0,d1                   ;keep value

        move.w  #6,d0                   ;0-5
        jsr     flib::random
        add.w   #1,d0                   ;change to 1-6
        move.w  d0,die2                 ;store value in die 1

        move.w  d0,d2                   ;compute total
        add.w   d1,d2
        move.w  d2,roll

        move.w  d2,-(A7)                ;total
        move.w  d1,-(A7)                ;die2
        move.w  d0,-(A7)                ;die1
        move.w  curplay,d0
        bsr     pname
        move.l  A6,-(A7)                ;Player name
        pea     rolltext(PC)            ;text
        pea     buffer(PC)              ;store it in buffer
        jsr     tios::sprintf
        lea     18(A7),A7
        lea     buffer(PC),A6           ;print die roll
        bsr     print

        move.w  roll,d2
        move.w  die1,d0
        move.w  die2,d1

        rts

;skew
;d2=prop
;d3=x
;d4=y
;returns:
;d3=skewed x
;d4=skewed y
;d2=unchanged
skew:
        movem.l d0-d1/A0-A6,-(A7)
        movem.l d5-d7,-(A7)
        clr.l   d1
        clr.l   d0
        cmp.w   #10,d2
        blt     row1            ;bottom row
        cmp.w   #20,d2
        blt     row2            ;left row
        cmp.w   #30,d2
        blt     row3            ;top row
        bra     row4            ;right row

row1:
        move.w  #9,d0
        sub.w   d2,d0
        mulu    #10,d0
        add.w   d0,d3
        add.w   #15,d3
        add.w   #105,d4
        bra     endskew
row2:
        move.w  d4,d1
        move.w  d3,d4
        move.w  d0,d3
        add.w   #15,d4
        move.w  #15,d3
        sub.w   d1,d3
        move.w  d2,d1
        move.w  #19,d0
        sub.w   d1,d0
        mulu    #10,d0
        add.w   d0,d4
        bra     endskew
row3:
        move.w  #10,d0
        sub.w   d3,d0
        add.w   #15,d0
        move.w  d0,d3
        move.w  #15,d0
        sub.w   d4,d0
        move.w  d0,d4
        move.w  d2,d1
        sub.w   #21,d1
        mulu    #10,d1
        add.w   d1,d3
        bra     endskew
row4:
        move.w  d4,d1
        move.w  d3,d4
        move.w  d1,d3
        add.w   #105,d3
        move.w  #10,d0
        sub.w   d4,d0
        move.w  d0,d4
        move.w  d2,d1
        sub.w   #31,d1
        mulu    #10,d1
        add.w   d1,d4
        add.w   #15,d4
        bra     endskew        
endskew:
        movem.l (A7)+,d5-d7
        movem.l (A7)+,d0-d1/A0-A6
        rts
;drawlines()     draws the line that separates the sides of the screen
;120x238
drawlines:
;draw line from 122,0 to 122,122
        lea     LCD_MEM,A0
        move.w  #122,d0
        move.w  #0,d1
        move.w  d0,d2
        move.w  d0,d3
        jsr     linelib::fline
        bsr     drawline
        rts

drawline:
        lea     LCD_MEM,A0
        move.w  #0,d0
        move.w  #122,d1
        move.w  #237,d2
        move.w  d1,d3
        jsr     linelib::fline
;        move.w  #0,d2
;drawloop:
;        move.w  #122,-(A7)
;        move.w  D2,-(A7)
;        jsr     flib::pixel_on
;        lea     4(A7),A7
;        add.w   #1,D2
;        cmp.w   #237,D2
;        bne     drawloop
        rts

showhelp:
        move.l  4(A7),-(A7)
        jsr     tios::ST_showHelp
        lea     4(A7),A7
        bsr     drawlines
        rts

drawboard:
;0,15 to 121,15
        lea     LCD_MEM,A0
        move.w  #0,d0
        move.w  #15,d1
        move.w  #121,d2
        move.w  d1,d3
        jsr     linelib::fline
;0,105 to 121,105
        move.w  #105,d1
        move.w  d1,d3
        jsr     linelib::fline
;15,0 to 15,121
        move.w  #15,d0
        move.w  #0,d1
        move.w  d0,d2
        move.w  #121,d3
        jsr     linelib::fline
;105,0 to 105,121
        move.w  #105,d0
        move.w  d0,d2
        jsr     linelib::fline
;d0=y
        move.w  #25,drawboardline
drawboardloop1:
        lea     LCD_MEM,A0
        move.w  #14,d0
        move.w  drawboardline,d1
        move.w  #1,d2
        move.w  d1,d3
        jsr     linelib::fline

        move.w  #106,d0
        move.w  #121,d2
        jsr     linelib::fline
        add.w   #10,drawboardline
        cmp.w   #105,drawboardline
        bne     drawboardloop1

        move.w  #25,drawboardline
drawboardloop2:
        move.w  drawboardline,d0
        move.w  #0,d1
        move.w  d0,d2
        move.w  #14,d3
        jsr     linelib::fline

        move.w  #106,d1
        move.w  #121,d3
        jsr     linelib::fline
        add.w   #10,drawboardline
        cmp.w   #105,drawboardline
        bne     drawboardloop2

        move.w  #0,d7                   ;counter
showproplineloop:
        move.w  d7,d1
        move.w  d7,d2
        bsr     posaddress
        cmp.w   #6,(A6)
        bne     showproplineloopinc
        move.w  #0,d3
        move.w  #6,d4
        bsr     skew
        move.w  d3,d0
        move.w  d4,d1
        move.w  #10,d3
        move.w  #6,d4
        bsr     skew
        move.w  d3,d2
        move.w  d4,d3
        lea     LCD_MEM,A0
        jsr     linelib::fline
showproplineloopinc:
        add.w   #1,d7
        cmp.w   #40,d7
        blt     showproplineloop

        rts

showprop:       ;property to show passed in d2
        movem   d0-d7/A0-A6,-(A7)
        move.w  d2,showpropp
        move.w  #71,-(A7)              ;clear area
        move.w  #104,-(A7)
        move.w  #16,-(A7)
        move.w  #16,-(A7)
        jsr     flib::erase_rect
        lea     8(A7),A7

        bsr     getname
        move.w  #1,-(A7)
        move.l  A6,-(A7)
        move.w  #17,-(A7)
        move.w  #16,-(A7)
        jsr     tios::DrawStrXY
        lea     10(A7),A7

        move.w  showpropp,d1
        bsr     posaddress
        move.w  (A6),d3
        cmp.w   #6,d3
        beq     showpropnorm
        bra     endshowprop
showpropnorm:
;showpropprice   dc.b    "Price: $%i",0
        add.l   #2,A6
        move.w  (A6)+,-(A7)
        pea     showpropprice
        pea     buffer
        jsr     tios::sprintf
        lea     10(a7),A7

        move.w  #1,-(A7)
        pea     buffer
        move.w  #23,-(A7)
        move.w  #16,-(a7)
        jsr     tios::DrawStrXY
        lea     10(a7),A7

;showproprent    dc.b    "Rent: $%i",0
        move.w  (A6)+,-(A7)
        pea     showproprent
        pea     buffer
        jsr     tios::sprintf
        lea     10(A7),A7

        move.w  #1,-(A7)
        pea     buffer
        move.w  #29,-(A7)
        move.w  #16,-(A7)
        jsr     tios::DrawStrXY
        lea     10(A7),A7

        move.w  #1,-(A7)
        pea     showproprent1
        move.w  #35,-(A7)
        move.w  #16,-(A7)
        jsr     tios::DrawStrXY
        lea     10(A7),A7
        move.w  #1,d7           ;counter
        move.w  #40,d6          ;line
showproploop:
        move.w  (A6)+,-(A7)
        pea     int
        pea     buffer
        jsr     tios::sprintf
        lea     10(A7),A7

        move.w  #1,-(a7)
        pea     buffer
        move.w  #41,-(A7)
        move.w  d6,-(A7)
        jsr     tios::DrawStrXY
        lea     10(A7),A7

        cmp.w   #3,d7
        bne     showpropnot4
        add.w   #4,d6
showpropnot4:

        add.w   #1,d7
        add.w   #14,d6
        cmp.w   #4,d7
        ble     showproploop

;showproprentht  dc.b    "With HOTEL: $%i",0
        move.w  (A6)+,-(A7)
        pea     showproprentht
        pea     buffer
        jsr     tios::sprintf
        lea     10(A7),A7

        move.w  #1,-(A7)
        pea     buffer
        move.w  #47,-(A7)
        move.w  #16,-(a7)
        jsr     tios::DrawStrXY
        lea     10(a7),A7

;showprophouse   dc.b    "Houses cost: $%i",0
        move.w  (A6),-(A7)
        pea     showprophouse
        pea     buffer
        jsr     tios::sprintf
        lea     10(A7),A7

        move.w  #1,-(A7)
        pea     buffer
        move.w  #53,-(A7)
        move.w  #16,-(a7)
        jsr     tios::DrawStrXY
        lea     10(a7),A7

;showpropowner   dc.b    "Owner: %s",0
        move.w  showpropp,d2
        bsr     propaddress
        move.w  (A6),d0
        cmp.w   #6,d0                   ;check if owned by bank
        beq     endshowprop
        bsr     pname
        move.l  A6,-(A7)
        pea     showpropowner
        pea     buffer
        jsr     tios::sprintf
        lea     12(A7),A7

        move.w  #1,-(A7)
        pea     buffer
        move.w  #59,-(A7)
        move.w  #16,-(a7)
        jsr     tios::DrawStrXY
        lea     10(a7),A7

        move.w  showpropp,d2
        bsr     propaddress
        cmp.w   #0,2(A6)
        beq     endshowprop
        cmp.w   #1,2(A6)
        beq     showprop1hs
        cmp.w   #5,2(A6)
        beq     showpropht
        cmp.w   #6,2(A6)
        beq     showpropm

;showprophouses  dc.b    "%i Houses",0
        move.w  2(A6),-(A7)
        pea     showprophouses
        pea     buffer
        jsr     tios::sprintf
        lea     10(A7),A7

        move.w  #1,-(A7)
        pea     buffer
        move.w  #65,-(A7)
        move.w  #16,-(a7)
        jsr     tios::DrawStrXY
        lea     10(a7),A7
        bra     endshowprop
showprop1hs:
;showprop1house  dc.b    "1 House",0
        move.w  #1,-(A7)
        pea     showprop1house
        move.w  #65,-(A7)
        move.w  #16,-(a7)
        jsr     tios::DrawStrXY
        lea     10(a7),A7
        bra     endshowprop
showpropht:
;showprophotel   dc.b    "1 Hotel",0
        move.w  #1,-(A7)
        pea     showprophotel
        move.w  #65,-(A7)
        move.w  #16,-(a7)
        jsr     tios::DrawStrXY
        lea     10(a7),A7
        bra     endshowprop
showpropm:
;showpropmort    dc.b    "Mortgaged",0
        move.w  #1,-(A7)
        pea     showpropmort
        move.w  #65,-(A7)
        move.w  #16,-(a7)
        jsr     tios::DrawStrXY
        lea     10(a7),A7

        bra     endshowprop

endshowprop:
        movem   (A7)+,D0-D7/A0-A6
        rts

show1:          ;prints string in buffer at bottom of info section
        move.w  #104,-(A7)              ;clear area
        move.w  #104,-(A7)
        move.w  #99,-(A7)
        move.w  #16,-(A7)
        jsr     flib::erase_rect
        lea     8(A7),A7

        move.w  #1,-(A7)
        move.l  A6,-(A7)
        move.w  #99,-(A7)
        move.w  #16,-(a7)
        jsr     tios::DrawStrXY
        lea     10(a7),A7
        rts
show2:
        move.w  #98,-(A7)              ;clear area
        move.w  #104,-(A7)
        move.w  #93,-(A7)
        move.w  #16,-(A7)
        jsr     flib::erase_rect
        lea     8(A7),A7
        move.w  #1,-(A7)
        move.l  A6,-(A7)
        move.w  #93,-(A7)
        move.w  #16,-(a7)
        jsr     tios::DrawStrXY
        lea     10(a7),A7
        rts
show3:
        move.w  #92,-(A7)              ;clear area
        move.w  #104,-(A7)
        move.w  #87,-(A7)
        move.w  #16,-(A7)
        jsr     flib::erase_rect
        lea     8(A7),A7
        move.w  #1,-(A7)
        move.l  A6,-(A7)
        move.w  #87,-(A7)
        move.w  #16,-(a7)
        jsr     tios::DrawStrXY
        lea     10(a7),A7
        rts
show4:
        move.w  #86,-(A7)              ;clear area
        move.w  #104,-(A7)
        move.w  #81,-(A7)
        move.w  #16,-(A7)
        jsr     flib::erase_rect
        lea     8(A7),A7

        move.w  #1,-(A7)
        move.l  A6,-(A7)
        move.w  #81,-(A7)
        move.w  #16,-(a7)
        jsr     tios::DrawStrXY
        lea     10(a7),A7
        rts
show5:
        move.w  #80,-(A7)              ;clear area
        move.w  #104,-(A7)
        move.w  #75,-(A7)
        move.w  #16,-(A7)
        jsr     flib::erase_rect
        lea     8(A7),A7
        move.w  #1,-(A7)
        move.l  A6,-(A7)
        move.w  #75,-(A7)
        move.w  #16,-(a7)
        jsr     tios::DrawStrXY
        lea     10(a7),A7
        rts



;blankline      prints a blank line
blankline:
        lea     nullstring(PC),A6
        bsr     print
        rts

;print(A6)      prints string pointed to by A6, scrolls list up
;fouls A3,A4,d4,d5
print:

        move.w  #120,-(A7)              ;clear area
        move.w  #238,-(A7)
        move.w  #0,-(A7)
        move.w  #123,-(A7)
        jsr     flib::erase_rect
        lea     8(A7),A7

        move.l  #29,-(A7)               ;copy string to buffer
        move.l  A6,-(A7)                
        pea     sideb(PC)
        jsr     tios::strncpy
        lea     12(A7),A7

        lea     sideb1(PC),a3           ;pointer to buffer
        move.l  A3,A4
        sub.l   #30,A4
        move.w  #0,d4                   ;counter
        move.w  #1,d5                   ;line to print on
ploop:
        move.l  #29,-(A7)               ;copy string to next higher line
        move.l  A4,-(A7)
        move.l  A3,-(A7)
        jsr     tios::strncpy
        lea     12(A7),A7

        move.w  #1,-(A7)                ;print the string
        move.l  A3,-(A7)
        move.w  D5,-(A7)
        move.w  #123,-(A7)
        jsr     tios::DrawStrXY
        lea     10(A7),A7


        add.w   #1,d4
        add.w   #6,d5
        sub.l   #30,A4
        sub.l   #30,A3
        cmp.w   #19,d4
        ble     ploop

        rts

;clrbuf()-clears the print buffer
clrbuf:
        move.w  #0,d1
        lea     sideb(PC),A6
clrbufloop:
        move.b  #0,(A6)
        add.l   #1,A6
        add.w   #1,d1
        cmp.w   #630,d1
        bne     clrbufloop
        rts

interrupt:
        move.w  #104,-(A7)              ;clear area
        move.w  #104,-(A7)
        move.w  #16,-(A7)
        move.w  #16,-(A7)
        jsr     flib::erase_rect
        lea     8(A7),A7

        move.w  #1,-(A7)
        pea     intchoose
        move.w  #17,-(A7)
        move.w  #16,-(a7)
        jsr     tios::DrawStrXY
        lea     10(a7),A7

        move.w  #0,d7                   ;counter
        move.w  #23,d6                  ;line
interruptloop:
        move.w  d7,d0
        bsr     plraddress
        move.w  2(A6),-(A7)
        bsr     pname
        move.l  A6,-(A7)
        move.w  d7,-(A7)
        add.w   #1,(A7)                 ;no such thing as F0
        pea     intchoice
        pea     buffer
        jsr     tios::sprintf
        lea     16(A7),A7

        move.w  #1,-(A7)
        pea     buffer
        move.w  D6,-(A7)
        move.w  #16,-(a7)
        jsr     tios::DrawStrXY
        lea     10(a7),A7

        add.w   #1,d7
        add.w   #6,d6

        cmp.w   numplayers,D7
        ble     interruptloop


intgkey:
        jsr     flib::idle_loop
        cmp.w   #264,d0                 ;ESC
        beq     endint
        cmp.w   #267,d0
        ble     intgkey
        sub.w   #268,d0                 ;get player number
        cmp.w   #6,d0
        bge     intgkey

        move.w  d0,transplr

        move.w  #104,-(A7)              ;clear area
        move.w  #104,-(A7)
        move.w  #16,-(A7)
        move.w  #16,-(A7)
        jsr     flib::erase_rect
        lea     8(A7),A7
intdostuff:
        move.w  transplr,d0
        bsr     plraddress
        move.w  2(A6),-(A7)             ;money
        bsr     pname
        move.l  A6,-(A7)                ;name
        pea     srolldice1
        pea     buffer
        jsr     tios::sprintf
        lea     14(A7),A7
        lea     buffer,A6
        bsr     show3

        move.w  transplr,d0
        bsr     pname
        move.l  A6,-(A7)
        move.w  curplay,d0
        bsr     pname
        move.l  A6,-(A7)
        pea     stint
        pea     buffer
        jsr     tios::sprintf
        lea     16(A7),A7

        pea     buffer
        bsr     showhelp
        lea     4(a7),A7


        bsr     gkey
        cmp.w   #264,d0                 ;ESC
        beq     endint
        bra     intdostuff


endint:
        move.w  curplay,transplr
        rts


;gkey   like flib::idle_loop, but first checks for keys like Esc and APPS
;       returns zero if the message should be reprinted and func should
;       be run again
gkey:
        move.l  A6,-(A7)
        lea     nullstring(PC),A6
        lea     fmenu2,A6
        bsr     show1
        lea     fmenu1,A6
        bsr     show2
        move.l  (A7)+,A6
        jsr     flib::idle_loop
        cmp.w   #100,d0                 ;d=debug menu
        beq     gkeydebug
        cmp.w   #269,d0                 ;F2=Buy bldg
        beq     gkeybuybldg
        cmp.w   #270,d0                 ;F3=Sell bldg
        beq     gkeysellbldg
        cmp.w   #273,d0                 ;F6=Mortgage prop
        beq     gkeymrtg
        cmp.w   #274,d0                 ;F7=Unmortgage prop
        beq     gkeyumrtg
        cmp.w   #118,d0                 ;v=view properties
        beq     gkeyview
        cmp.w   #266,d0                 ;MODE=help
        beq     gkeyhelp
        rts
gkeydebug:
        bsr     debug
        move.w  #0,d0
        rts
gkeybuybldg:
        bsr     transbuy
        move.w  #0,d0
        rts
gkeysellbldg:
        bsr     transsell
        move.w  #0,d0
        rts
gkeymrtg:
        bsr     transmortgage
        move.w  #0,d0
        rts
gkeyumrtg:
        bsr     transunmortgage
        move.w  #0,d0
        rts
gkeyview:
        bsr     view
        move.w  #0,d0
        rts
gkeyhelp:
        bsr     help
        move.w  #0,d0
        rts
;Debug menu: to be taken out in final version or left in as cheats...
debug:
        movem   d2-d5/A3-A6,-(A7)
        lea     debugmenu,A6
        bsr     print
        lea     debug1,A6
        bsr     print
        lea     debug2,A6
        bsr     print
        lea     debug3,A6
        bsr     print
        lea     debug4,A6
        bsr     print
        lea     debug5,A6
        bsr     print
        lea     debug6,A6
        bsr     print
debugkp:
;        move.l  A6,-(A7)
        bsr     debugsline
        move.w  debugplr,d0
        bsr     plraddress
        move.w  (A6),d2
        bsr     showprop
;        move.l  (A7)+,A6
        jsr     flib::idle_loop         ;Get keypress
        cmp.w   #268,d0                 ;F1
        beq     dbchplr                 ;change player
        cmp.w   #269,d0                 ;F2
        beq     dbchmoney               ;change money
        cmp.w   #270,d0                 ;F3
        beq     dbchprop                ;change property player is on
        cmp.w   #271,d0                 ;F4
        beq     dbchowner               ;change owner
        cmp.w   #272,d0                 ;F5
        beq     dbchhouse               ;change houses
        cmp.w   #273,d0                 ;F6
        beq     dbjail                  ;Send to jail
        cmp.w   #264,d0                 ;ESC
        beq     enddebug

        cmp.w   #269,debugmode
        beq     dbchmoneyk
        cmp.w   #270,debugmode
        beq     dbchpropk


        bra     debugkp

dbchplr:        ;change debugplayer
        add.w   #1,debugplr
        move.w  debugplr,d0
        cmp.w   numplayers,d0
        ble     debugkp
        move.w  #0,debugplr
        bra     debugkp

dbchmoney:      ;change amount of money
        move.w  #269,debugmode
        bra     debugkp
dbchmoneyk:
        move.w  d0,-(a7)
        bsr     debugsline
        move.w  debugplr,d0             ;this and next line so that won't
        bsr     plraddress              ;have to do this each time
        move.w  (A7)+,d0

        cmp.w   #338,d0                 ;up arrow
        beq     add100                  ;add $100
        cmp.w   #344,d0                 ;down arrow
        beq     sub100                  ;subtract $100
        cmp.w   #340,d0                 ;right arrow
        beq     add10
        cmp.w   #337,d0                 ;left arrow
        beq     sub10
        cmp.w   #13,d0                  ;Enter
        beq     add1
        cmp.w   #265,d0                 ;APPS
        beq     sub1
;        cmp.w   #264,d0                 ;Esc
;        beq     debugkp

        bra     debugkp
add100:
        add.w   #100,2(A6)
        bra     dbchmoney
sub100:
        sub.w   #100,2(A6)
        bra     dbchmoney
add10:
        add.w   #10,2(A6)
        bra     dbchmoney
sub10:
        sub.w   #10,2(A6)
        bra     dbchmoney
add1:
        add.w   #1,2(A6)
        bra     dbchmoney
sub1:
        sub.w   #1,2(A6)
        bra     dbchmoney

dbchprop:
        move.w  #270,debugmode
        bra     debugkp
dbchpropk:
        move.w  d0,-(a7)
        bsr     debugsline
        move.w  debugplr,d0
        bsr     plraddress              ;A6 will be intact after keypress test
        move.w  (A7)+,d0
        
        cmp.w   #340,d0                 ;right arrow
        beq     addprop1                ;next property
        cmp.w   #337,d0                 ;left arrow
        beq     subprop1
;        cmp.w   #264,d0                 ;esc
;        beq     debugkp
        bra     debugkp

addprop1:
        add.w   #1,(A6)                 ;add 1 to prop
        bra     dbchproptest
subprop1:
        sub.w   #1,(A6)                 ;subtract 1 from prop
        bra     dbchproptest

dbchproptest:
        cmp.w   #40,(A6)
        bge     sub40
        cmp.w   #0,(A6)
        blt     add40
        bra     dbchprop

sub40:
        sub.w   #40,(A6)
        bra     dbchprop
add40:
        add.w   #40,(A6)
        bra     dbchprop

dbchowner:      ;change ownership
        move.w  debugplr,d0
        bsr     plraddress
        move.w  (A6),d2
        bsr     propaddress
        cmp.w   #6,(A6)                 ;if bank owns it
        bne     dbtakeown
        move.w  d0,(A6)                 ;if bank owns it, debugplr owns it now
        bra     debugkp
dbtakeown:
        move.w  #6,(A6)                 ;bank now owns it
        bra     debugkp

dbchhouse:
        move.w  debugplr,d0
        bsr     plraddress
        move.w  (A6),d2
        bsr     propaddress
        add.w   #1,2(A6)                ;add 1 to num of houses,hotel,mortgaged
        cmp.w   #6,2(A6)
        ble     debugkp
        move.w  #0,2(A6)
        bra     debugkp
dbjail
        move.w  debugplr,d0
        bsr     gojail
        bra     debugkp

enddebug:
        movem   (A7)+,d2-d5/A3-A6
        rts
endgetkeyapps:
        move.w  #0,d0
        rts


debugsline:
        move.w  debugplr,d0
        bsr     plraddress
        move.w  (A6),d2
        bsr     propaddress
        move.w  2(A6),-(A7)     ;houses/hotel/mortaged
        move.w  (A6),d0
        cmp.w   #6,d0
        bne     notbank
        pea     bank            ;bank owns property
        bra     endbank
notbank:
        bsr     pname           ;name of player who owns property
        move.l  A6,-(A7)
endbank:
        move.w  debugplr,d0
        bsr     plraddress
        move.w  (A6),d2
        bsr     getname
        move.l  A6,-(A7)        ;name of property
        bsr     plraddress
        move.w  2(A6),-(A7)     ;money
        bsr     pname
        move.l  A6,-(A7)        ;name of player being edited
        pea     dbsline
        pea     buffer
        jsr     tios::sprintf
        lea     24(A7),A7

        pea     buffer
        bsr     showhelp        ;show msg on status line
        lea     4(A7),A7

        rts

view:
        movem.l d0-d7/A0-A6,-(A7)
viewgkey:
        move.w  transprop,d2
        bsr     showprop
        lea     nullstring,A6
        bsr     show5
        bsr     show4
        bsr     show3
        lea     sviewing,A6
        bsr     show2
        lea     sbuybuilding2,A6
        bsr     show1

        jsr     flib::idle_loop         ;get key
        cmp.w   #337,d0                 ;left-previous property
        beq     viewprevprop
        cmp.w   #340,d0                 ;right-next prop
        beq     viewnextprop
        cmp.w   #264,d0                 :ESC
        beq     endview
        bra     viewgkey

viewprevprop:
        sub.w   #1,transprop
        cmp.w   #0,transprop
        bge     viewgkey
        add.w   #40,transprop
        bra     viewgkey
viewnextprop:
        add.w   #1,transprop
        cmp.w   #40,transprop
        blt     viewgkey
        sub.w   #40,transprop
        bra     viewgkey
endview:
        movem.l (A7)+,D0-d7/A0-A6
        rts

help:
        movem.l D0/A6,-(A7)
        lea     _comment,A6
        bsr     print
        lea     sbyme,A6
        bsr     print
        lea     semail,A6
        bsr     print
        lea     nullstring,A6
        bsr     print
        lea     help1,A6
        bsr     print
        lea     help2,A6
        bsr     print
        lea     help3,A6
        bsr     print
        lea     help4,A6
        bsr     print
        lea     help5,A6
        bsr     print

        movem.l (A7)+,D0/A6
        rts

transbuy:
        move.w  #1,d6                   ;direction
transbuyloopstart:
        move.w  transprop,d7            ;counter end
transbuyloop:
        move.w  transprop,-(A7)
        move.w  transplr,-(A7)
        bsr     cbuybldg
        lea     4(A7),a7
        cmp.w   #0,d0
        beq     transbuyloopend
        add.w   d6,transprop
        cmp.w   #40,transprop
        blt     transbuyloopnowrap
        sub.w   #40,transprop
transbuyloopnowrap:
        cmp.w   #0,transprop
        bge     transbuyloopnoadd
        add.w   #40,transprop
transbuyloopnoadd:
        cmp.w   transprop,d7
        bne     transbuyloop

        bra     transcantbuybldg
transbuyloopend:

        move.w  transprop,d2
        bsr     showprop

        move.w  transplr,d0
        bsr     plraddress
        move.w  2(A6),-(A7)
        bsr     pname
        move.l  A6,-(A7)
        pea     srolldice1
        pea     buffer
        jsr     tios::sprintf
        lea     14(A7),A7
        lea     buffer,A6
        bsr     show3

        move.w  transprop,d1
        bsr     posaddress
        move.w  16(A6),-(A7)
        pea     sbuybuilding1
        pea     buffer
        jsr     tios::sprintf
        lea     10(A7),A7
        lea     buffer,A6
        bsr     show2
        lea     sbuybuilding2,A6
        bsr     show1
        lea     nullstring(PC),A6
        bsr     show4

;sbuybuilding1   dc.b    13,"-Buy bldg for $%i",0
;sbuybuilding2   dc.b    17,18,"-Change prop",0

        jsr     flib::idle_loop
        cmp.w   #337,d0                 ;left-previous property
        beq     buyprevprop
        cmp.w   #340,d0                 ;right-next prop
        beq     buynextprop
        cmp.w   #268,d0                 ;F1-Buy house/hotel
        beq     transbuybldg
        cmp.w   #13,d0
        beq     transbuybldg
        cmp.w   #264,d0                 ;ESC
        beq     transendbuybldg
        bra     transbuyloopstart
buyprevprop:
        move.w  #-1,d6
        sub.w   #1,transprop
        cmp.w   #0,transprop
        bge     transbuyloopstart
        add.w   #40,transprop
        bra     transbuyloopstart
buynextprop:
        move.w  #1,d6
        add.w   #1,transprop
        cmp.w   #39,transprop
        ble     transbuyloopstart
        sub.w   #40,transprop
        bra     transbuyloopstart
transbuybldg:
        move.w  transprop,-(A7) ;transprop
        move.w  transplr,-(A7) ;transplr
        bsr     buybldg
        lea     4(A7),a7
        bra     transbuyloopstart
transendbuybldg:
        lea     nullstring,A6
        bsr     show4
        bsr     show3
        rts
transcantbuybldg:
        lea     scantbuybldg1,A6
        bsr     show4
        lea     scantbuybldg2,A6
        bsr     show3
        lea     nullstring,A6
        bsr     show2
        bsr     show1
        jsr     flib::idle_loop
        bsr     show4
        bsr     show3
        rts
 
transsell:
        move.w  #1,d6                   ;direction
transsellloopstart:
        move.w  transprop,d7            ;counter end
transsellloop:
        move.w  transprop,-(A7)
        move.w  transplr,-(A7)
        bsr     csellbldg
        lea     4(A7),a7
        cmp.w   #0,d0
        beq     transsellloopend
        add.w   d6,transprop
        cmp.w   #40,transprop
        blt     transsellloopnowrap
        sub.w   #40,transprop
transsellloopnowrap:
        cmp.w   #0,transprop
        bge     transsellloopnoadd
        add.w   #40,transprop
transsellloopnoadd:
        cmp.w   transprop,d7
        bne     transsellloop

        bra     transcantsellbldg
transsellloopend:

        move.w  transprop,d2
        bsr     showprop

        move.w  transplr,d0
        bsr     plraddress
        move.w  2(A6),-(A7)
        bsr     pname
        move.l  A6,-(A7)
        pea     srolldice1
        pea     buffer
        jsr     tios::sprintf
        lea     14(A7),A7
        lea     buffer,A6
        bsr     show3

        move.w  transprop,d1
        bsr     posaddress
        move.w  16(A6),d7
        asr.w   #1,d7                   ;divide by 2
        move.w  d7,-(a7)
        pea     ssellbuilding1
        pea     buffer
        jsr     tios::sprintf
        lea     10(A7),A7
        lea     buffer,A6
        bsr     show2
        lea     ssellbuilding2,A6
        bsr     show1
        lea     nullstring(PC),A6
        bsr     show4

;ssellbuilding1   dc.b    13,"-sell bldg for $%i",0
;ssellbuilding2   dc.b    17,18,"-Change prop",0

        jsr     flib::idle_loop
        cmp.w   #337,d0                 ;left-previous property
        beq     sellprevprop
        cmp.w   #340,d0                 ;right-next prop
        beq     sellnextprop
        cmp.w   #13,d0
        beq     transsellbldg
        cmp.w   #264,d0                 ;ESC
        beq     transendsellbldg
        bra     transsellloopstart
sellprevprop:
        move.w  #-1,d6
        sub.w   #1,transprop
        cmp.w   #0,transprop
        bge     transsellloopstart
        add.w   #40,transprop
        bra     transsellloopstart
sellnextprop:
        move.w  #1,d6
        add.w   #1,transprop
        cmp.w   #39,transprop
        ble     transsellloopstart
        sub.w   #40,transprop
        bra     transsellloopstart
transsellbldg:
        move.w  transprop,-(A7)
        move.w  transplr,-(A7)
        bsr     sellbldg
        lea     4(A7),a7
        bra     transsellloopstart
transendsellbldg:
        lea     nullstring,A6
        bsr     show4
        bsr     show3
        rts
transcantsellbldg:
        lea     scantsellbldg1,A6
        bsr     show4
        lea     scantsellbldg2,A6
        bsr     show3
        lea     nullstring,A6
        bsr     show2
        bsr     show1
        jsr     flib::idle_loop
        bsr     show4
        bsr     show3
        rts


transmortgage:
        move.w  #1,d6                   ;direction
transmrtgloopstart:
        move.w  transprop,d7            ;counter end
transmrtgloop:
        move.w  transprop,-(A7)
        move.w  transplr,-(A7)
        bsr     cmortgage
        lea     4(A7),A7
        cmp.w   #0,d0
        beq     transmrtgloopend
        add.w   d6,transprop
        cmp.w   #40,transprop
        blt     transmrtgloopnowrap
        sub.w   #40,transprop
transmrtgloopnowrap:
        cmp.w   #0,transprop
        bge     transmrtgloopnoadd
        add.w   #40,transprop
transmrtgloopnoadd:
        cmp.w   transprop,d7
        bne     transmrtgloop

        bra     transcantmrtgprop
transmrtgloopend:
        move.w  transprop,d2
        bsr     showprop

        move.w  transplr,d0             ;show player name and money
        bsr     plraddress
        move.w  2(A6),-(A7)
        bsr     pname
        move.l  A6,-(A7)
        pea     srolldice1
        pea     buffer
        jsr     tios::sprintf
        lea     14(A7),A7
        lea     buffer,A6
        bsr     show3

;smrtgprop1       dc.b    13,"-mrtg prop for $%i",0
;ssellbuilding2   dc.b    17,18,"-Change prop",0
        move.w  transprop,d1
        bsr     posaddress
        move.w  2(A6),d3                ;price of prop
        asr.w   #1,d3                   ;divide by 2
        move.w  d3,-(A7)
        pea     smrtgprop1
        pea     buffer
        jsr     tios::sprintf
        lea     10(A7),A7
        lea     buffer,A6
        bsr     show2
        lea     ssellbuilding2,A6
        bsr     show1
        lea     nullstring,A6
        bsr     show5
        bsr     show4

        jsr     flib::idle_loop
        cmp.w   #337,d0                 ;left-previous prop
        beq     mrtgprevprop
        cmp.w   #340,d0                 ;right-next prop
        beq     mrtgnextprop
        cmp.w   #13,d0                  ;Enter-mortgage prop
        beq     transmrtgprop
        cmp.w   #264,d0                 ;ESC
        beq     transendmrtgprop
        bra     transmrtgloopstart
mrtgprevprop:
        move.w  #-1,d6
        sub.w   #1,transprop
        cmp.w   #0,transprop
        bge     transmrtgloopstart
        add.w   #40,transprop
        bra     transmrtgloopstart
mrtgnextprop:
        move.w  #1,d6
        add.w   #1,transprop
        cmp.w   #39,transprop
        ble     transmrtgloopstart
        sub.w   #40,transprop
        bra     transmrtgloopstart

transmrtgprop:
        move.w  transprop,-(A7)
        move.w  transplr,-(A7)
        bsr     mortgage
        lea     4(A7),A7
        bra     transmortgage
transendmrtgprop:
        lea     nullstring,A6
        bsr     show4
        bsr     show3
        rts
transcantmrtgprop:
        lea     scantmrtgprop1,A6
        bsr     show2
        lea     scantmrtgprop2,A6
        bsr     show1
        lea     nullstring,A6
        bsr     show3
        bsr     show4
        jsr     flib::idle_loop
        bsr     show2
        bsr     show1
        rts

transunmortgage:
        move.w  #1,d6
transumrtgloopstart:
        move.w  transprop,d7            ;counter end
transumrtgloop:
        move.w  transprop,-(A7)
        move.w  transplr,-(A7)
        bsr     cunmortgage
        lea     4(A7),A7
        cmp.w   #0,d0
        beq     transumrtgloopend
        add.w   d6,transprop
        cmp.w   #40,transprop
        blt     transumrtgloopnowrap
        sub.w   #40,transprop
transumrtgloopnowrap:
        cmp.w   #0,transprop
        bge     transumrtgloopnoadd
        add.w   #40,transprop
transumrtgloopnoadd:
        cmp.w   transprop,d7
        bne     transumrtgloop

        bra     transcantumrtgprop
transumrtgloopend:
        move.w  transprop,d2
        bsr     showprop

        move.w  transplr,d0             ;show player name and money
        bsr     plraddress
        move.w  2(A6),-(A7)
        bsr     pname
        move.l  A6,-(A7)
        pea     srolldice1
        pea     buffer
        jsr     tios::sprintf
        lea     14(A7),A7
        lea     buffer,A6
        bsr     show3
;sumrtgprop1     dc.b    13,"-unmrtg prop for $%i",0
        move.w  transprop,d1
        bsr     posaddress
        clr.l   d3
        clr.l   d4
        move.w  2(A6),d3
        asr     #1,d3                   ;divide by 2
        move.w  d3,d4
        divu    #10,d4
        add.w   d3,d4                   ;d4 is amount mortgaging costs
        move.w  d4,-(A7)
        pea     sumrtgprop1
        pea     buffer
        jsr     tios::sprintf
        lea     10(A7),A7
        lea     buffer,A6
        bsr     show2
        lea     ssellbuilding2,A6
        bsr     show1
        lea     nullstring,A6
        bsr     show5
        bsr     show4

        jsr     flib::idle_loop
        cmp.w   #337,d0                 ;left-previous prop
        beq     umrtgprevprop
        cmp.w   #340,d0                 ;right-next prop
        beq     umrtgnextprop
        cmp.w   #13,d0                  ;Enter-mortgage prop
        beq     transumrtgprop
        cmp.w   #264,d0                 ;ESC
        beq     transendumrtgprop
        bra     transumrtgloopstart
umrtgprevprop:
        move.w  #-1,d6
        sub.w   #1,transprop
        cmp.w   #0,transprop
        bge     transumrtgloopstart
        add.w   #40,transprop
        bra     transumrtgloopstart
umrtgnextprop:
        move.w  #1,d6
        add.w   #1,transprop
        cmp.w   #39,transprop
        ble     transumrtgloopstart
        sub.w   #40,transprop
        bra     transumrtgloopstart
transumrtgprop:
        move.w  transprop,-(A7)
        move.w  transplr,-(A7)
        bsr     unmortgage
        lea     4(A7),A7
        bra     transunmortgage
transendumrtgprop:
        lea     nullstring,A6
        bsr     show4
        bsr     show3
        rts
transcantumrtgprop:
        lea     scantmrtgprop1,A6
        bsr     show2
        lea     scantumrtgprop2,A6
        bsr     show1
        lea     nullstring,A6
        bsr     show3
        bsr     show4
        jsr     flib::idle_loop
        bsr     show2
        bsr     show1
        rts


;cmortgage(player,property#)
;  returns in d0 result indicating if it was succesful or not
cmortgage:
        move.w  4(A7),mortgageplr
        move.w  6(A7),mortgageprop
        movem   d1-d7/A0-A6,-(A7)

        move.w  mortgageprop,d2
        bsr     propaddress
        move.w  mortgageplr,d0
        cmp.w   (A6),d0
        beq     mortgageownedbyplr
        move.w  #1,d0
        movem   (A7)+,d1-d7/A0-A6
        rts

mortgageownedbyplr:
        cmp.w   #0,2(A6)
        beq     mortgagenobuildings
        cmp.w   #6,2(A6)
        beq     mortgagealreadymortgaged
;sbuildings      dc.b    "You have buildings there!",0                   ;2
        move.w  #2,d0
        movem   (A7)+,d1-d7/A0-A6
        rts
mortgagealreadymortgaged:
;sschonmortgaged dc.b    "That property is already mortgaged!",0         ;3
        move.w  #3,d0
        movem   (A7)+,d1-d7/A0-A6
        rts
mortgagenobuildings:
        move.w  #0,d2                   ;counter
        move.w  mortgageprop,d1
        bsr     posaddress
        move.w  18(A6),d4               ;prop group
mortgageloop:
        move.w  d2,d1
        bsr     posaddress
        cmp.w   18(A6),d4
        bne     mortgageloopinc
        bsr     propaddress
        cmp.w   #0,2(A6)
        beq     mortgageloopinc
        cmp.w   #6,2(A6)                ;mortgaged
        beq     mortgageloopinc

;sotherbuildings dc.b    "You have buildings on another property in that set!",0 ;4
        move.w  #4,d0
        movem   (A7)+,d1-d7/A0-A6
        rts
mortgageloopinc:
        add.w   #1,d2                   ;increment counter
        cmp.w   #40,d2
        blt     mortgageloop

        move.w  #0,d0
        movem   (A7)+,d1-d7/A0-A6
        rts

;mortgage(player, property#)
;  returns in d0 result indicating if it was succesful or not
mortgage:
        move.w  4(A7),mortgageplr
        move.w  6(A7),mortgageprop
        movem   d1-d7/A0-A6,-(A7)

        move.w  mortgageprop,-(A7)
        move.w  mortgageplr,-(A7)
        bsr     cmortgage
        lea     4(A7),A7

        cmp.w   #0,d0
        beq     mortgageok
        movem   (A7)+,d1-d7/A0-A6
        rts

mortgageok:
        move.w  mortgageprop,d2
        bsr     propaddress
        move.w  #6,2(A6)                ;mortgage

        move.w  d2,d1
        bsr     posaddress
        move.w  2(A6),d1
        asr     #1,d1                   ;divide by 2
        move.w  mortgageplr,d0
        bsr     addmoney                ;pay plr

        move.w  #0,d0
        movem   (A7)+,d1-d7/A0-A6
        rts

cunmortgage:
        move.w  4(A7),mortgageplr
        move.w  6(A7),mortgageprop
        movem   d1-d7/A0-A6,-(A7)

        move.w  mortgageprop,d2
        bsr     propaddress
        move.w  mortgageplr,d0
        cmp.w   (A6),d0
        beq     cunmortgageownedbyplr
;sdontown        dc.b    "You don't own that property!",0                ;1
        move.w  #1,d0
        movem   (A7)+,d1-d7/A0-A6
        rts
cunmortgageownedbyplr:                   ;Check if its already mortgaged
        cmp.w   #6,2(A6)
        beq     cunmortgagemortgaged
        move.w  #2,d0
        movem   (A7)+,d1-d7/A0-A6
        rts
cunmortgagemortgaged:
        move.w  #0,d0
        movem   (A7)+,d1-d7/A0-A6
        rts

unmortgage:
        move.w  4(A7),mortgageplr
        move.w  6(A7),mortgageprop
        movem   d1-d7/A0-A6,-(A7)
        move.w  mortgageprop,-(A7)
        move.w  mortgageplr,-(A7)
        bsr     cunmortgage
        lea     4(A7),A7
        cmp.w   #0,d0
        beq     canunmortgage
        movem   (A7)+,d1-d7/A0-A6
        rts
canunmortgage:
        move.w  transprop,d2
        move.w  d2,d1
        bsr     posaddress
        clr.l   d3
        clr.l   d4
        move.w  2(A6),d3
        asr     #1,d3                   ;divide by 2
        move.w  d3,d4
        divu    #10,d4
        add.w   d3,d4                   ;d4 is the amount to pay
        move.w  d4,d1
        move.w  mortgageplr,d0
        move.w  #1,d2
        bsr     pay
        cmp.w   #0,d0
        bne     unmortgagepaid
;snomoney        dc.b    "You need $%i!",0
        move.w  d4,-(A7)
        pea     snomoney
        pea     buffer
        jsr     tios::sprintf
        lea     10(A7),A7
        pea     buffer
        bsr     showhelp
        lea     4(A7),A7
        jsr     flib::idle_loop
        move.w  #3,d0
        movem   (A7)+,d1-d7/A0-A6
        rts
unmortgagepaid:
        move.w  mortgageprop,d2
        bsr     propaddress
        move.w  #0,2(A6)
        movem   (A7)+,d1-d7/A0-A6
        rts

cbuybldg:       ;check to see if building can be bought
        move.w  #1,buybldgc
;buybldg(player,property#)
;  returns in d0 result indicating if it was successful or not
buybldg:
        move.w  4(A7),buybldgplr
        move.w  6(A7),buybldgprop
        movem   d1-d7/A0-A6,-(A7)

        move.w  buybldgprop,d2                ;property
        move.w  buybldgplr,d0                 ;player
        bsr     propaddress
        cmp.w   (A6),D0                 ;see if player owns it
        beq     buybldgownsit
;        pea     sdontown                ;print msg
;        bsr     showhelp
;        lea     4(A7),A7
;        jsr     flib::idle_loop
        move.w  #1,d0
        movem   (A7)+,d1-d7/A0-A6
        rts
buybldgownsit:
        move.w  d2,d1
        bsr     posaddress              ;check if you can improve on that type of property
        cmp.w   #6,(A6)
        beq     buybldgrighttype
;        pea     swrongtype              ;print msg
;        bsr     showhelp
;        lea     4(A7),A7
;        jsr     flib::idle_loop
        move.w  #2,d0
        movem   (A7)+,d1-d7/A0-A6
        rts
buybldgrighttype:
        bsr     propaddress             ;check if is already full of buildings
        cmp.w   #5,2(A6)
        bne     buybldgnotfull
;        pea     sfullbldgs              ;print msg
;        bsr     showhelp
;        lea     4(A7),A7
;        jsr     flib::idle_loop
        move.w  #3,d0
        movem   (A7)+,d1-d7/A0-A6
        rts

buybldgnotfull:
        cmp.w   #6,2(A6)                ;check if prop is mortgaged
        bne     notmortgaged

 ;       pea     smortgaged              ;print msg
 ;       bsr     showhelp
 ;       lea     4(A7),A7
 ;       jsr     flib::idle_loop
        move.w  #4,d0
        movem   (A7)+,d1-d7/A0-A6
        rts

notmortgaged
        ;check if has all properties of the set and if is building evenly
        move.w  #0,d7                   ;counter
        move.w  2(A6),d6                ;number of buildings on prop now
        move.w  buybldgprop,d1          ;property
        bsr     posaddress
        move.w  18(A6),d5               ;property group
buybldgcheckloop:
        move.w  d7,d1
        bsr     posaddress
        cmp.w   18(A6),d5               ;check if is in group
        bne     buybldgnotingroup
        move.w  d7,d2
        bsr     propaddress
        move.w  buybldgplr,d4           ;player
        cmp.w   (A6),d4                 ;it's in group, check if owned by this
        beq     buybldgownedbyplr       ;player

 ;       pea     sneedset                ;print msg
 ;       bsr     showhelp
 ;       lea     4(A7),A7
 ;       jsr     flib::idle_loop
        move.w  #5,d0
        movem   (A7)+,d1-d7/A0-A6
        rts

buybldgownedbyplr:
        cmp.w   2(A6),d6                ;check to see if is building evenly
        ble     buybldgeven

;        pea     snoteven                ;print msg
;        bsr     showhelp
;        lea     4(A7),A7
;        jsr     flib::idle_loop
        move.w  #6,d0
        movem   (A7)+,d1-d7/A0-A6
        rts

buybldgeven:
        move.w  d7,d2
        bsr     propaddress
        cmp.w   #6,2(A6)                ;check if it's mortgaged
        bne     buybldgnotingroup

;        pea     sothermortgaged         ;print msg
;        bsr     showhelp
;        lea     4(A7),A7
;        jsr     flib::idle_loop
        move.w  #7,d0
        movem   (A7)+,d1-d7/A0-A6
        rts

buybldgnotingroup:

        add.w   #1,d7
        cmp.w   #40,d7
        blt     buybldgcheckloop

        cmp.w   #1,buybldgc
        beq     cbuybldge

        move.w  #1,buybldgc

        move.w  buybldgprop,d1
        bsr     posaddress
        move.w  16(A6),d1                       ;cost per house
        move.w  buybldgplr,d0
        move.w  #1,d2
        bsr     pay
        cmp.w   #1,d0
        beq     buybldgbought

        move.w  d1,-(a7)
        pea     snomoney
        pea     buffer
        jsr     tios::sprintf
        lea     10(a7),A7
        pea     buffer                          ;print msg
        bsr     showhelp
        lea     4(A7),A7
        jsr     flib::idle_loop
        move.w  #8,d0
        movem   (A7)+,d1-d7/A0-A6
        rts


buybldgbought:
        move.w  transprop,d2
        bsr     propaddress
        add.w   #1,2(A6)
        move.w  #0,d0                           ;successful
        movem   (A7)+,d1-d7/A0-A6
        rts

cbuybldge:
        move.w  #0,buybldgc
        move.w  #0,d0                           ;successful
        movem   (A7)+,d1-d7/A0-A6
        rts
        
csellbldg:      ;check to see if building can be sold
        move.w  #1,sellbldgc
;sellbldg(player,property#)
;  returns in d0 result indicating if it was successful or not
sellbldg:
        move.w  4(A7),sellbldgplr
        move.w  6(A7),sellbldgprop
        movem   d1-d7/A0-A6,-(A7)

        move.w  sellbldgprop,d2                ;property
        move.w  sellbldgplr,d0                 ;player
        bsr     propaddress
        cmp.w   (A6),D0                 ;see if player owns it
        beq     sellbldgownsit
;        pea     sdontown                ;print msg
;        bsr     showhelp
;        lea     4(A7),A7
;        jsr     flib::idle_loop
        move.w  #1,d0
        movem   (A7)+,d1-d7/A0-A6
        rts
sellbldgownsit:
        cmp.w   #0,2(A6)                ;make sure has houses to sell
        beq     sellbldgnobldgs
        cmp.w   #6,2(A6)
        bne     sellbldgcheckeven
sellbldgnobldgs:
;        pea     snobuildings            ;print msg
;        bsr     showhelp
;        lea     4(A7),A7
;        jsr     flib::idle_loop
        move.w  #2,d0
        movem   (A7)+,d1-d7/A0-A6
        rts
sellbldgcheckeven:
        move.w  #0,d7                   ;counter
        move.w  2(A6),d6                ;number of buildings on prop now
        move.w  sellbldgprop,d1         ;property
        bsr     posaddress
        move.w  18(A6),d5               ;property group
sellbldgcheckloop:
        move.w  d7,d1
        bsr     posaddress
        cmp.w   18(A6),d5               ;check if is in group
        bne     sellbldgnotingroup
        move.w  d7,d2
        bsr     propaddress
        cmp.w   2(A6),d6                ;check if unbuilding evenly
        bge     sellbldgnotingroup

;        pea     snoteven                ;print msg
;        bsr     showhelp
;        lea     4(A7),A7
;        jsr     flib::idle_loop
        move.w  #3,d0
        movem   (A7)+,d1-d7/A0-A6
        rts

sellbldgnotingroup:
        add.w   #1,d7
        cmp.w   #40,d7
        blt     sellbldgcheckloop

        cmp.w   #1,sellbldgc
        beq     csellbldge

        move.w  sellbldgprop,d2
        bsr     propaddress
        sub.w   #1,2(A6)                        ;subtract bldg
        move.w  sellbldgprop,d1
        bsr     posaddress
        move.w  16(A6),d1                       ;cost per house
        asr     #1,d1                           ;fancy way to divide by 2
        move.w  sellbldgplr,d0
        bsr     addmoney
        move.w  #1,d0
        movem   (A7)+,d1-d7/A0-A6
        rts

csellbldge:
        move.w  #0,sellbldgc
        move.w  #0,d0
        movem   (A7)+,d1-d7/A0-A6
        rts


;info about properties...
;1st word=player # of owner, 0-5, =6 if unowned
;2nd word
; if a normal property, then it is how many houses it has, 5=hotel
;       6=mortgaged
; if a different property, I have yet to decide whether it goes unused
;       or whether it signifies how many of that type of property the player
;       has

properties:
                ds.b    172             ;initialized by newgame sub


drawboardline   dc.w    0
showpropp:      dc.w    0
mortgageplr     dc.w    0
mortgageprop    dc.w    0
sellbldgc       dc.w    0
sellbldgprop    dc.w    0
sellbldgplr     dc.w    0
buybldgc        dc.w    0
buybldgprop     dc.w    0
buybldgplr      dc.w    0
transprop       dc.w    0
transplr        dc.w    0
debugplr        dc.w    0
debugmode       dc.w    0
propinfotemp    dc.w    0
amount          dc.w    0
util10          dc.w    0               ;flag if has to pay 10 times thrown b/c of chance card
_comment        dc.b    "Monopoly 92 Beta",0
sbyme           dc.b    169," 1998 Daniel Plaisted",0
semail          dc.b    "dsplaisted@bigfoot.com",0
help1           dc.b    "Special keys:",0
help2           dc.b    "APPS:  Press this to buy/sell",0
help3           dc.b    " houses if it's not your turn",0
help4           dc.b    "v:     View properties.",0
help5           dc.b    "d:     Debug/cheat menu",0
buffer:         ds.b    80
nullstring:     dc.b    0
srolldice1     dc.b    "%s: $%i",0
srolldice       dc.b    13,"-Roll Dice",0
stmenu          dc.b    "%s's turn.       %s  MODE-Help",0
stint           dc.b    "%s's turn.  %s Interrupting          MODE-Help",0
stappsint       dc.b    "APPS-Interrupt",0
fmenu1          dc.b    "F2-Buy Bldg  F3-Sell Bldg",0
fmenu2          dc.b    "F6-Mrtg        F7-Unmrtg",0
rolltext        dc.b    "%s rolls %d and %d = %d",0
doubletext      dc.b    "Doubles.",0
doubles         dc.w    0       ;number of doubles gotten so far
roll            dc.w    0       ;sum of dice
die1            dc.w    0       ;roll of die #1
die2            dc.w    0       ;roll of die #2
jailstring1     dc.b    "%s: In jail.",0
jailstring2     dc.b    "F1-Pay $50 F5-Roll Die.",0
gotojailstr     dc.b    "%s GOES TO JAIL",0
;buyornot        dc.b    "Buy %s for $%i?  F1-Yes  F2-Auction.",0
buyornot1       dc.b    13," -Buy %s",0
buyornot2       dc.b    "F5-Auction it",0
boughtprop      dc.b    "%s buys %s",0
paidrent1       dc.b    "%s pays %s",0
paidrent2       dc.b    "$%i rent on %s",0
menutext        dc.b    "F2-Show player info F3-Show property Info F4-transactions.",0 ;58
plrinfo         dc.b    "%s: $%i",0
plrinfojail     dc.b    "IN JAIL, %i rolls left.",0
propinfostart   dc.b    "Owns:",0
propinfo2       dc.b    "%s, %s",0
propinfoend     dc.b    "%s",0
;debug menu
intchoose       dc.b    "Who is interrupting?",0
intchoice       dc.b    "F%d-%s   $%i",0
debugmenu       dc.b    "Debug Menu:",0
debug1          dc.b    "F1 - Change debug player",0
debug2          dc.b    "F2 - Change money",0
debug3          dc.b    "F3 - Change current property",0
debug4          dc.b    "F4 - Change ownership of prop",0
debug5          dc.b    "F5 - Change houses/hotels/mrg",0
debug6          dc.b    "F6 - Send to Jail",0
showproprent    dc.b    "Rent: $%i",0
showproprent1   dc.b    "Houses: 1     2     3       4",0
int             dc.b    "%i",0
showproprent2   dc.b    "Rent:  $",0
showproprenths  dc.b    "W/ %i house(s): $%i",0
showproprentht  dc.b    "With HOTEL: $%i",0
showprophouse   dc.b    "Houses cost: $%i",0
showpropprice   dc.b    "Price: $%i",0
showpropowner   dc.b    "Owner: %s",0
showpropmort    dc.b    "Mortgaged",0
showprop1house  dc.b    "1 House",0
showprophouses  dc.b    "%i Houses",0
showprophotel   dc.b    "1 Hotel",0
dbsline         dc.b    "Editing %s: $%i, on %s owned by %s-%i",0
bank            dc.b    "The Bank",0
        ;Editing plr: $money, on property, owned by plr,houses/hotel/mrtgage.
transactsline   dc.b    "%s: F1-Buy/sell building  F2-(Un)mortgage  F3-Give",0
ssellbuilding1  dc.b    13,"-Sell bldg for $%i",0
sbuybuilding1   dc.b    13,"-Buy bldg for $%i",0
smrtgprop1      dc.b    13,"-mrtg prop for $%i",0
sumrtgprop1     dc.b    13,"-unmrtg prop for $%i",0
ssellbuilding2:
sviewing:       dc.b    "Viewing Properties",0
sbuybuilding2   dc.b    17,18,"-Change prop",0
scantbuybldg1   dc.b    "You can't buy",0
scantbuybldg2   dc.b    "buildings anywhere!",0
scantsellbldg1  dc.b    "You have no buildings",0
scantsellbldg2  dc.b    "that you can sell!",0
scantmrtgprop1  dc.b    "You have no properties",0
scantmrtgprop2  dc.b    "that you can mortgage!",0
scantumrtgprop2 dc.b    "that you can unmortgage!",0
smortgage       dc.b    "%s: %s-%d F1-Mortgage F2-Unmortgage ",17,18,"-Change prop",0
swrongtype      dc.b    "You can't improve that type of property!",0
sfullbldgs      dc.b    "You already have a hotel there!",0
smortgaged      dc.b    "That property is mortgaged!",0
sneedset        dc.b    "You need all the properties in that set!",0
snoteven        dc.b    "You have to build evenly on a group!",0
sothermortgaged dc.b    "Another property in that set is mortgaged!",0
snomoney        dc.b    "You need $%i!",0
snobuildings    dc.b    "You have no buildings there to sell!",0
sdontown        dc.b    "You don't own that property!",0                ;1
sbuildings      dc.b    "You have buildings there!",0                   ;2
sschonmortgaged dc.b    "That property is already mortgaged!",0         ;3
sotherbuildings dc.b    "You have buildings on another property in that set!",0 ;4
snotmortgaged   dc.b    "That property is not mortgaged!",0
;debugging strings to be deleted...
hadmoney        dc.b    "He had the money.",0
hadnomoney      dc.b    "Oops, he went bankrupt!",0
sdec            dc.b    "%d",0


;buffer for msg screen
;each msg at most 29 chars long, 30 with null terminator
sideb:          ds.b    600
sideb1:
                ds.b    30

;Changing info about the board, players, card piles, etc.
numplayers      dc.w    2               ;1=2,2=3,etc
curplay         dc.w    0               ;current player
player0         dc.w    0               ;position
                dc.w    1500            ;money
                dc.b    0               ;1-3 if in jail
                dc.b    0               ;1 if has comm chst get out of jail
                dc.b    0               ;1 if has chance get out of jail free
                dc.b    "Daniel",0,0,0,0,0,0,0,0,0,0      ;15 = max name length
player1         dc.w    0               ;position
                dc.w    1500            ;money
                dc.b    0               ;1-3 if in jail
                dc.b    0               ;1 if has comm chst get out of jail
                dc.b    0               ;1 if has chance get out of jail free
                dc.b    "Brian"0,0,0,0,0,0,0,0,0,0,0      ;15 = max name length
player2         dc.w    0               ;position
                dc.w    1500            ;money
                dc.b    0               ;1-3 if in jail
                dc.b    0               ;1 if has comm chst get out of jail
                dc.b    0               ;1 if has chance get out of jail free
                dc.b    "Jean"0,0,0,0,0,0,0,0,0,0,0,0      ;15 = max name length
player3         dc.w    0               ;position
                dc.w    1500            ;money
                dc.b    0               ;1-3 if in jail
                dc.b    0               ;1 if has comm chst get out of jail
                dc.b    0               ;1 if has chance get out of jail free
                dc.b    "Player 3",0,0,0,0,0,0,0,0      ;15 = max name length
player4         dc.w    0               ;position
                dc.w    1500            ;money
                dc.b    0               ;1-3 if in jail
                dc.b    0               ;1 if has comm chst get out of jail
                dc.b    0               ;1 if has chance get out of jail free
                dc.b    "Player 4",0,0,0,0,0,0,0,0      ;15 = max name length
player5         dc.w    0               ;position
                dc.w    1500            ;money
                dc.b    0               ;1-3 if in jail
                dc.b    0               ;1 if has comm chst get out of jail
                dc.b    0               ;1 if has chance get out of jail free
                dc.b    "Player 5",0,0,0,0,0,0,0,0      ;15 = max name length

;INFORMATION ABOUT THE BOARD THAT CHANGES






;INFORMATION ABOUT THE BOARD THAT DOESN'T CHANGE FROM GAME TO GAME
;community chest and chance card # codes
;1=Collect money
;2=Pay money
;3=advance to position
;4=go to jail
;5=Get out of Jail free
;6=Grand opera opening
;7=chairman of the board
;8=street repairs/general repairs
;9=go back 3 spaces
;10=nearest railroad, pay owner twice normal amnt
;11=nearest utility

strings         dc.w    0,3,17,29,36,47,58,67,74,82
                dc.w    94,99,111,125,137,150,160,17,170,184
                dc.w    197,210,67,223,235,248,255,268,280,292
                dc.w    306,317,329,17,343,354,67,368,379,390

;maxlength=13
stringstart     dc.b            "Go",0
                dc.b            "Mediterranean",0
                dc.b            "Comm. Chest",0
                dc.b            "Baltic",0
                dc.b            "Income Tax",0
                dc.b            "Reading RR",0
                dc.b            "Oriental",0
                dc.b            "Chance",0
                dc.b            "Vermont",0
                dc.b            "Connecticut",0

                dc.b            "Jail",0
                dc.b            "St. Charles",0
                dc.b            "Electric Comp",0
                dc.b            "States Ave.",0
                dc.b            "Virginia Ave",0
                dc.b            "Penns. RR",0
                dc.b            "St. James",0
                ;community chest
                dc.b            "Tennessee Ave",0
                dc.b            "New York Ave",0

                dc.b            "Free Parking",0        ;197
                dc.b            "Kentucky Ave",0        ;210
                ;chance
                dc.b            "Indiana Ave",0         ;223
                dc.b            "Illinois Ave",0        ;235
                dc.b            "B&0 RR",0              ;248
                dc.b            "Atlantic Ave",0        ;255
                dc.b            "Ventnor Ave",0         ;268
                dc.b            "Water Works",0         ;280
                dc.b            "MarvinGardens",0       ;292

                dc.b            "Go to Jail",0          ;306
                dc.b            "Pacific Ave",0         ;317
                dc.b            "NCarolina Ave",0       ;329
                ;community chest                        ;17
                dc.b            "Penns. Ave",0          ;343
                dc.b            "Short Line RR",0       ;355
                ;chance                                 ;67
                dc.b            "Park Place",0          ;368
                dc.b            "Luxury Tax",0          ;379
                dc.b            "Boardwalk",0           ;390


go              dc.w    0
                ds.b    18
mediterranean   dc.w    6
                dc.w    60,2,10,30,90,160,250,50,1
commchs1        dc.w    4
                ds.b    18
baltic          dc.w    6
                dc.w    60,4,20,60,180,320,450,50,1
incometax       dc.w    3
                ds.b    18
readingr        dc.w    7,200
                ds.b    16
oriental        dc.w    6
                dc.w    100,6,30,90,270,400,550,50,2
chance1         dc.w    5
                ds.b    18
vermont         dc.w    6
                dc.w    100,6,30,90,270,400,550,50,2
connecticut     dc.w    6
                dc.w    120,8,40,100,300,450,600,50,2
jail            dc.w    0
                ds.b    18
stcharles       dc.w    6
                dc.w    140,10,50,150,450,625,750,100,3
electric        dc.w    8,150
                ds.b    16
states          dc.w    6
                dc.w    140,10,50,150,450,625,750,100,3
virginia        dc.w    6
                dc.w    160,12,60,180,500,700,900,100,3
pennrr          dc.w    7,200
                ds.b    16
stjames         dc.w    6
                dc.w    180,14,70,200,550,750,950,100,4
commchs2        dc.w    4
                ds.b    18
tennessee       dc.w    6
                dc.w    180,14,70,200,550,750,950,100,4
newyork         dc.w    6
                dc.w    200,16,80,220,600,800,1000,100,4
freeparking     dc.w    0
                ds.b    18
kentucky        dc.w    6
                dc.w    220,18,90,250,700,875,1050,150,5
chance3         dc.w    5
                ds.b    18
indiana         dc.w    6
                dc.w    220,18,90,250,700,875,1050,150,5
illinois        dc.w    6
                dc.w    240,20,100,300,750,925,1100,150,5
b_and_o         dc.w    7,200
                ds.b    16
atlantic        dc.w    6
                dc.w    260,22,110,330,800,975,1150,150,6
ventnor         dc.w    6
                dc.w    260,22,110,330,800,975,1150,150,6
waterworks      dc.w    8,150
                ds.b    16
marvingardens   dc.w    6
                dc.w    280,24,120,360,850,1025,1200,150,6
gotojail        dc.w    1
                ds.b    18
pacific         dc.w    6
                dc.w    300,26,130,390,900,1100,1275,200,7
ncarolina       dc.w    6
                dc.w    300,26,130,390,900,1100,1275,200,7
commchs4        dc.w    4
                ds.b    18
pennsylvania    dc.w    6
                dc.w    320,28,150,450,1000,1200,1400,200,7
shortline       dc.w    7,200
                ds.b    16
chance4         dc.w    5
                ds.b    18
parkplace       dc.w    6
                dc.w    350,35,175,500,1100,1300,1500,200,8
luxerytax       dc.w    2
                ds.b    18
boardwalk       dc.w    6
                dc.w    400,50,200,600,1400,1700,2000,200,8

	end

