; ***************************************************
; *                                                 *
; *                 MINESWEEPER 2.1                 *
; *              (c) 1996 Vili Jussila		    *
; *		 (c) 1998 Jerbom                    *
; *                                                 *
; *           File last updated 04.02.1998          *
; *                                                 *
; ***************************************************


	xdef 		_main
	xdef 		_comment
	include		"macros.h"
	include		"macros2.h"
	include		"flib.h"
	include		"tios.h"

;************** Start of Fargo program **************


_main:
;prog_code:
	lea	old_stack(pc),a5
	move.l	sp,(a5)			; We need a larger stack
	move.l	#BOARD_SIZE+STACK_SIZE,-(sp)	; Allocate memory for board and stack
	jsr	tios::HeapAlloc
	add.l	#4,sp
	tst.w	d0			; Did we get the memory ?
	beq.s	\end
	move.w	d0,12(a5)
        move.l  #$88fc,a0;tios::Heap,a0
	lsl.w	#2,d0
	move.l	0(a0,d0.w),a6
	move.l	a6,8(a5)
	lea	BOARD_SIZE+STACK_SIZE(a6),sp

	bsr	init_interrupt
	bsr	main
	bsr	close_interrupt

	move.w	board_handle(pc),-(sp)
	jsr	tios::HeapFree
	add.l	#2,sp
\end	move.l	old_stack(pc),sp
	rts


main:
\start	bsr	draw_title_screen

\loop1	bsr	get_key
	cmp.w	#264,d0			; Esc ?
	beq	\end	
	cmp.w	#268,d0			; F1 ?
	bne.s	\skip1
	move.w	#8,width(a6)
	move.w	#8,height(a6)
	move.w	#10,mines(a6)
	clr.w	game_type(a6)
	bsr	play
	bra.s	\start
\skip1	cmp.w	#269,d0			; F2 ?
	bne.s	\skip2
	move.w	#16,width(a6)
	move.w	#16,height(a6)
	move.w	#40,mines(a6)
	move.w	#1,game_type(a6)
	bsr	play
	bra.s	\start
\skip2	cmp.w	#270,d0			; F3 ?
	bne.s	\skip3
	move.w	#30,width(a6)
	move.w	#16,height(a6)
	move.w	#99,mines(a6)
	move.w	#2,game_type(a6)
	bsr	play
	bra	\start
\skip3	cmp.w	#271,d0			; F4 ?
	bne.s	\skip4
	move.w	#3,game_type(a6)
	bsr	custom
	bsr	play
	bra	\start
\skip4	cmp.w	#272,d0			; F5 ?
	bne.s	\skip5
	bsr	draw_hall_of_fame
	bra	\start
\skip5	cmp.w	#273,d0			; F6 ?
	bne	\loop1
	bsr	draw_help_screen
	bra	\start
\end
	bsr	up_n_down
	rts


draw_help_screen:
	bsr	clr_screen
	lea	help_gfx(pc),a0
	moveq	#11,d0
	moveq	#2,d1
	moveq	#1,d2
	moveq	#3,d6
	bsr	print_bitmap
	lea	help_txt(pc),a3
	bsr	write


\loop1	bsr	get_key
	cmp.w	#264,d0			; Esc ?
	bne.s	\loop1	
	rts


sort_names:
	move.w	game_type(a6),d0
	lsl.w	#3,d0
	lea	best_times(pc),a0
	lea	0(a0,d0.w),a2
	lea	8(a2),a0

	move.l	a6,a1
	moveq	#3,d0
\loop1	move.w	d0,(a1)+
	move.w	-(a0),(a1)+
	dbf.s	d0,\loop1	

	moveq	#2,d1
\loop2	moveq	#2,d0
	move.l	a6,a0
\loop3	move.l	(a0)+,d2
	cmp.w	2(a0),d2
	bcs.s	\skip1
	move.l	(a0),-4(a0)
	move.l	d2,(a0)
\skip1	dbf.s	d0,\loop3
	dbf.s	d1,\loop2

	move.l	a6,a0
	lea	20(a6),a1
	move.w	game_type(a6),d0
	mulu	#40,d0
	lea	hall_of_fame(pc),a3
	lea	0(a3,d0.w),a3

	moveq	#3,d1
\loop4	move.w	(a0)+,d2
	move.w	(a0)+,(a2)+
	mulu	#10,d2
	lea	0(a3,d2.w),a4
	moveq	#9,d0	
\loop5	move.b	(a4)+,(a1)+
	dbf.s	d0,\loop5
	dbf.s	d1,\loop4

	lea	20(a6),a1
	moveq	#39,d0
\loop6	move.b	(a1)+,(a3)+
	dbf.s	d0,\loop6
	rts


write:
	movem.l	d0-d5/a0-a3,-(sp)
\loop1	moveq	#0,d4
	move.b	(a3)+,d4
	moveq	#0,d5
	move.b	(a3)+,d5

	moveq	#0,d0
	move.b	(a3)+,d0
	SetFont	d0

	move.w	#4,-(sp)
	pea	(a3)
	move.w	d5,-(sp)
	move.w	d4,-(sp)
	jsr	tios::DrawStrXY
	lea	10(sp),sp

\loop2	tst.b	(a3)+
	bne.s	\loop2
	cmp.b	#255,(a3)
	bne.s	\loop1
	movem.l	(sp)+,d0-d5/a0-a3
	rts


enter_hall_of_fame:
	move.w	game_type(a6),d0
	cmp.b	#3,d0			; Custom game ?
	beq.s	\end
	move.w	d0,d6
	lsl.w	#3,d0
	lea	best_times(pc),a0
	lea	6(a0,d0),a0
	cmp.w	(a0),d7			; Good enough time ?
	bhi.s	\end
	move.w	d7,(a0)

	box	#0,#16,#239,#127
	lea	input_txt(pc),a3
	bsr	write

	moveq	#9,d1
	move.w	#90,d2
	moveq	#70,d3
	moveq	#1,d4
	mulu	#40,d6
	lea	hall_of_fame(pc),a0
	lea	30(a0,d6),a0
	bsr	input
	tst.b	(a0)
	bne.s	\skip1
	lea	mr_entern(pc),a1
\loop1	move.b	(a1)+,(a0)+
	bne.s	\loop1
\skip1	bsr	sort_names
\end	rts


draw_hall_of_fame:
	bsr	clr_screen
	lea	best_gfx(pc),a0
	moveq	#6,d0
	moveq	#2,d1
	moveq	#4,d2
	moveq	#3,d6
	bsr	print_bitmap

	lea	best_txt(pc),a3
	bsr	write

	SetFont		#1
	lea	hall_of_fame(pc),a3
	lea	best_times(pc),a4
	moveq	#44,d5
	bsr	print_names
	moveq	#77,d5
	bsr	print_names
	moveq	#110,d5
	bsr	print_names

\loop1	bsr	get_key
	cmp.w	#264,d0			; Esc ?
	bne.s	\loop1	
	rts


print_names:
	move.l	d5,d6
	add.w	#9,d6
	moveq	#"1",d7
	moveq	#12,d3
	move.w	d5,d4
	bsr	print_names_
	move.w	d6,d4
	bsr	print_names_
	move.w	#132,d3
	move.w	d5,d4
	bsr	print_names_
	move.w	d6,d4
	bsr	print_names_
	rts


print_names_
	lea	1(a6),a0
	move.b	d7,(a0)+
	addq.b	#1,d7
	move.w	#'. ',(a0)+
	move.l	a3,a1
	moveq	#9,d0
\loop1	move.b	(a1)+,(a0)+
	dbeq.s	d0,\loop1
	subq.l	#1,a0
\loop2	move.b	#32,(a0)+
	dbf.s	d0,\loop2

	move.w	(a4)+,d0
	bsr	itoa2
	move.l	d1,(a0)
	lea	1(a6),a0

	move.w	#4,-(sp)
	move.l	a0,-(sp)
	move.w	d4,-(sp)
	move.w	d3,-(sp)
	jsr tios::DrawStrXY
	lea	10(sp),sp
	lea	10(a3),a3
	rts


play:
	bsr	new_game
\loop1	bsr	blink_cursor
	bsr	print_status
	bsr	update_face

        tst.w   tios::kb_vars+$1E
	beq.s	\loop1
	move.w	tios::kb_vars+$1E,d2
        clr.w   tios::kb_vars+$1E
	cmp.w	#264,d2			; Esc ?
	beq.s	\skip6
	move.w	cursor_x(a6),d0
	move.w	cursor_y(a6),d1
	cmp.w	#268,d2			; F1 ?
	bne.s	\skip3
	bsr	try_square
	tst.b	d0
	beq.s	\skip5
\skip6	bsr	game_over
	bra.s	\skip2
\skip5	bsr	all_found
	tst.w	d0
	beq.s	\loop1
	bsr	game_won
	bra.s	\skip2
\skip3	cmp.w	#272,d2			; F5 ?
	bne.s	\skip4
	bsr	place_flag
	bra.s	\loop1
\skip4	bsr	move_cursor
	bra.s	\loop1
\skip2	rts


custom:
	box	#0,#45,#239,#127	;HERE
	lea	custom1(pc),a3
	bsr	write

	moveq	#2,d1
	move.w	#168,d2
	moveq	#64,d3
	moveq	#2,d4
	lea	50(a6),a0
\loop1	bsr	input
	bsr	atoi
	cmp.w	#2,d0
	bcs.s	\loop1
	cmp.w	#16,d0
	bhi.s	\loop1
	move.w	d0,height(a6)

	lea	custom2(pc),a3
	bsr	write
	moveq	#2,d1
	move.w	#168,d2
	moveq	#76,d3
	lea	50(a6),a0
\loop2	bsr	input
	bsr	atoi
	cmp.w	#2,d0
	bcs.s	\loop2
	cmp.w	#30,d0
	bhi.s	\loop2
	move.w	d0,width(a6)

	mulu	height(a6),d0
	subq.w	#1,d0
	move.w	d0,d5
	bsr	itoa2
	move.b	number(pc),custom3+12
	move.b	number+1(pc),custom3+13
	move.b	number+2(pc),custom3+14
\loop3	lea	custom3(pc),a3
	bsr	write
	moveq	#3,d1
	move.w	#168,d2
	moveq	#88,d3
	moveq	#2,d4
	lea	50(a6),a0
	bsr	input
	bsr	atoi
	cmp.w	#1,d0
	bcs.s	\loop3
	cmp.w	d5,d0
	bhi.s	\loop3
	move.w	d0,mines(a6)
	rts


atoi:
	movem.l	d1-d3/a1,-(sp)
	moveq	#0,d0
	moveq	#0,d1
	moveq	#1,d2
	move.l	a0,a1
\loop1	tst.b	(a1)+			; Find end of the string
	bne.s	\loop1
	subq.l	#1,a1

\loop2	cmp.l	a0,a1			; Convert the string to an integer
	beq.s	\end
	move.b	-(a1),d1
	sub.b	#"0",d1
	move.l	d2,d3
	mulu	d1,d3
	add.w	d3,d0
	mulu	#10,d2
	bra.s	\loop2
\end	movem.l	(sp)+,d1-d3/a1
	rts


input:
	movem.l	d0-d4/a0-a2,-(sp)

	movem.l	d0-d1/a0,-(sp)
	SetFont	d4
	movem.l	(sp)+,d0-d1/a0
	move.l	a6,a2
	moveq	#0,d4

	bra.s	\skip1
\loop1	bsr	get_key
	cmp.w	#13,d0			; Enter ?
	beq.s	\enter
	cmp.w	#257,d0			; Backspace ?
	bne.s	\skip2
	tst.w	d4
	beq.s	\loop1
	subq.l	#1,a2
	subq.w	#1,d4
	bra.s	\skip1
\skip2	cmp.w	d1,d4			; Maximum number of characters read ?
	bcc.s	\loop1
	cmp.w	#255,d0			; Valid character ?
	bhi.s	\loop1
	addq.w	#1,d4
	move.b	d0,(a2)+
\skip1	move.b	#95,(a2)
	move.b	#32,1(a2)
	clr.b	2(a2)
	bsr	input_
	bra.s	\loop1

\enter	move.b	#32,(a2)
	clr.b	1(a2)
	bsr	input_
	clr.b	(a2)
	move.l	a6,a2
\loop2	move.b	(a2)+,(a0)+
	bne.s	\loop2
	movem.l	(sp)+,d0-d4/a0-a2
	rts

input_:
	movem.l	d1-d2/a0,-(sp)
	move.w	#4,-(sp)
	move.l	a6,-(sp)
	move.w	d3,-(sp)
	move.w	d2,-(sp)
	jsr	tios::DrawStrXY
	lea	10(sp),sp
	movem.l	(sp)+,d1-d2/a0
	rts



up_n_down:
	move.w	#61,d2
\loop2	moveq	#1,d1
	move.l	#LCD_MEM,a0
\loop1	bsr	up
	addq.w	#6,a0
	bsr	down
	addq.w	#6,a0
	dbf.s	d1,\loop1
	bsr	up
	dbf.s	d2,\loop2
	rts

up:
	move.l	a0,a1
	moveq	#124,d0
\loop1	move.l	60(a1),(a1)
	move.w	64(a1),4(a1)
	lea	30(a1),a1	
	dbf.s	d0,\loop1
	rts

down:
	lea	3810(a0),a1
	moveq	#124,d0
\loop1	move.l	-60(a1),(a1)
	move.w	-56(a1),4(a1)
	lea	-30(a1),a1	
	dbf.s	d0,\loop1
	rts


draw_title_screen:
	bsr	clr_screen
	lea	title_gfx(pc),a0
	moveq	#3,d0
	moveq	#5,d1
	moveq	#5,d2
	moveq	#7,d6
	bsr	print_bitmap
	lea	main_txt(pc),a3
	bsr	write
	rts


print_bitmap:
	mulu	#30,d1
	add.w	d0,d1
	move.l	#LCD_MEM,a1
	add.w	d1,a1
	move.l	a1,a2
	lea	patterns(pc),a3
	move.w	d6,a4

	moveq	#4,d5
\loop3
	move.w	d2,d4
\loop2	move.b	(a0)+,d0
	moveq	#3,d3
\loop1	rol.b	#2,d0
	move.b	d0,d1
	and.w	#3,d1
	beq.s	\skip1
	move.b	0(a3,d1.w),d1
	moveq	#0,d7
\loop4	move.b	d1,0(a2,d7)
	add.w	#30,d7
	dbf.s	d6,\loop4
	move.w	a4,d6
\skip1	addq.w	#1,a2
	dbf	d3,\loop1
	dbf	d4,\loop2
	lea	0(a1,d7),a1
	move.l	a1,a2
	dbf	d5,\loop3
	rts


all_found:
	movem.l	d1-d2/a0,-(sp)
	move.w	squares_1(a6),d1
	moveq	#0,d0
	moveq	#0,d2
	move.l	a6,a0
\loop1	btst	#4,(a0)+
	bne.s	\skip1
	addq.w	#1,d2
\skip1	dbf.s	d1,\loop1
	cmp.w	mines(a6),d2		; Have all mines been found ?
	bne.s	\end	
	moveq	#1,d0
\end	movem.l	(sp)+,d1-d2/a0
	rts

count_flags:
	movem.l	d1/a0,-(sp)
	move.w	squares_1(a6),d1
	moveq	#0,d0
	move.l	a6,a0
\loop1	btst	#5,(a0)+
	beq.s	\skip1
	addq.w	#1,d0
\skip1	dbf.s	d1,\loop1
	move.w	d0,flags(a6)
	move.b	#1,new_flag(a6)
	movem.l	(sp)+,d1/a0
	rts


update_face:
	tst.w	face_timer(a6)
	bne.s	\end
	move.w	#-1,face_timer(a6)
	moveq	#0,d2
	bsr	draw_face
\end	rts


draw_face:
	movem.l	d0-d2/a0-a1,-(sp)
	lsl.w	#5,d2
	lea	face_gfx(pc),a0
	lea	0(a0,d2.w),a0
	moveq	#14,d0
	moveq	#0,d1
	bsr	draw_tile_16
	movem.l	(sp)+,d0-d2/a0-a1
	rts


print_number:
	movem.l	d0-d1/a0-a2,-(sp)
	lea	LCD_MEM,a1
	mulu	#30,d1
	add.w	d0,d1
	add.w	d1,a1

\loop1	moveq	#0,d0
	move.b	(a0)+,d0
	beq.s	\end
	sub.b	#48,d0
	mulu	#13,d0
	lea	dig_numbers_gfx(pc),a2
	add.l	d0,a2

	move.b	(a2)+,0(a1)
	move.b	(a2)+,30(a1)
	move.b	(a2)+,60(a1)
	move.b	(a2)+,90(a1)
	move.b	(a2)+,120(a1)
	move.b	(a2)+,150(a1)
	move.b	(a2)+,180(a1)
	move.b	(a2)+,210(a1)
	move.b	(a2)+,240(a1)
	move.b	(a2)+,270(a1)
	move.b	(a2)+,300(a1)
	move.b	(a2)+,330(a1)
	move.b	(a2)+,360(a1)
	addq.w	#1,a1
	bra.s	\loop1
\end	movem.l	(sp)+,d0-d1/a0-a2
	rts


new_game:
	lea	clear_start(a6),a0
	move.w	#clear_end-clear_start-1,d0
\loop1	clr.b	(a0)+
	dbf.s	d0,\loop1

	move.w	#TICS_PER_SEC,sec_timer(a6)
	move.b	#1,new_time(a6)
	move.b	#1,new_flag(a6)

	bsr	clr_screen
	bsr	init_board
	moveq	#0,d2
	bsr	draw_board

	frame	#0,#0,#239,#15
	frame	#4,#3,#36,#12
	frame	#66,#3,#108,#12
	frame	#132,#3,#172,#12
	frame	#202,#3,#235,#12
	frame	#128,#6,#128,#9
	rts


clr_screen:
	lea	LCD_MEM,a0
	move.w	#959,d0
\loop1	clr.l	(a0)+
	dbf.s	d0,\loop1
	rts


print_status:
	tst.b	new_flag(a6)
	beq.s	\skip2
	clr.b	new_flag(a6)
	move.w	mines(a6),d0
	sub.w	flags(a6),d0
	tst.w	d0
	bge.s	\skip1
	moveq	#0,d0
\skip1	bsr	itoa
	moveq	#5,d0
	moveq	#1,d1
	lea	number(pc),a0
	bsr	print_number

\skip2	tst.b	new_time(a6)
	beq.s	\skip3
	clr.b	new_time(a6)
	move.w	time(a6),d0
	bsr	itoa
	moveq	#22,d0
	moveq	#1,d1
	lea	number(pc),a0
	bsr	print_number
\skip3	rts


itoa:
	and.l	#$ffff,d0
	divu	#100,d0
	move.b	d0,d1
	lsl.w	#8,d1
	clr.w	d0
	swap	d0
	divu	#10,d0
	move.b	d0,d1
	lsl.l	#8,d1
	swap	d0
	move.b	d0,d1
	lsl.l	#8,d1
	add.l	#$30303000,d1
	move.l	d1,number
	rts

itoa2:
	move.l	#$20202020,d1
	and.l	#$ffff,d0
	cmp.w	#100,d0
	bcs.s	\skip1
	divu	#100,d0
	move.b	d0,d1
	add.b	#48,d1
	lsl.w	#8,d1
	clr.w	d0
	swap	d0
	bra.s	\skip2
\skip1	cmp.w	#10,d0
	bcs.s	\skip3
\skip2	divu	#10,d0
	move.b	d0,d1
	add.b	#48,d1
	lsl.l	#8,d1
	swap	d0
\skip3	move.b	d0,d1
	add.b	#48,d1
	lsl.l	#8,d1
	move.l	d1,number
	rts


game_won:
	move.w	time(a6),d7
	moveq	#3,d2
	bsr	draw_face
	move.w	squares_1(a6),d0	; Mark every mine with a flag
	move.l	a6,a0
\loop1	btst	#6,(a0)+
	beq.s	\skip1
	bset	#5,-1(a0)
\skip1	dbf.s	d0,\loop1
	moveq	#0,d2
	bsr	draw_board

\loop2	bsr	get_key
	cmp.w	#264,d0
	bne.s	\loop2
	bsr	enter_hall_of_fame
	rts


game_over:
	moveq	#2,d2
	bsr	draw_face
	moveq	#1,d2
	bsr	draw_board
\loop1	bsr	get_key
	cmp.w	#264,d0
	bne.s	\loop1
	rts

get_key:
\loop1  tst.w   tios::kb_vars+$1E
	beq.s	\loop1
	move.w	tios::kb_vars+$1E,d0
        clr.w   tios::kb_vars+$1E
	rts

place_flag:
	movem.l	d2-d3,-(sp)
	bsr	read_square
	btst	#4,d2			; Is the square unopened ?
	bne.s	\end
	btst	#5,d2			; Is there already a flag ?
	bne.s	\flag
	bset	#5,0(a6,d3.w)
	addq.w	#1,flags(a6)
	bra.s	\skip1
\flag	bclr	#5,0(a6,d3.w)
	subq.w	#1,flags(a6)
\skip1	move.b	#1,new_flag(a6)
	moveq	#0,d2
	bsr	draw_square
\end	movem.l	(sp)+,d2-d3
	rts


open_trivial:
	movem.l	d1-d6/a0/a2-a3,-(sp)
	lea	around_table(pc),a0
	move.w	d0,a2
	move.w	d1,a3

	moveq	#0,d4			; Count the flags around this square
	moveq	#0,d5
	moveq	#7,d6
\loop1	add.b	(a0)+,d0
	add.b	(a0)+,d1
	bsr	read_square
	cmp.w	#48,d2
	beq.s	\skip1
	btst	#5,d2
	beq.s	\skip1
	addq.w	#1,d4
	btst	#6,d2
	beq.s	\skip1
	addq.w	#1,d5
\skip1	dbf.s	d6,\loop1

	move.w	a2,d0			; Was there as many flags as mines ?
	move.w	a3,d1
	bsr	read_square
	and.b	#15,d2
	cmp.b	d2,d4
	bne.s	\ok
	moveq	#1,d0
	cmp.b	d4,d5			; Were the flags correctly placed ?
	bne.s	\end

	move.w	a2,d0			; Open adjacent squares
	moveq	#7,d6
	lea	around_table(pc),a0
\loop2	add.b	(a0)+,d0
	add.b	(a0)+,d1
	bsr	read_square
	btst	#5,d2
	bne.s	\skip2
	movem.w	d0-d1,-(sp)
	bsr	open_square
	movem.w	(sp)+,d0-d1
\skip2	dbf.s	d6,\loop2

\ok	moveq	#0,d0
\end	movem.l	(sp)+,d1-d6/a0/a2-a3
	rts


try_square:
	movem.l	d1-d3,-(sp)
	moveq	#1,d2
	bsr	draw_face
	move.w	#FACE_DELAY,face_timer(a6)
	bsr	read_square
 	btst    #5,d2                   ; Have we already a flag ?
        bne.s   \ok
	btst	#6,d2			; Did we hit a mine ?
	beq.s	\no_mine
	moveq	#1,d0
	bra.s	\end
\no_mine
	btst	#4,d2			; Was the square opened ?
	beq.s	\unopened
	and.b	#15,d2
	beq.s	\ok
	bsr	open_trivial
	bra.s	\end
\unopened
	bsr	open_square
	bsr	count_flags
\ok	moveq	#0,d0
\end
	movem.l	(sp)+,d1-d3
	rts


open_square:
	move.b	d0,d2			; to save stack..
	lsl.w	#8,d2
	move.b	d1,d2
	movem.w	d2,-(sp)
	bsr	read_square
	btst	#4,d2			; Has this square already been opened or are we outside the board ?
	bne.s	\end

	move.w	d1,d3
	mulu	width(a6),d3
	add.w	d0,d3
	bset	#4,0(a6,d3.w)		; Reveal the square
	bclr	#5,0(a6,d3.w)
	move.w	d2,d3
	moveq	#0,d2
	bsr	draw_square
	and.b	#15,d3			; Is there any mines around this square ?
	bne.s	\end

	addq.w	#1,d0			; Open the adjacent squares too
	bsr	open_square
	addq.w	#1,d1
	bsr	open_square
	subq.w	#1,d0
	bsr	open_square
	subq.w	#1,d0
	bsr	open_square
	subq.w	#1,d1
	bsr	open_square
	subq.w	#1,d1
	bsr	open_square
	addq.w	#1,d0
	bsr	open_square
	addq.w	#1,d0
	bsr	open_square

\end	movem.w	(sp)+,d2
	moveq	#0,d0
	moveq	#0,d1
	move.b	d2,d1
	ext.w	d1
	lsr.w	#8,d2
	move.b	d2,d0
	ext.w	d0
	rts


init_interrupt:
	;move.l	$64,level1_int
	;move.w	#$2700,sr
	;bclr	#2,$600001
	;move.l	#interrupt,$64
	;bset	#2,$600001
	;move.w	#$2000,sr
	;rts

	move.w		#$0700,d0
	trap		#1
	move.l		$64,level1_int
	bclr.b		#2,$600001
	move.l		#interrupt,$64
	bset.b		#2,$600001
	trap		#1
	rts

close_interrupt:
	;move.w	#$2700,sr
	;bclr	#2,$600001
	;move.l	level1_int,$64
	;bset	#2,$600001
	;move.w	#$2000,sr
	;rts	

	move.w		#$0700,d0
	trap		#1
	bclr.b		#2,$600001
	move.l		level1_int,$64
	bset.b		#2,$600001
	trap		#1
	rts

interrupt:
	movem.l	a6,-(sp)
	move.l	board(pc),a6
	tst.b	cursor_timer(a6)
	bne.s	\skip1
	eor.b	#1,cursor_state(a6)
	bset	#1,cursor_state(a6)
	move.b	#CURSOR_DELAY,cursor_timer(a6)
\skip1	subq.b	#1,cursor_timer(a6)

	tst.w	sec_timer(a6)
	bne.s	\skip2
	move.w	#TICS_PER_SEC,sec_timer(a6)
	cmp.w	#999,time(a6)
	beq.s	\skip2
	addq.w	#1,time(a6)
	move.b	#1,new_time(a6)
\skip2	subq.w	#1,sec_timer(a6)

	cmp.w	#-1,face_timer(a6)
	beq.s	\skip3
	tst.w	face_timer(a6)
	beq.s	\skip3
	subq.w	#1,face_timer(a6)
\skip3

	movem.l	(sp)+,a6
	move.l	level1_int(PC),-(a7)
	rts


blink_cursor:
	btst	#1,cursor_state(a6)
	beq.s	\end
	bclr	#1,cursor_state(a6)
	tst.b	cursor_state(a6)
	beq.s	\clear
	bsr	draw_cursor
	bra.s	\end
\clear	bsr	clear_cursor
\end	rts



move_cursor:
	movem.l	d0-d1,-(sp)
	cmp.w	#337,d2			; Check if cursor key was pressed
	bcs.s	\end
	cmp.w	#348,d2
	bhi.s	\end
	move.w	cursor_x(a6),d0
	move.w	cursor_y(a6),d1
	btst	#1,d2
	beq.s	\skip1
	subq	#1,d1
\skip1	btst	#0,d2
	beq.s	\skip2
	subq	#1,d0
\skip2	btst	#3,d2
	beq.s	\skip3
	addq	#1,d1
\skip3	btst	#2,d2
	beq.s	\skip4
	addq	#1,d0
\skip4

	tst.w	d0
	bge.s	\skip5
	move.w	width_1(a6),d0
\skip5	tst.w	d1
	bge.s	\skip6
	move.w	height_1(a6),d1
\skip6	cmp.w	width_1(a6),d0
	ble.s	\skip7
	moveq	#0,d0
\skip7	cmp.w	height_1(a6),d1
	ble.s	\skip8
	moveq	#0,d1
\skip8

	cmp.w	cursor_x(a6),d0
	bne.s	\clear
	cmp.w	cursor_y(a6),d1
	beq.s	\end
\clear	bsr	clear_cursor
	move.w	d0,cursor_x(a6)
	move.w	d1,cursor_y(a6)
	move.b	#3,cursor_state(a6)
	move.b	#CURSOR_DELAY,cursor_timer(a6)
\end	movem.l	(sp)+,d0-d1
	rts


draw_cursor:
	movem.l	d0/a0,-(sp)
	lea	LCD_MEM+480,a0
	move.w	cursor_y(a6),d0
	add.w	corner_y(a6),d0
	mulu	#210,d0
	add.w	cursor_x(a6),d0
	add.w	corner_x(a6),d0
	add.w	d0,a0
	move.b	#255,(a0)
	or.b	#129,30(a0)
	or.b	#129,60(a0)
	or.b	#129,90(a0)
	or.b	#129,120(a0)
	or.b	#129,150(a0)
	move.b	#255,180(a0)
	movem.l	(sp)+,d0/a0
	rts


clear_cursor:
	movem.l	d0-d2,-(sp)
	move.w	cursor_x(a6),d0
	move.w	cursor_y(a6),d1
	moveq	#0,d2
	bsr	draw_square
	movem.l	(sp)+,d0-d2
	rts


draw_board:
	move.w	height_1(a6),d1
\loop1	move.w	width_1(a6),d0
\loop2	bsr	draw_square
	dbf.s	d0,\loop2
	dbf.s	d1,\loop1
	rts


draw_square:
	movem.l	d0-d3/a0-a1,-(sp)
	move.w	d1,d3
	mulu	width(a6),d3
	add.w	d0,d3
	move.b	0(a6,d3.w),d3
	add.w	corner_x(a6),d0
	add.w	corner_y(a6),d1

	tst.b	d2			; Is the game over ?
	bne.s	\game_over

	btst.b	#4,d3
	beq.s	\unopened
	and.w	#15,d3
	mulu	#7,d3
	lea	numbers_gfx(pc),a0
	add.l	d3,a0
	bsr	draw_tile
	bra.s	\end
\unopened
	btst.b	#5,d3
	beq.s	\unmarked
	lea	flag_gfx(pc),a0
	bsr	draw_tile
	bra.s	\end
\unmarked
	lea	hidden_gfx(pc),a0
	bsr	draw_tile
	bra.s	\end

\game_over
	btst.b	#6,d3
	beq.s	\no_mine
	lea	mine_gfx(pc),a0
	btst.b	#5,d3
	beq.s	\unmarked2
	bsr	draw_tile
	bra.s	\end
\unmarked2
	bsr	draw_tile_inv
	bra.s	\end
\no_mine
	move.w	d3,d2
	and.w	#15,d2
	mulu	#7,d2
	lea	numbers_gfx(pc),a0
	add.l	d2,a0
	btst.b	#4,d3
	beq.s	\unopened2
	bsr	draw_tile
	bra.s	\end
\unopened2
	bsr	draw_tile_inv
\end	movem.l	(sp)+,d0-d3/a0-a1
	rts


init_board:
	movem.l	d0-d7/a0-a1,-(sp)
	moveq	#BOARD_WIDTH,d0		; Coordinates of top left corner
	sub.w	width(a6),d0
	lsr.w	#1,d0
	move.w	d0,corner_x(a6)
	moveq	#BOARD_HEIGHT,d0
	sub.w	height(a6),d0
	lsr.w	#1,d0
	move.w	d0,corner_y(a6)
	move.w	width(a6),d0		; These are used in loops
	subq.w	#1,d0
	move.w	d0,width_1(a6)
	move.w	height(a6),d0
	subq.w	#1,d0
	move.w	d0,height_1(a6)
	move.w	height(a6),d0
	mulu	width(a6),d0
	subq.w	#1,d0
	move.w	d0,squares_1(a6)

	moveq	#119,d0			; Clear the board
	move.l	a6,a0
\loop1	clr.l	(a0)+
	dbf.s	d0,\loop1

	move.w	mines(a6),d1		; Place mines
	subq.w	#1,d1
\loop2	move.w	height(a6),d0
	jsr	flib::random
	move.w	d0,d2
	mulu	width(a6),d2
	move.w	width(a6),d0
	jsr	flib::random
	add.w	d0,d2
	tst.b	0(a6,d2.w)
	bne.s	\loop2
	bset.b	#6,0(a6,d2.w)
	dbf.s	d1,\loop2


	move.l	a6,a1			; Count how many mines there are around each square
	move.w	squares_1(a6),d0
	lea	1(a1,d0.w),a1
	move.w	height_1(a6),d5
\loop3	move.w	width_1(a6),d4
\loop4	moveq	#0,d6
	move.w	d4,d0
	move.w	d5,d1

	lea	around_table(pc),a0
	moveq	#7,d7
\loop5	add.b	(a0)+,d0
	add.b	(a0)+,d1
	bsr	read_square
	lsr.w	#6,d2
	add.w	d2,d6
	dbf.s	d7,\loop5

	or.b	d6,-(a1)
	dbf.s	d4,\loop4
	dbf.s	d5,\loop3
	movem.l	(sp)+,d0-d7/a0-a1
	rts


read_square:
	movem.l	d1,-(sp)
	moveq	#48,d2
	tst.w	d0			; Are we outside the board ?
	bcs.s	\end
	cmp.w	width(a6),d0
	bcc.s	\end
	tst.w	d1
	bcs.s	\end
	cmp.w	height(a6),d1
	bcc.s	\end
	move.w	d1,d3
	mulu	width(a6),d3
	add.w	d0,d3
	move.b	0(a6,d3.w),d2
\end	movem.l	(sp)+,d1
	rts


draw_tile_16:
	lea	LCD_MEM,a1
	mulu	#30,d1
	add.w	d0,d1
	add.w	d1,a1
	move.w	(a0)+,0(a1)
	move.w	(a0)+,30(a1)
	move.w	(a0)+,60(a1)
	move.w	(a0)+,90(a1)
	move.w	(a0)+,120(a1)
	move.w	(a0)+,150(a1)
	move.w	(a0)+,180(a1)
	move.w	(a0)+,210(a1)
	move.w	(a0)+,240(a1)
	move.w	(a0)+,270(a1)
	move.w	(a0)+,300(a1)
	move.w	(a0)+,330(a1)
	move.w	(a0)+,360(a1)
	move.w	(a0)+,390(a1)
	move.w	(a0)+,420(a1)
	move.w	(a0),450(a1)
	rts


draw_tile:
	lea	LCD_MEM+480,a1
	mulu	#210,d1
	add.w	d0,d1
	add.w	d1,a1
	move.b	(a0)+,0(a1)
	move.b	(a0)+,30(a1)
	move.b	(a0)+,60(a1)
	move.b	(a0)+,90(a1)
	move.b	(a0)+,120(a1)
	move.b	(a0)+,150(a1)
	move.b	(a0),180(a1)
	rts

draw_tile_inv:
	lea	LCD_MEM+480,a1
	mulu	#210,d1
	add.w	d0,d1
	add.w	d1,a1
	move.b	(a0)+,(a1)
	eor.b	#255,(a1)
	move.b	(a0)+,30(a1)
	eor.b	#255,30(a1)
	move.b	(a0)+,60(a1)
	eor.b	#255,60(a1)
	move.b	(a0)+,90(a1)
	eor.b	#255,90(a1)
	move.b	(a0)+,120(a1)
	eor.b	#255,120(a1)
	move.b	(a0)+,150(a1)
	eor.b	#255,150(a1)
	move.b	(a0),180(a1)
	eor.b	#255,180(a1)
	rts



;********************** Variables ******************************


BOARD_SIZE	equ 480
corner_x	equ BOARD_SIZE+0
corner_y	equ BOARD_SIZE+2
width_1		equ BOARD_SIZE+4
height_1	equ BOARD_SIZE+6
width		equ BOARD_SIZE+8
height		equ BOARD_SIZE+10
mines		equ BOARD_SIZE+12
game_type	equ BOARD_SIZE+14


clear_start	equ BOARD_SIZE+16

cursor_x	equ BOARD_SIZE+16
cursor_y	equ BOARD_SIZE+18
squares_1	equ BOARD_SIZE+20
flags		equ BOARD_SIZE+22
face_timer	equ BOARD_SIZE+24
time		equ BOARD_SIZE+26
sec_timer	equ BOARD_SIZE+28
new_time	equ BOARD_SIZE+30
cursor_timer	equ BOARD_SIZE+31
cursor_state	equ BOARD_SIZE+32
new_flag	equ BOARD_SIZE+33

clear_end	equ BOARD_SIZE+35


old_stack:	dc.l 0
level1_int	dc.l 0
board:		dc.l 0
board_handle:	dc.w 0


best_times:	dc.w 999,999,999,999,999,999,999,999,999,999,999,999

around_table:	dc.b 1,0,0,1,-1,0,-1,0,0,-1,0,-1,1,0,1,0

number:		dcb 4,0

patterns:	dc.b %00000000,%00001111,%11110000,%11111111

title_gfx:	dc.w %1000101010001011,%1011101000101110,%1110111011101110
		dc.w %1101101011001010,%0010001000101000,%1000101010001010
		dc.w %1010101010101011,%1011101010101110,%1110111011101110
		dc.w %1000101010011010,%0000101101101000,%1000100010001100
		dc.w %1000101010001011,%1011101000101110,%1110100011101010

best_gfx:	dc.b %11001110,%01101110,%00111010,%10001011,%10011000
		dc.b %10101000,%10000100,%00010010,%11011010,%00100000
		dc.b %11001110,%01000100,%00010010,%10101011,%10010000
		dc.b %10101000,%00100100,%00010010,%10001010,%00001000
		dc.b %11001110,%11000100,%00010010,%10001011,%10110000

help_gfx:	dc.b %10010111,%01010011
		dc.b %10100100,%01010100
		dc.b %11000111,%00100010
		dc.b %10100100,%00100001
		dc.b %10010111,%00100110


_comment:	dc.b "Minesweeper 2.1",0

main_txt:	dc.b 85,50,2,"(C) 1996/98",0
		dc.b 5,62,2,"Vili Jussila <vili@cc.tut.fi>",0
                dc.b 0,73,2,"PlusShell port by Rusty Wagner",0
                dc.b 90,85,0,"<river@gte.net>",0
		dc.b 8,95,2,"F1-Beginner    F4-Custom",0
		dc.b 8,105,2,"F2-Intermed.   F5-Best Times",0
		dc.b 8,115,2,"F3-Expert      F6-Help",0,255

custom1:	dc.b 48,64,2,"Height (2-16):",0,255
custom2:	dc.b 48,76,2,"Width  (2-30):",0,255
custom3:	dc.b 48,88,2,"Mines (1-   ):    ",0,255


best_txt:	dc.b 88,32,2,"Beginner",0,72,65,2,"Intermediate",0,96,98,2,"Expert",0,255
input_txt:	dc.b 56,40,2,"Excellent time !",0,32,54,2,"Please enter your name",0,255

help_txt:	dc.b 2,30,2,"Pad",0,32,31,1,"- Moves the cursor. Note that the",0,44,40,1,"cursor can wrap around the edge.",0
		dc.b 6,50,2,"F1",0,32,51,1,"- Uncovers a square. If all mines",0,44,60,1,"around a numbered square are",0
		dc.b 44,69,1,"found,pressing F1 on that square",0,44,78,1,"uncovers rest of the squares.",0
		dc.b 6,88,2,"F5",0,32,89,1,"- Mark a square with a flag.",0,44,98,1,"Marking it again removes the",0,44,107,1,"flag.",0
		dc.b 2,117,2,"Esc",0,32,118,1,"- End the game",0,255

mr_entern:	dc.b "Mr Enter",0

hall_of_fame:	dc.b "Anonymous",0,"Anonymous",0,"Anonymous",0,"Anonymous",0
		dc.b "Anonymous",0,"Anonymous",0,"Anonymous",0,"Anonymous",0
		dc.b "Anonymous",0,"Anonymous",0,"Anonymous",0,"Anonymous",0
		dc.b "Anonymous",0,"Anonymous",0,"Anonymous",0,"Anonymous",0



;************** Graphics ****************



hidden_gfx:	dc.b %00000000
		dc.b %01010100
		dc.b %00101010
		dc.b %01010100
		dc.b %00101010
		dc.b %01010100
		dc.b %00000000

;		dc.b %00000000		; Try this and see ugly vertical shadows..
;		dc.b %01111110
;		dc.b %01111110
;		dc.b %01111110
;		dc.b %01111110
;		dc.b %01111110
;		dc.b %00000000


flag_gfx:	dc.b %00000000
		dc.b %00111100
		dc.b %00111100
		dc.b %00111100
		dc.b %00100000
		dc.b %00100000
		dc.b %01110000



mine_gfx:	dc.b %00000000
		dc.b %00100000
		dc.b %00010000
		dc.b %00111000
		dc.b %01011100
		dc.b %01111100
		dc.b %00111000


numbers_gfx:	dc.b %00000000
		dc.b %00000000
		dc.b %00000000
		dc.b %00000000
		dc.b %00000000
		dc.b %00000000
		dc.b %00000000

		dc.b %00000000
		dc.b %00011000
		dc.b %00111000
		dc.b %01111000
		dc.b %00011000
		dc.b %00011000
		dc.b %00111100

		dc.b %00000000
		dc.b %00111100
		dc.b %01100110
		dc.b %00000110
		dc.b %00111100
		dc.b %01100000
		dc.b %01111110

		dc.b %00000000
		dc.b %01111110
		dc.b %00000110
		dc.b %00011100
		dc.b %00000110
		dc.b %01100110
		dc.b %00111100

		dc.b %00000000
		dc.b %01100000
		dc.b %01100110
		dc.b %01100110
		dc.b %01111110
		dc.b %00000110
		dc.b %00000110

		dc.b %00000000
		dc.b %01111110
		dc.b %01100000
		dc.b %01111100
		dc.b %00000110
		dc.b %01100110
		dc.b %00111100

		dc.b %00000000
		dc.b %00111100
		dc.b %01100000
		dc.b %01111100
		dc.b %01100110
		dc.b %01100110
		dc.b %00111100

		dc.b %00000000
		dc.b %01111110
		dc.b %00000110
		dc.b %00001100
		dc.b %00011000
		dc.b %00110000
		dc.b %01100000

		dc.b %00000000
		dc.b %00111100
		dc.b %01100110
		dc.b %00111100
		dc.b %01100110
		dc.b %01100110
		dc.b %00111100

dig_numbers_gfx:
		dc.b %01111100
		dc.b %10111010
		dc.b %11000110
		dc.b %11000110
		dc.b %11000110
		dc.b %10000010
		dc.b %00000000
		dc.b %10000010
		dc.b %11000110
		dc.b %11000110
		dc.b %11000110
		dc.b %10111010
		dc.b %01111100

		dc.b %00000000
		dc.b %00000010
		dc.b %00000110
		dc.b %00000110
		dc.b %00000110
		dc.b %00000010
		dc.b %00000000
		dc.b %00000010
		dc.b %00000110
		dc.b %00000110
		dc.b %00000110
		dc.b %00000010
		dc.b %00000000

		dc.b %01111100
		dc.b %00111010
		dc.b %00000110
		dc.b %00000110
		dc.b %00000110
		dc.b %00111010
		dc.b %01111100
		dc.b %10111000
		dc.b %11000000
		dc.b %11000000
		dc.b %11000000
		dc.b %10111000
		dc.b %01111100

		dc.b %01111100
		dc.b %00111010
		dc.b %00000110
		dc.b %00000110
		dc.b %00000110
		dc.b %00111010
		dc.b %01111100
		dc.b %00111010
		dc.b %00000110
		dc.b %00000110
		dc.b %00000110
		dc.b %00111010
		dc.b %01111100

		dc.b %00000000
		dc.b %10000010
		dc.b %11000110
		dc.b %11000110
		dc.b %11000110
		dc.b %10111010
		dc.b %01111100
		dc.b %00111010
		dc.b %00000110
		dc.b %00000110
		dc.b %00000110
		dc.b %00000010
		dc.b %00000000

		dc.b %01111100
		dc.b %10111000
		dc.b %11000000
		dc.b %11000000
		dc.b %11000000
		dc.b %10111000
		dc.b %01111100
		dc.b %00111010
		dc.b %00000110
		dc.b %00000110
		dc.b %00000110
		dc.b %00111010
		dc.b %01111100

		dc.b %01111100
		dc.b %10111000
		dc.b %11000000
		dc.b %11000000
		dc.b %11000000
		dc.b %10111000
		dc.b %01111100
		dc.b %10111010
		dc.b %11000110
		dc.b %11000110
		dc.b %11000110
		dc.b %10111010
		dc.b %01111100

		dc.b %01111100
		dc.b %00111010
		dc.b %00000110
		dc.b %00000110
		dc.b %00000110
		dc.b %00000010
		dc.b %00000000
		dc.b %00000010
		dc.b %00000110
		dc.b %00000110
		dc.b %00000110
		dc.b %00000010
		dc.b %00000000

		dc.b %01111100
		dc.b %10111010
		dc.b %11000110
		dc.b %11000110
		dc.b %11000110
		dc.b %10111010
		dc.b %01111100
		dc.b %10111010
		dc.b %11000110
		dc.b %11000110
		dc.b %11000110
		dc.b %10111010
		dc.b %01111100

		dc.b %01111100
		dc.b %10111010
		dc.b %11000110
		dc.b %11000110
		dc.b %11000110
		dc.b %10111010
		dc.b %01111100
		dc.b %00111010
		dc.b %00000110
		dc.b %00000110
		dc.b %00000110
		dc.b %00111010
		dc.b %01111100



face_gfx:	dc.w %0000001111100000
		dc.w %0000110000011000
		dc.w %0001000000000100
		dc.w %0010000000000010
		dc.w %0100000000000001
		dc.w %0100011000110001
		dc.w %1000011000110000
		dc.w %1000000000000000
		dc.w %1000000000000000
		dc.w %1000100000001000
		dc.w %0100010000010001
		dc.w %0100001111100001
		dc.w %0010000000000010
		dc.w %0001000000000100
		dc.w %0000110000011000
		dc.w %0000001111100000

		dc.w %0000001111100000
		dc.w %0000110000011000
		dc.w %0001000000000100
		dc.w %0010000000000010
		dc.w %0100111000111001
		dc.w %0100111000111001
		dc.w %1000111000111000
		dc.w %1000000000000000
		dc.w %1000000000000000
		dc.w %1000000111000000
		dc.w %0100001101100001
		dc.w %0100001000100001
		dc.w %0010001101100010
		dc.w %0001000111000100
		dc.w %0000110000011000
		dc.w %0000001111100000

		dc.w %0000001111100000
		dc.w %0000110000011000
		dc.w %0001000000000100
		dc.w %0010000000000010
		dc.w %0100101000101001
		dc.w %0100010000010001
		dc.w %1000101000101000
		dc.w %1000000000000000
		dc.w %1000000000000000
		dc.w %1000001111100000
		dc.w %0100010000010001
		dc.w %0100100000001001
		dc.w %0010000000000010
		dc.w %0001000000000100
		dc.w %0000110000011000
		dc.w %0000001111100000

		dc.w %0000001111100000
		dc.w %0000110000011000
		dc.w %0001000000000100
		dc.w %0010000000000010
		dc.w %0100000000000001
		dc.w %0100111111111001
		dc.w %1001111101111100
		dc.w %1010111101111010
		dc.w %1100111000111001
		dc.w %1000000000000000
		dc.w %0100000000000001
		dc.w %0100010000010001
		dc.w %0010001111100010
		dc.w %0001000000000100
		dc.w %0000110000011000
		dc.w %0000001111100000




;************** Constants ****************

BOARD_WIDTH	equ 30
BOARD_HEIGHT	equ 16
STACK_SIZE	equ 3500
FACE_DELAY	equ 250
CURSOR_DELAY	equ 100
TICS_PER_SEC	equ 350
F1		equ 17
F5		equ 21
ESC		equ 25




;************** End of Fargo program ****************

        end
