         ; ***************************************************
         ; *
         ; *               L U N O I D     V I
         ; *
         ; *
         ; *           Programmed by Patrick Davidson
         ; *
         ; *             last updated : 20-May-97
         ; *
         ; ***************************************************
         ; ---------- VARIABLE ADDRESSES (WITHIN TEXT MEMORY) ------
x        =$80dF
y        =$80e0
p        =$80e1
xv       =$80e2
yv       =$80e3
level    =$80e5
lives    =$80e6
won      =$80e7
speed    =$80e8
bricks   =$80e9
score    =$80eb
scrlstart =$80ed
scrlpos  =$80ef
sprtemp  =$80f1
uchoice  =$80f2
data     =$8100
temp     =$8180
temp2    =$8182
temp3    =$8183
  ; ------------------------ PROGRAM HEADER -------------------
         .org     0
         .include "ti-85.h"
         .db      "7.3 / Patrick Davidson"
         .db      0
#DEFINE LOCATE(xc,yc)    push hl \ ld hl,(xc*256)+yc \ ld ($800c),hl \ pop hl
#DEFINE D_HL             push de \ push hl \ ROM_CALL(D_HL_DECI) \ pop hl \ pop de
  ; ----------------------- INITIALIZATION --------------------
         ROM_CALL(CLEARLCD)
         ld       b,96
         ld       a,32
         ld       ix,$8641
pcl:     ld       hl,0
         ld       ($800c),hl
         push     af
         push     bc
         ROM_CALL(TX_CHARPUT)
         ld       hl,$fc00
         ld       b,8
         ld       de,16
il2:     ld       a,(hl)
         ld       (ix),a
         add      hl,de
         inc      ix
         djnz     il2
         pop      bc
         pop      af
         inc      a
         djnz     pcl
         ld       a,(CONTRAST)
         inc      a
         cp       $20
         jr       nz,ok1
         dec      a
ok1:     inc      a
         cp       $20
         jr       nz,ok2
         dec      a
ok2:     out      (2),a
         ld       (iy+13),0
         ld       a,1
         ld       (ZS_BITS),a
         CALL_(stuff)            ;do the game
         ld       a,(CONTRAST)    
         out      (2),a
         ROM_CALL(CLEARLCD)
         ld       hl,temp2
         ld       a,(hl)
         or       a
         ret      nz
         LOCATE(0,0)
         ld       de,(PROGRAM_ADDR)
         ld       hl,hstitle
         add      hl,de
         ROM_CALL(D_ZT_STR)
         LOCATE(16,1)
         ld       ix,hsdata
         add      ix,de
         ld       b,7
         ld       de,17
high_display_loop:
         ld       l,(ix+0)
         ld       h,(ix+1)
         D_HL
         ld       hl,$800c
         dec      (hl)
         inc      ix
         inc      ix
         push     ix
         pop      hl
         ROM_CALL(D_ZT_STR)
         add      ix,de
         ld       hl,$800c
         inc      (hl)
         djnz     high_display_loop
         CALL_(wait_key)
         ret
stuff:   ld       hl,saved_flag     ;Check for saved game
         ld       de,(PROGRAM_ADDR)
         add      hl,de
         ld       a,(hl)
         or       a
         JUMP_NZ(restore_game)
         ld       hl,0
         ld       ($800c),hl
         ld       hl,initial_msg
         add      hl,de
         ROM_CALL(D_ZT_STR)
         ld       ix,$800c
         inc      (ix)
         ROM_CALL(D_ZT_STR)
         inc      (ix)
         ROM_CALL(D_ZT_STR)
         ld       a,200
         CALL_(waste_time)
         ld       hl,scrltext
         add      hl,de
         ld       (scrlstart),hl
         ld       hl,$0806
         ld       ($8941),hl
intro_loop:
         ld       hl,$89c1
         ld       b,128
clrg:    ld       (hl),0
         inc      hl
         djnz     clrg
         ld       hl,(scrlpos)
         inc      hl
         ld       (scrlpos),hl
         ld       de,(scrl_end-scrltext)*8
         call     CP_HL_DE
         jr       nz,not_end_of_text
         ld       hl,0
         ld       (scrlpos),hl
not_end_of_text:
         ld       de,(scrlpos)
         ld       hl,(scrlstart)
         ld       b,3
fspl:    res      0,e
         srl      d
         jr       nc,no_ovfs
         set      0,e
no_ovfs: rrc      e
         djnz     fspl
         add      hl,de
         ld       b,15
         ld       a,(scrlpos)
         cpl
         and      7
         ld       e,a
scroll:  ld       a,(hl)
         inc      hl
         push     hl
         push     bc
         ld       hl,$8541
         push     de
         ld       de,8
         ld       b,a
scroll_draw:
         add      hl,de
         djnz     scroll_draw
         ld       b,8
         ld       ix,$8943
copy_char:
         ld       a,(hl)
         ld       (ix),a
         inc      ix
         inc      hl
         djnz copy_char
         pop      de
         ld       b,e
         ld       c,56
         ld       ix,$8941
         push     de
         CALL_(drw_spr)
         pop      de
         ld       a,e
         add      a,8
         ld       e,a
         pop      bc
         pop      hl
         djnz     scroll
         ld       ix,$89c1
         ld       b,8
blocks__:ld       (ix),255
         ld       (ix+15),255
         push     bc
         ld       bc,16
         add      ix,bc
         pop      bc
         djnz     blocks__
         ld       hl,$89c1
         ld       de,$ff80
         ld       bc,128
         ldir
         call     GET_KEY
         or       a
         JUMP_Z(intro_loop)
         cp       K_ALPHA
         ret      z
         ld       hl,speed
         ld       (hl),4
         cp       K_F2
         jr       nz,not_f2
         ld       (hl),3
not_f2:  cp       K_F3
         jr       nz,not_f3
         ld       (hl),2
not_f3:  cp       K_F4
         jr       nz,not_f4
         ld       (hl),1
not_f4:  cp       K_F5
         jr       nz,not_f5
         ld       (hl),0
not_f5:  ld       hl,lives
         ld       (hl),8
  ; ------------------- OUTER GAME LOOP ----------------------
         ROM_CALL(CLEARLCD)
         ld       hl,0
         ld       ($800c),hl
         ld       hl,universe_ttl
         ld       de,(PROGRAM_ADDR)
         add      hl,de
         ROM_CALL(D_ZT_STR)
         push     hl
         ld       hl,$800c
         inc      (hl)
         pop      hl
         ROM_CALL(D_ZT_STR)
loopu:   call     GET_KEY
         cp       K_F1
         jr       z,classic
         cp       K_F2
         jr       z,f2
         cp       K_F3
         jr       z,f3
         cp       K_F4
         jr       z,f4
         cp       K_F5
         jr       z,f5
         jr       loopu
f2:      ld       a,2
         jr       start
f3:      ld       a,4
         jr       start
f4:      ld       a,6
         jr       start
f5:      ld       a,8
         jr       start
classic: ld       a,0
start:   ld       (uchoice),a
play_da_game:
         CALL_(level_addr)
         ld       ix,lives
         inc      (ix)
         ld       b,32                  ;Copy the map + count blocks
         ld       ix,$8100
set_up_1:ld       c,(hl)
         rlc      c
         rlc      c
         ld       a,c
         and      3
         ld       (ix),a
         inc      ix
         rlc      c
         rlc      c
         ld       a,c
         and      3
         ld       (ix),a
         inc      ix
         rlc      c
         rlc      c
         ld       a,c
         and      3
         ld       (ix),a
         inc      ix
         rlc      c
         rlc      c
         ld       a,c
         and      3
         ld       (ix),a
         inc      ix
         inc      hl
         djnz     set_up_1
         ld       hl,level
         inc      (hl)
level_loop:
         ld       ix,x
         CALL_(do_level)
restore_position:
         CALL_(play_level)
         xor      a
         out      (1),a
         ld       a,(ix+8)
         or       a
         jr       z,finished_level
         dec      (ix+7)
         jr       z,game_over
         jr       level_loop
finished_level:
         CALL_(level_addr)
         ld       a,(hl)
         cp       255
         Jr       nz,play_da_game
  ; ---------------------- END OF GAME -------------------------
game_over:                    ;Set up score page
         ROM_CALL(CLEARLCD)
         LOCATE(0,0)
         ld       hl,end_msg
         ld       de,(PROGRAM_ADDR)
         add      hl,de
         ROM_CALL(D_ZT_STR)
         ld       a,(ix+7)              ;Score for levels completed
         or       a
         jr       nz,won_
         dec      (ix+6)
won_:    ld       a,(ix+6)
         or       a
         jr       z,no_levels
         ld       b,a
         ld       hl,0
         ld       de,1000
level_score_loop:
         ld       a,30
         CALL_(waste_time)
         add      hl,de
         LOCATE(16,1)
         D_HL
         push     hl
         ld       hl,(score)
         add      hl,de
         LOCATE(16,6)
         D_HL
         ld       (score),hl
         pop      hl
         djnz     level_score_loop
no_levels:
         ld       bc,(bricks)           ;Score for bricks hit
         ld       a,b
         or       c
         jr       z,no_bricks
         ld       hl,0              
bricks_loop:
         inc      hl
         inc      hl
         inc      hl
         inc      hl
         inc      hl
         LOCATE(16,2)
         D_HL
         push     hl
         ld       hl,(score)
         inc      hl
         inc      hl
         LOCATE(16,6)
         D_HL
         ld       (score),hl
         pop      hl
         dec      bc
         xor      a
         cp       b
         jr       nz,bricks_loop
         cp       c
         jr       nz,bricks_loop
no_bricks:
         ld       a,5                  ;Score bonus for speed
         sub      (ix+9)
         ld       b,a
         ld       hl,0
         ld       de,1000
speed_loop:
         ld       a,30
         CALL_(waste_time)
         add      hl,de
         LOCATE(16,3)
         D_HL
         push     hl
         ld       hl,(score)
         add      hl,de
         LOCATE(16,6)
         D_HL
         ld       (score),hl
         pop      hl
         djnz     speed_loop
         ld       a,(ix+7)              ;Score victory bonus
         or       a
         JUMP_Z(lost)
         ld       b,80
         ld       hl,0
         ld       de,50
victory_loop:
         ld       a,30
         CALL_(waste_time)
         add      hl,de
         LOCATE(16,4)
         D_HL
         push     hl
         ld       hl,(score)
         add      hl,de
         LOCATE(16,6)
         D_HL
         ld       (score),hl
         pop      hl
         djnz     victory_loop

         ld       b,(ix+7)              ;Score bonus for extra lives
         ld       hl,0
         ld       de,250
lives_loop:
         ld       a,30
         CALL_(waste_time)
         add      hl,de
         LOCATE(16,5)
         D_HL
         push     hl
         ld       hl,(score)
         add      hl,de
         LOCATE(16,6)
         D_HL
         ld (score),hl
         pop      hl
         djnz lives_loop
         ld       b,(ix+6)
lost:    CALL_(wait_key)
         ld       hl,lowest                  ;See if ya got a hi-score
         ld       de,(PROGRAM_ADDR)
         add      hl,de
         call     LD_HL_MHL
         ld       de,(score)
         call     CP_HL_DE
         ret      nc
         ROM_CALL(CLEARLCD)
         LOCATE(0,0)
         ld       de,(PROGRAM_ADDR)
         ld       hl,hi_score_str
         add      hl,de
         ROM_CALL(D_ZT_STR)
         ld       ix,lowest
         inc      de
         inc      de
         add      ix,de
         ld       (temp),ix
         ld       b,16
         ld       c,32
space_loop:
         ld       (ix),c
         inc      ix
         djnz     space_loop
         ld       ix,(temp)
         ld       b,0
enter_name_loop:
         call     GET_KEY
         cp       0
         jr       z,enter_name_loop
         cp       K_DEL
         jr       z,backup
         cp       K_ENTER
         jr       z,nomore
         ld       c,a
         ld       a,15
         cp       b
         jr       z,enter_name_loop
         ld       hl,chartable
         ld       de,(PROGRAM_ADDR)
         add      hl,de
         ld       e,c
         ld       d,0
         add      hl,de
         ld       a,(hl)
         ld       (ix),a
         ROM_CALL(TX_CHARPUT) 
         inc      b
         inc      ix
         jr       enter_name_loop
backup:  dec      b
         ld       a,255
         cp       b
         jr       z,too_far
         dec      ix
         ld       (ix),32
         ld       hl,$800d
         dec      (hl)
         ld       a,32
         ROM_CALL(TX_CHARPUT)
         dec      (hl)
         jr       enter_name_loop
too_far: inc      b
         jr       enter_name_loop
nomore:  ld       hl,lowest
         ld       de,(PROGRAM_ADDR)
         add      hl,de
         ld       de,(score)
         ld       (hl),e
         push     hl
         inc      hl
         ld       (hl),d
         pop      ix              ;sort hiscore table
         ld       b,6
sort_scores
         ld       e,(ix)
         ld       d,(ix+1)
         ld       l,(ix-19)
         ld       h,(ix-18)
         call     CP_HL_DE
         ret      nc
         push     bc
         ld       b,19
         ld       d,0
exg_loop:ld       e,(ix)
         ld       c,(ix-19)
         ld       (ix),c
         ld       (ix-19),e
         inc      ix
         djnz     exg_loop
         ld       de,-38
         add      ix,de
         pop      bc
         djnz     sort_scores
         ret
 ;------------------ LEVEL STARTING CODE ---------------------
do_level:ld       (ix+0),128
         ld       (ix+1),58
         ld       (ix+2),112
         ld       (ix+3),-1
         ld       (ix+4),-1
         ret
 ;---------------------- THE MAIN GAME -----------------------
play_level:
         ROM_CALL(CLEARLCD)       ;Display level entry message
         ld       ix,$800c
         ld       (ix+0),0
         ld       (ix+1),0
         ld       hl,approaching
         ld       de,(PROGRAM_ADDR)
         add      hl,de
         ROM_CALL(D_ZT_STR)
         ld       hl,level
         ld       c,(hl)
         ld       b,0
         push     bc
         pop      hl
         ROM_CALL(D_HL_DECI)
         ld       hl,press
         ld       de,(PROGRAM_ADDR)
         add      hl,de
         ROM_CALL(D_ZT_STR)
         ld       hl,lives
         ld       c,(hl)
         ld       b,0
         push     bc
         pop      hl
         ROM_CALL(D_HL_DECI)
         CALL_(wait_key)
         cp       K_EXIT
         JUMP_Z(r3)
         ld       ix,x
game_main_loop:
         ld       hl,$8641
         ld       b,128
         xor      a
clgloop: ld       (hl),a
         inc      hl
         ld       (hl),a
         inc      hl
         ld       (hl),a
         inc      hl
         ld       (hl),a
         inc      hl
         ld       (hl),a
         inc      hl
         ld       (hl),a
         inc      hl
         ld       (hl),a
         inc      hl
         ld       (hl),a
         inc      hl
         djnz     clgloop
         ld       a,(ix+9)              ;Slow down a bit
         or       a
         CALL_NZ(waste_time)
         CALL_(redraw_solid)      ;Redraw all blocks
         ld       a,(ix)                ;Move ball left/right      
         add      a,(ix+3)                   
         ld       (ix+0),a             
         bit      5,(ix+1)             ;Bounce off of blocks          
         jr       nz,bottom_section_1      
         CALL_(test_hit)      
         bit      1,a      
         jr       z,horiz_not_solid      
         ld       a,(ix+3)      
         neg      
         ld       (ix+3),a      
         add      a,(ix)      
         ld       (ix),a      
         jr       bottom_section_1
horiz_not_solid:
         cp       0
         jr       z,bottom_section_1
         ld       a,(ix+3)
         neg
         ld       (ix+3),a
bottom_section_1:      
         ld       a,(ix+1)              ;Move ball up/down      
         add      a,(ix+4)      
         ld       (ix+1),a      
         bit      5,(ix+1)             ;Bounce off of blocks          
         jr       nz,bottom_section_2
         CALL_(test_hit)
         bit      1,a
         jr       z,vert_not_solid
         ld       a,(ix+4)
         neg
         ld       (ix+4),a
         add      a,(ix+1)
         ld       (ix+1),a
         jr       bottom_section_2
vert_not_solid:
         cp       0
         jr       z,bottom_section_2
         ld       a,(ix+4)
         neg
         ld       (ix+4),a
bottom_section_2:
         push     ix                    ;Draw the ball
         ld       c,(ix+1)
         ld       b,(ix+0)
         srl      b
         dec      c
         dec      b
         ld       ix,spr_ball
         ld       de,(PROGRAM_ADDR)
         add      ix,de
         CALL_(drw_spr)
         pop      ix
         ld       a,(ix+1)              ;Bounce off top
         cp       1
         jr       nz,not_top
         ld       (ix+4),1
not_top: ld       a,(ix+1)              ;Bounce off paddle / Fall off screen
         cp       62
         ret      z
         cp       61
         CALL_Z(bounce_paddle)
         cp       60
         CALL_Z(bounce_paddle)
         ld       a,(ix+0)              ;Bounce off left edge
         and      252
         jr       nz,not_hit_left_edge
hit_left_edge:                          ;Hit left edge of screen
         ld       a,(ix+3)
         bit      7,a
         jr       z,not_hit_left_edge
         neg
         ld       (ix+3),a
not_hit_left_edge:
         ld       a,(ix+0)              ;Bounce off right edge
         add      a,4
         and      252
         jr       nz,not_hit_right_edge
hit_right_edge:                         ;Hit right edge of screen
         ld       a,(ix+3)
         bit      7,a
         jr       nz,not_hit_right_edge
         neg
         ld       (ix+3),a
not_hit_right_edge:
         ld       a,%00111111           ;Exit key = get out!
         out      (1),a
         in       a,(1)
         bit      6,a
         JUMP_Z(r3)
         ld       a,%01111110           ;Left arrow = go left!
         out      (1),a
         in       a,(1)
         bit      1,a
         CALL_Z(go_left)
         in       a,(1)                 ;Right arrow = go right!
         bit      2,a                 
         CALL_Z(go_right)
         in       a,(1)                 ;Down arrow = save & exit
         bit      0,a
         JUMP_Z(save)
         ld       a,(ix+2)              ; Draw paddle
         srl      a
         add      a,b
         ld       b,a
         ld       c,60
         push     ix
         ld       ix,leftp
         ld       de,(PROGRAM_ADDR)
         add      ix,de
         push     bc
         push     ix
         CALL_(drw_spr)
         pop      ix
         ld       de,6
         add      ix,de
         pop      bc
         ld       a,b
         add      a,8
         ld       b,a
         CALL_(drw_spr)
         pop      ix
         xor      a
         or       (ix+8)
         ld       de,$fc00
         ld       hl,$8641
         ld       bc,1024
         ldir
         JUMP_NZ(game_main_loop)
         ret
  ; ------------------- UTILITY ROUTINES ----------------------
save:    pop      bc                ;Save the game
         pop      bc
         ld       hl,saved_flag
         ld       de,(PROGRAM_ADDR)
         add      hl,de
         ld       (hl),1
         ld       bc,168
         ld       hl,saved_game
         add      hl,de
         push     hl
         pop      de
         ld       hl,$80df
         ldir
         ld       hl,ZS_BITS
         ld       (hl),3
         ld       hl,temp2
         ld       (hl),1
         ld       a,(CONTRAST)    
         out      (2),a
         ret
restore_game:                       ;Restore the game
         ld       (hl),0
         ld       bc,168
         inc      hl
         ld       de,$80df
         ldir
         JUMP_(restore_position)
wait_key:ld       a,200                   ;Wait for a keypress
         CALL_(waste_time)
wait_inner:
         call     GET_KEY
         or       a
         ret      nz
         jr       wait_inner
test_hit:ld       a,(ix+1)                ;Test if a block has been hit
         and      28
         sla      a
         sla      a
         ld       b,a
         ld       a,(ix+0)
         srl      a
         srl      a
         srl      a
         srl      a
         add      a,b
         ld       hl,$8100
         ld       c,a
         ld       b,0
         add      hl,bc
         ld       a,(hl)
         cp       1
         jr       z,clr_block
         cp       2
         jr       z,dec_block
         ret
dec_block:
         ld       (hl),1
         ret
clr_block:                    ;Clear out a block
         push     af
         ld       (hl),0
         ld       a,(ix+1)
         and      28
         ld       b,0
         ld       c,a
         sla      c
         sla      c
         sla      c
         bit      7,c
         jr       z,n_s
         ld       b,1
n_s:     sla      c
         ld       a,(ix+0)
         srl      a
         srl      a
         srl      a
         srl      a
         ld       hl,$fc00
         add      hl,bc
         ld       b,0
         ld       c,a
         add      hl,bc
         ld       c,16
         ld       (hl),b
         add      hl,bc
         ld       (hl),b
         add      hl,bc
         ld       (hl),b
         add      hl,bc
         ld       (hl),b
         inc      (ix+10)
         jr       z,ovl
         pop      af
         ret
ovl:     inc      (ix+11)
         pop      af
         ret
r3:      ld       a,(CONTRAST)    
         out      (2),a
         ld       hl,temp2
         ld       (hl),1
         inc      sp                   ;Return multiple levels
         inc      sp
         inc      sp
         inc      sp
         ret
go_right:ld       a,(ix+2)
         cp       224
         jr       z,right_edge
         inc      a
         ld       c,1
         in       e,(c)
         bit      3,e
         jr       z,quit_moving
         cp       224
         jr       z,right_edge
         inc      a
         cp       224
         jr       z,right_edge
         inc      a
         cp       224
         jr       z,right_edge
         inc      a
quit_moving:
         ld       (ix+2),a
         ret
right_edge:                   ;If paddle is at right edge
         ld       a,224
         ld       (ix+2),a
         ret
go_left: ld       a,(ix+2)
         cp       0
         jr       z,left_edge
         dec      a
         jr       z,left_edge
         ld       c,1
         in       e,(c)
         bit      3,e
         jr       z,quit_moving
         dec      a
         jr       z,left_edge
         dec      a
         jr       z,left_edge
         dec      a
         ld       (ix+2),a
         xor      a
         ret
left_edge:                     ;If paddle is at left edge
         xor      a
         ld       (ix+2),a
         ret
waste_time:                         ;Delay a little bit
         push     bc
         ld       b,0
l:       push     bc
         ld       b,a
il:      nop
         djnz     il
         pop      bc
         djnz     l
         pop      bc
         ret
bounce_paddle:                ;Bounce ball off paddle
         ld       a,(ix+0)
         sub      (ix+2)
         ld       c,a
         srl      a
         srl      a             
         srl      a
         srl      a
         srl      a
         ret      nz
         ld       hl,(PROGRAM_ADDR)
         ld       de,bounces
         add      hl,de
         ld       b,0
         add      hl,bc
         ld       a,(hl)
         ld       (ix+3),a
         ld       a,-1
         ld       (ix+4),a
         ret
redraw_solid:                 ;Redraw all bricks
         ld       hl,won
         ld       (hl),0
         ld       ix,$8641
         ld       hl,$8100
         ld       b,8
rs_outer:push     bc
         ld       b,16
rs_inner:ld       a,(hl)
         cp       3
         jr       z,draw_block_solid
         cp       1
         jr       z,draw_block
         cp       2
         jr       z,draw_block_tough
ok:      inc      hl
         inc      ix
         djnz     rs_inner
         ld       de,48
         add      ix,de
         pop      bc
         djnz     rs_outer
         ld       ix,x
         ret
draw_block:                   ;Draw a standard block
         push     hl
         ld       hl,won
         ld       (hl),1
         pop      hl
         ld       (ix+0),255
         ld       (ix+16),129
         ld       (ix+32),129
         ld       (ix+48),255
         jr       ok
draw_block_solid:             ;Draw a solid block
         ld       (ix+0),255
         ld       (ix+16),255
         ld       (ix+32),255
         ld       (ix+48),255
         jr       ok
draw_block_tough:             ;Draw a tough block
         push     hl
         ld       hl,won
         ld       (hl),1
         pop      hl
         ld       (ix+0),255
         ld       (ix+16),195
         ld       (ix+32),195
         ld       (ix+48),255
         jr       ok
  ; ------------------------ DATA -------------------------
bounces: .db      -3,-3
         .db      -2,-2,-2,-2,-2,-2
         .db      -1,-1,-1,-1,-1,-1
         .db      0,0,0,0
         .db      1,1,1,1,1,1
         .db      2,2,2,2,2,2
         .db      3,3
initial_msg: 
         .db      "L U N O I D     V I I",0
         .db      "by Patrick A Davidson"
         .db      "  (ariwsi@juno.com)  ",0
         .db      "Choose Speed : F1-F5"
         .db      0
scrltext:.db      "                 "
         .db      "WELCOME TO LUNOID 7!     "
         .db      "PRESS A FUNCTION KEY "
         .db      "TO SELECT THE SPEED AND "
         .db      "BEGIN THE GAME!  F1 IS THE "
         .db      "SLOWEST AND F5 THE FASTEST.  "
         .db      "IF YOU JUST WANT TO LOOK AT "
         .db      "THE HIGHSCORES, PRESS ALPHA.  "
         .db      "WHEN PLAYING, MOVE AROUND "
         .db      "WITH THE LEFT AND RIGHT "
         .db      "ARROWS.  TO MOVE MORE SLOWLY, "
         .db      "HOLD DOWN THE UP ARROW AT THE "
         .db      "SAME TIME.  TO EXIT AND SAVE "
         .db      "THE GAME, PRESS THE DOWN "
         .db      "ARROW.  THIS GAME WAS FINISHED "
         .db      "ON 20-MAY-1997.  THE "
         .db      "SOURCE CODE "
         .db      "IS 1,248 LINES LONG!  "
         .db      "TEXT RESTARTS....."
scrl_end:.db      "                 "
end_msg: .db      " -> Final Scoring <- "
         .db      "Levels finished:    0"
         .db      "     Bricks hit:    0"
         .db      "    Speed bonus:    0"
         .db      "  Victory bonus:    0"
         .db      "Lives remaining:    0"
         .db      "*** TOTAL SCORE:    0"
         .db      " ---> Lunoid VI <---",0
approaching:
         .db      "---> NEXT LEVEL:"
         .db      0
press:   .db      "PRESS ANY KEY TO PLAY"
         .db      "LIVES REMAINING:"
 ; -------------------- SAVED GAME DATA -----------------------
saved_flag:
         .db      0
saved_game:
         .dw      0,0,0,0,0,0,0,0,0,0,0,0
         .dw      0,0,0,0,0,0,0,0,0,0,0,0
         .dw      0,0,0,0,0,0,0,0,0,0,0,0
         .dw      0,0,0,0,0,0,0,0,0,0,0,0
         .dw      0,0,0,0,0,0,0,0,0,0,0,0
         .dw      0,0,0,0,0,0,0,0,0,0,0,0
         .dw      0,0,0,0,0,0,0,0,0,0,0,0
 ; -------------------- UNIVERSE DATA -------------------------
universe_ttl:
         .db      "CHOOSE YOUR UNIVERSE:",0
         .DB      "F1) The Sandbox      "
         .db      "F2) Classic Universe "
         .db      "F3) The Dark Realm   "
         .db      "F4) Castle of Death  "
         .db      "F5) Ultimate Universe",0
universe_list:
         .dw      sandbox-32
         .dw      classic_universe-32
         .dw      dark_realm-32
         .dw      castle_death-32
         .dw      ultimate-32
classic_universe:
         .db      %11111100,%00000000,%00000000,%00111111
         .db      %11110000,%00000000,%00000000,%00001111
         .db      %11000000,%00000000,%00000000,%00000011
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%10101010,%10101010,%00000000
         .db      %00000000,%01010101,%01010101,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %11000000,%00000000,%00000000,%00000011
         .db      %11010101,%01010101,%01010101,%01010111
         .db      %11000000,%00000000,%00000000,%00000011
         .db      %11010101,%01010101,%01010101,%01010111
         .db      %11000000,%00000000,%00000000,%00000011
         .db      %11010101,%01010101,%01010101,%01010111
         .db      %11000000,%00000000,%00000000,%00000011
         .db      %11000000,%00000000,%00000000,%00000011
         .db      %00000000,%10100000,%00101010,%10000000
         .db      %00000010,%00001000,%00100000,%00000000
         .db      %00000010,%00001000,%00100000,%00000000
         .db      %00000000,%10100000,%00101010,%10000000
         .db      %00000010,%00001000,%00000000,%10000000
         .db      %00000010,%00001000,%00100000,%10000000
         .db      %00000000,%10100000,%00001010,%10000000
         .db      %00001111,%11111111,%11111111,%11110000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00111111,%11111111,%11111111,%11111100
         .db      %00101010,%10001010,%10100010,%10100000
         .db      %00100000,%10001000,%00100010,%00001000
         .db      %00101010,%10001010,%10100010,%00001000
         .db      %00100000,%00001000,%00100010,%00001000
         .db      %00100000,%00001000,%00100010,%10100000
         .db      %00111111,%11111111,%11111111,%11111100
         .db      255
dark_realm:
         .db      %01000100,%01000100,%01000100,%01000100
         .db      %00010001,%00010001,%00010001,%00010001
         .db      %01000100,%01000100,%01000100,%01000100
         .db      %00010001,%00010001,%00010001,%00010001
         .db      %01000100,%01000100,%01000100,%01000100
         .db      %00010001,%00010001,%00010001,%00010001
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %11111100,%00000000,%00000000,%00111111
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000001,%01010101,%01010101,%01010101
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %00000011,%11111111,%11111111,%11111111
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %01010101,%01010101,%01010101,%01000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      %11111111,%11111111,%11111111,%11000000
         .db      255
sandbox: .db      %01010101,%01010101,%01010101,%01010101
         .db      %01000000,%00000000,%00000000,%00000001
         .db      %01000101,%01010101,%01010101,%01010001
         .db      %01000100,%00000000,%00000000,%00010001
         .db      %01000100,%00000000,%00000000,%00010001
         .db      %01000101,%01010101,%01010101,%01010001
         .db      %01000000,%00000000,%00000000,%00000001
         .db      %01010101,%01010101,%01010101,%01010101
         .DB      %00000010,%10000010,%10000010,%10000000
         .db      %00000000,%00000000,%00000000,%00000000
         .DB      %00000010,%10000010,%10000010,%10000000
         .db      %00000000,%00000000,%00000000,%00000000
         .DB      %00000010,%10000010,%10000010,%10000000
         .db      %00000000,%00000000,%00000000,%00000000
         .DB      %00000010,%10000010,%10000010,%10000000
         .db      %00000000,%00000000,%00000000,%00000000
         .db      255
castle_death:
         .db      %10101000,%00000000,%00000000,%00101010
         .db      %10101000,%00000000,%00000000,%00101010
         .db      %10101000,%00000000,%00000000,%00101010
         .db      %10101000,%00000000,%00000000,%00101010
         .db      %10101000,%00000000,%00000000,%00101010
         .db      %10101000,%00000000,%00000000,%00101010
         .db      %10101000,%00000000,%00000000,%00101010
         .db      %11111111,%11110000,%00001111,%11111111
         .db      %10001000,%10001000,%10001000,%10001000
         .db      %00100010,%00100010,%00100010,%00100010
         .db      %10001000,%10001000,%10001000,%10001000
         .db      %00100010,%00100010,%00100010,%00100010
         .db      %10001000,%10001000,%10001000,%10001000
         .db      %00100010,%00100010,%00100010,%00100010
         .db      %10001000,%10001000,%10001000,%10001000
         .db      %00100010,%00100010,%00100010,%00100010
         .db      255
ultimate:.db      %10101010,%10101010,%10101010,%10101010
         .db      %10101010,%10101010,%10101010,%10101010
         .db      %10101010,%10101010,%10101010,%10101010
         .db      %10101010,%10101010,%10101010,%10101010
         .db      %10101010,%10101010,%10101010,%10101010
         .db      %10101010,%10101010,%10101010,%10101010
         .db      %00000000,%00000000,%00000000,%00000000
         .DB      %11111100,%00111111,%11111100,%00111111
         .db      %10101010,%10101010,%10101010,%10101010
         .db      %10111111,%11111111,%11111111,%11111110
         .db      %10101010,%10101010,%10101010,%10101010
         .db      %10111111,%11111111,%11111111,%11111110
         .db      %10101010,%10101010,%10101010,%10101010
         .db      %10111111,%11111111,%11111111,%11111110
         .db      %10101010,%10101010,%10101010,%10101010
         .db      %10111111,%11111111,%11111111,%11111110
         .db      255
 ; ---------------------- HIGH SCORES -------------------------
hi_score_str:
         .db      "----> LUNOID  7 <----"
         .db      " You have  a hiscore!"
         .db      "Enter your name:     ",0
hstitle: .db      "=LUNOID 7 HIGHSCORES=",0
hsdata:  .dw      666
         .db      "Bill Gates      ",0
         .dw      666
         .db      "Bill Gates      ",0
         .dw      666
         .db      "Bill Gates      ",0
         .dw      666
         .db      "Bill Gates      ",0
         .dw      666
         .db      "Bill Gates      ",0
         .dw      666
         .db      "Bill Gates      ",0
lowest   .dw      666
         .db      "Bill Gates      ",0
chartable:
         .db      "..........XTOJE."
         .db      ". WSNID!.ZVRMHC?"
         .db      ".YUQLGB#x~+PKFA|"
         .db      "@54321.~+......."
 ; -------------- SRPITE DRAWING ROUTINE--------------
drw_spr: ld       e,128             ;FindPixel NO MORE !!!!!!!!!!!!!!!
         push     bc
         ld       a,b
         and      7                 ;Calculate bit number
         jr       z,done
         ld       b,a
bit_loop:srl      e
         djnz     bit_loop
done:    pop      bc
         ld       a,e
         ld       (sprtemp),a
         ld       hl,$8641          ;Calculate byte number
         srl      b
         srl      b
         srl      b
         ld       a,b               ;A = x shift right (bytes)
         sla      c                 
         sla      c
         ld       b,c               
         sla      c
         sla      c                 ;C = 8 LSBs of Y offset              
         or       c                 ;A = 8 LSBs of offset
         ld       c,a               ;C = 8 LSBs of offset
         ld       a,b
         rlca
         rlca
         and      3
         ld       b,a               ;B = 2 MSBs of offset
         add      hl,bc             ;HL = address
         ld       d,(ix)            ;C is width
         inc      ix
         ld       b,(ix)            ;C is height
         inc      ix
oloop:   push     bc                ;Save # of rows
         push     hl                ;Save screen address
         ld       b,d               ;Load width
         ld       c,(ix)            ;Load one line of image
         inc      ix
         ld       a,(sprtemp)       ;Load pixel mask
iloop:   bit      7,c               ;Test leftmost pixel
         jr       z,noplot          ;See if a plot is needed
         ld       e,a               ;OR pixel with screen
         or       (hl)
         ld       (hl),a
         ld       a,e
noplot:  sla      c
         rrca
         jr       nc,notedge        ;Test if edge of byte reached
         inc      hl                ;Go to next byte
notedge: djnz     iloop
         pop      hl                ;Restore address
         ld       bc,16             ;Go to next line
         add      hl,bc
         pop      bc                ;Restore data
         djnz     oloop
         ret
 ; -------------- SPRITE FOR PADDLE ------------------
leftp:   .db      8,4
         .db      %01111111
         .db      %10000000
         .db      %10000000
         .db      %01111111
rightp:  .db      8,4
         .db      %11111110
         .db      %00000001
         .db      %00000001
         .db      %11111110
spr_ball:.db      3,3
         .db      %01000000
         .db      %11100000
         .db      %01000000
 ; -------------- FIND A LEVEL ------------------------
level_addr:
         ld       a,(uchoice)
         ld       e,a
         ld       d,0
         ld       hl,universe_list
         add      hl,de
         ld       de,(PROGRAM_ADDR)
         add      hl,de
         call     LD_HL_MHL
         ld       a,(level)
         ld       b,a
         inc      b
         ld       de,(PROGRAM_ADDR)
         add      hl,de
         ld       de,32
find_level_loop:
         add      hl,de
         djnz     find_level_loop
         ret
         .end
