;<FFernique@eisti.fr>
 include "include\tios89.h"
 include "include\util89.h"
 xdef _main
 xdef _comment
 xdef _ti92plus

;***************************************;
spd       equ 50			;spd*100/64 = %vitesse balle par rapport aux lignes
filldone  equ 19116			;surface  remplir (75%)
maxballes equ 10
ballsize  equ 8
totalcnt  equ 25488 ;156*82
;************* Code ********************;
SetFont MACRO
        move.w \1,-(a7)
        jsr tios::FontSetSys
        addq.l #2,a7
        ENDM

_main:
 move.w  #1,-(a7)			;fontes #1
 jsr     tios::FontSetSys
 lea     2(a7),a7

 clr.l   score
Menu:
 jsr     util::zap_screen
 bsr     ShowScores
 tst.l   score				;un score  la dernire partie ?
 beq     MenuLoop
 bsr     ArchiveScore			;oui=>on archive nom et score du joueur
 clr.l   score
MenuLoop:
 jsr     util::idle_loop
 cmp.w   #264,d0
 beq     Exit
 cmp.w   #13,d0
 bne     MenuLoop


NewGame:
 move.w  #2,level
 move.w  level,d0
 mulu    #ballsize,d0
 move.w  d0,nbballes
 clr.l   score

StartLevel:

 move.l  $64,oldint#1
 move.l  #newint#1,$40064

 move.w  level,d0
 move.w  d0,lives			;autant de vie que de balles
 move.w  #1,curtype
 move.w  #112*64,xcur
 move.w  #52*64,ycur
 clr.w   flag
 clr.w   fillcnt
 bsr     InitScreenHandle
 bsr     InitBalls
 bsr     ShowActualScore
 bsr     ShowFilled
 bsr     ShowLivesLeft


Main:
 bsr     GetKeyStat			;scanne le clavier
 btst.w  #2,flag			;si on construit une ligne,
 bne     NoMove				;pas de curseur : NoMove
 bsr     MoveCursor
NoMove:
 bsr     DrawLine			;continue la ligne s'il y en a une

 bsr     MoveBalls			;dplace les balles (non affiches),
 bsr     XorBalls			;les dessine,
 bsr     TestBounces			;et les fait rebondir comme il faut.

 btst.w  #2,flag			;dessine le curseur si ncessaire
 bne     NoCurs1
 bsr     XorCursor
NoCurs1:
 bsr     DrawScreen			;copie l'cran virtuel vers le vrai

 btst.w  #2,flag			;efface le curseur si ncessaire
 bne     NoCurs2
 bsr     XorCursor
NoCurs2:
 bsr     XorBalls			;efface les balles

 cmp     #12,curcount
 bne     NoChgtCurs
 clr.w   curcount
 add.w   #1,curnum
 and.w   #%11,curnum
NoChgtCurs:
 add.w   #1,curcount

 move.w  #4,d3				;temporisation
\delay:
 cmp.w   sync,d3
 bgt     \delay
 clr.w   sync


 btst.b  #5,keystat+7
 bne     NoTeacher
 trap    #4
NoTeacher:
 btst.b  #6,keystat+8			;ESC ?
 bne     NoEsc
 bset.w  #3,flag
 bset.w  #4,flag
NoEsc:
 btst.w  #3,flag			;niveau fini ?
 beq     Main				;non=>retour au dbut de la boucle
					;OUI...
 move.l  oldint#1(PC),$40064

 btst.w  #4,flag			;plus de vie (=perdu) ?
 bne     Lose				;oui=>on s'en va
 cmp     #maxballes,level		;on a fini le dernier niveau ?
 beq     Win				;oui=>jeu fini ('that's all folks')
 add.w   #ballsize,nbballes		;non=>niveau suivant (une balle de plus)
 move.w  lives,d0			;chaque vie rapporte 500 pts
 mulu    #500,d0
 add.l   d0,score
 bsr     ShowActualScore		;affiche le score
 lea     windialog(PC),a6		;"level completed"
 jsr     util::show_dialog
 jsr     util::idle_loop
 add.w   #1,level			;niveau suivant
 bra     StartLevel			;ON Y VA !


Lose:
 lea     losedialog(PC),a6
 bra     Suite
Win:
 lea     donedialog(PC),a6
Suite:
 jsr     util::show_dialog
 jsr     util::idle_loop
 bra     Menu

Exit:
 rts

;***************************************;

GetKeyStat:
 movem.l d0-d1/a0,-(a7)
 lea	 keystat(PC),a0
 move.w  #$FFFE,d0
 moveq	 #9,d1
GetKeys:
 move.w  d0,$600018
 nop
 nop
 nop
 nop
 nop
 nop
 nop
 nop
 nop
 nop
 nop
 nop
 rol.w	 #1,d0
 move.b  $60001B,(a0)+
 dbra	 d1,GetKeys
 movem.l (a7)+,d0-d1/a0
 rts

;***************************************;

MoveCursor:
 move.w  #64,d0
 btst.b  #3,keystat			;LOCK appuy=>dplacement lent
 bne     NoSlow
 move.w  #10,d0
NoSlow:

 btst.b  #4,keystat
 bne     NoLeft
 sub.w   d0,xcur
NoLeft:
 btst.b  #6,keystat
 bne     NoRight
 add.w   d0,xcur
NoRight:
 btst.b  #7,keystat
 bne     NoDown
 add.w   d0,ycur
NoDown:
 btst.b  #5,keystat
 bne     NoUp
 sub.w   d0,ycur
NoUp:

 tst.w   xcur				;vrifie la validit des coordonnes
 bge     \ok1
 clr.w   xcur
\ok1:
 cmp     #224*64,xcur
 ble     \ok2
 move.w  #224*64,xcur
\ok2:
 tst.w   ycur
 bge     \ok3
 clr.w   ycur
\ok3:
 cmp     #96*64,ycur
 ble     \ok4
 move.w  #96*64,ycur
\ok4:

 btst.b  #4,keystat+7
 bne     NoDiamond
 btst.w  #0,flag
 bne     NoDiamondRelease			;si la touche n'a pas t relache on tourne pas !
 bset.w  #0,flag
 eori.w  #1,curtype			;0->1 et 1->0
 bra     NoDiamondRelease
NoDiamond:
 bclr.w  #0,flag
NoDiamondRelease:
 btst.b  #4,keystat+6
 bne     No2nd
 btst.w  #1,flag
 bne     No2ndRelease			;si la touche n'a pas t relache on commence pas une ligne !
 bset.w  #1,flag
 move.w  xcur,d0
 lsr.w   #6,d0
 add.w   #8,d0
 move.w  d0,line_pos1
 move.w  d0,line_pos2
 move.w  ycur,d1
 lsr.w   #6,d1
 add.w   #8,d1
 move.w  d1,line_pos1+2
 move.w  d1,line_pos2+2
 bsr     GetPixel
 tst.b   d2
 bne     No2nd
 bsr     PutPixel
 bset.w  #2,flag
 move.w  curtype,d0
 move.w  d0,line_dir
 bra     No2ndRelease
No2nd:
 bclr.w  #1,flag
No2ndRelease:
 rts

;***************************************;

DrawLine:
 btst.w  #2,flag			;y'a ti une ligne en construction ?
 bne     \OK				;oui=>on le prolonge
 rts					;non=>c'est fini
\OK:
 movem.l d0-d3,-(a7)
 tst.w   line_dir			;ligne horizontale ou verticale ?
 bne     VertLine
HorzLine: 				;horizontale...
 clr.w   d3
 move.w  line_pos1+2,d1
 move.w  line_pos1,d0
 subq.w  #1,d0
 bsr     GetPixel			;c'est fini  gauche ?
 tst.b   d2
 bne     EndLeft
 bsr     PutPixel			;non=>on prolonge
 move.w  d0,line_pos1
 moveq.w #1,d3				;d3 indique que la ligne n'est pas finie
EndLeft:
 move.w  line_pos2,d0
 addq.w  #1,d0
 bsr     GetPixel			;c'est fini  droite ?
 tst.b   d2
 bne     EndRight
 bsr     PutPixel			;non=>on prolonge
 move.w  d0,line_pos2
 moveq.w #1,d3				;d3 indique que la ligne n'est pas finie
EndRight:
 tst.w   d3				;la ligne est finie (d3=0) ?
 bne     NoHorzLineEnd
 bclr.w  #2,flag			;oui=>on l'indique
 lea     rect(PC),a0			;cherche puis remplit les zones vides
 move.w  line_pos1,(a0) ;x1		;en dessous...
 move.w  line_pos1+2,2(a0) ;y1
 move.w  line_pos2,4(a0) ;x2
 move.w  line_pos1,d0
 addq.w  #1,d0
 move.w  line_pos1+2,d1
\rep1:
 addq.w  #1,d1
 bsr     GetPixel 
 tst.b   d2
 beq     \rep1
 move.w  d1,6(a0)  ;y2
 bsr     CheckRect
 lea     rect(PC),a0			;puis au dessus.
 move.w  line_pos1,(a0) ;x1
 move.w  line_pos1+2,6(a0) ;y2
 move.w  line_pos2,4(a0) ;x2
 move.w  line_pos1,d0
 addq.w  #1,d0
 move.w  line_pos1+2,d1
\rep2:
 subq.w  #1,d1
 bsr     GetPixel 
 tst.b   d2
 beq     \rep2
 move.w  d1,2(a0)  ;y1
 bsr     CheckRect
NoHorzLineEnd:				;la ligne n'est pas finie=>a s'ra pour la prochaine fois...
 movem.l (a7)+,d0-d3
 rts

VertLine:
 clr.w   d3
 move.w  line_pos1+2,d1
 move.w  line_pos1,d0
 subq.w  #1,d1
 bsr     GetPixel			;c'est fini en haut ?
 tst.b   d2
 bne     EndUp
 bsr     PutPixel			;non=>on prolonge
 move.w  d1,line_pos1+2
 moveq.w #1,d3				;d3 indique que la ligne n'est pas finie
EndUp:
 move.w  line_pos2+2,d1
 addq.w  #1,d1
 bsr     GetPixel			;c'est fini en bas ?
 tst.b   d2
 bne     EndDown
 bsr     PutPixel			;non=>on prolonge
 move.w  d1,line_pos2+2
 moveq.w #1,d3				;d3 indique que la ligne n'est pas finie
EndDown:
 tst.w   d3				;la ligne est finie (d3=0) ?
 bne     NoVertLineEnd
 bclr.w  #2,flag			;oui=>on l'indique
 lea     rect(PC),a0			;cherche puis remplit les zones vides
 move.w  line_pos1+2,2(a0) ;y1		; gauche...
 move.w  line_pos2,4(a0) ;x2
 move.w  line_pos2+2,6(a0) ;y2
 move.w  line_pos1+2,d1
 addq.w  #1,d1
 move.w  line_pos1,d0
\rep3:
 subq.w  #1,d0
 bsr     GetPixel 
 tst.b   d2
 beq     \rep3
 move.w  d0,(a0)  ;x1
 bsr     CheckRect
 lea     rect(PC),a0			;puis  droite.
 move.w  line_pos1+2,2(a0) ;y1
 move.w  line_pos1,(a0) ;x1
 move.w  line_pos2+2,6(a0) ;y2
 move.w  line_pos1+2,d1
 addq.w  #1,d1
 move.w  line_pos2,d0
\rep4:
 addq.w  #1,d0
 bsr     GetPixel 
 tst.b   d2
 beq     \rep4
 move.w  d0,4(a0)  ;x2
 bsr     CheckRect
NoVertLineEnd:				;la ligne n'est pas finie=>a s'ra pour la prochaine fois...
 movem.l (a7)+,d0-d3
 rts

;***************************************;

CheckRect:				;remplit le rectangle s'il est vide
 movem.l d0-d1/a0-a1,-(a7)
 lea     rect(PC),a0
 lea  ballsptr,a1			;pour chaque balle, regarde si elle
 move.w  #0,d1				;dans le rectangle  tester
CheckNextBall:
 move.w  0(a1,d1),d0			;d0=xball
 lsr.w   #6,d0				;attention! coord balles spciales (*64)
 cmp     (a0),d0 ;x1			;xball<x1 ?
 blt     NotInRect			;oui=>la balle n'est pas dedans
 cmp     4(a0),d0 ;x2			;xball>x2 ?
 bgt     NotInRect			;oui=>la balle n'est pas dedans
 move.w  2(a1,d1),d0			;d0=yball
 lsr.w   #6,d0
 cmp     2(a0),d0 ;y1			;yball<y1 ?
 blt     NotInRect			;oui=>la balle n'est pas dedans
 cmp     6(a0),d0 ;y2			;yball>y2 ?
 bgt     NotInRect			;oui=>la balle n'est pas dedans
 bra     BallInRect			;non=>la balle est dedans, on arrte
NotInRect:				;cette balle n'est pas dedans
 add.w   #ballsize,d1
 cmp.w   nbballes,d1			;y'en a ti une autre ?
 bne     CheckNextBall			;oui => on continue  vrifier
 bsr     FillRect			;aucune balle dedans => on remplit !
 move.w  4(a0),d0			;puis on calcule la surface remplie
 sub.w   (a0),d0
 move.w  6(a0),d1
 sub.w   2(a0),d1
 mulu    d1,d0
 add.w   d0,fillcnt			;et on l'ajoute au total
 lsr.w   #3,d0				;1/8 pt par pixel
 add.l   d0,score

 move.w  fillcnt,d0
 cmp.w   #filldone,d0			;75% remplis ?
 blt     NoLevelDone			;non=>level pas fini

 sub.w   #filldone,d0			;oui :
 lsr.w   #2,d0				;encore 1/8 pt par pixel en rab (>75%)
 add.l   d0,score
 bset.w  #3,flag			;on indique que le level est fini

NoLevelDone:
 bsr     ShowActualScore
 bsr     ShowFilled
BallInRect:
 movem.l (a7)+,d0-d1/a0-a1
 rts

;***************************************;

FillRect:				;remplit un rectangle !!! (vite)
 movem.l d0-d6/a0,-(a7)
 lea     rect(pc),a0
 move.w  (a0),d0 ;x1
 move.w  4(a0),d2 ;x2
 cmp     d0,d2
 bgt     \NoChgtx
 exg.w   d0,d2				;d2 doit tre la xcoord la +grande
\NoChgtx:

 move.w  2(a0),d1 ;y1
 move.w  6(a0),d3 ;y2
 cmp     d1,d3
 bgt     \NoChgty
 exg.w   d1,d3				;d3 doit tre la ycoord la +grande
\NoChgty:

 lea  hptr,a0
 sub.w   d1,d3				;d3=compteur vertical (lignes)
 mulu    #30,d1
 add.l   d1,a0				;a0 pointe sur la premire ligne

 move.w  d0,d1
 and.w   #%1111,d1
 move.w  #$FFFF,d4
 lsr.w   d1,d4				;d4=word gauche du rectangle

 move.w  d2,d1
 and.w   #%1111,d1
 eori.w  #%1111,d1
 move.w  #$FFFF,d5
 lsl.w   d1,d5				;d5=word droit du rectangle

 move.w  d4,d6				;si jamais largeur dans un word,
 and.w   d5,d6				;on combine bords gauche et droit

 lsr.w   #4,d0
 add.w   d0,a0
 add.w   d0,a0				;a0 pointe sur le premier word
 lsr.w   #4,d2
 sub.w   d0,d2				;d2=compteur horizontal (nb words pleins)
 lsl.w   #1,d2
 sub.w   #2,d2

PutLine:
 tst.w   d2
 blt     InOneWord			;si d2<0, alors le rectangle est dans un seul word
 beq     PasInt				;si d2=0, il y a juste un ct gauche et un droit
 move.w  d2,d1				;si d2>0, il y a en plus d2-1 words pleins  l'intrieur
\PutInt:
 move.w  #$FFFF,0(a0,d1)		;on remplit l'intrieur
 subq.w  #2,d1
 tst.w   d1
 bne     \PutInt
PasInt:
 or.w    d4,(a0)			;on met le bord gauche
 or.w    d5,2(a0,d2)			;et le bord droit
 bra     EndHorz
InOneWord:
 or.w    d6,(a0)			;si la largeur tient dans un word...
EndHorz:
 add.l   #30,a0
 dbra    d3,PutLine			;ligne suivante

 movem.l (a7)+,d0-d6/a0
 rts

;***************************************;

TestBounces:				;rebonds des balles
 movem.l d0-d4/a0-a2,-(a7)
 lea  ballsptr,a0
 move.w  #0,d3
TestNextBall:
 move.w  0(a0,d3),d0
 move.w  2(a0,d3),d1
 lsr.w   #6,d0
 lsr.w   #6,d1
 add.w   #4,d0
 add.w   #4,d1
 clr.w   6(a0,d3)
 clr.w   d4

 sub.w   #5,d0				;teste  gauche
 bsr     GetPixel
 tst.b   d2
 beq     NoR_L
 bsr     CheckOnLine
 add.w   #1,d4
NoR_L:
 add.w   #10,d0				;teste  droite
 bsr     GetPixel
 tst.b   d2
 beq     NoR_R
 bsr     CheckOnLine
 add.w   #2,d4
NoR_R:

 lea     bouncestab(PC),a2
 tst.b   0(a2,d4)
 bne     EndHBounces
 move.b  4(a2,d4),4(a0,d3)
EndHBounces:
 move.b  8(a2,d4),6(a0,d3)

 clr.w   d4

 sub.w   #5,d0				;teste en haut
 sub.w   #5,d1
 bsr     GetPixel
 tst.b   d2
 beq     NoR_U
 bsr     CheckOnLine
 add.w   #1,d4
NoR_U:
 add.w   #10,d1				;teste en bas
 bsr     GetPixel
 tst.b   d2
 beq     NoR_D
 bsr     CheckOnLine
 add.w   #2,d4
NoR_D:

 tst.b   0(a2,d4)
 bne     EndVBounces
 move.b  4(a2,d4),5(a0,d3)
EndVBounces:
 move.b  8(a2,d4),7(a0,d3)

 add.w   #ballsize,d3
 cmp     nbballes,d3
 bne     TestNextBall
 movem.l (a7)+,d0-d4/a0-a2
 rts

;***************************************;

;ATTENTION :
;coords des balles : 1 pixel = 64 units
;on ajoute #spd units, or 50<64 donc vitesse < 1 pixel par boucle.
;les balles vont donc moins vite que la construction des lignes.
;changer cette valeur augmente la vitesse des balles par rapport aux lignes
;donc augmente la difficulte
MoveBalls:				;dplace les balles
 movem.l d0-d1/a0,-(a7)
 lea  ballsptr,a0
 move.w  #0,d1
MoveNextBall:
 tst.b   6(a0,d1)
 bne     EndGoHorz
 cmp.b   #1,4(a0,d1)
 bne     GoLeft
 add.w   #spd,0(a0,d1)			;+spd unites
 bra     EndGoHorz
GoLeft:
 sub.w   #spd,0(a0,d1)
EndGoHorz:
 tst.b   7(a0,d1)
 bne     EndGoVert
 cmp.b   #1,5(a0,d1)
 bne     GoUp
 add.w   #spd,2(a0,d1)
 bra     EndGoVert
GoUp:
 sub.w   #spd,2(a0,d1)
EndGoVert:
 add.w   #ballsize,d1
 cmp     nbballes,d1
 bne     MoveNextBall
 movem.l (a7)+,d0-d1/a0
 rts

;***************************************;

CheckOnLine:
 btst.w  #2,flag			;si y'a pas de ligne, on va  la fin
 beq     EndCheckOnLine
 cmp     #0,line_dir			;ligne horizontale ou verticale ?
 bne     NoOnHorzLine
 cmp     line_pos1+2,d1			;on touche la ligne en construction ?
 bne     NoOnHorzLine
 cmp     line_pos1,d0
 blt     NoOnHorzLine
 cmp     line_pos2,d0
 bgt     NoOnHorzLine
 bsr     FlashScreen
 move.w  line_pos1,d0			;efface la ligne en construction
 move.w  line_pos1+2,d1
\ClrHorzLine:
 bsr     PutPixel
 add.w   #1,d0
 cmp     line_pos2,d0
 ble     \ClrHorzLine
 bclr.w  #2,flag			;on indique qu'il n'y a plus de ligne
 sub.w   #1,lives			;et on perd une vie !
 bra     EndCheckOnLine
NoOnHorzLine:
 cmp     line_pos1,d0			;on touche la ligne en construction ?
 bne     EndCheckOnLine
 cmp     line_pos1+2,d1
 blt     EndCheckOnLine
 cmp     line_pos2+2,d1
 bgt     EndCheckOnLine
 bsr     FlashScreen
 move.w  line_pos1,d0			;efface la ligne en construction
 move.w  line_pos1+2,d1
\ClrVertLine:
 bsr     PutPixel
 add.w   #1,d1
 cmp     line_pos2+2,d1
 ble     \ClrVertLine
 bclr.w  #2,flag			;on indique qu'il n'y a plus de ligne
 sub.w   #1,lives			;et on perd une vie !
EndCheckOnLine:
 tst.w   lives				;y'a encore des vies ?
 bne     PasMort			;oui=>continue
 bset.w  #4,flag			;non=>on le signale => perdu
 bset.w  #3,flag			;et fin du jeu
PasMort:
 bsr     ShowLivesLeft
 rts



FlashScreen:
 movem.l d0-d1/a0,-(a7)
 move.w  #959,d0			;inversion...
 lea     LCD_MEM,a0
\RepInv1:
 eori.l  #$FFFFFFFF,(a0)+
 dbra    d0,\RepInv1

 move.w  sync,d0			;pause...
 clr.w   sync
 move.w  #90,d1
\Invertdelay:
 cmp.w   sync,d1
 bgt     \Invertdelay
 move.w  d0,sync

 move.w  #959,d0			;normal.
 lea     LCD_MEM,a0
\RepInv2:
 eori.l  #$FFFFFFFF,(a0)+
 dbra    d0,\RepInv2
 movem.l (a7)+,d0-d1/a0
 rts

;***************************************;

XorBalls:
 movem.l d0-d3/a0-a2,-(a7)
 lea  ballsptr,a0
 move.w  #0,d3
XorNextBall:
 move.w  0(a0,d3),d0
 move.w  2(a0,d3),d1
 lsr.w   #6,d0
 lsr.w   #6,d1
 lea     ball(PC),a2			;a2 pointe sur le dessin de la balle
 lea  hptr,a1			;destination du dessin...
 lsl.w   #1,d1
 move.l  d1,d2
 lsl.w   #4,d2
 sub.w   d1,d2
 add.l   d2,a1
 move.w  d0,d1				;deplacement x en word
 lsr.w   #3,d1				;div 8
 add.l   d1,a1				;ajoute  a1
 and.w   #%111,d0			;garde bits 1-3 (0-7)
 eori.b  #%111,d0
 move.w  d0,d1
 move.w  #7,d2
\nb:
 clr.w   d0
 move.b  (a2)+,d0			;lit le dessin
 lsl.w   d1,d0
 rol.w   #8,d0				;hi(d0)<=>lo(d0)
 eor.b   d0,(a1)+			;xorput ( 1->0 et 0->1 )
 ror.w   #8,d0
 eor.b   d0,(a1)+
 add.l   #28,a1				;ligne suivante
 dbra    d2,\nb
 add.w   #ballsize,d3
 cmp     nbballes,d3
 bne     XorNextBall
 movem.l (a7)+,d0-d3/a0-a2
 rts

;***************************************;

XorCursor:
 movem.l d0-d2/a0-a1,-(a7)
 move.w  xcur,d0
 move.w  ycur,d1
 lsr.w   #6,d0
 lsr.w   #6,d1
 lsl.w   #1,d1				;calcul de l'adresse
 move.l  d1,d2
 lsl.w   #4,d2
 sub.w   d1,d2
 move.w  d0,d1
 and.w   #$FFF0,d0
 lsr.w   #3,d0
 add.w   d0,d2
 and.w   #$0F,d1
 eori.w  #%1111,d1
 lea	hptr,a1
 adda.l  d2,a1				;a1 pointe sur le bon word
 lea     cursor(PC),a0
 move.w  curtype,d0
 lsl.w   #7,d0				;d0=d0*32*4 (16 words=32 octets et 4 images de curseur)
 add.w   d0,a0
 move.w  curnum,d0
 lsl.w   #5,d0
 add.w   d0,a0
 moveq   #15,d0
\RepPut:
 clr.l   d2
 move.w  (a0)+,d2
 lsl.l   d1,d2
 eor.l   d2,(a1)			;xorput
 add.l   #30,a1
 dbra    d0,\RepPut
 movem.l (a7)+,d0-d2/a0-a1
 rts

;***************************************;

ConvStr:
 movem.l d0-d2,-(a7)
 clr.b   (a0)
RepConv:
 divu    #10,d0
 move.l  d0,d2
 swap    d2
 add.b   #48,d2
 move.b  d2,-(a0)
 subq    #1,d1
 and.l   #$FFFF,d0
 bne     RepConv
 tst.w   d1
 beq     CS_Done
 subq    #1,d1
FillOut:
 move.b  #48,-(a0)
 dbra    d1,FillOut
CS_Done:
 movem.l (a7)+,d0-d2
 rts

;***************************************;

DrawScreen:				;affiche l'cran virtuel
 movem.l d0-d1/a0-a1,-(a7)
 lea  hptr,a0
 lea     LCD_MEM+480,a1
 move.w  #839,d0
RepCopy:
 move.l  (a0)+,(a1)+
 dbra    d0,RepCopy
 movem.l (a7)+,d0-d1/a0-a1
 rts 

;***************************************;

PutPixel:
 movem.l d0-d2/a0,-(a7)
 lea  hptr,a0
 mulu    #30,d1
 add.l   d1,a0
 move.w  d0,d2
 lsr.w   #3,d0
 add.l   d0,a0
 and.w   #%111,d2
 eori.w  #%111,d2
 bchg.b  d2,(a0)
 movem.l (a7)+,d0-d2/a0
 rts


GetPixel:
 movem.l d0-d1/a0,-(a7)
 lea  hptr,a0
 mulu    #30,d1
 add.l   d1,a0
 move.w  d0,d2
 lsr.w   #3,d0
 add.l   d0,a0
 and.w   #%111,d2
 eori.w  #%111,d2
 move.b  (a0),d0
 clr.b   d1
 bset.b  d2,d1
 and.b   d1,d0
 lsr.b   d2,d0
 move.b  d0,d2
 movem.l (a7)+,d0-d1/a0
 rts

;***************************************;

InitScreenHandle:
 movem.l d0/a0-a1,-(a7)

 jsr     util::zap_screen
 move.w  #127,-(a7) ;y2			;grand cadre
 move.w  #239,-(a7) ;x2
 move.w  #0,-(a7) ;y1
 move.w  #0,-(a7) ;x1
 jsr     util::frame_rect
 lea     8(a7),a7
 move.w  #126,-(a7) ;y2			;cadre jeu
 move.w  #238,-(a7) ;x2
 move.w  #16,-(a7) ;y1
 move.w  #1,-(a7) ;x1
 jsr     util::frame_rect
 lea     8(a7),a7
 move.w  #15,-(a7) ;y2			;cadre score
 move.w  #41,-(a7) ;x2
 move.w  #1,-(a7) ;y1
 move.w  #1,-(a7) ;x1
 jsr     util::frame_rect
 lea     8(a7),a7
 move.w  #15,-(a7) ;y2			;cadre titre
 move.w  #197,-(a7) ;x2
 move.w  #1,-(a7) ;y1
 move.w  #42,-(a7) ;x1
 jsr     util::frame_rect
 lea     8(a7),a7
 move.w  #15,-(a7) ;y2			;cadre vies
 move.w  #215,-(a7) ;x2
 move.w  #1,-(a7) ;y1
 move.w  #198,-(a7) ;x1
 jsr     util::frame_rect
 lea     8(a7),a7
 move.w  #15,-(a7) ;y2			;cadre %
 move.w  #238,-(a7) ;x2
 move.w  #1,-(a7) ;y1
 move.w  #216,-(a7) ;x1
 jsr     util::frame_rect
 lea     8(a7),a7

 move.w  #$00FF,-(a7)
 clr.w	 -(a7)
 move.w  #$00FF,-(a7)			;met le '%'
 move.w  #4,-(a7)
 move.w  #5,-(a7)
 move.w  #218,-(a7)
 move.w  #37,-(a7)
 jsr     tios::DrawCharXY
 lea	 14(a7),a7

 lea  hptr,a0
 lea     LCD_MEM+480,a1
 move.w  #839,d0
\Scr2Handle
 move.l  (a1)+,(a0)+
 dbra    d0,\Scr2Handle

 movem.l (a7)+,d0/a0-a1
 rts


InitBalls:
 move.w  #maxballes-1,d1		;choisit les positions initiales des balles
 lea  ballsptr,a0
DefineNextBall:
 move.w  #220,d0
 jsr     util::random			;position x
 add.w   #2,d0
 lsl.w   #6,d0
 move.w  d0,0(a0)
 move.w  #92,d0				;position y
 jsr     util::random
 add.w   #2,d0
 lsl.w   #6,d0
 move.w  d0,2(a0)
 move.w  #2,d0				;direction horizontale
 jsr     util::random
 lsl.w   #1,d0
 sub.w   #1,d0
 move.b  d0,4(a0)
 move.w  #2,d0				;direction verticale
 jsr     util::random
 lsl.w   #1,d0
 sub.w   #1,d0
 move.b  d0,5(a0)
 clr.w   6(a0)
 lea     ballsize(a0),a0
 dbra    d1,DefineNextBall
 rts

;***************************************;
ShowActualScore:
 movem.l d0-d2/a0-a1,-(a7)
 move.l  score,d0
 moveq   #6,d1
 lea     strend(PC),a0
 bsr     ConvStr
 WriteStrA #3,#5,#4,a0
 movem.l (a7)+,d0-d2/a0-a1
 rts

ShowLivesLeft:
 movem.l d0-d2/a0-a1,-(a7)
 clr.l   d0
 move.w  lives,d0
 moveq   #2,d1
 lea     strend(PC),a0
 bsr     ConvStr
 WriteStrA #200,#5,#4,a0
 movem.l (a7)+,d0-d2/a0-a1
 rts

ShowFilled:
 movem.l d0-d2/a0-a1,-(a7)
 clr.l   d0
 move.w  fillcnt,d0
 divu    #totalcnt/100,d0
 and.l   #$FFFF,d0
 moveq   #2,d1
 lea     strend(PC),a0
 bsr     ConvStr
 WriteStrA #225,#5,#4,a0
 movem.l (a7)+,d0-d2/a0-a1
 rts
;***************************************;

ArchiveScore:
 movem.l d0-d1/a0-a2,-(a7)
 move.l  score,d0
 lea     hiscores(PC),a2
 cmp.l	 96(a2),d0
 ble     TooLow
 lea	 16(a2),a0
 moveq	 #4,d1
CheckHigher:
 cmp.l	 (a0),d0
 bgt     HigherFound
 lea	 20(a0),a0
 dbra	 d1,CheckHigher
HigherFound:
 move.w  d1,place
 lea	 100(a2),a0
 lea	 80(a2),a3
 tst.w	 d1				;dernier score ?
 beq     NoScrollDown
 mulu	 #5,d1
 subq	 #1,d1
ScrollDown:				;non=>insertion
 move.l  -(a3),-(a0)
 dbra	 d1,ScrollDown
NoScrollDown:
 move.l  d0,16(a3)			;on sauve le score
 move.w  #14,d1				;on nettoie l'emplacement pour le nom
ResetName:
 move.b  #32,0(a3,d1)
 dbra    d1,ResetName
 bsr     ShowScores			;on affiche les scores
 lea     invite(PC),a0
 WriteStrA #75,#120,#4,a0
 bsr     ReadName			;lit le nom au bon endroit et le sauve
 lea     empty(PC),a0
 WriteStrA #75,#120,#4,a0
TooLow:
 movem.l (a7)+,d0-d1/a0-a2
 rts


ReadName:
 movem.l d0-d4,-(a7)
 move.w  #61,d3 ;x
 move.w  #4,d1
 sub.w   place,d1
 lsl.w   #3,d1
 add.w   #50,d1 ;y
 move.w  #53,d0
 move.w  #18,d2
 bsr     WriteChar
 clr.w	 d4
Input:
 jsr     util::idle_loop
 cmp.w	 #13,d0
 beq     InputDone
 cmp.w	 #257,d0
 beq     BackSpace
 cmp.w   #32,d0
 bcs     Input
 cmp.w   #256,d0
 bcc     Input
 cmp.w   #15,d4
 beq     Input
 move.b  d0,(a3)+
 move.w  d0,d2
 move.w  d3,d0
 bsr     WriteChar
 addq	 #6,d3
 addq	 #1,d4
 bra     Input
BackSpace:
 tst.w   d4
 beq     Input
 clr.b   -(a3)
 subq    #6,d3
 move.w  d3,d0
 moveq   #32,d2
 bsr     WriteChar
 sub.w   #1,d4
 bra     Input
InputDone:
 tst.w   d4				;chane vide ?
 beq     Input				;il faut au moins 1 caractre=>Input
 move.w  #53,d0
 move.w  #32,d2
 bsr     WriteChar
 movem.l (a7)+,d0-d4
 rts


ShowScores:
 movem.l d0-d4/a0-a2,-(a7)
 lea	 hiscores(PC),a2
 moveq   #50,d4				;ordonne de la 1re ligne
 moveq   #4,d3
ShowNextScore:
 WriteStrA #61,d4,#4,a2
 lea     strend(PC),a0
 move.l  16(a2),d0
 moveq   #6,d1
 bsr     ConvStr
 WriteStrA #155,d4,#4,a0
 lea     20(a2),a2
 add.l   #8,d4
 dbra    d3,ShowNextScore
 SetFont #1
 movem.l (a7)+,d0-d4/a0-a2
 rts


WriteChar:
 movem.l d0-d2/a0,-(a7)
 move.w  #$00FF,-(a7)
 clr.w	 -(a7)
 move.w  #$00FF,-(a7)
 move.w  #4,-(a7)
 move.w  d1,-(a7)
 move.w  d0,-(a7)
 move.w  d2,-(a7)
 jsr     tios::DrawCharXY
 lea	 14(a7),a7
 movem.l (a7)+,d0-d2/a0
 rts
;******* Nouvelle interruption #1 ******;
newint#1:
 add.w   #1,sync			;compteur pour synchro (ti de vitesses diffrentes)
 rte
;*********** Variables *****************;
oldint#1 dc.l 0				;adresse de l'ex-interruption
score    dc.l 0
sync     dc.w 0
curtype  dc.w 0 			;0=horz 1=vert
curnum   dc.w 0
curcount dc.w 0
xcur     dc.w 0
ycur     dc.w 0
place    dc.w 0
level    dc.w 1
lives    dc.w 0
fillcnt  dc.w 0				;surface remplie (en pixels)
flag     dc.w 0				;bit 0  1 : F5 appuye
					;bit 1  1 : F1 appuye
					;bit 2  1 : mur en construction 
					;            (pas de curseur donc)
                                        ;bit 3  1 : surface ncessaire remplie ou esc
                                        ;bit 4  1 : perdu (plus de vies ou esc)

line_dir  dc.w 0			;direction de la ligne : 0=h 1=v
line_pos1 dc.w 0,0			;1er coin (haut ou gauche)
line_pos2 dc.w 0,0			;2me
rect      dc.w 0,0,0,0			;coord du rectangle dfini

nbballes  dc.w 0			;nombre de balles * ballsize
;STRUCTURE d'une balle (stocke dans handle ballshptr)
;*maxballes:
;+00 1w x				;abscisse : 64 units=1 pixel
;+02 1w y
;+04 1b dir_x
;+05 1b dir_y
;+06 1b					;pour savoir s'il faut avancer ou non
;+07 1b					;pareil verticalement

str      ds.b 16			;utilise pour les conversions nombres=>string
strend
keystat  ds.b 10			;matrice du clavier

hiscores:
 dc.b "...            ",0,0,0,0,0
 dc.b "...            ",0,0,0,0,0
 dc.b "...            ",0,0,0,0,0
 dc.b "...            ",0,0,0,0,0
 dc.b "...            ",0,0,0,0,0

;************** Donnes ****************;
bouncestab:
 dc.b 1,0,0,1
 dc.b 0,1,-1,0
 dc.b 0,0,0,1

windialog dc.l $00340039,$00BC0057,$0008000A,wintxt,0
losedialog dc.l $004C0039,$00A40057,$0008000A,losetxt,0
donedialog dc.l $00300039,$00C00057,$0008000A,donetxt,0

cursor:
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0001000000001000
 dc.w %0011000000001100
 dc.w %0111111111111110
 dc.w %0011000000001100
 dc.w %0001000000001000
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000000000000

 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000010000100000
 dc.w %0000110000110000
 dc.w %0001111111111000
 dc.w %0000110000110000
 dc.w %0000010000100000
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000000000000

 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000110000000
 dc.w %0000001111000000
 dc.w %0000011111100000
 dc.w %0000001111000000
 dc.w %0000000110000000
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000000000000

 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000010000100000
 dc.w %0000110000110000
 dc.w %0001111111111000
 dc.w %0000110000110000
 dc.w %0000010000100000
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000000000000

 dc.w %0000000000000000
 dc.w %0000000100000000
 dc.w %0000001110000000
 dc.w %0000011111000000
 dc.w %0000000100000000
 dc.w %0000000100000000
 dc.w %0000000100000000
 dc.w %0000000100000000
 dc.w %0000000100000000
 dc.w %0000000100000000
 dc.w %0000000100000000
 dc.w %0000000100000000
 dc.w %0000011111000000
 dc.w %0000001110000000
 dc.w %0000000100000000
 dc.w %0000000000000000

 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000100000000
 dc.w %0000001110000000
 dc.w %0000011111000000
 dc.w %0000000100000000
 dc.w %0000000100000000
 dc.w %0000000100000000
 dc.w %0000000100000000
 dc.w %0000011111000000
 dc.w %0000001110000000
 dc.w %0000000100000000
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000000000000

 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000100000000
 dc.w %0000001110000000
 dc.w %0000011111000000
 dc.w %0000011111000000
 dc.w %0000001110000000
 dc.w %0000000100000000
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000000000000

 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000100000000
 dc.w %0000001110000000
 dc.w %0000011111000000
 dc.w %0000000100000000
 dc.w %0000000100000000
 dc.w %0000000100000000
 dc.w %0000000100000000
 dc.w %0000011111000000
 dc.w %0000001110000000
 dc.w %0000000100000000
 dc.w %0000000000000000
 dc.w %0000000000000000
 dc.w %0000000000000000


ball:
 dc.b %00111100
 dc.b %01000110
 dc.b %10011111
 dc.b %10111111
 dc.b %10111111
 dc.b %11111111
 dc.b %01111110
 dc.b %00111100

wintxt dc.b "LEVEL COMPLETED",0
losetxt dc.b "GAME OVER",0
donetxt dc.b "THAT'S ALL FOLKS",0
invite dc.b "ENTER YOUR NAME",0
empty dc.b "               ",0
_comment: dc.b "v1.7 by Thomas FERNIQUE ",169,"1998",0

	BSS

hptr ds.b 3360
ballsptr ds.b 80


;************* End of Fargo program ***************
 end