**** This program converted from Z80 to 68K by Source Guru 0.6
EXACT_STACK equ 1
        INCLUDE "sim-ti85.h"
**** Original Line:  ; *************** Galaxian - Copyright 1998 by Patrick Davidson ************
**** Original Line: 
**** Original Line:          .include "usgard.h"
**** Original Line: ;
**** Original Line: ;                    
**** Original Line: ;                                      
**** Original Line: ;                           
**** Original Line: ;                                    
**** Original Line: ;                       
**** Original Line: ;               Usgard (C) 1997 by      Andreas Ess,
**** Original Line: ;                                       Sam Davies,
**** Original Line: ;                                       Jimmy Mrdell,
**** Original Line: ;                                       Austin Butler &
**** Original Line: ;                                       Mel Tsai
**** Original Line: ;
**** Original Line: ;
**** Original Line: ;
**** Original Line: ;Just recompile your program with #include "usgard.h" instead of "ti-85.h"!
**** Original Line: ;
**** Original Line: 
**** Original Line: ;
**** Original Line: ;CALL's, ROM_CALL's
**** Original Line: ;Note: in Usgard, you can use a normal call instead of ROM_CALL(
**** Original Line: ; Example: write call D_ZM_STR instead of ROM_CALL(D_ZM_STR)
**** Original Line: ;RCALL ensures a 'safe' return when program has moved
**** Original Line: ;
**** Original Line: #DEFINE CALL_Z(addr)            call $8C0C \ .dw addr
**** Original Line: #DEFINE CALL_(addr)             call $8C0F \ .dw addr
**** Original Line: #DEFINE CALL_NZ(addr)           call $8C12 \ .dw addr
**** Original Line: #DEFINE CALL_C(addr)            call $8C18 \ .dw addr
**** Original Line: #DEFINE CALL_NC(addr)           call $8C1E \ .dw addr
**** Original Line: #DEFINE JUMP_Z(addr)            call $8C24 \ .dw addr
**** Original Line: #DEFINE JUMP_(addr)             call $8C27 \ .dw addr
**** Original Line: #DEFINE JUMP_NZ(addr)           call $8C2A \ .dw addr
**** Original Line: #DEFINE JUMP_C(addr)            call $8C30 \ .dw addr
**** Original Line: #DEFINE JUMP_NC(addr)           call $8C36 \ .dw addr
**** Original Line: #DEFINE ROM_CALL(addr)          call addr
**** Original Line: #DEFINE ROM_CALL_C(addr)        call c, addr
**** Original Line: #DEFINE ROM_CALL_NC(addr)       call nc, addr
**** Original Line: #DEFINE ROM_CALL_Z(addr)        call z, addr
**** Original Line: #DEFINE ROM_CALL_NZ(addr)       call nz, addr
**** Original Line: #DEFINE RCALL_(addr)            call $8CC8 \ .dw addr
**** Original Line: 
**** Original Line: ;
**** Original Line: ; Data Locations within Usgard
**** Original Line: ;
**** Original Line: PROGRAM_ADDR    =$8C3C  ; program address
PROGRAM_ADDR    equ     $8C3C  
**** Original Line: ROM_VERS        =$8C3E  ; ROM version byte:
ROM_VERS    equ     $8C3E  
**** Original Line: 			;  57h: 3.0A
**** Original Line: 			;  8Eh: 4.0
**** Original Line: 			;  5Eh: 5.0
**** Original Line: 			;  3Dh: 6.0
**** Original Line: 			;  97h: 8.0
**** Original Line: 			;  91h: 9.0
**** Original Line: 			;  35h: 10.0
**** Original Line: USG_VER         =$8C3F  ; Usgard version number ($20=1.0 lite, $21=1.0 std)
USG_VER    equ     $8C3F  
**** Original Line: USG_BITS        =$8C40  ; bit 0 set: program has been modified (not nec.)
USG_BITS    equ     $8C40  
**** Original Line: 			; bit 1 set: warp out (must be done by the shell)
**** Original Line: ZS_BITS         =$8C40
ZS_BITS    equ     $8C40
**** Original Line: ORGSP           =$8E8B  ; original SP(needed for OTH_EXIT)
ORGSP    equ     $8E8B  
**** Original Line: USGSHELL        =$8EA2  ; name of shell, zero-terminated, 9 bytes
USGSHELL    equ     $8EA2  
**** Original Line: VATName         =$8EAB  ; name of the current VAT entry
VATName    equ     $8EAB  
**** Original Line: 
**** Original Line: DEST_ADDR       =$8EB4  ; destination of video routines (e.g. VIDEO_MEM)
DEST_ADDR    equ     $8EB4  
**** Original Line: PAGE1ADDR       =$8EB4  ; DEST_ADDR is also used as first grayscale layer
PAGE1ADDR    equ     $8EB4  
**** Original Line: PAGE2ADDR       =$8EB6  ; second grayscale layer
PAGE2ADDR    equ     $8EB6  
**** Original Line: 
**** Original Line: PROG_HEADER     =$F9    ; Usgard 1.1 program's header
PROG_HEADER    equ     $F9    
**** Original Line: 
**** Original Line: ;
**** Original Line: ; The ROM_CALL parameters supported by ZShell
**** Original Line: ;
**** Original Line: LD_HL_MHL       =$0033  ; HL=(HL), A=L
LD_HL_MHL    equ     $0033  
**** Original Line: CP_HL_DE        =$008E  ; CP HL,DE (modifies flags only)
CP_HL_DE    equ     $008E  
**** Original Line: UNPACK_HL       =$009A  ; unpacks one digit of HL into %A
UNPACK_HL    equ     $009A  
**** Original Line: READ_KEYPAD     =$01A2  ; read the keypad port(A=key group mask->A=B=key press data)
READ_KEYPAD    equ     $01A2  
**** Original Line: STORE_KEY       =$01B1  ; store immediate keystroke from %A
STORE_KEY    equ     $01B1  
**** Original Line: GET_KEY         =$01BE  ; get immediate keystroke into %A
GET_KEY    equ     $01BE  
**** Original Line: UPDATE_APD      =$0115  ; set APD to 5 minutes again.
UPDATE_APD    equ     $0115  
**** Original Line: 
**** Original Line: TX_CHARPUT      =$8C41  ; xlated display of %A on screen, normal text style
TX_CHARPUT    equ     $8C41  
**** Original Line: D_LT_STR        =$8C44  ; display length-byte string
D_LT_STR    equ     $8C44  
**** Original Line: M_CHARPUT       =$8C47  ; display %A on screen, menu style
M_CHARPUT    equ     $8C47  
**** Original Line: D_ZM_STR        =$8C4A  ; display zero-terminated string,  menu style
D_ZM_STR    equ     $8C4A  
**** Original Line: D_LM_STR        =$8C4D  ; display length-byte string, menu style
D_LM_STR    equ     $8C4D  
**** Original Line: SCROLL_UP       =$8C50  ; scroll text screen up
SCROLL_UP    equ     $8C50  
**** Original Line: TR_CHARPUT      =$8C53  ; raw display of %A on screen, normal text style
TR_CHARPUT    equ     $8C53  
**** Original Line: CLEARLCD        =$8C56  ; clear LCD, but not text or graphics memory
CLEARLCD    equ     $8C56  
**** Original Line: D_HL_DECI       =$8C59  ; disp. HL as 5-byte, right just., blank-pad. decimal
D_HL_DECI    equ     $8C59  
**** Original Line: CLEARTEXT       =$8C5C  ; clear LCD and text memory (affected by 1,(IY+13))
CLEARTEXT    equ     $8C5C  
**** Original Line: D_ZT_STR        =$8C5F  ; display zero-terminated normal text string
D_ZT_STR    equ     $8C5F  
**** Original Line: BUSY_OFF        =$8C62  ; turn off "busy" indicataor
BUSY_OFF    equ     $8C62  
**** Original Line: BUSY_ON         =$8C65  ; turn on "busy" indicator
BUSY_ON    equ     $8C65  
**** Original Line: RANDOM          =$8C68  ; return random number in A
RANDOM    equ     $8C68  
**** Original Line: FIND_PIXEL      =$8C6B  ; Find location in RAM for a pixel on the GFX screen
FIND_PIXEL    equ     $8C6B  
**** Original Line: 
**** Original Line: FREEMEM         =$8C77  ; HL = free RAM on TI
FREEMEM    equ     $8C77  
**** Original Line: VAR_LENGTH      =$8C7A  ; DE = length of variable data at HL
VAR_LENGTH    equ     $8C7A  
**** Original Line: ASCIIZ_LEN      =$8C7D  ; get length of asciiz string
ASCIIZ_LEN    equ     $8C7D  
**** Original Line: NEG_BC          =$8C80  ; negate BC: HL = BC = -BC
NEG_BC    equ     $8C80  
**** Original Line: MUL_HL          =$8C83  ; HL = H * L
MUL_HL    equ     $8C83  
**** Original Line: 
**** Original Line: ;
**** Original Line: ;The new Usgard functions(15!)
**** Original Line: ;
**** Original Line: ;Interrupt functions
**** Original Line: INT_INSTALL     =$8C9B  ; installs an interrupt. HL = interrupt routine
INT_INSTALL    equ     $8C9B  
**** Original Line: INT_REMOVE      =$8C9E  ; removes the last interrupt routine installed
INT_REMOVE    equ     $8C9E  
**** Original Line: INT_CLEAN       =$8CA1  ; remove all installed interrupts (except TSRs)
INT_CLEAN    equ     $8CA1  
**** Original Line: 
**** Original Line: ;Append functions
**** Original Line: APPEND          =$8C95  ; Appends BC bytes from HL to end of Usgard string
APPEND    equ     $8C95  
**** Original Line: UNAPPEND        =$8C98  ; Removes the last BC bytes from Usgard string
UNAPPEND    equ     $8C98  
**** Original Line: CHECK_APPEND    =$8CCB  ; Check if code at HL, size BC, has been appended
CHECK_APPEND    equ     $8CCB  
**** Original Line: 
**** Original Line: ;Var & Mem functions
**** Original Line: VAR_NEW         =$8CA4  ; generates a var.(HL = name, A = type, BC = size)
VAR_NEW    equ     $8CA4  
**** Original Line: VAR_DELETE      =$8CA7  ; deletes a var(name = HL)
VAR_DELETE    equ     $8CA7  
**** Original Line: VAR_EXEC        =$8CAA  ; execute a variable(name = HL)
VAR_EXEC    equ     $8CAA  
**** Original Line: VAR_GET         =$8CAD  ; gets a var(name = HL; DE = VAT, HL = data)
VAR_GET    equ     $8CAD  
**** Original Line: VAR_RESIZE      =$8CB0  ; resizes a var, HL = name, BC = new size.
VAR_RESIZE    equ     $8CB0  
**** Original Line: 
**** Original Line: ;Relocate functions
**** Original Line: RELOC           =$8CCE  ; relocate var (HL = name)
RELOC    equ     $8CCE  
**** Original Line: DERELOC         =$8CD1  ; derelocate var (HL = name)
DERELOC    equ     $8CD1  
**** Original Line: 
**** Original Line: ;Other functions
**** Original Line: SEARCH_VAT      =$8CB3  ; search for file %A at VAT addr %HL, returns:
SEARCH_VAT    equ     $8CB3  
**** Original Line: 			; DE = data area, HL updated, carry if end of vat
**** Original Line: 			; check VATName for the name of the VAT entry
**** Original Line: OTH_SHUTDOWN    =$8CB6  ; shutdown the calc.
OTH_SHUTDOWN    equ     $8CB6  
**** Original Line: DM_HL_DECI      =$8CB9  ; display HL in menu style, right justified.
DM_HL_DECI    equ     $8CB9  
**** Original Line: OTH_PAUSE       =$8CBC  ; wait until Enter pressed
OTH_PAUSE    equ     $8CBC  
**** Original Line: OTH_CLEAR       =$8CBF  ; zero BC-1 bytes from HL
OTH_CLEAR    equ     $8CBF  
**** Original Line: OTH_EXIT        =$8CC2  ; exit to Usgard, no need for pops!
OTH_EXIT    equ     $8CC2  
**** Original Line: OTH_ARROW       =$8CC5  ; get arrow keys, 2nd, EXIT and MORE(multi-key)
OTH_ARROW    equ     $8CC5  
**** Original Line: 
**** Original Line: ;
**** Original Line: ; Data Locations
**** Original Line: ;
**** Original Line: KEY_0           =$8000  ; translated scancode of last key, but 0 if gotten
KEY_0    equ     $8000  
**** Original Line: KEY_1           =$8001  ; translated scancode of key down now
KEY_1    equ     $8001  
**** Original Line: KEY_2           =$8002  ; same as 8001, but $FF if more than one key is down
KEY_2    equ     $8002  
**** Original Line: KEY_STAT        =$8004  ; bit 2 set = key down now
KEY_STAT    equ     $8004  
**** Original Line: LAST_KEY        =$8006  ; last key pressed
LAST_KEY    equ     $8006  
**** Original Line: CONTRAST        =$8007  ; contrast
CONTRAST    equ     $8007  
**** Original Line: CURSOR_ROW      =$800C  ; text cursor row
CURSOR_ROW    equ     $800C  
**** Original Line: CURSOR_COL      =$800D  ; text cursor column
CURSOR_COL    equ     $800D  
**** Original Line: CURSOR_LET      =$800E  ; letter under text cursor
CURSOR_LET    equ     $800E  
**** Original Line: BUSY_COUNTER    =$8080  ; counter for busy indicator
BUSY_COUNTER    equ     $8080  
**** Original Line: BUSY_BITMAP     =$8081  ; bitmap for busy indicator
BUSY_BITMAP    equ     $8081  
**** Original Line: OP1             =$8082  ; OP1 'register'(var type, length, name, 11 bytes)
OP1    equ     $8082  
**** Original Line: OP2             =$808D  ; OP2 'register'(var type, length, name, 11 bytes)
OP2    equ     $808D  
**** Original Line: OP3             =$8098  ; OP3 'register'(var type, length, name, 11 bytes)
OP3    equ     $8098  
**** Original Line: OP4             =$80A3  ; OP4 'register'(var type, length, name, 11 bytes)
OP4    equ     $80A3  
**** Original Line: OP5             =$80AE  ; OP5 'register'(var type, length, name, 11 bytes)
OP5    equ     $80AE  
**** Original Line: OP6             =$80B9  ; OP6 'register'(var type, length, name, 11 bytes)
OP6    equ     $80B9  
**** Original Line: CURR_INPUT      =$80C6  ; -> current home-screen input
CURR_INPUT    equ     $80C6  
**** Original Line: BYTES_USED      =$80CC  ; # of used user memory (+$80C8 = first free byte)
BYTES_USED    equ     $80CC  
**** Original Line: TEXT_MEM        =$80DF  ; text memory
TEXT_MEM    equ     $80DF  
**** Original Line: CURSOR_ROW2     =$800C  ; text cursor row
CURSOR_ROW2    equ     $800C  
**** Original Line: CURSOR_COL2     =$800D  ; text cursor column
CURSOR_COL2    equ     $800D  
**** Original Line: DELC_LEN        =$800F  ; DelChar buffer length (max. 100)
DELC_LEN    equ     $800F  
**** Original Line: DELC            =$8010  ; DelChar buffer(100 bytes)
DELC    equ     $8010  
**** Original Line: CHECKSUM        =$81BE  ; memory checksum from 8BF7 to FA6F
CHECKSUM    equ     $81BE  
**** Original Line: TEMP_STORAGE    =$827C  ; 128 bytes temporary storage
TEMP_STORAGE    equ     $827C  
**** Original Line: CURSOR_X        =$8333  ; x value of cursor
CURSOR_X    equ     $8333  
**** Original Line: CURSOR_Y        =$8334  ; y value of cursor
CURSOR_Y    equ     $8334  
**** Original Line: _IY_TABLE       =$8346  ; where IY usually points
_IY_TABLE    equ     $8346  
**** Original Line: GRAPH_MEM       =$8641  ; graphics memory
GRAPH_MEM    equ     $8641  
**** Original Line: TEXT_MEM2       =$8A6B  ; secondary text memory
TEXT_MEM2    equ     $8A6B  
**** Original Line: USER_MEM        =$8B1B  ; -> start of user memory
USER_MEM    equ     $8B1B  
**** Original Line: FIXED_POINT     =$8B3A  ; fixed-point decimal place (FFh for floating point)
FIXED_POINT    equ     $8B3A  
**** Original Line: FIRST_FREE      =$8BE1  ; first free byte in memory
FIRST_FREE    equ     $8BE1  
**** Original Line: VAT_END         =$8BEB  ; -> one byte before end of VAT (backwards)
VAT_END    equ     $8BEB  
**** Original Line: VAT_START       =$FA6F  ; start of VAT
VAT_START    equ     $FA6F  
**** Original Line: VIDEO_MEM       =$FC00  ; video memory
VIDEO_MEM    equ     $FC00  
**** Original Line: 
**** Original Line: 
**** Original Line: ;
**** Original Line: ; Key Scancode definitions
**** Original Line: ;
**** Original Line: ;                     Function                Character
**** Original Line: K_NOKEY       =$00    ;No key
K_NOKEY    equ     $00    
**** Original Line: K_DOWN        =$01    ;Down
K_DOWN    equ     $01    
**** Original Line: K_LEFT        =$02    ;Left
K_LEFT    equ     $02    
**** Original Line: K_RIGHT       =$03    ;Right
K_RIGHT    equ     $03    
**** Original Line: K_UP          =$04    ;Up
K_UP    equ     $04    
**** Original Line: K_ENTER       =$09    ;Enter
K_ENTER    equ     $09    
**** Original Line: K_PLUS        =$0A    ;+                      X
K_PLUS    equ     $0A    
**** Original Line: K_MINUS       =$0B    ;-                      T
K_MINUS    equ     $0B    
**** Original Line: K_STAR        =$0C    ;*                      O
K_STAR    equ     $0C    
**** Original Line: K_SLASH       =$0D    ;/                      J
K_SLASH    equ     $0D    
**** Original Line: K_RAISE       =$0E    ;^                      E
K_RAISE    equ     $0E    
**** Original Line: K_CLEAR       =$0F    ;Clear
K_CLEAR    equ     $0F    
**** Original Line: K_SIGN        =$11    ;(-)                    Space
K_SIGN    equ     $11    
**** Original Line: K_3           =$12    ;3                      W
K_3    equ     $12    
**** Original Line: K_6           =$13    ;6                      S
K_6    equ     $13    
**** Original Line: K_9           =$14    ;9                      N
K_9    equ     $14    
**** Original Line: K_RIGHTPAR    =$15    ;)                      I
K_RIGHTPAR    equ     $15    
**** Original Line: K_TAN         =$16    ;Tan                    D
K_TAN    equ     $16    
**** Original Line: K_CUSTOM      =$17    ;Custom
K_CUSTOM    equ     $17    
**** Original Line: K_DOT         =$19    ;.                      Z
K_DOT    equ     $19    
**** Original Line: K_2           =$1A    ;2                      V
K_2    equ     $1A    
**** Original Line: K_5           =$1B    ;5                      R
K_5    equ     $1B    
**** Original Line: K_8           =$1C    ;8                      M
K_8    equ     $1C    
**** Original Line: K_LEFTPAR     =$1D    ;(                      H
K_LEFTPAR    equ     $1D    
**** Original Line: K_COS         =$1E    ;Cos                    C
K_COS    equ     $1E    
**** Original Line: K_PRGM        =$1F    ;Prgm
K_PRGM    equ     $1F    
**** Original Line: K_DEL         =$20    ;Del
K_DEL    equ     $20    
**** Original Line: K_0           =$21    ;0                      Y
K_0    equ     $21    
**** Original Line: K_1           =$22    ;1                      U
K_1    equ     $22    
**** Original Line: K_4           =$23    ;4                      Q
K_4    equ     $23    
**** Original Line: K_7           =$24    ;7                      L
K_7    equ     $24    
**** Original Line: K_EE          =$25    ;EE                     G
K_EE    equ     $25    
**** Original Line: K_SIN         =$26    ;Sin                    B
K_SIN    equ     $26    
**** Original Line: K_STAT        =$27    ;Stat
K_STAT    equ     $27    
**** Original Line: K_XVAR        =$28    ;x-Var                  x
K_XVAR    equ     $28    
**** Original Line: K_ON          =$29    ;On
K_ON    equ     $29    
**** Original Line: K_STO         =$2A    ;Sto                    =
K_STO    equ     $2A    
**** Original Line: K_COMMA       =$2B    ;,                      P
K_COMMA    equ     $2B    
**** Original Line: K_SQUARE      =$2C    ;x^2                    K
K_SQUARE    equ     $2C    
**** Original Line: K_LN          =$2D    ;Ln                     F
K_LN    equ     $2D    
**** Original Line: K_LOG         =$2E    ;Log                    A
K_LOG    equ     $2E    
**** Original Line: K_GRAPH       =$2F    ;Graph
K_GRAPH    equ     $2F    
**** Original Line: K_ALPHA       =$30    ;Alpha
K_ALPHA    equ     $30    
**** Original Line: K_F5          =$31    ;F5
K_F5    equ     $31    
**** Original Line: K_F4          =$32    ;F4
K_F4    equ     $32    
**** Original Line: K_F3          =$33    ;F3
K_F3    equ     $33    
**** Original Line: K_F2          =$34    ;F2
K_F2    equ     $34    
**** Original Line: K_F1          =$35    ;F1
K_F1    equ     $35    
**** Original Line: K_SECOND      =$36    ;2nd
K_SECOND    equ     $36    
**** Original Line: K_EXIT        =$37    ;EXIT
K_EXIT    equ     $37    
**** Original Line: K_MORE        =$38    ;MORE
K_MORE    equ     $38    
**** Original Line: 
**** Original Line: 
**** Original Line: ;
**** Original Line: ;Bits for OTH_ARROW:
**** Original Line: ;
**** Original Line: DOWN  = 0
DOWN    equ      0
**** Original Line: LEFT  = 1
LEFT    equ      1
**** Original Line: RIGHT = 2
RIGHT    equ      2
**** Original Line: UP  = 3
UP    equ      3
**** Original Line: F1  = 4
F1    equ      4
**** Original Line: SECOND  = 5
SECOND    equ      5
**** Original Line: EXIT  = 6
EXIT    equ      6
**** Original Line: MORE  = 7
MORE    equ      7
**** Original Line:          .org     0
**** Original Line:          .db      "Galaxian 3.0 by Patrick D",0
        dc.b    "Galaxian 3.0 by Patrick D"
        dc.b    0
**** Original Line: 
**** Original Line:  ; *************** Variables ************************************************
**** Original Line: 
**** Original Line: score             =TEXT_MEM
score    equ     TEXT_MEM
**** Original Line: lives             =TEXT_MEM+2
lives    equ     TEXT_MEM+2
**** Original Line: level             =TEXT_MEM+4
level    equ     TEXT_MEM+4
**** Original Line: x                 =TEXT_MEM+6
x    equ     TEXT_MEM+6
**** Original Line: y                 =TEXT_MEM+7
y    equ     TEXT_MEM+7
**** Original Line: lasers            =TEXT_MEM+8
lasers    equ     TEXT_MEM+8
**** Original Line: ybullets          =TEXT_MEM+9
ybullets    equ     TEXT_MEM+9
**** Original Line: ebuls             =TEXT_MEM+39
ebuls    equ     TEXT_MEM+39
**** Original Line: enemies           =TEXT_MEM+69
enemies    equ     TEXT_MEM+69
**** Original Line: boss_status       =TEXT_MEM+149
boss_status    equ     TEXT_MEM+149
**** Original Line: boss_pwr          =TEXT_MEM+150
boss_pwr    equ     TEXT_MEM+150
**** Original Line: boss_x            =TEXT_MEM+151
boss_x    equ     TEXT_MEM+151
**** Original Line: boss_y            =TEXT_MEM+152
boss_y    equ     TEXT_MEM+152
**** Original Line: boss_2bytes       =TEXT_MEM+154
boss_2bytes    equ     TEXT_MEM+154
**** Original Line: timer             =TEXT_MEM+155
timer    equ     TEXT_MEM+155
**** Original Line: your_status       =TEXT_MEM+156
your_status    equ     TEXT_MEM+156
**** Original Line: enemies_remaining =TEXT_MEM+157
enemies_remaining    equ     TEXT_MEM+157
**** Original Line: storage_length    =158
storage_length    equ     158
**** Original Line: 
**** Original Line:  ; *************** Level Data ***********************************************
**** Original Line: 
**** Original Line: enemy_coords      =DELC_LEN+1
enemy_coords    equ     DELC_LEN+1
**** Original Line: enemy_image       =DELC_LEN+41
enemy_image    equ     DELC_LEN+41
**** Original Line: boss_image        =DELC_LEN+43
boss_image    equ     DELC_LEN+43
**** Original Line: enemy_pwr         =DELC_LEN+45
enemy_pwr    equ     DELC_LEN+45
**** Original Line: 
**** Original Line:  ; *************** Temporary Variables **************************************
**** Original Line: 
**** Original Line: temp1             =DELC_LEN+80
temp1    equ     DELC_LEN+80
**** Original Line: temp              =DELC_LEN+82
temp    equ     DELC_LEN+82
**** Original Line: next_type         =DELC_LEN+84
next_type    equ     DELC_LEN+84
**** Original Line: jpf1              =DELC_LEN+85
jpf1    equ     DELC_LEN+85
**** Original Line: jpf2              =DELC_LEN+86
jpf2    equ     DELC_LEN+86
**** Original Line: contrst           =DELC_LEN+87
contrst    equ     DELC_LEN+87
**** Original Line: 
**** Original Line:  ; *************** Initialize Control Flags *********************************
**** Original Line: 
**** Original Line: init:    
        __LABEL init
**** Original Line:          ld       hl,DELC_LEN
        move.w  #DELC_LEN+0,d4
        lea     DELC_LEN-$10000(a0),a4
**** Original Line:          xor      a
        eor.b   d7,d7
**** Original Line:          ld       (hl),a
        ;__ADDR 4
        move.b  d7,(a4)
**** Original Line:          set      0,(iy+3)
        __ADDR  6
        bset    #0,3(a6)
**** Original Line:          ld       (iy+13),0
        ;__ADDR 6
        move.b  #0,13(a6)
**** Original Line:          inc      a
        addq.b  #1,d7
**** Original Line:          ld       (USG_BITS),a
        move.b  d7,USG_BITS-$10000(a0)
**** Original Line: 
**** Original Line:          ld       a,(CONTRAST)
        move.b  CONTRAST-$10000(a0),d7
**** Original Line:          cp       $1f
        cmp.b   #$1f,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,no_inc1
        beq   RA_no_inc1
**** Original Line:          inc      a
        addq.b  #1,d7
**** Original Line: no_inc1: cp       $1f
        __LABEL no_inc1
        cmp.b   #$1f,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,no_inc2
        beq   RA_no_inc2
**** Original Line:          inc      a
        addq.b  #1,d7
        move.w  sr,(a0)
**** Original Line: no_inc2: out      (2),a
        __LABEL no_inc2
        move.b  #2,d1
        jsr     ti85lib3@0007
**** Original Line:          ld       (contrst),a
        move.b  d7,contrst-$10000(a0)
**** Original Line: 
**** Original Line:  ; *************** Main Loop ************************************************
**** Original Line: 
**** Original Line:          ld       de,&title_message
        move.w  #title_message+0,d3
**** Original Line:          ld       hl,&title_menu
        move.w  #title_menu+0,d4
**** Original Line:          call     &display_info_screen
        __JSR   RA_display_info_screen
**** Original Line: 
**** Original Line: main_loop:
        __LABEL main_loop
**** Original Line:          call     GET_KEY
        jsr     ti85lib3@0006
**** Original Line: 
**** Original Line:          cp       K_EXIT
        cmp.b   #K_EXIT,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,exit_game
        beq   RA_exit_game
**** Original Line:          cp       K_CLEAR
        cmp.b   #K_CLEAR,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,exit_game
        beq   RA_exit_game
**** Original Line:          cp       K_F1
        cmp.b   #K_F1,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,inst
        beq   RA_inst
**** Original Line: 
**** Original Line:          cp       K_ENTER
        cmp.b   #K_ENTER,d7
        move.w  sr,(a0)
**** Original Line:          jr       nz,main_loop
        bne   RA_main_loop
**** Original Line:          call     &play_game
        __JSR   RA_play_game
**** Original Line:          jr       game_over
        bra     RA_game_over
**** Original Line: 
**** Original Line: inst:
        __LABEL inst
**** Original Line:          ld       de,&igc
        move.w  #igc+0,d3
**** Original Line:          ld       hl,&instructions
        move.w  #instructions+0,d4
**** Original Line:          call     &display_info_screen
        __JSR   RA_display_info_screen
**** Original Line:          jr       main_loop
        bra     RA_main_loop
**** Original Line: 
**** Original Line:  ; *************** Exit The Game ********************************************
**** Original Line: 
**** Original Line: exit_game:
        __LABEL exit_game
**** Original Line:          ld       a,(CONTRAST)
        move.b  CONTRAST-$10000(a0),d7
**** Original Line:          out      (2),a
        move.b  #2,d1
        jsr     ti85lib3@0007
**** Original Line:          jp       OTH_EXIT
        jsr     ti85lib3@0012
        __RTS
**** Original Line: 
**** Original Line:  ; **************** High-Score Handling *************************************
**** Original Line: 
**** Original Line: game_over:                                   ;Set up score page
        __LABEL game_over
**** Original Line:          ld       hl,(&lowest)               ;See if ya got a hi-score
        move.b  1+lowest+0-$10000(a0),d4
        asl.w   #8,d4
        move.b  lowest+0-$10000(a0),d4
**** Original Line:          ld       de,(score)
        move.b  1+score-$10000(a0),d3
        asl.w   #8,d3
        move.b  score-$10000(a0),d3
**** Original Line:          call     CP_HL_DE
        jsr     ti85lib3@0010
**** Original Line:          jp       nc,&display_scores
        move.b  (a0),ccr
        bcc   RA_display_scores
**** Original Line:          call     CLEARLCD
        jsr     ti85lib3@0002
**** Original Line:          ld       ($800c),de
        move.w  d3,d0
        lsr.w   #8,d0
        move.b  d3,$800c-$10000(a0)
        move.b  d0,1+$800c-$10000(a0)
**** Original Line:          ld       hl,&hi_score_str
        move.w  #hi_score_str+0,d4
**** Original Line:          call     D_ZT_STR
        jsr     ti85lib3@0005
**** Original Line:          ld       hl,&lowest+2
        move.w  #lowest+2+0,d4
**** Original Line:          ld       (temp),hl
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,temp-$10000(a0)
        move.b  d0,1+temp-$10000(a0)
**** Original Line:          ld       b,16
        and.w   #$ff,d2
        or.w    #(16)<<8,d2
**** Original Line: space_loop:
        __LABEL space_loop
**** Original Line:          ld       (hl),32
        __ADDR  4
        move.b  #32,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          djnz     space_loop
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_space_loop
**** Original Line:          ld       ix,(temp)
        move.b  1+temp-$10000(a0),d5
        asl.w   #8,d5
        move.b  temp-$10000(a0),d5
**** Original Line:          ld       b,0
        and.w   #$ff,d2
**** Original Line: enter_name_loop:
        __LABEL enter_name_loop
**** Original Line:          call     GET_KEY
        jsr     ti85lib3@0006
**** Original Line:          or       a
        or.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,enter_name_loop
        beq   RA_enter_name_loop
**** Original Line:          cp       K_DEL
        cmp.b   #K_DEL,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,backup
        beq   RA_backup
**** Original Line:          cp       K_ENTER
        cmp.b   #K_ENTER,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,nomore
        beq   RA_nomore
**** Original Line:          ld       c,a
        move.b  d7,d2
**** Original Line:          ld       a,15
        move.b  #15,d7
**** Original Line:          cp       b
        move.w  d2,(a1)
        cmp.b   (a1),d7
        move.w  sr,(a0)
**** Original Line:          jr       z,enter_name_loop
        beq   RA_enter_name_loop
**** Original Line:          ld       hl,&chartable-10
        move.w  #chartable-10+0,d4
**** Original Line:          ld       e,c
        move.b  d2,d3
**** Original Line:          ld       d,0
        and.w   #$ff,d3
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          ld       (ix),a
        __ADDR  5
        move.b  d7,(a5)
**** Original Line:          call     TX_CHARPUT 
        jsr     ti85lib3@0004
**** Original Line:          inc      b
        add.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        move.w  sr,(a0)
**** Original Line:          inc      ix
        addq.w  #1,d5
**** Original Line:          jr       enter_name_loop
        bra     RA_enter_name_loop
**** Original Line: backup:  dec      b
        __LABEL backup
        sub.w   #$100,d2
**** Original Line:          ld       a,255
        move.b  #255,d7
**** Original Line:          cp       b
        move.w  d2,(a1)
        cmp.b   (a1),d7
        move.w  sr,(a0)
**** Original Line:          jr       z,too_far
        beq   RA_too_far
**** Original Line:          dec      ix
        subq.w  #1,d5
**** Original Line:          ld       (ix),32
        __ADDR  5
        move.b  #32,(a5)
**** Original Line:          ld       hl,CURSOR_COL
        move.w  #CURSOR_COL+0,d4
        lea     CURSOR_COL-$10000(a0),a4
**** Original Line:          dec      (hl)
        ;__ADDR 4
        subq.b  #1,(a4)
**** Original Line:          ld       a,32
        move.b  #32,d7
**** Original Line:          call     TX_CHARPUT
        jsr     ti85lib3@0004
**** Original Line:          dec      (hl)
        __ADDR  4
        subq.b  #1,(a4)
        move.w  sr,(a0)
**** Original Line:          jr       enter_name_loop
        bra     RA_enter_name_loop
**** Original Line: too_far: inc      b
        __LABEL too_far
        add.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        move.w  sr,(a0)
**** Original Line:          jr       enter_name_loop
        bra     RA_enter_name_loop
**** Original Line: nomore:
        __LABEL nomore
**** Original Line:          ld       hl,&lowest
        move.w  #lowest+0,d4
        lea     lowest+0-$10000(a0),a4
**** Original Line:          ld       de,(score)
        move.b  1+score-$10000(a0),d3
        asl.w   #8,d3
        move.b  score-$10000(a0),d3
**** Original Line:          ld       (hl),e
        ;__ADDR 4
        move.b  d3,(a4)
**** Original Line:          push     hl
        move.w  d4,-(sp)
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          ld       (hl),d
        ;__ADDR 4
        move.w  d3,(a1)
        move.b  (a1),(a4)
**** Original Line:          pop      ix                         ;sort hiscore table
        move.w  (sp)+,d5
**** Original Line:          ld       b,6
        and.w   #$ff,d2
        or.w    #(6)<<8,d2
**** Original Line: sort_scores
        __LABEL sort_scores
**** Original Line:          ld       e,(ix)
        __ADDR  5
        move.b  (a5),d3
**** Original Line:          ld       d,(ix+1)
        __ADDR  5
        move.b  1(a5),d1
        asl.w   #8,d1
        and.w   #$ff,d3
        or.w    d1,d3
**** Original Line:          ld       l,(ix-19)
        __ADDR  5
        move.b  -19(a5),d4
**** Original Line:          ld       h,(ix-18)
        __ADDR  5
        move.b  -18(a5),d1
        asl.w   #8,d1
        and.w   #$ff,d4
        or.w    d1,d4
**** Original Line:          call     CP_HL_DE
        jsr     ti85lib3@0010
**** Original Line:          jr       nc,display_scores
        move.b  (a0),ccr
        bcc   RA_display_scores
**** Original Line:          push     bc
        move.w  d2,-(sp)
**** Original Line:          ld       b,19
        and.w   #$ff,d2
        or.w    #(19)<<8,d2
**** Original Line: exg_loop:ld       e,(ix)
        __LABEL exg_loop
        __ADDR  5
        move.b  (a5),d3
**** Original Line:          ld       c,(ix-19)
        __ADDR  5
        move.b  -19(a5),d2
**** Original Line:          ld       (ix),c
        __ADDR  5
        move.b  d2,(a5)
**** Original Line:          ld       (ix-19),e
        ;__ADDR 5
        move.b  d3,-19(a5)
**** Original Line:          inc      ix
        addq.w  #1,d5
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          djnz     exg_loop
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_exg_loop
**** Original Line:          ld       de,-38
        move.w  #-38+0,d3
**** Original Line:          add      ix,de
        add.w   d3,d5
**** Original Line:          pop      bc
        move.w  (sp)+,d2
**** Original Line:          djnz     sort_scores
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_sort_scores
**** Original Line: 
**** Original Line: display_scores:
        __LABEL display_scores
**** Original Line:          call     CLEARLCD 
        jsr     ti85lib3@0002
**** Original Line:          ld       ($800c),de
        move.w  d3,d0
        lsr.w   #8,d0
        move.b  d3,$800c-$10000(a0)
        move.b  d0,1+$800c-$10000(a0)
**** Original Line:          ld       hl,&hstitle
        move.w  #hstitle+0,d4
**** Original Line:          call     D_ZT_STR
        jsr     ti85lib3@0005
**** Original Line:          ld       hl,$1001
        move.w  #$1001+0,d4
**** Original Line:          ld       (CURSOR_ROW),hl
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,CURSOR_ROW-$10000(a0)
        move.b  d0,1+CURSOR_ROW-$10000(a0)
**** Original Line: 
**** Original Line:          ld       de,&hsdata
        move.w  #hsdata+0,d3
**** Original Line:          ld       b,7
        and.w   #$ff,d2
        or.w    #(7)<<8,d2
**** Original Line: high_display_loop:                           ;Display high scores
        __LABEL high_display_loop
**** Original Line:          ld       a,(de)
        __ADDR  3
        move.b  (a3),d7
**** Original Line:          ld       l,a
        move.b  d7,d4
**** Original Line:          inc      de
        addq.w  #1,d3
**** Original Line:          ld       a,(de)
        __ADDR  3
        move.b  (a3),d7
**** Original Line:          ld       h,a
        move.w  d4,(a1)
        move.b  d7,(a1)
        move.w  (a1),d4
**** Original Line:          inc      de
        addq.w  #1,d3
**** Original Line:          push     de
        move.w  d3,-(sp)
**** Original Line:          call     D_HL_DECI
        jsr     ti85lib3@0011
**** Original Line:          ld       hl,CURSOR_ROW
        move.w  #CURSOR_ROW+0,d4
        lea     CURSOR_ROW-$10000(a0),a4
**** Original Line:          dec      (hl)
        ;__ADDR 4
        subq.b  #1,(a4)
**** Original Line:          pop      hl
        move.w  (sp)+,d4
**** Original Line:          call     D_ZT_STR
        jsr     ti85lib3@0005
**** Original Line:          ex       de,hl
        exg     d3,d4
**** Original Line:          ld       hl,CURSOR_ROW
        move.w  #CURSOR_ROW+0,d4
        lea     CURSOR_ROW-$10000(a0),a4
**** Original Line:          inc      (hl)
        ;__ADDR 4
        addq.b  #1,(a4)
**** Original Line:          djnz     high_display_loop
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_high_display_loop
**** Original Line: wk__:    call     GET_KEY
        __LABEL wk__
        jsr     ti85lib3@0006
**** Original Line:          or       a
        or.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,wk__
        beq   RA_wk__
**** Original Line:          jp       &init
        bra     RA_init
**** Original Line: 
**** Original Line:  ; *************** Display Information Screen *******************************
**** Original Line: 
**** Original Line: display_info_screen:
        __LABEL display_info_screen
**** Original Line: 
**** Original Line:          push     hl
        move.w  d4,-(sp)
**** Original Line:          push     de
        move.w  d3,-(sp)
**** Original Line:          call     CLEARLCD
        jsr     ti85lib3@0002
**** Original Line: 
**** Original Line:          ld       hl,$fc0f
        move.w  #$fc0f+0,d4
**** Original Line:          ld       b,63
        and.w   #$ff,d2
        or.w    #(63)<<8,d2
**** Original Line:          ld       de,15
        move.w  #15+0,d3
**** Original Line: l2:      ld       (hl),1
        __LABEL l2
        __ADDR  4
        move.b  #1,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          ld       (hl),128
        ;__ADDR 4
        move.b  #128,(a4)
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          djnz     l2
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_l2
**** Original Line:          ld       hl,$fc00
        move.w  #$fc00+0,d4
**** Original Line:          ld       b,16
        and.w   #$ff,d2
        or.w    #(16)<<8,d2
**** Original Line: l1:      ld       (hl),255
        __LABEL l1
        __ADDR  4
        move.b  #255,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          djnz     l1
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_l1
**** Original Line:          ld       hl,$fff0
        move.w  #$fff0+0,d4
**** Original Line:          ld       b,16
        and.w   #$ff,d2
        or.w    #(16)<<8,d2
**** Original Line: l3:      ld       (hl),255
        __LABEL l3
        __ADDR  4
        move.b  #255,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          djnz     l3
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_l3
**** Original Line: 
**** Original Line:          ld       de,$0301
        move.w  #$0301+0,d3
**** Original Line:          ld       ($800c),de
        move.w  d3,d0
        lsr.w   #8,d0
        move.b  d3,$800c-$10000(a0)
        move.b  d0,1+$800c-$10000(a0)
**** Original Line:          pop      hl
        move.w  (sp)+,d4
**** Original Line:          call     D_ZT_STR
        jsr     ti85lib3@0005
**** Original Line:          pop      hl
        move.w  (sp)+,d4
**** Original Line: 
**** Original Line:          ld       b,5
        and.w   #$ff,d2
        or.w    #(5)<<8,d2
**** Original Line: l4:      ld       a,(hl)
        __LABEL l4
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          ld       (CURSOR_X),a
        move.b  d7,CURSOR_X-$10000(a0)
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          ld       (CURSOR_Y),a
        move.b  d7,CURSOR_Y-$10000(a0)
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          call     D_ZM_STR)
        jsr     ti85lib3@000E
**** Original Line:          djnz     l4
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_l4
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line:  ; *************** Restore Saved Game ***************************************
**** Original Line: 
**** Original Line: 
**** Original Line: restore: ld       (hl),0
        __LABEL restore
        __ADDR  4
        move.b  #0,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          ld       de,TEXT_MEM
        move.w  #TEXT_MEM+0,d3
**** Original Line:          ld       bc,storage_length
        move.w  #storage_length+0,d2
**** Original Line:          ldir
        __LDIR
**** Original Line:          call     &Load_Level_Data
        __JSR   RA_Load_Level_Data
**** Original Line:          jr       set_up_display
        bra     RA_set_up_display
**** Original Line: 
**** Original Line:  ; *************** Set Up Game Variables ************************************
**** Original Line: 
**** Original Line: play_game:
        __LABEL play_game
**** Original Line:          ld       hl,&saved_flag
        move.w  #saved_flag+0,d4
        lea     saved_flag+0-$10000(a0),a4
**** Original Line:          ld       a,(hl)
        ;__ADDR 4
        move.b  (a4),d7
**** Original Line:          or       a
        or.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          jr       nz,restore
        bne   RA_restore
**** Original Line:          ld       hl,TEXT_MEM
        move.w  #TEXT_MEM+0,d4
        lea     TEXT_MEM-$10000(a0),a4
**** Original Line:          ld       (hl),0
        ;__ADDR 4
        move.b  #0,(a4)
**** Original Line:          ld       de,TEXT_MEM+1
        move.w  #TEXT_MEM+1+0,d3
**** Original Line:          ld       bc,storage_length
        move.w  #storage_length+0,d2
**** Original Line:          ldir
        __LDIR
**** Original Line:          ld       a,9
        move.b  #9,d7
**** Original Line:          ld       (lasers),a
        move.b  d7,lasers-$10000(a0)
**** Original Line:          ld       (lives),a
        move.b  d7,lives-$10000(a0)
**** Original Line:          ld       a,70
        move.b  #70,d7
**** Original Line:          ld       (x),a
        move.b  d7,x-$10000(a0)
**** Original Line:          ld       (y),a
        move.b  d7,y-$10000(a0)
**** Original Line: 
**** Original Line:  ; *************** Set Up Game Display **************************************
**** Original Line: 
**** Original Line: set_up_display:
        __LABEL set_up_display
**** Original Line:          call     CLEARLCD
        jsr     ti85lib3@0002
**** Original Line: 
**** Original Line:          ld       hl,&in_game_text
        move.w  #in_game_text+0,d4
**** Original Line:          ld       b,3
        and.w   #$ff,d2
        or.w    #(3)<<8,d2
**** Original Line: l11:     ld       a,(hl)
        __LABEL l11
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          ld       (CURSOR_COL),a
        move.b  d7,CURSOR_COL-$10000(a0)
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          ld       (CURSOR_ROW),a
        move.b  d7,CURSOR_ROW-$10000(a0)
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          call     D_ZT_STR
        jsr     ti85lib3@0005
**** Original Line:          djnz     l11
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_l11
**** Original Line: 
**** Original Line:          call     &display_lives
        __JSR   RA_display_lives
**** Original Line:          call     &Update_Level_Number
        __JSR   RA_Update_Level_Number
**** Original Line: 
**** Original Line:  ; *************** Game Main Loop *******************************************
**** Original Line: 
**** Original Line: game_main_loop:
        __LABEL game_main_loop
**** Original Line:          ld       a,(enemies_remaining)
        move.b  enemies_remaining-$10000(a0),d7
**** Original Line:          or       a
        or.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          call     z,&Next_Level
        bne     NC__0
        __JSR   RA_Next_Level
NC__0:
**** Original Line:          ld       hl,timer
        move.w  #timer+0,d4
        lea     timer-$10000(a0),a4
**** Original Line:          inc      (hl)
        ;__ADDR 4
        addq.b  #1,(a4)
**** Original Line: 
**** Original Line:          xor      a
        eor.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          ld       hl,GRAPH_MEM+(16*12)
        move.w  #GRAPH_MEM+(16*12)+0,d4
**** Original Line:          ld       b,a
        move.w  d2,(a1)
        move.b  d7,(a1)
        move.w  (a1),d2
**** Original Line: csl:     ld       (hl),a
        __LABEL csl
        __ADDR  4
        move.b  d7,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          ld       (hl),a
        ;__ADDR 4
        move.b  d7,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          ld       (hl),a
        ;__ADDR 4
        move.b  d7,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          djnz     csl
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_csl
**** Original Line: 
**** Original Line:          call     &You_Shoot
        __JSR   RA_You_Shoot
**** Original Line:          call     &You_Shoot_Laser
        __JSR   RA_You_Shoot_Laser
**** Original Line:          call     &Your_Ship
        __JSR   RA_Your_Ship
**** Original Line:          call     &Move_Your_Bullets
        __JSR   RA_Move_Your_Bullets
**** Original Line:          call     &Enemy_Swoop
        __JSR   RA_Enemy_Swoop
**** Original Line:          call     &Handle_Enemies
        __JSR   RA_Handle_Enemies
**** Original Line:          CALL     &Enemies_Hit_You
        __JSR   RA_Enemies_Hit_You
**** Original Line:          call     &Boss
        __JSR   RA_Boss
**** Original Line:          call     &Boss_Shoot
        __JSR   RA_Boss_Shoot
**** Original Line:          call     &Enemies_Shoot_You
        __JSR   RA_Enemies_Shoot_You
**** Original Line:          call     &Move_Enemy_Bullets
        __JSR   RA_Move_Enemy_Bullets
**** Original Line:          call     &Display_Screen
        __JSR   RA_Display_Screen
**** Original Line:          call     &Misc_Keys
        __JSR   RA_Misc_Keys
**** Original Line:          jr       game_main_loop
        bra     RA_game_main_loop
**** Original Line: 
**** Original Line:  ; ************** Update Level Number ***************************************
**** Original Line: 
**** Original Line: Update_Level_Number:
        __LABEL Update_Level_Number
**** Original Line:          ld       hl,$1004
        move.w  #$1004+0,d4
**** Original Line:          ld       (CURSOR_ROW),hl
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,CURSOR_ROW-$10000(a0)
        move.b  d0,1+CURSOR_ROW-$10000(a0)
**** Original Line:          ld       hl,(level)
        move.b  1+level-$10000(a0),d4
        asl.w   #8,d4
        move.b  level-$10000(a0),d4
**** Original Line:          jp       D_HL_DECI
        jsr     ti85lib3@0011
        __RTS
**** Original Line: 
**** Original Line:  ; *************** Make Boss Shoot You **************************************
**** Original Line: 
**** Original Line: Boss_Shoot:
        __LABEL Boss_Shoot
**** Original Line:          ld       a,(timer)
        move.b  timer-$10000(a0),d7
**** Original Line:          and      63
        and.b   #63,d7
        move.w  sr,(a0)
**** Original Line:          ret      nz
        beq     NC__1
        __RTS
NC__1:
**** Original Line:          ld       hl,boss_status
        move.w  #boss_status+0,d4
        lea     boss_status-$10000(a0),a4
**** Original Line:          ld       a,(hl)
        ;__ADDR 4
        move.b  (a4),d7
**** Original Line:          or       a
        or.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          ret      z
        bne     NC__2
        __RTS
NC__2:
**** Original Line:          ret      m
        move.b  (a0),ccr
        bge     NC__3
        __RTS
NC__3:
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          ld       d,(hl)
        __ADDR  4
        move.b  (a4),d1
        asl.w   #8,d1
        and.w   #$ff,d3
        or.w    d1,d3
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          add      a,5
        add.b   #5,d7
        move.w  sr,(a0)
**** Original Line:          ld       e,a
        move.b  d7,d3
**** Original Line:          push     de
        move.w  d3,-(sp)
**** Original Line:          call     &boss_shoot
        __JSR   RA_boss_shoot
**** Original Line:          ld       hl,(boss_image)
        move.b  1+boss_image-$10000(a0),d4
        asl.w   #8,d4
        move.b  boss_image-$10000(a0),d4
**** Original Line:          ld       de,&spr_boss_3
        move.w  #spr_boss_3+0,d3
**** Original Line:          call     CP_HL_DE
        jsr     ti85lib3@0010
**** Original Line:          jr       z,bosssuper
        move.b  (a0),ccr
        beq   RA_bosssuper
**** Original Line:          pop      de
        move.w  (sp)+,d3
**** Original Line:          ld       a,13
        move.b  #13,d7
**** Original Line:          add      a,d
        move.w  d3,(a1)
        add.b   (a1),d7
**** Original Line:          ld       d,a
        move.w  d3,(a1)
        move.b  d7,(a1)
        move.w  (a1),d3
**** Original Line: 
**** Original Line: boss_shoot:
        __LABEL boss_shoot
**** Original Line:          ld       b,10
        and.w   #$ff,d2
        or.w    #(10)<<8,d2
**** Original Line:          ld       hl,ebuls
        move.w  #ebuls+0,d4
**** Original Line: find_enemy_bullet2:
        __LABEL find_enemy_bullet2
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          or       a
        or.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,feb___2
        beq   RA_feb___2
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          djnz     find_enemy_bullet2
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_find_enemy_bullet2
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line: feb___2:
        __LABEL feb___2
**** Original Line:          ld       (hl),1
        __ADDR  4
        move.b  #1,(a4)
**** Original Line:          ld       a,(x)
        move.b  x-$10000(a0),d7
**** Original Line:          sub      d
        move.w  d3,(a1)
        sub.b   (a1),d7
**** Original Line:          add      a,18
        add.b   #18,d7
        move.w  sr,(a0)
**** Original Line:          jp       p,&no_left_bossshoot
        bge   RA_no_left_bossshoot
**** Original Line:          ld       (hl),2
        ;__ADDR 4
        move.b  #2,(a4)
**** Original Line:          add      a,18
        add.b   #18,d7
        move.w  sr,(a0)
**** Original Line:          jp       p,&no_left_bossshoot
        bge   RA_no_left_bossshoot
**** Original Line:          ld       (hl),4
        ;__ADDR 4
        move.b  #4,(a4)
**** Original Line: no_left_bossshoot:
        __LABEL no_left_bossshoot
**** Original Line:          sub      54
        sub.b   #54,d7
        move.w  sr,(a0)
**** Original Line:          jp       m,&no_right_bossshoot
        blt   RA_no_right_bossshoot
**** Original Line:          ld       (hl),3
        __ADDR  4
        move.b  #3,(a4)
**** Original Line:          sub      18
        sub.b   #18,d7
        move.w  sr,(a0)
**** Original Line:          jp       m,&no_right_bossshoot
        blt   RA_no_right_bossshoot
**** Original Line:          ld       (hl),5
        ;__ADDR 4
        move.b  #5,(a4)
**** Original Line: no_right_bossshoot:
        __LABEL no_right_bossshoot
**** Original Line: 
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          ld       (hl),d
        __ADDR  4
        move.w  d3,(a1)
        move.b  (a1),(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          ld       (hl),e
        ;__ADDR 4
        move.b  d3,(a4)
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line: bosssuper:
        __LABEL bosssuper
**** Original Line:          pop      de
        move.w  (sp)+,d3
**** Original Line:          push     de
        move.w  d3,-(sp)
**** Original Line:          ld       a,10
        move.b  #10,d7
**** Original Line:          add      a,d
        move.w  d3,(a1)
        add.b   (a1),d7
        move.w  sr,(a0)
**** Original Line:          ld       d,a
        move.w  d3,(a1)
        move.b  d7,(a1)
        move.w  (a1),d3
**** Original Line:          call     &boss_shoot
        __JSR   RA_boss_shoot
**** Original Line:          pop      de
        move.w  (sp)+,d3
**** Original Line:          push     de
        move.w  d3,-(sp)
**** Original Line:          ld       a,20
        move.b  #20,d7
**** Original Line:          add      a,d
        move.w  d3,(a1)
        add.b   (a1),d7
        move.w  sr,(a0)
**** Original Line:          ld       d,a
        move.w  d3,(a1)
        move.b  d7,(a1)
        move.w  (a1),d3
**** Original Line:          call     &boss_shoot
        __JSR   RA_boss_shoot
**** Original Line:          pop      de
        move.w  (sp)+,d3
**** Original Line:          ld       a,30
        move.b  #30,d7
**** Original Line:          add      a,d
        move.w  d3,(a1)
        add.b   (a1),d7
        move.w  sr,(a0)
**** Original Line:          ld       d,a
        move.w  d3,(a1)
        move.b  d7,(a1)
        move.w  (a1),d3
**** Original Line:          jp       &boss_shoot
        bra     RA_boss_shoot
**** Original Line: 
**** Original Line:  ; *************** Move the Boss ********************************************
**** Original Line: 
**** Original Line: deploy_enemies:
        __LABEL deploy_enemies
**** Original Line:          ld       a,r                        ;Spit out enemies
        __RAND
**** Original Line:          cp       7
        cmp.b   #7,d7
        move.w  sr,(a0)
**** Original Line:          ret      p
        blt     NC__4
        __RTS
NC__4:
**** Original Line:          and      7
        and.b   #7,d7
**** Original Line:          add      a,a
        add.b   d7,d7
**** Original Line:          add      a,a
        add.b   d7,d7
**** Original Line:          ld       b,0
        and.w   #$ff,d2
**** Original Line:          ld       c,a
        move.b  d7,d2
**** Original Line:          ld       hl,enemies
        move.w  #enemies+0,d4
**** Original Line:          add      hl,bc                      ;HL -> slot in enemy data
        add.w   d2,d4
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          or       a
        or.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          ret      nz                         ;Return if enemy not destroyed
        beq     NC__5
        __RTS
NC__5:
**** Original Line:          ld       (hl),11                    ;Type to 11 (swooping)
        __ADDR  4
        move.b  #11,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          ld       a,(enemy_pwr)
        move.b  enemy_pwr-$10000(a0),d7
**** Original Line:          ld       (hl),a                     ;Load enemy's power
        ;__ADDR 4
        move.b  d7,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          ld       a,(boss_x)
        move.b  boss_x-$10000(a0),d7
**** Original Line:          add      a,12
        add.b   #12,d7
**** Original Line:          ld       (hl),a                     ;Load enemy X coordinate
        ;__ADDR 4
        move.b  d7,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          ld       (hl),24                    ;Load enemy Y coordinate
        ;__ADDR 4
        move.b  #24,(a4)
**** Original Line:          ld       hl,enemies_remaining
        move.w  #enemies_remaining+0,d4
        lea     enemies_remaining-$10000(a0),a4
**** Original Line:          inc      (hl)                       ;One more enemy remaining
        ;__ADDR 4
        addq.b  #1,(a4)
        move.w  sr,(a0)
**** Original Line:          ld       de,-200                    ;Remove points
        move.w  #-200+0,d3
**** Original Line:          jp       &sub_score
        bra     RA_sub_score
**** Original Line: 
**** Original Line: boss_5:  dec      (hl)                       ;Superboss left to X=0
        __LABEL boss_5
        __ADDR  4
        subq.b  #1,(a4)
        move.w  sr,(a0)
**** Original Line:          ret      nz
        beq     NC__6
        __RTS
NC__6:
**** Original Line:          dec      hl
        subq.w  #1,d4
        subq.w  #1,a4
**** Original Line:          dec      hl
        subq.w  #1,d4
        subq.w  #1,a4
**** Original Line:          ld       (hl),6
        ;__ADDR 4
        move.b  #6,(a4)
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line: boss_6:  inc      hl
        __LABEL boss_6
        addq.w  #1,d4
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          cp       16
        cmp.b   #16,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,sbpok
        beq   RA_sbpok
**** Original Line:          inc      (hl)
        __ADDR  4
        addq.b  #1,(a4)
        move.w  sr,(a0)
**** Original Line:          dec      hl
        subq.w  #1,d4
**** Original Line:          dec      hl
        subq.w  #1,d4
**** Original Line:          dec      hl
        subq.w  #1,d4
**** Original Line:          ret
        __RTS
**** Original Line: sbpok:   dec      hl
        __LABEL sbpok
        subq.w  #1,d4
**** Original Line:          inc      (hl)                       ;superboss right to X=65
        __ADDR  4
        addq.b  #1,(a4)
**** Original Line:          ld       a,(hl)
        ;__ADDR 4
        move.b  (a4),d7
**** Original Line:          cp       65
        cmp.b   #65,d7
        move.w  sr,(a0)
**** Original Line:          ret      nz
        beq     NC__7
        __RTS
NC__7:
**** Original Line:          dec      hl
        subq.w  #1,d4
        subq.w  #1,a4
**** Original Line:          dec      hl
        subq.w  #1,d4
        subq.w  #1,a4
**** Original Line:          ld       (hl),5
        ;__ADDR 4
        move.b  #5,(a4)
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line: Boss:    ld       hl,boss_status
        __LABEL Boss
        move.w  #boss_status+0,d4
        lea     boss_status-$10000(a0),a4
**** Original Line:          ld       a,(hl)
        ;__ADDR 4
        move.b  (a4),d7
**** Original Line:          or       a
        or.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          ret      z
        bne     NC__8
        __RTS
NC__8:
**** Original Line:          jp       m,&boss_explode
        move.b  (a0),ccr
        blt   RA_boss_explode
**** Original Line: 
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          ld       ix,(boss_image)
        move.b  1+boss_image-$10000(a0),d5
        asl.w   #8,d5
        move.b  boss_image-$10000(a0),d5
**** Original Line:          ld       d,(hl)
        __ADDR  4
        move.b  (a4),d1
        asl.w   #8,d1
        and.w   #$ff,d3
        or.w    d1,d3
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          ld       e,(hl)
        __ADDR  4
        move.b  (a4),d3
**** Original Line:          call     &drw_sprw
        __JSR   RA_drw_sprw
**** Original Line:          ld       hl,boss_status
        move.w  #boss_status+0,d4
        lea     boss_status-$10000(a0),a4
**** Original Line:          ld       a,(hl)
        ;__ADDR 4
        move.b  (a4),d7
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          dec      a
        subq.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,boss_1
        beq   RA_boss_1
**** Original Line:          dec      a
        subq.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,boss_2
        beq   RA_boss_2
**** Original Line:          dec      a
        subq.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,boss_3
        beq   RA_boss_3
**** Original Line:          dec      a
        subq.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,boss_4
        beq   RA_boss_4
**** Original Line:          ld       de,&deploy_enemies
        move.w  #deploy_enemies+0,d3
**** Original Line:          push     de
        move.w  d3,-(sp)
**** Original Line:          dec      a
        subq.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,boss_5
        beq   RA_boss_5
**** Original Line:          jr       boss_6
        bra     RA_boss_6
**** Original Line: 
**** Original Line: boss_4:  dec      (hl)                       ;Going left to X=0
        __LABEL boss_4
        __ADDR  4
        subq.b  #1,(a4)
        move.w  sr,(a0)
**** Original Line:          ret      nz
        beq     NC__9
        __RTS
NC__9:
**** Original Line:          dec      hl
        subq.w  #1,d4
        subq.w  #1,a4
**** Original Line:          dec      hl
        subq.w  #1,d4
        subq.w  #1,a4
**** Original Line:          ld       (hl),1
        ;__ADDR 4
        move.b  #1,(a4)
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line: boss_1:  inc      hl                         ;Going down to Y=20
        __LABEL boss_1
        addq.w  #1,d4
**** Original Line:          inc      (hl)
        __ADDR  4
        addq.b  #1,(a4)
**** Original Line:          ld       a,(hl)
        ;__ADDR 4
        move.b  (a4),d7
**** Original Line:          cp       20
        cmp.b   #20,d7
        move.w  sr,(a0)
**** Original Line:          ret      nz
        beq     NC__10
        __RTS
NC__10:
**** Original Line: boss_common:
        __LABEL boss_common
**** Original Line:          ld       hl,boss_status
        move.w  #boss_status+0,d4
        lea     boss_status-$10000(a0),a4
**** Original Line:          inc      (hl)
        ;__ADDR 4
        addq.b  #1,(a4)
        move.w  sr,(a0)
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line: boss_2:  inc      (hl)                       ;Going right to X=80
        __LABEL boss_2
        __ADDR  4
        addq.b  #1,(a4)
**** Original Line:          ld       a,(hl)
        ;__ADDR 4
        move.b  (a4),d7
**** Original Line:          cp       80
        cmp.b   #80,d7
        move.w  sr,(a0)
**** Original Line:          ret      nz
        beq     NC__11
        __RTS
NC__11:
**** Original Line:          jr       boss_common
        bra     RA_boss_common
**** Original Line: 
**** Original Line: boss_3:  inc      hl                         ;Going up to X=16
        __LABEL boss_3
        addq.w  #1,d4
**** Original Line:          dec      (hl)
        __ADDR  4
        subq.b  #1,(a4)
**** Original Line:          ld       a,(hl)
        ;__ADDR 4
        move.b  (a4),d7
**** Original Line:          cp       16
        cmp.b   #16,d7
        move.w  sr,(a0)
**** Original Line:          ret      nz
        beq     NC__12
        __RTS
NC__12:
**** Original Line:          jr       boss_common
        bra     RA_boss_common
**** Original Line: 
**** Original Line: boss_explode:
        __LABEL boss_explode
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          push     hl
        move.w  d4,-(sp)
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          call     &explosion_stuff
        __JSR   RA_explosion_stuff
**** Original Line:          pop      hl
        move.w  (sp)+,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          push     af
        move.b  d7,d1
        lsl.w   #8,d1
        move.b  1(a0),d1
        move.w  d1,-(sp)
**** Original Line:          push     hl
        move.w  d4,-(sp)
**** Original Line:          add      a,8
        add.b   #8,d7
        move.w  sr,(a0)
**** Original Line:          ld       (hl),a
        __ADDR  4
        move.b  d7,(a4)
**** Original Line:          dec      hl
        subq.w  #1,d4
        subq.w  #1,a4
**** Original Line:          ld       a,(hl)
        ;__ADDR 4
        move.b  (a4),d7
**** Original Line:          call     &explosion_stuff
        __JSR   RA_explosion_stuff
**** Original Line:          pop      hl
        move.w  (sp)+,d4
**** Original Line:          pop      af
        move.w  (sp)+,d1
        move.b  d1,1(a0)
        lsr.w   #8,d1
        move.b  d1,d7
**** Original Line:          ld       (hl),a
        __ADDR  4
        move.b  d7,(a4)
**** Original Line:          dec      hl
        subq.w  #1,d4
        subq.w  #1,a4
**** Original Line:          ld       a,(hl)
        ;__ADDR 4
        move.b  (a4),d7
**** Original Line:          cp       15
        cmp.b   #15,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,blown_up_enemyb
        beq   RA_blown_up_enemyb
**** Original Line:          inc      a
        addq.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          ld       (hl),a
        __ADDR  4
        move.b  d7,(a4)
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line: blown_up_enemyb:
        __LABEL blown_up_enemyb
**** Original Line:          dec      hl
        subq.w  #1,d4
**** Original Line:          ld       (hl),0
        __ADDR  4
        move.b  #0,(a4)
**** Original Line:          ld       hl,enemies_remaining
        move.w  #enemies_remaining+0,d4
        lea     enemies_remaining-$10000(a0),a4
**** Original Line:          dec      (hl)
        ;__ADDR 4
        subq.b  #1,(a4)
        move.w  sr,(a0)
**** Original Line:          ld       hl,(score)
        move.b  1+score-$10000(a0),d4
        asl.w   #8,d4
        move.b  score-$10000(a0),d4
**** Original Line:          ld       de,1000
        move.w  #1000+0,d3
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          ld       (score),hl
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,score-$10000(a0)
        move.b  d0,1+score-$10000(a0)
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line:  ; *************** Enemies Hit You ******************************************
**** Original Line: 
**** Original Line: Enemies_Hit_You:
        __LABEL Enemies_Hit_You
**** Original Line:          ld       a,(your_status)
        move.b  your_status-$10000(a0),d7
**** Original Line:          or       a
        or.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          ret      nz
        beq     NC__13
        __RTS
NC__13:
**** Original Line:          ld       de,(x)                     ;E = X, D = Y
        move.b  1+x-$10000(a0),d3
        asl.w   #8,d3
        move.b  x-$10000(a0),d3
**** Original Line:          ld       hl,enemies
        move.w  #enemies+0,d4
**** Original Line:          ld       b,20
        and.w   #$ff,d2
        or.w    #(20)<<8,d2
**** Original Line: lehy:    push     hl
        __LABEL lehy
        move.w  d4,-(sp)
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          or       a
        or.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,noeyc
        beq   RA_noeyc
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          sub      e
        sub.b   d3,d7
**** Original Line:          add      a,6
        add.b   #6,d7
        move.w  sr,(a0)
**** Original Line:          jp       m,&noeyc
        blt   RA_noeyc
**** Original Line:          cp       12
        cmp.b   #12,d7
        move.w  sr,(a0)
**** Original Line:          jr       nc,noeyc
        bcc   RA_noeyc
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          sub      d
        move.w  d3,(a1)
        sub.b   (a1),d7
**** Original Line:          add      a,6
        add.b   #6,d7
        move.w  sr,(a0)
**** Original Line:          jp       m,&noeyc
        blt   RA_noeyc
**** Original Line:          cp       12
        cmp.b   #12,d7
        move.w  sr,(a0)
**** Original Line:          jr       nc,noeyc
        bcc   RA_noeyc
**** Original Line:          dec      hl
        subq.w  #1,d4
**** Original Line:          dec      hl
        subq.w  #1,d4
**** Original Line:          ld       (hl),0
        __ADDR  4
        move.b  #0,(a4)
**** Original Line:          dec      hl
        subq.w  #1,d4
        subq.w  #1,a4
**** Original Line:          ld       (hl),4
        ;__ADDR 4
        move.b  #4,(a4)
**** Original Line:          pop      hl
        move.w  (sp)+,d4
**** Original Line:          jp       &damage_you
        bra     RA_damage_you
**** Original Line: noeyc:   pop      hl
        __LABEL noeyc
        move.w  (sp)+,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          djnz     lehy
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_lehy
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line:  ; *************** Make Enemies Swoop Down **********************************
**** Original Line: 
**** Original Line: Enemy_Swoop:
        __LABEL Enemy_Swoop
**** Original Line:          ld       a,(timer)
        move.b  timer-$10000(a0),d7
**** Original Line:          and      3
        and.b   #3,d7
**** Original Line:          cp       2
        cmp.b   #2,d7
        move.w  sr,(a0)
**** Original Line:          ret      nz
        beq     NC__14
        __RTS
NC__14:
**** Original Line:          ld       a,r
        __RAND
**** Original Line:          and      127
        and.b   #127,d7
**** Original Line:          cp       19
        cmp.b   #19,d7
        move.w  sr,(a0)
**** Original Line:          ret      p
        blt     NC__15
        __RTS
NC__15:
**** Original Line: 
**** Original Line:          add      a,a
        add.b   d7,d7
**** Original Line:          add      a,a
        add.b   d7,d7
**** Original Line:          ld       c,a
        move.b  d7,d2
**** Original Line:          ld       b,0
        and.w   #$ff,d2
**** Original Line:          ld       hl,enemies
        move.w  #enemies+0,d4
**** Original Line:          add      hl,bc
        add.w   d2,d4
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          cp       3
        cmp.b   #3,d7
        move.w  sr,(a0)
**** Original Line:          ret      nz
        beq     NC__16
        __RTS
NC__16:
**** Original Line: 
**** Original Line:          ld       a,r
        __RAND
**** Original Line:          and      1
        and.b   #1,d7
**** Original Line:          add      a,5
        add.b   #5,d7
**** Original Line:          ld       (hl),a
        __ADDR  4
        move.b  d7,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          ld       a,(hl)
        ;__ADDR 4
        move.b  (a4),d7
**** Original Line:          dec      hl
        subq.w  #1,d4
**** Original Line:          dec      hl
        subq.w  #1,d4
**** Original Line:          bit      6,a
        btst    #6,d7
        move.w  sr,(a0)
**** Original Line:          jr       nz,force_left
        move.b  (a0),ccr
        bne   RA_force_left
**** Original Line:          bit      5,a
        btst    #5,d7
        move.w  sr,(a0)
**** Original Line:          ret      nz
        move.b  (a0),ccr
        beq     NC__17
        __RTS
NC__17:
**** Original Line:          ld       (hl),5
        __ADDR  4
        move.b  #5,(a4)
**** Original Line:          ret
        __RTS
**** Original Line: force_left:
        __LABEL force_left
**** Original Line:          ld       (hl),6
        __ADDR  4
        move.b  #6,(a4)
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line:  ; *************** Make Enemies Shoot You ***********************************
**** Original Line: 
**** Original Line: Enemies_Shoot_You:
        __LABEL Enemies_Shoot_You
**** Original Line:          ld       a,r
        __RAND
**** Original Line:          and      127
        and.b   #127,d7
**** Original Line:          cp       19
        cmp.b   #19,d7
        move.w  sr,(a0)
**** Original Line:          ret      p
        blt     NC__18
        __RTS
NC__18:
**** Original Line: 
**** Original Line:          add      a,a
        add.b   d7,d7
**** Original Line:          add      a,a
        add.b   d7,d7
**** Original Line:          ld       c,a
        move.b  d7,d2
**** Original Line:          ld       b,0
        and.w   #$ff,d2
**** Original Line:          ld       hl,enemies
        move.w  #enemies+0,d4
**** Original Line:          add      hl,bc
        add.w   d2,d4
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          or       a
        or.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          ret      z
        bne     NC__19
        __RTS
NC__19:
**** Original Line:          dec      a
        subq.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          ret      z
        bne     NC__20
        __RTS
NC__20:
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          ld       d,(hl)
        __ADDR  4
        move.b  (a4),d1
        asl.w   #8,d1
        and.w   #$ff,d3
        or.w    d1,d3
**** Original Line:          inc      d
        add.w   #$100,d3
**** Original Line:          inc      d
        add.w   #$100,d3
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          add      a,5
        add.b   #5,d7
        move.w  sr,(a0)
**** Original Line:          ld       e,a
        move.b  d7,d3
**** Original Line: 
**** Original Line:          call     &test_operator
        __JSR   RA_test_operator
**** Original Line:          jp       z,&boss_shoot
        move.b  (a0),ccr
        beq   RA_boss_shoot
**** Original Line: 
**** Original Line:          ld       b,10
        and.w   #$ff,d2
        or.w    #(10)<<8,d2
**** Original Line:          ld       hl,ebuls
        move.w  #ebuls+0,d4
**** Original Line: find_enemy_bullet:
        __LABEL find_enemy_bullet
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          or       a
        or.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,feb___
        beq   RA_feb___
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          djnz     find_enemy_bullet
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_find_enemy_bullet
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line: feb___:  ld       (hl),1
        __LABEL feb___
        __ADDR  4
        move.b  #1,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          ld       (hl),d
        ;__ADDR 4
        move.w  d3,(a1)
        move.b  (a1),(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          ld       (hl),e
        ;__ADDR 4
        move.b  d3,(a4)
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line:  ; *************** Move Enemy Bullets ***************************************
**** Original Line: 
**** Original Line: Move_Enemy_Bullets:
        __LABEL Move_Enemy_Bullets
**** Original Line:          ld       hl,ebuls
        move.w  #ebuls+0,d4
**** Original Line:          ld       b,10
        and.w   #$ff,d2
        or.w    #(10)<<8,d2
**** Original Line: leb:     push     bc
        __LABEL leb
        move.w  d2,-(sp)
**** Original Line:          push     hl
        move.w  d4,-(sp)
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          dec      a
        subq.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,ebul1
        beq   RA_ebul1
**** Original Line:          dec      a
        subq.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,ebul2
        beq   RA_ebul2
**** Original Line:          dec      a
        subq.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,ebul3
        beq   RA_ebul3
**** Original Line:          dec      a
        subq.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,ebul4
        beq   RA_ebul4
**** Original Line:          dec      a
        subq.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,ebul5
        beq   RA_ebul5
**** Original Line: ebul_return:
        __LABEL ebul_return
**** Original Line:          pop      hl
        move.w  (sp)+,d4
**** Original Line:          pop      bc
        move.w  (sp)+,d2
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          djnz     leb
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_leb
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line: ebul3:   ld       a,(timer)
        __LABEL ebul3
        move.b  timer-$10000(a0),d7
**** Original Line:          rra
        move.b  (a0),ccr
        roxr.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       c,ebul1
        move.b  (a0),ccr
        bcs   RA_ebul1
**** Original Line: ebul5:   inc      (hl)
        __LABEL ebul5
        __ADDR  4
        addq.b  #1,(a4)
**** Original Line:          ld       a,(hl)
        ;__ADDR 4
        move.b  (a4),d7
**** Original Line:          cp       95
        cmp.b   #95,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,kill_enemy_bullet
        beq   RA_kill_enemy_bullet
**** Original Line:          jr       ebul1
        bra     RA_ebul1
**** Original Line: 
**** Original Line: ebul2:   ld       a,(timer)
        __LABEL ebul2
        move.b  timer-$10000(a0),d7
**** Original Line:          rra
        move.b  (a0),ccr
        roxr.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       c,ebul1
        move.b  (a0),ccr
        bcs   RA_ebul1
**** Original Line: ebul4:   dec      (hl)
        __LABEL ebul4
        __ADDR  4
        subq.b  #1,(a4)
        move.w  sr,(a0)
**** Original Line:          jr       z,kill_enemy_bullet
        beq   RA_kill_enemy_bullet
**** Original Line: 
**** Original Line: ebul1:   ld       d,(hl)
        __LABEL ebul1
        __ADDR  4
        move.b  (a4),d1
        asl.w   #8,d1
        and.w   #$ff,d3
        or.w    d1,d3
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          ld       a,81
        move.b  #81,d7
**** Original Line:          cp       (hl)
        __ADDR  4
        cmp.b   (a4),d7
        move.w  sr,(a0)
**** Original Line:          jr       z,kill_enemy_bullet
        beq   RA_kill_enemy_bullet
**** Original Line:          inc      (hl)
        ;__ADDR 4
        addq.b  #1,(a4)
        move.w  sr,(a0)
**** Original Line:          ld       e,(hl)
        ;__ADDR 4
        move.b  (a4),d3
**** Original Line:          ld       ix,&spr_enemy_bullet
        move.w  #spr_enemy_bullet+0,d5
**** Original Line:          call     &drw_spr
        __JSR   RA_drw_spr
**** Original Line:          ld       a,(your_status)
        move.b  your_status-$10000(a0),d7
**** Original Line:          or       a
        or.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          jr       nz,ebul_return
        bne   RA_ebul_return
**** Original Line:          pop      hl
        move.w  (sp)+,d4
**** Original Line:          push     hl
        move.w  d4,-(sp)
**** Original Line: 
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          ld       a,(x)
        move.b  x-$10000(a0),d7
**** Original Line:          sub      (hl)
        __ADDR  4
        sub.b   (a4),d7
**** Original Line:          add      a,6
        add.b   #6,d7
        move.w  sr,(a0)
**** Original Line:          jp       m,&ebul_return
        blt   RA_ebul_return
**** Original Line:          cp       9
        cmp.b   #9,d7
        move.w  sr,(a0)
**** Original Line:          jr       nc,ebul_return
        bcc   RA_ebul_return
**** Original Line: 
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          ld       a,(y)
        move.b  y-$10000(a0),d7
**** Original Line:          sub      (hl)
        ;__ADDR 4
        sub.b   (a4),d7
**** Original Line:          add      a,6
        add.b   #6,d7
        move.w  sr,(a0)
**** Original Line:          jp       m,&ebul_return
        blt   RA_ebul_return
**** Original Line:          cp       9
        cmp.b   #9,d7
        move.w  sr,(a0)
**** Original Line:          jr       nc,ebul_return
        bcc   RA_ebul_return
**** Original Line: 
**** Original Line:          call     &damage_you
        __JSR   RA_damage_you
**** Original Line: 
**** Original Line: kill_enemy_bullet:
        __LABEL kill_enemy_bullet
**** Original Line:          pop      hl
        move.w  (sp)+,d4
**** Original Line:          push     hl
        move.w  d4,-(sp)
**** Original Line:          ld       (hl),0
        __ADDR  4
        move.b  #0,(a4)
**** Original Line:          jr       ebul_return
        bra     RA_ebul_return
**** Original Line: 
**** Original Line:  ; *************** Hit Your Ship ********************************************
**** Original Line: 
**** Original Line: damage_you:
        __LABEL damage_you
**** Original Line: 
**** Original Line:          ld       a,31
        move.b  #31,d7
**** Original Line:          ld       (your_status),a
        move.b  d7,your_status-$10000(a0)
**** Original Line:          ld       hl,lives
        move.w  #lives+0,d4
        lea     lives-$10000(a0),a4
**** Original Line:          dec      (hl)
        ;__ADDR 4
        subq.b  #1,(a4)
**** Original Line: display_lives:
        __LABEL display_lives
**** Original Line:          ld       hl,$1001
        move.w  #$1001+0,d4
**** Original Line:          ld       (CURSOR_ROW),hl
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,CURSOR_ROW-$10000(a0)
        move.b  d0,1+CURSOR_ROW-$10000(a0)
**** Original Line:          ld       hl,(lives)
        move.b  1+lives-$10000(a0),d4
        asl.w   #8,d4
        move.b  lives-$10000(a0),d4
**** Original Line:          jp       D_HL_DECI
        jsr     ti85lib3@0011
        __RTS
**** Original Line: 
**** Original Line:  ; *************** Enemy Type 1 (Waiting to Descend) ************************
**** Original Line: 
**** Original Line: enemy_type_1:
        __LABEL enemy_type_1
**** Original Line:          ld       a,(timer)
        move.b  timer-$10000(a0),d7
**** Original Line:          and      127
        and.b   #127,d7
**** Original Line:          or       %10000000
        or.b   #%10000000,d7
**** Original Line: 
**** Original Line:          ld       hl,enemy_coords-1
        move.w  #enemy_coords-1+0,d4
**** Original Line:          add      hl,bc
        add.w   d2,d4
**** Original Line:          add      a,(hl)
        __ADDR  4
        add.b   (a4),d7
        move.w  sr,(a0)
**** Original Line:          RET      NZ
        beq     NC__21
        __RTS
NC__21:
**** Original Line:          dec      hl
        subq.w  #1,d4
        subq.w  #1,a4
**** Original Line:          ld       a,(hl)
        ;__ADDR 4
        move.b  (a4),d7
**** Original Line:          pop      BC
        move.w  (sp)+,d2
**** Original Line:          POP      HL
        move.w  (sp)+,d4
**** Original Line:          PUSH     HL
        move.w  d4,-(sp)
**** Original Line:          push     BC
        move.w  d2,-(sp)
**** Original Line:          ld       (hl),2
        __ADDR  4
        move.b  #2,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          ld       (hl),a
        ;__ADDR 4
        move.b  d7,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          ld       (hl),0
        ;__ADDR 4
        move.b  #0,(a4)
**** Original Line:          RET
        __RTS
**** Original Line:          
**** Original Line:  ; *************** Move The Enemies *****************************************
**** Original Line: 
**** Original Line: Handle_Enemies:
        __LABEL Handle_Enemies
**** Original Line:          ld       hl,enemies
        move.w  #enemies+0,d4
**** Original Line:          ld       bc,40
        move.w  #40+0,d2
**** Original Line: l_enemies:
        __LABEL l_enemies
**** Original Line:          push     bc
        move.w  d2,-(sp)
**** Original Line:          push     hl
        move.w  d4,-(sp)
**** Original Line:          ld       ix,(enemy_image)
        move.b  1+enemy_image-$10000(a0),d5
        asl.w   #8,d5
        move.b  enemy_image-$10000(a0),d5
**** Original Line:          ld       a,14
        move.b  #14,d7
**** Original Line:          cp       c
        cmp.b   d2,d7
        move.w  sr,(a0)
**** Original Line:          jr       nc,no_i2
        bcc   RA_no_i2
**** Original Line:          ld       a,(boss_image)
        move.b  boss_image-$10000(a0),d7
**** Original Line:          inc      a
        addq.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       nz,no_i2
        bne   RA_no_i2
**** Original Line:          ld       ix,&spr_enemy_1
        move.w  #spr_enemy_1+0,d5
**** Original Line: no_i2:
        __LABEL no_i2
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          ld       de,&enemy_return
        move.w  #enemy_return+0,d3
**** Original Line:          push     de
        move.w  d3,-(sp)
**** Original Line: 
**** Original Line:          dec      a
        subq.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,enemy_type_1
        beq   RA_enemy_type_1
**** Original Line:          dec      a
        subq.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,enemy_type_2
        beq   RA_enemy_type_2
**** Original Line:          dec      a
        subq.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,enemy_type_3
        beq   RA_enemy_type_3
**** Original Line:          dec      a
        subq.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,enemy_type_4
        beq   RA_enemy_type_4
**** Original Line:          dec      a
        subq.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jp       z,&enemy_type_5
        beq   RA_enemy_type_5
**** Original Line:          dec      a
        subq.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jp       z,&enemy_type_6
        beq   RA_enemy_type_6
**** Original Line:          dec      a
        subq.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jp       z,&enemy_type_7
        beq   RA_enemy_type_7
**** Original Line:          dec      a
        subq.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jp       z,&enemy_type_8
        beq   RA_enemy_type_8
**** Original Line:          dec      a
        subq.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jp       z,&enemy_type_9
        beq   RA_enemy_type_9
**** Original Line:          dec      a
        subq.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jp       z,&enemy_type_10
        beq   RA_enemy_type_10
**** Original Line:          dec      a
        subq.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jp       z,&enemy_type_11
        beq   RA_enemy_type_11
**** Original Line:          dec      a
        subq.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jp       z,&enemy_type_12
        beq   RA_enemy_type_12
**** Original Line:          dec      a
        subq.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jp       z,&enemy_type_13
        beq   RA_enemy_type_13
**** Original Line:          pop      HL
        move.w  (sp)+,d4
**** Original Line: enemy_return:
        __LABEL enemy_return
**** Original Line:          pop      hl
        move.w  (sp)+,d4
**** Original Line:          pop      bc
        move.w  (sp)+,d2
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          dec      c
        subq.b  #1,d2
**** Original Line:          dec      c
        subq.b  #1,d2
        move.w  sr,(a0)
**** Original Line:          jr       nz,l_enemies
        bne   RA_l_enemies
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line:  ; *************** Enemy Type 2 (Descending to Normal Position) *************
**** Original Line: 
**** Original Line: enemy_type_2:
        __LABEL enemy_type_2
**** Original Line:          ld       a,(timer)
        move.b  timer-$10000(a0),d7
**** Original Line:          add      a,a
        add.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,make_type_3
        beq   RA_make_type_3
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          ld       d,(hl)
        __ADDR  4
        move.b  (a4),d1
        asl.w   #8,d1
        and.w   #$ff,d3
        or.w    d1,d3
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      (hl)
        __ADDR  4
        addq.b  #1,(a4)
        move.w  sr,(a0)
**** Original Line: ecommon_2:
        __LABEL ecommon_2
**** Original Line:          ld       e,(hl)
        __ADDR  4
        move.b  (a4),d3
**** Original Line:          JP       &drw_spr
        bra     RA_drw_spr
**** Original Line: 
**** Original Line: make_type_3:
        __LABEL make_type_3
**** Original Line:          ld       (hl),3
        __ADDR  4
        move.b  #3,(a4)
**** Original Line: 
**** Original Line:  ; **************** Enemy Type 3 (Normal Pattern) ***************************
**** Original Line: 
**** Original Line: enemy_type_3:
        __LABEL enemy_type_3
**** Original Line:          Inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          ld       a,(timer)
        move.b  timer-$10000(a0),d7
**** Original Line:          rra
        move.b  (a0),ccr
        roxr.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       c,noslide
        move.b  (a0),ccr
        bcs   RA_noslide
**** Original Line:          inc      (hl)
        __ADDR  4
        addq.b  #1,(a4)
**** Original Line:          bit      5,a
        btst    #5,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,noslide
        move.b  (a0),ccr
        beq   RA_noslide
**** Original Line:          dec      (hl)
        ;__ADDR 4
        subq.b  #1,(a4)
**** Original Line:          dec      (hl)
        ;__ADDR 4
        subq.b  #1,(a4)
        move.w  sr,(a0)
**** Original Line: noslide: ld       d,(hl)
        __LABEL noslide
        __ADDR  4
        move.b  (a4),d1
        asl.w   #8,d1
        and.w   #$ff,d3
        or.w    d1,d3
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          jr       ecommon_2
        bra     RA_ecommon_2
**** Original Line: 
**** Original Line:  ; *************** Enemy Type 4 (Exploding) *********************************
**** Original Line: 
**** Original Line: enemy_type_4:
        __LABEL enemy_type_4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          push     hl
        move.w  d4,-(sp)
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line: 
**** Original Line:          call     &explosion_stuff
        __JSR   RA_explosion_stuff
**** Original Line: 
**** Original Line:          pop      hl
        move.w  (sp)+,d4
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          cp       15
        cmp.b   #15,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,blown_up_enemy
        beq   RA_blown_up_enemy
**** Original Line:          inc      a
        addq.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          ld       (hl),a
        __ADDR  4
        move.b  d7,(a4)
**** Original Line:          RET
        __RTS
**** Original Line: 
**** Original Line: blown_up_enemy:
        __LABEL blown_up_enemy
**** Original Line:          dec      hl
        subq.w  #1,d4
**** Original Line:          ld       (hl),0
        __ADDR  4
        move.b  #0,(a4)
**** Original Line:          ld       hl,enemies_remaining
        move.w  #enemies_remaining+0,d4
        lea     enemies_remaining-$10000(a0),a4
**** Original Line:          dec      (hl)
        ;__ADDR 4
        subq.b  #1,(a4)
        move.w  sr,(a0)
**** Original Line:          ld       hl,(score)
        move.b  1+score-$10000(a0),d4
        asl.w   #8,d4
        move.b  score-$10000(a0),d4
**** Original Line: smc_scoring:
        __LABEL smc_scoring
**** Original Line:          ld       de,100
        move.w  #100+0,d3
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          ld       (score),hl
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,score-$10000(a0)
        move.b  d0,1+score-$10000(a0)
**** Original Line:          RET
        __RTS
**** Original Line: 
**** Original Line:  ; *************** Enemy Type 5 (Swooping Up + Right) ***********************
**** Original Line: 
**** Original Line: enemy_type_5:
        __LABEL enemy_type_5
**** Original Line:          ld       a,7
        move.b  #7,d7
**** Original Line:          ld       bc,$01FF
        move.w  #$01FF+0,d2
**** Original Line: enemy_common:
        __LABEL enemy_common
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line: 
**** Original Line:          ld       (next_type),a
        move.b  d7,next_type-$10000(a0)
**** Original Line:          ld       a,b
        move.w  d2,(a1)
        move.b  (a1),d7
**** Original Line:          add      a,(hl)
        __ADDR  4
        add.b   (a4),d7
**** Original Line:          ld       (hl),a
        ;__ADDR 4
        move.b  d7,(a4)
**** Original Line:          ld       d,a
        move.w  d3,(a1)
        move.b  d7,(a1)
        move.w  (a1),d3
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          ld       a,c
        move.b  d2,d7
**** Original Line:          add      a,(hl)
        ;__ADDR 4
        add.b   (a4),d7
        move.w  sr,(a0)
**** Original Line:          ld       (hl),a
        ;__ADDR 4
        move.b  d7,(a4)
**** Original Line:          ld       e,a
        move.b  d7,d3
**** Original Line:          call     &drw_spr
        __JSR   RA_drw_spr
**** Original Line:          ld       a,(timer)
        move.b  timer-$10000(a0),d7
**** Original Line:          and      3
        and.b   #3,d7
        move.w  sr,(a0)
**** Original Line:          RET      nz
        beq     NC__22
        __RTS
NC__22:
**** Original Line:          POP      BC
        move.w  (sp)+,d2
**** Original Line:          pop      hl
        move.w  (sp)+,d4
**** Original Line:          push     hl
        move.w  d4,-(sp)
**** Original Line:          PUSH     BC
        move.w  d2,-(sp)
**** Original Line:          ld       a,(next_type)
        move.b  next_type-$10000(a0),d7
**** Original Line:          ld       (hl),a
        __ADDR  4
        move.b  d7,(a4)
**** Original Line:          RET
        __RTS
**** Original Line: 
**** Original Line:  ; *************** Enemy Type 6 (Swooping Up + Left) ************************
**** Original Line: 
**** Original Line: enemy_type_6:
        __LABEL enemy_type_6
**** Original Line:          ld       a,8
        move.b  #8,d7
**** Original Line:          ld       bc,$FFFF
        move.w  #$FFFF+0,d2
**** Original Line:          jr       enemy_common
        bra     RA_enemy_common
**** Original Line: 
**** Original Line:  ; *************** Enemy Type 7 (Swooping Right) ****************************
**** Original Line: 
**** Original Line: enemy_type_7:
        __LABEL enemy_type_7
**** Original Line:          ld       a,9
        move.b  #9,d7
**** Original Line:          ld       bc,$0100
        move.w  #$0100+0,d2
**** Original Line:          jr       enemy_common
        bra     RA_enemy_common
**** Original Line: 
**** Original Line:  ; *************** Enemy Type 8 (Swooping Left) *****************************
**** Original Line: 
**** Original Line: enemy_type_8:
        __LABEL enemy_type_8
**** Original Line:          ld       a,10
        move.b  #10,d7
**** Original Line:          ld       bc,$ff00
        move.w  #$ff00+0,d2
**** Original Line:          jr       enemy_common
        bra     RA_enemy_common
**** Original Line: 
**** Original Line:  ; *************** Enemy Type 9 (Swooping Right / Down) *********************
**** Original Line: 
**** Original Line: enemy_type_9:
        __LABEL enemy_type_9
**** Original Line:          ld       bc,$0101
        move.w  #$0101+0,d2
**** Original Line:          ld       a,11
        move.b  #11,d7
**** Original Line:          jr       enemy_common
        bra     RA_enemy_common
**** Original Line: 
**** Original Line:  ; *************** Enemy Type 10 (Swooping Left / Down) *********************
**** Original Line: 
**** Original Line: enemy_type_10:
        __LABEL enemy_type_10
**** Original Line:          ld       bc,$ff01  
        move.w  #$ff01+0,d2
**** Original Line:          ld       a,11
        move.b  #11,d7
**** Original Line:          jr       enemy_common
        bra     RA_enemy_common
**** Original Line: 
**** Original Line:  ; *************** Enemy Type 11 (Swooping Down) ****************************
**** Original Line: 
**** Original Line: enemy_type_11:
        __LABEL enemy_type_11
**** Original Line:          ld       a,12
        move.b  #12,d7
**** Original Line:          ld       bc,$0001
        move.w  #$0001+0,d2
**** Original Line:          jr       enemy_common
        bra     RA_enemy_common
**** Original Line: 
**** Original Line:  ; *************** Enemy Type 12 (Swooping Down Quickly) ********************
**** Original Line: 
**** Original Line: enemy_type_12:
        __LABEL enemy_type_12
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          ld       d,(hl)
        __ADDR  4
        move.b  (a4),d1
        asl.w   #8,d1
        and.w   #$ff,d3
        or.w    d1,d3
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      (hl)
        __ADDR  4
        addq.b  #1,(a4)
**** Original Line:          inc      (hl)
        ;__ADDR 4
        addq.b  #1,(a4)
**** Original Line:          ld       e,(hl)
        ;__ADDR 4
        move.b  (a4),d3
**** Original Line:          ld       a,78
        move.b  #78,d7
**** Original Line:          cp       e
        cmp.b   d3,d7
        move.w  sr,(a0)
**** Original Line:          jr       c,enemy_restore
        bcs   RA_enemy_restore
**** Original Line:          JP       &drw_spr
        bra     RA_drw_spr
**** Original Line:             
**** Original Line: enemy_restore:
        __LABEL enemy_restore
**** Original Line: 
**** Original Line:          POP      BC
        move.w  (sp)+,d2
**** Original Line:          pop      hl
        move.w  (sp)+,d4
**** Original Line:          push     hl
        move.w  d4,-(sp)
**** Original Line:          PUSH     BC
        move.w  d2,-(sp)
**** Original Line:          ld       (hl),1
        __ADDR  4
        move.b  #1,(a4)
**** Original Line:          ld       de,-1
        move.w  #-1+0,d3
**** Original Line: 
**** Original Line: ; *************** Subtract DE points from score *****************************
**** Original Line: 
**** Original Line: sub_score:
        __LABEL sub_score
**** Original Line:          push     hl
        move.w  d4,-(sp)
**** Original Line:          ld       hl,(score)
        move.b  1+score-$10000(a0),d4
        asl.w   #8,d4
        move.b  score-$10000(a0),d4
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          jr       nc,zero
        move.b  (a0),ccr
        bcc   RA_zero
**** Original Line:          ld       (score),hl
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,score-$10000(a0)
        move.b  d0,1+score-$10000(a0)
**** Original Line:          pop      hl
        move.w  (sp)+,d4
**** Original Line:          ret
        __RTS
**** Original Line: zero:    ld       hl,0
        __LABEL zero
        move.w  #0+0,d4
**** Original Line:          ld       (score),hl
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,score-$10000(a0)
        move.b  d0,1+score-$10000(a0)
**** Original Line:          pop      hl
        move.w  (sp)+,d4
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line:  ; *************** Enemy Type 13 (Warp Enemy) *******************************
**** Original Line: 
**** Original Line: enemy_type_13:
        __LABEL enemy_type_13
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          add      a,(hl)
        __ADDR  4
        add.b   (a4),d7
**** Original Line:          ld       d,a
        move.w  d3,(a1)
        move.b  d7,(a1)
        move.w  (a1),d3
**** Original Line: 
**** Original Line:          cp       1
        cmp.b   #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       nz,et13_not_x_2
        bne   RA_et13_not_x_2
**** Original Line:          ld       (hl),1
        ;__ADDR 4
        move.b  #1,(a4)
**** Original Line: et13_not_x_2:
        __LABEL et13_not_x_2
**** Original Line:          cp       23
        cmp.b   #23,d7
        move.w  sr,(a0)
**** Original Line:          jr       nz,et13_not_x_23
        bne   RA_et13_not_x_23
**** Original Line:          ld       (hl),1
        __ADDR  4
        move.b  #1,(a4)
**** Original Line:          ld       a,r
        __RAND
**** Original Line:          rra
        move.b  (a0),ccr
        roxr.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       c,et13_not_x_23
        move.b  (a0),ccr
        bcs   RA_et13_not_x_23
**** Original Line:          ld       (hl),-1
        ;__ADDR 4
        move.b  #-1,(a4)
**** Original Line: et13_not_x_23:
        __LABEL et13_not_x_23
**** Original Line:          cp       45
        cmp.b   #45,d7
        move.w  sr,(a0)
**** Original Line:          jr       nz,et13_not_x_45
        bne   RA_et13_not_x_45
**** Original Line:          ld       (hl),1
        __ADDR  4
        move.b  #1,(a4)
**** Original Line:          ld       a,r
        __RAND
**** Original Line:          rra
        move.b  (a0),ccr
        roxr.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       c,et13_not_x_45
        move.b  (a0),ccr
        bcs   RA_et13_not_x_45
**** Original Line:          ld       (hl),-1
        ;__ADDR 4
        move.b  #-1,(a4)
**** Original Line: et13_not_x_45:
        __LABEL et13_not_x_45
**** Original Line:          cp       87
        cmp.b   #87,d7
        move.w  sr,(a0)
**** Original Line:          jr       nz,et13_not_x_87
        bne   RA_et13_not_x_87
**** Original Line:          ld       (hl),-1
        __ADDR  4
        move.b  #-1,(a4)
**** Original Line: et13_not_x_87:
        __LABEL et13_not_x_87
**** Original Line: 
**** Original Line:          dec      hl
        subq.w  #1,d4
**** Original Line:          dec      hl
        subq.w  #1,d4
**** Original Line:          dec      hl
        subq.w  #1,d4
**** Original Line:          ld       (hl),d
        __ADDR  4
        move.w  d3,(a1)
        move.b  (a1),(a4)
**** Original Line: 
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          ld       a,(hl)
        ;__ADDR 4
        move.b  (a4),d7
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          add      a,(hl)
        ;__ADDR 4
        add.b   (a4),d7
        move.w  sr,(a0)
**** Original Line:          jr       z,et13_gone
        beq   RA_et13_gone
**** Original Line: 
**** Original Line:          ld       e,a         
        move.b  d7,d3
**** Original Line: 
**** Original Line:          cp       15
        cmp.b   #15,d7
        move.w  sr,(a0)
**** Original Line:          jr       nz,et13_not_y_15
        bne   RA_et13_not_y_15
**** Original Line:          ld       (hl),1
        ;__ADDR 4
        move.b  #1,(a4)
**** Original Line: et13_not_y_15:
        __LABEL et13_not_y_15
**** Original Line:          cp       27
        cmp.b   #27,d7
        move.w  sr,(a0)
**** Original Line:          jr       nz,et13_not_y_27
        bne   RA_et13_not_y_27
**** Original Line:          ld       (hl),1
        __ADDR  4
        move.b  #1,(a4)
**** Original Line:          ld       a,r
        __RAND
**** Original Line:          rra
        move.b  (a0),ccr
        roxr.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       c,et13_not_y_27
        move.b  (a0),ccr
        bcs   RA_et13_not_y_27
**** Original Line:          ld       (hl),-1
        ;__ADDR 4
        move.b  #-1,(a4)
**** Original Line: et13_not_y_27:
        __LABEL et13_not_y_27
**** Original Line:          cp       39
        cmp.b   #39,d7
        move.w  sr,(a0)
**** Original Line:          jr       nz,et13_not_y_39
        bne   RA_et13_not_y_39
**** Original Line:          ld       (hl),-1
        __ADDR  4
        move.b  #-1,(a4)
**** Original Line:          ld       a,r
        __RAND
**** Original Line:          rra
        move.b  (a0),ccr
        roxr.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       c,et13_not_y_39
        move.b  (a0),ccr
        bcs   RA_et13_not_y_39
**** Original Line:          rra
        move.b  (a0),ccr
        roxr.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       c,et13_not_y_39
        move.b  (a0),ccr
        bcs   RA_et13_not_y_39
**** Original Line: 
**** Original Line:          call     &test_operator
        __JSR   RA_test_operator
**** Original Line:          jr       z,et13_not_y_39
        move.b  (a0),ccr
        beq   RA_et13_not_y_39
**** Original Line: 
**** Original Line:          bit      3,c
        btst    #3,d2
        move.w  sr,(a0)
**** Original Line:          jr       z,et13_not_y_39
        move.b  (a0),ccr
        beq   RA_et13_not_y_39
**** Original Line: 
**** Original Line:          ld       (hl),-2
        __ADDR  4
        move.b  #-2,(a4)
**** Original Line:          dec      e
        subq.b  #1,d3
        move.w  sr,(a0)
**** Original Line: et13_not_y_39:
        __LABEL et13_not_y_39
**** Original Line: 
**** Original Line:          dec      hl
        subq.w  #1,d4
**** Original Line:          dec      hl
        subq.w  #1,d4
**** Original Line:          dec      hl
        subq.w  #1,d4
**** Original Line:          ld       (hl),e
        __ADDR  4
        move.b  d3,(a4)
**** Original Line: 
**** Original Line:          jp       &drw_spr
        bra     RA_drw_spr
**** Original Line: 
**** Original Line: et13_gone:
        __LABEL et13_gone
**** Original Line:          pop      bc
        move.w  (sp)+,d2
**** Original Line:          pop      hl
        move.w  (sp)+,d4
**** Original Line:          push     hl
        move.w  d4,-(sp)
**** Original Line:          push     bc
        move.w  d2,-(sp)
**** Original Line:          ld       (hl),a
        __ADDR  4
        move.b  d7,(a4)
**** Original Line:          ld       hl,enemies_remaining
        move.w  #enemies_remaining+0,d4
        lea     enemies_remaining-$10000(a0),a4
**** Original Line:          dec      (hl)
        ;__ADDR 4
        subq.b  #1,(a4)
        move.w  sr,(a0)
**** Original Line:          ld       de,-50
        move.w  #-50+0,d3
**** Original Line:          call     &sub_score
        __JSR   RA_sub_score
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line: test_operator:
        __LABEL test_operator
**** Original Line:          push     hl
        move.w  d4,-(sp)
**** Original Line:          push     de
        move.w  d3,-(sp)
**** Original Line:          ld       hl,(enemy_image)
        move.b  1+enemy_image-$10000(a0),d4
        asl.w   #8,d4
        move.b  enemy_image-$10000(a0),d4
**** Original Line:          ld       de,&enemy_o
        move.w  #enemy_o+0,d3
**** Original Line:          call     CP_HL_DE
        jsr     ti85lib3@0010
**** Original Line:          pop      de
        move.w  (sp)+,d3
**** Original Line:          pop      hl
        move.w  (sp)+,d4
**** Original Line:          ret               
        __RTS
**** Original Line: 
**** Original Line:  ; *************** Shoot Your Lasers ****************************************
**** Original Line: 
**** Original Line: You_Shoot_Laser:
        __LABEL You_Shoot_Laser
**** Original Line:          ld       hl,jpf2                    ;Test if F2 clicked
        move.w  #jpf2+0,d4
**** Original Line:          in       a,(1)
        move.b  #1,d1
        jsr     ti85lib3@0008
**** Original Line:          bit      3,a
        btst    #3,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,pressed2
        move.b  (a0),ccr
        beq   RA_pressed2
**** Original Line:          ld       (hl),0
        __ADDR  4
        move.b  #0,(a4)
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line: pressed2:ld       a,(hl)
        __LABEL pressed2
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          or       a
        or.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          ret      nz
        beq     NC__23
        __RTS
NC__23:
**** Original Line:          ld       (hl),1
        __ADDR  4
        move.b  #1,(a4)
**** Original Line: 
**** Original Line:          ld       hl,lasers                  ;Test # of lasers
        move.w  #lasers+0,d4
        lea     lasers-$10000(a0),a4
**** Original Line:          ld       a,(hl)
        ;__ADDR 4
        move.b  (a4),d7
**** Original Line:          dec      a
        subq.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          ret      m
        bge     NC__24
        __RTS
NC__24:
**** Original Line:          ld       (hl),a
        __ADDR  4
        move.b  d7,(a4)
**** Original Line:          ld       a,(x)
        move.b  x-$10000(a0),d7
**** Original Line:          add      a,3
        add.b   #3,d7
**** Original Line: 
**** Original Line:          ld       b,a                        ;Draw laser
        move.w  d2,(a1)
        move.b  d7,(a1)
        move.w  (a1),d2
**** Original Line:          ld       c,63              
        move.b  #63,d2
**** Original Line:          call     FIND_PIXEL
        jsr     ti85lib3@0009
**** Original Line:          ld       de,$8641
        move.w  #$8641+0,d3
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          ld       b,84
        and.w   #$ff,d2
        or.w    #(84)<<8,d2
**** Original Line:          ld       de,12
        move.w  #12+0,d3
**** Original Line: ldrawlaser:
        __LABEL ldrawlaser
**** Original Line:          ld       (hl),a
        __ADDR  4
        move.b  d7,(a4)
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          djnz     ldrawlaser
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_ldrawlaser
**** Original Line: 
**** Original Line:          ld       a,(x)                      ;Laser kills enemies
        move.b  x-$10000(a0),d7
**** Original Line:          add      a,3
        add.b   #3,d7
**** Original Line:          ld       e,a
        move.b  d7,d3
**** Original Line:          ld       hl,enemies
        move.w  #enemies+0,d4
**** Original Line:          ld       b,20
        and.w   #$ff,d2
        or.w    #(20)<<8,d2
**** Original Line: l_laser: ld       a,(hl)
        __LABEL l_laser
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          or       a
        or.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,nohitl
        beq   RA_nohitl
**** Original Line:          dec      a
        subq.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,nohitl
        beq   RA_nohitl
**** Original Line:          cp       3
        cmp.b   #3,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,nohitl
        beq   RA_nohitl
**** Original Line:          ld       a,e
        move.b  d3,d7
**** Original Line:          sub      (hl)
        __ADDR  4
        sub.b   (a4),d7
**** Original Line:          and      248
        and.b   #248,d7
        move.w  sr,(a0)
**** Original Line:          jr       nz,nohitl
        bne   RA_nohitl
**** Original Line:          dec      hl
        subq.w  #1,d4
        subq.w  #1,a4
**** Original Line:          ld       (hl),0
        ;__ADDR 4
        move.b  #0,(a4)
**** Original Line:          dec      hl
        subq.w  #1,d4
        subq.w  #1,a4
**** Original Line:          ld       (hl),4
        ;__ADDR 4
        move.b  #4,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line: nohitl:  inc      hl
        __LABEL nohitl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          djnz     l_laser
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_l_laser
**** Original Line: 
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line:  ; *************** Allow You To Shoot ***************************************
**** Original Line: 
**** Original Line: You_Shoot:
        __LABEL You_Shoot
**** Original Line:          ld       a,%00111111
        move.b  #%00111111,d7
**** Original Line:          out      (1),a
        move.b  #1,d1
        jsr     ti85lib3@0007
**** Original Line:          ld       a,(your_status)
        move.b  your_status-$10000(a0),d7
**** Original Line:          or       a
        or.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          ret      nz
        beq     NC__25
        __RTS
NC__25:
**** Original Line:          ld       hl,jpf1
        move.w  #jpf1+0,d4
**** Original Line:          in       a,(1)
        move.b  #1,d1
        jsr     ti85lib3@0008
**** Original Line:          bit      4,a
        btst    #4,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,pressed
        move.b  (a0),ccr
        beq   RA_pressed
**** Original Line:          ld       (hl),0
        __ADDR  4
        move.b  #0,(a4)
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line: pressed: ld       a,(hl)
        __LABEL pressed
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          or       a
        or.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          ret      nz
        beq     NC__26
        __RTS
NC__26:
**** Original Line:          ld       (hl),1                     ;Comment out for auto-fire
        __ADDR  4
        move.b  #1,(a4)
**** Original Line: 
**** Original Line:          ld       hl,ybullets
        move.w  #ybullets+0,d4
**** Original Line:          ld       de,3
        move.w  #3+0,d3
**** Original Line:          ld       b,10
        and.w   #$ff,d2
        or.w    #(10)<<8,d2
**** Original Line: find_ybullet:
        __LABEL find_ybullet
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          or       a
        or.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,found_ybullet
        beq   RA_found_ybullet
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          djnz     find_ybullet
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_find_ybullet
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line: found_ybullet:
        __LABEL found_ybullet
**** Original Line:          ld       (hl),1
        __ADDR  4
        move.b  #1,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          ld       a,(x)
        move.b  x-$10000(a0),d7
**** Original Line:          add      a,2
        add.b   #2,d7
**** Original Line:          ld       (hl),a
        ;__ADDR 4
        move.b  d7,(a4)
**** Original Line:          ld       a,(y)
        move.b  y-$10000(a0),d7
**** Original Line:          sub      4
        sub.b   #4,d7
        move.w  sr,(a0)
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          ld       (hl),a
        ;__ADDR 4
        move.b  d7,(a4)
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line:  ; *************** Move Your Bullets ****************************************
**** Original Line: 
**** Original Line: kill_bullet:
        __LABEL kill_bullet
**** Original Line:          dec      hl
        subq.w  #1,d4
**** Original Line:          dec      hl
        subq.w  #1,d4
**** Original Line:          ld       (hl),0
        __ADDR  4
        move.b  #0,(a4)
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line: Move_Your_Bullets:
        __LABEL Move_Your_Bullets
**** Original Line:          ld       hl,ybullets
        move.w  #ybullets+0,d4
**** Original Line:          ld       b,10
        and.w   #$ff,d2
        or.w    #(10)<<8,d2
**** Original Line: scan_your_bullets:
        __LABEL scan_your_bullets
**** Original Line:          push     bc
        move.w  d2,-(sp)
**** Original Line:          push     hl
        move.w  d4,-(sp)
**** Original Line:          ld       (temp1),hl
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,temp1-$10000(a0)
        move.b  d0,1+temp1-$10000(a0)
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          dec      a
        subq.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          call     z,&bullet_type_1
        bne     NC__27
        __JSR   RA_bullet_type_1
NC__27:
**** Original Line:          pop      hl
        move.w  (sp)+,d4
**** Original Line:          pop      bc
        move.w  (sp)+,d2
**** Original Line:          ld       de,3
        move.w  #3+0,d3
**** Original Line:          add      hl,de  
        add.w   d3,d4
**** Original Line:          djnz     scan_your_bullets
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_scan_your_bullets
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line: bullet_type_1:
        __LABEL bullet_type_1
**** Original Line: 
**** Original Line:          ld       d,(hl)
        __ADDR  4
        move.b  (a4),d1
        asl.w   #8,d1
        and.w   #$ff,d3
        or.w    d1,d3
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          ld       e,(hl)
        __ADDR  4
        move.b  (a4),d3
**** Original Line:          dec      e
        subq.b  #1,d3
        move.w  sr,(a0)
**** Original Line:          jr       z,kill_bullet
        beq   RA_kill_bullet
**** Original Line:          dec      e
        subq.b  #1,d3
        move.w  sr,(a0)
**** Original Line:          jr       z,kill_bullet
        beq   RA_kill_bullet
**** Original Line:          ld       (hl),e
        __ADDR  4
        move.b  d3,(a4)
**** Original Line:          ld       ix,&spr_bullet_1
        move.w  #spr_bullet_1+0,d5
**** Original Line:          push     de
        move.w  d3,-(sp)
**** Original Line:          call     &drw_spr
        __JSR   RA_drw_spr
**** Original Line:          pop      de
        move.w  (sp)+,d3
**** Original Line:          ld       b,20
        and.w   #$ff,d2
        or.w    #(20)<<8,d2
**** Original Line:          ld       hl,enemies
        move.w  #enemies+0,d4
**** Original Line: 
**** Original Line: hit_enemies:                                 ;Hits with normal enemies
        __LABEL hit_enemies
**** Original Line:          push     hl
        move.w  d4,-(sp)
**** Original Line: 
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          or       a
        or.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,nohit
        beq   RA_nohit
**** Original Line:          dec      a
        subq.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,nohit
        beq   RA_nohit
**** Original Line:          cp       3
        cmp.b   #3,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,nohit
        beq   RA_nohit
**** Original Line: 
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line: 
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          sub      d
        move.w  d3,(a1)
        sub.b   (a1),d7
**** Original Line:          add      a,5
        add.b   #5,d7
        move.w  sr,(a0)
**** Original Line:          jp       m,&nohit
        blt   RA_nohit
**** Original Line:          cp       8
        cmp.b   #8,d7
        move.w  sr,(a0)
**** Original Line:          jr       nc,nohit
        bcc   RA_nohit
**** Original Line: 
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          sub      e
        sub.b   d3,d7
**** Original Line:          add      a,5
        add.b   #5,d7
        move.w  sr,(a0)
**** Original Line:          jp       m,&nohit
        blt   RA_nohit
**** Original Line:          cp       10
        cmp.b   #10,d7
        move.w  sr,(a0)
**** Original Line:          jr       nc,nohit
        bcc   RA_nohit
**** Original Line: 
**** Original Line:          push     hl
        move.w  d4,-(sp)
**** Original Line:          ld       hl,(temp1)
        move.b  1+temp1-$10000(a0),d4
        asl.w   #8,d4
        move.b  temp1-$10000(a0),d4
**** Original Line:          ld       (hl),0
        __ADDR  4
        move.b  #0,(a4)
**** Original Line:          ld       hl,(score)
        move.b  1+score-$10000(a0),d4
        asl.w   #8,d4
        move.b  score-$10000(a0),d4
**** Original Line:          ld       de,10
        move.w  #10+0,d3
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          ld       (score),hl
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,score-$10000(a0)
        move.b  d0,1+score-$10000(a0)
**** Original Line:          pop      hl
        move.w  (sp)+,d4
**** Original Line: 
**** Original Line:          dec      hl
        subq.w  #1,d4
**** Original Line:          dec      hl
        subq.w  #1,d4
**** Original Line:          dec      (hl)
        __ADDR  4
        subq.b  #1,(a4)
        move.w  sr,(a0)
**** Original Line:          jr       nz,nohit
        bne   RA_nohit
**** Original Line:          ld       (hl),0
        ;__ADDR 4
        move.b  #0,(a4)
**** Original Line:          dec      hl
        subq.w  #1,d4
        subq.w  #1,a4
**** Original Line:          ld       (hl),4
        ;__ADDR 4
        move.b  #4,(a4)
**** Original Line: 
**** Original Line:          pop      hl
        move.w  (sp)+,d4
**** Original Line:          ret
        __RTS
**** Original Line:          
**** Original Line: nohit:   pop      hl
        __LABEL nohit
        move.w  (sp)+,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          djnz     hit_enemies
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_hit_enemies
**** Original Line: 
**** Original Line:          ld       hl,boss_status             ;Hits with boss
        move.w  #boss_status+0,d4
        lea     boss_status-$10000(a0),a4
**** Original Line:          ld       a,(hl)
        ;__ADDR 4
        move.b  (a4),d7
**** Original Line:          or       a
        or.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          ret      m
        bge     NC__28
        __RTS
NC__28:
**** Original Line:          ret      z
        move.b  (a0),ccr
        bne     NC__29
        __RTS
NC__29:
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          sub      d
        move.w  d3,(a1)
        sub.b   (a1),d7
**** Original Line: bhsmc1:  add      a,15
        __LABEL bhsmc1
        add.b   #15,d7
        move.w  sr,(a0)
**** Original Line:          ret      m
        bge     NC__30
        __RTS
NC__30:
**** Original Line: bhsmc2:  cp       18
        __LABEL bhsmc2
        cmp.b   #18,d7
        move.w  sr,(a0)
**** Original Line:          ret      p
        blt     NC__31
        __RTS
NC__31:
**** Original Line: 
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          sub      e
        sub.b   d3,d7
**** Original Line:          add      a,8
        add.b   #8,d7
        move.w  sr,(a0)
**** Original Line:          ret      m
        bge     NC__32
        __RTS
NC__32:
**** Original Line:          cp       13
        cmp.b   #13,d7
        move.w  sr,(a0)
**** Original Line:          ret      p
        blt     NC__33
        __RTS
NC__33:
**** Original Line: 
**** Original Line:          ld       hl,(temp1)
        move.b  1+temp1-$10000(a0),d4
        asl.w   #8,d4
        move.b  temp1-$10000(a0),d4
**** Original Line:          ld       (hl),0
        __ADDR  4
        move.b  #0,(a4)
**** Original Line: 
**** Original Line:          ld       hl,(score)
        move.b  1+score-$10000(a0),d4
        asl.w   #8,d4
        move.b  score-$10000(a0),d4
**** Original Line:          ld       de,25
        move.w  #25+0,d3
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          ld       (score),hl
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,score-$10000(a0)
        move.b  d0,1+score-$10000(a0)
**** Original Line: 
**** Original Line:          ld       hl,boss_pwr
        move.w  #boss_pwr+0,d4
        lea     boss_pwr-$10000(a0),a4
**** Original Line:          dec      (hl)
        ;__ADDR 4
        subq.b  #1,(a4)
        move.w  sr,(a0)
**** Original Line:          ret      nz
        beq     NC__34
        __RTS
NC__34:
**** Original Line:          ld       (hl),0
        ;__ADDR 4
        move.b  #0,(a4)
**** Original Line:          dec      hl
        subq.w  #1,d4
        subq.w  #1,a4
**** Original Line:          ld       (hl),-1
        ;__ADDR 4
        move.b  #-1,(a4)
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line:  ; *************** In-Game Text *********************************************
**** Original Line: 
**** Original Line: in_game_text:
        __LABEL in_game_text
**** Original Line:          .db      16,0,"LIVES",0
        dc.b    16
        dc.b    0
        dc.b    "LIVES"
        dc.b    0
**** Original Line:          .db      16,3,"LEVEL",0
        dc.b    16
        dc.b    3
        dc.b    "LEVEL"
        dc.b    0
**** Original Line:          .db      16,6,"SCORE",0
        dc.b    16
        dc.b    6
        dc.b    "SCORE"
        dc.b    0
**** Original Line: 
**** Original Line:  ; *************** Display the Screen ***************************************
**** Original Line: 
**** Original Line: Display_Screen:
        __LABEL Display_Screen
**** Original Line:          ld       a,64                       ;Display Image
        move.b  #64,d7
**** Original Line:          ld       hl,GRAPH_MEM+(16*12)
        move.w  #GRAPH_MEM+(16*12)+0,d4
**** Original Line:          ld       de,$fc00
        move.w  #$fc00+0,d3
**** Original Line: dsl:     ld       bc,12
        __LABEL dsl
        move.w  #12+0,d2
**** Original Line:          ldir
        __LDIR
**** Original Line:          inc      de
        addq.w  #1,d3
**** Original Line:          inc      de
        addq.w  #1,d3
**** Original Line:          inc      de
        addq.w  #1,d3
**** Original Line:          inc      de
        addq.w  #1,d3
**** Original Line:          dec      a
        subq.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       nz,dsl
        bne   RA_dsl
**** Original Line: 
**** Original Line:          ld       a,(lasers)                 ;Display number of lasers
        move.b  lasers-$10000(a0),d7
**** Original Line:          or       a
        or.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,nolasers
        beq   RA_nolasers
**** Original Line:          add      a,'0'
        add.b   #'0',d7
**** Original Line:          ld       (CURSOR_X),de
        move.w  d3,d0
        lsr.w   #8,d0
        move.b  d3,CURSOR_X-$10000(a0)
        move.b  d0,1+CURSOR_X-$10000(a0)
**** Original Line:          call     M_CHARPUT
        jsr     ti85lib3@000C
**** Original Line: nolasers:
        __LABEL nolasers
**** Original Line: 
**** Original Line:          ld       hl,$1007                   ;Display Score
        move.w  #$1007+0,d4
**** Original Line:          ld       (CURSOR_ROW),hl
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,CURSOR_ROW-$10000(a0)
        move.b  d0,1+CURSOR_ROW-$10000(a0)
**** Original Line:          ld       hl,(score)
        move.b  1+score-$10000(a0),d4
        asl.w   #8,d4
        move.b  score-$10000(a0),d4
**** Original Line:          jp       D_HL_DECI
        jsr     ti85lib3@0011
        __RTS
**** Original Line: 
**** Original Line:  ; *************** Handle Your Ship *****************************************
**** Original Line: 
**** Original Line: Your_Ship:
        __LABEL Your_Ship
**** Original Line:          ld       a,(your_status)
        move.b  your_status-$10000(a0),d7
**** Original Line:          bit      4,a
        btst    #4,d7
        move.w  sr,(a0)
**** Original Line:          jr       nz,you_not_normal
        move.b  (a0),ccr
        bne   RA_you_not_normal
**** Original Line:          or       a
        or.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,ok
        beq   RA_ok
**** Original Line:          dec      a
        subq.b  #1,d7
**** Original Line:          ld       (your_status),a
        move.b  d7,your_status-$10000(a0)
**** Original Line:          ld       hl,(lives)
        move.b  1+lives-$10000(a0),d4
        asl.w   #8,d4
        move.b  lives-$10000(a0),d4
**** Original Line:          ld       a,l
        move.b  d4,d7
**** Original Line:          or       h
        move.w  d4,(a1)
        or.b   (a1),d7
        move.w  sr,(a0)
**** Original Line:          jr       nz,ok
        bne   RA_ok
**** Original Line:          pop      af
        move.w  (sp)+,d1
        move.b  d1,1(a0)
        lsr.w   #8,d1
        move.b  d1,d7
**** Original Line:          ret
        __RTS
**** Original Line: ok:
        __LABEL ok
**** Original Line:          ld       a,%01111110
        move.b  #%01111110,d7
**** Original Line:          out      (1),a
        move.b  #1,d1
        jsr     ti85lib3@0007
**** Original Line:          ld       hl,y
        move.w  #y+0,d4
**** Original Line:          in       a,(1)
        move.b  #1,d1
        jsr     ti85lib3@0008
**** Original Line:          rra
        move.b  (a0),ccr
        roxr.b  #1,d7
**** Original Line:          ld       b,a
        move.w  d2,(a1)
        move.b  d7,(a1)
        move.w  (a1),d2
**** Original Line: 
**** Original Line:          jr       c,no_down
        move.b  (a0),ccr
        bcs   RA_no_down
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          inc      a
        addq.b  #1,d7
**** Original Line:          cp       73
        cmp.b   #73,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,no_down
        beq   RA_no_down
**** Original Line:          ld       (hl),a
        __ADDR  4
        move.b  d7,(a4)
**** Original Line: no_down: dec      hl
        __LABEL no_down
        subq.w  #1,d4
**** Original Line:          rr       b
        move.w  d2,(a1)
        move.b  (a1),d1
        move.b  (a0),ccr
        roxr.b  #1,d1
        move.w  sr,(a0)
        move.b  d1,(a1)
        move.w  (a1),d2
**** Original Line:          jr       c,no_left
        move.b  (a0),ccr
        bcs   RA_no_left
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          dec      a
        subq.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,no_left
        beq   RA_no_left
**** Original Line:          ld       (hl),a
        __ADDR  4
        move.b  d7,(a4)
**** Original Line: no_left: rr       b   
        __LABEL no_left
        move.w  d2,(a1)
        move.b  (a1),d1
        move.b  (a0),ccr
        roxr.b  #1,d1
        move.w  sr,(a0)
        move.b  d1,(a1)
        move.w  (a1),d2
**** Original Line:          jr       c,no_right
        move.b  (a0),ccr
        bcs   RA_no_right
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          inc      a
        addq.b  #1,d7
**** Original Line:          cp       89
        cmp.b   #89,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,no_right
        beq   RA_no_right
**** Original Line:          ld       (hl),a
        __ADDR  4
        move.b  d7,(a4)
**** Original Line: no_right:ld       d,(hl)
        __LABEL no_right
        __ADDR  4
        move.b  (a4),d1
        asl.w   #8,d1
        and.w   #$ff,d3
        or.w    d1,d3
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          rr       b
        move.w  d2,(a1)
        move.b  (a1),d1
        move.b  (a0),ccr
        roxr.b  #1,d1
        move.w  sr,(a0)
        move.b  d1,(a1)
        move.w  (a1),d2
**** Original Line:          jr       c,no_up
        move.b  (a0),ccr
        bcs   RA_no_up
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          dec      a
        subq.b  #1,d7
**** Original Line:          cp       60
        cmp.b   #60,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,no_up
        beq   RA_no_up
**** Original Line:          ld       (hl),a
        __ADDR  4
        move.b  d7,(a4)
**** Original Line: no_up:
        __LABEL no_up
**** Original Line:          ld       ix,&spr_your_ship
        move.w  #spr_your_ship+0,d5
**** Original Line: 
**** Original Line: display_common:
        __LABEL display_common
**** Original Line:          ld       e,(hl)
        __ADDR  4
        move.b  (a4),d3
**** Original Line:          jp       &drw_spr
        bra     RA_drw_spr
**** Original Line: 
**** Original Line: you_not_normal:
        __LABEL you_not_normal
**** Original Line: 
**** Original Line:          ld       de,-16
        move.w  #-16+0,d3
**** Original Line:          call     &sub_score
        __JSR   RA_sub_score
**** Original Line:          ld       a,(your_status)
        move.b  your_status-$10000(a0),d7
**** Original Line:          dec      a
        subq.b  #1,d7
**** Original Line:          ld       (your_status),a
        move.b  d7,your_status-$10000(a0)
**** Original Line:          inc      a
        addq.b  #1,d7
**** Original Line:          and      14
        and.b   #14,d7
**** Original Line:          xor      14
        eor.b   #14,d7
**** Original Line:          ld       hl,x-1
        move.w  #x-1+0,d4
**** Original Line: 
**** Original Line: explosion_stuff:
        __LABEL explosion_stuff
**** Original Line:          rra
        move.b  (a0),ccr
        roxr.b  #1,d7
**** Original Line:          add      a,a
        add.b   d7,d7
**** Original Line:          add      a,a
        add.b   d7,d7
**** Original Line:          add      a,a
        add.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          ld       c,a
        move.b  d7,d2
**** Original Line:          ld       b,0
        and.w   #$ff,d2
**** Original Line:          ld       ix,&spr_explosion
        move.w  #spr_explosion+0,d5
**** Original Line:          add      ix,bc
        add.w   d2,d5
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          ld       d,(hl)
        __ADDR  4
        move.b  (a4),d1
        asl.w   #8,d1
        and.w   #$ff,d3
        or.w    d1,d3
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          jr       display_common
        bra     RA_display_common
**** Original Line: 
**** Original Line:  ; *************** Control Key Processing ***********************************
**** Original Line: 
**** Original Line: ;cheat:   xor      a
**** Original Line: ;         ld       (enemies_remaining),a
**** Original Line: ;         ld       hl,0
**** Original Line: ;         ld       (score),hl
**** Original Line: ;         ld       (boss_status),hl
**** Original Line: ;         ret
**** Original Line: 
**** Original Line: Misc_Keys:
        __LABEL Misc_Keys
**** Original Line:          call     GET_KEY
        jsr     ti85lib3@0006
**** Original Line: 
**** Original Line:          ;cp       K_DOT
**** Original Line:          ;jr       z,cheat
**** Original Line:          cp       K_ENTER
        cmp.b   #K_ENTER,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,pause
        beq   RA_pause
**** Original Line:          cp       K_MORE
        cmp.b   #K_MORE,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,e_save
        beq   RA_e_save
**** Original Line:          cp       K_EXIT
        cmp.b   #K_EXIT,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,e_exit
        beq   RA_e_exit
**** Original Line:          cp       K_CLEAR
        cmp.b   #K_CLEAR,d7
        move.w  sr,(a0)
**** Original Line:          ret      nz
        beq     NC__35
        __RTS
NC__35:
**** Original Line:          pop      af
        move.w  (sp)+,d1
        move.b  d1,1(a0)
        lsr.w   #8,d1
        move.b  d1,d7
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line: e_save:  LD       A,3                        ;Save the game
        __LABEL e_save
        move.b  #3,d7
**** Original Line:          ld       (USG_BITS),a
        move.b  d7,USG_BITS-$10000(a0)
**** Original Line:          ld       de,&saved_flag
        move.w  #saved_flag+0,d3
        lea     saved_flag+0-$10000(a0),a3
**** Original Line:          ld       (de),a
        ;__ADDR 3
        move.b  d7,(a3)
**** Original Line:          inc      de
        addq.w  #1,d3
**** Original Line:          ld       hl,TEXT_MEM
        move.w  #TEXT_MEM+0,d4
**** Original Line:          ld       bc,storage_length
        move.w  #storage_length+0,d2
**** Original Line:          ldir
        __LDIR
**** Original Line:          jp       &exit_game
        bra     RA_exit_game
**** Original Line: 
**** Original Line: e_exit:  ld       a,3
        __LABEL e_exit
        move.b  #3,d7
**** Original Line:          ld       (USG_BITS),a
        move.b  d7,USG_BITS-$10000(a0)
**** Original Line:          jp       &exit_game
        bra     RA_exit_game
**** Original Line: 
**** Original Line: pause:   ld       hl,$1901
        __LABEL pause
        move.w  #$1901+0,d4
**** Original Line:          ld       (CURSOR_X),hl
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,CURSOR_X-$10000(a0)
        move.b  d0,1+CURSOR_X-$10000(a0)
**** Original Line:          ld       hl,&paused_msg
        move.w  #paused_msg+0,d4
**** Original Line:          call     D_ZM_STR)
        jsr     ti85lib3@000E
**** Original Line:          ld       de,$2001
        move.w  #$2001+0,d3
**** Original Line:          ld       (CURSOR_X),de
        move.w  d3,d0
        lsr.w   #8,d0
        move.b  d3,CURSOR_X-$10000(a0)
        move.b  d0,1+CURSOR_X-$10000(a0)
**** Original Line:          call     D_ZM_STR
        jsr     ti85lib3@000E
**** Original Line: 
**** Original Line: wenter:  call     GET_KEY
        __LABEL wenter
        jsr     ti85lib3@0006
**** Original Line:          ld       hl,contrst
        move.w  #contrst+0,d4
**** Original Line:          cp       K_ENTER
        cmp.b   #K_ENTER,d7
        move.w  sr,(a0)
**** Original Line:          ret      z
        bne     NC__36
        __RTS
NC__36:
**** Original Line:          cp       K_PLUS
        cmp.b   #K_PLUS,d7
        move.w  sr,(a0)
**** Original Line:          jr       nz,nic
        bne   RA_nic
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          cp       $1f
        cmp.b   #$1f,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,wenter
        beq   RA_wenter
**** Original Line:          inc      a
        addq.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       cc_common
        bra     RA_cc_common
**** Original Line: nic:     cp       K_MINUS
        __LABEL nic
        cmp.b   #K_MINUS,d7
        move.w  sr,(a0)
**** Original Line:          jr       nz,wenter
        bne   RA_wenter
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          or       a
        or.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,wenter
        beq   RA_wenter
**** Original Line:          dec      a
        subq.b  #1,d7
        move.w  sr,(a0)
**** Original Line: cc_common:
        __LABEL cc_common
**** Original Line:          ld       (hl),a
        __ADDR  4
        move.b  d7,(a4)
**** Original Line:          out      (2),a
        move.b  #2,d1
        jsr     ti85lib3@0007
**** Original Line:          jr       wenter
        bra     RA_wenter
        dc.b    32
**** Original Line: 
**** Original Line: paused_msg:
        __LABEL paused_msg
**** Original Line:          .db      "Paused - [ENTER] "
        dc.b    "Paused - [ENTER] "
**** Original Line:          .db      "to continue",0
        dc.b    "to continue"
        dc.b    0
**** Original Line:          .db      "[+] or [-] to "
        dc.b    "[+] or [-] to "
**** Original Line:          .db      "change contrast",0
        dc.b    "change contrast"
        dc.b    0
**** Original Line: 
**** Original Line:  ; *************** Sprite Rendering Routine *********************************
**** Original Line: 
**** Original Line: offsets_table:
        __LABEL offsets_table
**** Original Line:          .db      128,64,32,16,8,4,2,1
        dc.b    128
        dc.b    64
        dc.b    32
        dc.b    16
        dc.b    8
        dc.b    4
        dc.b    2
        dc.b    1
**** Original Line: 
**** Original Line: drw_spr: ld       a,d
        __LABEL drw_spr
        move.w  d3,(a1)
        move.b  (a1),d7
**** Original Line:          and      7
        and.b   #7,d7
**** Original Line:          ld       hl,&offsets_table
        move.w  #offsets_table+0,d4
**** Original Line:          ld       c,a
        move.b  d7,d2
**** Original Line:          ld       b,0
        and.w   #$ff,d2
**** Original Line:          add      hl,bc
        add.w   d2,d4
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          ld       (&_smc1+1),a
        move.b  d7,_smc1+1+2-$10000(a0)
**** Original Line: 
**** Original Line:          ld       hl,GRAPH_MEM
        move.w  #GRAPH_MEM+0,d4
**** Original Line: 
**** Original Line:          ld       a,e
        move.b  d3,d7
**** Original Line:          add      a,a
        add.b   d7,d7
**** Original Line:          add      a,e
        add.b   d3,d7
**** Original Line:          add      a,a
        add.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          rl       b
        move.w  d2,(a1)
        move.b  (a1),d1
        move.b  (a0),ccr
        roxl.b  #1,d1
        move.b  d1,(a1)
        move.w  (a1),d2
**** Original Line:          add      a,a
        add.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          rl       b
        move.w  d2,(a1)
        move.b  (a1),d1
        move.b  (a0),ccr
        roxl.b  #1,d1
        move.b  d1,(a1)
        move.w  (a1),d2
**** Original Line:          srl      d
        move.w  d3,(a1)
        move.b  (a1),d1
        lsr.b   #1,d1
        move.b  d1,(a1)
        move.w  (a1),d3
**** Original Line:          srl      d
        move.w  d3,(a1)
        move.b  (a1),d1
        lsr.b   #1,d1
        move.b  d1,(a1)
        move.w  (a1),d3
**** Original Line:          srl      d
        move.w  d3,(a1)
        move.b  (a1),d1
        lsr.b   #1,d1
        move.b  d1,(a1)
        move.w  (a1),d3
**** Original Line:          add      a,d
        move.w  d3,(a1)
        add.b   (a1),d7
        move.w  sr,(a0)
**** Original Line:          jr       nc,_n1
        bcc   RA__n1
**** Original Line:          inc      b
        add.w   #$100,d2
**** Original Line: _n1:     ld       c,a
        __LABEL _n1
        move.b  d7,d2
**** Original Line:          add      hl,bc                                    
        add.w   d2,d4
**** Original Line:           
**** Original Line:          ld       d,(ix)       
        __ADDR  5
        move.b  (a5),d1
        asl.w   #8,d1
        and.w   #$ff,d3
        or.w    d1,d3
**** Original Line:          ld       b,(ix+1)        
        __ADDR  5
        move.b  1(a5),d1
        asl.w   #8,d1
        and.w   #$ff,d2
        or.w    d1,d2
**** Original Line: _oloop:  push     bc                         ;Save # of rows
        __LABEL _oloop
        move.w  d2,-(sp)
**** Original Line:          push     hl                         ;Save screen address
        move.w  d4,-(sp)
**** Original Line:          ld       b,d                        ;Load width
        move.w  d3,d1
        and.w   #$ff00,d1
        and.w   #$ff,d2
        or.w    d1,d2
**** Original Line:          ld       c,(ix+2)                   ;Load one line of image
        __ADDR  5
        move.b  2(a5),d2
**** Original Line:          inc      ix
        addq.w  #1,d5
**** Original Line: _smc1    ld       a,1                        ;Load pixel mask
        __LABEL _smc1
        move.b  #1,d7
**** Original Line: _iloop:  sla      c                          ;Test leftmost pixel
        __LABEL _iloop
        add.b   d2,d2
        move.w  sr,(a0)
**** Original Line:          jr       nc,_noplot                 ;See if a plot is needed
        bcc   RA__noplot
**** Original Line:          ld       e,a                        ;OR pixel with screen
        move.b  d7,d3
**** Original Line:          or       (hl)
        __ADDR  4
        or.b   (a4),d7
**** Original Line:          ld       (hl),a
        ;__ADDR 4
        move.b  d7,(a4)
**** Original Line:          ld       a,e
        move.b  d3,d7
**** Original Line: _noplot: rrca
        __LABEL _noplot
        ror.b   #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       nc,_notedge                ;Test if edge of byte reached
        move.b  (a0),ccr
        bcc   RA__notedge
**** Original Line:          inc      hl                         ;Go to next byte
        addq.w  #1,d4
**** Original Line: _notedge:djnz     _iloop
        __LABEL _notedge
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA__iloop
**** Original Line:          pop      hl                         ;Restore address
        move.w  (sp)+,d4
**** Original Line:          ld       bc,12                      ;Go to next line
        move.w  #12+0,d2
**** Original Line:          add      hl,bc
        add.w   d2,d4
**** Original Line:          pop      bc                         ;Restore data
        move.w  (sp)+,d2
**** Original Line:          djnz     _oloop
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA__oloop
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line: drw_sprw:
        __LABEL drw_sprw
**** Original Line:          ld       a,d
        move.w  d3,(a1)
        move.b  (a1),d7
**** Original Line:          and      7
        and.b   #7,d7
**** Original Line:          ld       hl,&offsets_table
        move.w  #offsets_table+0,d4
**** Original Line:          ld       c,a
        move.b  d7,d2
**** Original Line:          ld       b,0
        and.w   #$ff,d2
**** Original Line:          add      hl,bc
        add.w   d2,d4
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          ld       (&wsmc1+1),a
        move.b  d7,wsmc1+1+2-$10000(a0)
**** Original Line:          ld       (&wsmc2+1),a
        move.b  d7,wsmc2+1+2-$10000(a0)
**** Original Line: 
**** Original Line:          ld       hl,GRAPH_MEM
        move.w  #GRAPH_MEM+0,d4
**** Original Line: 
**** Original Line:          ld       a,e
        move.b  d3,d7
**** Original Line:          add      a,a
        add.b   d7,d7
**** Original Line:          add      a,e
        add.b   d3,d7
**** Original Line:          add      a,a
        add.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          rl       b
        move.w  d2,(a1)
        move.b  (a1),d1
        move.b  (a0),ccr
        roxl.b  #1,d1
        move.b  d1,(a1)
        move.w  (a1),d2
**** Original Line:          add      a,a
        add.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          rl       b
        move.w  d2,(a1)
        move.b  (a1),d1
        move.b  (a0),ccr
        roxl.b  #1,d1
        move.b  d1,(a1)
        move.w  (a1),d2
**** Original Line:          srl      d
        move.w  d3,(a1)
        move.b  (a1),d1
        lsr.b   #1,d1
        move.b  d1,(a1)
        move.w  (a1),d3
**** Original Line:          srl      d
        move.w  d3,(a1)
        move.b  (a1),d1
        lsr.b   #1,d1
        move.b  d1,(a1)
        move.w  (a1),d3
**** Original Line:          srl      d
        move.w  d3,(a1)
        move.b  (a1),d1
        lsr.b   #1,d1
        move.b  d1,(a1)
        move.w  (a1),d3
**** Original Line:          add      a,d
        move.w  d3,(a1)
        add.b   (a1),d7
        move.w  sr,(a0)
**** Original Line:          jr       nc,n1
        bcc   RA_n1
**** Original Line:          inc      b
        add.w   #$100,d2
**** Original Line: n1:      ld       c,a
        __LABEL n1
        move.b  d7,d2
**** Original Line:          add      hl,bc                                    
        add.w   d2,d4
**** Original Line:           
**** Original Line:          ld       d,(ix)       
        __ADDR  5
        move.b  (a5),d1
        asl.w   #8,d1
        and.w   #$ff,d3
        or.w    d1,d3
**** Original Line:          ld       b,(ix+1)        
        __ADDR  5
        move.b  1(a5),d1
        asl.w   #8,d1
        and.w   #$ff,d2
        or.w    d1,d2
**** Original Line: woloop:  push     bc                         ;Save # of rows
        __LABEL woloop
        move.w  d2,-(sp)
**** Original Line:          push     hl                         ;Save screen address
        move.w  d4,-(sp)
**** Original Line:          ld       b,d                        ;Load width
        move.w  d3,d1
        and.w   #$ff00,d1
        and.w   #$ff,d2
        or.w    d1,d2
**** Original Line:          ld       c,(ix+2)                   ;Load one line of image
        __ADDR  5
        move.b  2(a5),d2
**** Original Line:          inc      ix
        addq.w  #1,d5
**** Original Line: wsmc1    ld       a,1                        ;Load pixel mask
        __LABEL wsmc1
        move.b  #1,d7
**** Original Line: wiloop:  sla      c                          ;Test leftmost pixel
        __LABEL wiloop
        add.b   d2,d2
        move.w  sr,(a0)
**** Original Line:          jr       nc,wnoplot                 ;See if a plot is needed
        bcc   RA_wnoplot
**** Original Line:          ld       e,a                        ;OR pixel with screen
        move.b  d7,d3
**** Original Line:          or       (hl)
        __ADDR  4
        or.b   (a4),d7
**** Original Line:          ld       (hl),a
        ;__ADDR 4
        move.b  d7,(a4)
**** Original Line:          ld       a,e
        move.b  d3,d7
**** Original Line: wnoplot: rrca
        __LABEL wnoplot
        ror.b   #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       nc,wnotedge                ;Test if edge of byte reached
        move.b  (a0),ccr
        bcc   RA_wnotedge
**** Original Line:          inc      hl                         ;Go to next byte
        addq.w  #1,d4
**** Original Line: wnotedge
        __LABEL wnotedge
**** Original Line: wsmc2:   cp       1
        __LABEL wsmc2
        cmp.b   #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,wover_1
        beq   RA_wover_1
**** Original Line: 
**** Original Line:          djnz     wiloop
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_wiloop
**** Original Line:          pop      hl                         ;Restore address
        move.w  (sp)+,d4
**** Original Line:          ld       bc,12                      ;Go to next line
        move.w  #12+0,d2
**** Original Line:          add      hl,bc
        add.w   d2,d4
**** Original Line:          pop      bc                         ;Restore data
        move.w  (sp)+,d2
**** Original Line:          djnz     woloop
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_woloop
**** Original Line:          ret
        __RTS
**** Original Line: wover_1: ld       c,(ix+2)
        __LABEL wover_1
        __ADDR  5
        move.b  2(a5),d2
**** Original Line:          inc      ix
        addq.w  #1,d5
**** Original Line:          djnz     wiloop
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_wiloop
**** Original Line:          dec      ix
        subq.w  #1,d5
**** Original Line:          pop      hl
        move.w  (sp)+,d4
**** Original Line:          ld       bc,12
        move.w  #12+0,d2
**** Original Line:          add      hl,bc
        add.w   d2,d4
**** Original Line:          pop      bc
        move.w  (sp)+,d2
**** Original Line:          djnz     woloop
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_woloop
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line:  ; *************** Enter Next Level *****************************************
**** Original Line: 
**** Original Line: Next_Level:
        __LABEL Next_Level
**** Original Line:          ld       hl,enemies
        move.w  #enemies+0,d4
**** Original Line:          ld       bc,80
        move.w  #80+0,d2
**** Original Line:          call     OTH_CLEAR
        jsr     ti85lib3@0014
**** Original Line: 
**** Original Line:          xor      a
        eor.b   d7,d7
**** Original Line:          ld       (timer),a
        move.b  d7,timer-$10000(a0)
**** Original Line:          ld       hl,(score)
        move.b  1+score-$10000(a0),d4
        asl.w   #8,d4
        move.b  score-$10000(a0),d4
**** Original Line:          ld       de,200
        move.w  #200+0,d3
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          ld       (score),hl
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,score-$10000(a0)
        move.b  d0,1+score-$10000(a0)
**** Original Line:          ld       hl,level
        move.w  #level+0,d4
        lea     level-$10000(a0),a4
**** Original Line:          inc      (hl)
        ;__ADDR 4
        addq.b  #1,(a4)
**** Original Line:          ld       a,(hl)
        ;__ADDR 4
        move.b  (a4),d7
**** Original Line: 
**** Original Line:          cp       21
        cmp.b   #21,d7
        move.w  sr,(a0)
**** Original Line:          jp       z,&won
        beq   RA_won
**** Original Line: 
**** Original Line:          call     &Update_Level_Number
        __JSR   RA_Update_Level_Number
**** Original Line: 
**** Original Line:          call     &Load_Level_Data
        __JSR   RA_Load_Level_Data
**** Original Line: 
**** Original Line:          jp       (hl)
        __ADDR  4
       jmp     (a4)
**** Original Line: 
**** Original Line:  ; *************** Give Victory Bonus ***************************************
**** Original Line: 
**** Original Line: won:     pop      af
        __LABEL won
        move.w  (sp)+,d1
        move.b  d1,1(a0)
        lsr.w   #8,d1
        move.b  d1,d7
**** Original Line:          ld       hl,(score)
        move.b  1+score-$10000(a0),d4
        asl.w   #8,d4
        move.b  score-$10000(a0),d4
**** Original Line:          ld       de,5000
        move.w  #5000+0,d3
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          ld       (score),hl
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,score-$10000(a0)
        move.b  d0,1+score-$10000(a0)
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line:  ; *************** Load a Level Data Bank ***********************************
**** Original Line: 
**** Original Line: Load_Level_Data:
        __LABEL Load_Level_Data
**** Original Line:          ld       hl,(level)
        move.b  1+level-$10000(a0),d4
        asl.w   #8,d4
        move.b  level-$10000(a0),d4
**** Original Line:          add      hl,hl
        add.w   d4,d4
**** Original Line:          ld       bc,&levels_jump_table-2
        move.w  #levels_jump_table-2+0,d2
**** Original Line:          add      hl,bc
        add.w   d2,d4
**** Original Line:          call     LD_HL_MHL
        jsr     ti85lib3@000A
**** Original Line:          ld       bc,(PROGRAM_ADDR)
        move.b  1+PROGRAM_ADDR-$10000(a0),d2
        asl.w   #8,d2
        move.b  PROGRAM_ADDR-$10000(a0),d2
**** Original Line:          add      hl,bc
        add.w   d2,d4
**** Original Line:          ld       e,1
        move.b  #1,d3
**** Original Line:          jp       (hl)
        __ADDR  4
       jmp     (a4)
**** Original Line: 
**** Original Line:  ; *************** Level Data Loaders ***************************************         
**** Original Line: 
**** Original Line: levels_jump_table:
        __LABEL levels_jump_table
**** Original Line:          .dw      level1                     ;20xEnemy 1
        __DW    level1
**** Original Line:          .dw      level2                     ;20xEnemy 1 
        __DW    level2
**** Original Line:          .dw      level3                     ;20xEnemy 1 & Boss 1
        __DW    level3
**** Original Line:          .dw      level4                     ;13xEnemy 1 & 7xEnemy 2
        __DW    level4
**** Original Line:          .dw      level5                     ;10xCross       
        __DW    level5
**** Original Line:          .dw      level6                     ;20xEnemy 2
        __DW    level6
**** Original Line:          .dw      level7                     ;20xEnemy 2 & Boss 2
        __DW    level7
**** Original Line:          .dw      level8                     ;13xEnemy 1 & 7xEnemy 3
        __DW    level8
**** Original Line:          .dw      level9                     ;10xCross
        __DW    level9
**** Original Line:          .dw      level10                    ;20xEnemy 3
        __DW    level10
**** Original Line:          .dw      level11                    ;20xEnemy 3 & Boss 2
        __DW    level11
**** Original Line:          .dw      level12                    ;13xEnemy 1 & 7xEnemy 4
        __DW    level12
**** Original Line:          .dw      level13                    ;10xCross
        __DW    level13
**** Original Line:          .dw      level14                    ;20xEnemy 4
        __DW    level14
**** Original Line:          .dw      level17                    ;10xO enemies
        __DW    level17
**** Original Line:          .dw      level15                    ;20xEnemy 4 & Boss 2
        __DW    level15
**** Original Line:          .dw      level17                    ;10xO enemies
        __DW    level17
**** Original Line:          .dw      level16                    ;Super-Boss & 8xEnemy 1
        __DW    level16
**** Original Line:          .dw      level17                    ;10xO enemies
        __DW    level17
**** Original Line:          .dw      level18                    ;Super-Boss & 8xEnemy 2
        __DW    level18
**** Original Line: 
**** Original Line: load_coordinates:
        __LABEL load_coordinates
**** Original Line:          ld       (enemy_image),bc
        move.w  d2,d0
        lsr.w   #8,d0
        move.b  d2,enemy_image-$10000(a0)
        move.b  d0,1+enemy_image-$10000(a0)
**** Original Line:          ld       (boss_image),de
        move.w  d3,d0
        lsr.w   #8,d0
        move.b  d3,boss_image-$10000(a0)
        move.b  d0,1+boss_image-$10000(a0)
**** Original Line:          LD       (enemy_pwr),a
        move.b  d7,enemy_pwr-$10000(a0)
**** Original Line:          ld       de,enemy_coords
        move.w  #enemy_coords+0,d3
**** Original Line:          ld       bc,40
        move.w  #40+0,d2
**** Original Line:          ldir
        __LDIR
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line: level1:                                      ;Levels with one type of enemy
        __LABEL level1
**** Original Line:          ld       hl,&Level1Pattern
        move.w  #Level1Pattern+0,d4
**** Original Line: level1_: ld       a,1
        __LABEL level1_
        move.b  #1,d7
**** Original Line:          ld       bc,&spr_enemy_1
        move.w  #spr_enemy_1+0,d2
**** Original Line: level1__:
        __LABEL level1__
**** Original Line:          call     &load_coordinates
        __JSR   RA_load_coordinates
**** Original Line:          ld       hl,&setup_standard
        move.w  #setup_standard+0,d4
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line: level2:
        __LABEL level2
**** Original Line:          ld       hl,&Level2Pattern
        move.w  #Level2Pattern+0,d4
**** Original Line:          jr       level1_
        bra     RA_level1_
**** Original Line: 
**** Original Line: level6:
        __LABEL level6
**** Original Line:          ld       hl,&Level6Pattern
        move.w  #Level6Pattern+0,d4
**** Original Line:          ld       a,2
        move.b  #2,d7
**** Original Line:          ld       bc,&spr_enemy_2
        move.w  #spr_enemy_2+0,d2
**** Original Line:          jr       level1__
        bra     RA_level1__
**** Original Line: 
**** Original Line: level10: ld       a,3
        __LABEL level10
        move.b  #3,d7
**** Original Line:          ld       bc,&spr_enemy_3
        move.w  #spr_enemy_3+0,d2
**** Original Line: level10_:
        __LABEL level10_
**** Original Line:          ld       hl,&Level10Pattern
        move.w  #Level10Pattern+0,d4
**** Original Line:          jr       level1__
        bra     RA_level1__
**** Original Line: 
**** Original Line: level14: ld       a,4
        __LABEL level14
        move.b  #4,d7
**** Original Line:          ld       bc,&spr_enemy_4
        move.w  #spr_enemy_4+0,d2
**** Original Line:          jr       level10_
        bra     RA_level10_
**** Original Line: 
**** Original Line: level3:                                      ;Levels with bosses
        __LABEL level3
**** Original Line:          ld       hl,&Level3Pattern
        move.w  #Level3Pattern+0,d4
**** Original Line:          ld       a,1
        move.b  #1,d7
**** Original Line:          ld       bc,&spr_enemy_1
        move.w  #spr_enemy_1+0,d2
**** Original Line:          ld       de,&spr_boss_1
        move.w  #spr_boss_1+0,d3
**** Original Line: level3_:
        __LABEL level3_
**** Original Line:          call     &load_coordinates
        __JSR   RA_load_coordinates
**** Original Line:          ld       hl,&setup_boss
        move.w  #setup_boss+0,d4
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line: level7:
        __LABEL level7
**** Original Line:          ld       hl,&Level7Pattern
        move.w  #Level7Pattern+0,d4
**** Original Line:          ld       a,2
        move.b  #2,d7
**** Original Line:          ld       bc,&spr_enemy_2
        move.w  #spr_enemy_2+0,d2
**** Original Line: level7_:
        __LABEL level7_
**** Original Line:          ld       de,&spr_boss_2
        move.w  #spr_boss_2+0,d3
**** Original Line:          jr       level3_
        bra     RA_level3_
**** Original Line: 
**** Original Line: level11: ld       a,3
        __LABEL level11
        move.b  #3,d7
**** Original Line:          ld       bc,&spr_enemy_3
        move.w  #spr_enemy_3+0,d2
**** Original Line: level11_:
        __LABEL level11_
**** Original Line:          ld       hl,&Level11Pattern
        move.w  #Level11Pattern+0,d4
**** Original Line:          jr       level7_
        bra     RA_level7_
**** Original Line: 
**** Original Line: level15: ld       a,4
        __LABEL level15
        move.b  #4,d7
**** Original Line:          ld       bc,&spr_enemy_4
        move.w  #spr_enemy_4+0,d2
**** Original Line:          jr       level11_
        bra     RA_level11_
**** Original Line: 
**** Original Line: level4:                                      ;Levels with two enemy types
        __LABEL level4
**** Original Line:          ld       hl,&Level4Pattern
        move.w  #Level4Pattern+0,d4
**** Original Line:          ld       a,2
        move.b  #2,d7
**** Original Line:          ld       bc,&spr_enemy_2
        move.w  #spr_enemy_2+0,d2
**** Original Line: level4_:
        __LABEL level4_
**** Original Line:          ld       e,-1
        move.b  #-1,d3
**** Original Line:          call     &load_coordinates
        __JSR   RA_load_coordinates
**** Original Line:          ld       hl,&setup_weak
        move.w  #setup_weak+0,d4
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line: level8:  ld       a,3
        __LABEL level8
        move.b  #3,d7
**** Original Line:          ld       bc,&spr_enemy_3
        move.w  #spr_enemy_3+0,d2
**** Original Line: level8_:
        __LABEL level8_
**** Original Line:          ld       hl,&Level8Pattern
        move.w  #Level8Pattern+0,d4
**** Original Line:          jr       level4_
        bra     RA_level4_
**** Original Line: 
**** Original Line: level12: ld       a,4
        __LABEL level12
        move.b  #4,d7
**** Original Line:          ld       bc,&spr_enemy_4
        move.w  #spr_enemy_4+0,d2
**** Original Line:          jr       level8_
        bra     RA_level8_
**** Original Line: 
**** Original Line: level5:                                      ;Levels with cross enemies
        __LABEL level5
**** Original Line: level9:
        __LABEL level9
**** Original Line: level13:
        __LABEL level13
**** Original Line:          ld       a,5
        move.b  #5,d7
**** Original Line:          ld       (enemy_pwr),a
        move.b  d7,enemy_pwr-$10000(a0)
**** Original Line:          ld       hl,&enemy_warped
        move.w  #enemy_warped+0,d4
**** Original Line:          ld       (enemy_image),hl
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,enemy_image-$10000(a0)
        move.b  d0,1+enemy_image-$10000(a0)
**** Original Line:          ld       (boss_image),hl
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,boss_image-$10000(a0)
        move.b  d0,1+boss_image-$10000(a0)
**** Original Line:          ld       hl,&setup_cross
        move.w  #setup_cross+0,d4
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line: level17:
        __LABEL level17
**** Original Line:          ld       a,8
        move.b  #8,d7
**** Original Line:          ld       (enemy_pwr),a
        move.b  d7,enemy_pwr-$10000(a0)
**** Original Line:          ld       hl,&enemy_o
        move.w  #enemy_o+0,d4
**** Original Line:          ld       (enemy_image),hl
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,enemy_image-$10000(a0)
        move.b  d0,1+enemy_image-$10000(a0)
**** Original Line:          ld       (boss_image),hl
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,boss_image-$10000(a0)
        move.b  d0,1+boss_image-$10000(a0)
**** Original Line:          ld       hl,&setup_o
        move.w  #setup_o+0,d4
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line: level16: ld       a,1
        __LABEL level16
        move.b  #1,d7
**** Original Line:          ld       bc,&spr_enemy_1
        move.w  #spr_enemy_1+0,d2
**** Original Line: level16_:
        __LABEL level16_
**** Original Line:          ld       hl,&Level1Pattern
        move.w  #Level1Pattern+0,d4
**** Original Line:          ld       de,&spr_boss_3
        move.w  #spr_boss_3+0,d3
**** Original Line:          call     &load_coordinates
        __JSR   RA_load_coordinates
**** Original Line:          ld       hl,&setup_super
        move.w  #setup_super+0,d4
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line: level18: ld       a,4
        __LABEL level18
        move.b  #4,d7
**** Original Line:          ld       bc,&spr_enemy_4
        move.w  #spr_enemy_4+0,d2
**** Original Line:          jr       level16_
        bra     RA_level16_
**** Original Line: 
**** Original Line:  ; *************** Level Set-Up Routines ************************************
**** Original Line: 
**** Original Line: setup_standard:
        __LABEL setup_standard
**** Original Line:          ld       a,20
        move.b  #20,d7
**** Original Line: setup_common:
        __LABEL setup_common
**** Original Line:          ld       b,20
        and.w   #$ff,d2
        or.w    #(20)<<8,d2
**** Original Line: put8:    ld       hl,enemies_remaining
        __LABEL put8
        move.w  #enemies_remaining+0,d4
        lea     enemies_remaining-$10000(a0),a4
**** Original Line:          ld       (hl),a
        ;__ADDR 4
        move.b  d7,(a4)
**** Original Line:          ld       hl,enemies
        move.w  #enemies+0,d4
**** Original Line:          ld       c,1
        move.b  #1,d2
**** Original Line:          ld       a,(enemy_pwr)
        move.b  enemy_pwr-$10000(a0),d7
**** Original Line:          ld       d,110
        and.w   #$ff,d3
        or.w    #(110)<<8,d3
**** Original Line: lle:     ld       (hl),c
        __LABEL lle
        __ADDR  4
        move.b  d2,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          ld       (hl),a
        ;__ADDR 4
        move.b  d7,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          ld       (hl),d
        ;__ADDR 4
        move.w  d3,(a1)
        move.b  (a1),(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          ld       (hl),d
        ;__ADDR 4
        move.w  d3,(a1)
        move.b  (a1),(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          djnz     lle
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_lle
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line: setup_boss:
        __LABEL setup_boss
**** Original Line:          ld       hl,&bhsmc1+1
        move.w  #bhsmc1+1+2,d4
        lea     bhsmc1+1+2-$10000(a0),a4
**** Original Line:          ld       (hl),15
        ;__ADDR 4
        move.b  #15,(a4)
**** Original Line:          ld       hl,&bhsmc2+1
        move.w  #bhsmc2+1+2,d4
        lea     bhsmc2+1+2-$10000(a0),a4
**** Original Line:          ld       (hl),18
        ;__ADDR 4
        move.b  #18,(a4)
**** Original Line:          ld       hl,boss_status
        move.w  #boss_status+0,d4
        lea     boss_status-$10000(a0),a4
**** Original Line:          ld       (hl),1
        ;__ADDR 4
        move.b  #1,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          ld       (hl),10
        ;__ADDR 4
        move.b  #10,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          ld       (HL),30
        ;__ADDR 4
        move.b  #30,(a4)
**** Original Line:          INC      HL
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          LD       (HL),0
        ;__ADDR 4
        move.b  #0,(a4)
**** Original Line:          ld       a,21
        move.b  #21,d7
**** Original Line:          jr       setup_common
        bra     RA_setup_common
**** Original Line: 
**** Original Line: setup_weak:
        __LABEL setup_weak
**** Original Line:          call     &setup_standard
        __JSR   RA_setup_standard
**** Original Line:          ld       hl,enemies+1
        move.w  #enemies+1+0,d4
**** Original Line:          ld       b,13
        and.w   #$ff,d2
        or.w    #(13)<<8,d2
**** Original Line: weak:    ld       (hl),1
        __LABEL weak
        __ADDR  4
        move.b  #1,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          djnz     weak
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_weak
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line: setup_o:
        __LABEL setup_o
**** Original Line: setup_cross:
        __LABEL setup_cross
**** Original Line:          ld       a,10
        move.b  #10,d7
**** Original Line:          ld       (enemies_remaining),a
        move.b  d7,enemies_remaining-$10000(a0)
**** Original Line:          ld       b,a
        move.w  d2,(a1)
        move.b  d7,(a1)
        move.w  (a1),d2
**** Original Line:          ld       hl,enemies
        move.w  #enemies+0,d4
**** Original Line: generate_warp_enemies:
        __LABEL generate_warp_enemies
**** Original Line:          ld       (hl),13
        __ADDR  4
        move.b  #13,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          ld       a,(enemy_pwr)
        move.b  enemy_pwr-$10000(a0),d7
**** Original Line:          ld       (hl),a
        ;__ADDR 4
        move.b  d7,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          ld       a,r
        __RAND
**** Original Line:          and      63
        and.b   #63,d7
**** Original Line:          add      a,10
        add.b   #10,d7
**** Original Line:          ld       (hl),a
        ;__ADDR 4
        move.b  d7,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          xor      a
        eor.b   d7,d7
**** Original Line:          ld       (hl),a
        ;__ADDR 4
        move.b  d7,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          ld       (hl),a
        ;__ADDR 4
        move.b  d7,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          inc      a
        addq.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          ld       (hl),a
        ;__ADDR 4
        move.b  d7,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          ld       (hl),a
        ;__ADDR 4
        move.b  d7,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          djnz     generate_warp_enemies
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_generate_warp_enemies
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line: setup_super:
        __LABEL setup_super
**** Original Line:          ld       b,8
        and.w   #$ff,d2
        or.w    #(8)<<8,d2
**** Original Line:          ld       a,9
        move.b  #9,d7
**** Original Line:          call     &put8
        __JSR   RA_put8
**** Original Line:          ld       hl,&bhsmc1+1
        move.w  #bhsmc1+1+2,d4
        lea     bhsmc1+1+2-$10000(a0),a4
**** Original Line:          ld       (hl),31
        ;__ADDR 4
        move.b  #31,(a4)
**** Original Line:          ld       hl,&bhsmc2+1
        move.w  #bhsmc2+1+2,d4
        lea     bhsmc2+1+2-$10000(a0),a4
**** Original Line:          ld       (hl),34
        ;__ADDR 4
        move.b  #34,(a4)
**** Original Line:          ld       hl,boss_status
        move.w  #boss_status+0,d4
        lea     boss_status-$10000(a0),a4
**** Original Line:          ld       (hl),5
        ;__ADDR 4
        move.b  #5,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          ld       (hl),98
        ;__ADDR 4
        move.b  #98,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          ld       (HL),2
        ;__ADDR 4
        move.b  #2,(a4)
**** Original Line:          INC      HL
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          LD       (HL),0
        ;__ADDR 4
        move.b  #0,(a4)
**** Original Line:          ret
        __RTS
**** Original Line: 
**** Original Line:  ; *************** Level Data ***********************************************
**** Original Line: 
**** Original Line: Level1Pattern:
        __LABEL Level1Pattern
**** Original Line:          .db      10,16,20,16,30,16,40,16,50,16
        dc.b    10
        dc.b    16
        dc.b    20
        dc.b    16
        dc.b    30
        dc.b    16
        dc.b    40
        dc.b    16
        dc.b    50
        dc.b    16
**** Original Line:          .db      5,24,15,24,25,24,35,24,45,24
        dc.b    5
        dc.b    24
        dc.b    15
        dc.b    24
        dc.b    25
        dc.b    24
        dc.b    35
        dc.b    24
        dc.b    45
        dc.b    24
**** Original Line:          .db      50,32,10,32,20,32,30,32,40,32
        dc.b    50
        dc.b    32
        dc.b    10
        dc.b    32
        dc.b    20
        dc.b    32
        dc.b    30
        dc.b    32
        dc.b    40
        dc.b    32
**** Original Line:          .db      5,40,15,40,25,40,35,40,45,40
        dc.b    5
        dc.b    40
        dc.b    15
        dc.b    40
        dc.b    25
        dc.b    40
        dc.b    35
        dc.b    40
        dc.b    45
        dc.b    40
**** Original Line: 
**** Original Line: Level2Pattern:
        __LABEL Level2Pattern
**** Original Line:          .db      1,16,14,16,27,16,40,16,53,16
        dc.b    1
        dc.b    16
        dc.b    14
        dc.b    16
        dc.b    27
        dc.b    16
        dc.b    40
        dc.b    16
        dc.b    53
        dc.b    16
**** Original Line:          .db      1,24,14,24,27,24,40,24,53,24
        dc.b    1
        dc.b    24
        dc.b    14
        dc.b    24
        dc.b    27
        dc.b    24
        dc.b    40
        dc.b    24
        dc.b    53
        dc.b    24
**** Original Line:          .db      1,32,14,32,27,32,40,32,53,32
        dc.b    1
        dc.b    32
        dc.b    14
        dc.b    32
        dc.b    27
        dc.b    32
        dc.b    40
        dc.b    32
        dc.b    53
        dc.b    32
**** Original Line:          .db      1,40,14,40,27,40,40,40,53,40
        dc.b    1
        dc.b    40
        dc.b    14
        dc.b    40
        dc.b    27
        dc.b    40
        dc.b    40
        dc.b    40
        dc.b    53
        dc.b    40
**** Original Line: 
**** Original Line: Level3Pattern:
        __LABEL Level3Pattern
**** Original Line:          .db      1,26,14,26,27,26,40,26,53,26
        dc.b    1
        dc.b    26
        dc.b    14
        dc.b    26
        dc.b    27
        dc.b    26
        dc.b    40
        dc.b    26
        dc.b    53
        dc.b    26
**** Original Line:          .db      1,34,14,34,27,34,40,34,53,34
        dc.b    1
        dc.b    34
        dc.b    14
        dc.b    34
        dc.b    27
        dc.b    34
        dc.b    40
        dc.b    34
        dc.b    53
        dc.b    34
**** Original Line:          .db      1,42,14,42,27,42,40,42,53,42
        dc.b    1
        dc.b    42
        dc.b    14
        dc.b    42
        dc.b    27
        dc.b    42
        dc.b    40
        dc.b    42
        dc.b    53
        dc.b    42
**** Original Line:          .db      1,50,14,50,27,50,40,50,53,50
        dc.b    1
        dc.b    50
        dc.b    14
        dc.b    50
        dc.b    27
        dc.b    50
        dc.b    40
        dc.b    50
        dc.b    53
        dc.b    50
**** Original Line: 
**** Original Line: Level4Pattern:
        __LABEL Level4Pattern
**** Original Line:          .db      5,18,13,18,21,18,29,18,37,18,45,18,53,18
        dc.b    5
        dc.b    18
        dc.b    13
        dc.b    18
        dc.b    21
        dc.b    18
        dc.b    29
        dc.b    18
        dc.b    37
        dc.b    18
        dc.b    45
        dc.b    18
        dc.b    53
        dc.b    18
**** Original Line:          .db      9,28,17,28,25,28,33,28,41,28,49,28
        dc.b    9
        dc.b    28
        dc.b    17
        dc.b    28
        dc.b    25
        dc.b    28
        dc.b    33
        dc.b    28
        dc.b    41
        dc.b    28
        dc.b    49
        dc.b    28
**** Original Line:          .db      5,38,13,38,21,38,29,38,37,38,45,38,53,38
        dc.b    5
        dc.b    38
        dc.b    13
        dc.b    38
        dc.b    21
        dc.b    38
        dc.b    29
        dc.b    38
        dc.b    37
        dc.b    38
        dc.b    45
        dc.b    38
        dc.b    53
        dc.b    38
**** Original Line: 
**** Original Line: Level6Pattern:
        __LABEL Level6Pattern
**** Original Line:          .db      53,28
        dc.b    53
        dc.b    28
**** Original Line:          .db      52,32
        dc.b    52
        dc.b    32
**** Original Line:          .db      48,35
        dc.b    48
        dc.b    35
**** Original Line:          .db      42,38
        dc.b    42
        dc.b    38
**** Original Line:          .db      35,39
        dc.b    35
        dc.b    39
**** Original Line:          .db      27,40
        dc.b    27
        dc.b    40
**** Original Line:          .DB      19,39
        dc.b    19
        dc.b    39
**** Original Line:          .DB      12,38
        dc.b    12
        dc.b    38
**** Original Line:          .DB      6,35
        dc.b    6
        dc.b    35
**** Original Line:          .db      2,32
        dc.b    2
        dc.b    32
**** Original Line:          .db      1,28
        dc.b    1
        dc.b    28
**** Original Line:          .db      2,24
        dc.b    2
        dc.b    24
**** Original Line:          .DB      6,21
        dc.b    6
        dc.b    21
**** Original Line:          .DB      12,18
        dc.b    12
        dc.b    18
**** Original Line:          .DB      19,17
        dc.b    19
        dc.b    17
**** Original Line:          .DB      27,16
        dc.b    27
        dc.b    16
**** Original Line:          .DB      35,17
        dc.b    35
        dc.b    17
**** Original Line:          .DB      42,18
        dc.b    42
        dc.b    18
**** Original Line:          .DB      48,21
        dc.b    48
        dc.b    21
**** Original Line:          .db      52,24
        dc.b    52
        dc.b    24
**** Original Line: 
**** Original Line: Level7Pattern:
        __LABEL Level7Pattern
**** Original Line:          .db      1,26,14,26,27,26,40,26,53,26
        dc.b    1
        dc.b    26
        dc.b    14
        dc.b    26
        dc.b    27
        dc.b    26
        dc.b    40
        dc.b    26
        dc.b    53
        dc.b    26
**** Original Line:          .db      1,34,14,34,27,34,40,34,53,34
        dc.b    1
        dc.b    34
        dc.b    14
        dc.b    34
        dc.b    27
        dc.b    34
        dc.b    40
        dc.b    34
        dc.b    53
        dc.b    34
**** Original Line:          .db      1,42,14,42,27,42,40,42,53,42
        dc.b    1
        dc.b    42
        dc.b    14
        dc.b    42
        dc.b    27
        dc.b    42
        dc.b    40
        dc.b    42
        dc.b    53
        dc.b    42
**** Original Line:          .db      1,50,14,50,27,50,40,50,53,50
        dc.b    1
        dc.b    50
        dc.b    14
        dc.b    50
        dc.b    27
        dc.b    50
        dc.b    40
        dc.b    50
        dc.b    53
        dc.b    50
**** Original Line: 
**** Original Line: Level8Pattern:
        __LABEL Level8Pattern
**** Original Line:          .db      5,18,13,18,21,18,29,18,37,18,45,18,53,18
        dc.b    5
        dc.b    18
        dc.b    13
        dc.b    18
        dc.b    21
        dc.b    18
        dc.b    29
        dc.b    18
        dc.b    37
        dc.b    18
        dc.b    45
        dc.b    18
        dc.b    53
        dc.b    18
**** Original Line:          .db      9,28,17,28,25,28,33,28,41,28,49,28
        dc.b    9
        dc.b    28
        dc.b    17
        dc.b    28
        dc.b    25
        dc.b    28
        dc.b    33
        dc.b    28
        dc.b    41
        dc.b    28
        dc.b    49
        dc.b    28
**** Original Line:          .db      5,38,13,38,21,38,29,38,37,38,45,38,53,38
        dc.b    5
        dc.b    38
        dc.b    13
        dc.b    38
        dc.b    21
        dc.b    38
        dc.b    29
        dc.b    38
        dc.b    37
        dc.b    38
        dc.b    45
        dc.b    38
        dc.b    53
        dc.b    38
**** Original Line: 
**** Original Line: Level10Pattern:
        __LABEL Level10Pattern
**** Original Line:          .DB      01,16,01,22,01,28,01,34,01,40
        dc.b    01
        dc.b    16
        dc.b    01
        dc.b    22
        dc.b    01
        dc.b    28
        dc.b    01
        dc.b    34
        dc.b    01
        dc.b    40
**** Original Line:          .DB      19,16,19,22,19,28,19,34,19,40
        dc.b    19
        dc.b    16
        dc.b    19
        dc.b    22
        dc.b    19
        dc.b    28
        dc.b    19
        dc.b    34
        dc.b    19
        dc.b    40
**** Original Line:          .db      37,16,37,22,37,28,37,34,37,40
        dc.b    37
        dc.b    16
        dc.b    37
        dc.b    22
        dc.b    37
        dc.b    28
        dc.b    37
        dc.b    34
        dc.b    37
        dc.b    40
**** Original Line:          .db      55,16,55,22,55,28,55,34,55,40
        dc.b    55
        dc.b    16
        dc.b    55
        dc.b    22
        dc.b    55
        dc.b    28
        dc.b    55
        dc.b    34
        dc.b    55
        dc.b    40
**** Original Line: 
**** Original Line: Level11Pattern:
        __LABEL Level11Pattern
**** Original Line:          .db      1,26,14,26,27,26,40,26,53,26
        dc.b    1
        dc.b    26
        dc.b    14
        dc.b    26
        dc.b    27
        dc.b    26
        dc.b    40
        dc.b    26
        dc.b    53
        dc.b    26
**** Original Line:          .db      1,34,14,34,27,34,40,34,53,34
        dc.b    1
        dc.b    34
        dc.b    14
        dc.b    34
        dc.b    27
        dc.b    34
        dc.b    40
        dc.b    34
        dc.b    53
        dc.b    34
**** Original Line:          .db      1,42,14,42,27,42,40,42,53,42
        dc.b    1
        dc.b    42
        dc.b    14
        dc.b    42
        dc.b    27
        dc.b    42
        dc.b    40
        dc.b    42
        dc.b    53
        dc.b    42
**** Original Line:          .db      1,50,14,50,27,50,40,50,53,50
        dc.b    1
        dc.b    50
        dc.b    14
        dc.b    50
        dc.b    27
        dc.b    50
        dc.b    40
        dc.b    50
        dc.b    53
        dc.b    50
**** Original Line: 
**** Original Line:  ; *************** Sprites **************************************************
**** Original Line: 
**** Original Line: enemy_warped:
        __LABEL enemy_warped
**** Original Line:          .db      7,7
        dc.b    7
        dc.b    7
**** Original Line:          .db      %11000110
        dc.b    %11000110
**** Original Line:          .db      %11101110
        dc.b    %11101110
**** Original Line:          .db      %01111100
        dc.b    %01111100
**** Original Line:          .db      %00111000
        dc.b    %00111000
**** Original Line:          .db      %01111100
        dc.b    %01111100
**** Original Line:          .db      %11101110
        dc.b    %11101110
**** Original Line:          .db      %11000110
        dc.b    %11000110
**** Original Line: 
**** Original Line: spr_enemy_1:
        __LABEL spr_enemy_1
**** Original Line:          .db      6,6
        dc.b    6
        dc.b    6
**** Original Line:          .db      %10000100
        dc.b    %10000100
**** Original Line:          .db      %10000100
        dc.b    %10000100
**** Original Line:          .db      %11111100
        dc.b    %11111100
**** Original Line:          .DB      %11111100
        dc.b    %11111100
**** Original Line:          .DB      %01111000
        dc.b    %01111000
**** Original Line:          .DB      %00110000
        dc.b    %00110000
**** Original Line: 
**** Original Line: spr_enemy_2:
        __LABEL spr_enemy_2
**** Original Line:          .db      6,7
        dc.b    6
        dc.b    7
**** Original Line:          .db      %10000100
        dc.b    %10000100
**** Original Line:          .db      %11001100
        dc.b    %11001100
**** Original Line:          .db      %11111100
        dc.b    %11111100
**** Original Line:          .db      %10000100
        dc.b    %10000100
**** Original Line:          .db      %10000100
        dc.b    %10000100
**** Original Line:          .db      %01001000
        dc.b    %01001000
**** Original Line:          .db      %00110000
        dc.b    %00110000
**** Original Line: 
**** Original Line: spr_enemy_3:
        __LABEL spr_enemy_3
**** Original Line:          .db      6,5
        dc.b    6
        dc.b    5
**** Original Line:          .db      %10000100
        dc.b    %10000100
**** Original Line:          .db      %11111100
        dc.b    %11111100
**** Original Line:          .DB      %10000100
        dc.b    %10000100
**** Original Line:          .DB      %01001000
        dc.b    %01001000
**** Original Line:          .db      %00110000
        dc.b    %00110000
**** Original Line: 
**** Original Line: spr_enemy_4:
        __LABEL spr_enemy_4
**** Original Line:          .db      7,5
        dc.b    7
        dc.b    5
**** Original Line:          .db      %10000010
        dc.b    %10000010
**** Original Line:          .db      %11000110
        dc.b    %11000110
**** Original Line:          .db      %10101010
        dc.b    %10101010
**** Original Line:          .db      %10010010
        dc.b    %10010010
**** Original Line:          .db      %10000010
        dc.b    %10000010
**** Original Line: 
**** Original Line: enemy_o: .db       7,7
        __LABEL enemy_o
        dc.b    7
        dc.b    7
**** Original Line:          .db      %01111100
        dc.b    %01111100
**** Original Line:          .db      %11111110
        dc.b    %11111110
**** Original Line:          .db      %11000110
        dc.b    %11000110
**** Original Line:          .db      %11000110
        dc.b    %11000110
**** Original Line:          .db      %11000110
        dc.b    %11000110
**** Original Line:          .db      %11111110
        dc.b    %11111110
**** Original Line:          .db      %01111100
        dc.b    %01111100
**** Original Line: 
**** Original Line: spr_boss_1:
        __LABEL spr_boss_1
**** Original Line:          .db      16,8
        dc.b    16
        dc.b    8
**** Original Line:          .db      %10000000,%00000001
        dc.b    %10000000
        dc.b    %00000001
**** Original Line:          .db      %11000000,%00000011
        dc.b    %11000000
        dc.b    %00000011
**** Original Line:          .db      %10111111,%11111101
        dc.b    %10111111
        dc.b    %11111101
**** Original Line:          .db      %10000001,%10000001
        dc.b    %10000001
        dc.b    %10000001
**** Original Line:          .db      %10000001,%10000001
        dc.b    %10000001
        dc.b    %10000001
**** Original Line:          .db      %01000001,%10000010
        dc.b    %01000001
        dc.b    %10000010
**** Original Line:          .db      %00100001,%10000100
        dc.b    %00100001
        dc.b    %10000100
**** Original Line:          .db      %00011111,%11111000
        dc.b    %00011111
        dc.b    %11111000
**** Original Line: 
**** Original Line: spr_boss_2:
        __LABEL spr_boss_2
**** Original Line:          .db      16,8
        dc.b    16
        dc.b    8
**** Original Line:          .db      %11111111,%11111111
        dc.b    %11111111
        dc.b    %11111111
**** Original Line:          .db      %11100000,%00000111
        dc.b    %11100000
        dc.b    %00000111
**** Original Line:          .db      %11100000,%00000111
        dc.b    %11100000
        dc.b    %00000111
**** Original Line:          .db      %11100000,%00000111
        dc.b    %11100000
        dc.b    %00000111
**** Original Line:          .db      %11100000,%00000111
        dc.b    %11100000
        dc.b    %00000111
**** Original Line:          .db      %11110000,%00001111
        dc.b    %11110000
        dc.b    %00001111
**** Original Line:          .db      %11101000,%00010111
        dc.b    %11101000
        dc.b    %00010111
**** Original Line:          .db      %01000111,%11100010
        dc.b    %01000111
        dc.b    %11100010
**** Original Line: 
**** Original Line: spr_boss_3:
        __LABEL spr_boss_3
**** Original Line:          .db      31,8
        dc.b    31
        dc.b    8
**** Original Line:          .db      %11111111,%11111111,%11111111,%11111110
        dc.b    %11111111
        dc.b    %11111111
        dc.b    %11111111
        dc.b    %11111110
**** Original Line:          .db      %10101000,%00000000,%00000000,%00101010
        dc.b    %10101000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00101010
**** Original Line:          .db      %10101001,%01010101,%01010101,%00101010
        dc.b    %10101001
        dc.b    %01010101
        dc.b    %01010101
        dc.b    %00101010
**** Original Line:          .db      %10101000,%00000000,%00000000,%00101010
        dc.b    %10101000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00101010
**** Original Line:          .db      %10101000,%00000111,%11000000,%00101010
        dc.b    %10101000
        dc.b    %00000111
        dc.b    %11000000
        dc.b    %00101010
**** Original Line:          .db      %10001111,%11000010,%10000111,%11100010
        dc.b    %10001111
        dc.b    %11000010
        dc.b    %10000111
        dc.b    %11100010
**** Original Line:          .db      %01010000,%00100001,%00001000,%00010100
        dc.b    %01010000
        dc.b    %00100001
        dc.b    %00001000
        dc.b    %00010100
**** Original Line:          .db      %00100000,%00011111,%11110000,%00001000
        dc.b    %00100000
        dc.b    %00011111
        dc.b    %11110000
        dc.b    %00001000
**** Original Line: 
**** Original Line: spr_enemy_bullet:
        __LABEL spr_enemy_bullet
**** Original Line:          .db      3,3
        dc.b    3
        dc.b    3
**** Original Line:          .db      %01000000
        dc.b    %01000000
**** Original Line:          .db      %11100000
        dc.b    %11100000
**** Original Line:          .db      %01000000
        dc.b    %01000000
**** Original Line: 
**** Original Line: spr_explosion:                               
        __LABEL spr_explosion
**** Original Line:          .db      8,6
        dc.b    8
        dc.b    6
**** Original Line:          .db      %00000000
        dc.b    %00000000
**** Original Line:          .db      %00011100
        dc.b    %00011100
**** Original Line:          .DB      %00111110
        dc.b    %00111110
**** Original Line:          .DB      %01010110
        dc.b    %01010110
**** Original Line:          .DB      %00111000
        dc.b    %00111000
**** Original Line:          .DB      %00000000
        dc.b    %00000000
**** Original Line:          .db      8,6
        dc.b    8
        dc.b    6
**** Original Line:          .db      %00110000
        dc.b    %00110000
**** Original Line:          .db      %01001110
        dc.b    %01001110
**** Original Line:          .DB      %10111110
        dc.b    %10111110
**** Original Line:          .DB      %01001111
        dc.b    %01001111
**** Original Line:          .DB      %00111000
        dc.b    %00111000
**** Original Line:          .DB      %00011010
        dc.b    %00011010
**** Original Line:          .db      8,6
        dc.b    8
        dc.b    6
**** Original Line:          .db      %11110011
        dc.b    %11110011
**** Original Line:          .db      %01001110
        dc.b    %01001110
**** Original Line:          .DB      %10110101
        dc.b    %10110101
**** Original Line:          .DB      %01000101
        dc.b    %01000101
**** Original Line:          .DB      %00111110
        dc.b    %00111110
**** Original Line:          .DB      %11011010
        dc.b    %11011010
**** Original Line:          .db      8,6
        dc.b    8
        dc.b    6
**** Original Line:          .db      %11110011
        dc.b    %11110011
**** Original Line:          .db      %01001110
        dc.b    %01001110
**** Original Line:          .DB      %10110101
        dc.b    %10110101
**** Original Line:          .DB      %01000101
        dc.b    %01000101
**** Original Line:          .DB      %00111110
        dc.b    %00111110
**** Original Line:          .DB      %11011010
        dc.b    %11011010
**** Original Line:          .db      8,6
        dc.b    8
        dc.b    6
**** Original Line:          .db      %01000001
        dc.b    %01000001
**** Original Line:          .db      %00100110
        dc.b    %00100110
**** Original Line:          .DB      %00010101
        dc.b    %00010101
**** Original Line:          .DB      %01000100
        dc.b    %01000100
**** Original Line:          .DB      %00010010
        dc.b    %00010010
**** Original Line:          .DB      %10011010
        dc.b    %10011010
**** Original Line:          .db      8,6
        dc.b    8
        dc.b    6
**** Original Line:          .db      %01000010
        dc.b    %01000010
**** Original Line:          .db      %00100000
        dc.b    %00100000
**** Original Line:          .DB      %00000001
        dc.b    %00000001
**** Original Line:          .DB      %01000100
        dc.b    %01000100
**** Original Line:          .DB      %00100010
        dc.b    %00100010
**** Original Line:          .DB      %10001010
        dc.b    %10001010
**** Original Line:          .db      8,6
        dc.b    8
        dc.b    6
**** Original Line:          .db      %00001000
        dc.b    %00001000
**** Original Line:          .db      %11000010
        dc.b    %11000010
**** Original Line:          .DB      %00000000
        dc.b    %00000000
**** Original Line:          .db      %00100000
        dc.b    %00100000
**** Original Line:          .db      %00000001
        dc.b    %00000001
**** Original Line:          .db      %00110000
        dc.b    %00110000
**** Original Line:          .db      8,6
        dc.b    8
        dc.b    6
**** Original Line:          .db      %00000100
        dc.b    %00000100
**** Original Line:          .DB      %00000000
        dc.b    %00000000
**** Original Line:          .DB      %01000000
        dc.b    %01000000
**** Original Line:          .DB      %00000000
        dc.b    %00000000
**** Original Line:          .db      %00000001
        dc.b    %00000001
**** Original Line:          .db      %00100100
        dc.b    %00100100
**** Original Line: 
**** Original Line: spr_bullet_1:
        __LABEL spr_bullet_1
**** Original Line:          .db      3,5
        dc.b    3
        dc.b    5
**** Original Line:          .db      %01000000
        dc.b    %01000000
**** Original Line:          .db      %11100000
        dc.b    %11100000
**** Original Line:          .db      %11100000
        dc.b    %11100000
**** Original Line:          .db      %11100000
        dc.b    %11100000
**** Original Line:          .DB      %11100000
        dc.b    %11100000
**** Original Line: 
**** Original Line: spr_your_ship:
        __LABEL spr_your_ship
**** Original Line:          .db      7,7
        dc.b    7
        dc.b    7
**** Original Line:          .DB      %00010000
        dc.b    %00010000
**** Original Line:          .DB      %00111000
        dc.b    %00111000
**** Original Line:          .DB      %10111010
        dc.b    %10111010
**** Original Line:          .DB      %10111010
        dc.b    %10111010
**** Original Line:          .DB      %10111010
        dc.b    %10111010
**** Original Line:          .DB      %11111110
        dc.b    %11111110
**** Original Line:          .DB      %11111110
        dc.b    %11111110
**** Original Line: 
**** Original Line:  ; **************** Title Screen Text ***************************************
**** Original Line: 
**** Original Line: title_message:
        __LABEL title_message
**** Original Line:          .db      "G A L A X I A N",0
        dc.b    "G A L A X I A N"
        dc.b    0
**** Original Line: title_menu:
        __LABEL title_menu
**** Original Line:          .db      38,20,"Version 3.0",0
        dc.b    38
        dc.b    20
        dc.b    "Version 3.0"
        dc.b    0
**** Original Line:          .db      5,28,"Copyright 1998 by"
        dc.b    5
        dc.b    28
        dc.b    "Copyright 1998 by"
**** Original Line:          .db      " Patrick Davidson",0
        dc.b    " Patrick Davidson"
        dc.b    0
**** Original Line:          .db      11,36,"E-Mail : "
        dc.b    11
        dc.b    36
        dc.b    "E-Mail : "
**** Original Line:          .db      "eeulplek@hotmail.com",0
        dc.b    "eeulplek@hotmail.com"
        dc.b    0
**** Original Line:          .db      18,47,"Press [F1] for "
        dc.b    18
        dc.b    47
        dc.b    "Press [F1] for "
**** Original Line:          .db      "instructions",0
        dc.b    "instructions"
        dc.b    0
**** Original Line: 
**** Original Line: instructions:
        __LABEL instructions
**** Original Line:          .db      10,55,"Press [ENTER] "
        dc.b    10
        dc.b    55
        dc.b    "Press [ENTER] "
**** Original Line:          .db      "to begin the game!",0
        dc.b    "to begin the game!"
        dc.b    0
**** Original Line:          .db      28,23,"Arrow keys - move ship",0
        dc.b    28
        dc.b    23
        dc.b    "Arrow keys - move ship"
        dc.b    0
**** Original Line:          .db      25,30,"[F1] - Cannon"
        dc.b    25
        dc.b    30
        dc.b    "[F1] - Cannon"
**** Original Line:          .db      "   [F2]-Laser",0
        dc.b    "   [F2]-Laser"
        dc.b    0
**** Original Line:          .db      13,37,"[ENTER] - Pause   "
        dc.b    13
        dc.b    37
        dc.b    "[ENTER] - Pause   "
**** Original Line:          .db      "[CLEAR] - Quit",0
        dc.b    "[CLEAR] - Quit"
        dc.b    0
**** Original Line:          .db      9,44,"[EXIT] - Exit    "
        dc.b    9
        dc.b    44
        dc.b    "[EXIT] - Exit    "
**** Original Line:          .db      "[MORE] - Save & exit",0
        dc.b    "[MORE] - Save & exit"
        dc.b    0
**** Original Line: 
**** Original Line: igc:
        __LABEL igc
**** Original Line:          .db      "Ingame Controls",0
        dc.b    "Ingame Controls"
        dc.b    0
**** Original Line: 
**** Original Line:  ; **************** Saved Game Data *****************************************
**** Original Line: 
**** Original Line: saved_flag:
        __LABEL saved_flag
**** Original Line:          .db      0
        dc.b    0
**** Original Line: save_data:
        __LABEL save_data
**** Original Line:          .db      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
**** Original Line:          .db      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
**** Original Line:          .db      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
**** Original Line:          .db      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
**** Original Line:          .db      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
**** Original Line:          .db      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
**** Original Line:          .db      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
**** Original Line:          .db      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
**** Original Line:          .db      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
**** Original Line:          .db      0,0,0,0,0,0,0,0,0,0,0,0,0,0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
**** Original Line: 
**** Original Line:  ; **************** High-Score Data *****************************************
**** Original Line: 
**** Original Line: hi_score_str:
        __LABEL hi_score_str
**** Original Line:          .db      "----> GALAXIAN! <----"
        dc.b    "----> GALAXIAN! <----"
**** Original Line:          .db      "  You have a hiscore!"
        dc.b    "  You have a hiscore!"
**** Original Line:          .db      "Enter your name:     ",0
        dc.b    "Enter your name:     "
        dc.b    0
**** Original Line: hstitle: .db      "=GALAXIAN HIGHSCORES=",0
        __LABEL hstitle
        dc.b    "=GALAXIAN HIGHSCORES="
        dc.b    0
**** Original Line: hsdata:  .dw      50000
        __LABEL hsdata
        __DW    50000
**** Original Line:          .db      "Galaxian 3.0    ",0
        dc.b    "Galaxian 3.0    "
        dc.b    0
**** Original Line:          .dw      40000
        __DW    40000
**** Original Line:          .db      "Galaxian 3.0    ",0
        dc.b    "Galaxian 3.0    "
        dc.b    0
**** Original Line:          .dw      30000
        __DW    30000
**** Original Line:          .db      "Galaxian 3.0    ",0
        dc.b    "Galaxian 3.0    "
        dc.b    0
**** Original Line:          .dw      25000
        __DW    25000
**** Original Line:          .db      "Galaxian 3.0    ",0
        dc.b    "Galaxian 3.0    "
        dc.b    0
**** Original Line:          .dw      20000
        __DW    20000
**** Original Line:          .db      "Galaxian 3.0    ",0
        dc.b    "Galaxian 3.0    "
        dc.b    0
**** Original Line:          .dw      15000
        __DW    15000
**** Original Line:          .db      "Galaxian 3.0    ",0
        dc.b    "Galaxian 3.0    "
        dc.b    0
**** Original Line: lowest   .dw      10000
        __LABEL lowest
        __DW    10000
**** Original Line:          .db      "Galaxian 3.0    ",0
        dc.b    "Galaxian 3.0    "
        dc.b    0
**** Original Line: 
**** Original Line: chartable:
        __LABEL chartable
**** Original Line:          .db      "XTOJE."
        dc.b    "XTOJE."
**** Original Line:          .db      ". WSNID!.ZVRMHC?"
        dc.b    ". WSNID!.ZVRMHC?"
**** Original Line:          .db      ".YUQLGB#x~+PKFA|"
        dc.b    ".YUQLGB#x~+PKFA|"
**** Original Line:          .db      "@54321.~+"
        dc.b    "@54321.~+"
**** Original Line: 
**** Original Line:          .end
        EVEN
___byebye:
        jsr     ti85lib3@0012
program_end:
        SECTION bss,BSS
buffer: ds.b    $8100
        END
