; CALC.asm
 ;  by Jimmy Mrdell

 ;  Jim Macdonell jimm@snowline.net

 ;  and William Deich williamiv@geocities.com
 ;
 ;
 ;  OK world, this program has a fairy tail behind it.
 ;
 ;  	Once upon a time young programmer named Jim Macdonell wrote a
 ;  program called acid11 to help the rest of his chemistry class.
 ;  Later William Charles Deich IV, in Hollywood, Florida came along
 ;  and wanted to use the program to display math formulas, but
 ;  didn't know much ASM.  Therefore, Jimmy Mrdell, a nice young
 ;  programmer in Sweeden, greatly improved the code for him.
 ;  Finally, William picked out the math formulas for it to display.
 ;  This is why the program still calls the display stings "acids."
 ;

 ;  The program now displays formulas for derivatives, integruals,
 ;  and cylindrical and spherical coordinates.  Now on the cylindrical
 ;  and spherical coordinates, I used "phi" as the angle with the
 ;  posative x-axis, and "theata" as the angle with the posative z-axis.
 ;  I know this is opposite to how most math books to it, but it is how 
 ;  most physics books do it, sorry.
 ;
 ;  You can add any number of display strings, or just change
 ;  the whole list of display strings as I did.  However, the

 ;  number of display strings must not be larger than 255.
 ;

 ;  Use MORE to scroll one page down EXIT exits (duh). This is the
 ;  "small" version that only uses the MORE key to flip thru the list.

 

NoAcids = $80DF 

 

 #include "TI-85.h"

  

 .org 0



 .db "Calc Help v1.0 by JM,WD", 0

 

  ROM_CALL(CLEARLCD)

  ld hl,$0101

  ld ($8333),hl

  ld de,Header

  ld hl,(PROGRAM_ADDR)

  add hl,de

  ROM_CALL(D_ZM_STR)

 

  ld de,Acids

  ld hl,(PROGRAM_ADDR)

  add hl,de  

  ld b,0

CountAcids:

  ld a,(hl)

  or a

  jr z,CountDone

  ld c,-1

  xor a

  cpir

  inc b

  jr CountAcids

CountDone:

  ld a,b

  ld (NoAcids),a

    

  ld bc,$0808

  xor a

  CALL_(DisplayAcids)  

  ld d,0

  

WaitKey:

  halt

  call GET_KEY

  or a

  jr z,WaitKey
  cp K_MORE

  jr z,PageDown

  cp K_EXIT

  ret z

  jr WaitKey



Output:

  CALL_(DisplayAcids)

  pop de

  jr WaitKey





PageDown:

  ld hl,$FC80

  ld bc,$380

  push de

  CALL_(Clear)

  pop de

  ld bc,$0808

  ld a,(NoAcids)

  sub d

  cp 9

  jr nc,NextPage

  ld d,-8  

NextPage:

  ld a,d

  add a,8

  ld d,a

  push de  

  jr Output

  

Clear:  

  ld e,l

  ld d,h

  inc de

  ld (hl),0

  ldir

  ret

   

; Display B acids, starting with acid A from row C

DisplayAcids:

  ld de,Acids

  ld hl,(PROGRAM_ADDR)

  add hl,de

  ;add a,a

  jr z,DispLoop

  push bc

  ld b,a

  xor a

  ; Search in acid list

Search:

  ld c,-1

  cpir  

  djnz Search

  pop bc

  ; B = acids left to display, C = current row, HL -> Acid, DE = $8333  

DispLoop:

  ld a,(hl)

  or a

  ret z   ; Check if no more acids

  ld a,c  

  ld ($8334),a

  add a,7

  ld c,a  

  ld a,1

  ld ($8333),a

  ROM_CALL(D_ZM_STR)

  

  djnz DispLoop

  ret

  

Header:

 .db "********************",0 

Acids:
 .db "DERIVATIVE FORMULAS",0

 .db "d/dx ln u = du/u",0
 .db "d/dx e^u = e^(u)*du",0
 .db "d/dx sin u = cos(u)du",0
 .db "d/dx cos u = -sin(u)du",0
 .db "d/dx tan u = sec",$12,"(u)du",0
 .db "d/dx cot u = -csc",$12,"(u)du",0
 .db "d/dx sec u = sec(u)tan(u)du",0
 .db "d/dx csc u = -csc(u)cot(u)du",0
 .db "d/dx sin",$11,"u = du/"
 .db $10,"(1-u",$12,")",0
 .db "d/dx cos",$11,"u = -du/"
 .db $10,"(1-u",$12,")",0
 .db "d/dx tan",$11
 .db "u = du/(1+u",$12,")",0
 .db "d/dx cot",$11
 .db "u = -du/(1+u",$12,")",0
 .db "d/dx sec",$11,"u = du/|u|"
 .db $10,"(u",$12,"-1)",0
 .db "d/dx csc",$11,"u = -du/|u|"
 .db $10,"(u",$12,"-1)",0
 .db " ",0
 .db "INTEGRUAL FORMULAS",0
 .db $08,"du/u = ln |u|+C",0
 .db $08,"e^(u)du = e^u+C",0
 .db $08,"sin(u)du = -cos u+C",0
 .db $08,"cos(u)du = sin u+C",0
 .db $08,"tan(u)du = -ln |cos u|+C",0
 .db $08,"cot(u)du = ln |sin u|+C",0
 .db $08,"sec(u)du = "
 .db "ln |sec u + tan u|+C",0
 .db $08,"csc(u)du = "
 .db "-ln |csc u+cot u|+C",0
 .db $08,"sec",$12,"(u)du = tan u+C",0
 .db $08,"csc",$12,"(u)du = -cot u+C",0
 .db $08,"sec(u)tan(u)du = sec u+C",0
 .db $08,"csc(u)cot(u)du = -csc u+C",0
 .db $08,"tan",$12,"(u)du = tan(u)-u+C",0
 .db $08,"cot",$12,"(u)du = -cot(u)-u+C",0
 .db $08,"ln(u)du = u*ln(u)-u+C",0
 .db $08,"du/",$10,"(a",$12
 .db "-u",$12,") = sin",$11,"(u/a)+C",0
 .db $08,"du/(a",$12,"+u",$12,") = "
 .db "1/a tan",$11,"(u/a)+C",0
 .db $08,"du/u",$10,"(u",$12,"-a",$12
 .db ") = 1/a sec",$11,"(|u|/a)+C",0
 .db " ",0
 .db " ",0
 .db " ",0
 .db " ",0
 .db " ",0
 .db "CYLINDRICAL COORDINATES",0
 .db "x=r*cos ",$C9,0
 .db "y=r*sin ",$C9,0
 .db "tan ",$C9,"=y/x",0
 .db "r",$12,"=x",$12,"+y",$12,0
 .db "z=z",0
 .db " ",0
 .db " ",0
 .db "SPHERICAL COORDINATES",0
 .db "x=R*sin",$C1,"cos",$C9,0
 .db "y=R*sin",$C1,"sin",$C9,0
 .db "z=R*cos",$C1,0
 .db "R",$12,"=x",$12,"+y",$12,"+z",$12,0
 .db "tan ",$C9,"=y/x",0
 .db $C1,"=cos",$11,"(z/",$10,"(x",$12,"+y",$12,"+z",$12,"))",0
 .db " ",0
 .db $C9,"=",$13,"with +x axis",0
 .db $C1,"=",$13,"with +z axis",0
 .db "r=radius in xy plain",0
 .db "R=radius in 3space",0
 .db 0   ; End of acids



 .end

 