; Tetris 89...ported from the 92 by Joel Jordan <scriber@usa.net>
; Version 0.70
; Version 0.71 - recompiled for new version of the ASM shells
; 		PlusShell 1.0a and DoorsOS 1.0
; Version 0.72 - now works with new roms
;		the Home key doesn't crash the calc anymore
;		fixed the GameOver dialog
; Version 0.73 - recompiled for new version of DoorsOS II 
; originally by Jimmy Mrdell <mja@algonet.se>


        include "doorsos.h"
        include "gray4lib.h"
	include "util.h"

	include "tetmacr.h"

	xdef _main
	xdef _comment
	
	xdef _ti89

_main:
; movem.l d0-d7/a0-a6,-(a7)

 bsr Init
 tst.b	 tkflag
 beq MainRepeat
 lea	 $300,a0
 lea     $4C00,a1
 move.l  gray4lib::plane0,a2
 move.w  #959,d1
RestoreScreen:
 move.l  (a0)+,(a1)+
 move.l  (a0)+,(a2)+
 dbra	 d1,RestoreScreen
 add.w	 #40,timer
 sf	 tkflag
 st	 intflag
 bra Main
MainRepeat:
 bsr Titel
 jsr util::idle_loop
 cmp.w	 #264,d0
 beq Done
 bsr Menu
 cmp.w	 #264,d0
 beq Done
 bsr NewGame
Main:
 tst.w	 twopl
 beq GetKeyInfo
 bsr ReceiveByte
 move.w  d0,d1
 lsr.w	 #4,d0
 beq GetKeyInfo
 and.w	 #$0F,d1
 cmp.w	 #$0F,d0
 beq PenaltyRows
 cmp.w	 #$0E,d0
 beq BarInfoH
 cmp.w	 #$0D,d0
 beq BarInfo
 cmp.w	 #$0C,d0
 bne GetKeyInfo
 lea	 windialog(PC),a6
 bra EndGame
BarInfoH:
 moveq	 #16,d1
BarInfo:
 bsr ShowBar
 bra GetKeyInfo
PenaltyRows:
 bsr RemoveCurPiece
Put_PR:
 bsr TrashRow
 tst.w	 y
 beq NextPR
 subq.w  #1,y
NextPR:
 dbra	 d1,Put_PR
 bsr ShowCurPiece
 bsr SendBarInfo
GetKeyInfo:
 bsr GetKeyStat
 move.w  x(PC),d4
 move.w  y(PC),d5
 move.w  rot(PC),d6
 bsr CheckDown
 bsr CheckLeftRight
 bsr CheckRotate
 bsr CheckDrop

 clr.l	 ltimer
 sf	 upflag
 sf	 downflag
; I had to change a lot of the keys around to reflect the different layout
; and the different hardware keymap
; refer to keymap in tetris89.txt for codes here

 btst.b  #0,keystat+6   ; 0th button, block 6 (ESC)
 beq GameOver
 tst.w	 twopl
 bne EndKeyCheck
 btst.b  #7,keystat     ; 7th button, block 0 (ALPHA)
 beq Pause
 btst.b  #6,keystat+5   ; 6th button, 5th block (Home)
 beq TeacherKey
EndKeyCheck:

CheckTimer:
 tst.w	 timer
 bne Main
ShortWait:
 move.w  #20,timer
Wait:
 tst.w	 timer
 bne Wait
 bra MoveDown

RetEKC:
 addq	 #4,a7
 bra EndKeyCheck

CheckRotate:
; tst.w	 disUflag
; bne SkipUpCheck
 btst.b  #0,keystat             ; button 0, 0th block (Up arrow)
 beq TryRot
SkipUpCheck:
 btst.b  #4,keystat             ; button 4, 0th block (2nd)
 beq TryRot
 btst.b  #5,keystat             ; button 5, 0th block (Shift)
 bne ClearUp
 addq	 #2,d6
TryRot:
 clr.l	 ltimer
 sf	 downflag
 addq	 #1,d6
 and.w	 #3,d6
 tst.b	 upflag
 bne RetEKC
 st	 upflag
 lea	 tmpp(PC),a0
 move.w  curPN(PC),d0
 move.w  d6,d1
 bsr Uncrunch
 bsr TestMoveA0
 bne RetEKC
 bsr RemoveCurPiece
 move.w  d6,rot
 bsr UncrunchCurPiece
 bsr ShowCurPiece
 bra RetEKC
ClearUp:
 sf	 upflag
 rts

CheckLeftRight:
 btst.b  #1,keystat			; Button 1, 0th block (Left)
 bne CheckRight
 clr.w	 rtimer
 sf	 downflag
 tst.w	 ltimer
 bne RetEKC
 move.w  #60,ltimer
 subq	 #1,d4
 bsr TestMove
 bne RetEKC
 bsr RemoveCurPiece
 move.w  d4,x
 bsr ShowCurPiece
 bra RetEKC
CheckRight:
 clr.w	 ltimer
 btst.b  #3,keystat			; Button 3, block 0 (Right)
 bne ClearRight
 sf	 downflag
 tst.w	 rtimer
 bne RetEKC
 move.w  #60,rtimer
 addq	 #1,d4
 bsr TestMove
 bne RetEKC
 bsr RemoveCurPiece
 move.w  d4,x
 bsr ShowCurPiece
 bra RetEKC
ClearRight:
 clr.w	 rtimer
 rts

CheckDown:
 tst.w	 disDflag
 bne Return
 btst.b  #2,keystat			; Button 2, block 0 (down)
 bne Return
 tst.b	 downflag
 bne RetEKC
 addq.l  #1,score
 addq	 #4,a7
 bra ShortWait

CheckDrop:
 btst.b  #6,keystat			; Button 6, block 0 (diamond)
; beq TryDrop
; btst.b  #2,keystat+2			; Button 2, block 2 (D on TI92)
; beq TryDrop
; btst.b  #6,keystat+6			; Button 6, block 6 (ENTER2 on TI92)
 bne ClearDown
TryDrop:
 tst.b	 downflag
 bne RetEKC
Drop:
 addq	 #1,d5
 addq.l  #1,score
 bsr TestMove
 beq Drop
 bsr RemoveCurPiece
 move.w  d5,y
 subq.w  #1,y
 bsr ShowCurPiece
 addq	 #4,a7
 bra StorePiece
ClearDown:
 sf	 downflag
 rts

MoveDown:
 move.w  levtimer(PC),timer
 move.w  x(PC),d4
 move.w  y(PC),d5
 addq	 #1,d5
 bsr TestMove
 bne StorePiece
 bsr RemoveCurPiece
 move.w  d5,y
 bsr ShowCurPiece
 bra Main
StorePiece:
 subq	 #1,d5
 moveq	 #3,d7
 lea	 curp(PC),a0
StoreSq:
 move.w  (a0)+,d2
 move.w  (a0)+,d3
 add.w	 d5,d2
 lsl.w	 #4,d2
 add.w	 d3,d2
 add.w	 d4,d2
 st	 0(a5,d2)
 dbra	 d7,StoreSq
 move.l  a5,a0
 lea	 rows(PC),a1
 moveq	 #17,d0
 clr.l	 d2
 clr.l	 d5
CheckRow:
 moveq	 #15,d1
CheckRCol:
 tst.b	 0(a0,d1)
 beq CheckNextRow
 dbra	 d1,CheckRCol
 addq	 #1,d5
 move.w  d2,(a1)+
CheckNextRow:
 lea	 16(a0),a0
 addq	 #1,d2
 dbra	 d0,CheckRow
 bsr ShowScore
 tst.w	 d5
 beq NewP
 add.w	 d5,lines
 clr.l	 d0
 move.w  lines(PC),d0
 divu	 #10,d0
 cmp.w	 level(PC),d0
 blt SameLevel
 move.w  d0,level
 lea	 levels(PC),a0
 lsl.w	 #1,d0
 move.w  0(a0,d0),levtimer
SameLevel:
 subq	 #1,d5
 lea	 scoring(PC),a0
 move.w  d5,d0
 lsl.w	 #1,d0
 move.w  0(a0,d0),d0
 move.w  level(PC),d1
 addq	 #1,d1
 mulu	 d1,d0
 add.l	 d0,score
 moveq	 #3,d6
Flash:
 move.w  d5,d0
 lea	 rows(PC),a0
 lea     $4C00,a1
 move.l  gray4lib::plane0,a2
FlashRows:
 move.w  (a0)+,d1
 subq	 #2,d1
; Changed this from 240 to 180 because the rows are only 6 pixels high*
; 30 bytes across = 180 bytes
 mulu	 #180,d1
 addq.w	 #1,d1
 moveq	 #5,d2
FlashLine:
 move.w  d1,d3
; I changed this next line from 4 to 9 because my method puts the first
; usuable position on an odd address, and i get address faults if I do this
; with word or long operations like the 92 uses for some reason
 move.w	 #9,d4
FlashWord:
; eori.w  #$FFFF,0(a1,d3.w)
; eori.w  #$FFFF,0(a2,d3.w)
; addq	 #2,d3
; substituted 10 byte or's for 5 word or's
 eori.b #$FF,0(a1,d3.w)
 eori.b #$FF,0(a2,d3.w)
 addq.w #1,d3
 dbra	 d4,FlashWord
 add.w	 #30,d1
 dbra	 d2,FlashLine
 dbra	 d0,FlashRows
 move.w  #40,timer
FlashPause:
 tst.w	 timer
 bne FlashPause
 dbra	 d6,Flash
 move.w  d5,d0
 lea	 rows(PC),a0
MoveLines:
 lea     $4C00,a1
 move.l  gray4lib::plane0,a2
 move.w  (a0)+,d1
 move.w  d1,d4
 subq	 #2,d1
 move.w  d1,d3
; Multiply by 6*30 = 180 bytes per block row...changed from 240
 mulu	 #180,d1
; add 150 instead of 220...this is because the rows begin at a different
; x coordinate than on the 92
 add.w	 #150,d1
 move.w  d1,d2
; subtract 180 instead of 240--6*30=180...
 sub.w	 #180,d2
 mulu	 	#6,d3
 subq	 #1,d3
MoveGFXRows:
; I had to expand these cuz the 68K won't let me do long operations
; starting at an odd address
 move.b  10(a1,d2),10(a1,d1)
 move.b  10(a2,d2),10(a2,d1)
 move.b  1(a1,d2),1(a1,d1)
 move.b  1(a2,d2),1(a2,d1)
 move.b  2(a1,d2),2(a1,d1)
 move.b  2(a2,d2),2(a2,d1)
 move.b  3(a1,d2),3(a1,d1)
 move.b  3(a2,d2),3(a2,d1)
 move.b  4(a1,d2),4(a1,d1)
 move.b  4(a2,d2),4(a2,d1)
 move.b  5(a1,d2),5(a1,d1)
 move.b  5(a2,d2),5(a2,d1)
 move.b  6(a1,d2),6(a1,d1)
 move.b  6(a2,d2),6(a2,d1)
 move.b  7(a1,d2),7(a1,d1)
 move.b  7(a2,d2),7(a2,d1)
 move.b  8(a1,d2),8(a1,d1)
 move.b  8(a2,d2),8(a2,d1)
 move.b  9(a1,d2),9(a1,d1)
 move.b  9(a2,d2),9(a2,d1)
 sub.w	 #30,d1
 sub.w	 #30,d2
 dbra	 d3,MoveGFXRows
; changed a 7 to 5 (8 rows per block vs 6 rows per block)
 moveq	 #5,d3
ClearTopRows:
 clr.b	 10(a1,d1)
 clr.b	 10(a2,d1)
 clr.b	 1(a1,d1)
 clr.b	 1(a2,d1)
 clr.b	 2(a1,d1)
 clr.b	 2(a2,d1)
 clr.b	 3(a1,d1)
 clr.b	 3(a2,d1)
 clr.b	 4(a1,d1)
 clr.b	 4(a2,d1)
 clr.b	 5(a1,d1)
 clr.b	 5(a2,d1)
 clr.b	 6(a1,d1)
 clr.b	 6(a2,d1)
 clr.b	 7(a1,d1)
 clr.b	 7(a2,d1)
 clr.b	 8(a1,d1)
 clr.b	 8(a2,d1)
 clr.b	 9(a1,d1)
 clr.b	 9(a2,d1)
 sub.w	 #30,d1
 dbra	 d3,ClearTopRows
 move.l  a5,a1
 lsl.w	 #4,d4
 add.w	 d4,a1
 move.l  a1,a2
 lea	 16(a2),a2
 lsr.w	 #2,d4
 subq	 #1,d4
UpdateBoard:
 move.l  -(a1),-(a2)
 dbra	 d4,UpdateBoard
 dbra	 d0,MoveLines
 tst.w	 twopl
 beq NewP
 tst.w	 d5
 beq NewP
 move.w  llflag(PC),d0
 lsr.w	 #3,d0
 sub.w	 d0,d5
 move.w  d5,d0
 or.w	 #$F0,d0
 bsr SendByte
NewP:
 tst.w	 twopl
 beq NoBarInfo
 bsr SendBarInfo
NoBarInfo:
 bsr ShowScore
 bsr NewPiece
 moveq	 #6,d4
 clr.l	 d5
 bsr TestMove
 beq Main
GameOver:
 tst.w	 twopl
 beq ShowGameOver
 move.b  #$C0,d0
 bsr SendByte
ShowGameOver:
 lea	 losedialog(PC),a6
EndGame:
 bsr ShowDialog
WaitQRel:
 bsr GetKeyStat
; btst	 #3,keystat+9		; Button 3, block 9 (Q on TI92)
; beq WaitQRel
; btst	 #6,keystat+8		; Button 6, block 8 (ESC on TI92)
; beq WaitQRel
	btst #0,keystat+6			; Button 0, block 6 (ESC on TI89)
	beq WaitQRel
 sf	 intflag
; changed this to the Plusshell convention cuz the address was off by
; two bytes or so anyway
 clr.w   (doorsos::kb_vars+$1C)
WaitKeyPress:
 jsr util::idle_loop
 cmp.w	 #337,d0
 bcs CheckGameOver
 cmp.w	 #353,d0
 bcs WaitKeyPress
CheckGameOver:
 tst.w	 twopl
 bne MainRepeat
 move.l  score(PC),d0
 cmp.l	 hiscore+56,d0
 ble MainRepeat
 lea	 hiscore+16(PC),a0
 moveq	 #2,d1
CheckPl:
 cmp.l	 (a0),d0
 bgt PlFound
 lea	 20(a0),a0
 dbra	 d1,CheckPl
PlFound:
 lea	 hiscore+60(PC),a0
 lea	 hiscore+40(PC),a1
 tst.w	 d1
 beq NoHiMove
 mulu	 #5,d1
 subq	 #1,d1
MoveHiTable:
 move.l  -(a1),-(a0)
 dbra	 d1,MoveHiTable
NoHiMove:
 move.l  d0,16(a1)
 bsr ClrScr
 SetFont #2
 WriteStr #16,#20,#4,ent1txt
 SetFont #1
 WriteStr #5,#38,#4,ent2txt
 WriteStr #1,#50,#4,ent3txt
 bsr CopyScreen
 move.w  #97,d3
 moveq	 #50,d1
 clr.l	 d4
Input:
 jsr util::idle_loop
 cmp.w	 #13,d0
 beq InputDone
 cmp.w	 #257,d0
 beq BackSpace
 cmp.w	 #32,d0
 bcs Input
 cmp.w	 #256,d0
 bcc Input
 cmp.w	 #15,d4
 beq Input
 move.b  d0,(a1)+
 move.w  d0,d2
 move.w  d3,d0
 bsr WriteChar
 addq	 #6,d3
 addq	 #1,d4
 bra Input
BackSpace:
 tst.w	 d4
 beq Input
 clr.b	 -(a1)
 subq	 #6,d3
 move.w  d3,d0
 moveq	 #32,d2
 bsr WriteChar
 subq	 #1,d4
 bra Input
InputDone:
 clr.b	 (a1)
 bra MainRepeat

ShowScore:
 movem.l d0-d2/a0-a1,-(a7)
; had to change fonts to 1 from 2 to fit on the screen
 SetFont #1
 lea	 tmpstr+6(PC),a0
 move.l  score(PC),d0
 moveq	 #6,d1
 bsr ConvStr
; this was moved to fit on the screen
 WriteStrA #106,#20,#4,a0
 lea	 tmpstr+6(PC),a0
 clr.l	 d0
 move.w  level(PC),d0
 moveq	 #4,d1
 bsr ConvStr
; moved to fit on screen
 WriteStrA #114,#40,#4,a0
 lea	 tmpstr+6(PC),a0
 clr.l	 d0
 move.w  lines(PC),d0
 moveq	 #4,d1
 bsr ConvStr
; moved to fit on screen
 WriteStrA #114,#60,#4,a0
; changed the addresses here a bit to make up for the changes in position
 lea     $4c0c,a0
 move.l  gray4lib::plane0,a1
 add.w	 #$c,a1
 moveq	 #80,d0
SS_CopyRow:
 moveq	 #8,d1
SS_CopyCol:
 move.b  (a0)+,(a1)+
 dbra	 d1,SS_CopyCol
 lea	 21(a0),a0
 lea	 21(a1),a1
 dbra	 d0,SS_CopyRow
 movem.l (a7)+,d0-d2/a0-a1
 rts

ConvStr:
 movem.l d0-d2,-(a7)
 clr.b	 (a0)
RepConv:
 divu	 #10,d0
 move.l  d0,d2
 swap	 d2
 add.b	 #48,d2
 move.b  d2,-(a0)
 subq	 #1,d1
 and.l	 #$FFFF,d0
 bne RepConv
 tst.w	 d1
 beq CS_Done
 subq	 #1,d1
FillOut:
 move.b  #32,-(a0)
 dbra	 d1,FillOut
CS_Done:
 movem.l (a7)+,d0-d2
 rts

; this has been converted 5/15/98

TrashRow:
 movem.l d0-d4/a0-a4,-(a7)
 lea     $4C00,a2
 move.l  gray4lib::plane0,a3
 moveq	 #1,d1
 move.w  #181,d2
 moveq	 #89,d3
MoveUpGFXRows:
; Stupid byte align strikes again!
 move.b  0(a2,d2),0(a2,d1)
 move.b  0(a3,d2),0(a3,d1)
 move.b  1(a2,d2),1(a2,d1)
 move.b  1(a3,d2),1(a3,d1)
 move.b  2(a3,d2),2(a3,d1)
 move.b  2(a2,d2),2(a2,d1)
 move.b  3(a3,d2),3(a3,d1)
 move.b  3(a2,d2),3(a2,d1)
 move.b  4(a3,d2),4(a3,d1)
 move.b  4(a2,d2),4(a2,d1)
 move.b  5(a3,d2),5(a3,d1)
 move.b  5(a2,d2),5(a2,d1)
 move.b  6(a3,d2),6(a3,d1)
 move.b  6(a2,d2),6(a2,d1)
 move.b  7(a3,d2),7(a3,d1)
 move.b  7(a2,d2),7(a2,d1)
 move.b  8(a3,d2),8(a3,d1)
 move.b  8(a2,d2),8(a2,d1)
 move.b  9(a3,d2),9(a3,d1)
 move.b  9(a2,d2),9(a2,d1)
 add.w	 #30,d1
 add.w	 #30,d2
 dbra	 d3,MoveUpGFXRows
 add.w	 d1,a2
 add.w	 d1,a3
 move.l  a5,a0
 move.l  a0,a4
 add.w	 #16,a0
 moveq	 #67,d1
MoveUpRows:
 move.l  (a0)+,(a4)+
 dbra	 d1,MoveUpRows
 addq	 #3,a4
 moveq	 #9,d3
TR_Fill:
 st	 0(a4,d3)
 dbra	 d3,TR_Fill
 moveq	 #4,d3
MakeHoles:
 moveq	 #10,d0
 jsr util::random
 clr.b	 0(a4,d0)
 dbra	 d3,MakeHoles
 moveq	 #9,d3
 clr.l	 d2
TR_PutSquares:
 lea	 empty(PC),a0
 tst.b	 0(a4,d2)
 beq TR_PutSquare
 lea	 pgfx(PC),a0
 moveq	 #7,d0
 jsr util::random
 lsl.w	 #4,d0
 add.w	 d0,a0
TR_PutSquare:
 move.l  a2,a1
 bsr PutSprite6
 move.l  a3,a1
 bsr PutSprite6
 addq	 #1,d2
 addq	 #1,a2
 addq	 #1,a3
 dbra	 d3,TR_PutSquares
 movem.l (a7)+,d0-d4/a0-a4
 rts

TestMove:
 lea	 curp(PC),a0
TestMoveA0:
 movem.l d2-d3/d7,-(a7)
 moveq	 #3,d7
CheckSq:
 move.w  (a0)+,d2
 move.w  (a0)+,d3
 add.w	 d5,d2
 lsl.w	 #4,d2
 add.w	 d3,d2
 add.w	 d4,d2
 tst.b	 0(a5,d2)
 bne TM_Done
 dbra	 d7,CheckSq
 cmp.w	 d0,d0
TM_Done:
 movem.l (a7)+,d2-d3/d7
 rts

Pause:
 move.w  timer(PC),d6
 move.l  #2560,-(a7)
 jsr doorsos::HeapAlloc
 lea	 4(a7),a7
 move.w  d0,d7
; handle_ptr d0,a0

	move.w d0,-(a7)
        jsr doorsos::HeapDeref
	addq.l #2,a7

 move.l  a0,a3
 lea     $4c00,a1
 move.l  gray4lib::plane0,a2
; add.w	 #10,a2
 moveq	 #100,d1
P_MoveRow:
 moveq	 #5,d2
P_MoveWord:
 move.w  (a1),(a0)+
 clr.w	 (a1)+
 move.w  (a2),(a0)+
 clr.w	 (a2)+
 dbra	 d2,P_MoveWord
 lea	 18(a1),a1
 lea	 18(a2),a2
 dbra	 d1,P_MoveRow
 lea	 pausedialog(PC),a6
 bsr ShowDialog
 SetFont #0
 WriteStr #48,#55,#4,paus2txt(PC)
 bsr CopyDialogBox
WaitPRel:
 GetKey  #$FFBF,d1
 btst	 #7,d1
 beq WaitPRel
 sf	 intflag


 clr.w   (doorsos::kb_vars+$1C)
 jsr util::idle_loop
 clr.w	 -(a7)
 jsr doorsos::ST_busy
 addq	 #2,a7
 st	 intflag
WaitPRelA:
 GetKey  #$FFBF,d1
 btst	 #7,d1
 beq WaitPRelA
 jsr util::clear_dialog
 bsr CopyDialogBox
 bsr ShowBrickWall
 lea     $4c00,a1
 move.l  gray4lib::plane0,a2
; add.w	 #10,a2
 moveq	 #100,d1
P_MoveRowB:
 moveq	 #5,d2
P_MoveWordB:
 move.w  (a3)+,(a1)+
 move.w  (a3)+,(a2)+
 dbra	 d2,P_MoveWordB
 lea	 18(a1),a1
 lea	 18(a2),a2
 dbra	 d1,P_MoveRowB
 move.w  d7,-(a7)
 jsr doorsos::HeapFree
 addq	 #2,a7
 jsr ShowInfoText
 move.w  d6,timer
 bra Main

; Didn't quite work -> it now turns off the calc

TeacherKey:
	trap #4
	bra EndKeyCheck
; sf	 intflag
; st	 tkflag
; lea	 $300,a0
; lea     $4C00,a1
; move.l  gray4lib::plane0,a2
; move.w  #959,d1
;SaveScreen:
; move.l  (a1)+,(a0)+
; move.l  (a2)+,(a0)+
; dbra	 d1,SaveScreen
;; move.w  #264,$75B2
;; move.w  #1,$75B0
; bra Done

ShowCurPiece:
 movem.l d0-d1/d6/a0,-(a7)
 lea	 curp(PC),a0
 move.w  x(PC),d0
 move.w  y(PC),d1
 move.w  curPN(PC),d6
 bsr ShowPiece
 movem.l (a7)+,d0-d1/d6/a0
 rts

RemoveCurPiece:
 movem.l d0-d1/d6/a0,-(a7)
 lea	 curp(PC),a0
 move.w  x(PC),d0
 move.w  y(PC),d1
 move.w  curPN(PC),d6
 bsr RemovePiece
 movem.l (a7)+,d0-d1/d6/a0
 rts

UncrunchCurPiece:
 movem.l d0-d1/a0,-(a7)
 lea	 curp(PC),a0
 move.w  curPN(PC),d0
 move.w  rot(PC),d1
 bsr Uncrunch
 movem.l (a7)+,d0-d1/a0
 rts

SendBarInfo:
 move.l  a5,a0
 lea	 35(a0),a0
 moveq	 #16,d0
SBI_CheckRow:
 moveq	 #9,d1
SBI_CheckCol
 tst.b	 0(a0,d1)
 bne TileFound
 dbra	 d1,SBI_CheckCol
 lea	 16(a0),a0
 dbra	 d0,SBI_CheckRow
TileFound:
 add.w	 #$D0,d0
 bsr SendByte
 rts

ShowBar:
 moveq	 #15,d2
 lea     $4c0c,a2
 move.l  gray4lib::plane0,a3
 add.w    #12,a3
RepShowBar:
 lea	 bargfx(PC),a0
 cmp.w	 d1,d2
 bge EmptyBox
 addq    #6,a0
EmptyBox:
 move.l  a0,a4
 move.l  a2,a1
 bsr PutSprite6
 move.l  a4,a0
 move.l  a3,a1
 bsr PutSprite
 lea     180(a2),a2
 lea     180(a3),a3
 dbra	 d2,RepShowBar
 rts

NewPiece:
 lea	 nextp(PC),a0
 moveq	 #16,d0
 moveq	 #13,d1
 bsr RemovePiece
 move.w  #6,x
 clr.w	 y
 clr.w	 rot
 move.w  nextPN(PC),curPN
 bsr UncrunchCurPiece
 lea	 curp(PC),a0
 bsr ShowCurPiece
RandomNewPiece:
 moveq	 #7,d0
 jsr util::random
 move.w  d0,d6
 move.w  d0,nextPN
 clr.l	 d1
 lea	 nextp(PC),a0
 bsr Uncrunch
 moveq	 #16,d0
 moveq	 #13,d1
 bsr ShowPiece
 move.w  levtimer(PC),timer
 add.w	 #20,timer
 st	 downflag
 clr.l	 ltimer
 rts

; I changed some stuff here, but I forgot most of it...

ShowPiece:    ; Shows the piece no D6, (A0) at D0,D1
 movem.l d0-d5/a0-a4,-(a7)
 lea     $4C00,a1
 move.l  gray4lib::plane0,a2
 lea	 pgfx(PC),a3
 move.w  d6,d2
 mulu.w  #12,d2
 adda.w  d2,a3
 cmp.w	 #6,d6
 bne StartPut
 cmp.w	 #3,(a0)
 bne StartPut
 lea     48(a3),a3
StartPut:
 subq	 #2,d0
 subq	 #2,d1
 moveq	 #3,d4
SP_PutSq:
 move.w  d0,d2
 move.w  d1,d3
 add.w	 (a0)+,d3
 add.w	 (a0)+,d2
 btst	 #15,d3
 bne SP_SkipSq
; changed for 6 rows again
 mulu	 #180,d3
 add.w	 d2,d3
 move.l  a3,a4
; 6 rows, not 8
 moveq  #5,d5
SP_PutRow:
 move.b  (a4)+,0(a1,d3)
 move.b  5(a4),0(a2,d3)
 add.w	 #30,d3
 dbra	 d5,SP_PutRow
SP_SkipSq:
 cmp.w	 #6,d6
 bne SP_NextSq
 lea     12(a3),a3
SP_NextSq:
 dbra	 d4,SP_PutSq
 movem.l (a7)+,d0-d5/a0-a4
 rts

; this has the same changes as the previous routine

RemovePiece:   ; Removes the piece at (A0) at D0,D1
 movem.l d0-d5/a0-a2,-(a7)
 lea     $4C00,a1
 move.l  gray4lib::plane0,a2
 subq	 #2,d0
 subq	 #2,d1
 moveq	 #3,d4
RP_ClrSq:
 move.w  d0,d2
 move.w  d1,d3
 add.w	 (a0)+,d3
 add.w	 (a0)+,d2
 btst	 #15,d3
 bne RP_SkipSq
; changed to 180
 mulu	 #180,d3
 add.w	 d2,d3
; changed to 5 from 7
 moveq #5,d5
RP_PutRow:
 clr.b	 0(a1,d3)
 clr.b	 0(a2,d3)
 add.w	 #30,d3
 dbra	 d5,RP_PutRow
RP_SkipSq:
 dbra	 d4,RP_ClrSq
 movem.l (a7)+,d0-d5/a0-a2
 rts

Uncrunch:     ; Uncrunch piece D0, rot D1 into (A0)
 movem.l d0-d2/a0-a1,-(a7)
 lea	 pieces(PC),a1
 lsl.w	 #3,d0
 lsl.w	 #1,d1
 add.w	 d1,d0
 move.w  0(a1,d0),d0
 moveq	 #7,d1
GetBits:
 move.w  d0,d2
 lsr.w	 #2,d0
 and.w	 #$03,d2
 move.w  d2,(a0)+
 dbra	 d1,GetBits
 movem.l (a7)+,d0-d2/a0-a1
 rts

NewGame:
 bsr ClrScr
 moveq	 #17,d0
 move.l  a5,a1
ClrBoard:
 move.l  #$01010100,(a1)+
 clr.l	 (a1)+
 clr.l	 (a1)+
 move.l  #$00010101,(a1)+
 dbra	 d0,ClrBoard
 moveq	 #7,d0
BBorder:
 move.w  #$0101,(a1)+
 dbra	 d0,BBorder
 tst.w	 twopl
 beq StartGame
 lea	 waitdialog(PC),a6
 bsr ShowDialog
 SetFont #0
 WriteStr #84,#71,#4,canctxt(PC)
 bsr CopyScreen
 move.b  #$AA,d0
 bsr SendByte
WaitReply:
 clr.w   $759a;$75B0
 bsr ReceiveByte
NoByte:
 cmp.b	 #$AA,d0
 beq SynchDone
; cmp.w   #264,$75B2
; bne WaitReply
 clr.w   $759a;$75B0
 addq	 #4,a7
 bra MainRepeat
SynchDone:
 move.b  #$AA,d0
 bsr SendByte
 bsr ClrScr
 clr.l	 d1
 bsr ShowBar
StartGame:
 st	 intflag
 bsr ShowBrickWall
 move.w  high(PC),d1
 beq NoTrashRows
 lsl.w	 #1,d1
 subq	 #1,d1
TrashRows:
 bsr TrashRow
 dbra	 d1,TrashRows
NoTrashRows:
 bsr RandomNewPiece
 bsr NewPiece
 clr.l	 score
 clr.w	 lines
 lea	 levels(PC),a0
 move.w  level(PC),d0
 move.w  d0,st_lev
 lsl.w	 #1,d0
 move.w  0(a0,d0),levtimer
ShowInfoText:
; font type changed, all the x and y positions were changed
 SetFont #1
 WriteStr #105,#10,#4,scoretxt(PC)
 WriteStr #105,#30,#4,leveltxt(PC)
 WriteStr #105,#50,#4,linestxt(PC)
 bsr ShowScore
 rts

WriteChar:
 movem.l d0-d2/a0,-(a7)
 move.w  #$00FF,-(a7)
 clr.w	 -(a7)
 move.w  #$00FF,-(a7)
 move.w  #4,-(a7)
 move.w  d1,-(a7)
 move.w  d0,-(a7)
 move.w  d2,-(a7)
 jsr util::DrawCharXY
 lea	 14(a7),a7
 movem.l (a7)+,d0-d2/a0
 rts

; CONVERTED!!! 5/15/98!!

Menu:
 bsr ShowTetrisLogo
 SetFont #2
 lea     $4C00+46*30+1,a0
 moveq	 #32,d0
VLines:
 moveq	 #10,d1
 move.l  a0,a1
VLine:
 move.b #$80,(a1)
 cmp.b	 #4,d1
 addq	 #2,a1
 dbra	 d1,VLine
 lea	 30(a0),a0
 dbra	 d0,VLines
 lea     $4C00+46*30+1,a0
 moveq	 #2,d0
HLines:
 moveq	 #17,d1
HLine:
 move.w  d1,d2
 sub.w	 #6,d2
 asr.w	 #1,d2
 beq SkipHLine
 st	 (a0)
SkipHLine:
 addq	 #1,a0
 dbra	 d1,HLine
 lea	 462(a0),a0
 dbra	 d0,HLines
 moveq	 #12,d0
 moveq	 #50,d1
 moveq	 #48,d2
 moveq	 #9,d3
PutLDig:
 bsr WriteChar
 add.w	 #16,d0
 addq	 #1,d2
 cmp.w	 #53,d2
 bne LSameRow
 moveq	 #12,d0
 moveq	 #66,d1
LSameRow:
 dbra	 d3,PutLDig
 move.w  #108,d0
 moveq	 #50,d1
 moveq	 #48,d2
 moveq	 #5,d3
PutRDig:
 bsr WriteChar
 add.w	 #16,d0
 addq	 #1,d2
 cmp.w	 #51,d2
 bne RSameRow
 move.w  #108,d0
 moveq	 #66,d1
RSameRow:
 dbra	 d3,PutRDig
 WriteStr #30,#33,#4,leveltxt(PC)
 WriteStr #115,#33,#4,hightxt(PC)
 SetFont #1
 WriteStr #12,#79,#4,tptxt(PC)
 WriteStr #12,#91,#4,ltxt(PC)
 move.l  #$000FE000,$4C00+87*30
 move.w  #$0FE0,$4C00+99*30+4
 bsr CopyScreen
 bsr ShowFlags
 move.w  st_lev(PC),d0
 move.w  d0,d1
 moveq	 #9,d6
 moveq	 #5,d5
 bsr Mark
 move.w  high(PC),d0
 moveq	 #5,d6
 moveq	 #3,d5
 bsr Mark
 clr.l	 d7
ChooseLevel:
 moveq	 #5,d5
 moveq	 #9,d6
ResTimer:
 move.w  #200,timer
WaitKey:
 tst.w	 timer
 bne NoFlash
 move.w  #200,timer
 move.w  d1,d0
 bsr Mark
NoFlash:
; i changed the key addresses to Plusshell convention here

 tst.w   (doorsos::kb_vars+$1C)
 beq WaitKey
 move.w  d1,d2

 move.w  (doorsos::kb_vars+$1E),d0

 clr.w   (doorsos::kb_vars+$1C)
; some of the following keycodes may have been changed, these are the
; standard codes listed in the manual unlike the others in the program
 cmp.w	 #337,d0
 bne CDown
 cmp.w	 d5,d1
 bcs WaitKey
 sub.w	 d5,d1
 bra Update
CDown:
 cmp.w	 #340,d0
 bne CLeft
 cmp.w	 d5,d1
 bcc WaitKey
 add.w	 d5,d1
 bra Update
CLeft:
 cmp.w	 #338,d0
 bne CRight
 tst.w	 d1
 beq WaitKey
 subq	 #1,d1
 bra Update
CRight:
 cmp.w	 #344,d0
 bne COther
 cmp.w	 d6,d1
 beq WaitKey
 addq	 #1,d1
Update:
 tst.w	 d7
 bne NoRemove
 move.w  d2,d0
 bsr Mark
NoRemove:
 move.w  d1,d0
 bsr Mark
 clr.l	 d7
 move.w  #200,timer
 bra WaitKey
COther:
 cmp.w	 #264,d0
 beq Return
 cmp.w	 #51,d0
 beq ChangeLLFlag
 cmp.w	 #116,d0
 beq ChangeTPFlag
 cmp.w	 #257,d0
 bne CEnter
 cmp.w	 #9,d6
 beq WaitKey
 tst.w	 d7
 beq ChooseLev
 move.w  d1,d0
 bsr Mark
ChooseLev:
 move.w  d1,high
 move.w  level(PC),d1
 bra ChooseLevel
CEnter:
 cmp.w	 #13,d0
 bne WaitKey
 cmp.w	 #9,d6
 bne HighChosen
 move.w  d1,level
 tst.w	 d7
 beq ChooseHigh
 move.w  d1,d0
 bsr Mark
ChooseHigh:
 moveq	 #3,d5
 moveq	 #5,d6
 move.w  high(PC),d1
 bra ResTimer
HighChosen:
 move.w  d1,high
Return:
 rts

ChangeLLFlag:
 eori.w  #8,llflag
 bsr ShowFlags
 bra WaitKey

ChangeTPFlag:
 eori.w  #8,twopl
 bsr ShowFlags
 bra WaitKey

PutSprite:
 moveq	 #7,d0
PS_PutRow:
 move.b  (a0)+,(a1)
 lea	 30(a1),a1
 dbra	 d0,PS_PutRow
 rts

PutSprite6:
 moveq	 #5,d0
PS_PutRow6:
 move.b  (a0)+,(a1)
 lea	 30(a1),a1
 dbra	 d0,PS_PutRow6
 add.w #2,a0
 rts

ShowFlags:
 lea	 box(PC),a0
 add.w	 twopl(PC),a0
 move.l  a0,a2
 move.l  gray4lib::plane0,a3
 lea     $4C00+2400,a1
 bsr PutSprite
 add.w	 #2400,a3
 move.l  a3,a1
 move.l  a2,a0
 bsr PutSprite

 lea	 box(PC),a0
 add.w	 llflag(PC),a0
 move.l  a0,a2
 move.l  gray4lib::plane0,a3
 lea     $4C00+2730,a1
 bsr PutSprite
 add.w	 #2730,a3
 move.l  a3,a1
 move.l  a2,a0
 bsr PutSprite
 rts

Mark:
 movem.l d0-d1/a0,-(a7)
 bchg	 #0,d7
 lea     $4C00+47*30+1,a0
 cmp.w	 #9,d6
 beq MarkLevel
 lea	 12(a0),a0
MarkLevel:
 cmp.w	 d5,d0
 bcs MarkSquare
 sub.w	 d5,d0
 lea	 480(a0),a0
MarkSquare:
 lsl.w	 #1,d0
 moveq	 #14,d1
ML_MarkRow:
 eori.b  #$7F,0(a0,d0)
 eori.b  #$FF,1(a0,d0)
 lea	 30(a0),a0
 dbra	 d1,ML_MarkRow
 movem.l (a7)+,d0-d1/a0
 rts

CopyScreen:
 movem.l d0/a0-a1,-(a7)
 lea     $4C00,a0
 move.l  gray4lib::plane0,a1
 move.w  #959,d0
RepCopy:
 move.l  (a0)+,(a1)+
 dbra	 d0,RepCopy
 movem.l (a7)+,d0/a0-a1
 rts

Titel:
 bsr ShowTetrisLogo
 SetFont #2
 WriteStr #40,#60,#4,top5txt(PC)
; i changed the credits ; -)
 SetFont #1
 WriteStr #30,#30,#4,author1(PC)
 WriteStr #15,#42,#4,author2(PC)
 lea	 hiscore(PC),a2
 moveq	 #5,d0
 moveq	 #76,d1
 move.l  #$002E0031,d2
 moveq	 #2,d3
ShowHiscore:
 bsr WriteChar
 swap	 d2
 addq	 #6,d0
 bsr WriteChar
 swap	 d2
 subq	 #6,d0
 move.l  d1,d4
 movem.l d0-d2,-(a7)
 WriteStrA #23,d1,#4,a2
 lea	 tmpstr+6(PC),a0
 move.l  16(a2),d0
 moveq	 #6,d1
 bsr ConvStr
 WriteStrA #120,d4,#4,a0
 movem.l (a7)+,d0-d2
 lea	 20(a2),a2
 addq	 #1,d2
 addq	 #8,d1
 dbra	 d3,ShowHiscore
 bsr CopyScreen
 rts

ShowTetrisLogo:
 bsr ClrScr
; had to reposition the logo by changing this address
 lea     $4c04,a0
 lea	 logo(PC),a1
 moveq	 #27,d0
ShowLogo:
 moveq	 #4,d1
ShowLogoRow:
 move.w  (a1)+,(a0)+
 dbra	 d1,ShowLogoRow
 lea	 20(a0),a0
 dbra	 d0,ShowLogo
 rts

ShowDialog:
 jsr util::show_dialog
CopyDialogBox:
 lea     $4C00+$1C*30+2,a0
 move.l  gray4lib::plane0,a1
 add.w	 #$1C*30+2,a1
 moveq	 #39,d0
SD_CopyRow:
 moveq	 #13,d1
SD_CopyByte:
 move.b  (a0)+,(a1)+
 dbra	 d1,SD_CopyByte
 lea	 16(a0),a0
 lea	 16(a1),a1
 dbra	 d0,SD_CopyRow
 rts

ClrScr:
 movem.l d0/a0-a1,-(a7)
 lea     $4C00,a0
 move.l  gray4lib::plane0,a1
 move.w  #959,d0
RepClr:
 clr.l	 (a0)+
 clr.l	 (a1)+
 dbra	 d0,RepClr
 movem.l (a7)+,d0/a0-a1
 rts

; thoughts on this one...
; a keymap needs to be made for this, the 89 only has 6 or 7 blocks of
; keys to read instead of 10 on the 92

GetKeyStat:
 movem.l d0-d1/a0,-(a7)
 lea	 keystat(PC),a0
 move.w  #$FFFE,d0
 moveq	 #6,d1
GetKeys:
 move.w  d0,$600018
 nop
 nop
 nop
 nop
 nop
 nop
 nop
 nop
 nop
 nop
 nop
 nop
 nop
 nop
 nop
 nop
 move.b  $60001B,(a0)+
; nop
; nop
; nop
; nop
; nop
; nop
; nop
; nop
; nop
; nop
; nop
; nop
; nop
; nop
; nop
; nop
 rol.w	 #1,d0
 dbra	 d1,GetKeys
 movem.l (a7)+,d0-d1/a0
 rts

ShowBrickWall:
; changed the address a bit i think
 lea     $4C00,a0
 move.l  gray4lib::plane0,a1
; this got changed so the walls are on the side of the screen not the middle
 moveq	 #11,d0
PutBrickWall:
 lea	 brickgfx(PC),a2
 moveq	 #7,d1
PBWRow:
 move.b  (a2),(a0)
 move.b  8(a2),(a1)
 move.b  (a2)+,11(a0)
 move.b  7(a2),11(a1)
 lea	 30(a0),a0
 lea	 30(a1),a1
 dbra	 d1,PBWRow
 dbra	 d0,PutBrickWall
 rts

SendByte:
 movem.l d0-d1/a0-a1,-(a7)
 move.b  d0,linkbuf
 move.w  #1,-(a7)
 pea	 linkbuf(PC)
 jsr doorsos::transmit
 addq	 #6,a7
 movem.l (a7)+,d0-d1/a0-a1
 rts

ReceiveByte:
 movem.l d1/a0-a1,-(a7)
 clr.b	 linkbuf
 move.w  #1,-(a7)
 pea	 linkbuf(PC)
 jsr doorsos::receive
 addq	 #6,a7
 clr.l	 d0
 move.b  linkbuf(PC),d0
 movem.l (a7)+,d1/a0-a1
 rts

Init:

	lea board,a5


 sf	 intflag
; move.w  #$0700,d0
; trap #1
 move.l  ($64),oldint1
; bclr.b #2,$600001
 move.l  #IntHandler,($040064)
; bset.b #2,$600001
; trap #1
 jsr gray4lib::on
 rts

Done:
 jsr gray4lib::off
; move.w  #$2700,d0
; trap #1
; bclr.b #2,$600001
 move.l  oldint1(PC),($040064)
; bset.b #2,$600001
; trap #1
; movem.l (a7)+,d0-d7/a0-a6
 rts

IntHandler:
 tst.w	 timer
 beq DecLTimer
 subq.w  #1,timer
DecLTimer:
 tst.w	 ltimer
 beq DecRTimer
 subq.w  #1,ltimer
DecRTimer:
 tst.w	 rtimer
 beq CheckFlag
 subq.w  #1,rtimer
CheckFlag:
 tst.b   intflag
 bne EndInt
 move.l  oldint1(PC),-(a7)
 rts
EndInt:
 rte

oldint1  dc.l 0

curp	 ds.w 8
nextp	 ds.w 8
tmpp	 ds.w 8
curPN	 dc.w 0
nextPN	 dc.w 0
x	 dc.w 0
y	 dc.w 0
rot	 dc.w 0
rows	 ds.w 4

score	 dc.l 0
lines	 dc.w 0

level	 dc.w 0
high	 dc.w 0

st_lev	 dc.w 0
st_high  dc.w 0
disUflag dc.w 0
disDflag dc.w 0
llflag	 dc.w 0
twopl	 dc.w 0

timer	 dc.w 0
ltimer	 dc.w 0
rtimer	 dc.w 0
levtimer dc.w 0

tmpstr	 ds.b 8

levels
 dc.w 310,258,215,179,149,124,104,86,72,60
 dc.w 51,40,36,32,28,24,20,16,13,10,8,6,5,4,3,2,1,0

scoring
 dc.w 40,100,300,1200

pieces
 dc.w %0010011010101011,%0101011000110111
 dc.w %0001001001101010,%0101100101100111
 dc.w %0010011010100011,%0001010101100111
 dc.w %0010011010101001,%0101011001111011
 dc.w %0110101001111011,%0110101001111011
 dc.w %0110101001111011,%0110101001111011
 dc.w %0010011010100111,%0010010101100111
 dc.w %0010010101101010,%0101011001111010
 dc.w %0011011001111010,%0001001001100111
 dc.w %0011011001111010,%0001001001100111
 dc.w %0010011001111011,%0010001101010110
 dc.w %0010011001111011,%0010001101010110
 dc.w %0010011010101110,%0100010101100111
 dc.w %0010011010101110,%0100010101100111

empty
 dc.w 0,0,0,0,0,0,0,0

pgfx
 dc.b %11111111,%10000001,%10111101,%10100101,%10111101,%11111111
 dc.b %11111111,%11111111,%11111111,%11100111,%11111111,%11111111

 dc.b %11111111,%11111111,%11111111,%11111111,%11111111,%11111111
 dc.b %11111111,%10000001,%10000001,%10000001,%10000001,%11111111

 dc.b %11111111,%10000001,%10011001,%10011001,%10000001,%11111111
 dc.b %11111111,%10000001,%10011001,%10011001,%10000001,%11111111

 dc.b %11111111,%10000001,%10000001,%10000101,%10111101,%11111111
 dc.b %11111111,%11000011,%11011111,%11011111,%11011111,%11111111

 dc.b %11111111,%11111111,%11111111,%11100111,%11100111,%11111111
 dc.b %11111111,%10000001,%10111101,%10100101,%10111101,%11111111

 dc.b %11111111,%10000001,%10011001,%10011001,%10000001,%11111111
 dc.b %11111111,%11111111,%11111111,%11111111,%11111111,%11111111

 dc.b %11111111,%10001001,%00100001,%00000101,%01010001,%11111111
 dc.b %11111111,%11111111,%11111111,%11111111,%11111111,%11111111
 dc.b %11111111,%10101000,%00000010,%01000000,%10000100,%11111111
 dc.b %11111111,%11111111,%11111111,%11111111,%11111111,%11111111
 dc.b %11111111,%10100000,%00000010,%00100000,%10000100,%11111111
 dc.b %11111111,%11111111,%11111111,%11111111,%11111111,%11111111
 dc.b %11111111,%10100100,%10000000,%11001000,%10000000,%11111111
 dc.b %11111111,%11111111,%11111111,%11111111,%11111111,%11111111
 dc.b %10000011,%10010001,%11000101,%10010101,%11000011,%11111111
 dc.b %11111111,%11111111,%11111111,%11111111,%11111111,%11111111
 dc.b %10010011,%11000001,%10001011,%10100001,%10000011,%11010001
 dc.b %11111111,%11111111,%11111111,%11111111,%11111111,%11111111
 dc.b %10010011,%11000001,%10001011,%10100001,%10000001,%10110001
 dc.b %11111111,%11111111,%11111111,%11111111,%11111111,%11111111 
 dc.b %11111111,%10001001,%10100011,%10000001,%11001001,%10000011
 dc.b %11111111,%11111111,%11111111,%11111111,%11111111,%11111111

; dc.b %11111111,%10001001,%00100001,%00000101,%01010001,%00000011,%00101001,%11111111
; dc.b %11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111
; dc.b %11111111,%10101000,%00000010,%01000000,%10000100,%00010001,%01000100,%11111111
; dc.b %11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111
; dc.b %11111111,%10100000,%00000010,%00100000,%10000100,%00010001,%01000100,%11111111
; dc.b %11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111
; dc.b %11111111,%10100100,%10000000,%11001000,%10000000,%10100010,%10001000,%11111111
; dc.b %11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111
; dc.b %10000011,%10010001,%11000101,%10010101,%11000011,%10000101,%10100001,%11111111
; dc.b %11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111
; dc.b %10010011,%11000001,%10001011,%10100001,%10000011,%11010001,%10000101,%10100001
; dc.b %11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111
; dc.b %10010011,%11000001,%10001011,%10100001,%10000001,%10110001,%10000101,%10100001
; dc.b %11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111 
; dc.b %11111111,%10001001,%10100011,%10000001,%11001001,%10000011,%10101001,%10000001
; dc.b %11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111,%11111111
 
box
 dc.b %1111111,%1000001,%1000001,%1000001,%1000001,%1000001,%1111111,0
 dc.b %1111111,%1100011,%1010101,%1001001,%1010101,%1100011,%1111111,0

bargfx
 dc.b $C6,$82,$82,$82,$82,$C6
 dc.b $C6,$82,$BA,$BA,$82,$C6

brickgfx
 dc.b %01000100,%01000100,%01000100,%11111111,%00010001,%00010001,%00010001,%11111111
 dc.b %01011101,%11111111,%11111111,%11111111,%01110111,%11111111,%11111111,%11111111

logo
 dc.b $00,$00,$00,$04,$00,$00,$00,$00,$00,$00
 dc.b $00,$7F,$FF,$F8,$00,$00,$00,$00,$00,$00
 dc.b $03,$FF,$FF,$F0,$00,$00,$00,$00,$00,$00
 dc.b $0F,$FF,$FF,$C0,$00,$00,$00,$06,$00,$00
 dc.b $1F,$C0,$00,$00,$00,$20,$00,$0F,$00,$00
 dc.b $38,$38,$00,$00,$00,$20,$00,$0F,$00,$00
 dc.b $60,$07,$00,$00,$00,$60,$00,$0E,$00,$00
 dc.b $40,$03,$C0,$00,$00,$60,$00,$04,$00,$00
 dc.b $80,$01,$E0,$00,$00,$E0,$00,$00,$00,$00
 dc.b $80,$01,$E0,$01,$E3,$F8,$41,$86,$01,$C8
 dc.b $80,$00,$F0,$07,$F0,$E0,$E3,$CF,$07,$F8
 dc.b $00,$00,$F0,$0C,$F8,$E1,$E7,$D7,$0C,$30
 dc.b $03,$80,$F8,$18,$70,$E2,$ED,$C7,$0E,$10
 dc.b $0C,$60,$78,$18,$60,$E0,$E9,$87,$0F,$00
 dc.b $10,$30,$78,$38,$40,$E0,$F1,$07,$07,$80
 dc.b $20,$18,$78,$38,$80,$E0,$E0,$07,$03,$E0
 dc.b $20,$18,$78,$39,$00,$E0,$E0,$07,$01,$F0
 dc.b $40,$18,$78,$3A,$00,$E0,$E0,$07,$08,$78
 dc.b $40,$18,$78,$3C,$00,$E4,$E0,$07,$08,$38
 dc.b $40,$10,$78,$3E,$10,$E8,$E0,$07,$4C,$18
 dc.b $60,$20,$78,$1F,$E0,$F0,$E0,$07,$8F,$30
 dc.b $60,$00,$70,$0F,$C0,$60,$C0,$03,$07,$E0
 dc.b $70,$00,$F0,$00,$00,$00,$00,$00,$00,$00
 dc.b $30,$00,$E0,$00,$00,$00,$00,$00,$00,$00
 dc.b $38,$01,$C0,$00,$00,$00,$00,$00,$00,$00
 dc.b $1C,$03,$80,$00,$00,$00,$00,$00,$00,$00
 dc.b $0F,$0F,$00,$00,$00,$00,$00,$00,$00,$00
 dc.b $03,$FC,$00,$00,$00,$00,$00,$00,$00,$00

; i changed the dialog box positions (1st two longs) on each of these

losedialog
 dc.l $0010001C,$007F0044,$0013000F,gotxt,0

windialog
 dc.l $0010001C,$007F0044,$001B000F,wintxt,0

waitdialog
 dc.l $0010001C,$007F0044,$001B000C,waittxt,0

pausedialog
 dc.l $0010001C,$007F0044,$0023000C,pausetxt,0

hiscore
 dc.b "---------------",0,0,0,0,0
 dc.b "---------------",0,0,0,0,0
 dc.b "---------------",0,0,0,0,0
; dc.b "---------------",0,0,0,0,0
; dc.b "---------------",0,0,0,0,0

intflag  dc.b 0
downflag dc.b 0
upflag	 dc.b 0
linkbuf  dc.b 0
tkflag	 dc.b 0

keystat  ds.b 7

oldstackptr dc.l 0

scoretxt dc.b "SCORE",0
leveltxt dc.b "LEVEL",0
linestxt dc.b "LINES",0
hightxt  dc.b "HIGH",0
pausetxt dc.b "PAUSE",0
paus2txt dc.b "PRESS ANY KEY",0
waittxt  dc.b "WAITING",0
canctxt  dc.b "PRESS ESC TO CANCEL",0
gotxt	 dc.b "GAME OVER",0
wintxt	 dc.b "YOU WIN",0

tptxt	 dc.b "Two player mode (link)",0
ltxt	 dc.b "2P: Send one row less",0

; split into two lines
author1	 dc.b "by Jimmy M",$E2,"rdell",0
author2	 dc.b "Ported by Joel Jordan",0

top5txt  dc.b "TOP THREE",0
ent1txt  dc.b "CONGRATULATIONS!",0
ent2txt  dc.b "You entered the Top Three list!",0
ent3txt  dc.b "Enter your name:",0

_comment dc.b "Tetris 1.21",0

	BSS
board ds.b 304

 end
