; Nibble89 v1.1
; last update: 7/2/99
; by Alban Gervaise (GefunS@I-France.com)


        include "doorsos.h"
        include "graphlib.h"
        include "userlib.h"
        include "nibble89.lvl"
        include "nibble89.pic"

        xdef _main
        xdef _comment
        xdef _ti89



Take_str MACRO
        move.w \1,d5
        move.w \2,d6
        move.w \3-1,d7
        move.w d7,d4
        bsr take_string
        ENDM


print_d0 MACRO
        bsr print_value
        move.w  \3,-(a7)
        move.l  a0,-(a7)
        move.w  \2,-(a7)
        move.w  \1,-(a7)
        jsr     doorsos::DrawStrXY
        lea 10(a7),a7
        ENDM


mask0 equ %11111110  ;(up\2nd\donw...)
mask1 equ %11111101  ;(Enter\clear...)
mask2 equ %11111011  ;( <- )
mask3 equ %11110111  ;(catalog...)
mask4 equ %11101111  ;(Mode...)
mask5 equ %11011111  ;(Home...)
mask6 equ %10111111  ;(ESC...)

LONG =  20  ; la longeur du nibble est de 20 pixel

        dc.l 'ICON'
        dc.w %1111111111111111
        dc.w %1011110000000001
        dc.w %1000011101001101
        dc.w %1000000000000101
        dc.w %1000000001111101
        dc.w %1000001111000001
        dc.w %1000000000000001
        dc.w %1111111111111111

_main:
        move.w #40,x_cur
        clr.b select
menu    bsr pic
        move.w #1,-(a7)
        jsr doorsos::FontSetSys
        lea.l play_str(pc),a4
        moveq #3,d7
        moveq #40,d5
loopp   move.w #4,-(a7)
        move.l a4,-(a7)
        move.w d5,-(a7)
        move.w #45,-(a7)
        jsr doorsos::DrawStrXY
        add.w #8,d5
        add.l #12,a4
        dbra.s d7,loopp
        lea 42(a7),a7
        bsr invert
select_loop:
        jsr userlib::idle_loop
        cmp.w #264,d0
        beq exit
        cmp.w #340,d0
        beq.s sbas
        cmp.w #337,d0
        beq.s shaut
        cmp.w #13,d0
        beq.S selection
        bra select_loop
sbas    cmp.b #3,select
        beq.s select_loop
        add.b #1,select
        moveq #7,d6
loopb   bsr.s invert
        add.w #1,x_cur
        bsr.S invert
        dbra.s d6,loopb                     
        bra.s select_loop
shaut   tst.b select
        beq.s select_loop
        sub.b #1,select
        moveq #7,d6
looph   bsr.s invert
        sub.w #1,x_cur
        bsr.s invert
        dbra.s d6,looph
        bra.s select_loop
invert  moveq #7,d4
        move.w x_cur,d1
loopi   moveq #15,d0
        move.w #147,d2
        clr.w d3
        jsr graphlib::horiz
        add.w #1,d1
        move.w #1000,d7
\loop   dbra.s d7,\loop
        dbra.s d4,loopi
        rts
selection:
        tst.b select
        beq start_game
        cmp.b #3,select
        beq exit
        cmp.b #2,select
        beq print_high
        bra options_menu
print_high:
        bsr.s disp_high
\wait   jsr userlib::idle_loop
        cmp.w #264,d0
        beq menu
        cmp.w #13,d0
        beq menu
        bra \wait
disp_high
        bsr pic
        lea.l veasy_str(pc),a5
        moveq #31,d6
        moveq #4,d7
loop1   move.w #1,-(a7)
        move.l a5,-(a7)
        move.w d6,-(a7)
        clr.w -(a7)
        jsr doorsos::DrawStrXY   ;10*5
        add.w #10,d6
        add.l #7,a5
        dbra.s d7,loop1
        moveq #4,d6
        lea.l veasy(pc),a5
        moveq #31,d7
loopps  move.w #1,-(a7)
        move.l a5,-(a7)
        move.w d7,-(a7)
        move.w #46,-(a7)
        jsr doorsos::DrawStrXY   ;10*5
        add.w #10,d7
        lea 16(a5),a5
        dbra.s d6,loopps
        lea.l veasy+14(pc),a5
        moveq #4,d6
        moveq #31,d7
loop0   move.w (a5),d0
        print_d0 #130,d7,#4
        add.w #10,d7
        lea 16(a5),a5
        dbra.s d6,loop0
        lea 100(a7),a7
        rts
options_menu:      
        bsr pic
        lea.l mode_str(pc),a4
        moveq #4,d7
        moveq #40,d5
looop   move.w #4,-(a7)
        move.l a4,-(a7)
        move.w d5,-(a7)
        move.w #25,-(a7)
        jsr doorsos::DrawStrXY
        add.w #8,d5
        add.l #6,a4
        dbra.s d7,looop
        lea 50(a7),a7
        move.w #40,x_cur
        clr.b select
        bsr put_option
option_loop:
        jsr userlib::idle_loop
        cmp.w #264,d0
        beq.s \retour
        cmp.w #340,d0
        beq.S osbas
        cmp.w #337,d0
        beq.S oshaut
        cmp.w #13,d0
        beq.s option_select
        bra.S option_loop
\retour move.b #1,select
        move.w #48,x_cur
        bra menu
osbas   cmp.b #4,select
        beq.s option_loop
        add.b #1,select
        moveq #7,d6
looopb  bsr invert
        add.w #1,x_cur
        bsr invert
        dbra.s d6,looopb
        bra.s option_loop
oshaut  tst.b select
        beq.s option_loop
        sub.b #1,select
        moveq #7,d6
loooph  bsr invert
        sub.w #1,x_cur
        bsr invert
        dbra.s d6,loooph
        bra.s option_loop
option_select:
        bsr invert
        tst.b select
        beq.s change_mode
        cmp.b #1,select
        beq.s change_diff
        tst.b sel_1
        beq.s \passe
        cmp.b #2,select
        beq.s change_level
        cmp.b #3,select
        beq change_wrap
        cmp.b #4,select
        beq.s change_lives
\passe  bsr invert
        bra option_loop
change_mode:
        tst.b sel_1
        bne.s chgmd
        move.b #1,sel_1
disp    bsr put_option
        bra option_loop
chgmd   clr.b sel_1
        bclr.b #1,flag
        move.b #3,sel_5
        move.B #1,sel_3
        bra.s disp
change_diff
        cmp.b #4,sel_2
        beq.s chgdiff
        add.b #1,sel_2
        bra.S disp
chgdiff clr.b sel_2
        bra.s disp
change_level:
        cmp.b #level_nbr,sel_3
        beq.s chglvl
        add.b #1,sel_3
        bra.s disp
chglvl  move.b #1,sel_3
        bra.s disp
change_lives
        cmp.b #6,sel_5
        beq.s chglive
        add.b #1,sel_5
        bra.s disp
chglive move.b #2,sel_5
        bra.s disp
change_wrap
        bchg.b #1,flag
        bra disp
put_option:
        clr.l d0
        move.b sel_1,d0
        lea.l play_1(pc),a0
        mulu #5,d0
        add.l d0,a0
        move.w #4,-(a7)
        move.l a0,-(a7)
        move.l #$00650028,-(a7)
        jsr doorsos::DrawStrXY    ; 10
        clr.l d0
        move.b sel_2,d0
        lea.l veasy_str(pc),a0
        mulu #7,d0
        add.l d0,a0
        move.w #4,-(a7)
        move.l a0,-(a7)
        move.l #$005F0030,-(a7)
        jsr doorsos::DrawStrXY    ;10
        clr.l d0
        move.b sel_3,d0
        sub.b #1,d0
        print_d0 #110,#56,#4
        lea.l off_str(pc),a0
        btst.b #1,flag
        beq.s \passe
        lea 4(a0),a0
\passe  move.w #4,-(a7)
        move.l a0,-(a7)
        move.l #$00650040,-(a7)
        jsr doorsos::DrawStrXY    ;10
        clr.l d0
        move.b sel_5,d0
        print_d0 #110,#72,#4
        lea 30(a7),a7
        bra invert
pic     jsr graphlib::clr_scr
        lea.l picture1(pc),a0
        move.b #$FF,d3
        moveq #10,d0
        clr.w d1
        jsr graphlib::put_sprite_mask
        clr.w -(a7)
        jsr doorsos::ST_busy
        pea email(pc)
        jsr doorsos::ST_showHelp
        lea 6(a7),a7
        rts



start_game:
        clr.l d0
        move.b sel_3,d0
        sub.b #1,d0
        move.w d0,level
        bset.b #0,flag
        clr.l d0
        move.b sel_5,d0
        move.w d0,lives_1
        move.w d0,lives_2
        move.w #1000,time
        tst.b sel_1       ; play solo
        bne \apres
        bclr.b #1,flag    ; no wrap
        bclr.b #0,flag    ; play solo
        clr.w level       ; begin at level 1
        move.w #3,lives_1 ; have 3 lives
\apres  lea.l speed_table(pc),a0
        clr.w d0
        move.b sel_2,d0
        mulu #2,d0
        move.w 0(a0,d0.w),speed
        bsr int_on
        move.w #3,lives
othloop bsr ini_var
        bsr ini_screen
        bsr disp_level
dieloop bsr ini_screen
        bsr ini_random
        btst.b #0,flag
        bne info
        bsr big_info_1p
        bra info_1p
main_loop:
        bsr delay
        btst.b #0,flag
        beq \apres
        move.w #mask0,d0
        bsr get_key
        btst.b #4,d0
        beq up_2
        btst.b #7,d0
        beq right_2
        btst.b #6,d0
        beq left_2
        move.w #mask5,d0
        bsr get_key
        btst.B #6,d0
        beq down_2

\apres  move.w #mask0,d0
        bsr get_key
        btst.b #0,d0
        beq up_1
        btst.b #3,d0
        beq right_1
        btst.b #1,d0
        beq left_1
        btst.b #2,d0
        beq down_1
        move.w #mask6,d0
        bsr get_key
        btst.b #0,d0
        beq fin_du_jeu
        move.w #mask1,d0
        bsr get_key
        btst.b #0,d0
        beq pause
        bra up_dated

revient bsr wait_key_esc_off
        bsr int_off
        bra menu

down_1  cmp.w #3,dir_1
        beq up_dated
        move.w #1,dir_1
        bra up_dated
up_1    cmp.w #1,dir_1
        beq up_dated
        move.w #3,dir_1
        bra up_dated
right_1 tst.w dir_1
        beq up_dated
        move.w #2,dir_1
        bra up_dated
left_1  cmp.w #2,dir_1
        beq up_dated
        clr.w dir_1
        bra up_dated

down_2  cmp.w #3,dir_2
        beq up_dated
        move.w #1,dir_2
        bra up_dated
up_2    cmp.w #1,dir_2
        beq up_dated
        move.w #3,dir_2
        bra up_dated
right_2 tst.w dir_2
        beq up_dated
        move.w #2,dir_2
        bra up_dated
left_2  cmp.w #2,dir_2
        beq up_dated
        clr.w dir_2
        bra up_dated


up_dated:
        bsr m1_0
        bsr do_up_dated
        move.w d2,-(a7)
        bsr m0_1
        move.w (a7)+,d2
        btst.b #0,flag
        bne \passe
        cmp.w #2,d2
        beq p_touche
        cmp.w #1,d2
        beq die_1
        bra info_1p

\passe  cmp.w #1,d2
        beq p1_die
        cmp.w #2,d2
        beq p_1p
        bsr m2_0
        bsr do_up_dated
        move.w d2,-(a7)
        bsr m0_2
        move.w (a7)+,d2
        cmp.w #1,d2
        beq p2_die
        cmp.w #2,d2
        beq p_2p
        bra main_loop

do_up_dated:
        move.l #x,a0       ; quel point est a efface? 
        move.w long,d1     ;
        mulu #4,d1         ;long*4-4 = point a efface
        add.w d1,a0        ;
        sub.w #4,a0        ;
        move.l (a0),d0     ; si X=0 alors on efface pas
        tst.l d0        ;
        beq passe       ;
        move.w (a0)+,d0    ; on efface la fin de la queue...
        move.w (a0)+,d1    ;
        move.w #1,d2
        bsr pixel
        sub.w #1,d1
        bsr pixel
        sub.w #1,d0
        bsr pixel
        add.w #1,d1 
        bsr pixel
        move.l #0,-(a0)    ; et dans la liste des coordonnes
passe   move.l #z,a0       ; on decale les coordonnees d'un rang vers le bas
        move.l #z,a1       ;
        add.w #4,a1        ;
        move.w #LONG*LONG-1,d0      ;
\loop   move.l -(a0),-(a1) ;
        dbra d0,\loop       ;                          
        move.l #y,a0       ; on prend les anciennes premieres coordonnes
        move.w (a0)+,d0    ;
        move.w (a0),d1     ;
        tst.w dir
        beq dir0
        cmp.w #1,dir
        beq dir1
        cmp.w #2,dir
        beq dir2
        sub.w #2,d0
        bra apres 
dir0    sub.w #2,d1
        bra apres
dir1    add.w #2,d0 
        bra apres
dir2    add.w #2,d1
apres   bsr check_pixel
        tst.w d2
        bne touche
        cmp.w #94,d0
        bge hit
        move.l #x,a0       ; rien a l'horizon donc on met affiche le point
        move.w d0,(a0)+    ; et on le remet dans la x
        move.w d1,(a0)     ;
        bsr print_pixel
        clr.w d2           ; no error!
        rts


touche  move.l #point,a0
        cmp.w (a0)+,d0
        bne hit
        cmp.w (a0),d1
        bne hit
        move.w #2,d2
        rts
hit     move.w #1,d2
        rts

p_touche
        add.w #1,stade_1
        cmp.w #11,stade_1
        beq p_gagne
        add.w #LONG,long_1
        move.l #x1,a0       ; et les coordonnees du point sont maintenant
        move.l #point,a1   ; celle de la trainee
        move.l (a1),(a0)   ;
        bsr ini_random     ; on fait random pour avoir un nouveau point
        add.w #200,time    ; on remet un peu de temps
        bsr big_info_1p
        bra info_1p


p_gagne cmp.w #level_nbr-1,level
        beq gagne
        add.w #1,level
        add.w #500,time
        add.w #1,lives_1
        bra othloop


gagne   move.w #2,-(a7)
        jsr doorsos::FontSetSys
        move.w #4,-(a7)
        pea.l win_str(pc)
        move.w #25,-(a7)
        move.w #20,-(a7)
        jsr doorsos::DrawStrXY
        lea 12(a7),a7
        add.w #1000,time
        bra good

p_1p    add.w #1,stade_1
        cmp.w #11,stade_1
        beq.s p1_wins
        add.w #LONG,long_1
        move.l #x1,a0
rejoue  move.l #point,a1
        move.l (a1),(a0)
        bsr ini_random
        bra info
p_2p    add.w #1,stade_2
        cmp.w #11,stade_2
        beq p2_wins
        add.w #LONG,long_2
        move.l #x2,a0
        bra.s rejoue

p1_wins moveq #11,d7
        move.w #2,-(a7)
        jsr doorsos::FontSetSys
        move.w #4,-(a7)
        pea win1_str(pc)
        move.w #40,-(a7)
        clr.w -(a7)
        jsr doorsos::DrawStrXY
        lea 12(a7),a7
\loop   moveq #1,d0
        moveq #1,d1
        moveq #78,d2
        moveq #91,d3
        clr.w d4
        jsr graphlib::fill
        bsr delayc
        dbra.s d7,\loop
        bsr wait
        bra revient

p2_wins moveq #9,d7
        move.w #2,-(a7)
        jsr doorsos::FontSetSys
        move.w #4,-(a7)
        pea win2_str(pc)
        move.w #40,-(a7)
        move.w #80,-(a7)
        jsr doorsos::DrawStrXY
        lea 12(a7),a7
\loop   moveq #78,d0
        moveq #1,d1
        moveq #80,d2
        moveq #91,d3
        clr.w d4
        jsr graphlib::fill
        bsr delayc
        dbra.s d7,\loop
        bsr wait
        bra revient


delay   move.w speed,d7
delay_l nop
        dbra.s d7,delay_l
        rts



info    clr.w -(a7)
        jsr doorsos::FontSetSys
        pea p1_str
        jsr doorsos::ST_showHelp
        lea 6(a7),a7
        move.w stade_1,d0
        print_d0 #30,#95,#4
        move.w lives_1,d0
        print_d0 #40,#95,#4
        WriteStr #45,#95,#4,lives_str      
        WriteStr #70,#95,#4,p2_str
        move.w stade_2,d0
        print_d0 #100,#95,#4
        move.w lives_2,d0
        print_d0 #110,#95,#4
        WriteStr #115,#95,#4,lives_str
        bra main_loop


big_info_1p
        clr.w -(a7)
        jsr doorsos::FontSetSys
        pea score_str
        jsr doorsos::ST_showHelp
        lea 6(a7),a7
        WriteStr #130,#95,#1,titre
        move.w lives_1,d0
        print_d0 #48,#95,#1
        WriteStr #56,#95,#1,lives_str
        move.w level,d0
        print_d0 #90,#95,#1
        WriteStr #78,#95,#1,level_str
        WriteStr #103,#95,#4,dot_str
        move.w stade_1,d0
        print_d0 #120,#95,#4
        rts
info_1p WriteStr #23,#95,#4,blank_over
        sub.w #1,time
        beq timeout
        move.w time,d0
        print_d0 #23,#95,#4
        bra main_loop

timeout move.w #2,-(a7)
        jsr doorsos::FontSetSys
        pea.l ent_esc(pc)
        jsr doorsos::ST_showHelp
        lea 6(a7),a7
        WriteStr #44,#40,#4,time_out_str
        bsr wait
        move.w #1000,time
        sub.w #1,lives_1
        beq perdu
        bra othloop


p1_die  bsr m2_0
        bsr do_up_dated
        move.w d2,-(a7)
        bsr m0_2
        move.w (a7)+,d2
        cmp.w #1,d2
        beq die_12
        moveq #9,d7
        move.w #2,-(a7)
        jsr doorsos::FontSetSys
        lea 2(a7),a7
        WriteStr #20,#40,#4,crash_str
fx_loop moveq #1,d0
        moveq #1,d1
        moveq #78,d2
        moveq #91,d3
        clr.w d4
        jsr graphlib::fill
        bsr delayc
        dbra.s d7,fx_loop
        sub.w #1,lives_1
        beq p2_wins
        bra dieloop

p2_die  moveq #9,d7
        move.w #2,-(a7)
        jsr doorsos::FontSetSys
        lea 2(a7),a7
        WriteStr #100,#40,#4,crash_str
f2_loop moveq #78,d0
        moveq #1,d1
        moveq #80,d2
        moveq #91,d3
        clr.w d4
        jsr graphlib::fill
        bsr delayc
        dbra.s d7,f2_loop
        sub.w #1,lives_2
        beq p1_wins
        bra dieloop

die_12  moveq #9,d7
        move.w #2,-(a7)
        jsr doorsos::FontSetSys
        lea 2(a7),a7
        WriteStr #100,#40,#4,crash_str
f12loop moveq #78,d0
        moveq #1,d1
        moveq #80,d2
        moveq #91,d3
        clr.w d4
        jsr graphlib::fill
        bsr delayc
        dbra.s d7,f12loop
        moveq #9,d7
        move.w #2,-(a7)
        jsr doorsos::FontSetSys
        lea 2(a7),a7
        WriteStr #20,#40,#4,crash_str
f21loop moveq #1,d0
        moveq #1,d1
        moveq #78,d2
        moveq #91,d3
        clr.w d4
        jsr graphlib::fill
        bsr delayc
        dbra.s d7,f21loop
        bra dieloop


die_1   move.w #2,-(a7)
        jsr doorsos::FontSetSys
        lea 2(a7),a7
        WriteStr #60,#40,#4,crash_str
        moveq #9,d7
f1_loop moveq #1,d0
        moveq #1,d1
        move.w #158,d2
        moveq #91,d3
        clr.w d4
        jsr graphlib::fill
        bsr delayc
        dbra.s d7,f1_loop
        bsr wait                  ; on attend que la touche ENTER soit presse
        sub.w #1,lives_1
        bne othloop


perdu   SetFont #2
        WriteStr #30,#40,#4,game_over_str
good    pea ent_esc(PC)        ; affiche press enter
        jsr doorsos::ST_showHelp     ;
        lea 4(a7),a7              ;
        bsr wait
fin_du_jeu
        bsr int_off
        SetFont #1
        move.w time,d7
        clr.w d0
        move.b sel_2,d0
        move.l #veasy,a5
        mulu #16,d0
        add.w d0,a5
        cmp.w 14(a5),d7
        ble menu
        move.w d7,14(a5)
        bsr disp_high
        WriteStr #40,#80,#4,enter_str
        WriteStr #40,#20,#4,new_score_str
        clr.l d0
        move.b sel_2,d0
        move.l #veasy,a5
        mulu #16,d0
        add.w d0,a5
        move.b sel_2,d1
        mulu #10,d1
        add.w #31,d1
        move.w #46,d0
        move.w #82,d2
        move.w #8,d3
        move.w #1,d4
        jsr graphlib::fill
        Take_str #46,d1,#12
\passe  move.B #2,select
        move.w #40+8*2,x_cur
        bra print_high

wait    move.w #mask6,d0
        bsr get_key
        btst.b #0,d0
        beq wait_key_esc_off
        move.w #mask1,d0
        bsr get_key
        btst.b #0,d0
        beq wait_key_enter_off
        bra wait

wait_key_esc_off:
        move.w #mask6,d0
        bsr get_key
        btst.b #0,d0
        beq wait_key_esc_off
        rts

wait_key_enter_off:
        move.w #mask1,d0
        bsr get_key
        btst.b #0,d0
        beq wait_key_enter_off
        rts

delayc  move.w #1000,d0
\loopa  moveq #100,d1
\loopc  dbra.s d1,\loopc
        dbra.s d0,\loopa
        rts

get_key move.w  d0,$600018
        move.w #50,d0
delay_c dbra d0,delay_c
        move.b $60001b,d0
exit    rts




ini_screen:
        jsr graphlib::clr_scr
        clr.w d0                
        clr.w d1
        move.w #159,d4
        move.w #93,d5
        jsr graphlib::frame
        lea level0(pc),a0
        move.w level,d0
        tst.w d0
        beq \ok
        sub.w #1,d0
\loop   move.w (a0)+,d1
        cmp.w #255,d1
        bne \loop
        dbra d0,\loop
\ok     move.l #x1,a1
        move.l (a0),(a1)
        move.w (a0)+,d0
        move.w (a0)+,d1
        move.w (a0)+,dir_1
        clr.w d2
        bsr print_pixel
        move.l #x2,a1
        move.l (a0),(a1)
        move.w (a0)+,d0
        move.w (a0)+,d1
        btst.b #0,flag
        beq \passe
        bsr print_pixel
\passe  move.w (a0)+,dir_2
loop_level:
        cmp.w #$FF,(a0)
        beq exit
        move.w (a0)+,d0 
        move.w (a0)+,d1
        move.w (a0)+,d2
        move.w (a0)+,d3
        move.w #2,d4
        jsr graphlib::fill
        bra loop_level

disp_level:
        bsr wait_key_enter_off
        SetFont #2
        clr.l d0
        move.w level,d0
        add.b #48,d0
        move.l #levels_str,a0
        move.b d0,7(a0)
        WriteStrA #42,#40,#4,a0
        pea.l ent_esc(pc)
        jsr doorsos::ST_showHelp
        lea 4(a7),a7
        bra wait

ini_random:                          ; affiche un point au hazard
        clr.l d0
        clr.l d1
        moveq #80,d0                ; limit=45 (46-1)
        jsr userlib::random
        lsl.l #1,d0                   ; on multiplie par 2 pour avoir un nombre pair   
        move.w d0,d1
        clr.l d0
        moveq #46,d0                ; meme chose pour d1
        jsr userlib::random
        lsl.l #1,d0
        bsr check_pixel              ; on verifie si il n'y a pas de probleme   
        tst.w d2                     ; si oui alors d2=/=0
        bne ini_random               ; on recommence
        bsr print_pixel              ; on affiche le pixel   
        move.l #point,a0             ; on enregistre ses coordonnees   
        move.w d0,(a0)+
        move.w d1,(a0)
        rts

pixel   movem.l d0-d3/a0,-(a7)   ; d2=0:pixel_on (d1.w=x d0.w=y)
        lea $4c00,a0             ; d2=1:pixel_off (d1.w=x d0.w=y)
        cmp.w #99,d0             ; d2=2:find_pixel (btst d4,(a4)=0:rien)
        bcc pasbon
        lsl.w #1,d0
        move.w d0,d3
        lsl.w #4,d0
        sub.w d3,d0
        lea 0(a0,d0.w),a0
        cmp.w #159,d1
        bcc pasbon
        move.w d1,d3
        lsr.w #3,d1
        cmp.w #2,d2
        beq \tst
        not.w d3
        and.w #7,d3
        tst.b d2
        bne \off
        bset.b d3,0(a0,d1.w)
        bra pasbon                
\off    bclr.b d3,0(a0,d1.w)
        bra pasbon
\tst    lea 0(a0,d1.w),a4
        not.w d3
        and.w #7,d3
        move.w d3,d4
        bra pasbon
        sub.l a4,a4
pasbon  movem.l (a7)+,d0-d3/a0
        rts



pause   bsr wait_key_enter_off
        pea.l pause_str(pc)
        jsr doorsos::ST_showHelp
        lea 4(a7),a7
        bsr wait
        btst.b #0,flag
        bne info
        bsr big_info_1p
        bra info_1p

take_string:
        jsr userlib::idle_loop
        cmp.w #257,d0
        beq undo
        cmp.w #264,d0
        beq \bon
        cmp.w #13,d0
        beq \bon
        move.b d0,(a5)+
        move.w #2,-(a7)
        move.w d6,-(a7)
        move.w d5,-(a7)
        move.w d0,-(a7)
        jsr userlib::DrawCharXY
        lea 8(a7),a7
        add.w #6,d5
        dbra d7,take_string
\bon    cmp.w d4,d7
        beq take_string
        clr.b (a5)
        rts
undo    cmp.w d4,d7
        beq take_string
        add.w #1,d7
        clr.b -(a5)
        sub.w #6,d5
        move.w #4,-(a7)
        move.w d6,-(a7)
        move.w d5,-(a7)
        move.w #32,-(a7)
        jsr userlib::DrawCharXY
        lea 8(a7),a7
        bra take_string


print_value:
        move.l #str+8,a0
        clr.b (a0)
        clr.l d1
print_loop:
        add.l #1,d1
        divu #10,d0
        swap d0
        add.b #48,d0
        move.b d0,-(a0)
        clr.w d0
        swap d0
        tst.w d0
        bne print_loop
        rts

check_pixel:                    ; vrifie si en d2/d1 il y a deja quelue chose
        btst.b #1,flag
        beq \begin
        cmp.w #94,d0
        bne \non_1
        move.w #2,d0
\non_1  tst.w d0
        bne \non_2
        move.w #92,d0
\non_2  cmp.w #160,d1
        bne \non_3
        move.w #2,d1
\non_3  tst.w d1
        bne \begin
        move.w #158,d1
\begin  movem.w d0-d1,-(a7)
        move.w #2,d2
        bsr pixel
        btst d4,(a4)
        beq \non
        sub.w #1,d0
        bsr pixel
        btst d4,(a4)
        beq \non
        sub.w #1,d1
        bsr pixel
        btst d4,(a4)
        beq \non
        add.w #1,d0
        bsr pixel
        btst d4,(a4)
        bne \okpxl
\non    clr.w d2            ; si tout va bien alors d0=0
\okpxl  movem.w (a7)+,d0-d1
        rts


print_pixel:
        movem d0-d1,-(a7)
        clr.w d2
        bsr pixel
        sub.w #1,d0
        bsr pixel
        sub.w #1,d1
        bsr pixel
        add.w #1,d0
        bsr pixel
        movem (a7)+,d0-d1
        rts

ini_var move.w #1,stade_1
        move.w #1,stade_2
        move.w #LONG,long_1
        move.w #LONG,long_2
        move.l #x1,a0
        bsr ini_mat
        move.l #x2,a0
ini_mat move.w #LONG*LONG-1,d0
clr_mat clr.l (a0)+
        dbra d0,clr_mat
        rts

m1_0    move.w stade_1,stade
        move.w lives_1,lives
        move.w long_1,long
        move.w dir_1,dir
        move.l #x1,a0
        move.l #x,a1
        move.w #LONG*LONG-1,d0
loop1_0 move.l (a0)+,(a1)+
        dbra d0,loop1_0
        rts
m2_0    move.w stade_2,stade
        move.w lives_2,lives
        move.w long_2,long
        move.w dir_2,dir
        move.l #x2,a0
        move.l #x,a2
        move.w #LONG*LONG-1,d0
loop2_0 move.l (a0)+,(a2)+
        dbra d0,loop2_0
        rts
m0_1    move.w stade,stade_1
        move.w lives,lives_1
        move.w long,long_1
        move.w dir,dir_1
        move.l #x,a0
        move.l #x1,a1
        move.w #LONG*LONG-1,d0
loop0_1 move.l (a0)+,(a1)+
        dbra d0,loop0_1
        rts           
m0_2    move.w stade,stade_2
        move.w lives,lives_2
        move.w long,long_2
        move.w dir,dir_2
        move.l #x,a0
        move.l #x2,a2
        move.w #LONG*LONG-1,d0
loop0_2 move.l (a0)+,(a2)+
        dbra d0,loop0_2
        rts

int_on  clr.l d0
        move.w #$0700,d0
        trap #1
        bclr.b #2,($600001)
        move.l ($64),old_int1
        move.l #new_int,($64)
        bset.b #2,($600001)
        trap #1
	rts
int_off clr.l d0
        move.w #$0700,d0
        trap #1
        bclr.b #2,($600001)
        move.l old_int1,($64)
        bset.b #2,($600001)
        trap #1
	rts
new_int rte

ent_esc       dc.b "press [ENTER] ",0
p1_str        dc.b "P1 dots:",0
p2_str        dc.b "P2 dots:",0
pause_str     dc.b "Game paused",0
lives_str     dc.b "lives",0
score_str     dc.b "score:",0
dot_str       dc.b "dots:",0
time_out_str  dc.b "Time Out!",0
game_over_str dc.b "Game Over...",0
blank_over    dc.b "            ",0
crash_str     dc.b "CRASH!",0
win_str       dc.b "CONGRATULATIONS!",0
level_str     dc.b "Lvl",0
blank_str     dc.b "       ",0
levels_str    dc.b "-LEVEL  -",0
win1_str      dc.b "P1 WINS!!!",0
win2_str      dc.b "P2 WINS!!!",0
choose_str    dc.b "choose your mode:",0


new_score_str dc.b "New High Score!",0
enter_str     dc.b "Enter your name",0

titre  dc.b "Nibble89",0
email dc.b "v1.1 by Endive <GefunS@I-France.com>",0


time    dc.w 0

play_str   dc.b " Play Game ",0
option_str dc.b "  Options  ",0
hisc_str   dc.b "High Scores",0
exit_str   dc.b " Quit Game ",0

hs_str     dc.b "     HIGH SCORE     ",0
op_str     dc.b "    OPTIONS MENUS   ",0


veasy  dc.b "alban gervai",0,0,3,232
easy   dc.b "alban gervai",0,0,3,232
medium dc.b "alban gervai",0,0,3,232
hard   dc.b "alban gervai",0,0,3,232
vhard  dc.b "alban gervai",0,0,3,232

mode_str   dc.b "Play ",0
           dc.b "Mode ",0
           dc.b "Level",0
           dc.b "Wrap ",0
           dc.b "lives",0
play_1     dc.b "Solo",0
play_2     dc.b "HvsH",0

sel_1      dc.b 0
sel_2      dc.b 0
sel_3      dc.b 1
sel_5      dc.b 3


veasy_str  dc.b "v easy",0
easy_str   dc.b " easy ",0
medium_str dc.b "medium",0
hard_str   dc.b " hard ",0          
vhard_str  dc.b "v hard",0

off_str    dc.b "off",0
on_str     dc.b "on ",0

speed_table dc.w 65535,35000,20000,10000,5000
flag       dc.b %00000000



_comment dc.b "Nibble89 v1.1 by Endive!",0

        BSS


select ds.b 1
x_cur  ds.w 1
str      ds.b 9
old_int1 ds.l 1
speed   ds.w 1
point   ds.l 1
level   ds.w 1
long    ds.w 1
long_1  ds.w 1
long_2  ds.w 1
stade   ds.w 1
stade_1 ds.w 1
stade_2 ds.w 1
dir     ds.w 1
dir_1   ds.w 1
dir_2   ds.w 1
lives   ds.w 1
lives_1 ds.w 1
lives_2 ds.w 1
x       ds.w 2 
y       ds.w LONG*LONG*2-4
z       ds.w 2
x1      ds.w 2 
y1      ds.w LONG*LONG*2-4
z1      ds.w 2
x2      ds.w 2 
y2      ds.w LONG*LONG*2-4
z2      ds.w 2

 end


; Nibble89
; par Alban Gervaise
