; FROGGER v1.0 made by Alban Gervaise
; frogger has been written for Doorsos v0.95Beta
; last release 5/1/99

        include "doorsos.h"
        include "userlib.h"
        include "graphlib.h"
        include "frog.pic"



WAIT = 4



Y_1COORD = 70
Y_2COORD = 58
Y_3COORD = 34
Y_4COORD = 22

LEVEL = 5

        xdef _main
        xdef _comment
        xdef _ti89

print_d0 MACRO
        bsr print_value
        move.w  \3,-(a7)
        move.l  a0,-(a7)
        move.w  \2,-(a7)
        move.w  \1,-(a7)
        jsr     doorsos::DrawStrXY
        lea 10(a7),a7
        ENDM

Take_Str MACRO
        move.w \1,d5
        move.w \2,d6
        move.w \3-1,d7
        move.w d7,d4
        move.l #\4,a5
        bsr take_string
        ENDM


mask0 equ %11111110  ;(up\2nd\donw...)
mask1 equ %11111101  ;(Enter\clear...)
mask2 equ %11111011  ;( <- )
mask3 equ %11110111  ;(catalog...)
mask4 equ %11101111  ;(Mode...)
mask5 equ %11011111  ;(Home...)
mask6 equ %10111111  ;(ESC...)

        dc.l 'ICON'              ; icon for ProShell v1.1
        dc.w %0111001111001110
        dc.w %0010010110100100
        dc.w %0001011111101000
        dc.w %0000111111110000
        dc.w %0000011111100000
        dc.w %0000111111110000
        dc.w %0000101111010000
        dc.w %0011000000001100


_main
        clr.w timer              ; timer = 0
        bsr int_on               ; change interrupt
        bsr wait_key_enter_off
        clr.w d0
\loop:
        move.l (a0)+,d1          ; wait...
        dbra.s d0,\loop
        bsr ini_main_screen      ; show frog icon, title
        bsr show_best            ; show best score
loop    cmp.w #350,timer
        beq.s show_press           ; show "PRESS ENTER"
        cmp.w #700,timer
        beq.s show_score
        move.w #mask6,d0         ; check is ESC is being pressed
        bsr get_key              ;
        btst.b #0,d0             ;
        beq int_off              ;  yes...so restore interrupt and quit
        move.w #mask1,d0         ; check is ENTER is being pressed
        bsr get_key              ;
        btst.b #0,d0             ;
        beq.s wait_off
        bra.s loop                 ; no key so continu little animation
        
show_press:
        bsr show_press_enter     ; timer = 350 => show PRESS ENTER
        bra.s loop
show_score:
        clr.w timer
        bsr show_best            ; timer = 700 => move 0 in timer
        bra.s loop                 ; and show best score
wait_off:
        bsr wait_key_enter_off

start:
        clr.w level              ; we start at level 1 (lvl 1=0,lvl 2=1...)
        clr.w score              ; we clear score
        bsr ini_var              ; move value of level in level data
        move.w #3,lives          ; we want 3 lives

lvlloop:                         ; loop when restart the level
        clr.w stop               ; stop: wait time before a key can be pressed
        bsr ini_scr              ; draw the area
        lea.l lvl_str(pc),a0     ; print "LEVEL"
        moveq #60,d7             ; at x=47 (cte) and y=60
        bsr message              ;
        clr.l d0                 ;
        move.w level,d0          ; print level + 1 (we start in fact at level0)
        add.w #1,d0              ;
        print_d0 #90,#47,#4      ;
        bsr wait
        bsr inivar2              ; ini var for frog coord at bottom
        bsr ini_scr              ; redraw area
        bsr disp_frog            ; draw the frog
        bsr info                 ; give info (score, time, level, lives)
        move.w #WAIT*2,stop



main_loop:
        cmp.w #300,timer         ; if timer=300:disp info and update time
        ble.s \passe              ; no...so go after
        clr.w timer              ;
        sub.w #1,time            ; time-1 = time
        beq timeout              ; if time=0: time out we lose... :(
        bsr info                 ; no so print info
\passe:
        move.w #mask6,d0         ; ESC has been pressed so check score and finish
        bsr get_key              ;
        btst.b #0,d0             ;
        beq fin_du_jeu           ;
        move.w #mask5,d0
        bsr get_key
        btst.b #6,d0
        beq int_off
        tst.w stop               ; if stop=/= 0: can't press an arrow key
        beq.s \bon
        sub.W #1,stop            ; wait before arrow can be pressed...
        bra.s \apres
\bon:
        move.w #mask0,d0
        bsr get_key              ; if up is pressed: go up
        btst.B #0,d0
        beq haut
        btst.b #1,d0
        beq gauche               ; if left...
        btst.B #3,d0
        beq droite               ; if right...
        btst.b #2,d0
        beq bas                  ; if down...
        move.w #mask1,d0
        bsr get_key
        btst.b #0,d0
        beq pause
\apres:
        bsr update               ; nothing so update screen with cars positions..
        bsr delay                ; wait
        bra check                ; check if you are not on a car :(

fin_du_jeu:                      ; end of the game, you lose or you win?
        bsr wait_key_enter_off
        bsr wait_key_esc_off
        bsr int_off              ; restore interrupt
        moveq #5,d0
\loop   bsr delay
        dbra.s d0,\loop
        SetFont #1               ; write with the middle font
        move.w score,d0
        move.w best+10,d1
        cmp.w d0,d1
        bge _main                ; score <= best score so go to main screen
        move.w d0,best+10
        move.l #best_score,a0
        moveq #2,d7              ; score > best score so NEW HIGH SCORE!!!
        bsr message              ; disp it
        clr.l d0
        move.w score,d0
        print_d0 #130,#47,#4     ; disp score
        Take_Str #70,#47,#9,best ; inputstr in best
        bra _main
        

haut:
        move.w #WAIT,stop        ; up has been pressed so we must wait
        cmp.w #10,frog_xy+2      ;
        ble main_loop
        cmp.w #22,frog_xy+2      ; if y frog = 22 so may be in case
        beq.s special
        clr.l d0
        clr.l d1                 ;
        clr.l d4                 ; no...but check if there is no problem
        move.w frog_xy+2,d0      ;
        move.w frog_xy,d1        ;
        sub.w #12,d0
        moveq #2,d2
        bsr pixel                ; is there already a pixel?
        btst.l d4,(a4)
        bne perdu                ; yes so lose
        add.w #8,d1
        bsr pixel
        btst.l d4,(a4)
        bne perdu                ; yes, so lose

passe_h:
        bsr xorfrog              ; clear the frog
        sub.w #12,frog_xy+2      ; update position
        clr.w dir                ; (up=0; right=1; down=2; left=3)
        bsr disp_frog            ; disp the frog
        bra main_loop            ; return to main loop

special move.w frog_xy,d0        ; special = check if frog goes in a case
        cmp.w #8,d0
        blt perdu                ; must be so long because the frog must
        clr.l d6                 ; go to the case with a marge of 10 pixels
        move.w #12,d7            ; and wa can't used a pixel test
        cmp.w #22,d0
        ble.s goal
        cmp.W #40,d0             ;
        blt perdu                ; the frog is in front of a black wall.. you lose
        add.w #2,d6
        move.w #44,d7
        cmp.W #62,d0
        ble.s goal                 ; the frog goes in a case...good!
        cmp.w #72,d0
        blt perdu
        add.w #2,d6
        move.w #76,d7
        cmp.w #84,d0
        ble.s goal
        cmp.w #104,d0              
        blt perdu                  ; if coor < 104 => lose
        add.w #2,d6
        move.w #108,d7
        cmp.w #116,d0
        ble.s goal
        cmp.w #136,d0
        blt perdu
        addq #2,d6
        move.w #140,d7
        cmp.w #152,d0
        bgt perdu

goal:                              ; the frog is in a case
        bsr xorfrog
        move.l #mat,a0           : matrix for the 5 cases
        add.w d6,a0
        tst.w (a0)                 ; is there already a frog?
        bne perdu                  ; yes, so you lose
        move.w #4,(a0)             ; no so put a value in the case (why 4...?)
        move.w d7,frog_xy          ;
        move.w #10,frog_xy+2       ;
        bsr disp_frog              ; disp the frog in the case
        add.w #50,score            ; bonus score 50!
        bsr info                   ; disp new score

        move.l #mat,a0           ; check if all the case are empty
        moveq #4,d0                ;
lpck:
        tst.w (a0)                 ;
        beq.s pas_win              ;  no, you don't win now...
        add.l #2,a0                ; 
        dbra.s d0,lpck             ;
        bra gagne                  ;  youh, youh! you winnnnn :)

pas_win:
        bsr inivar2                ; ini frog coord
        move.w #WAIT*2,stop        ; we wait a long time
        bra main_loop              ; and we go back to main loop

bas:
        move.w #WAIT,stop
        cmp.w #82,frog_xy+2        ; if y frog =85 you are to low
        bge main_loop              ;
        clr.l d0
        clr.l d1
        clr.l d4
        move.w frog_xy+2,d0
        move.w frog_xy,d1
        add.w #12,d0
        moveq #2,d2
        bsr pixel
        btst.l d4,(a4)             ; check if there is a pixel
        bne perdu                  ; if yes, you lose
        add.w #8,d1
        bsr pixel
        btst.l d4,(a4)
        bne perdu
        bsr xorfrog                ; no... so disp new frog coord
        add.w #12,frog_xy+2        ;
        move.w #2,dir              ;
        bsr disp_frog
        bra main_loop              ; return to main loop

gauche:
        move.w #WAIT,stop          ; wait...
        cmp.w #8,frog_xy
        ble main_loop              ; clear the frog
        bsr xorfrog
        sub.w #8,frog_xy
        move.w  #3,dir               ; update coord
        bsr disp_frog
        bra main_loop

droite:
        move.w #WAIT,stop
        cmp.w #148,frog_xy
        bge main_loop
        bsr xorfrog
        add.w #8,frog_xy
        move.w #1,dir
        bsr disp_frog
        bra main_loop
        

ini_scr:
        jsr graphlib::clr_scr2     ; clear all the screen but the status line
        clr.w d0
        clr.w d1
        move.w #160,d2
        move.w #13+15*2,d3
        moveq #2,d4
        jsr graphlib::fill         ; disp the black rect
        moveq #5,d7
        moveq #80,d1
        moveq #2,d3

loopih: clr.w d0
        move.w #160,d2
        jsr graphlib::horiz
        sub.w #12,d1
        dbra.s d7,loopih

        move.l #LCD_MEM+30*68,a0   ;
        moveq #20,d4               ; 
loopli:                            ; disp the line for the road
        move.b #%00001111,(a0)+    ;
        dbra.s d4,loopli           ;

        moveq #4,d7
        moveq #1,d4
        moveq #9,d1
        moveq #8,d3
        moveq #10,d2
        moveq #10,d0               ; dispthe rect
loopic:
        jsr graphlib::fill
        add.w #32,d0
        dbra.s d7,loopic

        WriteStr #10,#0,#2,_comment ; and disp the comment
        rts

ini_var:
        move.l #mat,a0   ; ini level data
        clr.l (a0)+
        clr.l (a0)+      ; clear the case value
        clr.w (a0)
        bsr read         ; read level data
inivar2:
        clr.w dir             ; the frog goes first up
        move.w #76,frog_xy    ; ini frog coord
        move.w #82,frog_xy+2  ;
        bsr.s disp_frog         ; disp the frog
        rts                   ; return

disp_frog:                    ;  disp the frog
        move.w frog_xy,d0     ; x coord 
        move.w frog_xy+2,d1   ; y coord
        move.b #255,d3        ; mask
        lea.l frogpic(pc),a0  ; pic
        clr.l d2              ; 
        move.w dir,d2         ;
        mulu #12,d2           ; add a value to have the good direction
        add.l d2,a0           ;
        jsr graphlib::put_sprite_mask ; disp
        rts                   ; return


xorfrog:                      ; same thing but clear the frog
        move.w frog_xy,d0
        move.w frog_xy+2,d1
        move.b #255,d3
        lea.l blank(pc),a0
        jsr graphlib::put_sprite_mask
        rts

get_key move.w  d0,$600018    ;
        move.w #50,d0         ;
delay_c dbra d0,delay_c       ;
        move.b $60001b,d0     ;
exit    rts                   ;


delay   move.w speed,d7       ; make a short delay
loopdl  nop                   ; adapted for the level
        dbra d7,loopdl        ;
        rts                   ;


check:                        ; check if the frog is on a car, on the water...
        tst.w frog_xy         ; if x = 0: the frog has been lost...
        beq.s perdu             ;
        cmp.w #160,frog_xy    ; if x = 160: same thing
        beq.s perdu
        clr.l d0
        clr.l d1
        clr.l d4
        move.w frog_xy+2,d0
        move.w frog_xy,d1
        sub.w #1,d1
        add.w #5,d0
        moveq #2,d2
        bsr pixel             ; check if there is a pixel
        btst.l d4,(a4)
        bne.s perdu             ; yes, so you lose
        add.w #8,d1
        bsr pixel
        btst.l d4,(a4)
        beq main_loop         ; no so return

perdu:                        ; you have lost...
        lea.l crash_str(pc),a0
        moveq #60,d7         ; disp it!
        bsr message
        sub.w #1,lives        ; take a life
        bsr info              ; disp the lives
        bsr wait              ; wait a key
        bsr xorfrog           ; clear the frog
        bsr inivar2           ; put new coord frog
        tst.w lives           ; if lives=0: you lose
        beq fin_du_jeu
        bra autre             ; no so you continu

gagne:                        ; you win the level
        lea.l win_str(pc),a0  ; disp it!
        moveq #40,d7
        bsr message
        bsr wait              ; wait a key
        cmp.w #LEVEL-1,level  ; check if it was the last level
        beq jeu_gagne         ; Yes..so you win the gammmmmme :)
        add.w #1,level        ; no :( so continu with the next level :)
        add.W #1,lives        ; give another life
        add.w #100,score      ; bonus 100!
        move.w time,d0
        mulu #10,d0
        add.w d0,score     ; + time bonus!!!
        bsr ini_var           ; ini the level data
        bra lvlloop           ; return at the begining

jeu_gagne:                    ; you have win the gammmmmmme :)
        add.W #100,score      ; little bonus
        move.w lives,d0       : life bonus!!!
        mulu #100,d0
        add.w d0,score        ; score bonus!!!
        bsr info              ; disp new score
        lea.l game_str(pc),a0 ; disp that you win
        moveq #10,d7
        bsr message
        moveq #10,d0
\loop   bsr delay
        dbra.s d0,\loop
        bsr wait              ; wait a key
        bra fin_du_jeu        ; check if you've got the best score


        
timeout:                      ; no more time...
        lea.l out_str(pc),a0  ; disp it
        moveq #55,d7
        bsr message
        bsr info              ; give info to show that it's true
        bsr wait              ; wait a key
        bsr xorfrog           ; clear the frog
        sub.w #1,lives        ; you lose a life
        beq fin_du_jeu        ; you have no life!!!so you lose
        move.w times,time     ; no so restart with the level time

autre:
        clr.w stop
        lea.l lvl_str(pc),a0  ;
        moveq #60,d7          ; disp the level
        bsr message           ;
        clr.l d0
        move.w level,d0
        add.w #1,d0
        print_d0 #90,#47,#4   ; print the number
        bsr wait              ; wait a key
        bsr inivar2           ; ini frog coord
        bsr info              ; disp info
erase   lea.l best_str+4(pc),a0 ; clear the message area
        clr.w d7
        bsr message
        bsr disp_frog         ; disp the frog
        move.w #WAIT*2,stop
        bra main_loop         ; return to main_loop

pause:  bsr wait_key_enter_off
        lea.l pause_str(pc),a0
        moveq #50,d7
        bsr message
        bsr wait
        bra erase             ; erase message

pixel   movem.l d0-d3/a0,-(a7)   ; d2=0:pixel_on (d0.w=y d1.w=x)
        lea $4c00,a0             ; d2=1:pixel_off (d0.w=y d1.w=x)
        cmp.w #99,d0             ; d2=2:find_pixel (btst d4,(a4)=0:nothing)
        bcc pasbon
        lsl.w #1,d0
        move.w d0,d3
        lsl.w #4,d0
        sub.w d3,d0
        lea 0(a0,d0.w),a0
        cmp.w #159,d1
        bcc pasbon
        move.w d1,d3
        lsr.w #3,d1
        cmp.w #2,d2
        beq \tst
        not.w d3
        and.w #7,d3
        tst.b d2
        bne \off
        bset.b d3,0(a0,d1.w)
        bra pasbon                
\off    bclr.b d3,0(a0,d1.w)
        bra pasbon
\tst    lea 0(a0,d1.w),a4
        not.w d3
        and.w #7,d3
        move.w d3,d4
        bra pasbon
        sub.l a4,a4
pasbon  movem.l (a7)+,d0-d3/a0
        rts


int_on  clr.l d0                  ; change old interrupt
        move.w #$0700,d0           
        trap #1                    
        bclr.b #2,($600001)
        move.l ($64),old_int1
        move.l #new_int,($64)
        bset.b #2,($600001)
        trap #1
	rts
int_off clr.l d0                  ; restore the old int
        move.w #$0700,d0
        trap #1
        bclr.b #2,($600001)
        move.l old_int1,($64)
        bset.b #2,($600001)
        trap #1
	rts
new_int add.w #1,timer            ; this is the new interrupt
        rte                       ; update the time


info:                             ; give info
        clr.w -(a7) 
        jsr doorsos::FontSetSys   ; 2
        pea score_str             ; disp score string
        jsr doorsos::ST_showHelp  ;4
        move.w score,d0
        bsr print_value           ; disp score value
        move.w #4,-(a7)
        move.l a0,-(a7)
        move.w #95,-(a7)
        move.w #23,-(a7)
        jsr doorsos::DrawStrXY    ; 10
        move.w #4,-(a7)
        pea.l time_str(pc)
        move.w #95,-(a7)         ; disp time string
        move.w #45,-(a7)
        jsr doorsos::DrawStrXY   ;10
        move.w time,d0
        bsr print_value
        move.w #4,-(a7)
        move.l a0,-(a7)          ; disp time value
        move.w #95,-(a7)
        move.w #64,-(a7)         
        jsr doorsos::DrawStrXY   ;10
        move.w #4,-(a7)
        pea.l lives_str(pc)
        move.w #95,-(a7)         ; disp lives string
        move.w #90,-(a7)
        jsr doorsos::DrawStrXY   ;10
        move.w lives,d0
        bsr.s print_value
        move.w #4,-(a7)          ; disp lives value
        move.l a0,-(a7)
        move.w #95,-(a7)
        move.w #110,-(a7)         
        jsr doorsos::DrawStrXY   ;10
        move.w #4,-(a7)
        pea.l level_str(pc)
        move.w #95,-(a7)         ; disp level string
        move.w #130,-(a7)
        jsr doorsos::DrawStrXY   ;10
        move.w level,d0
        add.w #1,d0
        bsr.s print_value
        move.w #4,-(a7)
        move.l a0,-(a7)
        move.w #95,-(a7)         ; disp level value
        move.w #150,-(a7)         
        jsr doorsos::DrawStrXY   ;10
        lea 76(a7),a7            ; restore the stack
        rts


print_value:                 ; convert a numbre <65536 in a string
        move.l #str+8,a0
        clr.b (a0)
        clr.l d1
print_loop:
        add.l #1,d1
        divu #10,d0
        swap d0
        add.b #48,d0
        move.b d0,-(a0)
        clr.w d0
        swap d0
        tst.w d0
        bne.s print_loop
        rts

message move.w #1,-(a7)
        jsr doorsos::FontSetSys
        clr.w d0
        moveq #45,d1
        move.w #160,d2
        moveq #10,d3
        moveq #1,d4
        jsr graphlib::fill
        move.W #4,-(a7)
        move.l a0,-(a7)
        move.w #47,-(a7)
        move.W d7,-(a7)
        jsr doorsos::DrawStrXY
        lea 12(a7),a7
        rts

wait:       ; wait until ESC or ENTER is pressed
        move.w #mask6,d0
        bsr get_key
        btst.B #0,d0
        beq wait_key_esc_off
        move.w #mask1,d0
        bsr get_key
        btst.b #0,d0
        beq wait_key_enter_off
        bra wait

wait_key_enter_off:          ; wait until ENTER is not pressed
        move.w #mask1,d0
        bsr get_key
        btst.b #0,d0
        beq wait_key_enter_off
        rts
wait_key_esc_off:            ; wait until ENTER is not pressed
        move.w #mask6,d0
        bsr get_key
        btst.b #0,d0
        beq wait_key_esc_off
        rts


take_string:                    ; take a string
        jsr userlib::idle_loop
        cmp.w #257,d0
        beq undo
        cmp.w #264,d0
        beq \bon
        cmp.w #13,d0
        beq \bon
        move.b d0,(a5)+
        move.w #2,-(a7)
        move.w d6,-(a7)
        move.w d5,-(a7)
        move.w d0,-(a7)
        jsr userlib::DrawCharXY
        lea 8(a7),a7
        add.w #6,d5
        dbra d7,take_string
\bon    cmp.w d4,d7
        beq take_string
        clr.b (a5)
        rts
undo    cmp.w d4,d7
        beq take_string
        add.w #1,d7
        clr.b -(a5)
        sub.w #6,d5
        move.w #4,-(a7)
        move.w d6,-(a7)
        move.w d5,-(a7)
        move.w #32,-(a7)
        jsr userlib::DrawCharXY
        lea 8(a7),a7
        bra take_string




; READ LEVEL DATA   

read    lea.l level1(pc),a0
        clr.l d0
        move.w level,d0
        tst.w d0
        beq found
        sub.w #1,d0
loopsl  cmp.w #$FFFF,(a0)+
        bne.s loopsl
        dbra.s d0,loopsl
found   move.w (a0),time
        move.w (a0)+,times
        move.w (a0)+,speed
        move.l #card,a1
        bsr.s repete
        move.l #carg,a1
        bsr.s repete
        move.l #lurryg,a1
        bsr.s repete
        move.l #lurryd,a1
        bsr.s repete
        rts

repete  move.w (a0)+,d0
        tst.w d0
        beq.s rien
        move.w d0,(a1)+
        sub.W #1,d0
copy    move.l (a0)+,(a1)+
        move.l (a0)+,(a1)+
        dbra.s d0,copy
        rts
rien    clr.w (a1)
        rts

ini_main_screen:                    ; put the frog icon and the title
        jsr graphlib::clr_scr
        move.l #picture1,a0
        moveq #50,d0
        moveq #20,d1
        move.b #$FF,d3
        jsr graphlib::put_sprite_mask
        clr.w -(a7)
        jsr doorsos::ST_busy
        pea.l email(pc)
        jsr doorsos::ST_showHelp
        move.w #2,-(a7)
        jsr doorsos::FontSetSys
        move.w #4,-(a7)
        pea.l title(pc)
        clr.w -(a7)
        move.w #30,-(a7)
        jsr doorsos::DrawStrXY
        clr.w -(a7)
        jsr doorsos::FontSetSys
        move.w #4,-(a7)
        pea.l auteur(pc)
        move.w #10,-(a7)
        move.w #62,-(a7)
        jsr doorsos::DrawStrXY
        lea 30(a7),a7
        rts

show_press_enter:
        bsr.s clrzone
        WriteStr #45,#85,#4,press_str
        rts
clrzone clr.w d0
        moveq #85,d1
        move.w #160,d2
        moveq #8,d3
        moveq #1,d4
        jsr graphlib::fill
        SetFont #1
        rts
show_best
        bsr.s clrzone
        WriteStr #20,#85,#4,best_str
        WriteStr #50,#85,#4,best
        clr.l d0
        move.w best+10,d0
        print_d0 #110,#85,#4
        rts



; UPDATE CARS, LURRY AND BRIDGES 

update:
        move.l #card,a6
        move.l #blank,a5
        bsr updatdd
        move.l #carg,a6
        bsr updatg
        move.l #pontd,a6
        move.l #plein,a5
        bsr updatdd
        move.l #pontg,a6
        bsr updatg
        move.l #lurryg,a6
        move.l #camion,a5
        bsr updatg
        move.l #lurryd,a6
        bsr updatdd
        cmp.w #22,frog_xy+2
        beq sd
        cmp.w #34,frog_xy+2
        bne exit
sg      sub.w #2,frog_xy
sd      add.w #1,frog_xy
        bsr disp_frog
        rts

updatdd clr.l d7        ; update for objects which go th right
        move.w (a6),d7
        tst.w d7
        beq exit
        sub.w #1,d7
        add.l #2,a6
loopd   bsr coord
        move.l a5,a0
        jsr graphlib::put_sprite_mask
        add.w #1,(a6)
        bsr coord
        cmp.w #160,d0
        beq.s justepd
        cmp.w #250,d0
        beq.s justemd
retourd jsr graphlib::put_sprite_mask
        lea 8(a6),a6
        dbra.s d7,loopd
        rts
justepd move.w #210,(a6)
        sub.w #1,2(a6)
        bra.s retourd
justemd move.w #10,(a6)
        add.w #1,2(a6)
        bra.s retourd

updatg  clr.l d7                  ; update for objets which go to left
        move.w (a6),d7
        tst.w d7
        beq exit
        sub.w #1,d7
        add.l #2,a6
loopg   bsr coord
        move.l a5,a0
        jsr graphlib::put_sprite_mask
        sub.w #1,(a6)
        bsr coord
        cmp.w #10,d0
        beq.s justepg
        cmp.w #200,d0
        beq.s justemg
retourg jsr graphlib::put_sprite_mask
        lea 8(a6),a6
        dbra.s d7,loopg
        rts
justepg move.w #250,(a6)
        sub.w #1,2(a6)
        bra.s retourg
justemg move.w #160,(a6)
        add.w #1,2(a6)
        bra.s retourg
coord   clr.l d1
        clr.l d0
        move.w (a6),d0
        move.w 2(a6),d1
        move.l 4(a6),a0
        move.b #$FF,d3
        rts



; SPRITES OF THE FROG 

frogpic dc.w 8
        dc.w 1
        dc.b %00010000
        dc.b %00111000
        dc.b %10010010
        dc.b %01111100
        dc.b %01111100
        dc.b %01111100
        dc.b %10010010
        dc.b %00000000
        dc.w 8
        dc.w 1
        dc.b %00000000
        dc.b %01000100
        dc.b %00111000
        dc.b %00111010
        dc.b %01111111
        dC.b %00111010
        dc.b %00111000
        dc.b %01000100
        dc.w 8
        dc.w 1
        dc.b %10010010
        dc.b %01111100
        dc.b %01111100
        dc.b %01111100
        dc.b %10010010
        dc.b %00111000
        dC.b %00010000
        dc.w 8
        dc.w 1
        dc.b %00000000
        dc.b %00100010
        dc.b %00011100
        dc.b %01011100
        dc.b %11111110
        dc.b %01011100
        dc.b %00011100
        dc.b %00100010



; SPRITES FOR THE CARS 

car1d   dc.w 8
        dc.w 1
        dc.b %00000001
        dc.b %00000010
        dc.b %00001111
        dc.b %00010101
        dc.b %11111101
        dc.b %10000001
        dc.b %11111111
        dc.b %01000010
car2d   dc.w 8
        dc.w 1
        dc.b %00001111
        dc.b %00010111
        dc.b %00100111
        dc.b %11111111
        dc.b %11111111
        dc.b %11111111
        dc.b %11111111
        dc.b %01100110

car1g   dc.w 8
        dc.w 1
        dc.b %10000000
        dc.b %01000000
        dc.b %11110000
        dc.b %10101000
        dc.b %10111111
        dc.b %10000001
        dc.b %11111111
        dc.b %01000010
car2g   dc.w 8
        dc.w 1
        dc.b %11110000
        dc.b %11101000
        dc.b %11100100
        dc.b %11111111
        dc.b %11111111
        dc.b %11111111
        dc.b %11111111
        dc.b %01100110

camiong dc.w 8
        dc.w 2
        dc.w %000011111111111
        dc.w %000101000000001
        dc.w %001001000000001
        dc.w %011111000000001
        dc.w %100000000000001
        dc.w %100000000000001
        dc.w %111111111111111
        dc.w %011000001101100
camiond dc.w 8
        dc.w 2
        dc.w %111111111110000
        dc.w %100000000101000
        dc.w %100000000100100
        dc.w %100000000111110
        dc.w %100000000000001
        dc.w %100000000000001
        dc.w %111111111111111
        dc.w %011011000000110

barque  dc.w 8
        dc.w 4
        dc.l %11100000000000000000000000000111
        dc.l %10000000000000000000000000000001
        dc.l %10000000000000000000000000000001
        dc.l %00000000000000000000000000000000
        dc.l %00000000000000000000000000000000
        dc.l %10000000000000000000000000000001
        dc.l %10000000000000000000000000000001
        dc.l %11100000000000000000000000000111


camion  dc.w 8
        dc.w 2
        ds.w 8

blank   dc.w 8
        dc.w 1
        ds.b 8

plein   dc.w 8
        dc.w 4
        dc.b 255,255,255,255,255,255,255,255
        dc.b 255,255,255,255,255,255,255,255
        dc.b 255,255,255,255,255,255,255,255
        dc.b 255,255,255,255,255,255,255,255

; LEVELS DATA 

level1  dc.w 100         ; time
        dc.w 10000        ; speed
        dc.w 3           ; numbers of cars go to left
        dc.w 10,Y_1COORD
        dc.l car1g
        dc.w 50,Y_1COORD
        dc.l car2g
        dc.w 150,Y_1COORD
        dc.l car1g
        dc.w 3           ; numbers of cars go to right
        dc.w 110,Y_2COORD
        dc.l car1d
        dc.w 30,Y_2COORD
        dc.l car2d
        dc.w 60,Y_2COORD
        dc.l car1d
        dc.w 0           ; numbers of lurry go to left
        dc.w 0           ; numbers of lurry go to right
        dc.w $FFFF       ; end of the level

level2  dc.w 75  ; time
        dc.w 4000  ; speed
        dc.w 3  ; numbers of cars go to left
        dc.w 10,Y_1COORD
        dc.l car1g
        dc.w 50,Y_1COORD
        dc.l car2g
        dc.w 160,Y_1COORD
        dc.l car1g
        dc.w 3  ; numbers of cars go to right
        dc.w 10,Y_2COORD
        dc.l car1d
        dc.w 50,Y_2COORD
        dc.l car2d
        dc.w 90,Y_2COORD
        dc.l car1d
        dc.w 1  ; numbers of lurry go to left
        dc.w 150,Y_2COORD
        dc.l camiong
        dc.w 1  ; numbers of lurry go to right
        dc.w 150,Y_1COORD
        dc.l camiond
        dc.w $FFFF  ; end of the level

level3  dc.w 75  ; time
        dc.w 2000  ; speed
        dc.w 3  ; numbers of cars go to left
        dc.w 10,Y_1COORD
        dc.l car1g
        dc.w 50,Y_1COORD
        dc.l car2g
        dc.w 160,Y_1COORD
        dc.l car1g
        dc.w 3  ; numbers of cars go to right
        dc.w 20,Y_2COORD
        dc.l car1d
        dc.w 60,Y_2COORD
        dc.l car2d
        dc.w 110,Y_2COORD
        dc.l car1d
        dc.w 2  ; numbers of lurry go to left
        dc.w 150,Y_2COORD
        dc.l camiong
        dc.w 180,Y_2COORD
        dc.l camiong
        dc.w 2  ; numbers of lurry go to right
        dc.w 80,Y_1COORD
        dc.l camiond
        dc.w 130,Y_1COORD
        dc.l camiond
        dc.w $FFFF  ; end of the level

level4  dc.w 50  ; time
        dc.w 500  ; speed
        dc.w 3  ; numbers of cars go to left
        dc.w 10,Y_1COORD
        dc.l car1g
        dc.w 50,Y_1COORD
        dc.l car2g
        dc.w 160,Y_1COORD
        dc.l car1g
        dc.w 3  ; numbers of cars go to right
        dc.w 20,Y_2COORD
        dc.l car1d
        dc.w 60,Y_2COORD
        dc.l car2d
        dc.w 110,Y_2COORD
        dc.l car1d
        dc.w 2  ; numbers of lurry go to left
        dc.w 150,Y_2COORD
        dc.l camiong
        dc.w 180,Y_2COORD
        dc.l camiong
        dc.w 2  ; numbers of lurry go to right
        dc.w 80,Y_1COORD
        dc.l camiond
        dc.w 130,Y_1COORD
        dc.l camiond
        dc.w $FFFF  ; end of the level


level5  dc.w 50  ; time
        dc.w 1  ; speed (can't be inferior because of scrolling time)
        dc.w 3  ; numbers of cars go to left
        dc.w 10,Y_1COORD
        dc.l car1g
        dc.w 50,Y_1COORD
        dc.l car2g
        dc.w 160,Y_1COORD
        dc.l car1g
        dc.w 3  ; numbers of cars go to right
        dc.w 20,Y_2COORD
        dc.l car1d
        dc.w 60,Y_2COORD
        dc.l car2d
        dc.w 110,Y_2COORD
        dc.l car1d
        dc.w 3  ; numbers of lurry go to left
        dc.w 150,Y_2COORD
        dc.l camiong
        dc.w 180,Y_2COORD
        dc.l camiong
        dc.w 40,Y_2COORD
        dc.l camiong
        dc.w 3  ; numbers of lurry go to right
        dc.w 80,Y_1COORD
        dc.l camiond
        dc.w 130,Y_1COORD
        dc.l camiond
        dc.w 230,Y_1COORD
        dc.l camiond
        dc.w $FFFF  ; end of the level



; DATA FOR ROADS, WATER... 

pontd   dc.w 3
        dc.w 50,Y_4COORD
        dc.l barque
        dc.w 140,Y_4COORD
        dc.l barque
        dc.w 10,Y_4COORD
        dc.l barque
pontg   dc.w 3
        dc.w 60,Y_3COORD
        dc.l barque
        dc.w 100,Y_3COORD
        dc.l barque
        dc.w 150,Y_3COORD
        dc.l barque

score_str  dc.b "score:",0
lives_str  dc.b "lives:",0
time_str   dc.b "time:",0
level_str  dc.b "lvl:",0
lvl_str    dc.b "LEVEL",0
out_str    dc.b "TIME OUT",0
crash_str  dc.b "CRASH!!!",0
win_str    dc.b "CONGRATULATIONS",0
game_str   dc.b "YOU ARE THE GREAT WINNER",0
best       dc.b "---------",0,0,0
email      dc.b "email: GefunS@I-France.com",0
title      dc.b "FROGGER v1.0",0
auteur     dc.b "by Endive",0
best_str   dc.b "best",0
best_score dc.b "best score:",0
press_str  dc.b "PRESS ENTER",0
pause_str  dc.b "game paused",0

_comment dc.b "Frogger v1.0 by Endive",0

        BSS

level    ds.w 1
old_int1 ds.l 1
stop     ds.w 1
frog_xy  ds.w 2
speed    ds.w 1
mat      ds.w 5
dir      ds.w 1
str      ds.b 10
timer    ds.w 1

score ds.w 1
lives ds.w 1
time  ds.w 1
times ds.w 1

card    ds.w 1
        ds.l 2*6
carg    ds.w 1
        ds.l 2*6
lurryg  ds.w 1
        ds.l 2*3
lurryd  ds.w 1
        ds.l 2*3

 end
 
; by Alban Gervaise
