#include asm86.h
#include ti86asm.inc

; Information about the current cave

curCave     = $C0F9  ; Current cave
difLevel    = $C0FA  ; Difficulty level
mwatime     = $C0FB  ; Magic wall milling time & max amoeba time at 3% growth
dmscore1    = $C0FC  ; Initial Jewel value
dmscore2    = $C0FD  ; Extra Jewel value
randseed1   = $C0FE  ; Randomiser seed 1
randseed2   = $C0FF  ; Randomiser seed 2
dmneeded    = $C100  ; Jewels needed
timeLeft    = $C101  ; Time left on current level
randobj     = $C102  ; Random objects (4 BYTE)
probobj     = $C106  ; Probability of random objects (4 BYTE)
animcnt1    = $C10A  ; Animation counter 1 (0-255)
animcnt2    = $C10B  ; Animation counter 2 (0-2)
flashcnt    = $C10C  ; Flash inbox counter. When reach 0, Rockford appears
dmtaken     = $C10D  ; Jewels taken
rockford    = $C10E  ; Rockfords position (x,y) (WORD)
flags	    = $C110  ; 0-RF found, 1-RF moved, 2-updated score, 3-screen flash
		     ; 4-Amoeba can grow, 5-Remove Extra Life text
score	    = $C111  ; Score (WORD)
lives	    = $C113  ; Lives left
finished    = $C114  ; 0-Diamons left to take, 1-Cave done
timecnt     = $C115  ; Time counter (0-4)
amTurn	    = $C116  ; Next scan, amoeba will become... (0 - no change)
nrAmoeba    = $C117  ; Number of amoebas found
amTime	    = $C118  ; Amobea time at 3% growth
mwactive    = $C119  ; Magic Wall Active
nextEL	    = $C11A  ; Next extra life (WORD)
ELTimer     = $C11C  ; Extra life timer
RFMove	    = $C11D  ; 0-Blinking, 1-Tapping, 3-Moved, 4-Facing right

cave	    = $C9FA  ; The cave data (960 BYTE)
cavestart   = $CA4A  ; Here the actually cave starts (there are 2 empty rows)
caveend     = $CDBA  ; And here the cave ends

; Temporary storage

xy	    = $CFAB  ; (WORD)
tmp	    = $CFAD  ;
string	    = $CFAE  ; Temporary string storage (8 BYTES)
keystat     = $CFB6  ; Keys pressed since last time


.org $D748

StartMenu:
 call BUSY_OFF
 res 1,(iy+$0D)
 call ChooseLevel
 cp $37
 jp z,Quit
 ld hl,0
 ld (score),hl
 ld a,3
 ld (lives),a
 ld hl,500
 ld (nextEL),hl
 xor a
 ld (animCnt2),a
 jr StartLevel

GameOver:
 call GET_KEY
 ld hl,$0403
 ld ($C00F),hl
 ld hl,GameOverText
 set 3,(iy+5)
 call _puts
 res 3,(iy+5)
 ld bc,2000
WaitKey3:
 push bc
 call GET_KEY
 pop bc
 or a
 jr nz,CheckHiscore
 halt
 dec bc
 ld a,b
 or c
 jr nz,WaitKey3
CheckHiscore:
 ld hl,hiscore
 push hl
 call LD_HL_MHL
 ld de,(score)
 call CP_HL_DE
 pop hl
 call c,NewHiscore
 jr StartMenu

RestartLevel:
 ld a,(curCave)
 cp 16
 jr nc,IMOver
 ld hl,lives
 dec (hl)
 ld a,(hl)
 or a
 jp z,GameOver
 jr StartLevel

IMOver:
 ld a,(curCave)
 sub 15
 add a,a
 add a,a
 ld (curCave),a
 cp 16
 jr nz,StartLevel
 xor a
 ld (curCave),a
 ld hl,difLevel
 ld a,(hl)
 cp 4
 jr z,StartLevel
 inc (hl)

StartLevel:
 ld a,r
 srl a
 ld (randseed2),a
 call _clrLCD
 ld hl,0
 ld ($C00F),hl
 ld hl,Title
 set 3,(iy+5)
 call _puts
 res 3,(iy+5)
 ld a,(curCave)
 cp 16
 jr nc,ShowIM
 ld hl,$0602
 ld ($C00F),hl
 ld hl,InfoText2
 call _puts
 ld hl,string
 push hl
 ld a,(curCave)
 add a,65
 ld (hl),a
 inc hl
 ld (hl),47
 inc hl
 ld a,(difLevel)
 add a,49
 ld (hl),a
 inc hl
 ld (hl),0
 pop hl
 call _puts
 ld hl,CaveDesc
 ld a,(curCave)
 ld b,a
 or a
 jr z,DescFound
SearchDesc:
 xor a
 ld c,255
 cpir
 djnz SearchDesc
DescFound:
 push hl
 ld c,21
 xor a
 cpir
 inc c
 srl c
 ld h,c
 ld l,4
 ld ($C00F),hl
 pop hl
 call _puts
 jr ShowLives
ShowIM:
 ld hl,$0303
 ld ($C00F),hl
 ld hl,IMText
 call _puts
 add a,33
 call _putc
ShowLives:
 ld hl,$0406
 ld ($C00F),hl
 ld hl,InfoText3
 call D_ZT_STR
 ld a,(lives)
 add a,48
 call _putc
WaitKey:
 call GET_KEY
 cp K_ENTER
 jr nz,WaitKey
 call _clrLCD
 ld a,10
 ld (flashcnt),a
 call InitLevel
 call GET_KEY
 ld b,60
RemoveAgain:
 push bc
 ld hl,(rockford)
 call ShowScreen
 ld hl,cavestart
RandAgain:
 call NextRandom
 ld a,(randseed1)
 and %00111111
 cp 40
 jr nc,RandAgain
 ld d,0
 ld e,a
 push hl
 add hl,de
 res 7,(hl)
 pop hl
 ld de,40
 add hl,de
 ld de,caveend
 ld a,($C006)
 or a
 jr nz,SkipRemove
 call CP_HL_DE
 jr nz,RandAgain
 pop bc
 djnz RemoveAgain
 push bc
SkipRemove:
 pop bc
 call GET_KEY
 ld hl,cavestart
 ld de,caveend
RemoveAll:
 res 7,(hl)
 inc hl
 call CP_HL_DE
 jr nz,RemoveAll
 call ShowInfoText

MainLoop:
 xor a
 ld ($C006),a
 ld (flags),a
 ld (keystat),a
 call UpdateCounters
 di
 call ScanFrame
 ei
 ld hl,Flags
 bit 4,(hl)
 jr nz,CheckBigAm
 ld a,$15
 ld (amTurn),a
 jr Show
CheckBigAm:
 ld a,(nrAmoeba)
 cp 200
 jr c,Show
 ld a,$11
 ld (amTurn),a
Show:
 ld hl,(rockford)
 call ShowScreen
 ld hl,flags
 bit 2,(hl)
 call nz,UpdateInfo
 bit 3,(hl)
 call nz,FlashScreen
 ld a,(timeLeft)
 or a
 jp z,TimeOut
 ld a,($C006)
 cp K_EXIT
 jr z,QuitGame
 cp K_MORE
 jp z,RestartLevel
 cp K_ALPHA
 call z,Pause
 ld a,(finished)
 bit 1,a
 jr nz,LevelDone
 bit 2,a
 jr z,MainLoop
QuitGame:
 call GET_KEY
 jp GameOver

Pause:
 call _clrLCD
 ld hl,$0803
 ld ($C00F),hl
 ld hl,PauseText
 call _puts
 ld de,$2C17
 ld ($C37C),de
 call _vputs
WaitKey5:
 call GET_KEY
 cp K_ENTER
 jr nz,WaitKey5
 call _clrLCD
 ld hl,(Rockford)
 call ShowScreen
 call ShowInfoText
 ret

ShowInfoText:
 ld b,4
 ld hl,InfoText
WriteNextRow:
 push hl
 call LD_HL_MHL
 ld ($C37C),hl
 pop hl
 inc hl
 inc hl
 call _vputs
 djnz WriteNextRow
 call UpdateInfo
 ret

LevelDone:
 ld hl,timeLeft
 ld a,(hl)
 or a
 jr z,EnterNextCave
 dec (hl)
 ld hl,(score)
 inc hl
 ld (score),hl
 bit 1,l
 call z,UpdateCounters
 ld hl,(rockford)
 call ShowScreen
 call UpdateInfo
 halt
 halt
 jr LevelDone

EnterNextCave:
 ld hl,curCave
 ld a,(hl)
 cp 16
 jr c,NoIM
 ld hl,Lives
 inc (hl)
 ld hl,$0303
 ld ($C00F),hl
 ld hl,ELText2
 set 3,(iy+5)
 call _puts
 res 3,(iy+5)
 call GET_KEY
 ld bc,1000
WaitKey2:
 push bc
 call GET_KEY
 pop bc
 or a
 jp nz,IMOver
 halt
 dec bc
 ld a,b
 or c
 jr nz,WaitKey2
 jp IMOver
NoIM:
 inc (hl)
 ld a,(hl)
 and $03
 jr z,InterMission
 jp StartLevel

InterMission:
 ld a,(hl)
 srl a
 srl a
 add a,15
 ld (curCave),a
 jp StartLevel

TimeOut:
 call GET_KEY
 ld a,(iy+5)
 xor 8
 ld (iy+5),a
 ld hl,$0403
 ld ($C00F),hl
 ld hl,TimeOutText
 call _puts
 ld b,32
TOWait:
 halt
 djnz TOWait
 call GET_KEY
 or a
 jr z,TimeOut
 res 3,(iy+5)
 jp RestartLevel


; ---=== UPDATES THE ANIMATION COUNTERS AND THE FLASH COUNTER ===---

UpdateCounters:
 ld hl,flashcnt
 ld a,(hl)
 or a
 jr z,UpdateELTimer
 dec (hl)
UpdateELTimer:
 ld hl,ELTimer
 ld a,(hl)
 or a
 jr z,UpdateAnimCnt
 dec (hl)
 jr nz,UpdateAnimCnt
 ld hl,Flags
 set 2,(hl)
 set 5,(hl)
UpdateAnimCnt:
 ld hl,animcnt1
 inc (hl)
 ld hl,animcnt2
 inc (hl)
 ld a,(hl)
 srl a
 cp $03
 jr nz,UpdateTimeCnt
 ld (hl),0
UpdateTimeCnt:
 ld hl,finished
 bit 1,(hl)
 ret nz
 ld hl,timecnt
 inc (hl)
 ld a,(hl)
 cp $0A
 ret nz
 ld a,r
 srl a
 ld (RandSeed2),a
 ld (hl),0
 ld hl,TimeLeft
 dec (hl)
 ld hl,Flags
 set 2,(hl)
 ld hl,amTime
 ld a,(hl)
 or a
 jr z,UpdateMW
 dec (hl)
UpdateMW:
 ld a,(mwactive)
 or a
 ret z
 ld hl,mwatime
 dec (hl)
 ld a,(hl)
 or a
 ret nz
 ld (mwactive),a
 ret

; ---=== UPDATES THE NUMBERS TO THE RIGHT ===---

UpdateInfo:
 push hl
 ld hl,(score)
 ld de,(nextEL)
 call CP_HL_DE
 jr c,NoExtraLife
 ld hl,500
 add hl,de
 ld (nextEL),hl
 ld hl,lives
 inc (hl)
 ld a,20
 ld (ELTimer),a
NoExtraLife:
 ld hl,$0378
 ld ($C37C),hl
 ld hl,string
 push hl
 ld a,(curCave)
 cp 16
 jr nc,ShowIMNo
 add a,65
 ld (hl),a
 jr ShowIT
ShowIMNo:
 ld (hl),73
 inc hl
 add a,33
 ld (hl),a
ShowIt:
 inc hl
 ld (hl),0
 pop hl
 call _vputs
 ld a,(dmneeded)
 ld h,0
 ld l,a
 ld de,string+7
 call UnpDigits
 dec de
 ld a,47
 ld (de),a
 ld a,(dmtaken)
 ld h,0
 ld l,a
 ld b,3
 call Unpack
 ld hl,$1563
 ld ($C37C),hl
 ex de,hl
 call _vputs
 ld a,(ELTimer)
 or a
 jr nz,ShowExtraText
 set 3,(iy+5)
 ld hl,Flags
 bit 5,(hl)
 call nz,ShowET
 res 3,(iy+5)
 ld hl,$2067
 ld ($C37C),hl
 ld hl,ScoreText
 call _vputs
 ld de,string+7
 ld hl,(score)
 ld b,5
 call UnpDigits2
 ld hl,$2767
 ld ($C37C),hl
 ex de,hl
 call _vputs
 jr ShowTimeLeft
ShowExtraText:
 call ShowET
ShowTimeLeft:
 ld a,(timeLeft)
 ld h,0
 ld l,a
 ld de,string+7
 call UnpDigits
 ld hl,$396B
 ld ($C37C),hl
 ex de,hl
 call _vputs
 pop hl
 ret

ShowET:
 ld hl,$2067
 ld ($C37C),hl
 ld hl,ExtraLifeText
 call _vputs
 ld de,$2767
 ld ($C37C),de
 call _vputs
 ret

; ---=== UNPACKS hl INTO de ===---

UnpDigits:
 ld b,3
UnpDigits2:
 xor a
 ld (de),a
Unpack:
 call UNPACK_HL
 add a,48
 dec de
 ld (de),a
 djnz Unpack
 ret


; ---=== CHECKS IF ANY KEYS ARE PRESSED ===---

CheckKeys:
 push hl
 ld hl,KeyStat
 ld a,$3E
 out (1),a
 in a,(1)
 or (hl)
 ld (hl),a
 pop hl
 ret


; ---=== SCANS THIS FRAME ===---

ScanFrame:
 xor a
 ld (nrAmoeba),a
 push hl
 ld hl,CaveStart
NextTile:
 ld a,(hl)	       ; Loads a with the tile ($00-$1F, 6 bits)
 cp $07
 jp z,IncTile2
 res 0,a
 or a
 jr z,IncTile2	       ; Check if dirt or space, then skip all
 push hl
 push hl
 or a
 ld de,41
 sbc hl,de
 push hl
 pop ix 	       ; Chg ix to hl-41 so it's easy to check in each dir
 pop hl
 ld a,(hl)	       ; Reloads a
 and %11111001	       ; Check unscanned boulders and jewels
 cp $10
 jp z,F_Falling
 ld a,(hl)
 cp $3A 	       ; Check if unscanned amoeba
 jp z,Amoeba
 cp $04 	       ; Check if Pre Outbox
 jr nz,CheckFinExp
 ld a,(finished)
 bit 0,a	       ; Check if enough jewels been collected
 jr z,IncTile
 ld a,$05
 ld (hl),a	       ; If so, change the pre outbox to flashing outbox
 jr IncTile
CheckFinExp:
 cp $1F 	       ; Check explosion to space stage 4
 jr nz,CheckFinExp2
 ld (hl),$00
 jr IncTile
CheckFinExp2:
 cp $24 	       ; Check explosion to jewel stage 4
 jr nz,CheckRockford
 ld (hl),$15
 jr IncTile
CheckRockford:
 cp $38 	       ; Check if Rockford
 call z,MoveRockford
 ld a,(flashcnt)
 or a		       ; Check if Rockford haven't been borned
 jr nz,Chk1
 ld a,(hl)	       ; If so, check if there are any Pre Rockford stages
 cp $25
 jr c,Chk1
 cp $29
 jr nc,Chk1
 inc (hl)	       ; If so, go to next stage
 cp $28
 jr nz,Chk1	       ; Check if Rockford have been born
 ld (hl),$38	       ; If so then change to Rockford

Chk1:
 ld a,(hl)
 and %1111100
 cp $08 	       ; Check if unscanned firefly
 call z,FireFly
 ld a,(hl)
 and %1111100
 cp $30 	       ; Check if unscanned butterfly
 call z,ButterFly
 ld a,(hl)	       ; Check for explosions, middle stages
 cp $1B
 jr c,IncTile
 cp $24
 jr nc,IncTile
IncExplosion:
 inc (hl)	       ; Go to next explosion step
 jr IncTile
IncTile:
 pop hl
IncTile2:
 inc hl
 ld de,CaveEnd
 call CP_HL_DE	       ; Check if end of cave is reached
 jp nz,NextTile

 ld hl,CaveStart       ; Now remove all scanned frames
NextTile2:
 ld a,(hl)
 and %11111000
 cp $10
 jr nz,NoFallObj
 res 0,(hl)
NoFallObj:
 ld a,(hl)
 cp $39
 jr nz,NotRF
 res 0,(hl)
NotRF:
 cp $3B
 jr z,ScanAm
 cp $1B
 jr z,ExpStage0
 cp $20
 jr z,ExpStage0
 and %11111100
 cp $0C
 jr z,Res2
 cp $34
 jr nz,SFDone
Res2:
 res 2,(hl)
SFDone:
 inc hl
 ld de,CaveEnd
 call CP_HL_DE
 jr nz,NextTile2
 pop hl
 ret
ExpStage0:
 inc (hl)
 jr SFDone
ScanAm:
 dec (hl)
 jr SFDone

F_Falling:	       ; Found a boulder or a jewel (stationary or falling)
 ld b,(hl)
 ld de,40
 add hl,de
 ld a,(hl)
 or a
 jr nz,NoFall
 ld a,b
 or $03
 ld (hl),a
 pop hl
 ld (hl),0
 jr IncTile2
NoFall:
 push af
 cp $03
 jr z,FTMagicWall
 cp $02
 jr z,CheckDiagFall
 and %11111010
 cp $10
 jr z,CheckDiagFall
 pop af
 res 0,a
 cp $38
 jr nz,FFCF
 bit 1,b
 jr z,IncTile
MakeSpcExp:
 ld a,$1B
MakeExp:
 call MakeExplosion
 jr IncTile
FFCF:
 and %11111000
 cp $08
 jr z,MakeSpcExp
 cp $30
 jr nz,MakeStationary
 ld a,$20
 jr MakeExp
MakeStationary:
 res 1,b
 pop hl
 ld (hl),b
 jp IncTile2
CheckDiagFall:
 pop af
 pop hl
 push hl
 dec hl
 ld a,(hl)
 or a
 jr nz,CheckDiagFallR
 push hl
 add hl,de
 ld a,(hl)
 or a
 pop hl
 jr nz,CheckDiagFallR
FillInDiag:
 ld a,b
 or %00000011
 ld (hl),a
 pop hl
 ld (hl),0
 jp IncTile2
CheckDiagFallR:
 inc hl
 inc hl
 ld a,(hl)
 or a
 jr nz,MakeStationary
 push hl
 add hl,de
 ld a,(hl)
 or a
 pop hl
 jr nz,MakeStationary
 jr FillInDiag
FTMagicWall:
 pop af
 bit 1,b
 jp z,IncTile
 ld a,(mwatime)
 or a
 jr z,ClearAbove
 ld a,1
 ld (mwactive),a
 add hl,de
 ld a,(hl)
 or a
 jr nz,ClearAbove
 ld a,b
 or $03
 xor $04
 ld (hl),a
ClearAbove:
 pop hl
 xor a
 ld (hl),0
 jp IncTile2

; ---=== CHECK THE SURROUNDINGS FOR ROCKFORD OR AMOEBA ===--

ChkSur:
 push ix
 ld hl,DirDat1
 ld b,4
 ld d,0
RepCS:
 ld e,(hl)
 inc hl
 add ix,de
 ld a,(ix+0)
 cp $3A
 jr z,CSARF
 res 0,a
 cp $38
 jr z,CSARF
 djnz RepCS
CSARF:
 pop ix
 ret

; ---=== MOVE FIREFLY ===---

FireFly:
 push hl
 call ChkSur
 jr z,FFExpl
 pop hl
 push hl
 ld a,(hl)
 and $03
 ld hl,DirDat2
 ld d,0
 ld e,a
 add hl,de
 ld d,0
 ld e,(hl)
 inc hl
 ld c,(hl)
 dec a
 ld b,a
 push ix
 pop hl
 add hl,de
 ld a,(hl)
 or a
 jr z,MoveFF
 sbc hl,de
 inc b
 ld e,c
 add hl,de
 ld a,(hl)
 or a
 jr z,MoveFF
 inc b
 ld a,b
 and $03
 set 3,a
 set 2,a
 pop hl
 ld (hl),a
 ret
MoveFF:
 ld a,b
 and $03
 set 3,a
 set 2,a
 ld (hl),a
 pop hl
 ld (hl),0
 ret

FFExpl:
 pop hl
 ld a,$1B
 call MakeExplosion
 ret


; ---=== MOVE BUTTERFLY ===---

ButterFly:
 push hl
 call ChkSur
 jr z,BFExpl
 pop hl
 push hl
 ld a,(hl)
 and $03
 ld hl,DirDat2+1
 ld d,0
 ld e,a
 add hl,de
 ld d,0
 ld e,(hl)
 dec hl
 ld c,(hl)
 inc a
 ld b,a
 push ix
 pop hl
 add hl,de
 ld a,(hl)
 or a
 jr z,MoveBF
 sbc hl,de
 dec b
 ld e,c
 add hl,de
 ld a,(hl)
 or a
 jr z,MoveBF
 dec b
 ld a,b
 and $03
 or %00110100
 pop hl
 ld (hl),a
 ret
MoveBF:
 ld a,b
 and $03
 or %00110100
 ld (hl),a
 pop hl
 ld (hl),0
 ret

BFExpl:
 pop hl
 ld a,$20
 call MakeExplosion
 ret


; ---=== CHECK IF AMOEBA SHOULD GROW ===---

Amoeba:
 ld a,(amTurn)
 or a
 jr z,NoAmTurning
 ld (hl),a
 jp IncTile
NoAmTurning:
 push hl
 ld hl,nrAmoeba
 inc (hl)
 ld hl,Flags
 bit 4,(hl)
 pop hl
 jr nz,DirsChecked
 xor a
CheckDirs:	       ; Check if its possible to grow
 push af
 push hl
 call CheckDir
 jr nz,NextDir
 ld hl,Flags
 set 4,(hl)
NextDir:
 pop hl
 pop af
 inc a
 cp $04
 jr nz,CheckDirs
DirsChecked:
 ld a,(amTime)
 ld c,32
 or a
 jr z,CheckGrowTry
 ld c,4
CheckGrowTry:
 call NextRandom
 ld a,(RandSeed1)
 and $7F
 cp c
 jp nc,IncTile
 and $03
 push hl
 call CheckDir
 jr nz,GrowNotPoss
 ld (hl),$3B
GrowNotPoss:
 pop hl
 jp IncTile

CheckDir:
 ld hl,DirDat2
 ld d,0
 ld e,a
 add hl,de
 ld d,0
 ld e,(hl)
 push ix
 pop hl
 add hl,de
 ld a,(hl)
 and $FE
 or a
 ret

; ---=== CHECK IF PLAYER HAS MOVED ROCKFORD ===---

MoveRockford:
 push hl
 ld hl,RFMove
 res 3,(hl)
 ld hl,flags
 set 0,(hl)	       ; Rockford found!
 pop hl
 ld d,h
 ld e,l
 xor a
 ld (tmp),a
 call CheckKeys
 bit 5,a
 jr nz,NoButtonPres
 push af
 ld a,1
 ld (tmp),a
 pop af
NoButtonPres:
 bit 1,a
 jr z,MoveLeft
 bit 2,a
 jr z,MoveRight
 bit 0,a
 jr z,MoveDown
 bit 3,a
 jr z,MoveUp
 ld a,($C006)
 dec a
 jr z,MoveDown
 dec a
 jr z,MoveLeft
 dec a
 jr z,MoveRight
 dec a
 jr z,MoveUp
 ret
MoveLeft:
 push hl
 ld hl,RFMove
 set 3,(hl)
 res 4,(hl)
 pop hl
 ld bc,$FF00
 dec de
 dec de
 ld (xy),de
 inc de
 jr HorzMove
MoveRight:
 push hl
 ld hl,RFMove
 set 3,(hl)
 set 4,(hl)
 pop hl
 ld bc,$0100
 inc de
 inc de
 ld (xy),de
 dec de
HorzMove:
 push hl
 ld hl,flags
 set 1,(hl)	       ; Rockford is moving
 pop hl
 ld a,(de)
 res 0,a
 cp $10
 jr nz,CheckMove
 push de
 ld de,(xy)
 ld a,(de)
 or a
 jr nz,NoPushing
 call NextRandom
 ld a,(RandSeed1)
 and $03
 jr nz,NoPushing       ; Only 1/4 chance that the boulder will be pushed
 ld a,$11
 ld (de),a
 pop de
 xor a
 ld (de),a
 jr MoveOK
NoPushing:
 pop de
 ret
MoveDown:
 ld bc,$0001
 push hl
 push hl
 ld hl,RFMove
 set 3,(hl)
 pop hl
 ld de,40
 add hl,de
 ex de,hl
 pop hl
 jr CheckMove
MoveUp:
 push hl
 ld hl,RFMove
 set 3,(hl)
 pop hl
 ld bc,$00FF
 push ix
 pop de
 inc de
CheckMove:
 push hl
 ld hl,flags
 set 1,(hl)	       ; Rockford is moving
 pop hl
 ld a,(de)
 cp $05 	       ; Check if exit is reached
 jr z,MoveToOutBox
 res 0,a
 or a
 jr z,MoveOK
 and %11111100
 cp $14 	       ; A jewel?
 ret nz
 xor a		       ; Yes! Then update scores and taken jewels
 ld (de),a
 push bc
 push hl
 ld a,(finished)
 bit 0,a	       ; Check if enough jewels have been taken
 ld a,(dmscore1)
 jr z,NoBonus
 ld a,(dmscore2)       ; Yes, you got bonus points
NoBonus:
 ld b,0
 ld c,a
 ld hl,(score)
 add hl,bc
 ld (score),hl
 ld hl,dmtaken
 inc (hl)
 ld a,(hl)
 ld hl,dmneeded
 cp (hl)
 ld hl,flags
 jr nz,NotEqual        ; Check if the last needed jewel was taken
 ld a,1
 ld (finished),a
 set 3,(hl)	       ; The screen will flash
NotEqual:
 set 2,(hl)	       ; The score has been updated
 pop hl
 pop bc
MoveOK:
 xor a
 ld (de),a
 ld a,(tmp)	       ; Check if button was pressed
 or a
 ret nz 	       ; It was, then don't move
 push hl
 ld (hl),0
 ex de,hl
 ld (hl),$39
 ld hl,(rockford)
 ld a,h
 add a,b
 ld h,a
 ld a,l
 add a,c
 ld l,a
 ld (rockford),hl
 pop hl
 ret
MoveToOutBox:
 push hl
 ld hl,finished
 set 1,(hl)
 pop hl
 jr MoveOK


; ---=== CREATES EXPLOSION a WITH CENTRE AT hl ===---

MakeExplosion:
 push bc
 push de
 push hl
 ld c,a
 or a
 ld de,41
 sbc hl,de
 ld de,38
 ld b,3
MakeExpRep:
 call CheckSq
 inc hl
 call CheckSq
 inc hl
 call CheckSq
 add hl,de
 djnz MakeExpRep
 pop hl
 pop de
 pop bc
 ret

CheckSq:
 ld a,(hl)
 cp $07
 ret z
 ld (hl),c
 ret


; ---=== FLASHES THE SCREEN A SHORT WHILE ===--

FlashScreen:
 ld b,2
FlashAgain:
 push bc
 ld hl,$FC00
 ld bc,1024
F_NextByte:
 ld a,(hl)
 xor $FF
 ld (hl),a
 inc hl
 dec bc
 ld a,b
 or c
 jr nz,F_NextByte
 ld b,20
Wait:
 halt
 djnz Wait
 pop bc
 djnz FlashAgain
 ret

; ---=== SHOWS THE SCREEN WITH h, l AS MIDDLE POINT ===---

ShowScreen:
 ld bc,$2114
 ld a,(curCave)
 cp 16
 jr c,CheckEdges
 ld bc,$0D0A
CheckEdges:
 push hl
 ld a,h
 cp $05
 jr nc,LeftEdgeOK
 ld h,5
LeftEdgeOK:
 cp b
 jr c,RightEdgeOK
 ld h,b
RightEdgeOK:
 ld a,l
 cp $06
 jr nc,TopEdgeOK
 ld l,$06
TopEdgeOK:
 cp c
 jr c,BotEdgeOK
 ld l,c
BotEdgeOK:
 or a
 ld de,$0504
 sbc hl,de
 ld a,h
 ld (tmp),a
 ld de,0
 ld b,8
S_NextRow:
 push bc
 ld b,12
S_NextCol:
 push de
 push hl

 call GetObject
 bit 7,a
 jr z,Uncovered
 ld a,$07
Uncovered:
 cp $25
 jr nz,CheckOutbox
 ld a,(flashcnt)
 or a
 ld a,$25
 jr z,ConvertImage
FlashBox:
 ld a,(animcnt1)
 bit 2,a
 ld a,$04
 jr nz,PutIt
 ld a,$11
 jr PutIt
CheckOutbox:
 cp $05
 jr nz,ConvertImage
 jr z,FlashBox
ConvertImage:
 ld hl,Object_Table
 ld d,0
 ld e,a
 add hl,de
 ld a,(hl)
 or a
 jr z,RFAnim
 cp $05 	       ; Check if Jewel
 jr nz,ChFF
 ld hl,animcnt2
 ld d,(hl)
 srl d
 add a,d	       ; Choose image depending on AnimCnt2
 jr PutIt
ChFF:
 cp $12 	       ; Check if Firefly
 jr nz,ChBF
 ld hl,animcnt1
 ld d,(hl)	       ; Choose image depending on AnimCnt1
 bit 1,d
 jr z,PutIt
 inc a
 jr PutIt
ChBF:
 cp $14 	       ; Check if Butterfly
 jr nz,ChAM
 ld hl,animcnt1
 ld d,a
 ld a,(hl)
 and %00000111
 add a,d	       ; Choose image depending on AnimCnt1
 jr PutIt
ChAM:
 cp $1C
 jr nz,ChMW	       ; Check if Amoeba
 ld hl,animcnt1
 ld d,a
 ld a,(hl)
 srl a
 and $03
 add a,d
 jr PutIt
ChMW:
 cp $2E
 jr nz,PutIt
 ld a,(mwactive)
 or a
 ld a,$2E
 jr z,PutIt
 inc a
 ld hl,animcnt1
 ld d,a
 ld a,(hl)
 and $03
 add a,d
PutIt:
 pop hl
 pop de

 ex de,hl
 call PutSprite
 ex de,hl
 inc d
 inc h
 dec b
 jp nz,S_NextCol
 ld a,(tmp)
 ld h,a
 inc l
 ld d,0
 inc e
 pop bc
 dec b
 jp nz,S_NextRow
 pop hl
 ret

RFAnim:
 ld a,(animcnt1)
 and $03
 ld hl,RFMove
 jr nz,SameAnim
 call NextRandom
 ld a,(RandSeed1)
 and $07
 jr nz,NoTapChange
 ld a,(hl)
 xor 2
 ld (hl),a
NoTapChange:
 res 0,(hl)
 call NextRandom
 ld a,(RandSeed1)
 and $03
 jr nz,NoBlinking
 set 0,(hl)
NoBlinking:
 xor a
SameAnim:
 bit 3,(hl)
 jr z,RFForward
 bit 4,(hl)
 jr nz,RF_Right
 add a,$26
StopTapBlink:
 res 0,(hl)
 res 1,(hl)
 jr PutIt
RF_Right:
 add a,$2A
 jr StopTapBlink
RFForward:
 ld a,(animcnt1)
 and $03
 srl a
 ld d,a
 ld a,(RFMove)
 and $03
 jr z,PutIt
 add a,a
 add a,$1E
 add a,d
 jr PutIt

; ---=== PUT GRAPHIC IMAGE a AT h, l ===---

PutSprite:
 push bc
 push de
 push hl
 ld d,l
 ld e,0
 or a
 rr d
 rr e		       ; Multiplying l with 128
 ld l,h
 ld h,0
 add hl,de
 ld de,$FC00
 add hl,de	       ; hl now points to the upper left corner of the image
 ex de,hl
 ld h,0
 ld l,a
 add hl,hl
 add hl,hl
 add hl,hl
 ld bc,G_Rockford
 add hl,bc
 ld b,8
PutRow:
 ldi
 push hl
 ex de,hl
 ld de,15
 add hl,de
 ex de,hl
 pop hl
 djnz PutRow
 pop hl
 pop de
 pop bc
 ret


; ---=== DECOMPRESS CURRENT LEVEL INTO GRAPHMEM ===---

InitLevel:
 xor a
 ld (timecnt),a
 ld (finished),a
 ld (dmtaken),a
 ld (amTurn),a
 ld (mwactive),a
 ld (ELTimer),a
 ld hl,CaveData
 ld a,(curCave)
 or a
 jr z,CaveFound
 ld b,a
SearchCave:
 ld d,(hl)
 inc hl
 ld e,(hl)
 dec hl
 add hl,de
 djnz SearchCave
CaveFound:
 inc hl 	       ; Skip the pointer
 inc hl
 inc hl 	       ; The first information is unimportant (cave nr)
 ld de,mwatime
 ldi
 ldi
 ldi
 ld a,(mwatime)
 ld (amTime),a
 ld a,(difLevel)
 push af
 ld d,0
 ld e,a
 add hl,de	       ; Find the right seeds depending on difficulty
 ld a,(hl)
 ld (randseed2),a
 ld de,5
 add hl,de
 ld a,(hl)
 ld (dmneeded),a
 add hl,de
 ld a,(hl)
 ld (timeLeft),a
 pop af
 sub 10
 neg
 ld d,0
 ld e,a
 add hl,de	       ; and jump to the scattered objects
 ld de,randobj
 ld bc,8
 ldir		       ; Move the next 8 byte into their right positions
 push hl
 xor a
 ld (randseed1),a
 ld bc,$0003	       ; Start scattering objects. B = x, C = y
ScatNext:
 ld (xy),bc
 push bc
 call NextRandom
 ld c,1 	       ; If no object chosen, then dirt
 ld hl,probobj
 ld b,4
 ld a,(randseed1)
CheckProb:
 cp (hl)
 jr nc,NotLesser
 push hl
 dec hl
 dec hl
 dec hl
 dec hl
 ld c,(hl)
 pop hl
NotLesser:
 inc hl
 djnz CheckProb
 ld a,c
 ld hl,(xy)
 call StoreObject
 pop bc
 inc b
 ld a,b
 cp 40
 jr c,ScatNext
 ld b,0
 inc c
 ld a,c
 cp $18
 jr c,ScatNext
 ld hl,$0002
 ld bc,$2816
 ld a,7
 call DrawRect
 pop ix
GetNext:
 ld a,(ix)
 cp $FF
 ret z
 and $3F
 ld e,a
 ld a,(ix)
 rlca
 rlca
 and $03
 ld h,(ix+1)
 ld l,(ix+2)
 ld b,(ix+3)
 ld c,(ix+4)
 ld d,(ix+5)
 jr z,StoObj
 dec a
 jr z,DrLine
 dec a
 jr z,FillRec
DrRec:
 ld a,e
 call DrawRect
 ld de,5
 add ix,de
 jr GetNext
StoObj:
 ld a,e
 cp $25
 jr nz,NotRockford
 ld (rockford),hl
NotRockford:
 cp $04
 jr nz,NotOutBox
NotOutBox:
 call StoreObject
 inc ix
 inc ix
 inc ix
 jr GetNext
DrLine:
 ld a,e
 call DrawLine
 ld de,5
 add ix,de
 jr GetNext
FillRec:
 ld a,e
 call DrawFillRect
 ld de,6
 add ix,de
 jr GetNext

; ---=== DRAW LINE FROM h, l WITH LENGTH b, DIRECTION c, OBJECT a ===---

DrawLine:
 push bc
 push de
 push hl
 push ix
 ld ix,ldx
 ld d,0
 ld e,c
 add ix,de
PlotObj:
 call StoreObject
 push af
 ld a,h
 add a,(ix+0)
 ld h,a
 ld a,l
 add a,(ix+8)
 ld l,a
 pop af
 djnz PlotObj
 pop ix
 pop hl
 pop de
 pop bc
 ret

; ---=== DRAW RECTANGLE FROM h,l WITH THE DIM b,c BORDER a FILL d ===--

DrawFillRect:
 call DrawRect
 ld a,d
RepDFR:
 inc h
 inc l
 dec b
 ret z
 dec b
 ret z
 dec c
 ret z
 dec c
 ret z
 call DrawRect
 jr RepDFR

; ---=== DRAW RECTANGLE FROM h,l WITH THE DIM b, c BORDER a ===---

DrawRect:
 push bc
 push de
 push hl
 ld d,b
 ld e,c
 ld c,2
 call DrawLine
 ld b,e
 ld c,4
 call DrawLine
 push hl
 push af
 ld a,l
 add a,e
 ld l,a
 dec l
 pop af
 ld b,d
 ld c,2
 call DrawLine
 pop hl
 push af
 ld a,h
 add a,d
 ld h,a
 dec h
 pop af
 ld b,e
 ld c,4
 call DrawLine
 pop hl
 pop de
 pop bc
 ret

; ---=== STORE OBJECT a AT h,l IN CAVE ===---

StoreObject:
 push bc
 push de
 push hl
 ld c,h
 ld h,0
 add hl,hl
 add hl,hl
 add hl,hl
 ld d,0
 ld e,l
 add hl,hl
 add hl,hl
 add hl,de    ; Now hl = l * 40
 ld e,c
 add hl,de    ; Adding the x-position
 ld de,Cave
 add hl,de    ; And finally the offset to the cavedata
 or $80       ; Set a bit that this object hasn't been uncovered
 ld (hl),a    ; And store the object
 pop hl
 pop de
 pop bc
 ret


; ---=== GET OBJECT a AT h,l IN CAVE ===---

GetObject:
 push bc
 push de
 push hl
 ld c,h
 ld h,0
 add hl,hl
 add hl,hl
 add hl,hl
 ld d,0
 ld e,l
 add hl,hl
 add hl,hl
 add hl,de    ; Now hl = l * 40
 ld e,c
 add hl,de    ; Adding the x-position
 ld de,Cave
 add hl,de    ; And finally the offset to the cavedata
 ld a,(hl)    ; And get the object
 pop hl
 pop de
 pop bc
 ret


; ---=== GETS THE NEXT "RANDOM" NUMBER ===---

NextRandom:
 push af
 push bc
 push de
 ld a,(randseed1)
 rrca
 and $80
 ld b,a
 ld a,(randseed2)
 ld d,a
 rrca
 and $7F
 ld c,a
 ld a,d
 rrca
 and $80
 add a,d
 adc a,$13
 ld (randseed2),a
 ld a,(randseed1)
 adc a,b
 adc a,c
 ld (randseed1),a
 pop de
 pop bc
 pop af
 ret


; ---=== CHOOSE CAVE AND DIFFICULTY ===---

ChooseLevel:
 call _clrLCD
 ld hl,TitlePic
 ld de,$FC40
 ld bc,272
 ldir
 ld de,$FE00
 ld bc,112
 ldir
 ld hl,$3804
 ld ($C37C),hl
 ld hl,AuthorText
 call _vputs
 xor a
 ld (curCave),a
 ld (difLevel),a
C_Wait:
 ld a,(difLevel)
 cp 3
 jr c,LowLevel
 xor a
 ld (curCave),a
LowLevel:
 ld hl,$0804
 ld ($C00F),hl
 ld a,(curCave)
 add a,65
 call _putc
 ld hl,$1104
 ld ($C00F),hl
 ld a,(difLevel)
 add a,49
 call _putc
 ld hl,$2D1F
 ld ($C37C),hl
 ld hl,HiScoreText
 call _vputs
 call LD_HL_MHL
 ld de,string+5
 ld b,5
 call UnpDigits2
 ex de,hl
 call _vputs
WK:
 call GET_KEY
 ld hl,difLevel
 cp K_ENTER
 ret z
 cp K_SECOND
 ret z
 cp $37
 ret z
 dec a
 jr z,LevD
 dec a
 jr z,CaveD
 dec a
 jr z,CaveI
 dec a
 jr nz,WK
 ld a,(hl)
 cp $04
UpdInfo1:
 jr z,WK
 inc (hl)
 jr C_Wait
LevD:
 ld a,(hl)
 or a
 jr z,WK
 dec (hl)
 jr C_Wait
CaveI:
 ld hl,curCave
 ld a,(hl)
 cp 12
 jr z,WK
 add a,4
 ld (hl),a
 jr C_Wait
CaveD:
 ld hl,curCave
 ld a,(hl)
 or a
 jr z,WK
 sub 4
 ld (hl),a
 jp C_Wait

NewHiscore:
 ld (hl),e
 inc hl
 ld (hl),d
 call _clrLCD
 ld hl,$0401
 ld ($C00F),hl
 ld hl,NewHiText
 call _puts
 ld de,$0303
 ld ($C00F),de
 call _puts
 ld ix,HiScoreName
 ld (ix),65
 ld (ix+1),65
 ld (ix+2),65
 push ix
 pop de
 ld c,1
EnterName:
 call ShowName
WaitKey4:
 push de
 call GET_KEY
 pop de
 or a
 jr z,WaitKey4
 cp K_SECOND
 ret z
 cp K_EXIT
 ret z
 cp K_ENTER
 jr z,NextLet
 dec a
 jr z,LetBelow
 dec a
 jr z,PrevLet
 dec a
 jr z,NextLet
 dec a
 jr nz,WaitKey4
LetAbove:
 ld a,(de)
 cp 90
 jr nz,SuccLet
 ld a,64
SuccLet:
 inc a
 ld (de),a
 jr EnterName
PrevLet:
 ld a,c
 dec a
 jr z,WaitKey4
 dec c
 dec de
 jr EnterName
NextLet:
 ld a,c
 cp 3
 ret z
 inc c
 inc de
 jr EnterName
LetBelow:
 ld a,(de)
 cp 65
 jr nz,DecLet
 ld a,91
DecLet:
 dec a
 ld (de),a
 jr EnterName

ShowName:
 push ix
 ld b,1
 ld hl,$0905
 ld ($C00F),hl
RepTypeLet:
 res 3,(iy+5)
 ld a,c
 cp b
 jr nz,TypeLet
 set 3,(iy+5)
TypeLet:
 ld a,(ix)
 call _putc
 inc ix
 inc b
 ld a,b
 cp 4
 jr nz,RepTypeLet
 res 3,(iy+5)
 pop ix
 ret

Quit:
 ld hl,ProgName
 rst 20h
 rst 10h
 ex de,hl
 ld a,b
 ld de,HiscoreName-$D748+4
 add hl,de
 adc a,0
 ld de,HiscoreName
 ld b,9
RepCopy:
 push bc
 push af
 push hl
 push de
 call $46C3
 pop de
 ld a,(de)
 ld (hl),a
 pop hl
 pop af
 push de
 call $4637
 pop de
 inc de
 pop bc
 djnz RepCopy

 set 1,(iy+$0D)
 call _clrScrn
 ld hl,0
 ld ($C00F),hl
 ret

D_ZT_STR:
 ld a,(hl)
 inc hl
 or a
 ret z
 call _putc
 jr D_ZT_STR

InfoText:
 .db 102,3,"Cave  ",0
 .db 101,14,"Jewels",0
 .db 103,32
ScoreText:
 .db "Score",0
 .db 105,50,"Time",0

InfoText2:
 .db "Cave: ",0

InfoText3:
 .db "Lives left: ",0

IMText:
 .db "Intermission ",0

ExtraLifeText:
 .db "EXTRA",0
 .db "   LIFE   ",0

ELText2:
 .db "* Extra life! *",0

GameOverText:
 .db "* GAME OVER *",0

AuthorText:
 .db "BY JIMMY MARDELL, "
 .db "mja@algonet.se",0

TimeOutText:
 .db " Out of time ",0

ldx:
 .db 0,1,1,1,0,-1,-1,-1
ldy:
 .db -1,-1,0,1,1,1,0,-1

DirDat1:	       ; Dat for checking if Rockford is close
 .db 1,39,2,39

DirDat2:	       ; First try ofs, second try ofs
 .db 81,40,1,42,81

HiScoreText:
 .db "Hiscore:  "
HiScoreName:
 .db 45,45,45,"   ",0
HiScore:
 .dw 0

ProgName:
 .db $12,2,"bd"

NewHiText:
 .db "A NEW HISCORE",0
EnterNameText:
 .db "Enter your name",0

PauseText:
 .db "PAUSE",0
 .db "Press any key to continue",0

Title:
 .db "BoulderDash 1.0      ",0

#include graphics.h
#include bd1caves.h
#include titlepic.h

.end
