; Space Invaders v1.2
; by David Lenhart

; I haven't discovered any bugs in this program, but I'll have 
; to admit it is a bit messy.  The Put8x5 routine may be useful 
; to you.  I haven't compared it to any other routines, but I 
; optimized it as best I could, and it should be fast.
; 
; This program copies many subroutines to graphics mem for faster calling.

; IMPROVEMENTS OVER v1.1
; - Allows you to skip the demo between levels.
; - Game speed is more constant when moveing left or right.
; - UFO end guy is tougher to kill now.

#include "ti-85.h"
.org 0
.db "Space Invaders  1.2",0

ArriveMem =     GRAPH_MEM
invPic =        ArriveMem+($10*11)
gunPic =        invPic+5
Put8x5 =        gunPic+5
divide =        Put8x5+59  ;59=size of routine
multiply =      divide+7
PutShields =    multiply+8
PutPiece =      PutShields+40
delay =         PutPiece+17
DrawBullet =    delay+8
dot =           DrawBullet+60
DetectHit =     dot+10
move =          DetectHit+12
Space =         move+11
Invaders =      Space+6
ByDavidLenhart = Invaders+9
YouWin  =       ByDavidLenhart+17
Zero =          YouWin+9-1
RotateUFO =     YouWin+9
UFO =           RotateUFO+47
ScreenOff =     UFO+(11*4)
ScreenOn =      ScreenOff+12
KillPlayer =    ScreenOn+9
BigText =       KillPlayer+10
DrawRow =       BigText+131
PutUFO =        DrawRow+25
Shifteroo =     PutUFO+27
o =             Shifteroo+12
StartPixel =    o
RandNum =       o+1
DestroyTimer =  o+2
ContrastLev =   o+3
ShotTimer =     o+4
DownCount =     o+5
playerLife =    o+6
RotateByte =    o+7
ExplXY =        o+8
ExplY =         ExplXY
ExplX =         ExplY+1
X =             ExplXY+2
invLeft =       o+11
invDir =        o+12
invDelay =      o+13
invTimer =      o+14
invRows =       o+15
InvThisLevel =  o+16 
invXY =         o+17 
invY =          invXY
invX =          invY+1
Bullets =       invXY+2                   ;3 bytes for: y, x, direction
pBullets =      Bullets+(maxBullets*3)       ; 2 bytes for y, x
gunXY =         pBullets+(pMaxBullets*2)
gunY =          gunXY
gunX =          gunY+1
shields =       gunXY+2
invExist =      shields+(ShieldHeight*6)           ; 6 8-bit wide shields


ShieldHeight = 5
alive = 1
dead = 0
pMaxBullets = 8
maxBullets = 7
FireButton =    $36
invXspacing =   13
invYspacing =   8
invPerRow =     6
invMax =        6*6
FiringDelay =   7
ShieldAltitude = 13
cursor = $800C

        ld a, 4        
        out (5), a

        ld hl, (PROGRAM_ADDR)
        ld de, pic1
        add hl, de
        ld de, invPic
 ld bc, 5+5+59+7+8+40+17+8+60+10+12+11+6+9+17+9+47+44+12+9+10+131+25+27+12
        ldir                    ; copy stuff to fixed mem
        
        ROM_CALL(ClearLCD)

        ld hl, Space
        ld b, (6*5)-1
        ld de, ((127-(12*5))/2)*$100+$2C
        call BigText

        ld hl, Invaders
        ld b, (6*8)-1
        ld de, ((127-(12*8))/2)*$100+$1C
        call BigText

        ld hl, $3925
        ld ($8333), hl
        ld hl, ByDavidLenhart
        ROM_CALL(D_ZM_STR)
        ld de, $FEA6
        call PutUFO
        ld hl, ($100*(48-21))+16+6
        ld (invXY), hl

rotate:
        call RotateUFO
        ld bc, $2000
        call delay
        call GET_KEY
;        ld a, (KEY_0)
        or a                    ; set flag
        jr z, rotate
        cp $37                   ; exit
        ret z

        xor a                   ;a=0
        ld (invRows), a         ; Starting level-1

NewLevel:        
        ld a, (invRows)
        inc a
        ld (invRows), a
        cp 7
        JUMP_Z(Winner)
        ROM_CALL(ClearLCD)
        cp 6
        CALL_NZ(invUnload)
LevelStart:
        ld a, alive
        ld (PlayerLife), a
        
        ROM_CALL(ClearLCD)
        ld a, (invRows)
        ld c, a
        ld b, invPerRow
        call multiply         ;a=b*c
        ld (invLeft), a
        ld (InvThisLevel), a

        ld hl, invExist
        ld (hl), alive
        ld de, invExist+1
        ld bc, invMax-1
        ldir                            ; rejuvenate invaders


        ld hl, pBullets
        ld (hl), 64
        ld de, pBullets+2
        ld bc, 2*(pmaxbullets-1)
        ldir                            ; set all player bullets offscreen
        
        ld hl, Bullets
        ld (hl), 64
        ld de, Bullets+3
        ld bc, 3*(maxbullets-1)
        ldir                            ; set all invader bullets offscreen

        ld  hl, shields                 
        ld (hl), 11111111b
        ld de, shields+1
        ld bc, (6*Shieldheight)-1
        ldir                            ; start with all shields solid
        call PutShields

        ld bc, $3C05
        ld (gunXY), bc
        ld de, gunPic
        call Put8x5
        
        ld a, (invRows)
        cp 6                    ; level 6 = end level
        push af
        CALL_Z(UFOArrive)
        ld a, (127-((invXspacing*invPerRow)-(invXspacing-7)))/2
        ld (invX), a
        ld a, 63
        ld (invY), a
        pop af
        CALL_NZ(invArrive)
        
        
        ld a, (invRows)
        inc a
        ld b, a
        ld a, 63
        call divide           ; c=a/b   a+b=remainder
        ld a, 1
        ld hl, bullets
drawnext:                       ; spread out bullets evenly
        push bc
        ld (hl), a
        ld c, a
        inc hl
        ld b, 2
        ld (hl), b
        inc hl
        ld (hl), 0
        inc hl
        push af
        call DrawBullet
        pop af
        pop bc
        add a, c
        djnz drawnext

        ld a, r
        and 2
        dec a                   ; random  -1 or 1
        ld (invDir), a
        ld a, 6
        ld (invDelay), a

      
        xor a
        ld (ShotTimer), a
        ld (DownCount), a
Shift:
        ld a, (DownCount)
        or a
        jr z, SkipDown
        dec a
        ld (DownCount), a
        CALL_(ShiftDown)
        jr SkipLeftRight
SkipDown:
        ld a, (invDir)
        push af
        inc a
        CALL_Z(ShiftLeft)               ;if a was -1
        pop af
        dec a
        CALL_Z(ShiftRight)              ;if a was 1
SkipLeftRight:
        call PutShields

        ld a, (invDelay)
        ld (invTimer), a
ActionLoop:
        ld a, (invRows)
        cp 6
        jr nz, SkipRotate
        call RotateUFO
SkipRotate:
        ld a, (PlayerLife)
        or a
        jr nz, SkipDestroy
        ld bc, (gunXY)
        ld de, GRAPH_MEM+256    ; use program instructions in graph mem
        ld a, r                 ; as graphic for explosion
        add a, e
        ld e, a
        ld a, r
        and 3
        add a, c
        ld c, a
        ld a, r
        and 3
        sub 2
        add a, b
        ld b, a
        call Put8x5               ;draw trash
        ld hl, DestroyTimer
        dec (hl)
        JUMP_Z(LevelStart)
        ld a, 250
        ld (invTimer), a
        JUMP_(DisableMoves)
SkipDestroy:
        ld a, 10111111b
        out (1), a
        in a, (1)
        bit 6, a                ; exit?
        jr nz, SkipExit
        call GET_KEY
        ret
SkipExit:
          ld hl, ShotTimer      ;recently added
        bit 5, a                ; 2nd = Fire Button
        jr nz, NoShot
        ld a, (hl)
        or a
        jr nz, NoShot
        ld a, FiringDelay
        ld (hl), a
          push hl               ;recently added
        ld hl, pBullets-2
SearchAgain:
        inc hl
        inc hl          ; 2 bytes, 1 for Y and 1 for X
        bit 6, (hl)
        jr z, SearchAgain       ; find an unused bullet
        
        ld c, 6                 ; bullet starts out at height of 6
        ld (hl), c              ; save Y coord
        inc hl
        ld a, (gunX)
        add a, 3
        ld b, a
        ld (hl), b              ; save X coord
        call DrawBullet
          pop hl                ;recently added
NoShot:
          ;;ld hl, ShotTimer    ;recently changed
        ld a, (hl)
        or a
        jr z, GunReady
        dec (hl)
GunReady:
        ld bc, (gunXY)
        ld a, 11111110b
        out (1), a
        in a, (1)
          push af        ; RECENT
          ld e, a
        and 00000110b
        cp 00000110b
        jr nz, pressedLorR
        push bc
        ld bc, $400
        call delay
        pop bc
pressedLorR:
          ld a, e
        bit 1, a        ;left
        jr nz, NotLeft
        ld de, gunPic
        call Put8x5
        ld a, b
        cp 1
        jr z, nope1        ; getting close to edge of screen?
        dec b
nope1:
        ld de, gunPic
        call Put8x5
NotLeft:
          pop af           ; RECENT
        bit 2, a        ;right
        jr nz, NotRight
        ld de, gunPic
        call Put8x5
        ld d, a         ;push
        ld a, b
        cp 127-7
        ld a, d         ;pop 
        jr z, nope2
        inc b
nope2:
        ld de, gunPic
        call Put8x5
NotRight:
        ld (gunXY), bc
DisableMoves:
        CALL_(DoBullets)
        JUMP_Z(NewLevel)       ; if level level has been won
        ld hl, invTimer
        dec (hl)
        JUMP_Z(Shift)

        ld bc, $940
        call delay
        JUMP_(ActionLoop)




DoBullets:
        ld hl, pBullets
        ld b, pMaxBullets
pGunLoop:
        push bc                 ; b = loop counter
        ld c, (hl)              ; Y
        ld a, c
        bit 6, c               ; off screen? 
        inc hl         ; adjust
        push bc
        ld bc, 200
        call nz, delay
        pop bc
        JUMP_NZ(BulletGone)
        dec hl
        ld a, c
        inc a
        cp 61
        jr nz, ok
        ld a, 64
ok:
        ld (hl), a              ; increment Y coord in mem
        inc hl
        ld b, (hl)              ; X

        push af
        call DrawBullet       ; erase
        pop af
        cp 64
        JUMP_Z(BulletGone)
        inc c
        call DrawBullet       ; redraw
        push hl                 ; save mem position in bullet info
        call DetectHit                ; z =hit, nz = miss
        JUMP_NZ(NoKills)
                                
        ld d, b                 ; bc,de = bulletXY
        ld e, c
        
        ld a, (invX)
        ld h, a
        ld a, d
        sub h                   ; a=bulletX-invX
        jr c, NoKills           ; bulletX-invX < 0
        
        ld b, a                 ; save a
        ld a, invPerRow*invXspacing
        sub b
        jr c, NoKills           ; bulletX > right side
        
        ld a, b                 ; b = bulletX-invaderX
     add a, 3           ; centering for UFO at end
        ld b, invXspacing
        call divide           ; c=a/b
        ld l, c                 ; save c  ; c=  # of inv in row
        add a, b                ; a+b=remainder
     sub 3
        ;;;;;;;;ld b, a                 ; b= leftover pixels
        ;;;;;;;;ld a, d                 ; d= bulletX    ; subtract extra pixels
        ;;;;;;;;sub b                   ; a= x coordinate of invader
                sub d   
                neg
        
        ld (ExplX), a


        ld a, (invY)
        sub e                   ; e= bulletY

        jr c, NoKills            ; bulletY>invY
        
        ;!!!!!!!!!!!
        ;ld b, a
        ;ld a, invPerCol*invYspacing
        ;sub b
        ;jr c, NoKills                  ; off the bottom
        ;ld a, b
        ;!!!!!!!!!!!

        ; ### Here a kill has occurred ###
        ld b, invYspacing
        call divide           ; c=a/b
        
        add a, b                   ; a+b=remainder
        ld b, a
        ld a, e                    ; e = bulletY
        add a, b                   ; find top of invader
                                   ; a= y coordinate of invader
        dec a                   ;#####
        ld (ExplY), a


        ld b, invPerRow
        ld a, c
        call multiply
                              ; l =  # of inv in row
        add a, l                ; a=invader#
        ;####################################################################
        ;cp (InvThisLevel)       ; check that it doesn't exceed
        push hl
        ld hl, InvThisLevel
        cp (hl)
        pop hl
        ;!!!!!!!!!!!!!!!!!!!!!!!!!!!!
        jr nc, NoKills
        
        ld b, 0
        ld c, a
        ld hl, invExist
        add hl, bc              ; hl = invExist+a
        ld a, (hl)      
        or a                    ; invader alive?
        
        jr z, NoKills
        ld a, (invRows)
        cp 6
        jr z, SkipThisStuff
        ld (hl), 0      ; kill invader
        push de
        ld bc, (ExplXY)
        ld de, invPic
        call Put8x5
        pop de
SkipThisStuff:
        ld b, d                 ; get bullet coords
        ld c, e
        call DrawBullet
        pop hl
        push hl             ; hl = mem addr of bullet X value
        dec hl
        ld (hl), 64             ; remove used bullet

        ld a, (invRows)
        cp 6
        jr nz, skipUFOhelp
         ;;inc a           ; increase a little
         ;;inc a           ; increase a little more
         ;;sla a           ; double the denominater in delay
        ld a, (6+2)*2      ;16
skipUFOhelp:
        ld b, a
        ld a, (invLeft)
        dec a
        ld (invLeft), a

        call divide             ; c=a/b
        inc c
        ld a, c
        ld (invDelay), a        ;invLeft/invRows+1
NoKills:
        ld b, d
        ld c, e                 ; get bullet coords
        pop hl
        push hl
        dec hl                  ; hl = bullet Y
        CALL_(DoShield)

        pop hl
BulletGone:
        inc hl          ; set to next y
        pop bc
        ;djnz pGunLoop
        dec b
        JUMP_NZ(pGunLoop)
        
        ld a, (invLeft) 
        or a
        ret z           ; ###### if z then Level is complete
                        ; z must be set on return
        

; ============= Space Invader Bullets ===============

        ld hl, Bullets          ; (hl)=y, (hl+1)=x, (hl+2)=direction
        ld a, (invRows)         ; 1 bullet for each row
        inc a
BulletLoop:
        push af                 ; a = bullet counter
        ld c, (hl)              ; Y
        inc hl
        ld b, (hl)              ; X
        inc hl
        call DrawBullet       ; erase
        ;CALL_(pause)
        ld a, (hl)              ; a= direction of bullet
        bit 6, c                ; off screen?
        CALL_NZ(invShoot)       ; bc=xy; a=direction
        ld (hl), a              ; # save new direction
        add a, b
        cp 1
        jr nz, ok4
        ld c, 1
ok4:
        cp 126
        jr nz, ok5
        ld c, 1
ok5:    
        ld b, a                 ; b=X
        dec hl
        ld (hl), b              ; # save sew X coord
        dec c
        ld a, c
        jr nz, OnScreen
   ;;???      ld a, 64
        ld c, 64
OnScreen:
        dec hl
        ld (hl), c              ; # save new Y coord
        call DrawBullet
        ;CALL_(pause)
        ;inc hl
        ;inc hl
        ;inc hl
        
        call DetectHit
        jr nz, miss
        ld a, 7
        sub c
        jr c, miss      ; too far up to hit player
        ld a, b
        ld de, (gunXY)
        sub d
        jr c, miss      ; too far left to hit player
        sub 7
        jr nc, miss     ; too far right
        ld a, (PlayerLife)
        or a
        call nz, KillPlayer     ; if not already dead
Miss:
        push hl
        CALL_(DoShield)
        pop hl
        
        inc hl
        inc hl
        inc hl
        pop af
        dec a
        JUMP_NZ(BulletLoop)
        ld a, 1                 ; ###### if z then Level is complete
        or a                    ; ###### but not here
        ret
        
DoShield:                               ; hl = bullet Y to kill bullet
                                        ; if hit shield
                                ; bc = bullet (X,Y)
        ld a, b
        sub 24
        ret c
        cp 104-24               ; right end of last shield
        ret nc
        ;and 31
        bit 4, a                ; >15? (width of shield-1)
        ret nz
        ld a, ShieldAltitude
        sub c
        ret c
        cp ShieldHeight
        ret nc                  ; >4? (height of shield-1)
        push hl                 ;
        push af                 ; save a=line# of shield
        ROM_CALL(FIND_PIXEL)
        ld h, a                 ; save screen bit
        ld a, l
        and 15
        sub 3   
        ld l, a         ; a= byte# from left of screen
        srl a
        srl a           ; /4
        sla a           ; *2    ; 2 byte gap between shields
        sub l
        neg             ; a = l-a
        push bc
        ld c, a
        ld b, ShieldHeight
        call multiply
        pop bc
        ld e, a
        pop af
        add a, e
        ld d, 0
        ld e, a
        ld a, h                 ; restore screen bit
        ld hl, shields
        add hl, de              ; hl = addr of shield byte
        ld d, a
        and (hl)                ; check if piece of shield exists
        jr nz, FoundPiece
        pop hl
        ret
FoundPiece:
        ld a, d
        xor (hl)
        ld (hl), a              ; erase piece
        ROM_CALL(FIND_PIXEL)
        ld de, $FC00
        add hl, de
        xor (hl)
        ld (hl), a              ; toggle screen bit (could be reset if bullet
                                ; is near)
        call DrawBullet
        pop hl                  ;
        ld (hl), 64             ; kill bullet
        ret


invShoot:
        push hl
        ld hl, invExist
        ld a, (InvThisLevel)
        sub invPerRow
        ld d, 0
        ld e, a
        add hl, de

        ld a, r
;        rrca
        and 1
        ld (RandNum), a         ; for choosing search direction

        ld a, r
        ld b, invPerRow
        call divide           ; c=a/b   a+b=remainder
        add a, b                ; random col = r mod invPerRow
        ld d, 0    ;zeroed above
        ld e, a
        add hl, de
        
        ld c, a         ;col
RowLoop:
        ld de, -invPerRow
        ld a, (invRows)
        ld b, a
        ld a, alive
        push hl
FindLoop:
        cp (hl)
        jr z, Found             ; any in this row?
        add hl, de              ; check next row up
        djnz FindLoop           ; if 0 then column empty
        pop hl
        ld a, (RandNum)
        or a
        ld a, c                 ; !!
        jr z, GoRight
        dec c
        dec hl
        or a
        jr nz, RowLoop
        ld c, invPerRow-1       ; off left side; continue at right side
        ld a, (InvThisLevel)
        dec a
        jr Continue
GoRight:
        inc c
        inc hl
        cp invPerRow-1          ; row numbered 0..invPerRow-1
        jr nz, RowLoop
        ld c, 0                 ; off right; continue at left
        ld a, (invThisLevel)
        sub invPerRow
Continue:
        ld hl, invExist
        ld d, 0
        ld e, a
        add hl, de
        jr RowLoop
Found:
        pop de                  ; trash saved hl
                                ; hl = shooting invader + invExist

        ld de, invExist
        or a                            ; clear carry
        sbc hl, de                      ; hl = # of shooting invader
        ld a, l
        ld b, invPerRow
        call divide                   ; c=a/b   a+b=remainder
        ld de, (invXY)
        push bc
        add a, b
        ld b, a
        ld c, invXspacing
        call multiply
        add a, d                           ; a=x loc of inv bullet
        add a, 3                                ; center of invader
        ld d, a

        pop bc
        ld b, invYspacing
        call multiply
        ld b, a
        ld a, e
        sub b
        ld b, d                         ; b=X      <-- coords of new shot
        sub 3                           ; move down a little
        ld c, a                         ; c=Y
        ld de, (gunXY)
        ld a, b
        
        ;!!!!
        
        
        sub 4                   ; center of aa gun 8x8 pic
        sub d                   ; horiz dist between bullet and AA gun
        ld h, -1
        jr nc, Nright
        ld h, 1
Nright:
        jr nc, pos
        neg
pos:
        sla a                   ; a=a*2
        cp c                    ; 2*invX-gunX-vert dist
        jr nc, Nstraight
        ld h, 0
Nstraight:
        ld a, h
        pop hl
        ret



;############################################################################


ShiftLeft:
        ld hl, invX
        dec (hl)
        jr nz, SkipChgRight
        ld a, 1
        ld (invDir), a
        ld a, invYspacing
        ld (DownCount), a   ; prepare to move invaders down 1 row
SkipChgRight:
        ;ld d, 1
        ;ld e, 0              ;d=1 e=0 shift right
        ld de, 256
        CALL_(ShiftStuff)
        call PutShields
        ld hl, $FC00-1
Lshift:
        inc hl
        bit 2, h
        ret z
        sla (hl)
        jr nc, Lshift
        dec hl
        set 0, (hl)
        inc hl
        jr Lshift
        ;;;;;;;;call PutShields       ; done on return

ShiftRight:
        ld a, (invX)
        inc a
        ld (invX), a
        cp 127-(invPerRow-1)*invXspacing+5
        jr nz, SkipChgLeft
        ld a, -1
        ld (invDir), a
        ld a, invYspacing
        ld (DownCount), a   ; prepare to move invaders down 1 row
SkipChgLeft:
        ld d,-1
        ld e, 0                 ;d=-1 e=0 shift left
        CALL_(ShiftStuff)
        call PutShields

        ld hl, $FFFF+1
RShift:
        dec hl
        bit 2, h
        ret z
        srl (hl)
        jr nc, Rshift
        inc hl
        set 7, (hl)
        dec hl
        jr Rshift
        ;;;;;;;;call PutShields       ; done on return

ShiftDown:
        ld a, (invY)
        dec a
        ld (invY), a
        ld d, a
        
        ld a, (invThisLevel)
        ld b, 0
        ld c, a

        ld hl, invExist-1       
        add hl, bc              ; hl = addr of last invader
        ld a, alive
        cpdr                    ; search for lowest invader
        ld bc, -(invExist-1)
        add hl, bc
        ld a, l
        ld b, invPerRow
        call divide           ; c=a/b     ; c = rows left - 1

        ld b, invYspacing
        call multiply         ; a=b*c
        sub d
        neg                     ; a = d-a
        cp (ShieldAltitude-3)+invYspacing
        jr nz, ShieldsRemain
        call PutShields
        ld hl, Shields
        ld (hl), 0
        ld de, Shields+1
        ld bc, (6*ShieldHeight)-1
        ldir                    ; clear shield mem
ShieldsRemain:
        cp (-2)+invYspacing               ; check if invaders have landed
        call z, KillPlayer
        ld de, 1                ; move stuff up
        CALL_(ShiftStuff)
        call PutShields
        ld hl, $FFEF
        ld de, $FFFF
        ld bc, $3F0
        lddr                    ; move down one pixel
        ret
        ;;;;;;;;call PutShields       ; done on return

ShiftStuff:     ; de = shift x, shift y
        
        ld hl, Bullets
        ld b, maxBullets
LoopB:                  ; shift all invader bullets
        push bc
        ld c, (hl)
        inc hl
        ld b, (hl)
        inc hl
        inc hl          ; skip direction byte
        call DrawBullet
        ld a, b
        add a, d
        ld b, a
        ld a, c
        add a, e
        ld c, a
        call DrawBullet
        pop bc
        djnz LoopB

        
        ld hl, pBullets         ; move player bullets
        ld b, pMaxBullets
MoveLoop:
        push bc
        ld c, (hl)
        inc hl
        ld b, (hl)
        inc hl
        call DrawBullet
        ld a, b
        add a, d
        ld b, a
        ld a, c
        add a, e
        ld c, a
        call DrawBullet
        pop bc
        djnz MoveLoop

        
        ld bc, (gunXY)          ;move AAgun
        push de
        ld de, gunPic
        call Put8x5
        pop de
        ld a, b
        add a, d
        ld b, a
        ld a, c
        add a, e
        ld c, a
           push de
        ld de, gunPic
        call Put8x5
           pop de
        ret


invArrive:
        ld bc, (invXY)
        ld de, invPic
        ld h, invPerRow
DrawLoop:        
        call Put8x5
        ld a, b
        add a, invXspacing
        ld b, a
        dec h
        jr nz, DrawLoop
        ld hl, $FC00
        push hl
        ld de, ArriveMem
        ld bc, $10*5
        ldir                    ; copy for use with animation
        pop hl
        ld (hl), 0
        ld de, $FC01
        ld bc, ($10*5)-1
        ldir                    ; erase top of screen
        ld a, (invRows)
        ld c, a
Looperoo2:        
        ld b, invYspacing-5
SpaceLoop:        
        push bc
        call Shifteroo
        ld bc, $2800
        call delay
        pop bc
        djnz SpaceLoop
        
        ld b, 5
        ld hl, ArriveMem+($10*(5-1))
Looperoo:
        push bc
        push hl
        call Shifteroo
        pop hl
        push hl
        ld de, $FC10
        ld bc, $10
        ldir                    ; copy line of screen data
        pop hl
        ld bc, $2800
        call delay
        pop bc
        ld de, -$10
        add hl, de
        djnz Looperoo
        ld hl, ArriveMem+($10*(5-1))
        dec c
        jr nz, Looperoo2
        ret



pic1:
.db 01100110b
.db 00011000b
.db 00111100b
.db 01100110b
.db 00111100b

pic2:
.db 00111000b
.db 00111000b
.db 01111100b
.db 11111110b
.db 11111110b

;Put8x5:                           ; de = imag addr, (b,c) = (x,y)
        push af
        push bc
        push de
        push hl
        ROM_CALL(FIND_PIXEL)
        ld bc, $FC00            ; $FC00 = start video mem
        add hl, bc
        ld (StartPixel), a      ; used to start new line
        ld b, 5                 ; pic height
StartLine:
        push bc                 ; save current line (B)
        push hl                 ; save screen byte pos.
        ld a, (StartPixel)      ; screen pixel number to B
        ld b, a
        ld a, (de)              ; pic byte to C
        ld c, a
        ld a, (hl)              ; screen byte to A
DoLine:
        bit 7, c                ; test graphic bit
        jr z, NoDot             ; add bit to A if set
        xor b
NoDot:
        srl b                   ; next screen bit
        jr nz, NoChange
        ld (hl), a              ; put A to screen
        inc hl                  ; move screen byte right one byte
        ld a, (hl)              ; get screen byte into A
        set 7, b                ; set B to left of new screen byte
NoChange:
        sla c                   ; switch to next graphic bit
        jr nz, DoLine           ; if any more bits left then continue
        ld (hl), a              ; otherwise put A to screen
        pop hl                  ; restore the original screen byte pos.
        ld bc, 16
        add hl, bc              ; move it to the next line
        inc de                  ; next graphic bit
        pop bc                  ; restore line count
        djnz StartLine          ; start new line if not done with graphic
        pop hl
        pop de
        pop bc
        pop af
        ret

;divide:                 ; c=a/b   a+b=remainder
        ld c, 0
DivLoop:
        sub b
        ret m
        inc c
        jr DivLoop

;multiply:               ; a=b*c
        ld a, b
        or a
        ret z
        xor a           ; a=0
MultLoop:
        add a, c
        djnz MultLoop
        ret

;PutShields:
        push af
        push de
        push hl
        
        ld de, shields
        ld hl, $FFF0-(ShieldAltitude*$10)+3
        call PutPiece
        inc hl
        call PutPiece
        inc hl
        inc hl
        inc hl
        call PutPiece
        inc hl
        call PutPiece
        inc hl
        inc hl
        inc hl
        call PutPiece
        inc hl
        call PutPiece
        pop hl
        pop de
        pop af
        ret

;PutPiece:        
        push hl
        ld b, ShieldHeight
PutLoop:
        ld a, (de)
        xor (hl)
        ld (hl), a
        push de
        ld de, $10
        add hl, de
        pop de
        inc de
        djnz PutLoop
        pop hl
        ret

;delay:
        push af
DelayLoop:
        dec bc
        ld a, b
        or c
        jr nz, DelayLoop
        pop af
        ret

;DrawBullet:
        ;ld a, c
        ;cp 64
        ;ret z
        bit 6, c
        jr z, SkipTheDelay
        push bc
        ld bc, 100
        call delay
        pop bc
        ret
SkipTheDelay:
        push hl
        push de
        push bc
        ROM_CALL(FIND_PIXEL)
        ld b, a
        ld de, $FC00-$10
        add hl, de
        ld de, $10

        xor (hl)
        ld (hl), a
        add hl, de
        ld a, b
        xor (hl)
        ld (hl), a
        add hl, de
        ld a, b
        xor (hl)
        ld (hl), a
        sbc hl, de
        ld a, b
        push hl
        rlca
        jr nc, samebyteA
        dec hl
samebyteA:
        xor (hl)
        ld (hl), a
        pop hl
        ld a, b
        rrca
        jr nc, samebyteB
        inc hl
samebyteB:
        xor (hl)
        ld (hl), a
        pop bc
        pop de
        pop hl
        ret


;Dot:
        push hl
        ROM_CALL(FIND_PIXEL)
;ld de, $FC00            ; set to graphics mem before calling dot
        add hl, de
        xor (hl)
        ld (hl), a
        pop hl
        ret

;DetectHit:
        push hl
        ROM_CALL(FIND_PIXEL)
        ld de, $FC00
        add hl, de
        and (hl)                ; if bullet hits something then 
                                ; a pixel is turned off  (xor)
        pop hl
        ret                     ; z = hit ; nz = miss

;move:
        sla b
        sla c
        ld a, b
        add a, h
        ld b, a
        ld a, c
        add a, l
        ld c, a
        ret

;Space:
.db "Space",0
;Invaders:
.db "Invaders",0
:ByDavidLenhart:
.db "by David Lenhart",0
;YouWin:
.db "VICTORY!",0

;RotateUFO:
        ld bc, (invXY)
        ld a, b
        add a, 21
        ld b, a
        ld a, c
        sub 6
        ld c, a
        ld de, $FC00
        ld a, (RotateByte)
        ld l, 2
RotateStart:
        push hl
        ld h, 8*4
        push bc
RotateLoop:
        bit 7, a
        ld l, a
        call nz, dot
        ld a, l
        rlca
        inc b
        dec h
        jr nz, RotateLoop
        pop bc
        rlca
        pop hl
        dec l
        jr nz, RotateStart
        rrca
        ld (RotateByte), a
        ret

;UFO:
.db 00000000b
.db 00001111b
.db 11110000b
.db 00000000b
.db 00000000b
.db 11111111b
.db 11111111b
.db 00000000b
.db 00001111b
.db 11111111b
.db 11111111b
.db 11110000b
.db 01111111b
.db 11111111b
.db 11111111b
.db 11111110b
.db 11111111b
.db 11111111b
.db 11111111b
.db 11111111b
.db 11000011b
.db 11000011b
.db 11000011b
.db 11000011b
.db 11111111b
.db 11111111b
.db 11111111b
.db 11111111b
.db 01111111b
.db 11111111b
.db 11111111b
.db 11111110b
.db 00001111b
.db 11111111b
.db 11111111b
.db 11110000b
.db 00000000b
.db 11111111b
.db 11111111b
.db 00000000b
.db 00000000b
.db 00001111b
.db 11110000b
.db 00000000b

;ScreenOff:
        ld hl, CONTRAST
        ld a, (hl)
        ld (ContrastLev), a
        xor a
        ld (hl), a
        out (2), a
        ret

;ScreenOn:
        ld a, (ContrastLev)
        ld (CONTRAST), a
        out (2), a
        ret

;KillPlayer:        
        xor a
        ld (PlayerLife), a
        ld a, 54
        ld (DestroyTimer), a
        ret

;BigText:        
        
        push hl
        push de
        ld de, $0007
        ld (cursor), de
        ROM_CALL(D_ZT_STR)
        call ScreenOff
        pop hl
        ;ld de, $FC00            ; set to graphics mem before calling dot
        ld c, 7
yloop:
        push bc
xloop:        
        push bc
        call DetectHit
        jr z, skipdot
        push bc
        call move
        call dot
        inc b
        call dot
        inc c
        call dot
        dec b
        call dot
        pop bc
        jr SkipSmooth
skipdot:
        inc c
        call DetectHit
        jr z, SkipSmooth
        push bc
        inc b
        call DetectHit
        jr nz, SkipSmoothR
        dec c
        call DetectHit
        jr z, SkipSmoothR
        call move
        dec b
        inc c
        call dot
        inc b
        inc c
        call dot
SkipSmoothR:
        pop bc
        dec b
        call DetectHit
        jr nz, SkipSmoothL
        dec c
        call DetectHit
        jr z, SkipSmoothL
        inc c
        call move
        inc b
        call dot
        dec c
        inc b
        call dot
SkipSmoothL:
SkipSmooth:
        pop bc
        djnz xloop
        pop bc
        dec c
        jr nz, yloop
        ld hl, $FFFF
        ld (hl), 0
        ld de, $FFFE
        ld bc, ($10*8)-1
        lddr                    ; erase text at bottom
        call ScreenOn
        pop hl
        ret

;DrawRow:
        ld a, (X)
        ld b, a
        ld a, (invY)
        sub 8
        ld c, a
        ld de, invPic
ScootLoop:
        call Put8x5
        ld a, b
        sub invXspacing
        ld b, a
        cp 32
        jr nc, ScootLoop
        ret

;PutUFO:
        ld a, 11000011b
        ld (RotateByte), a
        ld hl, UFO
        ld a, 11
it:
        ld bc, 4
        ldir
        push hl
        ex de, hl
        ld de, $10-4
        add hl, de
        ex de, hl
        pop hl
        dec a
        jr nz, it
        ret

;Shifteroo:
        ld hl, $FFEF-$100
        ld de, $FFFF-$100
        ld bc, $3F0-$100
        lddr                    ; move down one pixel
        ret

invUnload:
        call GET_KEY
        ld de, $FF00
        call PutUFO
        ld hl, ($100*(0-21))+(15-5)+6
        ld (invXY), hl
        ld a, (invRows)
RowStart:
        push af
        ld a, 32
        ld (X), a
Continue_:
           call GET_KEY         ;recently added
           cp 5                 ;exclude arrow keys & 0
           jr c, noExit_
           pop af               ;lower stack
           ret                   ;quick exit
noExit_:
        call RotateUFO
        call DrawRow
        ld bc, $2000
        call delay
        call DrawRow
        ld a, (X)
        inc a
        ld (X), a
        cp 32+(invXspacing*(invPerRow-1))
        jr nz, Continue_
        call DrawRow
        
        ld b, invYspacing
MoveSaucer:        
        push bc
        CALL_(SaucerUp)
        pop bc
        djnz MoveSaucer
        pop af  ;invrowcount
        dec a
        jr nz, RowStart

        ld a, (invY)
ScootDown:        
        push af
        CALL_(SaucerUp)
        dec (hl)                ; dec (invY)
        ld hl, $FFEF
        ld de, $FFFF
        ld bc, $3F0
        lddr                    ; move down one pixel
        pop af
        dec a
        jr nz, ScootDown
        ret

SaucerUp:
        call RotateUFO
        ld a, 64-1
        ld de, $FC00
        ld hl, $FC10
ShiftSaucer:
        ld bc, 4
        ldir
        ld bc, $10-4
        add hl, bc
        ex de, hl
        add hl, bc
        ex de, hl
        dec a
        jr nz, ShiftSaucer
        ld bc, $3000
        call delay
        ld hl, invY
        inc (hl)
        ret


UFOarrive:

        ld hl, ArriveMem        
        ld (hl), 0
        ld de, ArriveMem+1
        ld bc, ($10*11)-1
        ldir                     ; clear mem

        ld de, ArriveMem+6
        call PutUFO            ; put UFO in mem for animation

        ld hl, ArriveMem
        ld b, 11
UFOloop:
        push bc
        push hl
        ld a, 63-6+6
        add a, b
        ld l, a
        ld h, 48-21
        ld (invXY), hl
        ld a, b
        cp 6
        call c, RotateUFO
        call Shifteroo
        pop hl
        ld de, $FC10
        ld bc, $10
        ldir
        ld bc, $6000
        call delay
        pop bc
        djnz UFOloop
        ld hl, invExist+invPerRow
        ld (hl), dead
        ld de, invExist+invPerRow+1
        ld bc, invPerRow-1+(5*invPerRow)
        ldir
        ld hl, invExist
        ld (hl), dead
        ld de, invExist+1
        ld bc, invMax-1
        ldir
        ld a, alive
        ld hl, invExist+invPerRow+2
        ld (hl), a
        inc hl
        ld (hl), a
        ld a, 72                ; may increase up to 79 w/o decrease in speed
        ld (invLeft), a         ; hit points for end guy
        ret


Winner:
        ld d, 20
Flash:        
        call ScreenOff
        ld bc, $1800
        call delay
        call ScreenOn
        ld bc, $3000
        call delay
        dec d
        jr nz, Flash

        ROM_CALL(ClearLCD)
        ld hl, YouWin
        ld b, (6*8)-1
        ld de, ((127-(12*8))/2+2)*$100+$2C
        call BigText
        
        ld de, invPic
        ld bc, $0105
        call Put8x5
        ld hl, Zero
        ld b, (6*2)-1
        ld de, (42*$100)+28
        call BigText

        ld de, gunPic
        ld bc, $0105
        call Put8x5
        ld b, (6*2)-1
        ld de, (55*$100)+6
        call BigText
        
        ld bc, $0303
        call DrawBullet
        ld b, (6*1)-1
        ld de, (59*$100)+17
        call BigText

        ld bc, $0303
        call DrawBullet
        ld b, (6*1)-1
        ld de, (62*$100)+26
        call BigText
WaitExit:
        call GET_KEY
        cp $37
        jr nz, WaitExit
        ret

;#include "debug"

.end

;00000000000011111111000000000000
;00000000111111111111111100000000
;00001111111111111111111111110000
;01111111111111111111111111111110
;11111111111111111111111111111111
;11000011110000111100001111000011
;11111111111111111111111111111111
;01111111111111111111111111111110
;00001111111111111111111111110000
;00000000111111111111111100000000
;00000000000011111111000000000000

