/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Calendar;
import javax.swing.JPanel;
import javax.swing.Timer;

public class AnalogClock
extends JPanel
implements ActionListener {
    private Timer timer = new Timer(1000, this);
    private URL url;
    private Image face;
    private int second;
    private int minute;
    private int hour;
    private double secondAngle;
    private double minuteAngle;
    private double hourAngle;
    private int secondLength;
    private int minuteLength;
    private int hourLength;
    private Point origin;

    public AnalogClock(int n) {
        this.secondLength = n;
        this.minuteLength = n;
        this.hourLength = (int)((double)n * 0.75);
        this.origin = new Point(n, n);
        this.timer.start();
    }

    public AnalogClock(int n, Image image) {
        this.secondLength = n;
        this.minuteLength = n;
        this.hourLength = (int)((double)n * 0.75);
        this.face = image;
        this.origin = new Point(this.face.getWidth(null) / 2, this.face.getHeight(null) / 2);
        this.timer.start();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = null;
        dimension = this.face != null ? new Dimension(this.face.getWidth(null), this.face.getHeight(null)) : new Dimension(this.minuteLength * 2, this.minuteLength * 2);
        return dimension;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.getTime();
        this.hourAngle = 1.5707963267948966 - (double)this.hour * 0.5235987755982988 - (double)this.minute * (Math.PI / 360);
        this.minuteAngle = 1.5707963267948966 - (double)this.minute * 0.10471975511965977;
        this.secondAngle = 1.5707963267948966 - (double)this.second * 0.10471975511965977;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.drawImage(this.face, 0, 0, null);
        Graphics2D graphics2D = (Graphics2D)graphics;
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHints(renderingHints);
        graphics2D.setStroke(new BasicStroke(4.0f));
        graphics2D.drawLine(this.origin.x, this.origin.y, (int)((double)this.origin.x + Math.cos(this.minuteAngle) * (double)this.minuteLength), (int)((double)this.origin.y - Math.sin(this.minuteAngle) * (double)this.minuteLength));
        graphics2D.drawLine(this.origin.x, this.origin.y, (int)((double)this.origin.x + Math.cos(this.hourAngle) * (double)this.hourLength), (int)((double)this.origin.y - Math.sin(this.hourAngle) * (double)this.hourLength));
        graphics2D.setStroke(new BasicStroke(1.0f));
        graphics2D.setColor(Color.RED);
        graphics2D.drawLine(this.origin.x, this.origin.y, (int)((double)this.origin.x + Math.cos(this.secondAngle) * (double)this.secondLength), (int)((double)this.origin.y - Math.sin(this.secondAngle) * (double)this.secondLength));
    }

    private void getTime() {
        Calendar calendar = Calendar.getInstance();
        this.hour = calendar.get(10);
        this.minute = calendar.get(12);
        this.second = calendar.get(13);
    }
}

