;Game Genie Decoder Program
;-------------------
;Binary created using DAsm 2.12 running on an Amiga.

   PROCESSOR   6502

   ORG   $C000    ;16Kb PRG-ROM, 8Kb CHR-ROM

   dc.b "Game Genie Decoder, 1998 Chris Covell (ccovell@direct.ca)"

Reset_Routine  SUBROUTINE
   cld         ;Clear decimal flag
   sei         ;Disable interrupts
.WaitV   lda $2002
   bpl .WaitV     ;Wait for vertical blanking interval
   ldx #$00
   stx $2000
   stx $2001      ;Screen display off, amongst other things
   stx $2005
   stx $2005      ;Try to clear that damn scroll register!!
   dex
   txs         ;Top of stack at $1FF

;Clear (most of) the NES' WRAM. This routine is ripped from "Duck Hunt" - I should probably clear all
;$800 bytes.
   ldy #$06    ;To clear 7 x $100 bytes, from $000 to $6FF?
   sty $01        ;Store count value in $01
   ldy #$00
   sty $00
   lda #$00

.Clear   sta ($00),y    ;Clear $100 bytes
   dey
   bne .Clear

   dec $01        ;Decrement "banks" left counter
   bpl .Clear     ;Do next if >= 0


;********** Initialize Name Table ********

   lda   #$20
   sta   $2006
   lda   #$00
   sta   $2006

   ldx   #$F0
   ldy   #$4
.ClearNameTable sta $2007
   dex
   bne   .ClearNameTable
   dey
   bne   .ClearNameTable
;****************************************

;********* Initialize Palette to specified colour ********

   ldx   #$3F
   stx   $2006
   ldx   #$00
   stx   $2006

   ldx   #$0D     ;Colour Value (Black)
   ldy   #$20     ;Clear BG & Sprite palettes.
.InitPal stx $2007
   dey
   bne   .InitPal
;*********************************************************

   ldx   #$3F
   stx   $2006
   ldx   #$00
   stx   $2006

   ldx   #$00     ;Palette 0
   ldy   #$20
.SetPal  lda   .CMAP,X
   sta   $2007
   dey
   inx
   bne .SetPal

;************************************************

;********** Set up Attribute Table

   ldx   #$23
   stx   $2006
   ldx   #$C0
   stx   $2006

   ldx   #$0   ;Beginning of Attribute Map
   ldy   #$40  ;Fill out Table

.SetAtt  lda   .AttrMap,X
   sta   $2007
   inx
   dey
   bne .SetAtt

;********** Set up Name Table

   ldx   #$20
   stx   $2006
   ldx   #$40
   stx   $2006

   ldx   #$0   ;Beginning of Map
   ldy   #$D0   ;208 Tiles

.SetMap1  lda   .TitleMap1,X
   lsr
   lsr
   lsr
   lsr
   sta   $2007
   lda   .TitleMap1,X
   and   #$F
   sta   $2007
   inx
   dey
   bne .SetMap1

   ldx   #$0
   ldy   #$E0  ;224 Characters
.SetMap2 lda   .WinMap1,X
   sta   $2007
   inx
   dey
   bne .SetMap2

   ldx   #$0
   ldy   #$E0  ;224 Characters
.SetMap3 lda   .WinMap2,X
   sta   $2007
   inx
   dey
   bne .SetMap3

;*************************************

;***** Set up Sprites **************************

   ldx   #$0
   stx   $2003

   ldx   #$47     ;y-position
   stx   $2004
   ldx   #$24
   stx   $2004
   ldx   #$00
   stx   $2004
   ldx   #$10     ;x-position
   stx   $2004

   ldx   #$47
   stx   $2004
   ldx   #$25
   stx   $2004
   ldx   #$00
   stx   $2004
   ldx   #$18
   stx   $2004

   ldx   #$A3
   stx   $2004
   ldx   #$26
   stx   $12
   stx   $2004
   ldx   #$00
   stx   $2004
   ldx   #$18
   stx   $2004

;***********************************************

;Enable vblank interrupts, etc.
   lda   #%10000000
   sta   $2000
   lda   #%00011110    ;Screen on, sprites on, show leftmost 8 pixels, colour
   sta   $2001
   cli            ;Enable interrupts(?)

   ldx   #0
   stx   $11
   ldx   #0
   stx   $10

;Now just loop forever?
.Loop jmp .Loop

.CMAP dc.b #$0D,#$2C,#$3C,#$30,#$0D,#$2C,#$0D,#$0D,#$0D,#$06,#$17,#$28,#$0D,#$0D,#$0D,#$0D
      dc.b #$0D,#$18,#$27,#$30,#$0D,#$0D,#$0D,#$0D,#$0D,#$0D,#$0D,#$0D,#$0D,#$0D,#$0D,#$0D

.AttrMap dc.b #$55,#$55,#$55,#$55,#$55,#$55,#$55,#$55
         dc.b #$05,#$05,#$05,#$05,#$05,#$05,#$05,#$05
         dc.b #$00,#$00,#$00,#$00,#$00,#$00,#$00,#$00
         dc.b #$00,#$00,#$00,#$00,#$00,#$00,#$00,#$00
         dc.b #$2A,#$0A,#$0A,#$0A,#$0A,#$0A,#$0A,#$8A
         dc.b #$22,#$00,#$00,#$00,#$00,#$00,#$00,#$88
         dc.b #$22,#$00,#$00,#$00,#$00,#$00,#$00,#$88
         dc.b #$0A,#$0A,#$0A,#$0A,#$0A,#$0A,#$0A,#$0A

.TitleMap1 dc.b #$02,#$CC,#$00,#$00,#$00,#$00,#$00,#$00,#$2C,#$C0,#$00,#$00,#$00,#$80,#$00,#$00
           dc.b #$05,#$23,#$2C,#$C5,#$D9,#$62,#$CE,#$40,#$52,#$32,#$CE,#$4D,#$C6,#$A2,#$CE,#$40
           dc.b #$06,#$02,#$A0,#$05,#$55,#$AA,#$04,#$00,#$60,#$2A,#$04,#$05,#$0A,#$AA,#$04,#$00
           dc.b #$00,#$C4,#$0C,#$04,#$44,#$80,#$CC,#$40,#$0C,#$40,#$CC,#$44,#$08,#$80,#$CC,#$40
           dc.b #$00,#$00,#$00,#$00,#$00,#$00,#$00,#$00,#$00,#$00,#$00,#$00,#$00,#$00,#$00,#$00
           dc.b #$0A,#$00,#$8D,#$E0,#$8D,#$60,#$09,#$60,#$AC,#$E0,#$E4,#$E4,#$8D,#$00,#$E4,#$E4
           dc.b #$05,#$50,#$07,#$10,#$07,#$90,#$A0,#$05,#$02,#$40,#$06,#$40,#$05,#$00,#$A0,#$A0
           dc.b #$AC,#$E0,#$05,#$20,#$05,#$00,#$81,#$24,#$24,#$20,#$24,#$60,#$05,#$20,#$A0,#$A0
           dc.b #$C4,#$C4,#$8C,#$C0,#$8C,#$00,#$08,#$40,#$8C,#$C0,#$C4,#$C4,#$8C,#$C0,#$0C,#$40
           dc.b #$09,#$C5,#$8D,#$A4,#$0E,#$40,#$2C,#$70,#$AE,#$E0,#$E4,#$E4,#$E4,#$E4,#$E0,#$E4
           dc.b #$A0,#$31,#$07,#$40,#$0A,#$00,#$87,#$10,#$0A,#$00,#$81,#$90,#$06,#$40,#$A6,#$A0
           dc.b #$81,#$05,#$05,#$60,#$0A,#$00,#$20,#$E0,#$0A,#$00,#$06,#$40,#$0A,#$00,#$A0,#$E0
           dc.b #$08,#$C0,#$8C,#$84,#$0C,#$40,#$0C,#$40,#$0C,#$40,#$08,#$00,#$0C,#$40,#$C4,#$80


.WinMap1   dc.b "GAME GENIE DECODER PROGRAM [1998"
           dc.b " BY CHRIS C.  CCOVELL@DIRECT.CA "
           dc.b " \____________________________] "
           dc.b " ^\________]\________________]^ "
           dc.b " ^^  CODE  ^^                ^^ "
           dc.b " ^^        ^^ VALUE  COMPARE ^^ "
           dc.b " ^`________a^  b             ^^ "
.WinMap2   dc.b " ^\_________a                ^^ "
           dc.b " ^^   CPU     ROM    .NES    ^^ "
           dc.b " ^^ ADDRESS ADDRESS ADDRESS  ^^ "
           dc.b " ^^  b       b       b       ^^ "
           dc.b " ^^                          ^^ "
           dc.b " ^`__________________________a^ "
           dc.b " `____________________________a "


Change_Palette SUBROUTINE

   ldx   #$7   ;Is it at the end of the palette?
   cpx   $11
   bne   .IncPal
   ldx   #0
   jmp   .WritePal
.IncPal   ldx   $11
   inx

.WritePal
   ldy   #$3F
   sty   $2006
   ldy   #$05
   sty   $2006
   ldy   .CycleMap,X
   sty   $2007
   stx   $11
   rts

.CycleMap dc.b #$2C,#$2B,#$28,#$27,#$25,#$24,#$2C,#$21

NMI_Routine SUBROUTINE

   inc   $10
   ldx   #5          ;X/60 seconds
   cpx   $10         ;Store Vblanks in $10
   bpl   .NoChange
   jsr   Change_Palette
   lda   #$9
   sta   $2003
   ldx   #$29
   cpx   $12
   bne   .SpinStar
   ldx   #$25
   stx   $12
.SpinStar ldx  $12
   inx
   stx   $12
   stx   $2004
   ldx   #0
   stx   $10
.NoChange

;First, save the registers
   php
   pha
   txa
   pha
   tya
   pha

   ldx   $00      ;Get previous button status byte
   stx   $01      ;Put it in $01

;Controller read routine, by Kevin Horton.

;Returns following bits in A:
; Bit    Button
; ---    ------
;  0     Right
;  1     Left
;  2     Down
;  3     Up
;  4     Start
;  5     Select
;  6     B
;  7     A

   LDY   #$08     ;Number of iterations
   LDX   #$01
   STX   $4016    ;store 1 out the strobe
   DEX
   STX   $4016    ;store 0 out the strobe
.ReadBit
   LDA   $4016    ;read the button
   ROR         ;transfer it to the carry flag
   TXA
   ROL
   TAX         ;rotate X left, storing the bit into the lowest pos.
   DEY
   BNE   .ReadBit ;loop 8 times for all 8 buttons
;  RTS         ;return acc with status of all 8 buttons

;Now we compare the current and previous button values.
;is pressed, *AND* that button was *NOT* pressed last time.
;To do this:
; get the current button status.
; Logical AND with %11011111 giving "CBS", to see if buttons pressed. If not,
;  nothing to do.
; Now we know that at least one of A, B is pressed.
; get the previous button status.
; NOT this previous status, giving "NPBS"
; Logical AND "NPBS" with "CBS".
; Then bits 6 & 7 are set iff the button is pressed now, but was not pressed last frame. So take
;  action based on this.

   and   #%11111111     ;Only interested in A & B at the moment
   sta   $00      ;Use location 0 for storing current controller button data

;Next inst unnecessary since last inst was sta $00
;  lda   $00      ;Get current button status
   beq   .DoLittle  ;If neither button pressed

   lda   $01      ;Get previous button status
   eor   #$FF     ;NOT it
   and   $00      ;AND this with current status
   beq   .DoLittle  ;If no change from last time, do nothing

;Now we can see what action to take.
;If A pressed, Input 1 code letter.
;If B pressed, Delete 1 code letter.
;If Select pressed, reset CPU.
;If Start pressed, decode code.
;If Up pressed, move cursor up.
;If Down pressed, move cursor down.
;If Left pressed, move cursor left.
;If Right pressed, move cursor right.

   rol         ;So button A status in carry
   bcc   .NotA

;Input 1 code letter

   pha
   ldx   $20   ;Get current position
   lda   .GGtable,X
   ldx   $21   ;Get code position
   sta   $30,X
   jsr   DrawChar
   ldx   #5
   cpx   $21
   bne   .Test7
   lda   $32      ;Test if 6-letter or 8-letter code.
   and   #%1000
   beq   .NoAdvance
.Test7   ldx #7
   cpx   $21
   beq   .NoAdvance
   inc   $21
.NoAdvance pla

.NotA rol         ;So button B status in carry
   bcc   .NotB

;Delete 1 code letter

   pha
   ldx   $21      ;Get current position
   lda   #$0
   sta   $30,X    ;Clear code letter in RAM
   ldx   $21
   beq   .NoDecrease
   dec   $21
   jsr   ClearChar
.NoDecrease pla

   jmp .NotB

.DoLittle   jmp .DoNothing

.NotB rol
   bcc   .NotSelect

   jmp Reset_Routine    ;Reset CPU

.NotSelect rol            ;So Start button status in carry
   bcc   .NotStart

;Decode GG code
   ;WHATEVER

   ldx   #$4         ;Should be at least 5 chars long...
   cpx   $21
   bpl   .NotStart
   jsr   Decode

.NotStart rol     ;So Up status in carry
   bcc   .NotUp

;Move cursor up

   jsr   ChangeCursorRow

.NotUp rol        ;So Down status in carry
   bcc   .NotDown

;Move cursor down

   jsr   ChangeCursorRow

.NotDown rol      ;So Left status in carry
   bcc   .NotLeft

;Move cursor left

   ldx   #$8
   cpx   $20
   bne   .TestA
   ldx   #$10
   stx   $20
   jmp   .DecreaseCursor
.TestA   ldx   #$0
   cpx   $20
   bne   .DecreaseCursor
   ldx   #$8
   stx   $20
.DecreaseCursor dec $20

.NotLeft rol      ;So Right status in carry
   bcc   .UpdateSprites

;Move cursor right

   ldx   #$7
   cpx   $20
   bne   .TestN
   ldx   #$FF
   stx   $20
   jmp   .AdvanceCursor
.TestN   ldx   #$F
   cpx   $20      ;See where cursor is.
   bne   .AdvanceCursor
   ldx   #$7
   stx   $20
.AdvanceCursor inc $20

.UpdateSprites
   ldx   #$00
   stx   $2003       ;Point to Sprite 0's Y-pos
   lda   $20
   and   #8          ;Is it in the upper Row?
   beq   .ItsUpper
   lda   #$20
.ItsUpper   clc
   adc   #$48        ;Add 48 to that
   sta   $2004       ;Store in Y-pos
   ldx   #$04
   stx   $2003
   sta   $2004       ;Store in Y-pos of Sprite 1
   ldx   #$03
   stx   $2003
   lda   $20
   and   #7          ;Check for x-value now.
   tax
   lda   .CursorTable,X
   sta   $2004       ;Store in X-pos of Sprite 0
   clc
   adc   #$8         ;Add 8 to X-pos
   ldx   #$07
   stx   $2003
   sta   $2004       ;Store in X-pos of Sprite 1

   ldx   #$0B        ;X-pos of Sprite 3
   stx   $2003
   ldx   $21         ;# of times to add 8
   lda   #$18        ;Initial X-pos
.MoveStar   clc
   adc   #$8
   dex
   bne   .MoveStar
   sta   $2004       ;Save Star position in VRAM


.DoNothing        ;Restore registers and exit.
   ldx   #$0
   stx   $2005
   stx   $2005

   pla
   tay
   pla
   tax
   pla
   plp

   rti

.CursorTable dc.b #$10,#$30,#$50,#$70,#$90,#$B0,#$D0,#$F0
.GGtable dc.b #$0,#$8,#$1,#$9,#$2,#$A,#$3,#$B,#$4,#$C,#$5,#$D,#$6,#$E,#$7,#$F

DrawChar SUBROUTINE
   lda   #$22     ;Point to VRAM
   sta   $2006
   lda   #$83
   clc
   adc   $21
   sta   $2006
   lda   $20
   ora   #$10   ;Increase to 2nd Row
   sta   $2007
   rts

ClearChar SUBROUTINE
   lda   #$22
   sta   $2006
   lda   #$83
   clc
   adc   $21
   sta   $2006
   lda   #$0
   sta   $2007
   sta   $2007
   rts

ChangeCursorRow SUBROUTINE
   pha
   lda   $20      ;See where cursor is.
   and   #%1000   ;See if in top or bottom row.
   bne   .IsBottomRow
   lda   $20
   clc
   adc   #$10
   sta   $20
.IsBottomRow lda $20
   sec
   sbc   #$8
   sta   $20
   pla
   rts

Decode SUBROUTINE

;Decode Address
   lda   $34      ;MNO
   and   #7
   sta   $43      ;Low Address Byte Low Nybble
   lda   $33      ;L
   and   #8
   ora   $43
   sta   $43      ;Add to $43
   lda   $32      ;IJK
   and   #7
   sta   $42      ;Low Address High Nybble
   lda   $31      ;H
   and   #8
   ora   $42
   sta   $42      ;Add to $42
   lda   $35      ;EFG
   and   #7
   sta   $41      ;High Address Low Nybble
   lda   $34      ;D
   and   #8
   ora   $41
   sta   $41      ;Add to $41
   lda   $33      ;ABC
   and   #7
   sta   $40

;Decode Value
   lda   $30      ;678
   and   #7
   sta   $45      ;Low Value Nybble
   lda   $31      ;234
   and   #7
   sta   $44      ;High Value Nybble
   lda   $30      ;1
   and   #8
   ora   $44
   sta   $44

   lda   $32
   and   #8
   beq   .6Character
   lda   $37      ;5
   and   #8
   ora   $45
   sta   $45
   lda   $36      ;^&*
   and   #7
   sta   $47
   lda   $35      ;%
   and   #8
   ora   $47
   sta   $47
   lda   $37      ;@#$
   and   #7
   sta   $46
   lda   $36      ;!
   and   #8
   ora   $46
   sta   $46
   jmp   .8Character

.6Character

      lda   $35      ;5
   and   #8
   ora   $45
   sta   $45

.8Character
   jsr   DisplayValues
   rts

DisplayValues SUBROUTINE
   ldx   #$23     ;CPU Address
   stx   $2006
   ldx   #$26
   stx   $2006
   lda   $40
   clc
   adc   #$38
   sta   $2007
   lda   $41
   ora   #$30
   sta   $2007
   lda   $42
   ora   #$30
   sta   $2007
   lda   $43
   ora   #$30
   sta   $2007

   ldx   #$23     ;ROM Address
   stx   $2006
   ldx   #$2E
   stx   $2006
   lda   $40
   ora   #$30
   sta   $2007
   lda   $41
   ora   #$30
   sta   $2007
   lda   $42
   ora   #$30
   sta   $2007
   lda   $43
   ora   #$30
   sta   $2007

   ldx   #$F
   cpx   $42
   bne   .ItsOK
   ldx   #$0
   stx   $42
   ldx   #$F
   cpx   $41
   bne   .ItsBad
   ldx   #$0
   stx   $41
   inc   $40

   jmp .ItsGood         ;GRRR This fucking sucks!!!
.ItsOK inc $42
   jmp .ItsGood
.ItsBad inc $41
.ItsGood ldx   #$23
   stx   $2006
   ldx   #$36
   stx   $2006
   lda   $40
   ora   #$30
   sta   $2007
   lda   $41
   ora   #$30
   sta   $2007
   lda   $42
   ora   #$30
   sta   $2007
   lda   $43
   ora   #$30
   sta   $2007

   ldx   #$22
   stx   $2006
   ldx   #$B0
   stx   $2006
   lda   $44
   ora   #$30
   sta   $2007
   lda   $45
   ora   #$30
   sta   $2007

   ldx   #$22
   stx   $2006
   ldx   #$B7
   stx   $2006
   lda   $32
   and   #$8
   beq   .NoComp
   ldx   #$62     ;"$"
   stx   $2007
   lda   $46
   ora   #$30
   sta   $2007
   lda   $47
   ora   #$30
   sta   $2007
   jmp   .Comp
.NoComp  ldx   #$0
   stx   $2007
   stx   $2007
   stx   $2007
.Comp

   rts

IRQ_Routine       ;Dummy label
   rti

;That's all the code. Now we just need to set the vector table approriately.

   ORG   $FFFA,0
   dc.w  NMI_Routine
   dc.w  Reset_Routine
   dc.w  IRQ_Routine    ;Not used, just points to RTI


;The end.
